/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.CoreEntityMention;
import edu.stanford.nlp.pipeline.CoreQuote;
import edu.stanford.nlp.pipeline.CoreSentence;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CoreDocument {
    protected Annotation annotationDocument;
    private List<CoreEntityMention> entityMentions;
    private List<CoreQuote> quotes;
    private List<CoreSentence> sentences;

    public CoreDocument(String documentText) {
        this.annotationDocument = new Annotation(documentText);
    }

    public CoreDocument(Annotation annotation) {
        this.annotationDocument = annotation;
        this.wrapAnnotations();
    }

    public void wrapAnnotations() {
        if (this.annotationDocument.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            this.wrapSentences();
            if (!this.sentences.isEmpty() && this.sentences.get(0).entityMentions() != null) {
                this.buildDocumentEntityMentionsList();
            }
            if (QuoteAnnotator.gatherQuotes(this.annotationDocument) != null) {
                this.buildDocumentQuotesList();
            }
        }
    }

    private void wrapSentences() {
        this.sentences = ((List)this.annotationDocument.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(coreMapSentence -> new CoreSentence(this, (CoreMap)coreMapSentence)).collect(Collectors.toList());
        this.sentences.forEach(CoreSentence::wrapEntityMentions);
    }

    private void buildDocumentEntityMentionsList() {
        this.entityMentions = this.sentences.stream().flatMap(sentence -> sentence.entityMentions().stream()).collect(Collectors.toList());
    }

    private void buildDocumentQuotesList() {
        this.quotes = QuoteAnnotator.gatherQuotes(this.annotationDocument).stream().map(coreMapQuote -> new CoreQuote(this, (CoreMap)coreMapQuote)).collect(Collectors.toList());
    }

    public Annotation annotation() {
        return this.annotationDocument;
    }

    public String docID() {
        return (String)this.annotationDocument.get(CoreAnnotations.DocIDAnnotation.class);
    }

    public String docDate() {
        return (String)this.annotationDocument.get(CoreAnnotations.DocDateAnnotation.class);
    }

    public String text() {
        return (String)this.annotationDocument.get(CoreAnnotations.TextAnnotation.class);
    }

    public List<CoreLabel> tokens() {
        return (List)this.annotationDocument.get(CoreAnnotations.TokensAnnotation.class);
    }

    public List<CoreSentence> sentences() {
        return this.sentences;
    }

    public List<CoreEntityMention> entityMentions() {
        return this.entityMentions;
    }

    public Map<Integer, CorefChain> corefChains() {
        return (Map)this.annotationDocument.get(CorefCoreAnnotations.CorefChainAnnotation.class);
    }

    public List<CoreQuote> quotes() {
        return this.quotes;
    }

    public String toString() {
        return this.annotation().toString();
    }
}

