/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.parser.lexparser.TreeBinarizer;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ReflectionLoading;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class BinarizerAnnotator
implements Annotator {
    private static final String DEFAULT_TLPP_CLASS = "edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams";
    private final TreeBinarizer binarizer;
    private final String tlppClass;

    public BinarizerAnnotator(String annotatorName, Properties props) {
        this.tlppClass = props.getProperty(annotatorName + ".tlppClass", DEFAULT_TLPP_CLASS);
        TreebankLangParserParams tlpp = (TreebankLangParserParams)ReflectionLoading.loadByReflection(this.tlppClass, new Object[0]);
        this.binarizer = TreeBinarizer.simpleTreeBinarizer(tlpp.headFinder(), tlpp.treebankLanguagePack());
    }

    public String signature(String annotatorName, Properties props) {
        return this.tlppClass;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                this.doOneSentence(sentence);
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private void doOneSentence(CoreMap sentence) {
        Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
        Tree binarized = BinarizerAnnotator.isBinarized(tree) ? tree : this.binarizer.transformTree(tree);
        Trees.convertToCoreLabels(binarized);
        sentence.set(TreeCoreAnnotations.BinarizedTreeAnnotation.class, binarized);
    }

    private static boolean isBinarized(Tree tree) {
        if (tree.isLeaf()) {
            return true;
        }
        if (tree.children().length > 2) {
            return false;
        }
        for (Tree child : tree.children()) {
            if (BinarizerAnnotator.isBinarized(child)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, TreeCoreAnnotations.TreeAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(TreeCoreAnnotations.BinarizedTreeAnnotation.class);
    }
}

