/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.neural;

import edu.stanford.nlp.neural.SimpleTensor;
import edu.stanford.nlp.parser.dvparser.DVModel;
import edu.stanford.nlp.parser.dvparser.DVModelReranker;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.sentiment.RNNOptions;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TwoDimensionalMap;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Function;
import org.ejml.simple.SimpleMatrix;

public class ConvertModels {
    public static <K1, K2, V, V2> TwoDimensionalMap<K1, K2, V2> transform2DMap(TwoDimensionalMap<K1, K2, V> in, Function<V, V2> function) {
        TwoDimensionalMap<K1, K2, V2> out2 = TwoDimensionalMap.treeMap();
        out2.addAll(in, function);
        return out2;
    }

    public static List<List<Double>> fromMatrix(SimpleMatrix in) {
        ArrayList<List<Double>> out2 = new ArrayList<List<Double>>();
        for (int i = 0; i < in.numRows(); ++i) {
            out2.add(new ArrayList());
            for (int j = 0; j < in.numCols(); ++j) {
                ((List)out2.get(i)).add(in.get(i, j));
            }
        }
        return out2;
    }

    public static List<List<List<Double>>> fromTensor(SimpleTensor in) {
        ArrayList<List<List<Double>>> out2 = new ArrayList<List<List<Double>>>();
        for (int i = 0; i < in.numSlices(); ++i) {
            out2.add(ConvertModels.fromMatrix(in.getSlice(i)));
        }
        return out2;
    }

    public static SimpleMatrix toMatrix(List<List<Double>> in) {
        if (in.size() == 0) {
            throw new IllegalArgumentException("Input array with 0 rows");
        }
        if (in.get(0).size() == 0) {
            throw new IllegalArgumentException("Input array with 0 columns");
        }
        for (int i = 1; i < in.size(); ++i) {
            if (in.get(i).size() == in.get(0).size()) continue;
            throw new IllegalArgumentException("Input array with uneven columns");
        }
        SimpleMatrix out2 = new SimpleMatrix(in.size(), in.get(0).size());
        for (int i = 0; i < in.size(); ++i) {
            List<Double> row = in.get(i);
            for (int j = 0; j < row.size(); ++j) {
                out2.set(i, j, row.get(j).doubleValue());
            }
        }
        return out2;
    }

    public static SimpleTensor toTensor(List<List<List<Double>>> in) {
        int numSlices = in.size();
        SimpleMatrix[] slices = new SimpleMatrix[numSlices];
        for (int i = 0; i < numSlices; ++i) {
            slices[i] = ConvertModels.toMatrix(in.get(i));
        }
        return new SimpleTensor(slices);
    }

    public static <K, V, V2> Map<K, V2> transformMap(Map<K, V> in, Function<V, V2> function) {
        TreeMap<K, V2> transformed = Generics.newTreeMap();
        for (Map.Entry<K, V> entry : in.entrySet()) {
            transformed.put(entry.getKey(), function.apply(entry.getValue()));
        }
        return transformed;
    }

    public static void writeSentiment(SentimentModel model, ObjectOutputStream out2) throws IOException {
        Function<SimpleMatrix, List> f = x -> ConvertModels.fromMatrix(x);
        out2.writeObject(ConvertModels.transform2DMap(model.binaryTransform, f));
        out2.writeObject(ConvertModels.transform2DMap(model.binaryTensors, x -> ConvertModels.fromTensor(x)));
        out2.writeObject(ConvertModels.transform2DMap(model.binaryClassification, f));
        out2.writeObject(ConvertModels.transformMap(model.unaryClassification, f));
        out2.writeObject(ConvertModels.transformMap(model.wordVectors, f));
        out2.writeObject(model.op);
    }

    public static SentimentModel readSentiment(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Function<List, SimpleMatrix> f = x -> ConvertModels.toMatrix(x);
        TwoDimensionalMap map2dSM = (TwoDimensionalMap)ErasureUtils.uncheckedCast(in.readObject());
        TwoDimensionalMap<String, String, SimpleMatrix> binaryTransform = ConvertModels.transform2DMap(map2dSM, f);
        TwoDimensionalMap map2dST = (TwoDimensionalMap)ErasureUtils.uncheckedCast(in.readObject());
        TwoDimensionalMap<String, String, SimpleTensor> binaryTensor = ConvertModels.transform2DMap(map2dST, x -> ConvertModels.toTensor(x));
        map2dSM = (TwoDimensionalMap)ErasureUtils.uncheckedCast(in.readObject());
        TwoDimensionalMap<String, String, SimpleMatrix> binaryClassification = ConvertModels.transform2DMap(map2dSM, f);
        Map map = (Map)ErasureUtils.uncheckedCast(in.readObject());
        Map<String, SimpleMatrix> unaryClassification = ConvertModels.transformMap(map, f);
        map = (Map)ErasureUtils.uncheckedCast(in.readObject());
        Map<String, SimpleMatrix> wordVectors = ConvertModels.transformMap(map, f);
        RNNOptions op = (RNNOptions)ErasureUtils.uncheckedCast(in.readObject());
        return new SentimentModel(binaryTransform, binaryTensor, binaryClassification, unaryClassification, wordVectors, op);
    }

    public static void writeParser(LexicalizedParser model, DVModelReranker reranker, ObjectOutputStream out2) throws IOException {
        out2.writeObject(model);
        Function<SimpleMatrix, List> f = x -> ConvertModels.fromMatrix(x);
        DVModel dvmodel = reranker.getModel();
        out2.writeObject(ConvertModels.transform2DMap(dvmodel.binaryTransform, f));
        out2.writeObject(ConvertModels.transformMap(dvmodel.unaryTransform, f));
        out2.writeObject(ConvertModels.transform2DMap(dvmodel.binaryScore, f));
        out2.writeObject(ConvertModels.transformMap(dvmodel.unaryScore, f));
        out2.writeObject(ConvertModels.transformMap(dvmodel.wordVectors, f));
    }

    public static LexicalizedParser readParser(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LexicalizedParser model = (LexicalizedParser)ErasureUtils.uncheckedCast(in.readObject());
        Function<List, SimpleMatrix> f = x -> ConvertModels.toMatrix(x);
        TwoDimensionalMap map2dSM = (TwoDimensionalMap)ErasureUtils.uncheckedCast(in.readObject());
        TwoDimensionalMap<String, String, SimpleMatrix> binaryTransform = ConvertModels.transform2DMap(map2dSM, f);
        Map map = (Map)ErasureUtils.uncheckedCast(in.readObject());
        Map<String, SimpleMatrix> unaryTransform = ConvertModels.transformMap(map, f);
        map2dSM = (TwoDimensionalMap)ErasureUtils.uncheckedCast(in.readObject());
        TwoDimensionalMap<String, String, SimpleMatrix> binaryScore = ConvertModels.transform2DMap(map2dSM, f);
        map = (Map)ErasureUtils.uncheckedCast(in.readObject());
        Map<String, SimpleMatrix> unaryScore = ConvertModels.transformMap(map, f);
        map = (Map)ErasureUtils.uncheckedCast(in.readObject());
        Map<String, SimpleMatrix> wordVectors = ConvertModels.transformMap(map, f);
        DVModel dvModel = new DVModel(binaryTransform, unaryTransform, binaryScore, unaryScore, wordVectors, model.getOp());
        DVModelReranker reranker = new DVModelReranker(dvModel);
        model.reranker = reranker;
        return model;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Model modelType;
        Stage stage;
        Properties props = StringUtils.argsToProperties(args);
        try {
            stage = Stage.valueOf(props.getProperty("stage").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Please specify -stage, either OLD or NEW");
        }
        try {
            modelType = Model.valueOf(props.getProperty("model").toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("Please specify -model, either SENTIMENT or DVPARSER");
        }
        if (!props.containsKey("input")) {
            throw new IllegalArgumentException("Please specify -input");
        }
        if (!props.containsKey("output")) {
            throw new IllegalArgumentException("Please specify -output");
        }
        if (modelType == Model.SENTIMENT) {
            if (stage == Stage.OLD) {
                SentimentModel model = SentimentModel.loadSerialized(props.getProperty("input"));
                ObjectOutputStream out2 = new ObjectOutputStream(new FileOutputStream(props.getProperty("output")));
                ConvertModels.writeSentiment(model, out2);
                out2.close();
            } else {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(props.getProperty("input")));
                SentimentModel model = ConvertModels.readSentiment(in);
                model.saveSerialized(props.getProperty("output"));
            }
        } else if (modelType == Model.DVPARSER) {
            if (stage == Stage.OLD) {
                String inFile = props.getProperty("input");
                LexicalizedParser model = LexicalizedParser.loadModel(inFile, new String[0]);
                if (model.reranker == null) {
                    System.out.println("Nothing to do for " + inFile);
                } else {
                    DVModelReranker reranker = (DVModelReranker)model.reranker;
                    model.reranker = null;
                    ObjectOutputStream out3 = new ObjectOutputStream(new FileOutputStream(props.getProperty("output")));
                    ConvertModels.writeParser(model, reranker, out3);
                    out3.close();
                }
            } else {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(props.getProperty("input")));
                LexicalizedParser model = ConvertModels.readParser(in);
                model.saveParserToSerialized(props.getProperty("output"));
            }
        }
    }

    public static enum Model {
        SENTIMENT,
        DVPARSER;

    }

    public static enum Stage {
        OLD,
        NEW;

    }
}

