/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.naturalli.Monotonicity;
import edu.stanford.nlp.naturalli.MonotonicityType;
import edu.stanford.nlp.naturalli.NaturalLogicRelation;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public enum Operator {
    ALL("all", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    EVERY("every", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    ANY("any", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    EACH("each", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    THE_LOT_OF("the lot of", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    ALL_OF("all of", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    EACH_OF("each of", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    FOR_ALL("for all", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    FOR_EVERY("for every", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    FOR_EACH("for each", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    EVERYONE("everyone", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    NUM("--num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    NUM_NUM("--num-- --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    NUM_NUM_NUM("--num-- --num-- --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    NUM_NUM_NUM_NUM("--num-- --num-- --num-- --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    FEW("few", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "multiplicative"),
    IMPLICIT_NAMED_ENTITY("__implicit_named_entity__", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "multiplicative"),
    NO("no", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    NEITHER("neither", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    NO_ONE("no one", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    NOBODY("nobody", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    NOT("not", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    BUT("but", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    EXCEPT("except", NaturalLogicRelation.INDEPENDENCE, "anti-additive", "anti-additive"),
    UNARY_NO("no", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    UNARY_NOT("not", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    UNARY_NO_ONE("no one", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    UNARY_NT("n't", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    UNARY_BUT("but", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    UNARY_EXCEPT("except", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    GENERAL_NEG_POLARITY("neg_polarity_trigger", NaturalLogicRelation.INDEPENDENCE, "anti-additive"),
    SOME("some", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    SEVERAL("several", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    EITHER("either", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    A("a", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive-multiplicative", "additive-multiplicative"),
    THE("the", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive-multiplicative", "additive-multiplicative"),
    LESS_THAN("less than --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    SOME_OF("some of", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    ONE_OF("one of", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    AT_LEAST("at least --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    A_FEW("a few", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    AT_LEAST_A_FEW("at least a few", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    THERE_BE("there be", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    THERE_BE_A_FEW("there be a few", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    THERE_EXIST("there exist", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    NUM_OF("--num-- of", NaturalLogicRelation.FORWARD_ENTAILMENT, "additive", "additive"),
    NOT_ALL("not all", NaturalLogicRelation.INDEPENDENCE, "additive", "anti-multiplicative"),
    NOT_EVERY("not every", NaturalLogicRelation.INDEPENDENCE, "additive", "anti-multiplicative"),
    MOST("most", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    MORE("more", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    MANY("many", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    ENOUGH("enough", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    MORE_THAN("more than __num_", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    LOTS_OF("lots of", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    PLENTY_OF("plenty of", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    HEAPS_OF("heap of", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    A_LOAD_OF("a load of", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    LOADS_OF("load of", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    TONS_OF("ton of", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    BOTH("both", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    JUST_NUM("just --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    ONLY_NUM("only --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "nonmonotone", "multiplicative"),
    AT_MOST_NUM("at most --num--", NaturalLogicRelation.FORWARD_ENTAILMENT, "anti-additive", "anti-additive");

    public static final Set<String> GLOSSES;
    public static final List<Operator> valuesByLengthDesc;
    public final String surfaceForm;
    public final Monotonicity subjMono;
    public final MonotonicityType subjType;
    public final Monotonicity objMono;
    public final MonotonicityType objType;
    public final NaturalLogicRelation deleteRelation;
    public static final Set<String> quantifierGlosses;

    private Operator(String surfaceForm, NaturalLogicRelation deleteRelation, String subjMono, String objMono) {
        this.surfaceForm = surfaceForm;
        this.deleteRelation = deleteRelation;
        Pair<Monotonicity, MonotonicityType> subj = Operator.monoFromString(subjMono);
        this.subjMono = (Monotonicity)((Object)subj.first);
        this.subjType = (MonotonicityType)((Object)subj.second);
        Pair<Monotonicity, MonotonicityType> obj = Operator.monoFromString(objMono);
        this.objMono = (Monotonicity)((Object)obj.first);
        this.objType = (MonotonicityType)((Object)obj.second);
    }

    private Operator(String surfaceForm, NaturalLogicRelation deleteRelation, String subjMono) {
        this.surfaceForm = surfaceForm;
        this.deleteRelation = deleteRelation;
        Pair<Monotonicity, MonotonicityType> subj = Operator.monoFromString(subjMono);
        this.subjMono = (Monotonicity)((Object)subj.first);
        this.subjType = (MonotonicityType)((Object)subj.second);
        this.objMono = Monotonicity.INVALID;
        this.objType = MonotonicityType.NONE;
    }

    public boolean isUnary() {
        return this.objMono == Monotonicity.INVALID;
    }

    public static Pair<Monotonicity, MonotonicityType> monoFromString(String mono) {
        switch (mono) {
            case "nonmonotone": {
                return Pair.makePair(Monotonicity.NONMONOTONE, MonotonicityType.NONE);
            }
            case "additive": {
                return Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.ADDITIVE);
            }
            case "multiplicative": {
                return Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.MULTIPLICATIVE);
            }
            case "additive-multiplicative": {
                return Pair.makePair(Monotonicity.MONOTONE, MonotonicityType.BOTH);
            }
            case "anti-additive": {
                return Pair.makePair(Monotonicity.ANTITONE, MonotonicityType.ADDITIVE);
            }
            case "anti-multiplicative": {
                return Pair.makePair(Monotonicity.ANTITONE, MonotonicityType.MULTIPLICATIVE);
            }
            case "anti-additive-multiplicative": {
                return Pair.makePair(Monotonicity.ANTITONE, MonotonicityType.BOTH);
            }
        }
        throw new IllegalArgumentException("Unknown monotonicity: " + mono);
    }

    public static String monotonicitySignature(Monotonicity mono, MonotonicityType type) {
        switch (mono) {
            case MONOTONE: {
                switch (type) {
                    case NONE: {
                        return "nonmonotone";
                    }
                    case ADDITIVE: {
                        return "additive";
                    }
                    case MULTIPLICATIVE: {
                        return "multiplicative";
                    }
                    case BOTH: {
                        return "additive-multiplicative";
                    }
                }
            }
            case ANTITONE: {
                switch (type) {
                    case NONE: {
                        return "nonmonotone";
                    }
                    case ADDITIVE: {
                        return "anti-additive";
                    }
                    case MULTIPLICATIVE: {
                        return "anti-multiplicative";
                    }
                    case BOTH: {
                        return "anti-additive-multiplicative";
                    }
                }
            }
            case NONMONOTONE: {
                return "nonmonotone";
            }
        }
        throw new IllegalStateException("Unhandled case: " + (Object)((Object)mono) + " and " + (Object)((Object)type));
    }

    public static Optional<Operator> fromString(String word) {
        String wordToLowerCase = word.toLowerCase().replaceAll("[0-9]", "--num-- ").trim();
        for (Operator candidate : Operator.values()) {
            if (!candidate.surfaceForm.equals(wordToLowerCase)) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    static {
        GLOSSES = Collections.unmodifiableSet(new HashSet<String>(){
            {
                for (Operator q : Operator.values()) {
                    this.add(q.surfaceForm);
                }
            }
        });
        valuesByLengthDesc = Collections.unmodifiableList(new ArrayList<Operator>(){
            {
                for (Operator op : Operator.values()) {
                    this.add(op);
                }
                Collections.sort(this, (a, b) -> b.surfaceForm.split(" ").length - a.surfaceForm.split(" ").length);
            }
        });
        quantifierGlosses = Collections.unmodifiableSet(new HashSet<String>(){
            {
                for (Operator operator : Operator.values()) {
                    this.add(operator.surfaceForm);
                }
            }
        });
    }
}

