/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.util.Trilean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum NaturalLogicRelation {
    EQUIVALENT(0, true, false, true, false),
    FORWARD_ENTAILMENT(1, true, false, false, false),
    REVERSE_ENTAILMENT(2, false, false, true, false),
    NEGATION(3, false, true, false, true),
    ALTERNATION(4, false, true, false, false),
    COVER(5, false, false, false, true),
    INDEPENDENCE(6, false, false, false, false);

    public final int fixedIndex;
    public final boolean maintainsTruth;
    public final boolean negatesTruth;
    public final boolean maintainsFalsehood;
    public final boolean negatesFalsehood;
    private static final Map<String, NaturalLogicRelation> insertArcToNaturalLogicRelation;

    private NaturalLogicRelation(int fixedIndex, boolean maintainsTruth, boolean negatesTruth, boolean maintainsFalsehood, boolean negatesFalsehood) {
        this.fixedIndex = fixedIndex;
        this.maintainsTruth = maintainsTruth;
        this.negatesTruth = negatesTruth;
        this.maintainsFalsehood = maintainsFalsehood;
        this.negatesFalsehood = negatesFalsehood;
    }

    protected static NaturalLogicRelation byFixedIndex(int index) {
        switch (index) {
            case 0: {
                return EQUIVALENT;
            }
            case 1: {
                return FORWARD_ENTAILMENT;
            }
            case 2: {
                return REVERSE_ENTAILMENT;
            }
            case 3: {
                return NEGATION;
            }
            case 4: {
                return ALTERNATION;
            }
            case 5: {
                return COVER;
            }
            case 6: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalArgumentException("Unknown index for Natural Logic relation: " + index);
    }

    public NaturalLogicRelation join(NaturalLogicRelation other) {
        switch (this) {
            case EQUIVALENT: {
                return other;
            }
            case FORWARD_ENTAILMENT: {
                switch (other) {
                    case EQUIVALENT: 
                    case FORWARD_ENTAILMENT: {
                        return FORWARD_ENTAILMENT;
                    }
                    case NEGATION: 
                    case ALTERNATION: {
                        return COVER;
                    }
                    case REVERSE_ENTAILMENT: 
                    case COVER: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case REVERSE_ENTAILMENT: {
                switch (other) {
                    case EQUIVALENT: 
                    case REVERSE_ENTAILMENT: {
                        return REVERSE_ENTAILMENT;
                    }
                    case NEGATION: 
                    case COVER: {
                        return COVER;
                    }
                    case FORWARD_ENTAILMENT: 
                    case ALTERNATION: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case NEGATION: {
                switch (other) {
                    case EQUIVALENT: {
                        return NEGATION;
                    }
                    case FORWARD_ENTAILMENT: {
                        return COVER;
                    }
                    case REVERSE_ENTAILMENT: {
                        return ALTERNATION;
                    }
                    case NEGATION: {
                        return EQUIVALENT;
                    }
                    case ALTERNATION: {
                        return REVERSE_ENTAILMENT;
                    }
                    case COVER: {
                        return FORWARD_ENTAILMENT;
                    }
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case ALTERNATION: {
                switch (other) {
                    case EQUIVALENT: 
                    case REVERSE_ENTAILMENT: {
                        return ALTERNATION;
                    }
                    case NEGATION: 
                    case COVER: {
                        return FORWARD_ENTAILMENT;
                    }
                    case FORWARD_ENTAILMENT: 
                    case ALTERNATION: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case COVER: {
                switch (other) {
                    case EQUIVALENT: 
                    case FORWARD_ENTAILMENT: {
                        return COVER;
                    }
                    case NEGATION: 
                    case ALTERNATION: {
                        return REVERSE_ENTAILMENT;
                    }
                    case REVERSE_ENTAILMENT: 
                    case COVER: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case INDEPENDENCE: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalStateException("[should be impossible]: Incomplete join table for " + (Object)((Object)this) + " joined with " + (Object)((Object)other));
    }

    public Trilean applyToTruthValue(boolean initialTruthValue) {
        if (initialTruthValue) {
            if (this.maintainsTruth) {
                return Trilean.TRUE;
            }
            if (this.negatesTruth) {
                return Trilean.FALSE;
            }
            return Trilean.UNKNOWN;
        }
        if (this.maintainsFalsehood) {
            return Trilean.FALSE;
        }
        if (this.negatesFalsehood) {
            return Trilean.TRUE;
        }
        return Trilean.UNKNOWN;
    }

    public static boolean knownDependencyArc(String dependencyLabel) {
        return insertArcToNaturalLogicRelation.containsKey(dependencyLabel.toLowerCase());
    }

    public static NaturalLogicRelation forDependencyInsertion(String dependencyLabel) {
        return NaturalLogicRelation.forDependencyInsertion(dependencyLabel, true);
    }

    public static NaturalLogicRelation forDependencyInsertion(String dependencyLabel, boolean isSubject) {
        return NaturalLogicRelation.forDependencyInsertion(dependencyLabel, isSubject, Optional.empty());
    }

    public static NaturalLogicRelation forDependencyInsertion(String dependencyLabel, boolean isSubject, Optional<String> dependent) {
        NaturalLogicRelation rel;
        if (!isSubject) {
            switch (dependencyLabel) {
                case "conj:or": 
                case "conj:nor": {
                    return NaturalLogicRelation.forDependencyInsertion("conj:and", false);
                }
                case "cc:preconj": {
                    if (dependent.isPresent() && "neither".equalsIgnoreCase(dependent.get())) {
                        return INDEPENDENCE;
                    }
                    return REVERSE_ENTAILMENT;
                }
            }
        }
        if ((rel = insertArcToNaturalLogicRelation.get(dependencyLabel.toLowerCase())) != null) {
            return rel;
        }
        if (dependencyLabel.startsWith("nmod:")) {
            return REVERSE_ENTAILMENT;
        }
        if (dependencyLabel.startsWith("conj")) {
            return REVERSE_ENTAILMENT;
        }
        if (dependencyLabel.startsWith("advcl")) {
            return REVERSE_ENTAILMENT;
        }
        return INDEPENDENCE;
    }

    private static NaturalLogicRelation insertionToDeletion(NaturalLogicRelation insertionRel) {
        switch (insertionRel) {
            case EQUIVALENT: {
                return EQUIVALENT;
            }
            case FORWARD_ENTAILMENT: {
                return REVERSE_ENTAILMENT;
            }
            case REVERSE_ENTAILMENT: {
                return FORWARD_ENTAILMENT;
            }
            case NEGATION: {
                return NEGATION;
            }
            case ALTERNATION: {
                return COVER;
            }
            case COVER: {
                return ALTERNATION;
            }
            case INDEPENDENCE: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalStateException("Unhandled natural logic relation: " + (Object)((Object)insertionRel));
    }

    public static NaturalLogicRelation forDependencyDeletion(String dependencyLabel) {
        return NaturalLogicRelation.forDependencyDeletion(dependencyLabel, true);
    }

    public static NaturalLogicRelation forDependencyDeletion(String dependencyLabel, boolean isSubject) {
        NaturalLogicRelation rel = NaturalLogicRelation.forDependencyInsertion(dependencyLabel, isSubject);
        return NaturalLogicRelation.insertionToDeletion(rel);
    }

    public static NaturalLogicRelation forDependencyDeletion(String dependencyLabel, boolean isSubject, Optional<String> dependent) {
        NaturalLogicRelation rel = NaturalLogicRelation.forDependencyInsertion(dependencyLabel, isSubject, dependent);
        return NaturalLogicRelation.insertionToDeletion(rel);
    }

    static {
        insertArcToNaturalLogicRelation = Collections.unmodifiableMap(new HashMap<String, NaturalLogicRelation>(){
            {
                this.put("acomp", REVERSE_ENTAILMENT);
                this.put("advcl", REVERSE_ENTAILMENT);
                this.put("acl", REVERSE_ENTAILMENT);
                this.put("acl:relcl", REVERSE_ENTAILMENT);
                this.put("advmod", REVERSE_ENTAILMENT);
                this.put("agent", INDEPENDENCE);
                this.put("amod", REVERSE_ENTAILMENT);
                this.put("appos", REVERSE_ENTAILMENT);
                this.put("aux", INDEPENDENCE);
                this.put("aux:pass", INDEPENDENCE);
                this.put("comp", REVERSE_ENTAILMENT);
                this.put("ccomp", REVERSE_ENTAILMENT);
                this.put("cc", REVERSE_ENTAILMENT);
                this.put("compound", INDEPENDENCE);
                this.put("flat", INDEPENDENCE);
                this.put("mwe", INDEPENDENCE);
                this.put("conj:and\\/or", REVERSE_ENTAILMENT);
                this.put("conj:and", REVERSE_ENTAILMENT);
                this.put("conj:both", REVERSE_ENTAILMENT);
                this.put("conj:but", REVERSE_ENTAILMENT);
                this.put("conj:nor", FORWARD_ENTAILMENT);
                this.put("conj:or", FORWARD_ENTAILMENT);
                this.put("conj:plus", FORWARD_ENTAILMENT);
                this.put("conj", REVERSE_ENTAILMENT);
                this.put("conj_x", REVERSE_ENTAILMENT);
                this.put("cop", INDEPENDENCE);
                this.put("csubj", REVERSE_ENTAILMENT);
                this.put("csubj:pass", INDEPENDENCE);
                this.put("dep", REVERSE_ENTAILMENT);
                this.put("det", FORWARD_ENTAILMENT);
                this.put("discourse", EQUIVALENT);
                this.put("obj", REVERSE_ENTAILMENT);
                this.put("expl", EQUIVALENT);
                this.put("goeswith", EQUIVALENT);
                this.put("infmod", REVERSE_ENTAILMENT);
                this.put("iobj", REVERSE_ENTAILMENT);
                this.put("mark", REVERSE_ENTAILMENT);
                this.put("mwe", INDEPENDENCE);
                this.put("neg", NEGATION);
                this.put("nn", INDEPENDENCE);
                this.put("npadvmod", REVERSE_ENTAILMENT);
                this.put("nsubj", REVERSE_ENTAILMENT);
                this.put("nsubj:pass", INDEPENDENCE);
                this.put("number", INDEPENDENCE);
                this.put("nummod", INDEPENDENCE);
                this.put("op", INDEPENDENCE);
                this.put("parataxis", REVERSE_ENTAILMENT);
                this.put("partmod", REVERSE_ENTAILMENT);
                this.put("pcomp", INDEPENDENCE);
                this.put("pobj", INDEPENDENCE);
                this.put("possessive", INDEPENDENCE);
                this.put("poss", FORWARD_ENTAILMENT);
                this.put("nmod:poss", FORWARD_ENTAILMENT);
                this.put("preconj", INDEPENDENCE);
                this.put("predet", INDEPENDENCE);
                this.put("case", INDEPENDENCE);
                this.put("nmod:aboard", REVERSE_ENTAILMENT);
                this.put("nmod:about", REVERSE_ENTAILMENT);
                this.put("nmod:above", REVERSE_ENTAILMENT);
                this.put("nmod:according_to", REVERSE_ENTAILMENT);
                this.put("nmod:across_from", REVERSE_ENTAILMENT);
                this.put("nmod:across", REVERSE_ENTAILMENT);
                this.put("nmod:after", REVERSE_ENTAILMENT);
                this.put("nmod:against", REVERSE_ENTAILMENT);
                this.put("nmod:ahead_of", REVERSE_ENTAILMENT);
                this.put("nmod:along", REVERSE_ENTAILMENT);
                this.put("nmod:alongside_of", REVERSE_ENTAILMENT);
                this.put("nmod:alongside", REVERSE_ENTAILMENT);
                this.put("nmod:along_with", REVERSE_ENTAILMENT);
                this.put("nmod:amid", REVERSE_ENTAILMENT);
                this.put("nmod:among", REVERSE_ENTAILMENT);
                this.put("nmod:anti", REVERSE_ENTAILMENT);
                this.put("nmod:apart_from", REVERSE_ENTAILMENT);
                this.put("nmod:around", REVERSE_ENTAILMENT);
                this.put("nmod:as_for", REVERSE_ENTAILMENT);
                this.put("nmod:as_from", REVERSE_ENTAILMENT);
                this.put("nmod:aside_from", REVERSE_ENTAILMENT);
                this.put("nmod:as_of", REVERSE_ENTAILMENT);
                this.put("nmod:as_per", REVERSE_ENTAILMENT);
                this.put("nmod:as", REVERSE_ENTAILMENT);
                this.put("nmod:as_to", REVERSE_ENTAILMENT);
                this.put("nmod:at", REVERSE_ENTAILMENT);
                this.put("nmod:away_from", REVERSE_ENTAILMENT);
                this.put("nmod:based_on", REVERSE_ENTAILMENT);
                this.put("nmod:because_of", REVERSE_ENTAILMENT);
                this.put("nmod:before", REVERSE_ENTAILMENT);
                this.put("nmod:behind", REVERSE_ENTAILMENT);
                this.put("nmod:below", REVERSE_ENTAILMENT);
                this.put("nmod:beneath", REVERSE_ENTAILMENT);
                this.put("nmod:beside", REVERSE_ENTAILMENT);
                this.put("nmod:besides", REVERSE_ENTAILMENT);
                this.put("nmod:between", REVERSE_ENTAILMENT);
                this.put("nmod:beyond", REVERSE_ENTAILMENT);
                this.put("nmod:but", REVERSE_ENTAILMENT);
                this.put("nmod:by_means_of", REVERSE_ENTAILMENT);
                this.put("nmod:by", REVERSE_ENTAILMENT);
                this.put("nmod:depending_on", REVERSE_ENTAILMENT);
                this.put("nmod:dep", REVERSE_ENTAILMENT);
                this.put("nmod:despite", REVERSE_ENTAILMENT);
                this.put("nmod:down", REVERSE_ENTAILMENT);
                this.put("nmod:due_to", REVERSE_ENTAILMENT);
                this.put("nmod:during", REVERSE_ENTAILMENT);
                this.put("nmod:en", REVERSE_ENTAILMENT);
                this.put("nmod:except_for", REVERSE_ENTAILMENT);
                this.put("nmod:excepting", REVERSE_ENTAILMENT);
                this.put("nmod:except", REVERSE_ENTAILMENT);
                this.put("nmod:excluding", REVERSE_ENTAILMENT);
                this.put("nmod:exclusive_of", REVERSE_ENTAILMENT);
                this.put("nmod:followed_by", REVERSE_ENTAILMENT);
                this.put("nmod:following", REVERSE_ENTAILMENT);
                this.put("nmod:for", REVERSE_ENTAILMENT);
                this.put("nmod:from", REVERSE_ENTAILMENT);
                this.put("nmod:if", REVERSE_ENTAILMENT);
                this.put("nmod:in_accordance_with", REVERSE_ENTAILMENT);
                this.put("nmod:in_addition_to", REVERSE_ENTAILMENT);
                this.put("nmod:in_case_of", REVERSE_ENTAILMENT);
                this.put("nmod:including", REVERSE_ENTAILMENT);
                this.put("nmod:in_front_of", REVERSE_ENTAILMENT);
                this.put("nmod:in_lieu_of", REVERSE_ENTAILMENT);
                this.put("nmod:in_place_of", REVERSE_ENTAILMENT);
                this.put("nmod:in", REVERSE_ENTAILMENT);
                this.put("nmod:inside_of", REVERSE_ENTAILMENT);
                this.put("nmod:inside", REVERSE_ENTAILMENT);
                this.put("nmod:in_spite_of", REVERSE_ENTAILMENT);
                this.put("nmod:instead_of", REVERSE_ENTAILMENT);
                this.put("nmod:into", REVERSE_ENTAILMENT);
                this.put("nmod:irrespective_of", REVERSE_ENTAILMENT);
                this.put("nmod:like", REVERSE_ENTAILMENT);
                this.put("nmod:minus", REVERSE_ENTAILMENT);
                this.put("nmod:near", REVERSE_ENTAILMENT);
                this.put("nmod:near_to", REVERSE_ENTAILMENT);
                this.put("nmod:next_to", REVERSE_ENTAILMENT);
                this.put("nmod:off_of", REVERSE_ENTAILMENT);
                this.put("nmod:off", REVERSE_ENTAILMENT);
                this.put("nmod:of", REVERSE_ENTAILMENT);
                this.put("nmod:on_account_of", REVERSE_ENTAILMENT);
                this.put("nmod:on_behalf_of", REVERSE_ENTAILMENT);
                this.put("nmod:on", REVERSE_ENTAILMENT);
                this.put("nmod:on_top_of", REVERSE_ENTAILMENT);
                this.put("nmod:onto", REVERSE_ENTAILMENT);
                this.put("nmod:opposite", REVERSE_ENTAILMENT);
                this.put("nmod:out_of", REVERSE_ENTAILMENT);
                this.put("nmod:out", REVERSE_ENTAILMENT);
                this.put("nmod:outside_of", REVERSE_ENTAILMENT);
                this.put("nmod:outside", REVERSE_ENTAILMENT);
                this.put("nmod:over", REVERSE_ENTAILMENT);
                this.put("nmod:owing_to", REVERSE_ENTAILMENT);
                this.put("nmod:past", REVERSE_ENTAILMENT);
                this.put("nmod:per", REVERSE_ENTAILMENT);
                this.put("nmod:plus", REVERSE_ENTAILMENT);
                this.put("nmod:preliminary_to", REVERSE_ENTAILMENT);
                this.put("nmod:preparatory_to", REVERSE_ENTAILMENT);
                this.put("nmod:previous_to", REVERSE_ENTAILMENT);
                this.put("nmod:prior_to", REVERSE_ENTAILMENT);
                this.put("nmod:pursuant_to", REVERSE_ENTAILMENT);
                this.put("nmod:regarding", REVERSE_ENTAILMENT);
                this.put("nmod:regardless_of", REVERSE_ENTAILMENT);
                this.put("nmod", REVERSE_ENTAILMENT);
                this.put("nmod:round", REVERSE_ENTAILMENT);
                this.put("nmod:save", REVERSE_ENTAILMENT);
                this.put("nmod:since", REVERSE_ENTAILMENT);
                this.put("nmod:subsequent_to", REVERSE_ENTAILMENT);
                this.put("nmod:such_as", REVERSE_ENTAILMENT);
                this.put("nmod:thanks_to", REVERSE_ENTAILMENT);
                this.put("nmod:than", REVERSE_ENTAILMENT);
                this.put("nmod:throughout", REVERSE_ENTAILMENT);
                this.put("nmod:through", REVERSE_ENTAILMENT);
                this.put("nmod:together_with", REVERSE_ENTAILMENT);
                this.put("nmod:to", REVERSE_ENTAILMENT);
                this.put("nmod:toward", REVERSE_ENTAILMENT);
                this.put("nmod:towards", REVERSE_ENTAILMENT);
                this.put("nmod:underneath", REVERSE_ENTAILMENT);
                this.put("nmod:under", REVERSE_ENTAILMENT);
                this.put("nmod:unlike", REVERSE_ENTAILMENT);
                this.put("nmod:until", REVERSE_ENTAILMENT);
                this.put("nmod:upon", REVERSE_ENTAILMENT);
                this.put("nmod:up", REVERSE_ENTAILMENT);
                this.put("nmod:versus", REVERSE_ENTAILMENT);
                this.put("nmod:via", REVERSE_ENTAILMENT);
                this.put("nmod:vs.", REVERSE_ENTAILMENT);
                this.put("nmod:whether", REVERSE_ENTAILMENT);
                this.put("nmod:within", REVERSE_ENTAILMENT);
                this.put("nmod:without", REVERSE_ENTAILMENT);
                this.put("nmod:with_regard_to", REVERSE_ENTAILMENT);
                this.put("nmod:with_respect_to", REVERSE_ENTAILMENT);
                this.put("nmod:with", REVERSE_ENTAILMENT);
                this.put("obl:aboard", REVERSE_ENTAILMENT);
                this.put("obl:about", REVERSE_ENTAILMENT);
                this.put("obl:above", REVERSE_ENTAILMENT);
                this.put("obl:according_to", REVERSE_ENTAILMENT);
                this.put("obl:across_from", REVERSE_ENTAILMENT);
                this.put("obl:across", REVERSE_ENTAILMENT);
                this.put("obl:after", REVERSE_ENTAILMENT);
                this.put("obl:against", REVERSE_ENTAILMENT);
                this.put("obl:ahead_of", REVERSE_ENTAILMENT);
                this.put("obl:along", REVERSE_ENTAILMENT);
                this.put("obl:alongside_of", REVERSE_ENTAILMENT);
                this.put("obl:alongside", REVERSE_ENTAILMENT);
                this.put("obl:along_with", REVERSE_ENTAILMENT);
                this.put("obl:amid", REVERSE_ENTAILMENT);
                this.put("obl:among", REVERSE_ENTAILMENT);
                this.put("obl:anti", REVERSE_ENTAILMENT);
                this.put("obl:apart_from", REVERSE_ENTAILMENT);
                this.put("obl:around", REVERSE_ENTAILMENT);
                this.put("obl:as_for", REVERSE_ENTAILMENT);
                this.put("obl:as_from", REVERSE_ENTAILMENT);
                this.put("obl:aside_from", REVERSE_ENTAILMENT);
                this.put("obl:as_of", REVERSE_ENTAILMENT);
                this.put("obl:as_per", REVERSE_ENTAILMENT);
                this.put("obl:as", REVERSE_ENTAILMENT);
                this.put("obl:as_to", REVERSE_ENTAILMENT);
                this.put("obl:at", REVERSE_ENTAILMENT);
                this.put("obl:away_from", REVERSE_ENTAILMENT);
                this.put("obl:based_on", REVERSE_ENTAILMENT);
                this.put("obl:because_of", REVERSE_ENTAILMENT);
                this.put("obl:before", REVERSE_ENTAILMENT);
                this.put("obl:behind", REVERSE_ENTAILMENT);
                this.put("obl:below", REVERSE_ENTAILMENT);
                this.put("obl:beneath", REVERSE_ENTAILMENT);
                this.put("obl:beside", REVERSE_ENTAILMENT);
                this.put("obl:besides", REVERSE_ENTAILMENT);
                this.put("obl:between", REVERSE_ENTAILMENT);
                this.put("obl:beyond", REVERSE_ENTAILMENT);
                this.put("obl:but", REVERSE_ENTAILMENT);
                this.put("obl:by_means_of", REVERSE_ENTAILMENT);
                this.put("obl:by", REVERSE_ENTAILMENT);
                this.put("obl:depending_on", REVERSE_ENTAILMENT);
                this.put("obl:dep", REVERSE_ENTAILMENT);
                this.put("obl:despite", REVERSE_ENTAILMENT);
                this.put("obl:down", REVERSE_ENTAILMENT);
                this.put("obl:due_to", REVERSE_ENTAILMENT);
                this.put("obl:during", REVERSE_ENTAILMENT);
                this.put("obl:en", REVERSE_ENTAILMENT);
                this.put("obl:except_for", REVERSE_ENTAILMENT);
                this.put("obl:excepting", REVERSE_ENTAILMENT);
                this.put("obl:except", REVERSE_ENTAILMENT);
                this.put("obl:excluding", REVERSE_ENTAILMENT);
                this.put("obl:exclusive_of", REVERSE_ENTAILMENT);
                this.put("obl:followed_by", REVERSE_ENTAILMENT);
                this.put("obl:following", REVERSE_ENTAILMENT);
                this.put("obl:for", REVERSE_ENTAILMENT);
                this.put("obl:from", REVERSE_ENTAILMENT);
                this.put("obl:if", REVERSE_ENTAILMENT);
                this.put("obl:in_accordance_with", REVERSE_ENTAILMENT);
                this.put("obl:in_addition_to", REVERSE_ENTAILMENT);
                this.put("obl:in_case_of", REVERSE_ENTAILMENT);
                this.put("obl:including", REVERSE_ENTAILMENT);
                this.put("obl:in_front_of", REVERSE_ENTAILMENT);
                this.put("obl:in_lieu_of", REVERSE_ENTAILMENT);
                this.put("obl:in_place_of", REVERSE_ENTAILMENT);
                this.put("obl:in", REVERSE_ENTAILMENT);
                this.put("obl:inside_of", REVERSE_ENTAILMENT);
                this.put("obl:inside", REVERSE_ENTAILMENT);
                this.put("obl:in_spite_of", REVERSE_ENTAILMENT);
                this.put("obl:instead_of", REVERSE_ENTAILMENT);
                this.put("obl:into", REVERSE_ENTAILMENT);
                this.put("obl:irrespective_of", REVERSE_ENTAILMENT);
                this.put("obl:like", REVERSE_ENTAILMENT);
                this.put("obl:minus", REVERSE_ENTAILMENT);
                this.put("obl:near", REVERSE_ENTAILMENT);
                this.put("obl:near_to", REVERSE_ENTAILMENT);
                this.put("obl:next_to", REVERSE_ENTAILMENT);
                this.put("obl:off_of", REVERSE_ENTAILMENT);
                this.put("obl:off", REVERSE_ENTAILMENT);
                this.put("obl:of", REVERSE_ENTAILMENT);
                this.put("obl:on_account_of", REVERSE_ENTAILMENT);
                this.put("obl:on_behalf_of", REVERSE_ENTAILMENT);
                this.put("obl:on", REVERSE_ENTAILMENT);
                this.put("obl:on_top_of", REVERSE_ENTAILMENT);
                this.put("obl:onto", REVERSE_ENTAILMENT);
                this.put("obl:opposite", REVERSE_ENTAILMENT);
                this.put("obl:out_of", REVERSE_ENTAILMENT);
                this.put("obl:out", REVERSE_ENTAILMENT);
                this.put("obl:outside_of", REVERSE_ENTAILMENT);
                this.put("obl:outside", REVERSE_ENTAILMENT);
                this.put("obl:over", REVERSE_ENTAILMENT);
                this.put("obl:owing_to", REVERSE_ENTAILMENT);
                this.put("obl:past", REVERSE_ENTAILMENT);
                this.put("obl:per", REVERSE_ENTAILMENT);
                this.put("obl:plus", REVERSE_ENTAILMENT);
                this.put("obl:preliminary_to", REVERSE_ENTAILMENT);
                this.put("obl:preparatory_to", REVERSE_ENTAILMENT);
                this.put("obl:previous_to", REVERSE_ENTAILMENT);
                this.put("obl:prior_to", REVERSE_ENTAILMENT);
                this.put("obl:pursuant_to", REVERSE_ENTAILMENT);
                this.put("obl:regarding", REVERSE_ENTAILMENT);
                this.put("obl:regardless_of", REVERSE_ENTAILMENT);
                this.put("obl", REVERSE_ENTAILMENT);
                this.put("obl:round", REVERSE_ENTAILMENT);
                this.put("obl:save", REVERSE_ENTAILMENT);
                this.put("obl:since", REVERSE_ENTAILMENT);
                this.put("obl:subsequent_to", REVERSE_ENTAILMENT);
                this.put("obl:such_as", REVERSE_ENTAILMENT);
                this.put("obl:thanks_to", REVERSE_ENTAILMENT);
                this.put("obl:than", REVERSE_ENTAILMENT);
                this.put("obl:throughout", REVERSE_ENTAILMENT);
                this.put("obl:through", REVERSE_ENTAILMENT);
                this.put("obl:together_with", REVERSE_ENTAILMENT);
                this.put("obl:to", REVERSE_ENTAILMENT);
                this.put("obl:toward", REVERSE_ENTAILMENT);
                this.put("obl:towards", REVERSE_ENTAILMENT);
                this.put("obl:underneath", REVERSE_ENTAILMENT);
                this.put("obl:under", REVERSE_ENTAILMENT);
                this.put("obl:unlike", REVERSE_ENTAILMENT);
                this.put("obl:until", REVERSE_ENTAILMENT);
                this.put("obl:upon", REVERSE_ENTAILMENT);
                this.put("obl:up", REVERSE_ENTAILMENT);
                this.put("obl:versus", REVERSE_ENTAILMENT);
                this.put("obl:via", REVERSE_ENTAILMENT);
                this.put("obl:vs.", REVERSE_ENTAILMENT);
                this.put("obl:whether", REVERSE_ENTAILMENT);
                this.put("obl:within", REVERSE_ENTAILMENT);
                this.put("obl:without", REVERSE_ENTAILMENT);
                this.put("obl:with_regard_to", REVERSE_ENTAILMENT);
                this.put("obl:with_respect_to", REVERSE_ENTAILMENT);
                this.put("obl:with", REVERSE_ENTAILMENT);
                this.put("prt", INDEPENDENCE);
                this.put("punct", EQUIVALENT);
                this.put("purpcl", REVERSE_ENTAILMENT);
                this.put("quantmod", FORWARD_ENTAILMENT);
                this.put("ref", REVERSE_ENTAILMENT);
                this.put("rcmod", REVERSE_ENTAILMENT);
                this.put("root", INDEPENDENCE);
                this.put("tmod", REVERSE_ENTAILMENT);
                this.put("vmod", REVERSE_ENTAILMENT);
                this.put("xcomp", REVERSE_ENTAILMENT);
            }
        });
    }
}

