/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref;

import edu.stanford.nlp.coref.data.CorefCluster;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CorefUtils {
    public static List<Mention> getSortedMentions(Document document) {
        ArrayList<Mention> mentions = new ArrayList<Mention>(document.predictedMentionsByID.values());
        Collections.sort(mentions, (m1, m2) -> m1.appearEarlierThan((Mention)m2) ? -1 : 1);
        return mentions;
    }

    public static List<Pair<Integer, Integer>> getMentionPairs(Document document) {
        ArrayList<Pair<Integer, Integer>> pairs = new ArrayList<Pair<Integer, Integer>>();
        List<Mention> mentions = CorefUtils.getSortedMentions(document);
        for (int i = 0; i < mentions.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                pairs.add(new Pair<Integer, Integer>(mentions.get((int)j).mentionID, mentions.get((int)i).mentionID));
            }
        }
        return pairs;
    }

    public static Map<Pair<Integer, Integer>, Boolean> getUnlabeledMentionPairs(Document document) {
        return CorefUtils.getMentionPairs(document).stream().collect(Collectors.toMap(p -> p, p -> false));
    }

    public static Map<Pair<Integer, Integer>, Boolean> getLabeledMentionPairs(Document document) {
        Map<Pair<Integer, Integer>, Boolean> mentionPairs = CorefUtils.getUnlabeledMentionPairs(document);
        for (CorefCluster c : document.goldCorefClusters.values()) {
            ArrayList<Mention> clusterMentions = new ArrayList<Mention>(c.getCorefMentions());
            for (Mention clusterMention : clusterMentions) {
                for (Mention clusterMention2 : clusterMentions) {
                    Pair<Integer, Integer> mentionPair = new Pair<Integer, Integer>(clusterMention.mentionID, clusterMention2.mentionID);
                    if (!mentionPairs.containsKey(mentionPair)) continue;
                    mentionPairs.put(mentionPair, true);
                }
            }
        }
        return mentionPairs;
    }

    public static void mergeCoreferenceClusters(Pair<Integer, Integer> mentionPair, Document document) {
        Mention m1 = document.predictedMentionsByID.get(mentionPair.first);
        Mention m2 = document.predictedMentionsByID.get(mentionPair.second);
        if (m1.corefClusterID == m2.corefClusterID) {
            return;
        }
        int removeId = m1.corefClusterID;
        CorefCluster c1 = document.corefClusters.get(m1.corefClusterID);
        CorefCluster c2 = document.corefClusters.get(m2.corefClusterID);
        CorefCluster.mergeClusters(c2, c1);
        document.corefClusters.remove(removeId);
    }

    public static void removeSingletonClusters(Document document) {
        for (CorefCluster c : new ArrayList<CorefCluster>(document.corefClusters.values())) {
            if (c.getCorefMentions().size() != 1) continue;
            document.corefClusters.remove(c.clusterID);
        }
    }

    public static void checkForInterrupt() {
        if (Thread.interrupted()) {
            throw new RuntimeInterruptedException();
        }
    }

    public static Map<Integer, List<Integer>> heuristicFilter(List<Mention> sortedMentions, int maxMentionDistance, int maxMentionDistanceWithStringMatch) {
        HashMap wordToMentions = new HashMap();
        for (int i = 0; i < sortedMentions.size(); ++i) {
            Mention m = sortedMentions.get(i);
            for (String word : CorefUtils.getContentWords(m)) {
                wordToMentions.putIfAbsent(word, new ArrayList());
                ((List)wordToMentions.get(word)).add(m);
            }
        }
        HashMap<Integer, List<Integer>> mentionToCandidateAntecedents = new HashMap<Integer, List<Integer>>();
        for (int i = 0; i < sortedMentions.size(); ++i) {
            Mention m = sortedMentions.get(i);
            ArrayList<Integer> candidateAntecedents = new ArrayList<Integer>();
            for (int j = Math.max(0, i - maxMentionDistance); j < i; ++j) {
                candidateAntecedents.add(sortedMentions.get((int)j).mentionID);
            }
            for (String word : CorefUtils.getContentWords(m)) {
                List withStringMatch = (List)wordToMentions.get(word);
                if (withStringMatch == null) continue;
                for (Mention match : withStringMatch) {
                    if (match.mentionNum >= m.mentionNum || match.mentionNum < m.mentionNum - maxMentionDistanceWithStringMatch || candidateAntecedents.contains(match.mentionID)) continue;
                    candidateAntecedents.add(match.mentionID);
                }
            }
            if (candidateAntecedents.isEmpty()) continue;
            mentionToCandidateAntecedents.put(m.mentionID, candidateAntecedents);
        }
        return mentionToCandidateAntecedents;
    }

    private static List<String> getContentWords(Mention m) {
        ArrayList<String> words = new ArrayList<String>();
        for (int i = m.startIndex; i < m.endIndex; ++i) {
            CoreLabel cl = m.sentenceWords.get(i);
            String POS = (String)cl.get(CoreAnnotations.PartOfSpeechAnnotation.class);
            if (!POS.equals("NN") && !POS.equals("NNS") && !POS.equals("NNP") && !POS.equals("NNPS")) continue;
            words.add(cl.word().toLowerCase());
        }
        return words;
    }

    public static void printHumanReadableCoref(Document document) {
        for (CorefCluster c : document.corefClusters.values()) {
            for (Mention corefMention : c.corefMentions) {
                Redwood.log(document.docInfo.get("DOC_ID") + "\t" + c.clusterID + "\t" + corefMention.originalSpan.get(0).beginPosition() + "\t" + corefMention.toString() + "\n");
            }
        }
    }
}

