app.import((lib, game, ui, get, ai, _status, app) => {
	lib.arenaReady.push(() => {
		initializePlayerNames();
		overrideUpdateRoundNumber();
		createUIElements();
	});
	// 玩家昵称列表
	const PLAYER_NICKNAMES = ["缘之空", "小小恐龙", "自然萌", "海边的ebao", "小云云", "点点", "猫猫虫", "小爱莉", "冰佬", "鹿鹿", "黎佬", "浮牢师", "U佬", "蓝宝", "影宝", "柳下跖", "无语", "小曦", "墨渊", "k9", "扶苏", "皇叔"];
	// 初始化玩家昵称
	const initializePlayerNames = () => {
		setInterval(() => {
			game.countPlayer(current => {
				// 添加确定每个玩家的名字
				if (!current.nickname) {
					const namex = current === game.me ? lib.config.connect_nickname : PLAYER_NICKNAMES.randomGet();
					current.nickname = namex;
				}
			});
		}, 1000);
	};
	// 重写轮次更新函数
	const overrideUpdateRoundNumber = () => {
		const originUpdateRoundNumber = game.updateRoundNumber;
		game.updateRoundNumber = function () {
			originUpdateRoundNumber.apply(this, arguments);
			if (ui.cardRoundTime) {
				ui.cardRoundTime.updateRoundCard();
			}
		};
	};
	// 创建UI元素
	const createUIElements = () => {
		createConfigButton();
		createSortButton();
		createSelectAllButton();
		createTopRightMenu();
	};
	// 创建配置按钮
	const createConfigButton = () => {
		const configButton = ui.create.node("div");
		configButton.style.cssText = `
			display: block;
			--w: 56px;
			--h: calc(var(--w) * 74/71);
			width: var(--w);
			height: var(--h);
			position: absolute;
			bottom: 13%;
			left: 53px;
			right: auto;
			background-color: transparent;
			z-index: 1;
		`;
		configButton.onclick = () => {
			game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
			if (!ui.click.configMenu) return;
			game.closePopped();
			game.pause2();
			ui.click.configMenu();
			ui.system1.classList.remove("shown");
			ui.system2.classList.remove("shown");
		};
		document.body.appendChild(configButton);
	};
	// 创建整理手牌按钮
	const createSortButton = () => {
		const isRightLayout = lib.config["extension_十周年UI_rightLayout"] === "on";
		const sortImg = "hs_zhengli.png";
		const sortButton = ui.create.node("img");
		sortButton.src = `${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/${sortImg}`;
		let styleText = "display:block;position:absolute;background-color:transparent;";
		styleText += "width:85px;height:50px;bottom: 18%;left: 22px;z-index:4;right: auto;";
		styleText += isRightLayout ? "right: calc(100% - 380px);z-index:3;" : "right: calc(100% - 1260px);z-index:3;";
		sortButton.style.cssText = styleText;
		sortButton.onclick = () => {
			if (!game.me || game.me.hasSkillTag("noSortCard")) return;
			const cards = game.me.getCards("hs");
			const sortFunction = (b, a) => {
				if (a.name !== b.name) return lib.sort.card(a.name, b.name);
				if (a.suit !== b.suit) return lib.suit.indexOf(a) - lib.suit.indexOf(b);
				return a.number - b.number;
			};
			if (cards.length > 1) {
				cards.sort(sortFunction);
				cards.forEach((card, index) => {
					game.me.node.handcards1.insertBefore(cards[index], game.me.node.handcards1.firstChild);
				});
				dui.queueNextFrameTick(dui.layoutHand, dui);
			}
		};
		document.body.appendChild(sortButton);
	};
	// 创建全选/反选手牌按钮
	const createSelectAllButton = () => {
		const isRightLayout = lib.config["extension_十周年UI_rightLayout"] === "on";
		const selectAllButton = ui.create.node("img");
		const updateSelectAllButtonImage = () => {
			if (ui.selected.cards.length > 0) {
				selectAllButton.src = `${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/fanxuanhs.png`;
			} else {
				selectAllButton.src = `${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/quanxuanhs.png`;
			}
		};
		updateSelectAllButtonImage();
		let styleText = "display:block;position:absolute;background-color:transparent;";
		styleText += "width:85px;height:50px;bottom: 26%;left: 22px;z-index:4;right: auto;";
		styleText += isRightLayout ? "right: calc(100% - 295px);z-index:3;" : "right: calc(100% - 1175px);z-index:3;";
		selectAllButton.style.cssText = styleText;
		selectAllButton.onclick = () => {
			const event = _status.event;
			if (!event || !event.isMine || !event.isMine() || !event.allowChooseAll || event.complexCard || event.complexSelect) {
				return;
			}
			const selectCard = event.selectCard;
			if (!selectCard) return;
			const range = get.select(selectCard);
			if (range[1] <= 1) return;
			game.playAudio("../extension/十周年UI/audio/card_click.mp3");
			const selecteds = [...ui.selected.cards];
			ui.selected.cards.length = 0;
			game.check();
			const selectables = get.selectableCards();
			const cards = selecteds.length ? [...new Set(selectables).difference(selecteds)] : selectables;
			if (cards.length <= range[1]) {
				ui.selected.cards.push(...cards);
			} else {
				ui.selected.cards.push(...cards.randomGets(range[1]));
			}
			for (let i = 0; i < ui.selected.cards.length; i++) {
				const card = ui.selected.cards[i];
				card.classList.add("selected");
				if (card.updateTransform) card.updateTransform(true, 0);
			}
			for (let i = 0; i < selecteds.length; i++) {
				const card = selecteds[i];
				card.classList.remove("selected");
				if (card.updateTransform) card.updateTransform(false, 0);
			}
			game.check();
			updateSelectAllButtonImage();
			if (typeof event.custom?.add?.card === "function") {
				event.custom.add.card();
			}
		};
		// 定时检测是否有选择事件，动态显示/隐藏全选按钮
		selectAllButton._interval = setInterval(() => {
			const event = _status.event;
			if (!event || !event.isMine || !event.isMine() || !event.allowChooseAll || event.complexCard || event.complexSelect) {
				selectAllButton.style.display = "none";
				return;
			}
			const selectCard = event.selectCard;
			if (!selectCard) {
				selectAllButton.style.display = "none";
				return;
			}
			const range = get.select(selectCard);
			if (range[1] <= 1) {
				selectAllButton.style.display = "none";
				return;
			}
			selectAllButton.style.display = "block";
			updateSelectAllButtonImage();
		}, 100);
		document.body.appendChild(selectAllButton);
	};
	// 创建右上角菜单
	const createTopRightMenu = () => {
		const topOffset = "10px";
		// 菜单按钮
		const menuBtn = ui.create.node("img");
		menuBtn.src = `${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/CD/hs_caidan.png`;
		menuBtn.style.cssText = `display:block;--w:56px;--h:calc(var(--w) * 74/71);width:var(--w);height:var(--h);position:absolute;top:${topOffset};left:40px;background-color:transparent;z-index:3;`;
		document.body.appendChild(menuBtn);
		let menuPopup = null;
		const openMenu = () => {
			if (menuPopup) return;
			game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/click.mp3");
			menuPopup = ui.create.div(".popup-container", { background: "rgb(0,0,0,0)" }, ui.window);
			menuPopup.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/back.mp3");
				event.stopPropagation();
				closeMenu();
			});
			// 创建菜单项
			const home = ui.create.div(".HOME", menuPopup);
			const settingsBtn = ui.create.div(".SZ", menuPopup);
			settingsBtn.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
				if (!ui.click.configMenu) return;
				game.closePopped();
				game.pause2();
				ui.click.configMenu();
				ui.system1.classList.remove("shown");
				ui.system2.classList.remove("shown");
				closeMenu();
			});
			const leaveBtn = ui.create.div(".LK", menuPopup);
			leaveBtn.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
				window.location.reload();
			});
			const bgBtn = ui.create.div(".BJ", menuPopup);
			bgBtn.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
				openBackgroundSelector();
			});
			const surrenderBtn = ui.create.div(".TX", menuPopup);
			surrenderBtn.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
				game.over();
			});
			const autoBtn = ui.create.div(".TG", menuPopup);
			autoBtn.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
				ui.click.auto();
			});
		};
		const openBackgroundSelector = () => {
			const popuperContainer = ui.create.div(
				".popup-container",
				{
					background: "rgba(0, 0, 0, 0.8)",
				},
				ui.window
			);
			const guanbi = ui.create.div(".bgback", popuperContainer, (e) => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/caidan.mp3");
				popuperContainer.hide();
				game.resume2();
			});
			const bigdialog = ui.create.div(".bgdialog", popuperContainer);
			const bgbg = ui.create.div(".backgroundsbg", bigdialog);
			loadBackgroundImages(bgbg);
		};
		const loadBackgroundImages = (container) => {
			let backgroundItems = lib.configMenu.appearence.config.image_background.item;
			let hiddenBgs = lib.config.hiddenBackgroundPack || [];

			for (let fileName in backgroundItems) {
				if (fileName === "default" || hiddenBgs.includes(fileName)) continue;

				let img = ui.create.div(".backgrounds", container);
				img.dataset.name = fileName;

				if (fileName.startsWith("custom_")) {
					game.getDB("image", fileName, (fileToLoad) => {
						if (fileToLoad) {
							const fileReader = new FileReader();
							fileReader.onload = (fileLoadedEvent) => {
								const data = fileLoadedEvent.target.result;
								img.style.backgroundImage = `url(${data})`;
								img.style.backgroundSize = "cover";
							};
							fileReader.readAsDataURL(fileToLoad, "UTF-8");
						}
					});
				} else {
					img.setBackgroundImage(`image/background/${fileName}.jpg`);
				}

				if (fileName === lib.config.image_background) ui.create.div(".bgxuanzhong", img);

				img.addEventListener("click", function () {
					const editItem = container.querySelector(".backgrounds:last-child");
					const isEditMode = editItem && editItem.classList.contains("active");
					if (isEditMode) {
						game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
						const textDiv = this.querySelector(".buttontext");
						if (textDiv && textDiv.innerHTML === "隐藏") {
							container.parentNode.noclose = true;
							this.remove();
							if (!lib.config.prompt_hidebg) {
								alert("隐藏的背景可通过选项-其它-重置隐藏内容恢复");
								game.saveConfig("prompt_hidebg", true);
							}
							lib.config.hiddenBackgroundPack.add(fileName);
							game.saveConfig("hiddenBackgroundPack", lib.config.hiddenBackgroundPack);
							delete lib.configMenu.appearence.config.image_background.item[fileName];
							if (lib.config.image_background === fileName) {
								game.saveConfig("image_background", "default");
								lib.init.background();
								game.updateBackground();
							}
							while (container.firstChild) {
								container.removeChild(container.firstChild);
							}
							loadBackgroundImages(container);
							return;
						} else if (textDiv && textDiv.innerHTML === "删除") {
							container.parentNode.noclose = true;
							if (confirm("是否删除此背景？（此操作不可撤销）")) {
								this.remove();
								lib.config.customBackgroundPack.remove(fileName);
								game.saveConfig("customBackgroundPack", lib.config.customBackgroundPack);
								if (fileName.startsWith("cdv_")) {
									game.removeFile(`image/background/${fileName}.jpg`);
								} else {
									game.deleteDB("image", fileName);
								}
								delete lib.configMenu.appearence.config.image_background.item[fileName];
								if (lib.config.image_background === fileName) {
									game.saveConfig("image_background", "default");
									lib.init.background();
									game.updateBackground();
								}
								while (container.firstChild) {
									container.removeChild(container.firstChild);
								}
								loadBackgroundImages(container);
							}
							return;
						}
					}
					const allSelectedElements = document.querySelectorAll(".bgxuanzhong");
					allSelectedElements.forEach((selectedElement) => {
						selectedElement.parentNode.removeChild(selectedElement);
					});
					ui.create.div(".bgxuanzhong", img);
					game.saveConfig("image_background", fileName);
					lib.init.background();
					game.updateBackground();
				});

				let backgroundName = backgroundItems[fileName];
				ui.create.div(".buttontext", backgroundName, img);
			}
			((container) => {
				const addItem = ui.create.div(".backgrounds", container);
				ui.create.div(".buttontext", "添加背景", addItem);
				const input = document.createElement("input");
				input.type = "file";
				input.accept = "image/*";
				input.multiple = true;
				input.style.display = "none";
				document.body.appendChild(input);
				addItem.addEventListener("click", () => {
					game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
					input.click();
				});
				input.onchange = (e) => {
					const files = e.target.files;
					if (!files || files.length === 0) return;
					const fileList = Array.from(files);
					const totalFiles = fileList.length;
					let processedFiles = 0;
					fileList.forEach((file2, index) => {
						if (file2) {
							let name2 = file2.name;
							if (name2.includes(".")) {
								name2 = name2.slice(0, name2.indexOf("."));
							}
							let link = `${game.writeFile ? "cdv_" : "custom_"}${name2}`;
							if (lib.configMenu.appearence.config.image_background.item[link]) {
								for (let i = 1; i < 1e3; i++) {
									if (!lib.configMenu.appearence.config.image_background.item[`${link}_${i}`]) {
										link = `${link}_${i}`;
										break;
									}
								}
							}
							lib.configMenu.appearence.config.image_background.item[link] = name2;
							const callback = () => {
								lib.config.customBackgroundPack.add(link);
								game.saveConfig("customBackgroundPack", lib.config.customBackgroundPack);
								processedFiles++;
								if (processedFiles === totalFiles && editItem.classList.contains("active")) {
									editbg.call(editItem);
								}
								while (container.firstChild) {
									container.removeChild(container.firstChild);
								}
								loadBackgroundImages(container);
							};
							if (game.writeFile) {
								game.writeFile(file2, "image/background", `${link}.jpg`, callback);
							} else {
								game.putDB("image", link, file2, callback);
							}
						}
					});
				};
				const editItem = ui.create.div(".backgrounds", container);
				ui.create.div(".buttontext", "编辑背景", editItem);
				const editbg = function () {
					this.classList.toggle("active");
					const items = Array.from(container.querySelectorAll(".backgrounds"));
					const self = this;
					items.slice(0, Math.max(0, items.length - 2)).forEach((item) => {
						const fname = item.dataset.name;
						if (!fname) return;
						const textDiv = item.querySelector(".buttontext");
						if (!textDiv) return;
						let str;
						if (self.classList.contains("active")) {
							if (fname.startsWith("custom_") || fname.startsWith("cdv_")) {
								str = "删除";
							} else {
								str = "隐藏";
							}
						} else {
							str = lib.configMenu.appearence.config.image_background.item[fname] || fname;
						}
						textDiv.innerHTML = str;
					});
				};
				editItem.addEventListener("click", function () {
					game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/button.mp3");
					editbg.call(this);
				});
			})(container);
		};
		const closeMenu = () => {
			if (menuPopup) {
				menuPopup.delete(200);
				menuPopup = null;
			}
		}
		menuBtn.onclick = function () {
			if (menuPopup) {
				closeMenu();
			} else {
				openMenu();
			}
		};
	}
	// 插件主体
	const plugin = {
		name: "lbtn",
		// 过滤器
		filter() {
			return !["chess", "tafang"].includes(get.mode());
		},
		// 内容初始化
		content(next) {
			// 创建UI卡牌更新技能
			lib.skill._uicardupdate = {
				trigger: {
					player: "phaseJieshuBegin",
				},
				forced: true,
				unique: true,
				popup: false,
				silent: true,
				noLose: true,
				noGain: true,
				noDeprive: true,
				priority: -Infinity,
				filter(event, player) {
					return player === game.me;
				},
				content() {
					if (ui.updateSkillControl) {
						ui.updateSkillControl(game.me, true);
					}
				},
			};
		},
		// 预内容初始化
		precontent() {
			initializeVideoContent();
			overrideCreateFunctions();
			overrideConfigMenu();
			overrideConfirmFunction();
		},
		// 创建器
		create: {
			// 控制创建
			control() { },
			// 确认对话框创建
			confirm() {
				const confirm = ui.create.control("<span>确定</span>", "cancel");
				confirm.classList.add("lbtn-confirm");
				confirm.node = {
					ok: confirm.firstChild,
					cancel: confirm.lastChild,
				};
				if (_status.event.endButton) {
					_status.event.endButton.close();
				}
				confirm.node.ok.link = "ok";
				confirm.node.ok.classList.add("primary");
				confirm.node.cancel.classList.add("primary2");
				confirm.custom = plugin.click.confirm;
				// 重写关闭函数
				app.reWriteFunction(confirm, {
					close: [
						function () {
							this.classList.add("closing");
						},
					],
				});
				// 绑定事件监听器
				for (const key in confirm.node) {
					const node = confirm.node[key];
					node.classList.add("disabled");
					node.removeEventListener(lib.config.touchscreen ? "touchend" : "click", ui.click.control);
					node.addEventListener(lib.config.touchscreen ? "touchend" : "click", function (e) {
						e.stopPropagation();
						if (this.classList.contains("disabled")) {
							if (this.link === "cancel" && this.dataset.type === "endButton" && _status.event.endButton) {
								_status.event.endButton.custom();
								ui.confirm.close();
							}
							return;
						}
						if (this.parentNode.custom) {
							this.parentNode.custom(this.link, this);
						}
					});
				}
				// 处理技能按钮
				if (ui.skills2 && ui.skills2.skills.length) {
					const skills = ui.skills2.skills;
					confirm.skills2 = [];
					for (let i = 0; i < skills.length; i++) {
						const item = document.createElement("div");
						item.link = skills[i];
						item.innerHTML = get.translation(skills[i]);
						item.addEventListener(lib.config.touchscreen ? "touchend" : "click", function (e) {
							e.stopPropagation();
							ui.click.skill(this.link);
						});
						item.dataset.type = "skill2";
						if (ui.updateSkillControl) {
							ui.updateSkillControl(game.me, true);
						}
					}
				}
				// 更新函数
				confirm.update = function () {
					if (confirm.skills2) {
						if (_status.event.skill && _status.event.skill !== confirm.dataset.skill) {
							confirm.dataset.skill = _status.event.skill;
							confirm.skills2.forEach(function (item) {
								item.remove();
							});
							ui.updatec();
						} else if (!_status.event.skill && confirm.dataset.skill) {
							delete confirm.dataset.skill;
							confirm.skills2.forEach(function (item) {
								confirm.insertBefore(item, confirm.firstChild);
							});
							ui.updatec();
						}
					}
					if (ui.updateSkillControl) {
						ui.updateSkillControl(game.me, true);
					}
				};
				return confirm;
			},
			// 手牌数量显示创建
			handcardNumber() {
				const isRightLayout = lib.config["extension_十周年UI_rightLayout"] === "on";
				// 创建设置按钮
				ui.create.div(".settingButton", ui.arena, plugin.click.setting);
				// 加载功能按钮（取消XPJ配置项分支，所有布局均加载小部件）
				if (isRightLayout) {
					ui.create.div(".jiluButton_new", ui.arena, ui.click.pause);
					ui.create.div(".meiguiButton_new", ui.arena);
				} else {
					ui.create.div(".jiluButton_new1", ui.arena, ui.click.pause);
					ui.create.div(".meiguiButton_new1", ui.arena, plugin.click.meigui);
				}
				// 创建托管按钮
				ui.create.div(".tuoguanButton", ui.arena, ui.click.auto);
				// 创建手牌数量显示
				const className = isRightLayout ? ".handcardNumber" : ".handcardNumber1";
				const node = ui.create.div(className, ui.arena).hide();
				node.node = {
					cardPicture: ui.create.div(".cardPicture", node),
					cardNumber: ui.create.div(".cardNumber", node),
				};
				node.updateCardnumber = function () {
					if (!game.me) return;
					const currentCards = game.me.countCards("h") || 0;
					const cardLimit = game.me.getHandcardLimit() || 0;
					const numberColor = currentCards > cardLimit ? "red" : "white";
					const displayLimit = cardLimit === Infinity ? "∞" : cardLimit;
					this.node.cardNumber.innerHTML = `<span><font color="${numberColor}">${currentCards}</font>` + `<sp style="font-size:15px; font-family:yuanli; color:#FFFCF5;">/</sp>${displayLimit}</span>`;
					this.show();
					game.addVideo("updateCardnumber", null, {
						cardNumber: cardLimit,
					});
				};
				node.node.cardNumber.interval = setInterval(function () {
					ui.handcardNumber.updateCardnumber();
				}, 1000);
				game.addVideo("createhandcardNumber");
				return node;
			},
			// 卡牌轮次时间创建
			cardRoundTime() {
				const node = ui.create.div(".cardRoundNumber", ui.arena, ui.click.pause).hide();
				node.node = {
					cardPileNumber: ui.create.div(".cardPileNumber", node),
					roundNumber: ui.create.div(".roundNumber", node),
					time: ui.create.div(".time", node),
				};
				// 更新轮次卡牌函数
				node.updateRoundCard = function () {
					const cardNumber = ui.cardPile.childNodes.length || 0;
					const roundNumber = Math.max(1, game.roundNumber || 1);
					this.node.roundNumber.innerHTML = `<span>${roundNumber}轮</span>`;
					this.setNumberAnimation(cardNumber);
					this.show();
					game.addVideo("updateCardRoundTime", null, {
						cardNumber: cardNumber,
						roundNumber: roundNumber,
					});
				};
				// 数字动画函数
				node.setNumberAnimation = function (num, step) {
					const item = this.node.cardPileNumber;
					clearTimeout(item.interval);
					if (!item._num) {
						item.innerHTML = `<span>${num}</span>`;
						item._num = num;
					} else {
						if (item._num !== num) {
							if (!step) {
								step = 500 / Math.abs(item._num - num);
							}
							if (item._num > num) {
								item._num--;
							} else {
								item._num++;
							}
							item.innerHTML = `<span>${item._num}</span>`;
							if (item._num !== num) {
								item.interval = setTimeout(function () {
									node.setNumberAnimation(num, step);
								}, step);
							}
						}
					}
				};
				// 时间显示
				ui.time4 = node.node.time;
				ui.time4.starttime = get.utc();
				ui.time4.interval = setInterval(function () {
					const totalSeconds = Math.round((get.utc() - ui.time4.starttime) / 1000);
					if (totalSeconds >= 3600) {
						// 显示小时:分钟:秒
						const hours = Math.floor(totalSeconds / 3600);
						const minutes = Math.floor((totalSeconds - hours * 3600) / 60);
						const seconds = totalSeconds - hours * 3600 - minutes * 60;
						const formattedHours = hours < 10 ? "0" + hours : hours.toString();
						const formattedMinutes = minutes < 10 ? "0" + minutes : minutes.toString();
						const formattedSeconds = seconds < 10 ? "0" + seconds : seconds.toString();
						ui.time4.innerHTML = `<span>${formattedHours}:${formattedMinutes}:${formattedSeconds}</span>`;
					} else {
						// 显示分钟:秒
						const minutes = Math.floor(totalSeconds / 60);
						const seconds = totalSeconds - minutes * 60;
						const formattedMinutes = minutes < 10 ? "0" + minutes : minutes.toString();
						const formattedSeconds = seconds < 10 ? "0" + seconds : seconds.toString();
						ui.time4.innerHTML = `<span>${formattedMinutes}:${formattedSeconds}</span>`;
					}
				}, 1000);
				game.addVideo("createCardRoundTime");
				return node;
			},
		},
		// 点击事件处理
		click: {
			// 换肤按钮
			huanfu() {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/CD/huanfu.mp3");
				if (window.zyile_charactercard) {
					window.zyile_charactercard(player, false);
				} else {
					ui.click.charactercard(game.me.name, game.zhu, lib.config.mode === "mode_guozhan" ? "guozhan" : true);
				}
			},
			// 确认按钮
			confirm(link, target) {
				if (link === "ok") {
					ui.click.ok(target);
				} else if (link === "cancel") {
					ui.click.cancel(target);
				} else if (target.custom) {
					target.custom(link);
				}
			},
		},
		// 比较函数
		compare: {
			type(a, b) {
				if (a === b) return 0;
				const types = ["basic", "trick", "delay", "equip"].addArray([a, b]);
				return types.indexOf(a) - types.indexOf(b);
			},
			name(a, b) {
				if (a === b) return 0;
				return a > b ? 1 : -1;
			},
			nature(a, b) {
				if (a === b) return 0;
				const nature = [undefined, "fire", "thunder"].addArray([a, b]);
				return nature.indexOf(a) - nature.indexOf(b);
			},
			suit(a, b) {
				if (a === b) return 0;
				const suit = ["diamond", "heart", "club", "spade"].addArray([a, b]);
				return suit.indexOf(a) - suit.indexOf(b);
			},
			number(a, b) {
				return a - b;
			},
		},
	};
	// 初始化视频内容
	function initializeVideoContent() {
		Object.assign(game.videoContent, {
			createCardRoundTime() {
				ui.cardRoundTime = plugin.create.cardRoundTime();
			},
			createhandcardNumber() {
				ui.handcardNumber = plugin.create.handcardNumber();
			},
			updateCardRoundTime(opts) {
				if (!ui.cardRoundTime) return;
				const roundNumber = Math.max(1, game.roundNumber || 1);
				ui.cardRoundTime.node.roundNumber.innerHTML = `<span>第${roundNumber}轮</span>`;
				ui.cardRoundTime.setNumberAnimation(opts.cardNumber);
			},
			updateCardnumber(opts) {
				if (!ui.handcardNumber) return;
				// ui.handcardNumber.setNumberAnimation(opts.cardNumber);
			},
		});
	}
	// 重写创建函数
	function overrideCreateFunctions() {
		app.reWriteFunction(ui.create, {
			me: [
				function () {
					plugin.create.control();
				},
				null,
			],
			arena: [
				null,
				function () {
					if (ui.time3) {
						clearInterval(ui.time3.interval);
						ui.time3.delete();
					}
					if (ui.cardPileNumber) {
						ui.cardPileNumber.delete();
					}
					ui.cardRoundTime = plugin.create.cardRoundTime();
					ui.handcardNumber = plugin.create.handcardNumber();
				},
			],
			cards: [
				null,
				function () {
					if (ui.cardRoundTime) {
						ui.cardRoundTime.updateRoundCard();
					}
				},
			],
		});
	}
	// 重写配置菜单
	function overrideConfigMenu() {
		app.reWriteFunction(lib.configMenu.appearence.config, {
			update: [
				null,
				function (res, config, map) {
					map.control_style.hide();
					map.custom_button.hide();
					map.custom_button_system_top.hide();
					map.custom_button_system_bottom.hide();
					map.custom_button_control_top.hide();
					map.custom_button_control_bottom.hide();
					map.radius_size.hide();
				},
			],
		});
	}
	// 重写确认函数
	function overrideConfirmFunction() {
		ui.create.confirm = function (str, func) {
			let confirm = ui.confirm;
			if (!confirm) {
				confirm = ui.confirm = plugin.create.confirm();
			}
			confirm.node.ok.classList.add("disabled");
			confirm.node.cancel.classList.add("disabled");
			if (_status.event.endButton) {
				ui.confirm.node.cancel.classList.remove("disabled");
			}
			if (str) {
				if (str.indexOf("o") !== -1) {
					confirm.node.ok.classList.remove("disabled");
				}
				if (str.indexOf("c") !== -1) {
					confirm.node.cancel.classList.remove("disabled");
				}
				confirm.str = str;
			}
			if (func) {
				confirm.custom = func;
			}
			ui.updatec();
			confirm.update();
		};
		const originalCardChooseAll = ui.create.cardChooseAll;
		ui.create.cardChooseAll = () => null;
		function removeCardChooseAll(event) {
			if (!event || !event.cardChooseAll) return;
			const el = event.cardChooseAll;
			if (el instanceof HTMLDivElement) {
				if (el.parentNode) el.remove();
				if (ui.updatec) ui.updatec();
			}
			delete event.cardChooseAll;
		}
		const initObserver = () => {
			if (!ui.control) return;
			const observer = new MutationObserver((mutations) => {
				for (let i = 0; i < mutations.length; i++) {
					const added = mutations[i].addedNodes;
					for (let j = 0; j < added.length; j++) {
						const node = added[j];
						if (node.nodeType === 1 && node.classList && node.classList.contains("control")) {
							const first = node.firstElementChild;
							if (first && /^[全反]选$/.test(first.innerHTML) && node.childElementCount === 1) {
								node.remove();
								if (_status.event && _status.event.cardChooseAll === node) delete _status.event.cardChooseAll;
								if (ui.updatec) ui.updatec();
							}
						}
					}
				}
			});
			observer.observe(ui.control, { childList: true });
		};
		if (ui.control) initObserver();
		else if (lib.arenaReady) lib.arenaReady.push(initObserver);

		if (lib.hooks && lib.hooks.checkEnd) {
			lib.hooks.checkEnd.add(removeCardChooseAll);
		}
		const originalCheck = game.check;
		game.check = function (event) {
			const result = originalCheck.apply(this, arguments);
			removeCardChooseAll(event);
			return result;
		};
		// 拦截出牌阶段的取消：有选中时仅恢复选择而不结束回合
		(() => {
			const originalCancel = ui.click.cancel;
			ui.click.cancel = function (node) {
				const event = _status.event;
				if (event && _status.event.type === "phase" && ui.confirm && !event.skill && (ui.selected.cards.length !== 0 || ui.selected.targets.length !== 0)) {
					ui.confirm.classList.add("removing");
					event.restore();
					const cards = event.player.getCards("hej");
					for (let i = 0; i < cards.length; i++) {
						cards[i].recheck("useSkill");
					}
					game.uncheck();
					game.check();
					return;
				}
				return originalCancel.call(this, node);
			};
		})();
	}
	return plugin;
});
