app.import((lib, game, ui, get, ai, _status, app) => {
	const LBTN_CONST = {
		guozhanIdentities: [
			{ key: "unknown", color: "#FFFFDE" },
			{ key: "wei", color: "#0075FF" },
			{ key: "shu", color: "#ff0000" },
			{ key: "wu", color: "#00ff00" },
			{ key: "qun", color: "#ffff00" },
			{ key: "jin", color: "#9e00ff" },
			{ key: "ye", color: "#9e00ff" },
			{ key: "key", color: "#9e00ff" },
		],
		identityColors: {
			zhu: "#ae5f35",
			zhong: "#e9d765",
			fan: "#87a671",
			nei: "#9581c4",
		},
	};
	function buildModeWinTranslations(mode, versusMode) {
		const baseIdentityMap = {
			rZhu: "击败冷方主公<br>与所有野心家",
			rZhong: "保护暖方主公<br>击败冷方主公<br>与所有野心家",
			rYe: "联合冷方野心家<br>击败其他角色",
			rNei: "协助冷方主公<br>击败暖方主公<br>与所有野心家",
			bZhu: "击败暖方主公<br>与所有野心家",
			bZhong: "保护冷方主公<br>击败暖方主公<br>与所有野心家",
			bYe: "联合暖方野心家<br>击败其他角色",
			bNei: "协助暖方主公<br>击败冷方主公<br>与所有野心家",
			zhu: "推测场上身份<br>击败反贼内奸",
			zhong: "保护主公<br>取得最后胜利",
			fan: "找出反贼队友<br>全力击败主公",
			nei: "找出反贼忠臣<br>最后击败主公",
			mingzhong: "保护主公<br>取得最后胜利",
			undefined: "胜利条件",
		};
		const handlers = {
			doudizhu: () => ({ zhu: "击败所有农民", fan: "击败地主", undefined: "未选择阵营" }),
			single: () => ({ zhu: "击败对手", fan: "击败对手", undefined: "未选择阵营" }),
			boss: () => ({ zhu: "击败盟军", cai: "击败神祇", undefined: "未选择阵营" }),
			guozhan: () => {
				const map = { undefined: "未选择势力", unknown: "保持隐蔽", ye: "   击败场上<br>所有其他角色", key: "   击败所有<br>非键势力角色" };
				for (let i = 0; i < lib.group.length; i++) {
					map[lib.group[i]] = `击败所有<br>非${get.translation(lib.group[i])}势力角色`;
				}
				return map;
			},
			versus: () => {
				const vmHandlers = {
					standard: () => null,
					two: () => ({ undefined: get.config("replace_character_two") ? "抢先击败敌人<br>所有上场角色" : "   协同队友<br>击败所有敌人" }),
					three: () => ({ undefined: get.config("replace_character_two") ? "抢先击败敌人<br>所有上场角色" : "   协同队友<br>击败所有敌人" }),
					jiange: () => ({ wei: "击败所有<br>蜀势力角色", shu: "击败所有<br>魏势力角色" }),
					siguo: () => {
						const map = {};
						for (let i = 0; i < lib.group.length; i++) {
							map[lib.group[i]] = `获得龙船或击败<br>非${get.translation(lib.group[i])}势力角色`;
						}
						return map;
					},
				};
				const run = vmHandlers[versusMode];
				return run ? run() : {};
			},
		};
		return (handlers[mode] && handlers[mode]()) || baseIdentityMap;
	}
	game.ui_identityShow_update = () => {
		const identityShow = game.ui_identityShow; /*图层1*/
		const identityShowx = game.ui_identityShowx; /*图层2 在图层1下面*/
		let str = "";
		if (lib.config.mode === "guozhan" || (lib.config.mode === "versus" && get.config("versus_mode") === "siguo") || (lib.config.mode === "versus" && get.config("versus_mode") === "jiange")) {
			LBTN_CONST.guozhanIdentities.forEach(({ key, color }) => {
				const count = game.countPlayer(current => current.identity === key);
				if (count > 0) str += `<font color="${color}">${get.translation(key)}</font> x ${count}  `;
			});
		} else if (lib.config.mode === "versus" && get.config("versus_mode") === "two") {
			const enemy = game.countPlayer(current => current.isEnemyOf(game.me));
			const friend = game.countPlayer(current => current.isFriendOf(game.me));
			if (enemy > 0) str += `<font color="#ff0000">虎</font> x ${enemy}  `;
			if (friend > 0) str += `<font color="#00ff00">龙</font> x ${friend}  `;
		} else {
			const zhu = game.countPlayer(current => current.identity === "zhu" || current.identity === "rZhu" || current.identity === "bZhu");
			const zhong = game.countPlayer(current => current.identity === "zhong" || current.identity === "rZhong" || current.identity === "bZhong" || current.identity === "mingzhong");
			const fan = game.countPlayer(current => current.identity === "fan" || current.identity === "rYe" || current.identity === "bYe");
			const nei = game.countPlayer(current => current.identity === "nei" || current.identity === "rNei" || current.identity === "bNei");
			if (zhu > 0) str += `<font color="${LBTN_CONST.identityColors.zhu}">${get.translation("zhu")}</font> x ${zhu}  `;
			if (zhong > 0) str += `<font color="${LBTN_CONST.identityColors.zhong}">${get.translation("zhong")}</font> x ${zhong}  `;
			if (fan > 0) str += `<font color="${LBTN_CONST.identityColors.fan}">${get.translation("fan")}</font> x ${fan}  `;
			if (nei > 0) str += `<font color="${LBTN_CONST.identityColors.nei}">${get.translation("nei")}</font> x ${nei}`;
		}
		str += `<br>${game.me?.identity ? lib.translate[game.me.identity + "_win_option"] ?? "" : ""}`;
		/*尽量保持字体大小，行高一致，不然会产生偏移*/
		identityShow.innerHTML = `<span style="font-family:shousha; font-size: 17.0px;font-weight:500;text-align: right; line-height: 20px; color: #C1AD92;text-shadow:none;">${str}</span>`; /*图层1*/
		identityShowx.innerHTML = `<span style="font-family:shousha; font-size: 17.0px;font-weight:500;text-align: right; line-height: 20px; color: #2D241B; -webkit-text-stroke: 2.7px #322B20;text-shadow:none;">${str}</span>`; /*图层2*/
	};
	game.ui_identityShow_init = () => {
		if (game.ui_identityShow === undefined) {
			game.ui_identityShow = ui.create.div("", "身份加载中......");
			game.ui_identityShow.style.top = "1.9px"; /*图层1 上下位置如果需要改动 两个图层都要改*/
			game.ui_identityShow.style.left = "63.5px"; /*图层2 左右位置如果需要改动 两个图层都要改*/
			game.ui_identityShow.style["z-index"] = 4;
			ui.arena.appendChild(game.ui_identityShow);
		}
		if (game.ui_identityShowx === undefined) {
			game.ui_identityShowx = ui.create.div("", "身份加载中......");
			game.ui_identityShowx.style.top = "1.9px"; /*图层2*/
			game.ui_identityShowx.style.left = "63.5px"; /*图层2*/
			game.ui_identityShowx.style["z-index"] = 3;
			ui.arena.appendChild(game.ui_identityShowx);
		}
	};
	lib.arenaReady.push(() => {
		//更新轮次
		const originUpdateRoundNumber = game.updateRoundNumber;
		game.updateRoundNumber = function () {
			originUpdateRoundNumber.apply(this, arguments);
			if (ui.cardRoundTime) ui.cardRoundTime.updateRoundCard();
		};
		/*聊天按钮模块*/
		if (lib.config.extension_十周年UI_LTAN === false) {
			const liaotian = ui.create.node("img");
			liaotian.src = lib.assetURL + "extension/十周年UI/shoushaUI/lbtn/images/uibutton/liaotian.png";
			if (lib.config["extension_十周年UI_rightLayout"] === "on") {
				liaotian.style.cssText = "display: block;--w: 135px;--h: calc(var(--w) * 1019/1400);width: var(--w);height: var(--h);position: absolute;top: calc(100% - 97px);right: calc(100% - 129px);background-color: transparent;z-index:3";
			} else {
				//左手模式聊天按钮参数
				liaotian.style.cssText = "display: block; --w: 135px; --h: calc(var(--w) * 1019/1400); width: var(--w); height: var(--h); position: absolute; top: calc(100% - 97px); left: calc(100% - 129px); background-color: transparent; z-index: 3; transform: scaleX(-1);";
			}
			liaotian.onclick = () => {
				if (lib.config["extension_说话_enable"]) {
					game.showChatWordBackground();
				} else {
					game.showChatWordBackgroundX();
				}
			};
			document.body.appendChild(liaotian);
		}
		/*---------------------*/
		if (lib.config.mode === "identity" || lib.config.mode === "guozhan" || lib.config.mode === "versus" || lib.config.mode === "single" || lib.config.mode === "boss" || lib.config.mode === "doudizhu") {
			const map = buildModeWinTranslations(lib.config.mode, get.config("versus_mode"));
			if (map === null) return;
			for (const i in map) {
				lib.translate[`${i}_win_option`] = map[i];
			}
			game.ui_identityShow_init();
			setInterval(() => {
				game.ui_identityShow_update();
			}, 1000);
		}
		//右上角菜单栏
		const headImg = ui.create.node("img");
		headImg.src = `${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/SSCD/button.png`;
		headImg.style.cssText = "display: block;--w: 130px;--h: calc(var(--w) * 1080/1434);width: var(--w);height: var(--h);position: absolute;bottom: calc(100% - 98px);left: calc(100% - 126.2px);background-color: transparent;z-index:1";
		document.body.appendChild(headImg);
		const head = ui.create.node("div");
		head.style.cssText = "display: block;width: 134px;height: 103px;position: absolute;top: 0px;right: -8px;background-color: transparent;z-index:1";
		head.onclick = () => {
			game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/label.mp3");
			const popuperContainer = ui.create.div(".popup-container", { background: "rgb(0,0,0,0)" }, ui.window);
			popuperContainer.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/caidan.mp3");
				event.stopPropagation();
				popuperContainer.delete(200);
			});
			const yemian = ui.create.div(".yemian", popuperContainer);
			const shezhi = ui.create.div(".shezhi", popuperContainer);
			shezhi.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/xuanzhe.mp3");
				if (!ui.click.configMenu) return;
				game.closePopped();
				game.pause2();
				ui.click.configMenu();
				ui.system1.classList.remove("shown");
				ui.system2.classList.remove("shown");
			});
			const tuichu = ui.create.div(".tuichu", popuperContainer);
			tuichu.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/xuanzhe.mp3");
				window.location.reload();
			});
			const taopao = ui.create.div(".taopao", popuperContainer);
			taopao.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/xuanzhe.mp3");
				game.reload();
			});
			const touxiang = ui.create.div(".touxiang", popuperContainer);
			touxiang.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/xuanzhe.mp3");
				game.over();
			});
			const tuoguan = ui.create.div(".tuoguan", popuperContainer);
			tuoguan.addEventListener("click", event => {
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/xuanzhe.mp3");
				ui.click.auto();
			});
		};
		document.body.appendChild(head);
		if (lib.config.mode === "identity" || lib.config.mode === "doudizhu" || lib.config.mode === "versus" || lib.config.mode === "guozhan") {
			/*左上角问号框*/
			const tipshow = ui.create.node("img");
			tipshow.src = `${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/shenfen.png`;
			tipshow.style.cssText = "display: block;--w: 400px;--h: calc(var(--w) * 279/2139);width: var(--w);height: var(--h);position: absolute;top: -1px;left:-45px;background-color: transparent;z-index:1";
			tipshow.onclick = () => {
				const popuperContainer = ui.create.div(".popup-container", ui.window);
				game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/label.mp3");
				const modeHandlers = {
					identity: () => {
						const idMap = { zhu: ".sfrwzhugong", zhong: ".sfrwchongchen", fan: ".sfrwfanzei", nei: ".sfrwneijian" };
						const cls = idMap[game.me.identity];
						if (cls) ui.create.div(cls, popuperContainer);
					},
					doudizhu: () => {
						const idMap = { zhu: ".sfrwdizhu", fan: ".sfrwnongmin" };
						const cls = idMap[game.me.identity];
						if (cls) ui.create.div(cls, popuperContainer);
					},
					versus: () => ui.create.div(".sfrwhu", popuperContainer),
					guozhan: () => {
						const groupMap = {
							unknown: ".sfrwundefined",
							undefined: ".sfrwundefined",
							wei: ".sfrwweiguo",
							shu: ".sfrwshuguo",
							wu: ".sfrwwuguo",
							qun: ".sfrwqunxiong",
							jin: ".sfrwjinguo",
							ye: ".sfrwyexinjia",
						};
						const cls = groupMap[game.me.group] || ".sfrwundefined";
						ui.create.div(cls, popuperContainer);
					},
				};
				const handler = modeHandlers[lib.config.mode];
				if (handler) handler();
				popuperContainer.addEventListener("click", event => {
					game.playAudio("../extension/十周年UI/shoushaUI/lbtn/images/SSCD/caidan.mp3");
					popuperContainer.delete(200);
				});
			};
			document.body.appendChild(tipshow);
		}
	});
	const plugin = {
		name: "lbtn",
		filter() {
			return !["chess", "tafang"].includes(get.mode());
		},
		content(next) {
			lib.skill._uicardupdate = {
				trigger: { player: "phaseJieshuBegin" },
				forced: true,
				unique: true,
				popup: false,
				silent: true,
				noLose: true,
				noGain: true,
				noDeprive: true,
				priority: -Infinity,
				filter(event, player) {
					return !!player;
				},
				async content(event, trigger, player) {
					const me = player || (_status.event && _status.event.player) || game.me;
					if (ui.updateSkillControl) ui.updateSkillControl(me, true);
				},
			};
		},
		precontent() {
			Object.assign(game.videoContent, {
				createCardRoundTime() {
					ui.cardRoundTime = plugin.create.cardRoundTime();
				},
				createhandcardNumber() {
					ui.handcardNumber = plugin.create.handcardNumber();
				},
				updateCardRoundTime(opts) {
					if (!ui.cardRoundTime) return;
					const roundNumber = Math.max(1, game.roundNumber || 1);
					ui.cardRoundTime.node.roundNumber.innerHTML = `<span>第${roundNumber}轮</span>`;
					ui.cardRoundTime.setNumberAnimation(opts.cardNumber);
				},
				updateCardnumber(opts) {
					if (!ui.handcardNumber) return;
				},
			});
			app.reWriteFunction(ui.create, {
				me: [
					function () {
						plugin.create.control();
					},
					null,
				],
				arena: [
					null,
					function () {
						if (ui.time3) {
							clearInterval(ui.time3.interval);
							ui.time3.delete();
						}
						if (ui.cardPileNumber) ui.cardPileNumber.delete();
						ui.cardRoundTime = plugin.create.cardRoundTime();
						ui.handcardNumber = plugin.create.handcardNumber();
					},
				],
				cards: [
					null,
					function () {
						if (ui.cardRoundTime) {
							ui.cardRoundTime.updateRoundCard();
						}
					},
				],
			});
			app.reWriteFunction(lib.configMenu.appearence.config, {
				update: [
					null,
					function (res, config, map) {
						map.control_style.hide();
						map.custom_button.hide();
						map.custom_button_system_top.hide();
						map.custom_button_system_bottom.hide();
						map.custom_button_control_top.hide();
						map.custom_button_control_bottom.hide();
						map.radius_size.hide();
					},
				],
			});
			ui.create.confirm = (str, func) => {
				if ((_status.mode === "huanle" && _status.event.parent.name === "chooseCharacter" && _status.event.parent.step === "6" && _status.event.name === "chooseButton") || (lib.config["extension_无名补丁_xindjun"] && get.playerNumber() === "8" && get.mode() === "identity" && _status.mode === "normal" && _status.event.parent.name === "chooseCharacter" && _status.event.parent.step === "1" && _status.event.name === "chooseButton")) {
					const node = ui.dialog.querySelector(".selected");
					const head = ui.create.div(".ok23", node);
					head.ondblclick = (e) => {
						e.stopPropagation();
						ui.click.ok();
					};
					return;
				}
				let confirm = ui.confirm;
				if (!confirm) {
					confirm = ui.confirm = plugin.create.confirm();
				}
				confirm.node.ok.classList.add("disabled");
				confirm.node.cancel.classList.add("disabled");
				if (_status.event.endButton) {
					ui.confirm.node.cancel.classList.remove("disabled");
				}
				if (str) {
					if (str.indexOf("o") !== -1) {
						confirm.node.ok.classList.remove("disabled");
					}
					if (str.indexOf("c") !== -1) {
						confirm.node.cancel.classList.remove("disabled");
					}
					confirm.str = str;
				}
				if (func) {
					confirm.custom = func;
				}
				ui.updatec();
				confirm.update();
			};
			// 拦截出牌阶段的取消：有选中时仅恢复选择而不结束回合
			(() => {
				const originalCancel = ui.click.cancel;
				ui.click.cancel = function (node) {
					const event = _status.event;
					if (event && _status.event.type === "phase" && ui.confirm && !event.skill && (ui.selected.cards.length !== 0 || ui.selected.targets.length !== 0)) {
						ui.confirm.classList.add("removing");
						event.restore();
						const cards = event.player.getCards("hej");
						for (let i = 0; i < cards.length; i++) {
							cards[i].recheck("useSkill");
						}
						game.uncheck();
						game.check();
						return;
					}
					return originalCancel.call(this, node);
				};
			})();
		},
		create: {
			control() { },
			confirm() {
				//确定文本
				const confirm = ui.create.control("<span></span>", "cancel");
				confirm.classList.add("lbtn-confirm");
				confirm.node = {
					ok: confirm.firstChild,
					cancel: confirm.lastChild,
					//小改动
					//cancel2: confirm.lastChild,
				};
				if (_status.event.endButton) {
					_status.event.endButton.close();
					//	delete event.endButton;
				}
				confirm.node.ok.link = "ok";
				//这里重要修改2开始
				//目的是在使用手气卡时，将按钮替换为免费换牌（3次后替换为换牌的函数在gamedraw函数里），将弃牌阶段按钮替换为弃牌，所以css的样式一定要搬。（再次修改，用以适配神将选势力）
				if (_status.event.name === "gameDraw") confirm.node.ok.classList.add("huan");
				else if (_status.event.name === "chooseToDiscard" && _status.event.parent.name === "phaseDiscard") confirm.node.ok.classList.add("qi");
				else if ((_status.mode === "huanle" && _status.event.parent.step === "7") || (get.mode() === "identity" && _status.mode === "normal" && _status.event.parent.name === "chooseCharacter" && _status.event.parent.step === "2")) confirm.node.ok.classList.add("group");
				else confirm.node.ok.classList.add("primary");
				if ((_status.mode === "huanle" && _status.event.parent.step === "7") || (get.mode() === "identity" && _status.mode === "normal" && _status.event.parent.name === "chooseCharacter" && _status.event.parent.step === "2")) confirm.node.cancel.remove();
				else confirm.node.cancel.classList.add("primary2");
				confirm.node.cancel.innerHTML = `<image style=width: 80px height 15px src=${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/QX.png>`;
				// confirm.node.cancel2.classList.add('primary2');
				confirm.custom = plugin.click.confirm;
				app.reWriteFunction(confirm, {
					close: [
						function () {
							this.classList.add("closing");
						},
					],
				});
				for (const k in confirm.node) {
					confirm.node[k].classList.add("disabled");
					confirm.node[k].removeEventListener(lib.config.touchscreen ? "touchend" : "click", ui.click.control);
					confirm.node[k].addEventListener(lib.config.touchscreen ? "touchend" : "click", function (e) {
						e.stopPropagation();
						if (this.classList.contains("disabled")) {
							if (this.link === "cancel" && this.dataset.type === "endButton" && _status.event.endButton) {
								_status.event.endButton.custom();
								ui.confirm.close();
								//  ui.updatec();
							}
							return;
						}
						if (this.parentNode.custom) {
							this.parentNode.custom(this.link, this);
						}
					});
				}
				//添加重铸按钮素材
				if (ui.skills2 && ui.skills2.skills.length) {
					const skills = ui.skills2.skills;
					confirm.skills2 = [];
					for (let i = 0; i < skills.length; i++) {
						const item = document.createElement("div");
						item.link = skills[i];
						if (skills[i] === "_recasting") {
							item.innerHTML = `<img draggable='false' src=${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/CZ.png>`;
							// 为重铸按钮设置单独的背景图
							item.style.backgroundImage = `url(${lib.assetURL}extension/十周年UI/shoushaUI/lbtn/images/uibutton/game_btn_bg2.png)`;
							item.style.transform = "scale(0.75,0.75)";
							item.style.setProperty("padding", "25px 10px", "important");
						} else {
							item.innerHTML = get.translation(skills[i]);
						}
						item.addEventListener(lib.config.touchscreen ? "touchend" : "click", function (e) {
							if (_status.event?.skill === "_recasting") return;
							e.stopPropagation();
							ui.click.skill(this.link);
							if (ui.updateSkillControl) ui.updateSkillControl(game.me, true);
						});
						item.dataset.type = "skill2";
						confirm.skills2.push(item);
						confirm.insertBefore(item, confirm.firstChild);
					}
				}
				confirm.update = () => {
					//鹿鹿修改 限定技专属按钮开始
					const skisxdj = () => {
						if (_status.event?.skill && get.info(_status.event.skill)?.limited && _status.event.player === game.me) {
							return true;
						}
						if (_status.event?.getParent(2)?.skill && get.info(_status.event.getParent(2).skill)?.limited && _status.event.getParent(2).player === game.me) {
							return true;
						}
						if (_status.event?.getParent()?.skill && get.info(_status.event.getParent().skill)?.limited && _status.event.getParent().player === game.me) {
							return true;
						}
						return false;
					};
					if (skisxdj() === true && !confirm.node.ok.classList.contains("xiandingji")) {
						confirm.node.ok.classList.add("xiandingji");
					}
					if (skisxdj() !== true && confirm.node.ok.classList.contains("xiandingji")) {
						confirm.node.ok.classList.remove("xiandingji");
					}
					//鹿鹿修改 限定技专属按钮结束
					if (confirm.skills2) {
						if (_status.event.skill && _status.event.skill !== confirm.dataset.skill) {
							confirm.dataset.skill = _status.event.skill;
							confirm.skills2.forEach((item) => {
								item.remove();
							});
							ui.updatec();
						} else if (!_status.event.skill && confirm.dataset.skill) {
							delete confirm.dataset.skill;
							confirm.skills2.forEach((item) => {
								confirm.insertBefore(item, confirm.firstChild);
							});
							ui.updatec();
						}
					}
					if (ui.updateSkillControl) ui.updateSkillControl(game.me, true);
				};
				return confirm;
			},
			handcardNumber() {
				const node3 = ui.create.div(".settingButton", ui.arena, plugin.click.setting);
				const node2 = ui.create.div(".lbtn-controls", ui.arena);
				ui.create.div(".lbtn-control", node2, "   ");
				ui.create.div(".lbtn-control", node2, "   ");
				/*ui.create.div('.lbtn-control1', node2, plugin.click.paixu);*/
				//左手模式记录和牌序按钮
				let paixuauto, jilu;
				if (lib.config["extension_十周年UI_rightLayout"] === "on") {
					paixuauto = ui.create.div(".lbtn-paixu", ui.arena);
					jilu = ui.create.div(".latn-jilu", ui.arena, ui.click.pause);
				} else {
					paixuauto = ui.create.div(".lbtn-paixu1", ui.arena);
					jilu = ui.create.div(".latn-jilu1", ui.arena, ui.click.pause);
				}
				paixuauto.onclick = () => {
					if (window.paixuxx === undefined || window.paixuxx === false) {
						plugin.click.startAutoPaixu();
						paixuauto.setBackgroundImage("extension/十周年UI/shoushaUI/lbtn/images/uibutton/zidongpaixu.png");
						window.paixuxx = true;
					} else {
						plugin.click.stopAutoPaixu();
						paixuauto.setBackgroundImage("extension/十周年UI/shoushaUI/lbtn/images/uibutton/btn-paixu.png");
						window.paixuxx = false;
					}
				};
				//-----------------//
				//左手模式同上继续加一个显示手牌牌量新的按钮css
				let node;
				if (lib.config["extension_十周年UI_rightLayout"] === "on") {
					node = ui.create.div(".handcardNumber", ui.arena).hide();
					node.node = {
						cardPicture: ui.create.div(".cardPicture", node),
						cardNumber: ui.create.div(".cardNumber", node),
					};
				} else {
					node = ui.create.div(".handcardNumber1", ui.arena).hide();
					node.node = {
						cardPicture: ui.create.div(".cardPicture1", node),
						cardNumber: ui.create.div(".cardNumber1", node),
					};
				}
				//手牌显示·---//
				node.updateCardnumber = function () {
					if (!game.me) return;
					const cardNumber2 = game.me.countCards("h") || 0;
					let cardNumber = game.me.getHandcardLimit() || 0;
					let numbercolor = "white";
					if (cardNumber2 > cardNumber) numbercolor = "white";
					if (cardNumber === Infinity) cardNumber = "∞";
					if (cardNumber > game.me.hp) numbercolor = "#20c520";
					if (cardNumber < game.me.hp) numbercolor = "#ff1813";
					if (cardNumber === game.me.hp) numbercolor = "#ffe9cd";
					this.node.cardNumber.innerHTML = `</span><font size=5.5 >${cardNumber2}</font><font size=5 face="xinwei">/<font color=${numbercolor} size=4 face="shousha">${cardNumber}</font></span>`;
					//      this.setNumberAnimation(cardNumber);
					this.show();
					game.addVideo("updateCardnumber", null, {
						cardNumber: cardNumber,
					});
				};
				node.node.cardNumber.interval = setInterval(() => {
					ui.handcardNumber.updateCardnumber();
				}, 1000);
				game.addVideo("createhandcardNumber");
				return node;
			},
			cardRoundTime() {
				const node = ui.create.div(".cardRoundNumber", ui.arena).hide();
				node.node = {
					cardPileNumber: ui.create.div(".cardPileNumber", node, plugin.click.paidui),
					roundNumber: ui.create.div(".roundNumber", node),
					time: ui.create.div(".time", node),
				};
				node.updateRoundCard = function () {
					const cardNumber = ui.cardPile.childNodes.length || 0;
					const roundNumber = Math.max(1, game.roundNumber || 1);
					this.node.roundNumber.innerHTML = `<span>第${roundNumber}轮</span>`;
					this.setNumberAnimation(cardNumber);
					this.show();
					game.addVideo("updateCardRoundTime", null, {
						cardNumber: cardNumber,
						roundNumber: roundNumber,
					});
				};
				node.setNumberAnimation = function (num, step) {
					const item = this.node.cardPileNumber;
					clearTimeout(item.interval);
					if (!item._num) {
						item.innerHTML = `<span>${num}</span>`;
						item._num = num;
					} else {
						if (item._num !== num) {
							if (!step) step = 500 / Math.abs(item._num - num);
							if (item._num > num) item._num--;
							else item._num++;
							item.innerHTML = `<span>${item._num}</span>`;
							if (item._num !== num) {
								const self = this;
								item.interval = setTimeout(() => {
									self.setNumberAnimation(num, step);
								}, step);
							}
						}
					}
				};
				ui.time4 = node.node.time;
				ui.time4.starttime = get.utc();
				ui.time4.interval = setInterval(() => {
					const num = Math.round((get.utc() - ui.time4.starttime) / 1000);
					if (num >= 3600) {
						let num1 = Math.floor(num / 3600);
						let num2 = Math.floor((num - num1 * 3600) / 60);
						let num3 = num - num1 * 3600 - parseInt(num2) * 60;
						if (num1 < 10) {
							num1 = `0${num1.toString()}`;
						}
						if (num2 < 10) {
							num2 = `0${num2.toString()}`;
						}
						if (num3 < 10) {
							num3 = `0${num3.toString()}`;
						}
						ui.time4.innerHTML = `<span>${num1}:${num2}:${num3}</span>`;
					} else {
						let num1 = Math.floor(num / 60);
						let num2 = num - num1 * 60;
						if (num1 < 10) {
							num1 = `0${num1.toString()}`;
						}
						if (num2 < 10) {
							num2 = `0${num2.toString()}`;
						}
						ui.time4.innerHTML = `<span>${num1}:${num2}</span>`;
					}
				}, 1000);
				game.addVideo("createCardRoundTime");
				return node;
			},
		},
		click: {
			paixu() {
				if (!game.me || game.me.hasSkillTag("noSortCard")) return;
				const cards = game.me.getCards("hs");
				const sort2 = (a, b) => {
					const order = { basic: 0, trick: 1, delay: 1, equip: 2 };
					const ta = get.type(a);
					const tb = get.type(b);
					const ca = order[ta] === undefined ? 99 : order[ta];
					const cb = order[tb] === undefined ? 99 : order[tb];
					if (ca !== cb) return ca - cb;
					if (a.name !== b.name) return lib.sort.card(a.name, b.name);
					if (a.suit !== b.suit) return lib.suit.indexOf(a.suit) - lib.suit.indexOf(b.suit);
					return a.number - b.number;
				};
				if (cards.length > 1) {
					cards.sort(sort2);
					cards.forEach((i, j) => {
						game.me.node.handcards1.insertBefore(cards[j], game.me.node.handcards1.firstChild);
					});
					dui.queueNextFrameTick(dui.layoutHand, dui);
				}
			},
			// 开启自动牌序（监听手牌变化自动整理）
			startAutoPaixu() {
				if (!game.me || game.me.hasSkillTag("noSortCard")) return;
				const container = game.me.node && game.me.node.handcards1;
				if (!container) return;
				if (ui._autoPaixuObserver) {
					try {
						ui._autoPaixuObserver.disconnect();
					} catch (e) { }
				}
				ui._autoPaixuDebounce = null;
				ui._autoPaixuSorting = false;
				ui._autoPaixuEnabled = true;
				ui._autoPaixuContainer = container;
				ui._autoPaixuLastCount = container.childNodes.length || 0;
				ui._autoPaixuObserver = new MutationObserver(() => {
					if (ui._autoPaixuSorting) return;
					if (ui._autoPaixuDebounce) clearTimeout(ui._autoPaixuDebounce);
					ui._autoPaixuDebounce = setTimeout(() => {
						if (!game.me || !game.me.node || !game.me.node.handcards1) return;
						const curCount = game.me.node.handcards1.childNodes.length || 0;
						if (ui._autoPaixuLastCount !== null && curCount < ui._autoPaixuLastCount) {
							ui._autoPaixuLastCount = curCount;
							return;
						}
						const cards = game.me.getCards("hs");
						const sort2 = (a, b) => {
							const order = { basic: 0, trick: 1, delay: 1, equip: 2 };
							const ta = get.type(a);
							const tb = get.type(b);
							const ca = order[ta] === undefined ? 99 : order[ta];
							const cb = order[tb] === undefined ? 99 : order[tb];
							if (ca !== cb) return ca - cb;
							if (a.name !== b.name) return lib.sort.card(a.name, b.name);
							if (a.suit !== b.suit) return lib.suit.indexOf(a.suit) - lib.suit.indexOf(b.suit);
							return a.number - b.number;
						};
						if (cards.length > 1) {
							ui._autoPaixuSorting = true;
							const sorted = cards.slice().sort(sort2);
							const container = game.me.node.handcards1;
							let unchanged = true;
							for (let idx = 0; idx < sorted.length; idx++) {
								if (container.childNodes[idx] !== sorted[idx]) {
									unchanged = false;
									break;
								}
							}
							if (!unchanged) {
								for (let k = 0; k < sorted.length; k++) {
									const nodeExpect = sorted[k];
									if (container.childNodes[k] !== nodeExpect) {
										container.insertBefore(nodeExpect, container.childNodes[k] || null);
									}
								}
							}
							dui.queueNextFrameTick(() => {
								dui.layoutHand();
								setTimeout(() => {
									ui._autoPaixuSorting = false;
								}, 0);
							}, dui);
							ui._autoPaixuLastCount = game.me.node.handcards1.childNodes.length || 0;
							ui._autoPaixuSuppressOnce = true;
						}
					}, 180);
				});
				ui._autoPaixuObserver.observe(container, { childList: true, subtree: true });
				if (ui._autoPaixuKeeper)
					try {
						clearInterval(ui._autoPaixuKeeper);
					} catch (e) { }
				ui._autoPaixuKeeper = setInterval(() => {
					if (!ui._autoPaixuEnabled) return;
					if (!game.me || !game.me.node) return;
					const cur = game.me.node.handcards1;
					if (!cur) return;
					if (cur !== ui._autoPaixuContainer) {
						ui._autoPaixuContainer = cur;
						ui._autoPaixuLastCount = cur.childNodes.length || 0;
						try {
							ui._autoPaixuObserver.disconnect();
						} catch (e) { }
						ui._autoPaixuObserver.observe(cur, { childList: true, subtree: true });
					}
					const nowCount = cur.childNodes.length || 0;
					if (nowCount !== ui._autoPaixuLastCount) {
						const prev = ui._autoPaixuLastCount;
						ui._autoPaixuLastCount = nowCount;
						if (nowCount > prev && !ui._autoPaixuSorting) {
							if (ui._autoPaixuSuppressOnce) {
								ui._autoPaixuSuppressOnce = false;
							} else
								setTimeout(() => {
									plugin.click.paixu();
								}, 120);
						}
					}
				}, 600);
				plugin.click.paixu();
			},
			stopAutoPaixu() {
				if (ui._autoPaixuObserver) {
					try {
						ui._autoPaixuObserver.disconnect();
					} catch (e) { }
					ui._autoPaixuObserver = null;
				}
				if (ui._autoPaixuDebounce) {
					clearTimeout(ui._autoPaixuDebounce);
					ui._autoPaixuDebounce = null;
				}
				if (ui._autoPaixuKeeper) {
					try {
						clearInterval(ui._autoPaixuKeeper);
					} catch (e) { }
					ui._autoPaixuKeeper = null;
				}
				ui._autoPaixuSorting = false;
				ui._autoPaixuEnabled = false;
			},
			//可点击函数（牌堆）
			paidui() {
				if (!_status.gameStarted) return;
				game.pause2();
				const cardsInfo = game.players
					.map(item => item.get("h"))
					.flat(window.Infinity)
					.concat(...ui.cardPile.childNodes)
					.concat(...ui.discardPile.childNodes)
					.map(item => ({
						name: item.name,
						suit: item.suit,
						number: item.number,
						nature: get.translation(item.nature),
						color: get.color(item),
						type: get.translation(get.type(item), "trick"),
						translate: lib.translate[item.name],
						link: item,
					}));
				let cardStatistics = {
					杀: {
						num: 0,
						type: "基本",
					},
					火杀: {
						num: 0,
						type: "基本",
					},
					雷杀: {
						num: 0,
						type: "基本",
					},
					红杀: {
						num: 0,
						type: "基本",
					},
					黑杀: {
						num: 0,
						type: "基本",
					},
					"黑桃2~9": {
						num: 0,
						type: "花色",
					},
				};
				let typeList = ["点数", "花色"];
				for (let card of cardsInfo) {
					typeList.add(card.type);
					// 统计卡牌名
					if (!cardStatistics[card.translate])
						cardStatistics[card.translate] = {
							num: 0,
							type: card.type,
						};
					// 统计花色
					if (!cardStatistics[get.translation(card.suit)])
						cardStatistics[get.translation(card.suit)] = {
							num: 0,
							type: "花色",
						};
					// 统计点数
					if (!cardStatistics[card.number])
						cardStatistics[card.number] = {
							num: 0,
							type: "点数",
						};
					if (ui.cardPile.contains(card.link)) {
						cardStatistics[card.translate].num++;
						cardStatistics[get.translation(card.suit)].num++;
						cardStatistics[card.number].num++;
						if (card.name === "sha") {
							if (card.color === "black") {
								cardStatistics["黑杀"].num++;
								if (card.suit === "spade" && card.number <= 9 && card.number >= 2) cardStatistics["黑桃2~9"].num++;
							} else if (card.color === "red") {
								cardStatistics["红杀"].num++;
							}
						}
					}
					if (card.nature) {
						if (!cardStatistics[card.nature + card.translate])
							cardStatistics[card.nature + card.translate] = {
								num: 0,
								type: card.type,
							};
						if (ui.cardPile.contains(card.link)) {
							cardStatistics[card.nature + card.translate].num++;
						}
					}
				}
				let popupContainer = ui.create.div(
					".popup-container",
					ui.window,
					{
						zIndex: 10,
						background: "rgb(0,0,0,.3)",
					},
					function () {
						this.delete(500);
						game.resume2();
					}
				);
				let statistics = ui.create.div(".card-statistics", "卡牌计数器", popupContainer);
				let statisticsTitle = ui.create.div(".card-statistics-title", statistics);
				let statisticsContent = ui.create.div(".card-statistics-content", statistics);
				typeList.forEach(item => {
					ui.create.div(statisticsTitle, "", item);
					statisticsContent[item] = ui.create.div(statisticsContent, "");
				});
				for (let i in cardStatistics) {
					let items = ui.create.div(".items");
					let item = ui.create.div(".item", i, items);
					let num = ui.create.div(".item-num", `X${cardStatistics[i].num}`, items);
					statisticsContent[cardStatistics[i].type].appendChild(items);
				}
			},
			confirm(link, target) {
				if (link === "ok") {
					ui.click.ok(target);
				} else if (link === "cancel") {
					ui.click.cancel(target);
				} else if (target.custom) {
					target.custom(link);
				}
			},
		},
		showDistanceDisplay() {
			plugin.closeDistanceDisplay();
			plugin._lastMe = game.me;
			if (game.players && game.players.length > 0) {
				game.players.forEach(player => {
					if (player !== game.me) {
						const distance = get.distance(game.me, player);
						const distanceText = distance === Infinity ? "∞" : distance.toString();
						const distanceDisplay = ui.create.div(".distance-display", `(距离:${distanceText})`, player);
						player._distanceDisplay = distanceDisplay;
					}
				});
			}
			if (plugin._distanceUpdateInterval) {
				clearInterval(plugin._distanceUpdateInterval);
			}
			plugin._distanceUpdateInterval = setInterval(() => {
				plugin.updateDistanceDisplay();
			}, 1000);
		},
		updateDistanceDisplay() {
			if (plugin._lastMe !== game.me) {
				plugin._lastMe = game.me;
				plugin.closeDistanceDisplay();
				plugin.showDistanceDisplay();
				return;
			}
			game.players.forEach(player => {
				if (player !== game.me && player._distanceDisplay) {
					const distance = get.distance(game.me, player);
					const distanceText = distance === Infinity ? "∞" : distance.toString();
					player._distanceDisplay.innerHTML = `(距离:${distanceText})`;
				}
			});
		},
		closeDistanceDisplay() {
			game.players.forEach(player => {
				if (player._distanceDisplay) {
					player._distanceDisplay.remove();
					player._distanceDisplay = null;
				}
			});
			if (plugin._distanceUpdateInterval) {
				clearInterval(plugin._distanceUpdateInterval);
				plugin._distanceUpdateInterval = null;
			}
		},
		compare: {
			type(a, b) {
				if (a === b) return 0;
				const types = ["basic", "trick", "delay", "equip"].addArray([a, b]);
				return types.indexOf(a) - types.indexOf(b);
			},
			name(a, b) {
				if (a === b) return 0;
				return a > b ? 1 : -1;
			},
			nature(a, b) {
				if (a === b) return 0;
				const nature = [undefined, "fire", "thunder"].addArray([a, b]);
				return nature.indexOf(a) - nature.indexOf(b);
			},
			suit(a, b) {
				if (a === b) return 0;
				const suit = ["diamond", "heart", "club", "spade"].addArray([a, b]);
				return suit.indexOf(a) - suit.indexOf(b);
			},
			number(a, b) {
				return a - b;
			},
		},
	};
	lib.announce.subscribe("gameStart", () => setTimeout(() => plugin.showDistanceDisplay(), 100));
	return plugin;
});
