app.import((lib, game, ui, get, ai, _status, app) => {
	// 获取势力背景图片路径接口
	function getName2BackgroundImage(group) {
		if (!group || group === "unknown") {
			return `extension/十周年UI/shoushaUI/character/images/shousha/name2_unknown.png`;
		}
		const validGroups = ["wei", "shu", "wu", "qun", "ye", "jin", "daqin", "western", "shen", "key", "Han", "qin"];
		if (!validGroups.includes(group)) {
			group = "default";
		}
		return `extension/十周年UI/shoushaUI/character/images/shousha/name2_${group}.png`;
	}

	const plugin = {
		name: "character",
		// 势力背景接口，外部可通过覆盖此方法自定义背景逻辑
		getName2BackgroundImage(group) {
			return getName2BackgroundImage(group);
		},
		filter() {
			return !["chess", "tafang"].includes(get.mode());
		},
		content(next) { },
		precontent() {
			app.reWriteFunction(lib, {
				setIntro: [
					function (args, node) {
						if (get.itemtype(node) === "player") {
							if (lib.config.touchscreen) {
								lib.setLongPress(node, plugin.click.playerIntro);
							} else if (lib.config.right_info) {
								node.oncontextmenu = plugin.click.playerIntro;
							}
							return node;
						}
					},
				],
			});
		},
		click: {
			identity(e) {
				e.stopPropagation();
				const player = this.parentNode;
				if (!game.getIdentityList) return;
				if (player.node.guessDialog) {
					player.node.guessDialog.classList.toggle("hidden");
				} else {
					const list = game.getIdentityList(player);
					if (!list) return;
					const guessDialog = ui.create.div(".guessDialog", player);
					const container = ui.create.div(guessDialog);
					lib.setScroll(guessDialog);
					player.node.guessDialog = guessDialog;
				}
			},
			playerIntro(e) {
				e.stopPropagation();
				if (plugin.playerDialog) {
					return plugin.playerDialog.show(this);
				}
				const container = ui.create.div(".popup-container.hidden", ui.window, (e) => {
					if (e.target === container) {
						container.hide();
						game.resume2();
					}
				});
				const dialog = ui.create.div(".character-dialog.popped", container);
				const blackBg1 = ui.create.div(".blackBg.one", dialog);
				const blackBg2 = ui.create.div(".blackBg.two", dialog);
				const basicInfo = ui.create.div(".basicInfo", blackBg1);
				const officalMap = {
					offical_icon_1: "士兵",
					offical_icon_2: "十夫长",
					offical_icon_3: "百夫长",
					offical_icon_4: "千夫长",
					offical_icon_5: "校尉",
					offical_icon_6: "先锋将军",
					offical_icon_7: "中军将军",
					offical_icon_8: "领军将军",
					offical_icon_9: "骠骑将军",
					offical_icon_10: "大将军",
					offical_icon_11: "大元帅",
				};
				const officalbg = ui.create.div(".offical-bg", blackBg1);
				const officalIcon = ui.create.div(".offical-icon", officalbg);
				const randomOffical = Object.keys(officalMap).randomGet();
				officalIcon.setBackgroundImage(`extension/十周年UI/shoushaUI/character/images/shousha/${randomOffical}.png`);
				ui.create.div(".offical-text", officalMap[randomOffical], officalbg);
				const fightbg = ui.create.div(".fight-bg", blackBg1);
				const rightPane = ui.create.div(".right", blackBg2);
				const mingcheng = ui.create.div(".mingcheng", basicInfo);
				const dengji = ui.create.div(".dengji", basicInfo);
				const shenglv = ui.create.div(".shenglv", fightbg);
				const taolv = ui.create.div(".shenglv", fightbg);
				const viewBusinessCard = ui.create.div(".viewBusinessCard", "查看名片", blackBg1);
				const createButton = (name, parent) => {
					if (!name || !lib.character[name]) return;
					ui.create.button(name, "character", parent, true);
				};
				container.show = function (player) {
					function createLeftPane(parent) {
						const skin = lib.config["extension_十周年UI_outcropSkin"];
						const skinClassMap = {
							shizhounian: ".left3",
							shousha: ".left2",
						};
						const cls = skinClassMap[skin] || ".left";
						return ui.create.div(cls, parent);
					}
					function createStars(container, rarity) {
						const num = { legend: 5, epic: 4, rare: 3, junk: 2 }[rarity] || 1;
						for (let i = 0; i < num; i++) ui.create.div(".item", container);
						for (let i = 0; i < 5 - num; i++) ui.create.div(".item.huixing", container);
					}
					if (!player.name2) {
						// 处理单武将情况
						let name = player.name1 || player.name;
						let name2 = player.name2;
						if (player.classList.contains("unseen") && player !== game.me) name = "unknown";
						if (player.classList.contains("unseen2") && player !== game.me) name2 = "unknown";

						let biankuang = ui.create.div(".biankuang", blackBg2);
						let leftPane = createLeftPane(biankuang);
						if (player.classList.contains("unseen") && player !== game.me) {
							biankuang.setBackgroundImage(plugin.getName2BackgroundImage("unknown"));
							leftPane.style.backgroundImage = "url('image/character/hidden_image.jpg')";
						} else {
							biankuang.setBackgroundImage(plugin.getName2BackgroundImage(player.group));
							leftPane.style.backgroundImage = player.node.avatar.style.backgroundImage;
						}
						createButton(name, leftPane.firstChild);
						createButton(name2, leftPane.firstChild);
						const biankuangname = ui.create.div(".biankuangname", biankuang);
						if (!(player.classList.contains("unseen") && player !== game.me)) {
							const xing = ui.create.div(".xing", biankuang);
							createStars(xing, game.getRarity(player.name));
						}
						biankuangname.innerHTML = get.slimName(name);
					} else {
						// 处理双将
						rightPane.style.left = "280px";
						rightPane.style.width = "calc(100% - 300px)";
						let name = player.name1 || player.name;
						let name2 = player.name2;
						let group1 = lib.character[name][1];
						let group2 = lib.character[name2][1];
						if (player.classList.contains("unseen") && player !== game.me) name = "unknown";
						if (player.classList.contains("unseen2") && player !== game.me) name2 = "unknown";

						let biankuang = ui.create.div(".biankuang", blackBg2);
						let biankuang2 = ui.create.div(".biankuang2", blackBg2);
						let leftPane = createLeftPane(biankuang);
						let leftPane2 = createLeftPane(biankuang2);
						if (player.classList.contains("unseen") && player !== game.me) {
							biankuang.setBackgroundImage(plugin.getName2BackgroundImage("unknown"));
							leftPane.style.backgroundImage = "url('image/character/hidden_image.jpg')";
						} else {
							biankuang.setBackgroundImage(plugin.getName2BackgroundImage(group1));
							leftPane.style.backgroundImage = player.node.avatar.style.backgroundImage;
						}

						if (player.classList.contains("unseen2") && player !== game.me) {
							biankuang2.setBackgroundImage(plugin.getName2BackgroundImage("unknown"));
							leftPane2.style.backgroundImage = "url('image/character/hidden_image.jpg')";
						} else {
							biankuang2.setBackgroundImage(plugin.getName2BackgroundImage(group2));
							leftPane2.setBackground(name2, "character");
						}
						createButton(name, leftPane.firstChild);
						createButton(name2, leftPane2.firstChild);
						const biankuangname = ui.create.div(".biankuangname", biankuang);
						const biankuangname2 = ui.create.div(".biankuangname2", biankuang2);
						if (!(player.classList.contains("unseen") && player !== game.me)) {
							const xing = ui.create.div(".xing", biankuang);
							createStars(xing, game.getRarity(player.name));
						}
						if (!(player.classList.contains("unseen2") && player !== game.me)) {
							const xing2 = ui.create.div(".xing", biankuang2);
							createStars(xing2, game.getRarity(player.name2));
						}
						biankuangname.innerHTML = get.slimName(name);
						biankuangname2.innerHTML = get.slimName(name2);
					}
					mingcheng.innerHTML = player.nickname || (player === game.me ? lib.config.connect_nickname : get.translation(player.name));
					dengji.innerText = `Lv：${Math.floor(Math.random() * 200 + 1)}`;
					shenglv.innerHTML = `<span style="font-size: 20px;">胜率：</span>${Math.floor(Math.random() * 100)}.${Math.floor(Math.random() * 100)}%`;
					taolv.innerHTML = `<span style="font-size: 20px;">逃率：</span>${Math.floor(Math.random() * 100)}.${Math.floor(Math.random() * 100)}%`;
					dialog.classList.add("single");
					viewBusinessCard.onclick = () => {
						const popuperContainer = ui.create.div(".popup-container", { background: "rgb(0,0,0,0)" }, ui.window);
						popuperContainer.addEventListener("click", event => {
							event.stopPropagation();
							popuperContainer.delete(200);
						});
						const bigdialog = ui.create.div(".bigdialog", popuperContainer);
						[1, 2, 3, 4].forEach(i => ui.create.div(`.kuangkuang${i}`, bigdialog));
						const shanchangArr = [1, 2, 3, 4].map(i => ui.create.div(`.shanchang${i}`, bigdialog));
						const minixingxiang = ui.create.div(".minixingxiang", bigdialog);
						const jingji = ui.create.div(".jingji", bigdialog);
						const xingbie = ui.create.div(".xingbie", bigdialog);
						const useless = ui.create.div(".useless", bigdialog);
						const useless2 = ui.create.div(".useless2", bigdialog);
						const wanjiaming = ui.create.div(
							".wanjiaming",
							bigdialog,
							player === game.me
								? lib.config.connect_nickname
								: get.translation(
									[
										"氪金抽66",
										"卡宝真可爱",
										"蒸蒸日上",
										"√卡视我如父",
										"麒麟弓免疫枸杞",
										"坏可宣（老坏批）",
										"六千大败而归",
										"开局酒古锭",
										"遇事不决刷个乐",
										"见面两刀喜相逢",
										"改名出66",
										"时代的六万五",
										"韩旭",
										"司马长衫",
										"ogx",
										"狗卡不如无名杀",
										"王八万",
										"一拳兀突骨",
										"开局送神将",
										"丈八二桃",
										"装甲车车",
										"等我喝口酒",
										"Samuri",
										"马",
										"Log-Frunki",
										"aoe银钱豹",
										"没有丈八就托管",
										"无中yyds",
										"给咸鱼鸽鸽打call",
										"小零二哟～",
										"长歌最帅了",
										"大猫有侠者之风",
										"布灵布灵❤️",
										"我爱～摸鱼🐠～",
										"小寻寻真棒",
										"呲牙哥超爱笑",
										"是俺杀哒",
										"阿七阿七",
										"祖安·灰晖是龙王",
										"吃颗桃桃好遗计",
										"好可宣✓良民",
										"藏海表锅好",
										"金乎？木乎？水乎！！",
										"无法也无天",
										"西风不识相",
										"神秘喵酱",
										"星城在干嘛？",
										"子鱼今天摸鱼了吗？",
										"阳光苞里有阳光",
										"诗笺的小裙裙",
										"轮回中的消逝",
										"乱踢jb的云野",
										"小一是不是...是不是...",
										"美羊羊爱瑟瑟",
										"化梦的星辰",
										"杰哥带你登dua郎",
										"世中君子人",
										"叹年华未央",
										"短咕咕",
										"洛天依？！",
										"黄老板是好人～",
										"来点瑟瑟文和",
										"鲨鱼配辣椒",
										"萝卜～好萝卜",
										"废城君",
										"E佬细节鬼才",
										"感到棘手要怀念谁？",
										"半价小薯片",
										"JK欧拉欧拉欧拉",
										"新年快乐",
										"乔姐带你飞",
										"12345678？",
										"缘之空",
										"小小恐龙",
										"教主：杀我！",
										"才思泉涌的司马",
										"我是好人",
										"喜怒无常的大宝",
										"黄赌毒",
										"阴间杀～秋",
										"敢于劈瓜的关羽",
										"暮暮子",
									].randomGet(1)
								)
						);
						ui.create.div(".gonghui", bigdialog, get.translation(`(${["无名杀会员", "手机三国杀会员", "三国杀ol会员", "三国杀十周年会员", "怒焰三国杀会员", "欢乐三国杀会员", "阵面对决会员"].randomGet(1)})`));
						ui.create.div(".xianhua", bigdialog, get.translation(`鲜花${Math.floor(Math.random() * 999 + 1)}`));
						ui.create.div(".jidan", bigdialog, get.translation(`鸡蛋${Math.floor(Math.random() * 999 + 1)}`));
						ui.create.div(".fenxiang", bigdialog, get.translation("分享"));
						ui.create.div(".zhanshi", bigdialog, get.translation("展示(诏令－1)"));
						const list = Object.keys(lib.character).filter(i => !lib.filter.characterDisabled(i));
						_status.characterlist = list;
						event.filterChoice = (name1, name2) => {
							const info1 = lib.character[name1];
							const info2 = lib.character[name2];
							if (!info1 || !info2) return;
							let num = 0;
							if (info1[0] === info2[0]) num++;
							if (get.infoMaxHp(info1[2]) === get.infoMaxHp(info2[2])) num++;
							if (info1[3].length === info2[3].length) num++;
							return num > 1;
						};
						let shanchang = list.randomGets(4);
						shanchangArr.forEach((element, i) => {
							const value = shanchang[i % shanchang.length];
							element.setBackground(value, "character");
						});
						const jingjitu = ["jingji1", "jingji2", "jingji3", "jingji4"];
						const xingbietu = ["xingbie1", "xingbie2"];
						useless.setBackgroundImage("extension/十周年UI/shoushaUI/character/images/shousha/useless.png");
						useless2.setBackgroundImage("extension/十周年UI/shoushaUI/character/images/shousha/useless2.png");
						if (player.classList.contains("unseen") && player !== game.me) {
							minixingxiang.style.backgroundImage = "url('image/character/hidden_image.jpg')";
						} else {
							minixingxiang.style.backgroundImage = player.node.avatar.style.backgroundImage;
						}
						jingji.setBackgroundImage(`extension/十周年UI/shoushaUI/character/images/shousha/${jingjitu.randomGet()}.png`);
						xingbie.setBackgroundImage(`extension/十周年UI/shoushaUI/character/images/shousha/${xingbietu.randomGet()}.png`);
					};
					rightPane.innerHTML = "<div></div>";
					lib.setScroll(rightPane.firstChild);
					let oSkills = player.getSkills(null, false, false).slice(0);
					oSkills = oSkills.filter(skill => lib.skill[skill] && skill !== "jiu" && !lib.skill[skill].nopop && !lib.skill[skill].equipSkill && lib.translate[skill + "_info"] && lib.translate[skill + "_info"] !== "");
					if (player === game.me && player.hiddenSkills.length) oSkills.addArray(player.hiddenSkills);
					const allShown = player.isUnderControl() || (!game.observe && game.me && game.me.hasSkillTag("viewHandcard", null, player, true));
					const shownHs = player.getShownCards();
					if (shownHs.length) {
						ui.create.div(".xcaption", player.hasCard(card => !shownHs.includes(card), "h") ? "明置的手牌" : "手牌区域", rightPane.firstChild);
						shownHs.forEach(item => {
							const card = game.createCard(get.name(item, false), get.suit(item, false), get.number(item, false), get.nature(item, false));
							card.style.zoom = "0.6";
							rightPane.firstChild.appendChild(card);
						});
						if (allShown) {
							const hs = player.getCards("h");
							hs.removeArray(shownHs);
							if (hs.length) {
								ui.create.div(".xcaption", "其他手牌", rightPane.firstChild);
								hs.forEach(item => {
									const card = game.createCard(get.name(item, false), get.suit(item, false), get.number(item, false), get.nature(item, false));
									card.style.zoom = "0.6";
									rightPane.firstChild.appendChild(card);
								});
							}
						}
					} else if (allShown) {
						const hs = player.getCards("h");
						if (hs.length) {
							ui.create.div(".xcaption", "手牌区域", rightPane.firstChild);
							hs.forEach(item => {
								const card = game.createCard(get.name(item, false), get.suit(item, false), get.number(item, false), get.nature(item, false));
								card.style.zoom = "0.6";
								rightPane.firstChild.appendChild(card);
							});
						}
					}
					if (oSkills.length) {
						let captionText = "武将技能";
						const modeCaptionMap = {
							doudizhu: "武将技能·斗地主",
							identity: "武将技能·身份",
							versus: "武将技能·团战",
							single: "武将技能·1v1",
							guozhan: "武将技能·国战",
						};
						captionText = modeCaptionMap[lib.config.mode] || captionText;
						ui.create.div(".xcaption", captionText, rightPane.firstChild);
						oSkills.forEach(name => {
							const skillEnabled = get.info(name).enable;
							const skillIcon = skillEnabled ? "sp_zhu" : "sp_bei";
							const baseIcon = `<img src="extension/十周年UI/shoushaUI/character/images/shousha/${skillIcon}.png" style="width:25px;height:25px;margin-bottom:-7px;">`;
							const transparentIcon = `<img src="extension/十周年UI/shoushaUI/character/images/shousha/${skillIcon}.png" style="width:25px;height:25px;margin-bottom:-7px;opacity:0.5;">`;
							const skillName = `【${lib.translate[name]}】`;
							const skillInfo = get.skillInfoTranslation(name, player, false);

							if (player.forbiddenSkills[name]) {
								const conflict = player.forbiddenSkills[name].length ? `（与${get.translation(player.forbiddenSkills[name])}冲突）` : "（双将禁用）";
								ui.create.div(".xskill", `<div data-color><span style="opacity:0.5">${skillName}</span></div><div><span style="opacity:0.5">${conflict}${skillInfo}</span></div>`, rightPane.firstChild);
							} else if (player.hiddenSkills.includes(name)) {
								if (lib.skill[name].preHidden && get.mode() === "guozhan") {
									const id = ui.create.div(".xskill", transparentIcon + `<div data-color><span style="opacity:0.5">${skillName}</span></div><div><span style="opacity:0.5">${skillInfo}</span><br><div class="underlinenode on gray" style="position:relative;padding-left:0;padding-top:7px">预亮技能</div></div>`, rightPane.firstChild);
									const underlinenode = id.querySelector(".underlinenode");
									if (_status.prehidden_skills.includes(name)) underlinenode.classList.remove("on");
									underlinenode.link = name;
									underlinenode.listen(ui.click.hiddenskill);
								} else {
									ui.create.div(".xskill", transparentIcon + `<div data-color><span style="opacity:0.5">${skillName}</span></div><div><span style="opacity:0.5">${skillInfo}</span></div>`, rightPane.firstChild);
								}
							} else if (!player.getSkills().includes(name) || player.awakenedSkills.includes(name)) {
								ui.create.div(".xskill", transparentIcon + `<div data-color><span style="opacity:0.5">${skillName}</span></div><div><span style="opacity:0.5">${skillInfo}</span></div>`, rightPane.firstChild);
							} else if (lib.skill[name].frequent || lib.skill[name].subfrequent) {
								const id = ui.create.div(".xskill", baseIcon + `<div data-color>${skillName}</div><div>${skillInfo}<br><div class="underlinenode on gray" style="position:relative;padding-left:0;padding-top:7px">自动发动</div></div>`, rightPane.firstChild);
								const underlinenode = id.querySelector(".underlinenode");

								// 处理自动技能开关状态
								const shouldDisable = (lib.skill[name].frequent && lib.config.autoskilllist.includes(name)) || (lib.skill[name].subfrequent && lib.skill[name].subfrequent.some(sub => lib.config.autoskilllist.includes(name + "_" + sub)));
								if (shouldDisable) underlinenode.classList.remove("on");

								underlinenode.link = name;
								underlinenode.listen(ui.click.autoskill2);
							} else if (lib.skill[name].clickable && player.isIn() && player.isUnderControl(true) && player === game.me) {
								const id = ui.create.div(".xskill", baseIcon + `<div data-color>${skillName}</div><div>${skillInfo}<br><div class="menubutton skillbutton" style="position:relative;margin-top:5px;color: rgba(255, 203, 0, 1);">点击发动</div></div>`, rightPane.firstChild);
								const intronode = id.querySelector(".skillbutton");

								if (!_status.gameStarted || (lib.skill[name].clickableFilter && !lib.skill[name].clickableFilter(player))) {
									intronode.classList.add("disabled");
									intronode.style.opacity = 0.5;
								} else {
									intronode.link = player;
									intronode.func = lib.skill[name].clickable;
									intronode.classList.add("pointerdiv");
									intronode.listen(() => {
										container.hide();
										game.resume2();
									});
									intronode.listen(ui.click.skillbutton);
								}
							} else {
								ui.create.div(".xskill", baseIcon + `<div data-color>${skillName}</div><div>${skillInfo}</div>`, rightPane.firstChild);
							}
						});
					}
					const eSkills = player.getCards("e");
					if (eSkills.length) {
						ui.create.div(".xcaption", "装备区域", rightPane.firstChild);
						eSkills.forEach(card => {
							const cards = card.cards;
							let isQiexie = card.name.startsWith("qiexie_");
							let displayName = card.name + "_info";
							let str = [get.translation(isQiexie ? card.name : card), get.translation(displayName)];
							if (Array.isArray(cards) && cards.length) {
								str[0] += `（${get.translation(card.cards)}）`;
							}
							if (lib.card[card.name]?.cardPrompt) {
								str[1] = lib.card[card.name].cardPrompt(card, player);
							}
							if (isQiexie && lib.translate[card.name + "_append"]) {
								str[1] += `<br><br><div style="font-size: 0.85em; font-family: xinwei; line-height: 1.2;">${lib.translate[card.name + "_append"]}</div>`;
							}
							ui.create.div(".xskill", `<div data-color>${str[0]}</div><div>${str[1]}</div>`, rightPane.firstChild);
						});
					}
					const judges = player.getCards("j");
					if (judges.length) {
						ui.create.div(".xcaption", "判定区域", rightPane.firstChild);
						judges.forEach(card => {
							const cards = card.cards;
							let str = [get.translation(card), get.translation(card.name + "_info")];
							if ((Array.isArray(cards) && cards.length && !lib.card[card]?.blankCard) || player.isUnderControl(true)) str[0] += `（${get.translation(cards)}）`;
							ui.create.div(".xskill", `<div data-color>${str[0]}</div><div>${str[1]}</div>`, rightPane.firstChild);
						});
					}
					container.classList.remove("hidden");
					if (!lib.config["extension_十周年UI_viewInformationPause"]) game.pause2();
				};
				plugin.characterDialog = container;
				container.show(this);
			},
		},
	};
	return plugin;
});
