---
position: 5
sidebar_position: 5
id: ldap_setting
title: LDAP 配置
---

:::info 简介

1. 为了方便用户使用 Dinky 并与公司内部的用户进行集成时，Dinky 提供了LDAP配置。并支持可视化配置，修改后会自动生效，无需重启
   Dinky 服务。
2. 同时实现了LDAP用户导入功能，开启后，当用户使用LDAP登录时，如果没有相应的Dinky用户映射，则会自动拉取LDAP信息创建一个Dinky用户与之映射。如果关闭此功能，对于未导入的LDAP用户将无法登录。

:::

## 1. 什么是LDAP？

LDAP（轻量级目录访问协议）是一种用于访问和维护分布式目录服务信息的开放标准协议。
它提供了一种结构化的方式来存储、查询和修改目录中的数据，如用户、组织和设备等信息。
LDAP广泛应用于企业、组织和网络中，提供了高效、安全和可扩展的身份验证和访问控制机制。

## 2. 为什么使用LDAP

首先，当涉及到存储和管理大量用户、组织和设备等信息时，我们需要一种高效、可靠且安全的方式来完成这个任务。
这就是为什么使用LDAP（轻量级目录访问协议）的原因。
其次，除了存储和管理信息，LDAP还有一个重要功能，即为不同系统之间提供统一的访问认证服务。
当一个组织中有多个应用程序或系统时，每个系统都需要自己的用户账户和密码来进行身份验证。
这对于用户来说可能会非常不便，因为他们需要记住多个不同的账户信息。同时，对于系统管理员来说，管理和维护这些账户也是一项复杂的任务。
LDAP通过提供统一的身份验证服务来解决这个问题。
组织可以将所有用户的账户信息存储在LDAP目录中，而不是每个系统都单独维护账户信息。
这意味着用户只需要记住一个账户和密码，就可以访问所有连接到LDAP的系统。

## 3. Dinky与LDAP对接

:::danger 注意

1. 当你需要配置此功能时, 默认你已经了解LDAP的相关知识, 并且已经在你的公司内部搭建了LDAP服务, 并且你已经拥有了LDAP管理员账号,
   或者有权限查询列表的ldap用户。
2. 请确保你的LDAP服务已经正常运行, 并且你的LDAP服务可以被Dinky服务所连接。
3. 如果对接LDAP失败, 请检查你的LDAP服务是否正常运行, 并且检查你的LDAP服务是否可以被Dinky服务所连接。
4. 如果不懂如何配置LDAP/根本不了解LDAP, 请自己百度/谷歌/..., 或者联系你们公司的LDAP管理员。

:::

### 3.1 系统要求

在与我们的系统对接LDAP之前，请确保系统满足以下要求：

- 已经安装和配置LDAP服务器
- 确保系统网络连接正常
- 拥有ldap管理员，或者有权限查询列表的ldap用户

### 3.2 配置LDAP连接

首先进入**配置中心** > **全局配置** > **LDAP设置**，对参数配置进行修改即可。

:::tip 提示

1. 所有参数配置完成之后, 请动动你的小手点一下 `测试链接`, 如果提示 `连接成功`, 则表示你的LDAP配置成功,
   否则请检查你的LDAP服务是否正常运行, 并且检查你的LDAP服务是否可以被Dinky服务所连接。
2. 可以点击 Dinky 提供的 `测试登录` 按钮测试`登录功能`是否正常。
3. 可以点击 `导入用户` 按钮, 导入LDAP用户到Dinky中。

:::

**参数配置说明:**

| 参数名称         | 参数说明                                                                                    | 默认值           |
|:-------------|:----------------------------------------------------------------------------------------|:--------------|
| LDAP 服务地址    | ldap认证服务地址，例如：ldap://192.168.111.1:389                                                  |               |
| 登录用户名（DN）    | 用于连接ldap服务的用户名，或者管理员DN，例如：cn=admin,dc=jakehu,dc=mez                                     |               |
| 登录密码         | 用于连接ldap服务的密码                                                                           |               |
| 连接超时         | 连接ldap服务的最大时间，超过则断开                                                                     |               |
| 用户基础DN       | Dinky会在此基础dn下进行用户搜索,例如：ou=users,dc=dinky,dc=com                                         |               |
| 用户过滤规则       | 使用ldap的filter语法进行用户过滤，例如: (&(objectClass=inetOrgPerson))                                |               |
| 登录时自动映射用户    | 开启后，当用户使用LDAP登录时，如果没有相应的Dinky用户映射，则会自动拉取LDAP信息创建一个Dinky用户与之映射。如果关闭此功能，对于未导入的LDAP用户将无法登录 | true          |
| LDAP导入默认租户编码 | 开启自动导入用户后，新用户登录需要一个默认的租户编码，否则无法登录,请注意租户编码必须在Dinky中存在                                    | DefaultTenant |
| LDAP用户名字段    | 需要填写一个LDAP中用户的属性字段来与Dinky用户对应，必须填写，一般可选为 cn 或者 uid 表示用户唯一标识                             |               |
| LDAP昵称字段     | 需要填写一个LDAP中用户的属性字段来与Dinky昵称对应，必须填写，一般可选为 sn 或者其他标识，不要求唯一                                |               |
| 是否启用 LDAP    | 开启LDAP登录功能，开启前请先填写上面配置并确保正确配置,请最后修改此项配置                                                 | false         |