---
sidebar_position: 1
position: 1
id: job_overview
title: 任务总览
---
:::info 简介

运维中心包括 FlinkSQL 任务运维、FlinkJar 任务运维.

在运维中心，您可以查看作业实例运行详情，针对任务的关键指标查看，集群信息，作业快照，异常信息，作业日志，配置信息，FlinkSQL，SQL
血缘，历史版本，告警记录。

以便全方位的了解 Flink 任务的运行情况，及时发现问题，解决问题。

请注意: 目前只针对于 Flink 任务进行运维管理, 普通 DB SQL 任务暂不支持.
:::

## 任务总览

![devops_overview](http://pic.dinky.org.cn/dinky/docs/zh-CN/user_guide/devops_center/devops_overview.png)

- 可以点击 `指标卡片` 进行筛选对应状态下的任务,如 `运行中`, `已取消`, `异常作业`, `重启中`, `已完成`, `未知作业`
- 在此页面内,可以直观的看到 Flink 任务的运行状态. 生命周期,及任务耗时等信息.
- 在列表区 右上角可以进行筛选任务所属的`生命周期`
- 如上图所示.子表格中展示的是 `该任务名称所有的历史任务`,可以按需查看历史任务的详情信息.可以点击作业名称左侧的小图标进行打开/关闭
- 如果您需要查看某个任务的详情,可以点击操作栏的 `小眼睛图标` 进行查看[任务详情](job_details)

## 指标说明


| 指标名称                | 说明         | 是否可筛选 | 备注                                          |
| ----------------------- | ------------ | ---------- | --------------------------------------------- |
| 总计                    | 总计任务数   | 是         | 包括所有产生运行记录的作业,点击可查看所有作业 |
| 批作业                  | 批作业数     | 否         | Flink 批作业                                  |
| 流作业                  | 流作业数     | 否         | Flink 流作业                                  |
| 运行中<br/>(RUNNING)    | 运行中任务数 | 是         |                                               |
| 已取消<br/>(CANCELED)   | 已取消任务数 | 是         |                                               |
| 异常作业<br/>(FAILED)   | 异常作业数   | 是         |                                               |
| 重启中<br/>(RESTARTING) | 重启中任务数 | 是         |                                               |
| 已完成<br/>(FINISHED)   | 已完成任务数 | 是         |                                               |
| 未知作业<br/>(UNKNOWN)  | 未知作业数   | 是         |                                               |

## 状态值说明


| 状态值                  | 说明                                                                                                                                                                                                               | 是否与 Flink 状态对应 | 对应 Flink 状态值 | 是否可筛选 | 备注                                                                          |
| ----------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | --------------------- | ----------------- | ---------- | ----------------------------------------------------------------------------- |
| 运行中<br/>(RUNNING)    | 任务正在运行                                                                                                                                                                                                       | 是                    | RUNNING           | 是         | 点击`运行中` 卡片即可筛选                                                     |
| 已取消<br/>(CANCELED)   | 任务被取消                                                                                                                                                                                                         | 是                    | CANCELED          | 是         | 点击`已取消` 卡片即可筛选                                                     |
| 异常作业<br/>(FAILED)   | 任务异常                                                                                                                                                                                                           | 是                    | FAILED            | 是         | 点击`异常作业` 卡片即可筛选                                                   |
| 重启中<br/>(RESTARTING) | 任务正在重启                                                                                                                                                                                                       | 是                    | RESTARTING        | 是         | 点击`重启中` 卡片即可筛选                                                     |
| 已完成<br/>(FINISHED)   | 任务已完成                                                                                                                                                                                                         | 是                    | FINISHED          | 是         | 点击`已完成` 卡片即可筛选                                                     |
| 未知作业<br/>(UNKNOWN)  | 任务状态未知 ,产生原因是由于 Dinky 访问不到任务所在的 JobManager 了,导致无法获取任务状态                                                                                                                           | 否                    |                   | 是         | 点击`未知作业` 卡片即可筛选<br/>Dinky 内部定义的状态值, 不会与 Flink 状态对应 |
| 重连<br/>(RECONNECTING) | 任务正在重连,此状态产生原因是由于 Dinky 访问不到任务所在的 JobManager 了,导致无法获取任务状态,会进行一定次数/时间的 尝试重连,在此期间内,任务状态为`重连`, 如果超过指定次数/时间则直接状态变更为`未知作业(UNKNOWN)` | 否                    |                   | 是         | Dinky 内部定义的状态值, 不会与 Flink 状态对应                                 |
