---
position: 2
sidebar_position: 2
id: alert_instance
title: 告警实例
---


:::warning 触发告警前提条件

1. 只适用于 `FlinkSQL,FlinkJar` 任务
2. 作业为`已发布`状态
3. 满足告警策略,且该告警策略关联了告警模板

:::

目前Dinky支持的告警方式有：

- **[钉钉](#钉钉)告警 :** WebHook
- **[企业微信](#企业微信)告警 :** 包含 **应用(支持配置代理url)** **群聊**
- **[飞书](#飞书)告警 :** WebHook
- **[邮箱](#邮箱)告警 :**  通过邮件发送报警通知
- **[短信](#短信)告警 :**  通过短信发送报警通知,目前支持 阿里云短信 和 腾讯云短信
- **[Http](#http)告警 :**  通过Http Url 发送报警通知

## 报警实例列表

![alert_instance_list](http://pic.dinky.org.cn/dinky/docs/test/alert_list.png)

## 参数解读

### 公共配置项

|  字段  |                                        说明                                        | 是否必填 | 默认值  | 示例 |
|:----:|:--------------------------------------------------------------------------------:|:----:|:----:|:--:|
|  名称  |                                   告警实例名称,需要唯一                                    |  是   |  无   | 无  |
|  类型  | WeChat(App/群聊)<br/> DingTalk<br/> FeiShu<br/> Email<br/> Http <br/> Sms(阿里云/腾讯云) |  是   |  无   | 无  |
| 是否启用 |           已启用<br/> 已禁用 <br/> 注意:禁用后报警实例不能被告警组所关联, 且关联的报警组下的该实例无法发送告警信息           |  是   | true | 无  |

### 钉钉

|     字段     |             说明             | 是否必填 |  默认值  |  示例   |
|:----------:|:--------------------------:|:----:|:-----:|:-----:|
| WebHook 地址 |          钉钉机器人地址           |  是   |   无   |   无   |
|    关键词     | 自定义关键词,当创建机器人时指定了关键词策略时才生效 |  否   |   无   | Dinky |
|     密令     | 钉钉机器人密令,当创建机器人时指定了加签策略时才生效 |  否   |   无   |   无   |
|   是否启用代理   |           是否启用代理           |  否   | false |   无   |
|    代理地址    |       代理地址,仅当启用代理时生效       |  是   |   无   |   无   |
|    代理端口    |       代理端口,仅当启用代理时生效       |  是   |   无   |   无   |
|    用户名     |      代理用户名,仅当启用代理时生效       |  是   |   无   |   无   |
|     密码     |       代理密码,仅当启用代理时生效       |  是   |   无   |   无   |
|   是否@所有人   |           是否@所有人           |  否   | false |   无   |
|    手机号码    | 手机号码,支持多个,按需添加 ,未启用@全部时必填  |  是   |   无   |   无   |

**说明:** 自定义机器人发送消息时，在“被@手机号”里面的人员收到该消息时，会有@消息提醒。

[钉钉-开发者文档](https://open.dingtalk.com/document/robots/custom-robot-access)

### 企业微信

#### 微信企业应用配置

![alert_instance_wechat_app](http://pic.dinky.org.cn/dinky/docs/test/alert_instance_wechat_app.png)

|   字段   |                                         说明                                         | 是否必填 |  默认值  | 示例 |
|:------:|:----------------------------------------------------------------------------------:|:----:|:-----:|:--:|
|  发送方式  |                                发送方式，支持应用和群聊,此为 App                                 |  是   |   无   | 无  |
|  企业Id  |                                   企业Id,需要联系管理员获取                                   |  是   |   无   | 无  |
|   密令   |                                  应用的密令，需要联系管理员获取                                   |  是   |   无   | 无  |
|  代理ID  |                                   代理ID,需要联系管理员获取                                   |  是   |   无   | 无  |
| 企微发送地址 | 企微发送地址，默认为:https://qyapi.weixin.qq.com/cgi-bin 可以支持代理url,如：https://ip:port/cgi-bin |      |   是   | 无  |   无   |
| 是否@所有人 |                                       是否@所有人                                       |  否   | false | 无  |
|  @用户   |                      当启用@所有人时,此处填写企业微信用户名,可以联系管理员获取/自行查看个人信息                       |  是   |   无   | 无  |

**说明:** @所有人与被@用户可相互切换

#### 微信企业群聊配置

![create_wechat_chat_alert](http://pic.dinky.org.cn/dinky/docs/test/alert_instance_wechat_chat.png)

|     字段     |                   说明                    | 是否必填 |  默认值  | 示例 |
|:----------:|:---------------------------------------:|:----:|:-----:|:--:|
| WebHook 地址 |               WebHook 地址                |  是   |   无   | 无  |
|    关键词     |       自定义关键词，当创建机器人时指定了关键词策略时才生效        |  否   |   无   | 无  |
|     密令     |             应用的密令，需要联系管理员获取             |  是   |   无   | 无  | 
|   是否@所有人   |                 是否@所有人                  |  否   | false | 无  |
|    @用户     | 当启用@所有人时,此处填写企业微信用户名,可以联系管理员获取/自行查看个人信息 |  是   |   无   | 无  |

**说明:** @所有人与被@用户可相互切换

其中发送方式分别对应企微文档：

[应用-开发者文档](https://work.weixin.qq.com/api/doc/90000/90135/90236)  
[群聊-开发者文档](https://work.weixin.qq.com/api/doc/90000/90135/90248)

### 飞书

![create_feishu_alert](http://pic.dinky.org.cn/dinky/docs/test/alert_instance_feishu.png)

|     字段     |             说明             | 是否必填 |  默认值  |  示例   |
|:----------:|:--------------------------:|:----:|:-----:|:-----:|
| WebHook 地址 |          飞书机器人地址           |  是   |   无   |   无   |
|    关键词     | 自定义关键词,当创建机器人时指定了关键词策略时才生效 |  否   |   无   | Dinky |
|     密令     | 钉钉机器人密令,当创建机器人时指定了加签策略时才生效 |  否   |   无   |   无   |
|   是否启用代理   |           是否启用代理           |  否   | false |   无   |
|    代理地址    |       代理地址,仅当启用代理时生效       |  是   |   无   |   无   |
|    代理端口    |       代理端口,仅当启用代理时生效       |  是   |   无   |   无   |
|    用户名     |      代理用户名,仅当启用代理时生效       |  是   |   无   |   无   |
|     密码     |       代理密码,仅当启用代理时生效       |  是   |   无   |   无   |
|   是否@所有人   |           是否@所有人           |  否   | false |   无   |
|    @用户     |     当启用@所有人时,此处填写飞书用户名     |  是   |   无   |   无   |

**说明:** @所有人与被@用户可相互切换

[飞书-自定义机器人接入开发文档](https://open.feishu.cn/document/ukTMukTMukTM/ucTM5YjL3ETO24yNxkjN)

### 邮箱

|    字段     |              说明               | 是否必填 |  默认值  |      示例      |
|:---------:|:-----------------------------:|:----:|:-----:|:------------:|
|   邮箱地址    |             邮箱地址              |  是   |   无   |      无       |
| 邮件服务器Port |            邮件服务器端口            |  是   |   无   |      无       |
|   发送者昵称   |             发送者昵称             |  是   |   无   |      无       |
|   收件人邮箱   |             收件人邮箱             |  是   |   无   |      无       |
|   抄送人邮箱   |             抄送人邮箱             |  是   |   无   |      无       |
| 是否开启邮箱验证  |           是否开启邮箱验证            |  否   | false |      无       |
|   邮箱用户名   |             邮箱用户名             |  是   |   无   |      无       |
|   邮箱密码    |  邮箱密码 ,注意:部分邮箱需要自行获取授权码而非密码   |  是   |   无   |      无       |
|  开启tls证书  |            开启tls证书            |  否   | false |      无       |
|   开启SSL   |            开启SSL证书            |  否   | false |      无       |
|   受信任域   | 如果开启了SSL，必填(一半情况和邮箱服务器保持一致即可) |  是   |   无   | stmp.126.com |

### 短信

#### 公共配置项

|       字段        |                                   说明                                   | 是否必填 |                              默认值                              | 示例 |
|:---------------:|:----------------------------------------------------------------------:|:----:|:-------------------------------------------------------------:|:--:|
|      短信服务商      |                            短信服务商,支持阿里云和腾讯云                             |  是   |                               无                               | 无  |
|   AccessKeyId   |                              AccessKeyId                               |  是   |                               无                               | 无  |
| AccessKeySecret |                            AccessKeySecret                             |  是   |                               无                               | 无  |
|      短信签名       |                      短信签名，阿里云可以使用默认的签名，腾讯云需要自行申请                       |  是   |                               无                               | 无  |
|     短信模版ID      |                              短信模版ID，自行申请                               |  是   |                               无                               | 无  |
|       权重        |                                  告警权重                                  |  是   |                               1                               | 无  |
|     重试间隔时间      |                               重试间隔时间，单位秒                               |  是   |                               5                               | 无  |
|     最大重试次数      |                                 最大重试次数                                 |  是   |                               5                               | 无  |
|      请求地址       | 请求地址<br/>阿里云使用:dysmsapi.aliyuncs.com <br/>腾讯云使用sms.tencentcloudapi.com |  是   | 阿里云使用:dysmsapi.aliyuncs.com <br/>腾讯云使用sms.tencentcloudapi.com | 无  |   
|      地域信息       |                              地域信息,以实际情况选择                              |  是   |                               无                               | 无  |
|      手机号码       |                                  手机号码                                  |  是   |                               无                               | 无  |

#### 阿里云

> 同 公共配置项

#### 腾讯云

> 仅列出差异项

|    字段    |    说明    | 是否必填 | 默认值 | 示例 |
|:--------:|:--------:|:----:|:---:|:--:|
| SdkAppId | SdkAppId |  是   |  无  | 无  |
|  请求超时时间  |  请求超时时间  |  是   |  无  | 无  |

**说明:** 短信服务商目前支持阿里云和腾讯云,短信模版ID需要自行在短信服务商申请,部分差异字段自行查找相关文档及其值

[短信开发文档](https://sms4j.com/doc3/)

### Http

|  字段  |                                                说明                                                 | 是否必填 | 默认值 | 示例 |
|:----:|:-------------------------------------------------------------------------------------------------:|:----:|:---:|:--:|
| 请求方式 |                                            请求方式,支持POST                                            |  是   |  无  | 无  |
| 请求地址 |                                               请求地址                                                |  是   |  无  | 无  |
| 请求头  |                                           请求头 , 以列表形式填写                                           |  是   |  无  | 无  |
| 内容字段 |       在http请求中，请求体(body)内被替换为`告警消息`的字段，如果涉及多层嵌套字段，请使用json path表达式，例如 text.markdown.content        |  是   |  无  | 无  |
| 标题字段 | 在http请求中，请求体(body)内被替换为`标题内容`的字段，如果涉及多层嵌套字段，请使用json path表达式，例如 markdown.title，如果不填写，则标题默认拼接在内容字段中 |  是   |  无  | 无  |
| 请求体  |                                             支持json格式                                              |  是   |  无  | 无  |

