/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import { l } from '@/utils/intl';

export const QUICK_GUIDE = [
  {
    key: 'clusterInstance',
    label: l('datastudio.middle.qg.clusterInstance'),
    link: '/registration/cluster/instance'
  },
  {
    key: 'clusterConfiguration',
    label: l('datastudio.middle.qg.clusterConfiguration'),
    link: '/registration/cluster/config'
  },
  {
    key: 'database',
    label: l('datastudio.middle.qg.database'),
    link: '/registration/datasource/list'
  },
  {
    key: 'alertInstance',
    label: l('datastudio.middle.qg.alertInstance'),
    link: '/registration/alert/instance'
  },
  {
    key: 'alertGroup',
    label: l('datastudio.middle.qg.alertGroup'),
    link: '/registration/alert/group'
  },
  {
    key: 'alertRule',
    label: l('datastudio.middle.qg.alertRule'),
    link: '/registration/alert/rule'
  },
  {
    key: 'alertTemplate',
    label: l('datastudio.middle.qg.alertTemplate'),
    link: '/registration/alert/template'
  },
  {
    key: 'rootLog',
    label: l('datastudio.middle.qg.rootLog'),
    link: '/settings/systemlog'
  },
  {
    key: 'globalsetting',
    label: l('datastudio.middle.qg.globalsetting'),
    link: '/settings/globalsetting'
  },
  {
    key: 'fragment',
    label: l('datastudio.middle.qg.fragment'),
    link: '/registration/fragment'
  },
  {
    key: 'document',
    label: l('datastudio.middle.qg.document'),
    link: '/registration/document'
  },
  {
    key: 'gitprojects',
    label: l('datastudio.middle.qg.gitprojects'),
    link: '/registration/gitproject'
  },
  {
    key: 'udf',
    label: l('datastudio.middle.qg.udf'),
    link: '/registration/udf'
  },
  {
    key: 'resource',
    label: l('datastudio.middle.qg.resource'),
    link: '/registration/resource'
  },
  {
    key: 'accountCenter',
    label: l('datastudio.middle.qg.accountCenter'),
    link: '/account/center'
  }
];
