/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

const defaultSvgSize = '100%';

export const Congratulations = (props: { size?: number }) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        component={() => (
          <svg viewBox='0 0 1024 1024' version='1.1' width={size} height={size}>
            <path
              d='M618.112 198.72m-15.084945-15.084945a21.333333 21.333333 0 1 0 30.16989 30.16989 21.333333 21.333333 0 1 0-30.16989-30.16989Z'
              fill='#1A1F23'
              p-id='1549'
            ></path>
            <path
              d='M286.421333 280.981333m-15.084944-15.084944a21.333333 21.333333 0 1 0 30.169889 30.169889 21.333333 21.333333 0 1 0-30.169889-30.169889Z'
              fill='#1A1F23'
              p-id='1550'
            ></path>
            <path
              d='M835.328 415.936m-15.084945-15.084945a21.333333 21.333333 0 1 0 30.16989 30.16989 21.333333 21.333333 0 1 0-30.16989-30.16989Z'
              fill='#1A1F23'
              p-id='1551'
            ></path>
            <path
              d='M750.250667 744.810667m-15.084945-15.084945a21.333333 21.333333 0 1 0 30.169889 30.169889 21.333333 21.333333 0 1 0-30.169889-30.169889Z'
              fill='#1A1F23'
              p-id='1552'
            ></path>
            <path
              d='M809.6 227.2l35.818667 21.482667a10.666667 10.666667 0 0 1 0 18.304l-35.797334 21.482666a10.666667 10.666667 0 0 0-3.669333 3.648l-21.482667 35.818667a10.666667 10.666667 0 0 1-18.304 0l-21.461333-35.818667a10.666667 10.666667 0 0 0-3.669333-3.648l-35.797334-21.482666a10.666667 10.666667 0 0 1 0-18.304l35.797334-21.482667a10.666667 10.666667 0 0 0 3.669333-3.648l21.461333-35.797333a10.666667 10.666667 0 0 1 18.304 0l21.482667 35.797333a10.666667 10.666667 0 0 0 3.648 3.648zM442.346667 126.4L465.28 161.28a10.666667 10.666667 0 0 1-7.936 16.469333l-41.6 3.797334a10.666667 10.666667 0 0 0-4.864 1.706666l-34.922667 22.912a10.666667 10.666667 0 0 1-16.469333-7.957333l-3.797333-41.578667a10.666667 10.666667 0 0 0-1.706667-4.885333L331.093333 116.864a10.666667 10.666667 0 0 1 7.936-16.469333l41.6-3.797334a10.666667 10.666667 0 0 0 4.864-1.706666l34.901334-22.912a10.666667 10.666667 0 0 1 16.490666 7.957333l3.776 41.578667c0.170667 1.749333 0.746667 3.413333 1.706667 4.885333zM926.762667 660.650667l-7.808 41.024a10.666667 10.666667 0 0 1-17.173334 6.293333l-32.512-26.197333a10.666667 10.666667 0 0 0-4.693333-2.154667l-41.024-7.829333a10.666667 10.666667 0 0 1-6.293333-17.173334l26.197333-32.512a10.666667 10.666667 0 0 0 2.176-4.693333l7.808-41.002667a10.666667 10.666667 0 0 1 17.173333-6.314666l32.512 26.197333a10.666667 10.666667 0 0 0 4.693334 2.176l41.002666 7.808a10.666667 10.666667 0 0 1 6.314667 17.173333l-26.197333 32.512a10.666667 10.666667 0 0 0-2.176 4.693334zM531.904 741.653333l-212.181333-212.16-141.44 353.6 353.6-141.44z'
              fill='#FB1717'
              p-id='1553'
            ></path>
            <path
              d='M429.354667 774.826667l10.154666-108.224a10.666667 10.666667 0 0 1 15.552-8.469334l63.957334 33.28a10.666667 10.666667 0 0 1 5.696 10.517334l-6.826667 68.010666a10.666667 10.666667 0 0 1-9.514667 9.557334l-67.306666 6.912a10.666667 10.666667 0 0 1-11.712-11.605334z'
              fill='#FB9E17'
              p-id='1554'
            ></path>
            <path
              d='M255.914667 876.437333l32-384-42.496-3.541333-32 384 42.496 3.541333z m106.837333-291.626666l-21.333333 245.333333 42.496 3.712 21.333333-245.333333-42.496-3.712zM691.370667 341.802667a21.333333 21.333333 0 0 1 0 30.165333l-196.117334 196.096a21.333333 21.333333 0 0 1-30.165333-30.165333l196.096-196.096a21.333333 21.333333 0 0 1 30.186667 0zM434.346667 224a21.333333 21.333333 0 0 1 27.84 11.605333c28.096 68.202667 28.586667 125.824 15.936 172.117334A226.474667 226.474667 0 0 1 419.84 507.733333a21.333333 21.333333 0 0 1-30.186667-30.165333 183.765333 183.765333 0 0 0 47.317334-81.045333c10.005333-36.672 10.474667-84.650667-14.229334-144.64a21.333333 21.333333 0 0 1 11.605334-27.861334zM799.850667 592.213333a21.333333 21.333333 0 0 0-13.44-27.029333c-128.597333-43.221333-220.224 19.84-262.293334 61.930667a21.333333 21.333333 0 0 0 30.165334 30.165333c36.16-36.16 111.530667-87.616 218.56-51.669333a21.333333 21.333333 0 0 0 27.008-13.418667z'
              fill='#1A1F23'
              p-id='1555'
            ></path>
            <path
              d='M592.512 246.144a21.333333 21.333333 0 0 1 13.504 26.965333l-30.186667 90.517334a21.333333 21.333333 0 0 1-40.469333-13.482667l30.165333-90.517333a21.333333 21.333333 0 0 1 26.986667-13.482667z m194.517333 194.496a21.333333 21.333333 0 0 1-13.504 26.986667l-90.496 30.165333a21.333333 21.333333 0 0 1-13.504-40.469333l90.517334-30.165334a21.333333 21.333333 0 0 1 26.986666 13.482667zM315.029333 329.109333a21.333333 21.333333 0 0 1 26.986667 13.482667l22.613333 67.882667a21.333333 21.333333 0 1 1-40.448 13.504l-22.634666-67.882667a21.333333 21.333333 0 0 1 13.482666-26.986667z m389.034667 389.013334a21.333333 21.333333 0 0 1-26.986667 13.504l-67.882666-22.634667a21.333333 21.333333 0 1 1 13.482666-40.469333l67.882667 22.613333a21.333333 21.333333 0 0 1 13.504 26.986667z'
              fill='#FB9E17'
              p-id='1556'
            ></path>
            <path
              d='M618.112 198.72m-15.084945-15.084945a21.333333 21.333333 0 1 0 30.16989 30.16989 21.333333 21.333333 0 1 0-30.16989-30.16989Z'
              fill='#1A1F23'
              p-id='1557'
            ></path>
            <path
              d='M286.421333 280.981333m-15.084944-15.084944a21.333333 21.333333 0 1 0 30.169889 30.169889 21.333333 21.333333 0 1 0-30.169889-30.169889Z'
              fill='#1A1F23'
              p-id='1558'
            ></path>
            <path
              d='M835.328 415.936m-15.084945-15.084945a21.333333 21.333333 0 1 0 30.16989 30.16989 21.333333 21.333333 0 1 0-30.16989-30.16989Z'
              fill='#1A1F23'
              p-id='1559'
            ></path>
            <path
              d='M750.250667 744.810667m-15.084945-15.084945a21.333333 21.333333 0 1 0 30.169889 30.169889 21.333333 21.333333 0 1 0-30.169889-30.169889Z'
              fill='#1A1F23'
              p-id='1560'
            ></path>
            <path
              d='M809.6 227.2l35.818667 21.482667a10.666667 10.666667 0 0 1 0 18.304l-35.797334 21.482666a10.666667 10.666667 0 0 0-3.669333 3.648l-21.482667 35.818667a10.666667 10.666667 0 0 1-18.304 0l-21.461333-35.818667a10.666667 10.666667 0 0 0-3.669333-3.648l-35.797334-21.482666a10.666667 10.666667 0 0 1 0-18.304l35.797334-21.482667a10.666667 10.666667 0 0 0 3.669333-3.648l21.461333-35.797333a10.666667 10.666667 0 0 1 18.304 0l21.482667 35.797333a10.666667 10.666667 0 0 0 3.648 3.648zM442.346667 126.4L465.28 161.28a10.666667 10.666667 0 0 1-7.936 16.469333l-41.6 3.797334a10.666667 10.666667 0 0 0-4.864 1.706666l-34.922667 22.912a10.666667 10.666667 0 0 1-16.469333-7.957333l-3.797333-41.578667a10.666667 10.666667 0 0 0-1.706667-4.885333L331.093333 116.864a10.666667 10.666667 0 0 1 7.936-16.469333l41.6-3.797334a10.666667 10.666667 0 0 0 4.864-1.706666l34.901334-22.912a10.666667 10.666667 0 0 1 16.490666 7.957333l3.776 41.578667c0.170667 1.749333 0.746667 3.413333 1.706667 4.885333zM926.762667 660.650667l-7.808 41.024a10.666667 10.666667 0 0 1-17.173334 6.293333l-32.512-26.197333a10.666667 10.666667 0 0 0-4.693333-2.154667l-41.024-7.829333a10.666667 10.666667 0 0 1-6.293333-17.173334l26.197333-32.512a10.666667 10.666667 0 0 0 2.176-4.693333l7.808-41.002667a10.666667 10.666667 0 0 1 17.173333-6.314666l32.512 26.197333a10.666667 10.666667 0 0 0 4.693334 2.176l41.002666 7.808a10.666667 10.666667 0 0 1 6.314667 17.173333l-26.197333 32.512a10.666667 10.666667 0 0 0-2.176 4.693334zM531.904 741.653333l-212.181333-212.16-141.44 353.6 353.6-141.44z'
              fill='#FB1717'
              p-id='1561'
            ></path>
            <path
              d='M429.354667 774.826667l10.154666-108.224a10.666667 10.666667 0 0 1 15.552-8.469334l63.957334 33.28a10.666667 10.666667 0 0 1 5.696 10.517334l-6.826667 68.010666a10.666667 10.666667 0 0 1-9.514667 9.557334l-67.306666 6.912a10.666667 10.666667 0 0 1-11.712-11.605334z'
              fill='#FB9E17'
              p-id='1562'
            ></path>
            <path
              d='M268.778667 448.426667a21.333333 21.333333 0 0 1 19.370666 5.824l281.6 281.6a21.333333 21.333333 0 0 1-7.168 34.901333l-469.333333 187.733333a21.333333 21.333333 0 0 1-27.733333-27.733333l187.733333-469.333333a21.333333 21.333333 0 0 1 15.530667-12.992z m12.074666 58.88l-157.226666 393.066666 393.066666-157.226666-235.84-235.861334z'
              fill='#1A1F23'
              p-id='1563'
            ></path>
            <path
              d='M287.914667 492.437333l-32 384-42.517334-3.541333 32-384 42.517334 3.541333z m53.504 337.706667l21.333333-245.333333 42.496 3.712-21.333333 245.333333-42.496-3.712z'
              fill='#1A1F23'
              p-id='1564'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const Magic = (props: { size?: number }) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        component={() => (
          <svg viewBox='0 0 1697 1024' width={size} height={size}>
            <path
              d='M1.616842 739.085474l31.258947-50.526316c57.317053 56.212211 97.818947 91.809684 121.45179 106.765474 86.150737 54.514526 124.874105 25.6 163.516632 58.556631 25.761684 21.989053 52.493474 57.128421 80.195368 105.418105l-52.466526 48.397474c-3.341474-28.672-20.911158-58.017684-52.709053-88.037053-47.696842-45.002105-94.396632-21.611789-174.969263-72.784842-53.733053-34.142316-92.483368-70.063158-116.277895-107.789473z'
              fill='#FFBABA'
              p-id='5130'
            ></path>
            <path
              d='M673.684211 685.460211l18.782315-11.776c7.221895 33.738105 13.069474 56.023579 17.569685 66.883368 16.330105 39.558737 33.441684 37.456842 39.235368 58.394947 3.826526 13.931789 5.578105 32.983579 5.200842 57.128421l-24.872421 6.224842c4.230737-11.398737 4.230737-26.246737 0-44.517052-6.332632-27.405474-24.872421-29.184-40.124632-66.236632-10.159158-24.737684-15.413895-46.753684-15.791157-66.101894z'
              fill='#FFD600'
              p-id='5131'
            ></path>
            <path
              d='M1680.195368 596.992l-17.623579-16.653474c-16.410947 29.696-28.429474 48.990316-36.082526 57.882948-27.863579 32.498526-46.08 25.492211-57.667368 43.52-7.760842 11.991579-14.443789 29.453474-20.129684 52.331789l25.680842 13.204211c-1.751579-11.991579 1.994105-25.977263 11.210105-41.984 13.850947-23.983158 34.627368-20.183579 60.658526-50.661053 17.381053-20.291368 28.698947-39.504842 33.953684-57.667368zM245.463579 257.643789l22.366316-35.247157c76.907789 124.604632 122.610526 197.793684 137.162105 219.513263 52.924632 79.198316 23.120842 159.258947 46.484211 202.536421 15.575579 28.833684 37.025684 69.793684 64.350315 122.88l-40.097684 12.314947a1031.114105 1031.114105 0 0 0-52.224-126.248421c-28.645053-57.344 1.616842-128.215579-47.912421-202.482526a32714.401684 32714.401684 0 0 0-130.155789-193.266527z'
              fill='#A0E3FF'
              p-id='5132'
            ></path>
            <path
              d='M970.105263 27.109053L915.833263 0c-4.634947 59.203368-10.832842 97.387789-18.647579 114.553263-40.798316 89.815579-86.474105 115.738947-96.525473 135.168-47.211789 91.082105 41.606737 158.800842 24.926315 206.95579A4869.497263 4869.497263 0 0 0 781.473684 592.842105h52.385684a4566.986105 4566.986105 0 0 0 41.930106-136.165052c18.297263-63.137684-66.533053-121.586526-22.474106-206.95579 19.671579-38.076632 63.811368-55.161263 91.998316-108.705684 9.296842-17.677474 17.569684-55.646316 24.791579-113.906526z'
              fill='#D8A0FF'
              p-id='5133'
            ></path>
            <path
              d='M1127.558737 408.602947c5.712842 124.281263-34.465684 151.174737-24.441263 199.733895 6.682947 32.363789 16.249263 81.111579 28.672 146.189474h-35.84a1571.301053 1571.301053 0 0 0-16.545685-124.604632c-10.994526-63.649684 42.981053-135.221895 16.518737-221.318737 1.024 0 31.178105-9.889684 31.636211 0z'
              fill='#58FF99'
              p-id='5134'
            ></path>
            <path
              d='M1431.471158 134.736842H1482.105263c-58.745263 104.286316-81.839158 168.96-69.254737 194.101895 45.864421 91.540211-40.421053 159.582316-24.252631 207.979789 10.832842 32.282947 25.114947 77.877895 42.873263 136.865685h-69.793684c4.230737-34.573474 0.404211-73.027368-11.425685-115.334737-17.785263-63.461053 54.218105-143.710316 11.425685-229.510737-28.537263-57.209263-5.281684-121.909895 69.793684-194.101895z'
              fill='#FFD600'
              p-id='5135'
            ></path>
            <path
              d='M970.105263 700.631579m-26.947368 0a26.947368 26.947368 0 1 0 53.894737 0 26.947368 26.947368 0 1 0-53.894737 0Z'
              fill='#A0E3FF'
              p-id='5136'
            ></path>
            <path
              d='M538.947368 323.368421m-26.947368 0a26.947368 26.947368 0 1 0 53.894737 0 26.947368 26.947368 0 1 0-53.894737 0Z'
              fill='#FFBABA'
              p-id='5137'
            ></path>
            <path
              d='M1239.578947 269.473684m-26.947368 0a26.947368 26.947368 0 1 0 53.894737 0 26.947368 26.947368 0 1 0-53.894737 0Z'
              fill='#FFBABA'
              p-id='5138'
            ></path>
            <path
              d='M269.473684 673.684211m-26.947368 0a26.947368 26.947368 0 1 0 53.894737 0 26.947368 26.947368 0 1 0-53.894737 0Z'
              fill='#58FF99'
              p-id='5139'
            ></path>
            <path
              d='M1536 808.421053m-26.947368 0a26.947368 26.947368 0 1 0 53.894736 0 26.947368 26.947368 0 1 0-53.894736 0Z'
              fill='#D8A0FF'
              p-id='5140'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const WelcomePic1 = (props: { size?: number }) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        component={() => (
          <svg
            node-id='1'
            width={size}
            height={size}
            template-height='1024'
            template-width='1024'
            viewBox='0 0 1024 1024'
          >
            <defs node-id='378'>
              <clipPath id='master_svg0_45_247' node-id='3'>
                <path
                  d='M 0.00 0.00 L 1024.00 0.00 L 1024.00 1024.00 L 0.00 1024.00 Z'
                  fill='#000000'
                  fill-rule='nonzero'
                  node-id='381'
                  stroke='none'
                  target-height='1024'
                  target-width='1024'
                  target-x='0'
                  target-y='0'
                />
              </clipPath>
            </defs>
            <g node-id='1313'>
              <g clip-path='url(#master_svg0_45_247)' group-id='1' id='sillyvg_g_1' node-id='387'>
                <path
                  d='M 790.20 691.00 L 790.80 468.50 L 777.10 460.60 L 464.00 642.50 L 463.30 880.80 L 570.70 942.50 L 532.40 965.80 L 527.30 965.00 L 521.90 964.70 L 516.60 964.90 L 511.40 965.70 L 506.50 967.00 L 501.90 968.90 L 72.00 720.70 L 74.70 718.70 L 76.80 716.70 L 78.30 714.70 L 79.40 712.70 L 80.10 710.50 L 80.20 708.30 L 79.90 706.10 L 79.10 703.90 L 78.00 701.90 L 76.30 699.90 L 74.10 698.00 L 71.20 696.10 L 67.80 694.40 L 238.40 598.00 L 360.00 668.20 L 362.60 668.90 L 365.20 668.20 L 647.80 503.80 L 649.10 501.50 L 649.10 498.80 L 647.80 496.50 L 646.70 495.70 L 590.50 463.30 L 590.70 394.40 L 734.70 311.40 L 876.80 394.20 L 881.80 396.80 L 886.40 398.70 L 890.70 400.10 L 894.80 401.00 L 898.70 401.40 L 902.70 401.40 L 906.40 400.90 L 909.90 399.90 L 913.10 398.60 L 965.60 368.20 L 968.40 366.40 L 970.80 364.30 L 973.10 361.80 L 975.10 358.80 L 977.00 355.50 L 978.70 351.20 L 980.00 346.30 L 980.80 340.70 L 981.20 334.40 L 981.00 328.30 L 980.30 322.00 L 979.10 315.50 L 977.50 309.10 L 975.40 302.70 L 970.10 289.90 L 963.30 277.80 L 959.40 272.00 L 950.90 261.30 L 951.90 254.10 L 952.40 246.40 L 952.20 240.00 L 951.60 233.40 L 950.60 226.80 L 949.10 219.90 L 946.60 211.00 L 943.50 202.00 L 939.70 193.10 L 935.30 184.40 L 930.50 176.00 L 925.20 167.90 L 919.40 160.10 L 913.30 152.80 L 906.80 146.20 L 901.60 141.40 L 896.40 137.10 L 891.00 133.30 L 880.90 127.30 L 872.10 123.60 L 867.60 122.20 L 859.50 120.80 L 856.50 110.90 L 852.80 101.10 L 848.40 91.30 L 843.50 81.80 L 838.10 72.60 L 832.10 63.80 L 822.30 51.30 L 811.80 40.20 L 806.10 35.00 L 800.40 30.30 L 794.50 26.10 L 788.60 22.40 L 783.10 19.40 L 772.80 15.10 L 763.00 12.60 L 758.30 12.00 L 753.80 11.70 L 749.50 11.90 L 745.20 12.60 L 741.20 13.60 L 737.40 15.00 L 733.90 16.80 L 682.50 46.60 L 679.10 48.90 L 675.80 51.60 L 672.80 54.70 L 670.00 58.30 L 667.50 62.50 L 665.50 66.70 L 663.70 71.40 L 662.30 76.50 L 661.20 82.10 L 660.40 88.40 L 618.40 112.70 L 615.50 114.90 L 612.90 117.50 L 610.40 120.40 L 606.20 127.00 L 604.50 130.90 L 602.00 139.50 L 600.60 149.30 L 600.40 154.90 L 600.50 161.40 L 601.10 167.90 L 602.20 174.70 L 603.60 181.60 L 606.20 190.60 L 609.30 199.60 L 613.10 208.60 L 617.50 217.30 L 622.30 225.80 L 627.70 234.00 L 633.50 241.80 L 639.70 249.10 L 646.20 255.90 L 651.40 260.70 L 656.70 265.00 L 662.00 268.90 L 667.50 272.30 L 724.30 305.40 L 590.70 382.30 L 591.10 275.70 L 485.10 214.60 L 471.90 222.30 L 471.90 206.60 L 366.10 145.40 L 260.80 206.60 L 260.70 232.00 L 238.00 218.90 L 132.80 280.10 L 132.20 463.20 L 76.40 495.60 L 75.30 496.40 L 74.00 498.70 L 74.00 501.40 L 75.30 503.70 L 76.40 504.50 L 228.10 592.10 L 52.00 691.00 L 47.60 690.90 L 39.10 691.90 L 35.00 693.00 L 31.30 694.30 L 27.90 696.10 L 25.00 698.00 L 22.70 700.00 L 21.10 702.00 L 19.90 704.10 L 19.20 706.30 L 19.00 708.60 L 19.20 710.80 L 20.00 713.10 L 21.20 715.10 L 22.90 717.20 L 25.10 719.20 L 28.10 721.10 L 34.20 723.90 L 37.60 724.90 L 42.90 725.90 L 48.50 726.30 L 54.10 726.10 L 59.50 725.40 L 493.20 975.70 L 491.90 978.00 L 491.20 980.20 L 491.00 982.40 L 491.30 984.60 L 492.00 986.80 L 493.30 989.10 L 495.00 991.10 L 497.20 993.00 L 500.10 995.00 L 503.20 996.50 L 506.50 997.80 L 514.00 999.60 L 521.80 1000.20 L 525.70 1000.00 L 533.30 998.90 L 536.90 997.80 L 543.40 995.00 L 546.20 993.10 L 548.40 991.10 L 550.00 989.20 L 551.20 987.20 L 551.90 985.00 L 552.20 982.90 L 552.10 980.70 L 551.50 978.50 L 550.40 976.50 L 549.00 974.50 L 547.00 972.50 L 544.40 970.60 L 580.90 948.40 L 691.90 1012.20 L 1005.00 830.30 L 1005.00 814.60 L 790.20 691.00 Z M 485.80 336.90 L 485.60 402.70 Z M 366.70 267.80 L 366.60 293.60 Z M 89.20 500.00 L 132.10 475.10 L 132.10 504.00 L 238.00 565.10 L 238.50 413.20 L 238.10 565.10 L 251.20 557.50 L 251.20 573.10 L 357.00 634.20 L 357.60 486.70 L 357.10 634.20 L 462.30 573.10 L 462.40 547.70 L 485.10 560.70 L 485.50 414.50 L 485.20 560.70 L 590.40 499.60 L 590.50 475.10 L 633.90 500.20 L 362.60 657.80 L 89.20 500.00 Z'
                  fill='#cad0dd'
                  fill-rule='nonzero'
                  group-id='1,2'
                  node-id='391'
                  stroke='none'
                  target-height='1000.5'
                  target-width='986'
                  target-x='19'
                  target-y='11.7'
                />
                <path
                  d='M 883.40 213.70 L 888.70 222.70 L 549.80 418.30 L 544.60 409.30 L 883.40 213.70 Z M 362.60 668.90 L 360.00 668.20 L 76.40 504.50 L 75.00 503.30 L 74.10 501.70 L 73.90 500.00 L 74.10 498.30 L 75.00 496.80 L 76.40 495.60 L 359.20 331.40 L 361.80 331.40 L 363.10 332.00 L 646.70 495.70 L 648.20 496.90 L 649.00 498.40 L 649.30 500.10 L 649.00 501.80 L 648.20 503.30 L 646.70 504.60 L 365.20 668.20 L 362.60 668.90 Z M 89.20 500.00 L 362.60 657.80 L 633.90 500.20 L 360.50 342.30 L 89.20 500.00 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,3'
                  node-id='396'
                  stroke='none'
                  target-height='455.2'
                  target-width='814.8'
                  target-x='73.9'
                  target-y='213.7'
                />
                <path
                  d='M 472.00 206.60 L 471.30 430.50 L 366.10 491.60 L 366.80 267.70 L 472.00 206.60 Z'
                  fill='#6eba6e'
                  fill-rule='nonzero'
                  group-id='1,4'
                  node-id='401'
                  stroke='none'
                  target-height='285'
                  target-width='105.899994'
                  target-x='366.1'
                  target-y='206.6'
                />
                <path
                  d='M 465.20 218.40 L 462.80 219.80 L 462.20 425.20 L 464.60 426.60 L 465.20 218.40 Z'
                  fill='#6eba6e'
                  fill-rule='nonzero'
                  group-id='1,5'
                  node-id='406'
                  stroke='none'
                  target-height='208.20001'
                  target-width='3'
                  target-x='462.2'
                  target-y='218.4'
                />
                <path
                  d='M 462.20 425.20 L 372.90 477.10 L 372.90 479.80 L 464.60 426.60 L 462.20 425.20 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,6'
                  node-id='411'
                  stroke='none'
                  target-height='54.599976'
                  target-width='91.70001'
                  target-x='372.9'
                  target-y='425.2'
                />
                <path
                  d='M 462.60 219.60 L 373.30 271.50 L 372.70 476.90 L 462.00 425.00 L 462.60 219.60 Z'
                  fill='#60a860'
                  fill-rule='nonzero'
                  group-id='1,7'
                  node-id='416'
                  stroke='none'
                  target-height='257.3'
                  target-width='89.899994'
                  target-x='372.7'
                  target-y='219.6'
                />
                <path
                  d='M 366.70 267.70 L 366.00 491.60 L 260.20 430.50 L 260.80 206.60 L 366.70 267.70 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,8'
                  node-id='421'
                  stroke='none'
                  target-height='285'
                  target-width='106.5'
                  target-x='260.2'
                  target-y='206.6'
                />
                <path
                  d='M 472.00 206.60 L 366.80 267.70 L 260.90 206.60 L 366.10 145.50 L 472.00 206.60 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,9'
                  node-id='426'
                  stroke='none'
                  target-height='122.20001'
                  target-width='211.1'
                  target-x='260.9'
                  target-y='145.5'
                />
                <path
                  d='M 435.40 196.60 L 435.40 205.40 L 366.30 245.70 L 366.50 236.70 L 435.40 196.60 Z'
                  fill='#d4dae8'
                  fill-rule='nonzero'
                  group-id='1,10'
                  node-id='431'
                  stroke='none'
                  target-height='49.09999'
                  target-width='69.100006'
                  target-x='366.3'
                  target-y='196.6'
                />
                <path
                  d='M 366.50 236.70 L 366.30 245.70 L 296.80 205.70 L 297.20 196.60 L 366.50 236.70 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,11'
                  node-id='436'
                  stroke='none'
                  target-height='49.09999'
                  target-width='69.70001'
                  target-x='296.8'
                  target-y='196.6'
                />
                <path
                  d='M 435.40 196.60 L 366.50 236.70 L 297.20 196.60 L 366.10 156.60 L 435.40 196.60 Z'
                  fill='#ffffff'
                  fill-rule='nonzero'
                  group-id='1,12'
                  node-id='441'
                  stroke='none'
                  target-height='80.09999'
                  target-width='138.19998'
                  target-x='297.2'
                  target-y='156.6'
                />
                <path
                  d='M 382.80 276.70 L 382.90 281.70 L 378.50 284.20 L 378.50 279.20 L 382.80 276.70 Z M 387.20 279.20 L 387.20 284.20 L 382.90 286.70 L 382.90 281.70 L 387.20 279.20 Z M 391.60 271.60 L 391.60 276.70 L 387.20 279.20 L 387.20 274.20 L 391.60 271.60 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,13'
                  node-id='446'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.100006'
                  target-x='378.5'
                  target-y='271.6'
                />
                <path
                  d='M 396.00 274.10 L 396.00 279.20 L 391.60 281.70 L 391.60 276.70 L 396.00 274.10 Z M 400.30 266.60 L 400.30 271.60 L 396.00 274.10 L 396.00 269.10 L 400.30 266.60 Z M 404.80 269.10 L 404.80 274.10 L 400.40 276.60 L 400.30 271.60 L 404.80 269.10 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,14'
                  node-id='451'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.199982'
                  target-x='391.6'
                  target-y='266.6'
                />
                <path
                  d='M 409.10 261.50 L 409.10 266.50 L 404.80 269.10 L 404.70 264.00 L 409.10 261.50 Z M 413.50 264.00 L 413.50 269.00 L 409.10 271.60 L 409.10 266.50 L 413.50 264.00 Z M 417.90 256.50 L 417.90 261.50 L 413.50 264.00 L 413.50 259.00 L 417.90 256.50 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,15'
                  node-id='456'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.199982'
                  target-x='404.7'
                  target-y='256.5'
                />
                <path
                  d='M 422.20 259.00 L 422.30 264.00 L 417.90 266.50 L 417.90 261.50 L 422.20 259.00 Z M 426.60 251.40 L 426.60 256.40 L 422.20 259.00 L 422.20 253.90 L 426.60 251.40 Z M 431.00 253.90 L 431.00 258.90 L 426.60 261.50 L 426.60 256.40 L 431.00 253.90 Z M 435.30 246.40 L 435.40 251.40 L 431.00 253.90 L 431.00 248.90 L 435.30 246.40 Z M 439.70 248.90 L 439.70 253.90 L 435.40 256.40 L 435.40 251.40 L 439.70 248.90 Z M 444.10 241.30 L 444.10 246.30 L 439.70 248.90 L 439.70 243.80 L 444.10 241.30 Z M 448.50 243.80 L 448.50 248.80 L 444.20 251.30 L 444.10 246.30 L 448.50 243.80 Z M 452.90 236.30 L 452.90 241.30 L 448.50 243.80 L 448.50 238.80 L 452.90 236.30 Z M 457.30 238.80 L 457.30 243.80 L 452.90 246.30 L 452.90 241.30 L 457.30 238.80 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,16'
                  node-id='461'
                  stroke='none'
                  target-height='30.199997'
                  target-width='39.399994'
                  target-x='417.9'
                  target-y='236.3'
                />
                <path
                  d='M 459.20 248.90 L 459.20 252.30 L 376.10 300.20 L 376.10 296.80 L 459.20 248.90 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,17'
                  node-id='466'
                  stroke='none'
                  target-height='51.30002'
                  target-width='83.100006'
                  target-x='376.1'
                  target-y='248.9'
                />
                <path
                  d='M 382.80 316.70 L 382.90 321.70 L 378.50 324.20 L 378.50 319.20 L 382.80 316.70 Z M 387.20 319.20 L 387.20 324.20 L 382.90 326.70 L 382.90 321.70 L 387.20 319.20 Z M 391.60 311.60 L 391.60 316.70 L 387.20 319.20 L 387.20 314.20 L 391.60 311.60 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,18'
                  node-id='471'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.100006'
                  target-x='378.5'
                  target-y='311.6'
                />
                <path
                  d='M 396.00 314.10 L 396.00 319.20 L 391.60 321.70 L 391.60 316.70 L 396.00 314.10 Z M 400.30 306.60 L 400.30 311.60 L 396.00 314.10 L 396.00 309.10 L 400.30 306.60 Z M 404.80 309.10 L 404.80 314.10 L 400.40 316.60 L 400.30 311.60 L 404.80 309.10 Z M 409.10 301.50 L 409.10 306.50 L 404.80 309.10 L 404.70 304.00 L 409.10 301.50 Z M 413.50 304.00 L 413.50 309.00 L 409.10 311.60 L 409.10 306.50 L 413.50 304.00 Z M 417.90 296.50 L 417.90 301.50 L 413.50 304.00 L 413.50 299.00 L 417.90 296.50 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,19'
                  node-id='476'
                  stroke='none'
                  target-height='25.200012'
                  target-width='26.299988'
                  target-x='391.6'
                  target-y='296.5'
                />
                <path
                  d='M 422.20 299.00 L 422.30 304.00 L 417.90 306.50 L 417.90 301.50 L 422.20 299.00 Z M 426.60 291.40 L 426.60 296.40 L 422.20 299.00 L 422.20 293.90 L 426.60 291.40 Z M 431.00 293.90 L 431.00 298.90 L 426.60 301.50 L 426.60 296.40 L 431.00 293.90 Z M 435.30 286.40 L 435.40 291.40 L 431.00 293.90 L 431.00 288.90 L 435.30 286.40 Z M 439.70 288.90 L 439.70 293.90 L 435.40 296.40 L 435.40 291.40 L 439.70 288.90 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,20'
                  node-id='481'
                  stroke='none'
                  target-height='20.100006'
                  target-width='21.800018'
                  target-x='417.9'
                  target-y='286.4'
                />
                <path
                  d='M 444.10 281.30 L 444.10 286.30 L 439.70 288.90 L 439.70 283.90 L 444.10 281.30 Z M 448.50 283.80 L 448.50 288.80 L 444.20 291.30 L 444.10 286.30 L 448.50 283.80 Z M 452.90 276.20 L 452.90 281.30 L 448.50 283.80 L 448.50 278.80 L 452.90 276.20 Z M 457.30 278.70 L 457.30 283.80 L 452.90 286.30 L 452.90 281.30 L 457.30 278.70 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,21'
                  node-id='486'
                  stroke='none'
                  target-height='15.099976'
                  target-width='17.599976'
                  target-x='439.7'
                  target-y='276.2'
                />
                <path
                  d='M 459.20 288.90 L 459.20 292.30 L 376.10 340.20 L 376.10 336.80 L 459.20 288.90 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,22'
                  node-id='491'
                  stroke='none'
                  target-height='51.30002'
                  target-width='83.100006'
                  target-x='376.1'
                  target-y='288.9'
                />
                <path
                  d='M 382.80 356.70 L 382.90 361.70 L 378.50 364.20 L 378.50 359.20 L 382.80 356.70 Z M 387.20 359.20 L 387.20 364.20 L 382.90 366.70 L 382.90 361.70 L 387.20 359.20 Z M 391.60 351.60 L 391.60 356.70 L 387.20 359.20 L 387.20 354.20 L 391.60 351.60 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,23'
                  node-id='496'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.100006'
                  target-x='378.5'
                  target-y='351.6'
                />
                <path
                  d='M 396.00 354.10 L 396.00 359.20 L 391.60 361.70 L 391.60 356.70 L 396.00 354.10 Z M 400.30 346.60 L 400.30 351.60 L 396.00 354.10 L 396.00 349.10 L 400.30 346.60 Z M 404.80 349.10 L 404.80 354.10 L 400.40 356.60 L 400.30 351.60 L 404.80 349.10 Z M 409.10 341.50 L 409.10 346.50 L 404.80 349.10 L 404.70 344.00 L 409.10 341.50 Z M 413.50 344.00 L 413.50 349.00 L 409.10 351.60 L 409.10 346.50 L 413.50 344.00 Z M 417.90 336.50 L 417.90 341.50 L 413.50 344.00 L 413.50 339.00 L 417.90 336.50 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,24'
                  node-id='501'
                  stroke='none'
                  target-height='25.200012'
                  target-width='26.299988'
                  target-x='391.6'
                  target-y='336.5'
                />
                <path
                  d='M 422.20 339.00 L 422.30 344.00 L 417.90 346.50 L 417.90 341.50 L 422.20 339.00 Z M 426.60 331.40 L 426.60 336.40 L 422.20 339.00 L 422.20 333.90 L 426.60 331.40 Z M 431.00 333.90 L 431.00 338.90 L 426.60 341.50 L 426.60 336.40 L 431.00 333.90 Z M 435.30 326.40 L 435.40 331.40 L 431.00 333.90 L 431.00 328.90 L 435.30 326.40 Z M 439.70 328.90 L 439.70 333.90 L 435.40 336.40 L 435.40 331.40 L 439.70 328.90 Z M 444.10 321.30 L 444.10 326.30 L 439.70 328.90 L 439.70 323.80 L 444.10 321.30 Z M 448.50 323.80 L 448.50 328.80 L 444.20 331.30 L 444.10 326.30 L 448.50 323.80 Z M 452.90 316.30 L 452.90 321.30 L 448.50 323.80 L 448.50 318.80 L 452.90 316.30 Z M 457.30 318.80 L 457.30 323.80 L 452.90 326.30 L 452.90 321.30 L 457.30 318.80 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,25'
                  node-id='506'
                  stroke='none'
                  target-height='30.200012'
                  target-width='39.399994'
                  target-x='417.9'
                  target-y='316.3'
                />
                <path
                  d='M 459.20 328.90 L 459.20 332.30 L 376.10 380.20 L 376.10 376.80 L 459.20 328.90 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,26'
                  node-id='511'
                  stroke='none'
                  target-height='51.30002'
                  target-width='83.100006'
                  target-x='376.1'
                  target-y='328.9'
                />
                <path
                  d='M 382.80 396.70 L 382.90 401.70 L 378.50 404.20 L 378.50 399.20 L 382.80 396.70 Z M 387.20 399.20 L 387.20 404.20 L 382.90 406.70 L 382.90 401.70 L 387.20 399.20 Z M 391.60 391.60 L 391.60 396.70 L 387.20 399.20 L 387.20 394.20 L 391.60 391.60 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,27'
                  node-id='516'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.100006'
                  target-x='378.5'
                  target-y='391.6'
                />
                <path
                  d='M 396.00 394.10 L 396.00 399.20 L 391.60 401.70 L 391.60 396.70 L 396.00 394.10 Z M 400.30 386.60 L 400.30 391.60 L 396.00 394.10 L 396.00 389.10 L 400.30 386.60 Z M 404.80 389.10 L 404.80 394.10 L 400.40 396.60 L 400.30 391.60 L 404.80 389.10 Z M 409.10 381.50 L 409.10 386.50 L 404.80 389.10 L 404.70 384.00 L 409.10 381.50 Z M 413.50 384.00 L 413.50 389.00 L 409.10 391.60 L 409.10 386.50 L 413.50 384.00 Z M 417.90 376.50 L 417.90 381.50 L 413.50 384.00 L 413.50 379.00 L 417.90 376.50 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,28'
                  node-id='521'
                  stroke='none'
                  target-height='25.200012'
                  target-width='26.299988'
                  target-x='391.6'
                  target-y='376.5'
                />
                <path
                  d='M 422.20 379.00 L 422.30 384.00 L 417.90 386.50 L 417.90 381.50 L 422.20 379.00 Z M 426.60 371.40 L 426.60 376.40 L 422.20 379.00 L 422.20 373.90 L 426.60 371.40 Z M 431.00 373.90 L 431.00 378.90 L 426.60 381.50 L 426.60 376.40 L 431.00 373.90 Z M 435.30 366.40 L 435.40 371.40 L 431.00 373.90 L 431.00 368.90 L 435.30 366.40 Z M 439.70 368.90 L 439.70 373.90 L 435.40 376.40 L 435.40 371.40 L 439.70 368.90 Z M 444.10 361.30 L 444.10 366.30 L 439.70 368.90 L 439.70 363.80 L 444.10 361.30 Z M 448.50 363.80 L 448.50 368.80 L 444.20 371.30 L 444.10 366.30 L 448.50 363.80 Z M 452.90 356.30 L 452.90 361.30 L 448.50 363.80 L 448.50 358.80 L 452.90 356.30 Z M 457.30 358.80 L 457.30 363.80 L 452.90 366.30 L 452.90 361.30 L 457.30 358.80 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,29'
                  node-id='526'
                  stroke='none'
                  target-height='30.200012'
                  target-width='39.399994'
                  target-x='417.9'
                  target-y='356.3'
                />
                <path
                  d='M 459.20 368.90 L 459.20 372.30 L 376.10 420.20 L 376.10 416.80 L 459.20 368.90 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,30'
                  node-id='531'
                  stroke='none'
                  target-height='51.30002'
                  target-width='83.100006'
                  target-x='376.1'
                  target-y='368.9'
                />
                <path
                  d='M 382.80 436.70 L 382.90 441.70 L 378.50 444.20 L 378.50 439.20 L 382.80 436.70 Z M 387.20 439.20 L 387.20 444.20 L 382.90 446.70 L 382.90 441.70 L 387.20 439.20 Z M 391.60 431.60 L 391.60 436.70 L 387.20 439.20 L 387.20 434.20 L 391.60 431.60 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,31'
                  node-id='536'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.100006'
                  target-x='378.5'
                  target-y='431.6'
                />
                <path
                  d='M 396.00 434.10 L 396.00 439.20 L 391.60 441.70 L 391.60 436.70 L 396.00 434.10 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,32'
                  node-id='541'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.399994'
                  target-x='391.6'
                  target-y='434.1'
                />
                <path
                  d='M 400.30 426.60 L 400.30 431.60 L 396.00 434.10 L 396.00 429.10 L 400.30 426.60 Z M 404.80 429.10 L 404.80 434.10 L 400.40 436.60 L 400.30 431.60 L 404.80 429.10 Z M 409.10 421.50 L 409.10 426.50 L 404.80 429.10 L 404.70 424.00 L 409.10 421.50 Z M 413.50 424.00 L 413.50 429.00 L 409.10 431.60 L 409.10 426.50 L 413.50 424.00 Z M 417.90 416.50 L 417.90 421.50 L 413.50 424.00 L 413.50 419.00 L 417.90 416.50 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,33'
                  node-id='546'
                  stroke='none'
                  target-height='20.100006'
                  target-width='21.899994'
                  target-x='396'
                  target-y='416.5'
                />
                <path
                  d='M 422.20 419.00 L 422.30 424.00 L 417.90 426.50 L 417.90 421.50 L 422.20 419.00 Z M 426.60 411.40 L 426.60 416.40 L 422.20 419.00 L 422.20 413.90 L 426.60 411.40 Z M 431.00 413.90 L 431.00 418.90 L 426.60 421.50 L 426.60 416.40 L 431.00 413.90 Z M 435.30 406.40 L 435.40 411.40 L 431.00 413.90 L 431.00 408.90 L 435.30 406.40 Z M 439.70 408.90 L 439.70 413.90 L 435.40 416.40 L 435.40 411.40 L 439.70 408.90 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,34'
                  node-id='551'
                  stroke='none'
                  target-height='20.100006'
                  target-width='21.800018'
                  target-x='417.9'
                  target-y='406.4'
                />
                <path
                  d='M 444.10 401.30 L 444.10 406.30 L 439.70 408.90 L 439.70 403.80 L 444.10 401.30 Z M 448.50 403.80 L 448.50 408.80 L 444.20 411.30 L 444.10 406.30 L 448.50 403.80 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,35'
                  node-id='556'
                  stroke='none'
                  target-height='10'
                  target-width='8.799988'
                  target-x='439.7'
                  target-y='401.3'
                />
                <path
                  d='M 452.90 396.20 L 452.90 401.30 L 448.50 403.80 L 448.50 398.80 L 452.90 396.20 Z M 457.30 398.80 L 457.30 403.80 L 452.90 406.30 L 452.90 401.30 L 457.30 398.80 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,36'
                  node-id='561'
                  stroke='none'
                  target-height='10.099976'
                  target-width='8.799988'
                  target-x='448.5'
                  target-y='396.2'
                />
                <path
                  d='M 459.20 408.90 L 459.20 412.20 L 376.10 460.20 L 376.10 456.80 L 459.20 408.90 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,37'
                  node-id='566'
                  stroke='none'
                  target-height='51.30002'
                  target-width='83.100006'
                  target-x='376.1'
                  target-y='408.9'
                />
                <path
                  d='M 267.80 228.20 L 267.80 231.20 L 359.20 284.00 L 359.20 281.00 L 267.80 228.20 Z M 267.80 243.20 L 267.70 246.20 L 359.10 299.00 L 359.20 296.00 L 267.80 243.20 Z M 267.70 250.80 L 267.70 253.80 L 359.10 306.50 L 359.10 303.50 L 267.70 250.80 Z M 267.80 235.70 L 267.80 238.70 L 359.20 291.50 L 359.20 288.50 L 267.80 235.70 Z M 267.60 280.90 L 267.60 283.90 L 359.00 336.60 L 359.00 333.60 L 267.60 280.90 Z M 267.70 273.30 L 267.70 276.30 L 359.10 329.10 L 359.10 326.10 L 267.70 273.30 Z M 267.70 265.80 L 267.70 268.80 L 359.10 321.60 L 359.10 318.60 L 267.70 265.80 Z M 267.70 258.30 L 267.70 261.30 L 359.10 314.10 L 359.10 311.10 L 267.70 258.30 Z M 267.80 361.60 L 267.80 364.60 L 359.20 417.40 L 359.20 414.40 L 267.80 361.60 Z M 267.80 376.70 L 267.70 379.70 L 359.10 432.40 L 359.20 429.40 L 267.80 376.70 Z M 267.70 384.20 L 267.70 387.20 L 359.10 440.00 L 359.10 437.00 L 267.70 384.20 Z M 267.80 369.10 L 267.80 372.10 L 359.20 424.90 L 359.20 421.90 L 267.80 369.10 Z M 267.60 414.30 L 267.60 417.30 L 359.00 470.10 L 359.00 467.10 L 267.60 414.30 Z M 267.70 406.80 L 267.70 409.80 L 359.10 462.50 L 359.10 459.50 L 267.70 406.80 Z M 267.70 399.20 L 267.70 402.30 L 359.10 455.00 L 359.10 452.00 L 267.70 399.20 Z M 267.70 391.70 L 267.70 394.70 L 359.10 447.50 L 359.10 444.50 L 267.70 391.70 Z'
                  fill='#6eba6e'
                  fill-rule='nonzero'
                  group-id='1,38'
                  node-id='571'
                  stroke='none'
                  target-height='241.90001'
                  target-width='91.600006'
                  target-x='267.6'
                  target-y='228.2'
                />
                <path
                  d='M 343.90 280.10 L 343.20 504.00 L 238.00 565.10 L 238.70 341.20 L 343.90 280.10 Z'
                  fill='#f34858'
                  fill-rule='nonzero'
                  group-id='1,39'
                  node-id='576'
                  stroke='none'
                  target-height='284.99997'
                  target-width='105.899994'
                  target-x='238'
                  target-y='280.1'
                />
                <path
                  d='M 337.10 291.90 L 334.70 293.20 L 334.20 498.70 L 336.50 500.10 L 337.10 291.90 Z'
                  fill='#fa5168'
                  fill-rule='nonzero'
                  group-id='1,40'
                  node-id='581'
                  stroke='none'
                  target-height='208.20001'
                  target-width='2.899994'
                  target-x='334.2'
                  target-y='291.9'
                />
                <path
                  d='M 334.20 498.70 L 244.90 550.60 L 244.90 553.30 L 336.50 500.10 L 334.20 498.70 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,41'
                  node-id='586'
                  stroke='none'
                  target-height='54.599976'
                  target-width='91.600006'
                  target-x='244.9'
                  target-y='498.7'
                />
                <path
                  d='M 334.60 293.10 L 245.30 344.90 L 244.70 550.40 L 334.00 498.50 L 334.60 293.10 Z'
                  fill='#e63044'
                  fill-rule='nonzero'
                  group-id='1,42'
                  node-id='591'
                  stroke='none'
                  target-height='257.30002'
                  target-width='89.90001'
                  target-x='244.7'
                  target-y='293.1'
                />
                <path
                  d='M 238.60 341.20 L 238.00 565.10 L 132.10 504.00 L 132.70 280.10 L 238.60 341.20 Z'
                  fill='#fa5168'
                  fill-rule='nonzero'
                  group-id='1,43'
                  node-id='596'
                  stroke='none'
                  target-height='284.99997'
                  target-width='106.5'
                  target-x='132.1'
                  target-y='280.1'
                />
                <path
                  d='M 343.90 280.10 L 238.70 341.20 L 132.80 280.10 L 238.00 218.90 L 343.90 280.10 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,44'
                  node-id='601'
                  stroke='none'
                  target-height='122.30002'
                  target-width='211.09999'
                  target-x='132.8'
                  target-y='218.9'
                />
                <path
                  d='M 307.40 270.10 L 307.40 278.90 L 238.20 319.20 L 238.50 310.20 L 307.40 270.10 Z'
                  fill='#d4dae8'
                  fill-rule='nonzero'
                  group-id='1,45'
                  node-id='606'
                  stroke='none'
                  target-height='49.100006'
                  target-width='69.2'
                  target-x='238.2'
                  target-y='270.1'
                />
                <path
                  d='M 238.50 310.20 L 238.20 319.20 L 168.70 279.10 L 169.10 270.10 L 238.50 310.20 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,46'
                  node-id='611'
                  stroke='none'
                  target-height='49.100006'
                  target-width='69.8'
                  target-x='168.7'
                  target-y='270.1'
                />
                <path
                  d='M 307.40 270.10 L 238.50 310.20 L 169.10 270.10 L 238.00 230.10 L 307.40 270.10 Z'
                  fill='#ffffff'
                  fill-rule='nonzero'
                  group-id='1,47'
                  node-id='616'
                  stroke='none'
                  target-height='80.100006'
                  target-width='138.29999'
                  target-x='169.1'
                  target-y='230.1'
                />
                <path
                  d='M 254.80 350.20 L 254.80 355.20 L 250.40 357.70 L 250.40 352.70 L 254.80 350.20 Z M 259.20 352.70 L 259.20 357.70 L 254.80 360.20 L 254.80 355.20 L 259.20 352.70 Z M 263.50 345.10 L 263.50 350.10 L 259.20 352.70 L 259.10 347.60 L 263.50 345.10 Z M 267.90 347.60 L 267.90 352.60 L 263.50 355.20 L 263.50 350.10 L 267.90 347.60 Z M 272.30 340.10 L 272.30 345.10 L 267.90 347.60 L 267.90 342.60 L 272.30 340.10 Z M 276.70 342.50 L 276.70 347.60 L 272.30 350.10 L 272.30 345.10 L 276.70 342.50 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,48'
                  node-id='621'
                  stroke='none'
                  target-height='20.100006'
                  target-width='26.300018'
                  target-x='250.4'
                  target-y='340.1'
                />
                <path
                  d='M 281.00 335.00 L 281.10 340.00 L 276.70 342.50 L 276.70 337.50 L 281.00 335.00 Z M 285.40 337.50 L 285.40 342.50 L 281.10 345.00 L 281.10 340.00 L 285.40 337.50 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,49'
                  node-id='626'
                  stroke='none'
                  target-height='10'
                  target-width='8.699982'
                  target-x='276.7'
                  target-y='335'
                />
                <path
                  d='M 289.80 329.90 L 289.80 335.00 L 285.40 337.50 L 285.40 332.50 L 289.80 329.90 Z M 294.20 332.40 L 294.20 337.50 L 289.80 340.00 L 289.80 335.00 L 294.20 332.40 Z M 298.50 324.90 L 298.50 329.90 L 294.20 332.40 L 294.20 327.40 L 298.50 324.90 Z M 302.90 327.40 L 302.90 332.40 L 298.60 334.90 L 298.60 329.90 L 302.90 327.40 Z M 307.30 319.80 L 307.30 324.90 L 302.90 327.40 L 302.90 322.40 L 307.30 319.80 Z M 311.70 322.30 L 311.70 327.40 L 307.30 329.90 L 307.30 324.90 L 311.70 322.30 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,50'
                  node-id='631'
                  stroke='none'
                  target-height='20.200012'
                  target-width='26.300018'
                  target-x='285.4'
                  target-y='319.8'
                />
                <path
                  d='M 316.10 314.80 L 316.10 319.80 L 311.70 322.30 L 311.60 317.30 L 316.10 314.80 Z M 320.40 317.30 L 320.50 322.30 L 316.10 324.80 L 316.10 319.80 L 320.40 317.30 Z M 324.80 309.70 L 324.80 314.80 L 320.40 317.30 L 320.40 312.20 L 324.80 309.70 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,51'
                  node-id='636'
                  stroke='none'
                  target-height='15.099976'
                  target-width='13.199982'
                  target-x='311.6'
                  target-y='309.7'
                />
                <path
                  d='M 329.20 312.20 L 329.20 317.30 L 324.80 319.80 L 324.80 314.80 L 329.20 312.20 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,52'
                  node-id='641'
                  stroke='none'
                  target-height='7.5999756'
                  target-width='4.4000244'
                  target-x='324.8'
                  target-y='312.2'
                />
                <path
                  d='M 331.20 322.30 L 331.20 325.70 L 248.10 373.70 L 248.10 370.30 L 331.20 322.30 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,53'
                  node-id='646'
                  stroke='none'
                  target-height='51.400024'
                  target-width='83.100006'
                  target-x='248.1'
                  target-y='322.3'
                />
                <path
                  d='M 254.80 390.20 L 254.80 395.20 L 250.40 397.70 L 250.40 392.70 L 254.80 390.20 Z M 259.20 392.70 L 259.20 397.70 L 254.80 400.20 L 254.80 395.20 L 259.20 392.70 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,54'
                  node-id='651'
                  stroke='none'
                  target-height='10'
                  target-width='8.800018'
                  target-x='250.4'
                  target-y='390.2'
                />
                <path
                  d='M 263.50 385.10 L 263.50 390.10 L 259.20 392.70 L 259.10 387.60 L 263.50 385.10 Z M 267.90 387.60 L 267.90 392.60 L 263.50 395.20 L 263.50 390.10 L 267.90 387.60 Z M 272.30 380.10 L 272.30 385.10 L 267.90 387.60 L 267.90 382.60 L 272.30 380.10 Z M 276.70 382.50 L 276.70 387.60 L 272.30 390.10 L 272.30 385.10 L 276.70 382.50 Z M 281.00 375.00 L 281.10 380.00 L 276.70 382.50 L 276.70 377.50 L 281.00 375.00 Z M 285.40 377.50 L 285.40 382.50 L 281.10 385.00 L 281.10 380.00 L 285.40 377.50 Z M 289.80 369.90 L 289.80 375.00 L 285.40 377.50 L 285.40 372.50 L 289.80 369.90 Z M 294.20 372.40 L 294.20 377.50 L 289.80 380.00 L 289.80 375.00 L 294.20 372.40 Z M 298.50 364.90 L 298.50 369.90 L 294.20 372.40 L 294.20 367.40 L 298.50 364.90 Z M 302.90 367.40 L 302.90 372.40 L 298.60 374.90 L 298.60 369.90 L 302.90 367.40 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,55'
                  node-id='656'
                  stroke='none'
                  target-height='30.300018'
                  target-width='43.799988'
                  target-x='259.1'
                  target-y='364.9'
                />
                <path
                  d='M 307.30 359.80 L 307.30 364.90 L 302.90 367.40 L 302.90 362.40 L 307.30 359.80 Z M 311.70 362.30 L 311.70 367.40 L 307.30 369.90 L 307.30 364.90 L 311.70 362.30 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,56'
                  node-id='661'
                  stroke='none'
                  target-height='10.100006'
                  target-width='8.800018'
                  target-x='302.9'
                  target-y='359.8'
                />
                <path
                  d='M 316.10 354.80 L 316.10 359.80 L 311.70 362.30 L 311.60 357.30 L 316.10 354.80 Z M 320.40 357.30 L 320.50 362.30 L 316.10 364.80 L 316.10 359.80 L 320.40 357.30 Z M 324.80 349.70 L 324.80 354.70 L 320.40 357.30 L 320.40 352.20 L 324.80 349.70 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,57'
                  node-id='666'
                  stroke='none'
                  target-height='15.099976'
                  target-width='13.199982'
                  target-x='311.6'
                  target-y='349.7'
                />
                <path
                  d='M 329.20 352.20 L 329.20 357.30 L 324.80 359.80 L 324.80 354.70 L 329.20 352.20 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,58'
                  node-id='671'
                  stroke='none'
                  target-height='7.5999756'
                  target-width='4.4000244'
                  target-x='324.8'
                  target-y='352.2'
                />
                <path
                  d='M 331.20 362.30 L 331.20 365.70 L 248.10 413.70 L 248.10 410.30 L 331.20 362.30 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,59'
                  node-id='676'
                  stroke='none'
                  target-height='51.400024'
                  target-width='83.100006'
                  target-x='248.1'
                  target-y='362.3'
                />
                <path
                  d='M 254.80 430.20 L 254.80 435.20 L 250.40 437.70 L 250.40 432.70 L 254.80 430.20 Z M 259.20 432.70 L 259.20 437.70 L 254.80 440.20 L 254.80 435.20 L 259.20 432.70 Z M 263.50 425.10 L 263.50 430.10 L 259.20 432.70 L 259.10 427.60 L 263.50 425.10 Z M 267.90 427.60 L 267.90 432.60 L 263.50 435.20 L 263.50 430.10 L 267.90 427.60 Z M 272.30 420.10 L 272.30 425.10 L 267.90 427.60 L 267.90 422.60 L 272.30 420.10 Z M 276.70 422.50 L 276.70 427.60 L 272.30 430.10 L 272.30 425.10 L 276.70 422.50 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,60'
                  node-id='681'
                  stroke='none'
                  target-height='20.100006'
                  target-width='26.300018'
                  target-x='250.4'
                  target-y='420.1'
                />
                <path
                  d='M 281.00 415.00 L 281.10 420.00 L 276.70 422.50 L 276.70 417.50 L 281.00 415.00 Z M 285.40 417.50 L 285.40 422.50 L 281.10 425.00 L 281.10 420.00 L 285.40 417.50 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,61'
                  node-id='686'
                  stroke='none'
                  target-height='10'
                  target-width='8.699982'
                  target-x='276.7'
                  target-y='415'
                />
                <path
                  d='M 289.80 409.90 L 289.80 415.00 L 285.40 417.50 L 285.40 412.50 L 289.80 409.90 Z M 294.20 412.40 L 294.20 417.50 L 289.80 420.00 L 289.80 415.00 L 294.20 412.40 Z M 298.50 404.90 L 298.50 409.90 L 294.20 412.40 L 294.20 407.40 L 298.50 404.90 Z M 302.90 407.40 L 302.90 412.40 L 298.60 414.90 L 298.60 409.90 L 302.90 407.40 Z M 307.30 399.80 L 307.30 404.90 L 302.90 407.40 L 302.90 402.40 L 307.30 399.80 Z M 311.70 402.30 L 311.70 407.40 L 307.30 409.90 L 307.30 404.90 L 311.70 402.30 Z M 316.10 394.80 L 316.10 399.80 L 311.70 402.30 L 311.60 397.30 L 316.10 394.80 Z M 320.40 397.30 L 320.50 402.30 L 316.10 404.80 L 316.10 399.80 L 320.40 397.30 Z M 324.80 389.70 L 324.80 394.70 L 320.40 397.30 L 320.40 392.20 L 324.80 389.70 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,62'
                  node-id='691'
                  stroke='none'
                  target-height='30.299988'
                  target-width='39.399994'
                  target-x='285.4'
                  target-y='389.7'
                />
                <path
                  d='M 329.20 392.20 L 329.20 397.20 L 324.80 399.80 L 324.80 394.70 L 329.20 392.20 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,63'
                  node-id='696'
                  stroke='none'
                  target-height='7.5999756'
                  target-width='4.4000244'
                  target-x='324.8'
                  target-y='392.2'
                />
                <path
                  d='M 331.20 402.30 L 331.20 405.70 L 248.10 453.70 L 248.10 450.30 L 331.20 402.30 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,64'
                  node-id='701'
                  stroke='none'
                  target-height='51.400024'
                  target-width='83.100006'
                  target-x='248.1'
                  target-y='402.3'
                />
                <path
                  d='M 254.80 470.20 L 254.80 475.20 L 250.40 477.70 L 250.40 472.70 L 254.80 470.20 Z M 259.20 472.70 L 259.20 477.70 L 254.80 480.20 L 254.80 475.20 L 259.20 472.70 Z M 263.50 465.10 L 263.50 470.10 L 259.20 472.70 L 259.10 467.60 L 263.50 465.10 Z M 267.90 467.60 L 267.90 472.60 L 263.50 475.20 L 263.50 470.10 L 267.90 467.60 Z M 272.30 460.10 L 272.30 465.10 L 267.90 467.60 L 267.90 462.60 L 272.30 460.10 Z M 276.70 462.50 L 276.70 467.60 L 272.30 470.10 L 272.30 465.10 L 276.70 462.50 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,65'
                  node-id='706'
                  stroke='none'
                  target-height='20.100006'
                  target-width='26.300018'
                  target-x='250.4'
                  target-y='460.1'
                />
                <path
                  d='M 281.00 455.00 L 281.10 460.00 L 276.70 462.50 L 276.70 457.50 L 281.00 455.00 Z M 285.40 457.50 L 285.40 462.50 L 281.10 465.00 L 281.10 460.00 L 285.40 457.50 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,66'
                  node-id='711'
                  stroke='none'
                  target-height='10'
                  target-width='8.699982'
                  target-x='276.7'
                  target-y='455'
                />
                <path
                  d='M 289.80 449.90 L 289.80 455.00 L 285.40 457.50 L 285.40 452.50 L 289.80 449.90 Z M 294.20 452.40 L 294.20 457.50 L 289.80 460.00 L 289.80 455.00 L 294.20 452.40 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,67'
                  node-id='716'
                  stroke='none'
                  target-height='10.100006'
                  target-width='8.800018'
                  target-x='285.4'
                  target-y='449.9'
                />
                <path
                  d='M 298.50 444.90 L 298.50 449.90 L 294.20 452.40 L 294.20 447.40 L 298.50 444.90 Z M 302.90 447.40 L 302.90 452.40 L 298.60 454.90 L 298.60 449.90 L 302.90 447.40 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,68'
                  node-id='721'
                  stroke='none'
                  target-height='10'
                  target-width='8.699982'
                  target-x='294.2'
                  target-y='444.9'
                />
                <path
                  d='M 307.30 439.90 L 307.30 444.90 L 302.90 447.40 L 302.90 442.40 L 307.30 439.90 Z M 311.70 442.30 L 311.70 447.40 L 307.30 449.90 L 307.30 444.90 L 311.70 442.30 Z M 316.10 434.80 L 316.10 439.80 L 311.70 442.30 L 311.60 437.30 L 316.10 434.80 Z M 320.40 437.30 L 320.50 442.30 L 316.10 444.80 L 316.10 439.80 L 320.40 437.30 Z M 324.80 429.70 L 324.80 434.70 L 320.40 437.30 L 320.40 432.20 L 324.80 429.70 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,69'
                  node-id='726'
                  stroke='none'
                  target-height='20.199982'
                  target-width='21.899994'
                  target-x='302.9'
                  target-y='429.7'
                />
                <path
                  d='M 329.20 432.20 L 329.20 437.20 L 324.80 439.80 L 324.80 434.70 L 329.20 432.20 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,70'
                  node-id='731'
                  stroke='none'
                  target-height='7.5999756'
                  target-width='4.4000244'
                  target-x='324.8'
                  target-y='432.2'
                />
                <path
                  d='M 331.20 442.30 L 331.20 445.70 L 248.10 493.70 L 248.10 490.30 L 331.20 442.30 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,71'
                  node-id='736'
                  stroke='none'
                  target-height='51.400024'
                  target-width='83.100006'
                  target-x='248.1'
                  target-y='442.3'
                />
                <path
                  d='M 254.80 510.20 L 254.80 515.20 L 250.40 517.70 L 250.40 512.70 L 254.80 510.20 Z M 259.20 512.70 L 259.20 517.70 L 254.80 520.20 L 254.80 515.20 L 259.20 512.70 Z M 263.50 505.10 L 263.50 510.10 L 259.20 512.70 L 259.10 507.60 L 263.50 505.10 Z M 267.90 507.60 L 267.90 512.60 L 263.50 515.20 L 263.50 510.10 L 267.90 507.60 Z M 272.30 500.10 L 272.30 505.10 L 267.90 507.60 L 267.90 502.60 L 272.30 500.10 Z M 276.70 502.50 L 276.70 507.60 L 272.30 510.10 L 272.30 505.10 L 276.70 502.50 Z M 281.00 495.00 L 281.10 500.00 L 276.70 502.50 L 276.70 497.50 L 281.00 495.00 Z M 285.40 497.50 L 285.40 502.50 L 281.10 505.00 L 281.10 500.00 L 285.40 497.50 Z M 289.80 489.90 L 289.80 495.00 L 285.40 497.50 L 285.40 492.50 L 289.80 489.90 Z M 294.20 492.40 L 294.20 497.50 L 289.80 500.00 L 289.80 495.00 L 294.20 492.40 Z M 298.50 484.90 L 298.50 489.90 L 294.20 492.40 L 294.20 487.40 L 298.50 484.90 Z M 302.90 487.40 L 302.90 492.40 L 298.60 494.90 L 298.60 489.90 L 302.90 487.40 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,72'
                  node-id='741'
                  stroke='none'
                  target-height='35.30002'
                  target-width='52.5'
                  target-x='250.4'
                  target-y='484.9'
                />
                <path
                  d='M 307.30 479.80 L 307.30 484.90 L 302.90 487.40 L 302.90 482.40 L 307.30 479.80 Z M 311.70 482.30 L 311.70 487.40 L 307.30 489.90 L 307.30 484.90 L 311.70 482.30 Z M 316.10 474.80 L 316.10 479.80 L 311.70 482.30 L 311.60 477.30 L 316.10 474.80 Z M 320.40 477.30 L 320.50 482.30 L 316.10 484.80 L 316.10 479.80 L 320.40 477.30 Z M 324.80 469.70 L 324.80 474.70 L 320.40 477.30 L 320.40 472.20 L 324.80 469.70 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,73'
                  node-id='746'
                  stroke='none'
                  target-height='20.199982'
                  target-width='21.899994'
                  target-x='302.9'
                  target-y='469.7'
                />
                <path
                  d='M 329.20 472.20 L 329.20 477.20 L 324.80 479.80 L 324.80 474.70 L 329.20 472.20 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,74'
                  node-id='751'
                  stroke='none'
                  target-height='7.5999756'
                  target-width='4.4000244'
                  target-x='324.8'
                  target-y='472.2'
                />
                <path
                  d='M 331.20 482.30 L 331.20 485.70 L 248.10 533.70 L 248.10 530.30 L 331.20 482.30 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,75'
                  node-id='756'
                  stroke='none'
                  target-height='51.400024'
                  target-width='83.100006'
                  target-x='248.1'
                  target-y='482.3'
                />
                <path
                  d='M 139.70 301.70 L 139.70 304.70 L 231.10 357.40 L 231.10 354.40 L 139.70 301.70 Z M 139.70 316.70 L 139.70 319.70 L 231.10 372.50 L 231.10 369.50 L 139.70 316.70 Z M 139.70 324.20 L 139.70 327.30 L 231.00 380.00 L 231.10 377.00 L 139.70 324.20 Z M 139.70 309.20 L 139.70 312.20 L 231.10 365.00 L 231.10 362.00 L 139.70 309.20 Z M 139.60 354.30 L 139.60 357.40 L 231.00 410.10 L 231.00 407.10 L 139.60 354.30 Z M 139.60 346.80 L 139.60 349.80 L 231.00 402.60 L 231.00 399.60 L 139.60 346.80 Z M 139.60 339.30 L 139.60 342.30 L 231.00 395.10 L 231.00 392.10 L 139.60 339.30 Z M 139.60 331.80 L 139.60 334.80 L 231.00 387.50 L 231.00 384.50 L 139.60 331.80 Z M 139.70 435.10 L 139.70 438.10 L 231.10 490.90 L 231.10 487.90 L 139.70 435.10 Z M 139.70 450.10 L 139.70 453.20 L 231.10 505.90 L 231.10 502.90 L 139.70 450.10 Z M 139.70 457.70 L 139.70 460.70 L 231.00 513.40 L 231.10 510.40 L 139.70 457.70 Z M 139.70 442.60 L 139.70 445.60 L 231.10 498.40 L 231.10 495.40 L 139.70 442.60 Z M 139.60 487.80 L 139.60 490.80 L 231.00 543.50 L 231.00 540.50 L 139.60 487.80 Z M 139.60 480.20 L 139.60 483.30 L 231.00 536.00 L 231.00 533.00 L 139.60 480.20 Z M 139.60 472.70 L 139.60 475.70 L 231.00 528.50 L 231.00 525.50 L 139.60 472.70 Z M 139.60 465.20 L 139.60 468.20 L 231.00 521.00 L 231.00 518.00 L 139.60 465.20 Z'
                  fill='#e63044'
                  fill-rule='nonzero'
                  group-id='1,76'
                  node-id='761'
                  stroke='none'
                  target-height='241.79999'
                  target-width='91.5'
                  target-x='139.6'
                  target-y='301.7'
                />
                <path
                  d='M 591.10 275.70 L 590.40 499.60 L 485.20 560.80 L 485.90 336.90 L 591.10 275.70 Z'
                  fill='#4562ef'
                  fill-rule='nonzero'
                  group-id='1,77'
                  node-id='766'
                  stroke='none'
                  target-height='285.09998'
                  target-width='105.89996'
                  target-x='485.2'
                  target-y='275.7'
                />
                <path
                  d='M 584.20 287.50 L 581.90 288.90 L 581.30 494.30 L 583.60 495.70 L 584.20 287.50 Z'
                  fill='#576cfb'
                  fill-rule='nonzero'
                  group-id='1,78'
                  node-id='771'
                  stroke='none'
                  target-height='208.20001'
                  target-width='2.9000244'
                  target-x='581.3'
                  target-y='287.5'
                />
                <path
                  d='M 581.30 494.30 L 492.00 546.20 L 492.00 549.00 L 583.60 495.70 L 581.30 494.30 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,79'
                  node-id='776'
                  stroke='none'
                  target-height='54.700012'
                  target-width='91.599976'
                  target-x='492'
                  target-y='494.3'
                />
                <path
                  d='M 581.70 288.70 L 492.40 340.60 L 491.80 546.00 L 581.10 494.10 L 581.70 288.70 Z'
                  fill='#3a5bd6'
                  fill-rule='nonzero'
                  group-id='1,80'
                  node-id='781'
                  stroke='none'
                  target-height='257.3'
                  target-width='89.900024'
                  target-x='491.8'
                  target-y='288.7'
                />
                <path
                  d='M 485.80 336.90 L 485.10 560.80 L 379.20 499.60 L 379.90 275.70 L 485.80 336.90 Z'
                  fill='#576cfb'
                  fill-rule='nonzero'
                  group-id='1,81'
                  node-id='786'
                  stroke='none'
                  target-height='285.09998'
                  target-width='106.599976'
                  target-x='379.2'
                  target-y='275.7'
                />
                <path
                  d='M 591.10 275.70 L 485.90 336.90 L 380.00 275.70 L 485.20 214.60 L 591.10 275.70 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,82'
                  node-id='791'
                  stroke='none'
                  target-height='122.29999'
                  target-width='211.09998'
                  target-x='380'
                  target-y='214.6'
                />
                <path
                  d='M 554.50 265.80 L 554.50 274.50 L 485.40 314.80 L 485.60 305.80 L 554.50 265.80 Z'
                  fill='#d4dae8'
                  fill-rule='nonzero'
                  group-id='1,83'
                  node-id='796'
                  stroke='none'
                  target-height='49'
                  target-width='69.100006'
                  target-x='485.4'
                  target-y='265.8'
                />
                <path
                  d='M 485.60 305.80 L 485.40 314.80 L 415.80 274.80 L 416.30 265.80 L 485.60 305.80 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,84'
                  node-id='801'
                  stroke='none'
                  target-height='49'
                  target-width='69.80002'
                  target-x='415.8'
                  target-y='265.8'
                />
                <path
                  d='M 554.50 265.80 L 485.60 305.80 L 416.30 265.80 L 485.20 225.70 L 554.50 265.80 Z'
                  fill='#ffffff'
                  fill-rule='nonzero'
                  group-id='1,85'
                  node-id='806'
                  stroke='none'
                  target-height='80.09999'
                  target-width='138.20001'
                  target-x='416.3'
                  target-y='225.7'
                />
                <path
                  d='M 501.90 345.80 L 501.90 350.80 L 497.60 353.40 L 497.60 348.30 L 501.90 345.80 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,86'
                  node-id='811'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.299988'
                  target-x='497.6'
                  target-y='345.8'
                />
                <path
                  d='M 506.30 348.30 L 506.30 353.30 L 502.00 355.90 L 501.90 350.80 L 506.30 348.30 Z M 510.70 340.80 L 510.70 345.80 L 506.30 348.30 L 506.30 343.30 L 510.70 340.80 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,87'
                  node-id='816'
                  stroke='none'
                  target-height='15.100006'
                  target-width='8.800018'
                  target-x='501.9'
                  target-y='340.8'
                />
                <path
                  d='M 515.10 343.30 L 515.10 348.30 L 510.70 350.80 L 510.70 345.80 L 515.10 343.30 Z M 519.40 335.70 L 519.40 340.70 L 515.10 343.30 L 515.00 338.20 L 519.40 335.70 Z M 523.90 338.20 L 523.90 343.20 L 519.40 345.80 L 519.40 340.70 L 523.90 338.20 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,88'
                  node-id='821'
                  stroke='none'
                  target-height='15.099976'
                  target-width='13.200012'
                  target-x='510.7'
                  target-y='335.7'
                />
                <path
                  d='M 528.20 330.60 L 528.20 335.70 L 523.80 338.20 L 523.80 333.20 L 528.20 330.60 Z M 532.60 333.10 L 532.60 338.20 L 528.20 340.70 L 528.20 335.70 L 532.60 333.10 Z M 537.00 325.60 L 537.00 330.60 L 532.60 333.10 L 532.60 328.10 L 537.00 325.60 Z M 541.30 328.10 L 541.40 333.10 L 537.00 335.60 L 537.00 330.60 L 541.30 328.10 Z M 545.70 320.50 L 545.70 325.60 L 541.30 328.10 L 541.30 323.10 L 545.70 320.50 Z M 550.10 323.00 L 550.10 328.10 L 545.70 330.60 L 545.70 325.60 L 550.10 323.00 Z M 554.40 315.50 L 554.50 320.50 L 550.10 323.00 L 550.10 318.00 L 554.40 315.50 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,89'
                  node-id='826'
                  stroke='none'
                  target-height='25.200012'
                  target-width='30.700012'
                  target-x='523.8'
                  target-y='315.5'
                />
                <path
                  d='M 558.80 318.00 L 558.80 323.00 L 554.50 325.50 L 554.50 320.50 L 558.80 318.00 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,90'
                  node-id='831'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.299988'
                  target-x='554.5'
                  target-y='318'
                />
                <path
                  d='M 563.20 310.40 L 563.20 315.40 L 558.80 318.00 L 558.80 313.00 L 563.20 310.40 Z M 567.60 312.90 L 567.60 317.90 L 563.20 320.50 L 563.20 315.40 L 567.60 312.90 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,91'
                  node-id='836'
                  stroke='none'
                  target-height='10.100006'
                  target-width='8.799988'
                  target-x='558.8'
                  target-y='310.4'
                />
                <path
                  d='M 572.00 305.40 L 572.00 310.40 L 567.60 312.90 L 567.60 307.90 L 572.00 305.40 Z M 576.40 307.90 L 576.40 312.90 L 572.00 315.40 L 572.00 310.40 L 576.40 307.90 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,92'
                  node-id='841'
                  stroke='none'
                  target-height='10'
                  target-width='8.800049'
                  target-x='567.6'
                  target-y='305.4'
                />
                <path
                  d='M 578.30 318.00 L 578.30 321.40 L 495.20 369.40 L 495.20 366.00 L 578.30 318.00 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,93'
                  node-id='846'
                  stroke='none'
                  target-height='51.399994'
                  target-width='83.099976'
                  target-x='495.2'
                  target-y='318'
                />
                <path
                  d='M 501.90 385.80 L 501.90 390.80 L 497.60 393.40 L 497.60 388.30 L 501.90 385.80 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,94'
                  node-id='851'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.299988'
                  target-x='497.6'
                  target-y='385.8'
                />
                <path
                  d='M 506.30 388.30 L 506.30 393.30 L 502.00 395.90 L 501.90 390.80 L 506.30 388.30 Z M 510.70 380.80 L 510.70 385.80 L 506.30 388.30 L 506.30 383.30 L 510.70 380.80 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,95'
                  node-id='856'
                  stroke='none'
                  target-height='15.100006'
                  target-width='8.800018'
                  target-x='501.9'
                  target-y='380.8'
                />
                <path
                  d='M 515.10 383.30 L 515.10 388.30 L 510.70 390.80 L 510.70 385.80 L 515.10 383.30 Z M 519.40 375.70 L 519.40 380.70 L 515.10 383.30 L 515.00 378.20 L 519.40 375.70 Z M 523.90 378.20 L 523.90 383.20 L 519.40 385.80 L 519.40 380.70 L 523.90 378.20 Z M 528.20 370.60 L 528.20 375.70 L 523.80 378.20 L 523.80 373.20 L 528.20 370.60 Z M 532.60 373.10 L 532.60 378.20 L 528.20 380.70 L 528.20 375.70 L 532.60 373.10 Z M 537.00 365.60 L 537.00 370.60 L 532.60 373.10 L 532.60 368.10 L 537.00 365.60 Z M 541.30 368.10 L 541.40 373.10 L 537.00 375.60 L 537.00 370.60 L 541.30 368.10 Z M 545.70 360.50 L 545.70 365.60 L 541.30 368.10 L 541.30 363.10 L 545.70 360.50 Z M 550.10 363.00 L 550.10 368.10 L 545.70 370.60 L 545.70 365.60 L 550.10 363.00 Z M 554.40 355.50 L 554.50 360.50 L 550.10 363.00 L 550.10 358.00 L 554.40 355.50 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,96'
                  node-id='861'
                  stroke='none'
                  target-height='35.299988'
                  target-width='43.799988'
                  target-x='510.7'
                  target-y='355.5'
                />
                <path
                  d='M 558.80 358.00 L 558.80 363.00 L 554.50 365.50 L 554.50 360.50 L 558.80 358.00 Z M 563.20 350.40 L 563.20 355.40 L 558.80 358.00 L 558.80 353.00 L 563.20 350.40 Z M 567.60 352.90 L 567.60 357.90 L 563.20 360.50 L 563.20 355.40 L 567.60 352.90 Z M 572.00 345.40 L 572.00 350.40 L 567.60 352.90 L 567.60 347.90 L 572.00 345.40 Z M 576.40 347.90 L 576.40 352.90 L 572.00 355.40 L 572.00 350.40 L 576.40 347.90 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,97'
                  node-id='866'
                  stroke='none'
                  target-height='20.100006'
                  target-width='21.900024'
                  target-x='554.5'
                  target-y='345.4'
                />
                <path
                  d='M 578.30 358.00 L 578.30 361.40 L 495.20 409.30 L 495.20 406.00 L 578.30 358.00 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,98'
                  node-id='871'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='495.2'
                  target-y='358'
                />
                <path
                  d='M 501.90 425.80 L 501.90 430.80 L 497.60 433.40 L 497.60 428.30 L 501.90 425.80 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,99'
                  node-id='876'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.299988'
                  target-x='497.6'
                  target-y='425.8'
                />
                <path
                  d='M 506.30 428.30 L 506.30 433.30 L 502.00 435.90 L 501.90 430.80 L 506.30 428.30 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,100'
                  node-id='881'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.399994'
                  target-x='501.9'
                  target-y='428.3'
                />
                <path
                  d='M 510.70 420.80 L 510.70 425.80 L 506.30 428.30 L 506.30 423.30 L 510.70 420.80 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,101'
                  node-id='886'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.4000244'
                  target-x='506.3'
                  target-y='420.8'
                />
                <path
                  d='M 515.10 423.30 L 515.10 428.30 L 510.70 430.80 L 510.70 425.80 L 515.10 423.30 Z M 519.40 415.70 L 519.40 420.70 L 515.10 423.30 L 515.00 418.20 L 519.40 415.70 Z M 523.90 418.20 L 523.90 423.20 L 519.40 425.80 L 519.40 420.70 L 523.90 418.20 Z M 528.20 410.60 L 528.20 415.70 L 523.80 418.20 L 523.80 413.20 L 528.20 410.60 Z M 532.60 413.10 L 532.60 418.20 L 528.20 420.70 L 528.20 415.70 L 532.60 413.10 Z M 537.00 405.60 L 537.00 410.60 L 532.60 413.10 L 532.60 408.10 L 537.00 405.60 Z M 541.30 408.10 L 541.40 413.10 L 537.00 415.60 L 537.00 410.60 L 541.30 408.10 Z M 545.70 400.50 L 545.70 405.60 L 541.30 408.10 L 541.30 403.10 L 545.70 400.50 Z M 550.10 403.00 L 550.10 408.10 L 545.70 410.60 L 545.70 405.60 L 550.10 403.00 Z M 554.40 395.50 L 554.50 400.50 L 550.10 403.00 L 550.10 398.00 L 554.40 395.50 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,102'
                  node-id='891'
                  stroke='none'
                  target-height='35.299988'
                  target-width='43.799988'
                  target-x='510.7'
                  target-y='395.5'
                />
                <path
                  d='M 558.80 398.00 L 558.80 403.00 L 554.50 405.50 L 554.50 400.50 L 558.80 398.00 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,103'
                  node-id='896'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.299988'
                  target-x='554.5'
                  target-y='398'
                />
                <path
                  d='M 563.20 390.40 L 563.20 395.40 L 558.80 398.00 L 558.80 393.00 L 563.20 390.40 Z M 567.60 392.90 L 567.60 397.90 L 563.20 400.50 L 563.20 395.40 L 567.60 392.90 Z M 572.00 385.40 L 572.00 390.40 L 567.60 392.90 L 567.60 387.90 L 572.00 385.40 Z M 576.40 387.90 L 576.40 392.90 L 572.00 395.40 L 572.00 390.40 L 576.40 387.90 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,104'
                  node-id='901'
                  stroke='none'
                  target-height='15.100006'
                  target-width='17.600037'
                  target-x='558.8'
                  target-y='385.4'
                />
                <path
                  d='M 578.30 398.00 L 578.30 401.40 L 495.20 449.30 L 495.20 446.00 L 578.30 398.00 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,105'
                  node-id='906'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='495.2'
                  target-y='398'
                />
                <path
                  d='M 501.90 465.80 L 501.90 470.80 L 497.60 473.40 L 497.60 468.30 L 501.90 465.80 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,106'
                  node-id='911'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.299988'
                  target-x='497.6'
                  target-y='465.8'
                />
                <path
                  d='M 506.30 468.30 L 506.30 473.30 L 502.00 475.90 L 501.90 470.80 L 506.30 468.30 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,107'
                  node-id='916'
                  stroke='none'
                  target-height='7.600006'
                  target-width='4.399994'
                  target-x='501.9'
                  target-y='468.3'
                />
                <path
                  d='M 510.70 460.80 L 510.70 465.80 L 506.30 468.30 L 506.30 463.30 L 510.70 460.80 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,108'
                  node-id='921'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.4000244'
                  target-x='506.3'
                  target-y='460.8'
                />
                <path
                  d='M 515.10 463.30 L 515.10 468.30 L 510.70 470.80 L 510.70 465.80 L 515.10 463.30 Z M 519.40 455.70 L 519.40 460.70 L 515.10 463.30 L 515.00 458.20 L 519.40 455.70 Z M 523.90 458.20 L 523.90 463.20 L 519.40 465.80 L 519.40 460.70 L 523.90 458.20 Z M 528.20 450.60 L 528.20 455.70 L 523.80 458.20 L 523.80 453.20 L 528.20 450.60 Z M 532.60 453.10 L 532.60 458.20 L 528.20 460.70 L 528.20 455.70 L 532.60 453.10 Z M 537.00 445.60 L 537.00 450.60 L 532.60 453.10 L 532.60 448.10 L 537.00 445.60 Z M 541.30 448.10 L 541.40 453.10 L 537.00 455.60 L 537.00 450.60 L 541.30 448.10 Z M 545.70 440.50 L 545.70 445.60 L 541.30 448.10 L 541.30 443.10 L 545.70 440.50 Z M 550.10 443.00 L 550.10 448.10 L 545.70 450.60 L 545.70 445.60 L 550.10 443.00 Z M 554.40 435.50 L 554.50 440.50 L 550.10 443.00 L 550.10 438.00 L 554.40 435.50 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,109'
                  node-id='926'
                  stroke='none'
                  target-height='35.299988'
                  target-width='43.799988'
                  target-x='510.7'
                  target-y='435.5'
                />
                <path
                  d='M 558.80 438.00 L 558.80 443.00 L 554.50 445.50 L 554.50 440.50 L 558.80 438.00 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,110'
                  node-id='931'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.299988'
                  target-x='554.5'
                  target-y='438'
                />
                <path
                  d='M 563.20 430.40 L 563.20 435.40 L 558.80 438.00 L 558.80 433.00 L 563.20 430.40 Z M 567.60 432.90 L 567.60 437.90 L 563.20 440.50 L 563.20 435.40 L 567.60 432.90 Z M 572.00 425.40 L 572.00 430.40 L 567.60 432.90 L 567.60 427.90 L 572.00 425.40 Z M 576.40 427.90 L 576.40 432.90 L 572.00 435.40 L 572.00 430.40 L 576.40 427.90 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,111'
                  node-id='936'
                  stroke='none'
                  target-height='15.100006'
                  target-width='17.600037'
                  target-x='558.8'
                  target-y='425.4'
                />
                <path
                  d='M 578.30 438.00 L 578.30 441.40 L 495.20 489.30 L 495.20 486.00 L 578.30 438.00 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,112'
                  node-id='941'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='495.2'
                  target-y='438'
                />
                <path
                  d='M 501.90 505.80 L 501.90 510.80 L 497.60 513.40 L 497.60 508.30 L 501.90 505.80 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,113'
                  node-id='946'
                  stroke='none'
                  target-height='7.6000366'
                  target-width='4.299988'
                  target-x='497.6'
                  target-y='505.8'
                />
                <path
                  d='M 506.30 508.30 L 506.30 513.30 L 502.00 515.90 L 501.90 510.80 L 506.30 508.30 Z M 510.70 500.80 L 510.70 505.80 L 506.30 508.30 L 506.30 503.30 L 510.70 500.80 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,114'
                  node-id='951'
                  stroke='none'
                  target-height='15.100037'
                  target-width='8.800018'
                  target-x='501.9'
                  target-y='500.8'
                />
                <path
                  d='M 515.10 503.30 L 515.10 508.30 L 510.70 510.80 L 510.70 505.80 L 515.10 503.30 Z M 519.40 495.70 L 519.40 500.70 L 515.10 503.30 L 515.00 498.20 L 519.40 495.70 Z M 523.90 498.20 L 523.90 503.20 L 519.40 505.80 L 519.40 500.70 L 523.90 498.20 Z M 528.20 490.60 L 528.20 495.70 L 523.80 498.20 L 523.80 493.20 L 528.20 490.60 Z M 532.60 493.10 L 532.60 498.20 L 528.20 500.70 L 528.20 495.70 L 532.60 493.10 Z M 537.00 485.60 L 537.00 490.60 L 532.60 493.10 L 532.60 488.10 L 537.00 485.60 Z M 541.30 488.10 L 541.40 493.10 L 537.00 495.60 L 537.00 490.60 L 541.30 488.10 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,115'
                  node-id='956'
                  stroke='none'
                  target-height='25.199982'
                  target-width='30.700012'
                  target-x='510.7'
                  target-y='485.6'
                />
                <path
                  d='M 545.70 480.50 L 545.70 485.60 L 541.30 488.10 L 541.30 483.10 L 545.70 480.50 Z M 550.10 483.00 L 550.10 488.10 L 545.70 490.60 L 545.70 485.60 L 550.10 483.00 Z M 554.40 475.50 L 554.50 480.50 L 550.10 483.00 L 550.10 478.00 L 554.40 475.50 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,116'
                  node-id='961'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.200012'
                  target-x='541.3'
                  target-y='475.5'
                />
                <path
                  d='M 558.80 478.00 L 558.80 483.00 L 554.50 485.50 L 554.50 480.50 L 558.80 478.00 Z M 563.20 470.40 L 563.20 475.40 L 558.80 478.00 L 558.80 473.00 L 563.20 470.40 Z M 567.60 472.90 L 567.60 477.90 L 563.20 480.50 L 563.20 475.40 L 567.60 472.90 Z M 572.00 465.40 L 572.00 470.40 L 567.60 472.90 L 567.60 467.90 L 572.00 465.40 Z M 576.40 467.90 L 576.40 472.90 L 572.00 475.40 L 572.00 470.40 L 576.40 467.90 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,117'
                  node-id='966'
                  stroke='none'
                  target-height='20.100006'
                  target-width='21.900024'
                  target-x='554.5'
                  target-y='465.4'
                />
                <path
                  d='M 578.30 478.00 L 578.30 481.40 L 495.20 529.30 L 495.20 526.00 L 578.30 478.00 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,118'
                  node-id='971'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='495.2'
                  target-y='478'
                />
                <path
                  d='M 386.90 297.30 L 386.90 300.30 L 478.30 353.10 L 478.30 350.10 L 386.90 297.30 Z M 386.80 312.40 L 386.80 315.40 L 478.20 368.10 L 478.20 365.10 L 386.80 312.40 Z M 386.80 319.90 L 386.80 322.90 L 478.20 375.70 L 478.20 372.70 L 386.80 319.90 Z M 386.90 304.80 L 386.90 307.80 L 478.30 360.60 L 478.30 357.60 L 386.90 304.80 Z M 386.70 350.00 L 386.70 353.00 L 478.10 405.80 L 478.10 402.80 L 386.70 350.00 Z M 386.80 342.50 L 386.80 345.50 L 478.10 398.20 L 478.20 395.20 L 386.80 342.50 Z M 386.80 334.90 L 386.80 337.90 L 478.20 390.70 L 478.20 387.70 L 386.80 334.90 Z M 386.80 327.40 L 386.80 330.40 L 478.20 383.20 L 478.20 380.20 L 386.80 327.40 Z M 386.90 430.70 L 386.90 433.70 L 478.30 486.50 L 478.30 483.50 L 386.90 430.70 Z M 386.80 445.80 L 386.80 448.80 L 478.20 501.60 L 478.20 498.60 L 386.80 445.80 Z M 386.80 453.30 L 386.80 456.30 L 478.20 509.10 L 478.20 506.10 L 386.80 453.30 Z M 386.90 438.30 L 386.90 441.30 L 478.30 494.00 L 478.30 491.00 L 386.90 438.30 Z M 386.70 483.40 L 386.70 486.40 L 478.10 539.20 L 478.10 536.20 L 386.70 483.40 Z M 386.80 475.90 L 386.80 478.90 L 478.10 531.70 L 478.20 528.70 L 386.80 475.90 Z M 386.80 468.40 L 386.80 471.40 L 478.20 524.10 L 478.20 521.10 L 386.80 468.40 Z M 386.80 460.80 L 386.80 463.90 L 478.20 516.60 L 478.20 513.60 L 386.80 460.80 Z'
                  fill='#4562ef'
                  fill-rule='nonzero'
                  group-id='1,119'
                  node-id='976'
                  stroke='none'
                  target-height='241.90002'
                  target-width='91.599976'
                  target-x='386.7'
                  target-y='297.3'
                />
                <path
                  d='M 463.00 349.20 L 462.30 573.10 L 357.10 634.20 L 357.80 410.30 L 463.00 349.20 Z'
                  fill='#37617b'
                  fill-rule='nonzero'
                  group-id='1,120'
                  node-id='981'
                  stroke='none'
                  target-height='285'
                  target-width='105.899994'
                  target-x='357.1'
                  target-y='349.2'
                />
                <path
                  d='M 456.20 361.00 L 453.80 362.40 L 453.20 567.80 L 455.60 569.20 L 456.20 361.00 Z'
                  fill='#416e84'
                  fill-rule='nonzero'
                  group-id='1,121'
                  node-id='986'
                  stroke='none'
                  target-height='208.20001'
                  target-width='3'
                  target-x='453.2'
                  target-y='361'
                />
                <path
                  d='M 453.20 567.80 L 363.90 619.70 L 363.90 622.50 L 455.60 569.20 L 453.20 567.80 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,122'
                  node-id='991'
                  stroke='none'
                  target-height='54.700012'
                  target-width='91.70001'
                  target-x='363.9'
                  target-y='567.8'
                />
                <path
                  d='M 453.60 362.20 L 364.40 414.10 L 363.80 619.50 L 453.10 567.60 L 453.60 362.20 Z'
                  fill='#30596d'
                  fill-rule='nonzero'
                  group-id='1,123'
                  node-id='996'
                  stroke='none'
                  target-height='257.3'
                  target-width='89.80002'
                  target-x='363.8'
                  target-y='362.2'
                />
                <path
                  d='M 357.70 410.30 L 357.10 634.20 L 251.20 573.10 L 251.80 349.20 L 357.70 410.30 Z'
                  fill='#416e84'
                  fill-rule='nonzero'
                  group-id='1,124'
                  node-id='1001'
                  stroke='none'
                  target-height='285'
                  target-width='106.500015'
                  target-x='251.2'
                  target-y='349.2'
                />
                <path
                  d='M 463.00 349.20 L 357.80 410.30 L 251.90 349.20 L 357.10 288.10 L 463.00 349.20 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,125'
                  node-id='1006'
                  stroke='none'
                  target-height='122.19998'
                  target-width='211.1'
                  target-x='251.9'
                  target-y='288.1'
                />
                <path
                  d='M 426.40 339.20 L 426.40 348.00 L 357.30 388.30 L 357.60 379.30 L 426.40 339.20 Z'
                  fill='#d4dae8'
                  fill-rule='nonzero'
                  group-id='1,126'
                  node-id='1011'
                  stroke='none'
                  target-height='49.099976'
                  target-width='69.100006'
                  target-x='357.3'
                  target-y='339.2'
                />
                <path
                  d='M 357.50 379.30 L 357.30 388.30 L 287.80 348.30 L 288.20 339.20 L 357.50 379.30 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,127'
                  node-id='1016'
                  stroke='none'
                  target-height='49.099976'
                  target-width='69.70001'
                  target-x='287.8'
                  target-y='339.2'
                />
                <path
                  d='M 426.40 339.20 L 357.50 379.30 L 288.20 339.20 L 357.10 299.20 L 426.40 339.20 Z'
                  fill='#ffffff'
                  fill-rule='nonzero'
                  group-id='1,128'
                  node-id='1021'
                  stroke='none'
                  target-height='80.099976'
                  target-width='138.19998'
                  target-x='288.2'
                  target-y='299.2'
                />
                <path
                  d='M 373.90 419.30 L 373.90 424.30 L 369.50 426.80 L 369.50 421.80 L 373.90 419.30 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,129'
                  node-id='1026'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='369.5'
                  target-y='419.3'
                />
                <path
                  d='M 378.30 421.80 L 378.30 426.80 L 373.90 429.30 L 373.90 424.30 L 378.30 421.80 Z M 382.60 414.20 L 382.60 419.30 L 378.20 421.80 L 378.20 416.80 L 382.60 414.20 Z M 387.00 416.70 L 387.00 421.80 L 382.60 424.30 L 382.60 419.30 L 387.00 416.70 Z M 391.40 409.20 L 391.40 414.20 L 387.00 416.70 L 387.00 411.70 L 391.40 409.20 Z M 395.80 411.70 L 395.80 416.70 L 391.40 419.20 L 391.40 414.20 L 395.80 411.70 Z M 400.10 404.10 L 400.10 409.10 L 395.80 411.70 L 395.80 406.60 L 400.10 404.10 Z M 404.50 406.60 L 404.50 411.60 L 400.20 414.20 L 400.10 409.10 L 404.50 406.60 Z M 408.90 399.10 L 408.90 404.10 L 404.50 406.60 L 404.50 401.60 L 408.90 399.10 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,130'
                  node-id='1031'
                  stroke='none'
                  target-height='30.199982'
                  target-width='35'
                  target-x='373.9'
                  target-y='399.1'
                />
                <path
                  d='M 413.30 401.60 L 413.30 406.60 L 408.90 409.10 L 408.90 404.10 L 413.30 401.60 Z M 417.60 394.00 L 417.60 399.00 L 413.30 401.60 L 413.30 396.50 L 417.60 394.00 Z M 422.00 396.50 L 422.00 401.50 L 417.70 404.10 L 417.60 399.00 L 422.00 396.50 Z M 426.40 389.00 L 426.40 394.00 L 422.00 396.50 L 422.00 391.50 L 426.40 389.00 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,131'
                  node-id='1036'
                  stroke='none'
                  target-height='20.100006'
                  target-width='17.5'
                  target-x='408.9'
                  target-y='389'
                />
                <path
                  d='M 430.80 391.50 L 430.80 396.50 L 426.40 399.00 L 426.40 394.00 L 430.80 391.50 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,132'
                  node-id='1041'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='426.4'
                  target-y='391.5'
                />
                <path
                  d='M 435.20 383.90 L 435.20 388.90 L 430.80 391.50 L 430.70 386.40 L 435.20 383.90 Z M 439.50 386.40 L 439.60 391.40 L 435.20 394.00 L 435.20 388.90 L 439.50 386.40 Z M 443.90 378.80 L 443.90 383.90 L 439.50 386.40 L 439.50 381.40 L 443.90 378.80 Z M 448.30 381.40 L 448.30 386.40 L 443.90 388.90 L 443.90 383.90 L 448.30 381.40 Z'
                  fill='#f9bb4a'
                  fill-rule='nonzero'
                  group-id='1,133'
                  node-id='1046'
                  stroke='none'
                  target-height='15.200012'
                  target-width='17.599976'
                  target-x='430.7'
                  target-y='378.8'
                />
                <path
                  d='M 450.20 391.50 L 450.30 394.80 L 367.20 442.80 L 367.20 439.40 L 450.20 391.50 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,134'
                  node-id='1051'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='367.2'
                  target-y='391.5'
                />
                <path
                  d='M 373.90 459.30 L 373.90 464.30 L 369.50 466.80 L 369.50 461.80 L 373.90 459.30 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,135'
                  node-id='1056'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='369.5'
                  target-y='459.3'
                />
                <path
                  d='M 378.30 461.80 L 378.30 466.80 L 373.90 469.30 L 373.90 464.30 L 378.30 461.80 Z M 382.60 454.20 L 382.60 459.30 L 378.20 461.80 L 378.20 456.80 L 382.60 454.20 Z M 387.00 456.70 L 387.00 461.80 L 382.60 464.30 L 382.60 459.30 L 387.00 456.70 Z M 391.40 449.20 L 391.40 454.20 L 387.00 456.70 L 387.00 451.70 L 391.40 449.20 Z M 395.80 451.70 L 395.80 456.70 L 391.40 459.20 L 391.40 454.20 L 395.80 451.70 Z M 400.10 444.10 L 400.10 449.10 L 395.80 451.70 L 395.80 446.60 L 400.10 444.10 Z M 404.50 446.60 L 404.50 451.60 L 400.20 454.20 L 400.10 449.10 L 404.50 446.60 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,136'
                  node-id='1061'
                  stroke='none'
                  target-height='25.199982'
                  target-width='30.600006'
                  target-x='373.9'
                  target-y='444.1'
                />
                <path
                  d='M 408.90 439.10 L 408.90 444.10 L 404.50 446.60 L 404.50 441.60 L 408.90 439.10 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,137'
                  node-id='1066'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='404.5'
                  target-y='439.1'
                />
                <path
                  d='M 413.30 441.60 L 413.30 446.60 L 408.90 449.10 L 408.90 444.10 L 413.30 441.60 Z M 417.60 434.00 L 417.60 439.00 L 413.30 441.60 L 413.30 436.50 L 417.60 434.00 Z M 422.00 436.50 L 422.00 441.50 L 417.70 444.10 L 417.60 439.00 L 422.00 436.50 Z M 426.40 429.00 L 426.40 434.00 L 422.00 436.50 L 422.00 431.50 L 426.40 429.00 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,138'
                  node-id='1071'
                  stroke='none'
                  target-height='20.100006'
                  target-width='17.5'
                  target-x='408.9'
                  target-y='429'
                />
                <path
                  d='M 430.80 431.50 L 430.80 436.50 L 426.40 439.00 L 426.40 434.00 L 430.80 431.50 Z M 435.20 423.90 L 435.20 428.90 L 430.80 431.50 L 430.70 426.40 L 435.20 423.90 Z M 439.50 426.40 L 439.60 431.40 L 435.20 433.90 L 435.20 428.90 L 439.50 426.40 Z M 443.90 418.80 L 443.90 423.90 L 439.50 426.40 L 439.50 421.40 L 443.90 418.80 Z M 448.30 421.30 L 448.30 426.40 L 443.90 428.90 L 443.90 423.90 L 448.30 421.30 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,139'
                  node-id='1076'
                  stroke='none'
                  target-height='20.200012'
                  target-width='21.899994'
                  target-x='426.4'
                  target-y='418.8'
                />
                <path
                  d='M 450.20 431.50 L 450.30 434.80 L 367.20 482.80 L 367.20 479.40 L 450.20 431.50 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,140'
                  node-id='1081'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='367.2'
                  target-y='431.5'
                />
                <path
                  d='M 373.90 499.30 L 373.90 504.30 L 369.50 506.80 L 369.50 501.80 L 373.90 499.30 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,141'
                  node-id='1086'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='369.5'
                  target-y='499.3'
                />
                <path
                  d='M 378.30 501.80 L 378.30 506.80 L 373.90 509.30 L 373.90 504.30 L 378.30 501.80 Z M 382.60 494.20 L 382.60 499.30 L 378.20 501.80 L 378.20 496.80 L 382.60 494.20 Z M 387.00 496.70 L 387.00 501.80 L 382.60 504.30 L 382.60 499.30 L 387.00 496.70 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,142'
                  node-id='1091'
                  stroke='none'
                  target-height='15.099976'
                  target-width='13.100006'
                  target-x='373.9'
                  target-y='494.2'
                />
                <path
                  d='M 391.40 489.20 L 391.40 494.20 L 387.00 496.70 L 387.00 491.70 L 391.40 489.20 Z M 395.80 491.70 L 395.80 496.70 L 391.40 499.20 L 391.40 494.20 L 395.80 491.70 Z M 400.10 484.10 L 400.10 489.10 L 395.80 491.70 L 395.80 486.60 L 400.10 484.10 Z M 404.50 486.60 L 404.50 491.60 L 400.20 494.20 L 400.10 489.10 L 404.50 486.60 Z M 408.90 479.10 L 408.90 484.10 L 404.50 486.60 L 404.50 481.60 L 408.90 479.10 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,143'
                  node-id='1096'
                  stroke='none'
                  target-height='20.100006'
                  target-width='21.899994'
                  target-x='387'
                  target-y='479.1'
                />
                <path
                  d='M 413.30 481.60 L 413.30 486.60 L 408.90 489.10 L 408.90 484.10 L 413.30 481.60 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,144'
                  node-id='1101'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='408.9'
                  target-y='481.6'
                />
                <path
                  d='M 417.60 474.00 L 417.60 479.00 L 413.30 481.60 L 413.30 476.50 L 417.60 474.00 Z M 422.00 476.50 L 422.00 481.50 L 417.70 484.10 L 417.60 479.00 L 422.00 476.50 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,145'
                  node-id='1106'
                  stroke='none'
                  target-height='10.100006'
                  target-width='8.700012'
                  target-x='413.3'
                  target-y='474'
                />
                <path
                  d='M 426.40 469.00 L 426.40 474.00 L 422.00 476.50 L 422.00 471.50 L 426.40 469.00 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,146'
                  node-id='1111'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='422'
                  target-y='469'
                />
                <path
                  d='M 430.80 471.50 L 430.80 476.50 L 426.40 479.00 L 426.40 474.00 L 430.80 471.50 Z M 435.20 463.90 L 435.20 468.90 L 430.80 471.50 L 430.70 466.40 L 435.20 463.90 Z M 439.50 466.40 L 439.60 471.40 L 435.20 473.90 L 435.20 468.90 L 439.50 466.40 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,147'
                  node-id='1116'
                  stroke='none'
                  target-height='15.100006'
                  target-width='13.200012'
                  target-x='426.4'
                  target-y='463.9'
                />
                <path
                  d='M 443.90 458.80 L 443.90 463.90 L 439.50 466.40 L 439.50 461.40 L 443.90 458.80 Z M 448.30 461.30 L 448.30 466.40 L 443.90 468.90 L 443.90 463.90 L 448.30 461.30 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,148'
                  node-id='1121'
                  stroke='none'
                  target-height='10.100006'
                  target-width='8.799988'
                  target-x='439.5'
                  target-y='458.8'
                />
                <path
                  d='M 450.20 471.50 L 450.30 474.80 L 367.20 522.80 L 367.20 519.40 L 450.20 471.50 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,149'
                  node-id='1126'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='367.2'
                  target-y='471.5'
                />
                <path
                  d='M 373.90 539.30 L 373.90 544.30 L 369.50 546.80 L 369.50 541.80 L 373.90 539.30 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,150'
                  node-id='1131'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='369.5'
                  target-y='539.3'
                />
                <path
                  d='M 378.30 541.80 L 378.30 546.80 L 373.90 549.30 L 373.90 544.30 L 378.30 541.80 Z M 382.60 534.20 L 382.60 539.30 L 378.20 541.80 L 378.20 536.80 L 382.60 534.20 Z M 387.00 536.70 L 387.00 541.80 L 382.60 544.30 L 382.60 539.30 L 387.00 536.70 Z M 391.40 529.20 L 391.40 534.20 L 387.00 536.70 L 387.00 531.70 L 391.40 529.20 Z M 395.80 531.70 L 395.80 536.70 L 391.40 539.20 L 391.40 534.20 L 395.80 531.70 Z M 400.10 524.10 L 400.10 529.10 L 395.80 531.70 L 395.80 526.60 L 400.10 524.10 Z M 404.50 526.60 L 404.50 531.60 L 400.20 534.20 L 400.10 529.10 L 404.50 526.60 Z M 408.90 519.10 L 408.90 524.10 L 404.50 526.60 L 404.50 521.60 L 408.90 519.10 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,151'
                  node-id='1136'
                  stroke='none'
                  target-height='30.200012'
                  target-width='35'
                  target-x='373.9'
                  target-y='519.1'
                />
                <path
                  d='M 413.30 521.60 L 413.30 526.60 L 408.90 529.10 L 408.90 524.10 L 413.30 521.60 Z M 417.60 514.00 L 417.60 519.00 L 413.30 521.60 L 413.30 516.50 L 417.60 514.00 Z M 422.00 516.50 L 422.00 521.50 L 417.70 524.10 L 417.60 519.00 L 422.00 516.50 Z M 426.40 509.00 L 426.40 514.00 L 422.00 516.50 L 422.00 511.50 L 426.40 509.00 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,152'
                  node-id='1141'
                  stroke='none'
                  target-height='20.099976'
                  target-width='17.5'
                  target-x='408.9'
                  target-y='509'
                />
                <path
                  d='M 430.80 511.50 L 430.80 516.50 L 426.40 519.00 L 426.40 514.00 L 430.80 511.50 Z M 435.20 503.90 L 435.20 508.90 L 430.80 511.50 L 430.70 506.40 L 435.20 503.90 Z M 439.50 506.40 L 439.60 511.40 L 435.20 513.90 L 435.20 508.90 L 439.50 506.40 Z M 443.90 498.80 L 443.90 503.90 L 439.50 506.40 L 439.50 501.40 L 443.90 498.80 Z M 448.30 501.30 L 448.30 506.40 L 443.90 508.90 L 443.90 503.90 L 448.30 501.30 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,153'
                  node-id='1146'
                  stroke='none'
                  target-height='20.200012'
                  target-width='21.899994'
                  target-x='426.4'
                  target-y='498.8'
                />
                <path
                  d='M 450.20 511.50 L 450.30 514.80 L 367.20 562.80 L 367.20 559.40 L 450.20 511.50 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,154'
                  node-id='1151'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='367.2'
                  target-y='511.5'
                />
                <path
                  d='M 373.90 579.30 L 373.90 584.30 L 369.50 586.80 L 369.50 581.80 L 373.90 579.30 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,155'
                  node-id='1156'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='369.5'
                  target-y='579.3'
                />
                <path
                  d='M 378.30 581.80 L 378.30 586.80 L 373.90 589.30 L 373.90 584.30 L 378.30 581.80 Z M 382.60 574.20 L 382.60 579.30 L 378.20 581.80 L 378.20 576.80 L 382.60 574.20 Z M 387.00 576.70 L 387.00 581.80 L 382.60 584.30 L 382.60 579.30 L 387.00 576.70 Z M 391.40 569.20 L 391.40 574.20 L 387.00 576.70 L 387.00 571.70 L 391.40 569.20 Z M 395.80 571.70 L 395.80 576.70 L 391.40 579.20 L 391.40 574.20 L 395.80 571.70 Z M 400.10 564.10 L 400.10 569.10 L 395.80 571.70 L 395.80 566.60 L 400.10 564.10 Z M 404.50 566.60 L 404.50 571.60 L 400.20 574.20 L 400.10 569.10 L 404.50 566.60 Z M 408.90 559.10 L 408.90 564.10 L 404.50 566.60 L 404.50 561.60 L 408.90 559.10 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,156'
                  node-id='1161'
                  stroke='none'
                  target-height='30.200012'
                  target-width='35'
                  target-x='373.9'
                  target-y='559.1'
                />
                <path
                  d='M 413.30 561.60 L 413.30 566.60 L 408.90 569.10 L 408.90 564.10 L 413.30 561.60 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,157'
                  node-id='1166'
                  stroke='none'
                  target-height='7.5'
                  target-width='4.399994'
                  target-x='408.9'
                  target-y='561.6'
                />
                <path
                  d='M 417.60 554.00 L 417.60 559.00 L 413.30 561.60 L 413.30 556.50 L 417.60 554.00 Z M 422.00 556.50 L 422.00 561.50 L 417.70 564.10 L 417.60 559.00 L 422.00 556.50 Z M 426.40 549.00 L 426.40 554.00 L 422.00 556.50 L 422.00 551.50 L 426.40 549.00 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,158'
                  node-id='1171'
                  stroke='none'
                  target-height='15.099976'
                  target-width='13.100006'
                  target-x='413.3'
                  target-y='549'
                />
                <path
                  d='M 430.80 551.50 L 430.80 556.50 L 426.40 559.00 L 426.40 554.00 L 430.80 551.50 Z M 435.20 543.90 L 435.20 548.90 L 430.80 551.50 L 430.70 546.40 L 435.20 543.90 Z M 439.50 546.40 L 439.60 551.40 L 435.20 553.90 L 435.20 548.90 L 439.50 546.40 Z M 443.90 538.80 L 443.90 543.90 L 439.50 546.40 L 439.50 541.40 L 443.90 538.80 Z M 448.30 541.30 L 448.30 546.40 L 443.90 548.90 L 443.90 543.90 L 448.30 541.30 Z'
                  fill='#9ad898'
                  fill-rule='nonzero'
                  group-id='1,159'
                  node-id='1176'
                  stroke='none'
                  target-height='20.200012'
                  target-width='21.899994'
                  target-x='426.4'
                  target-y='538.8'
                />
                <path
                  d='M 450.20 551.50 L 450.30 554.80 L 367.20 602.80 L 367.20 599.40 L 450.20 551.50 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,160'
                  node-id='1181'
                  stroke='none'
                  target-height='51.299988'
                  target-width='83.099976'
                  target-x='367.2'
                  target-y='551.5'
                />
                <path
                  d='M 258.80 370.80 L 258.80 373.80 L 350.20 426.60 L 350.20 423.60 L 258.80 370.80 Z M 258.80 385.80 L 258.80 388.80 L 350.20 441.60 L 350.20 438.60 L 258.80 385.80 Z M 258.80 393.40 L 258.80 396.40 L 350.10 449.10 L 350.10 446.10 L 258.80 393.40 Z M 258.80 378.30 L 258.80 381.30 L 350.20 434.10 L 350.20 431.10 L 258.80 378.30 Z M 258.70 423.50 L 258.70 426.50 L 350.10 479.20 L 350.10 476.20 L 258.70 423.50 Z M 258.70 415.90 L 258.70 418.90 L 350.10 471.70 L 350.10 468.70 L 258.70 415.90 Z M 258.70 408.40 L 258.70 411.40 L 350.10 464.20 L 350.10 461.20 L 258.70 408.40 Z M 258.70 400.90 L 258.70 403.90 L 350.10 456.70 L 350.10 453.70 L 258.70 400.90 Z M 258.80 504.20 L 258.80 507.20 L 350.20 560.00 L 350.20 557.00 L 258.80 504.20 Z M 258.80 519.30 L 258.80 522.30 L 350.20 575.00 L 350.20 572.00 L 258.80 519.30 Z M 258.80 526.80 L 258.80 529.80 L 350.10 582.60 L 350.10 579.60 L 258.80 526.80 Z M 258.80 511.70 L 258.80 514.80 L 350.20 567.50 L 350.20 564.50 L 258.80 511.70 Z M 258.70 556.90 L 258.70 559.90 L 350.10 612.70 L 350.10 609.70 L 258.70 556.90 Z M 258.70 549.40 L 258.70 552.40 L 350.10 605.10 L 350.10 602.10 L 258.70 549.40 Z M 258.70 541.80 L 258.70 544.90 L 350.10 597.60 L 350.10 594.60 L 258.70 541.80 Z M 258.70 534.30 L 258.70 537.30 L 350.10 590.10 L 350.10 587.10 L 258.70 534.30 Z'
                  fill='#30596d'
                  fill-rule='nonzero'
                  group-id='1,161'
                  node-id='1186'
                  stroke='none'
                  target-height='241.90002'
                  target-width='91.5'
                  target-x='258.7'
                  target-y='370.8'
                />
                <path
                  d='M 515.00 987.50 L 512.50 986.80 L 42.00 715.20 L 40.40 713.70 L 36.80 708.70 L 36.10 707.30 L 35.90 705.70 L 36.10 704.10 L 36.90 702.60 L 40.70 697.80 L 42.20 696.40 L 234.90 588.30 L 237.40 587.70 L 239.80 588.50 L 240.80 589.30 L 242.10 591.60 L 242.30 592.90 L 241.70 595.30 L 239.90 597.20 L 47.40 705.90 L 48.10 706.90 L 515.00 976.40 L 581.80 935.80 L 584.40 935.10 L 586.90 935.70 L 588.80 937.60 L 589.60 940.10 L 589.00 942.70 L 587.10 944.60 L 517.70 986.80 L 515.00 987.50 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,162'
                  node-id='1191'
                  stroke='none'
                  target-height='399.8'
                  target-width='553.69995'
                  target-x='35.9'
                  target-y='587.7'
                />
                <path
                  d='M 477.70 650.40 L 790.80 468.50 L 790.20 691.00 L 477.10 872.90 L 477.70 650.40 Z'
                  fill='#5b5e71'
                  fill-rule='nonzero'
                  group-id='1,163'
                  node-id='1196'
                  stroke='none'
                  target-height='404.40002'
                  target-width='313.69998'
                  target-x='477.1'
                  target-y='468.5'
                />
                <path
                  d='M 491.20 658.20 L 777.20 492.00 L 776.70 683.20 L 490.70 849.40 L 491.20 658.20 Z'
                  fill='#ffffff'
                  fill-rule='nonzero'
                  group-id='1,164'
                  node-id='1201'
                  stroke='none'
                  target-height='357.40002'
                  target-width='286.5'
                  target-x='490.7'
                  target-y='492'
                />
                <path
                  d='M 464.00 642.50 L 777.10 460.60 L 790.80 468.50 L 477.70 650.40 L 464.00 642.50 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,165'
                  node-id='1206'
                  stroke='none'
                  target-height='189.80002'
                  target-width='326.8'
                  target-x='464'
                  target-y='460.6'
                />
                <path
                  d='M 691.90 996.50 L 1005.00 814.60 L 1005.00 830.30 L 691.90 1012.30 L 691.90 996.50 Z'
                  fill='#cad0dd'
                  fill-rule='nonzero'
                  group-id='1,166'
                  node-id='1211'
                  stroke='none'
                  target-height='197.70001'
                  target-width='313.09998'
                  target-x='691.9'
                  target-y='814.6'
                />
                <path
                  d='M 477.10 872.90 L 790.20 691.00 L 1005.00 814.60 L 691.90 996.50 L 477.10 872.90 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,167'
                  node-id='1216'
                  stroke='none'
                  target-height='305.5'
                  target-width='527.9'
                  target-x='477.1'
                  target-y='691'
                />
                <path
                  d='M 504.00 872.90 L 790.20 706.60 L 901.80 770.90 L 615.70 937.20 L 504.00 872.90 Z'
                  fill='#cad0dd'
                  fill-rule='nonzero'
                  group-id='1,168'
                  node-id='1221'
                  stroke='none'
                  target-height='230.60004'
                  target-width='397.8'
                  target-x='504'
                  target-y='706.6'
                />
                <path
                  d='M 477.70 650.40 L 477.10 872.90 L 691.90 996.50 L 691.90 1012.30 L 463.30 880.70 L 464.00 642.50 L 477.70 650.40 Z'
                  fill='#d4dae8'
                  fill-rule='nonzero'
                  group-id='1,169'
                  node-id='1226'
                  stroke='none'
                  target-height='369.8'
                  target-width='228.60004'
                  target-x='463.3'
                  target-y='642.5'
                />
                <path
                  d='M 621.50 873.40 L 639.20 883.60 L 657.00 873.40 L 639.30 863.10 L 621.50 873.40 Z M 596.10 858.60 L 613.80 868.90 L 631.60 858.60 L 613.80 848.30 L 596.10 858.60 Z M 570.70 843.80 L 588.40 854.10 L 606.10 843.80 L 588.40 833.60 L 570.70 843.80 Z M 621.40 902.90 L 639.10 913.20 L 657.00 902.90 L 639.30 892.60 L 621.40 902.90 Z M 596.00 917.60 L 613.70 927.80 L 631.50 917.60 L 613.70 907.30 L 596.00 917.60 Z M 570.60 902.80 L 588.30 913.10 L 631.50 888.10 L 613.80 877.80 L 570.60 902.80 Z M 570.60 873.30 L 588.30 883.60 L 606.10 873.30 L 588.40 863.00 L 570.60 873.30 Z M 545.20 858.50 L 562.90 868.80 L 580.70 858.50 L 563.00 848.20 L 545.20 858.50 Z M 519.70 873.20 L 537.40 883.50 L 555.20 873.30 L 537.50 863.00 L 519.70 873.20 Z M 647.00 858.70 L 664.70 869.00 L 682.40 858.70 L 664.70 848.40 L 647.00 858.70 Z M 850.70 770.50 L 868.40 780.80 L 886.10 770.60 L 868.40 760.30 L 850.70 770.50 Z M 825.30 755.70 L 843.00 766.00 L 860.70 755.80 L 843.00 745.50 L 825.30 755.70 Z M 799.80 741.00 L 817.50 751.20 L 835.30 741.00 L 817.60 730.70 L 799.80 741.00 Z M 723.40 755.60 L 741.20 765.90 L 758.90 755.60 L 741.20 745.30 L 723.40 755.60 Z M 698.00 770.30 L 715.70 780.60 L 733.50 770.30 L 715.80 760.00 L 698.00 770.30 Z M 748.90 770.40 L 766.60 780.70 L 809.80 755.70 L 792.10 745.40 L 748.90 770.40 Z M 672.50 785.00 L 690.20 795.30 L 708.00 785.10 L 690.20 774.80 L 672.50 785.00 Z M 723.40 785.10 L 741.10 795.40 L 758.90 785.10 L 741.20 774.80 L 723.40 785.10 Z M 774.30 785.20 L 792.00 795.40 L 809.80 785.20 L 792.10 774.90 L 774.30 785.20 Z M 647.10 799.70 L 664.80 810.00 L 682.50 799.80 L 664.80 789.40 L 647.10 799.70 Z M 697.90 799.80 L 715.60 810.10 L 733.40 799.80 L 715.70 789.50 L 697.90 799.80 Z M 748.90 799.80 L 766.60 810.10 L 784.30 799.90 L 766.60 789.60 L 748.90 799.80 Z'
                  fill='#5b5e71'
                  fill-rule='nonzero'
                  group-id='1,170'
                  node-id='1231'
                  stroke='none'
                  target-height='197.09998'
                  target-width='366.39996'
                  target-x='519.7'
                  target-y='730.7'
                />
                <path
                  d='M 799.70 770.40 L 825.20 785.20 L 799.70 799.90 L 817.40 810.20 L 860.60 785.30 L 817.40 760.20 L 799.70 770.40 Z M 672.50 814.50 L 690.20 824.80 L 707.90 814.50 L 690.20 804.20 L 672.50 814.50 Z M 723.30 814.60 L 741.10 824.90 L 758.80 814.60 L 741.10 804.30 L 723.30 814.60 Z M 774.30 814.60 L 792.00 824.90 L 809.70 814.70 L 792.00 804.40 L 774.30 814.60 Z M 647.00 829.20 L 664.80 839.50 L 682.50 829.20 L 664.80 818.90 L 647.00 829.20 Z M 697.90 829.30 L 715.60 839.50 L 733.40 829.30 L 715.70 819.00 L 697.90 829.30 Z M 621.50 843.90 L 639.20 854.20 L 657.00 843.90 L 639.30 833.60 L 621.50 843.90 Z M 672.50 843.90 L 690.20 854.20 L 707.90 844.00 L 690.20 833.70 L 672.50 843.90 Z M 646.90 888.10 L 664.70 898.40 L 784.20 829.40 L 766.50 819.10 L 646.90 888.10 Z M 596.10 829.10 L 613.80 839.40 L 631.60 829.20 L 613.90 818.90 L 596.10 829.10 Z M 621.60 814.40 L 639.30 824.70 L 657.10 814.40 L 639.40 804.10 L 621.60 814.40 Z M 774.40 726.20 L 792.10 736.50 L 809.90 726.20 L 792.20 715.90 L 774.40 726.20 Z M 748.90 740.90 L 766.60 751.20 L 784.30 741.00 L 766.60 730.70 L 748.90 740.90 Z M 545.10 888.00 L 562.90 898.30 L 580.60 888.00 L 562.90 877.70 L 545.10 888.00 Z'
                  fill='#5b5e71'
                  fill-rule='nonzero'
                  group-id='1,171'
                  node-id='1236'
                  stroke='none'
                  target-height='182.5'
                  target-width='315.5'
                  target-x='545.1'
                  target-y='715.9'
                />
                <path
                  d='M 720.40 893.50 L 719.30 894.40 L 718.50 896.30 L 718.60 897.30 L 719.20 898.20 L 720.40 899.10 L 767.90 926.70 L 769.30 927.30 L 772.70 927.80 L 776.10 927.30 L 777.50 926.70 L 846.50 886.90 L 847.60 886.00 L 848.30 885.10 L 848.50 884.10 L 848.30 883.20 L 847.70 882.20 L 846.50 881.30 L 799.00 853.70 L 795.90 852.70 L 792.50 852.70 L 789.40 853.70 L 720.40 893.50 Z'
                  fill='#cad0dd'
                  fill-rule='nonzero'
                  group-id='1,172'
                  node-id='1241'
                  stroke='none'
                  target-height='75.099976'
                  target-width='130'
                  target-x='718.5'
                  target-y='852.7'
                />
                <path
                  d='M 765.00 631.50 L 764.20 639.40 L 763.20 643.50 L 760.00 651.50 L 758.00 655.50 L 755.60 659.20 L 750.20 666.00 L 747.10 669.00 L 740.70 673.70 L 665.30 717.10 L 662.50 718.50 L 660.00 719.30 L 655.70 719.70 L 653.70 719.30 L 651.90 718.50 L 650.30 717.40 L 648.90 715.80 L 647.80 714.00 L 647.00 711.90 L 646.20 706.30 L 646.80 700.30 L 649.20 692.60 L 651.50 688.10 L 654.10 683.90 L 657.20 680.10 L 656.70 674.60 L 657.50 666.80 L 660.00 658.70 L 663.80 650.90 L 666.10 647.20 L 671.50 640.50 L 677.70 635.00 L 680.90 632.90 L 684.40 631.20 L 687.50 630.10 L 690.30 629.70 L 691.80 624.90 L 693.70 620.20 L 696.10 615.60 L 698.80 611.20 L 701.70 607.10 L 705.00 603.30 L 708.50 599.80 L 712.20 596.80 L 716.00 594.30 L 720.00 592.40 L 723.60 591.20 L 726.90 590.60 L 729.90 590.60 L 732.90 591.20 L 735.50 592.40 L 737.80 594.00 L 739.90 596.30 L 741.40 598.90 L 742.60 602.00 L 743.30 605.70 L 743.70 610.10 L 743.30 616.20 L 746.50 615.00 L 749.30 614.40 L 751.90 614.20 L 754.30 614.50 L 756.60 615.20 L 758.70 616.30 L 760.50 617.90 L 762.10 619.90 L 763.30 622.10 L 764.20 624.70 L 764.80 627.80 L 765.00 631.50 Z'
                  fill='#fed57a'
                  fill-rule='nonzero'
                  group-id='1,173'
                  node-id='1246'
                  stroke='none'
                  target-height='129.10004'
                  target-width='118.79999'
                  target-x='646.2'
                  target-y='590.6'
                />
                <path
                  d='M 583.30 737.60 L 584.40 738.30 L 584.50 762.90 L 583.40 764.80 L 561.80 777.20 L 560.70 776.60 L 560.60 752.00 L 561.70 750.10 L 583.30 737.60 Z'
                  fill='#75ca75'
                  fill-rule='nonzero'
                  group-id='1,174'
                  node-id='1251'
                  stroke='none'
                  target-height='39.600037'
                  target-width='23.900024'
                  target-x='560.6'
                  target-y='737.6'
                />
                <path
                  d='M 620.20 716.30 L 621.50 716.90 L 621.50 741.50 L 620.30 743.50 L 598.90 755.80 L 597.80 755.20 L 597.70 730.60 L 598.80 728.70 L 620.20 716.30 Z'
                  fill='#576cfb'
                  fill-rule='nonzero'
                  group-id='1,175'
                  node-id='1256'
                  stroke='none'
                  target-height='39.5'
                  target-width='23.799988'
                  target-x='597.7'
                  target-y='716.3'
                />
                <path
                  d='M 634.30 680.10 L 634.30 686.60 L 523.50 750.50 L 523.50 744.00 L 634.30 680.10 Z M 591.00 679.20 L 591.10 685.70 L 523.50 724.70 L 523.40 718.20 L 591.00 679.20 Z M 650.00 619.20 L 650.00 625.70 L 523.40 698.90 L 523.40 692.40 L 650.00 619.20 Z M 692.00 569.10 L 692.00 575.60 L 523.30 673.00 L 523.30 666.50 L 692.00 569.10 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,176'
                  node-id='1261'
                  stroke='none'
                  target-height='181.40002'
                  target-width='168.70001'
                  target-x='523.3'
                  target-y='569.1'
                />
                <path
                  d='M 546.20 759.00 L 547.30 759.70 L 547.40 784.30 L 546.30 786.20 L 524.80 798.60 L 523.70 798.00 L 523.60 773.40 L 524.70 771.50 L 546.20 759.00 Z'
                  fill='#fa5168'
                  fill-rule='nonzero'
                  group-id='1,177'
                  node-id='1266'
                  stroke='none'
                  target-height='39.599976'
                  target-width='23.800049'
                  target-x='523.6'
                  target-y='759'
                />
                <path
                  d='M 71.30 696.00 L 74.20 698.00 L 76.40 700.00 L 78.10 702.00 L 79.20 704.10 L 80.00 706.40 L 80.30 708.60 L 80.00 710.80 L 79.30 713.10 L 78.10 715.20 L 76.50 717.20 L 74.30 719.20 L 71.40 721.10 L 68.30 722.70 L 61.20 725.00 L 53.70 726.20 L 49.70 726.30 L 41.90 725.80 L 34.50 724.00 L 28.00 721.10 L 25.10 719.20 L 22.80 717.20 L 21.20 715.10 L 20.00 713.10 L 19.20 710.80 L 19.00 708.60 L 19.20 706.40 L 19.90 704.10 L 21.10 702.00 L 22.70 700.00 L 25.00 698.00 L 27.90 696.00 L 34.30 693.20 L 41.70 691.40 L 49.50 690.80 L 57.30 691.40 L 64.70 693.20 L 71.30 696.00 Z'
                  fill='#748bfd'
                  fill-rule='nonzero'
                  group-id='1,178'
                  node-id='1271'
                  stroke='none'
                  target-height='35.5'
                  target-width='61.300003'
                  target-x='19'
                  target-y='690.8'
                />
                <path
                  d='M 543.30 969.90 L 546.20 971.80 L 548.50 973.80 L 550.10 975.80 L 551.30 977.90 L 552.00 980.20 L 552.30 982.40 L 552.10 984.60 L 551.30 986.90 L 550.20 989.00 L 548.50 991.00 L 546.30 993.00 L 543.40 995.00 L 536.90 997.80 L 533.30 998.90 L 525.70 1000.00 L 521.70 1000.10 L 517.80 1000.00 L 510.20 998.80 L 506.60 997.80 L 500.10 995.00 L 497.10 993.00 L 494.90 991.00 L 493.20 989.00 L 492.00 986.90 L 491.30 984.60 L 491.00 982.40 L 491.20 980.20 L 492.00 977.90 L 493.10 975.80 L 494.80 973.80 L 497.00 971.80 L 499.90 969.90 L 506.40 967.00 L 510.00 965.90 L 517.60 964.80 L 521.60 964.60 L 525.50 964.80 L 533.10 965.90 L 536.80 967.00 L 543.30 969.90 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,179'
                  node-id='1276'
                  stroke='none'
                  target-height='35.5'
                  target-width='61.299988'
                  target-x='491'
                  target-y='964.6'
                />
                <path
                  d='M 682.60 75.60 L 620.40 111.40 L 623.70 109.80 L 627.10 108.50 L 630.80 107.60 L 634.70 107.00 L 638.90 106.90 L 644.00 107.30 L 649.30 108.30 L 655.10 110.00 L 661.20 112.50 L 723.40 76.70 L 717.30 74.20 L 711.50 72.50 L 706.20 71.40 L 701.10 71.10 L 696.90 71.20 L 693.00 71.70 L 689.30 72.60 L 685.90 73.90 L 682.60 75.60 Z'
                  fill='#cad0dd'
                  fill-rule='nonzero'
                  group-id='1,180'
                  node-id='1281'
                  stroke='none'
                  target-height='41.4'
                  target-width='103'
                  target-x='620.4'
                  target-y='71.1'
                />
                <path
                  d='M 682.50 46.60 L 686.10 44.80 L 689.90 43.40 L 693.90 42.30 L 698.20 41.70 L 702.50 41.50 L 706.90 41.70 L 711.70 42.30 L 716.70 43.40 L 726.50 46.70 L 737.30 52.10 L 743.20 55.80 L 749.10 60.00 L 754.80 64.70 L 760.50 69.90 L 771.00 81.00 L 780.80 93.50 L 786.80 102.40 L 792.20 111.60 L 797.10 121.10 L 801.50 130.90 L 805.20 140.70 L 808.20 150.60 L 859.50 120.80 L 856.50 110.90 L 852.80 101.10 L 848.40 91.30 L 843.50 81.80 L 838.10 72.60 L 832.10 63.80 L 822.30 51.30 L 811.80 40.20 L 806.10 35.00 L 800.40 30.40 L 794.50 26.20 L 788.60 22.40 L 777.80 17.00 L 768.00 13.70 L 763.00 12.60 L 758.20 11.90 L 753.80 11.70 L 749.50 11.90 L 745.20 12.60 L 741.20 13.60 L 737.40 15.00 L 733.80 16.80 L 682.50 46.60 Z M 914.40 398.00 L 965.70 368.20 L 968.40 366.40 L 970.80 364.30 L 973.10 361.80 L 975.10 358.80 L 977.00 355.50 L 978.70 351.20 L 980.00 346.30 L 980.90 340.70 L 981.20 334.40 L 981.00 328.30 L 980.30 322.00 L 979.10 315.50 L 977.50 309.10 L 975.40 302.70 L 970.10 289.90 L 963.30 277.80 L 959.40 272.00 L 950.90 261.30 L 899.60 291.10 L 908.20 301.70 L 912.00 307.50 L 918.80 319.70 L 924.10 332.40 L 926.20 338.90 L 927.80 345.30 L 929.00 351.70 L 929.70 358.00 L 929.90 364.20 L 929.60 370.50 L 928.70 376.10 L 927.40 381.00 L 925.70 385.20 L 923.90 388.60 L 921.80 391.50 L 919.60 394.00 L 917.10 396.20 L 914.40 398.00 Z'
                  fill='#d4dae8'
                  fill-rule='nonzero'
                  group-id='1,181'
                  node-id='1286'
                  stroke='none'
                  target-height='386.3'
                  target-width='298.7'
                  target-x='682.5'
                  target-y='11.7'
                />
                <path
                  d='M 899.60 291.10 L 950.90 261.30 L 952.20 250.40 L 952.20 239.90 L 951.60 233.40 L 950.50 226.70 L 949.10 219.90 L 946.60 211.00 L 943.40 202.00 L 939.60 193.10 L 935.30 184.40 L 930.50 176.00 L 925.20 167.90 L 919.40 160.10 L 913.30 152.90 L 906.80 146.20 L 901.60 141.40 L 896.40 137.10 L 891.10 133.30 L 885.60 129.90 L 880.90 127.30 L 872.10 123.50 L 867.60 122.20 L 859.50 120.80 L 808.20 150.60 L 816.40 152.00 L 825.10 155.00 L 834.30 159.60 L 839.80 163.00 L 845.10 166.90 L 850.40 171.20 L 855.50 175.90 L 862.00 182.60 L 868.10 189.90 L 873.90 197.70 L 879.20 205.80 L 884.00 214.20 L 888.40 222.90 L 892.20 231.80 L 895.30 240.70 L 897.80 249.70 L 899.30 256.50 L 900.30 263.20 L 900.90 269.70 L 900.90 280.10 L 899.60 291.10 Z'
                  fill='#cad0dd'
                  fill-rule='nonzero'
                  group-id='1,182'
                  node-id='1291'
                  stroke='none'
                  target-height='170.3'
                  target-width='144'
                  target-x='808.2'
                  target-y='120.8'
                />
                <path
                  d='M 737.20 52.10 L 730.70 48.60 L 724.40 45.90 L 718.60 43.90 L 713.00 42.50 L 707.10 41.70 L 701.70 41.50 L 696.60 41.90 L 691.80 42.80 L 687.20 44.30 L 682.80 46.40 L 678.80 49.00 L 675.10 52.20 L 671.80 55.90 L 668.90 60.00 L 666.30 64.70 L 664.10 70.10 L 662.40 75.60 L 661.10 81.70 L 660.30 88.40 L 660.00 95.80 L 660.10 101.40 L 661.20 112.50 L 655.90 110.30 L 650.90 108.70 L 646.20 107.60 L 641.70 107.00 L 637.50 106.90 L 633.10 107.20 L 629.00 108.00 L 625.20 109.10 L 621.60 110.70 L 618.20 112.80 L 615.10 115.20 L 612.30 118.00 L 609.70 121.20 L 607.30 124.90 L 605.20 129.10 L 603.60 133.30 L 602.30 138.00 L 601.30 143.10 L 600.60 148.70 L 600.40 154.90 L 600.50 161.30 L 601.10 167.90 L 602.20 174.70 L 603.60 181.60 L 606.20 190.60 L 609.30 199.60 L 613.10 208.60 L 617.50 217.30 L 622.30 225.80 L 627.70 234.00 L 633.50 241.80 L 639.70 249.10 L 646.20 255.90 L 651.40 260.60 L 656.70 265.00 L 662.10 268.80 L 667.50 272.30 L 876.80 394.20 L 882.50 397.10 L 887.80 399.30 L 892.70 400.60 L 897.30 401.30 L 901.20 401.50 L 904.80 401.20 L 908.10 400.50 L 911.30 399.50 L 914.20 398.10 L 916.90 396.30 L 919.40 394.20 L 921.70 391.60 L 923.80 388.70 L 925.60 385.40 L 927.40 381.10 L 928.70 376.10 L 929.60 370.50 L 929.90 364.20 L 929.70 358.00 L 929.00 351.70 L 927.80 345.30 L 926.20 338.90 L 924.10 332.40 L 921.60 326.00 L 915.60 313.60 L 908.20 301.70 L 899.60 291.10 L 900.90 280.10 L 900.90 269.70 L 900.30 263.20 L 899.20 256.50 L 897.80 249.70 L 895.30 240.70 L 892.10 231.80 L 888.40 222.90 L 884.00 214.20 L 879.20 205.80 L 873.90 197.70 L 868.10 189.90 L 862.00 182.60 L 855.50 175.90 L 850.40 171.20 L 845.10 166.90 L 839.80 163.00 L 834.30 159.60 L 825.10 155.00 L 816.40 152.00 L 808.20 150.60 L 803.40 135.80 L 797.10 121.10 L 792.20 111.60 L 786.80 102.40 L 780.80 93.60 L 771.00 81.10 L 760.50 69.90 L 754.80 64.80 L 749.10 60.10 L 743.20 55.90 L 737.20 52.10 Z'
                  fill='#e4e8f4'
                  fill-rule='nonzero'
                  group-id='1,183'
                  node-id='1296'
                  stroke='none'
                  target-height='360'
                  target-width='329.5'
                  target-x='600.4'
                  target-y='41.5'
                />
                <path
                  d='M 760.80 196.10 L 776.20 202.90 L 777.10 199.80 L 779.50 194.50 L 770.20 175.40 L 783.20 168.00 L 794.30 184.80 L 797.70 184.60 L 801.00 184.80 L 804.20 185.60 L 806.00 170.40 L 824.10 180.80 L 825.70 197.90 L 829.20 201.30 L 835.60 208.60 L 846.90 204.80 L 859.70 227.10 L 850.20 235.30 L 852.20 241.60 L 853.50 247.50 L 869.00 258.60 L 869.00 279.50 L 852.30 272.20 L 850.80 275.70 L 848.90 278.70 L 859.50 300.30 L 846.60 307.60 L 832.50 286.80 L 829.30 286.50 L 825.90 285.70 L 823.70 305.30 L 805.60 294.80 L 803.50 272.80 L 797.00 266.30 L 782.90 270.80 L 770.00 248.60 L 780.70 239.40 L 778.80 234.20 L 777.30 228.90 L 760.70 217.00 L 760.80 196.10 Z M 814.70 269.40 L 818.80 271.40 L 822.40 272.60 L 825.60 273.10 L 828.60 273.10 L 831.60 272.50 L 834.20 271.40 L 836.50 269.70 L 838.50 267.50 L 840.00 264.90 L 841.20 261.80 L 842.00 258.10 L 842.30 253.70 L 842.10 249.30 L 841.40 244.80 L 840.20 240.20 L 836.60 231.20 L 834.30 226.80 L 828.80 218.60 L 825.60 214.90 L 822.20 211.60 L 818.60 208.70 L 814.90 206.30 L 810.90 204.30 L 807.30 203.10 L 804.00 202.60 L 801.10 202.60 L 798.10 203.20 L 795.50 204.30 L 793.20 206.00 L 791.20 208.20 L 789.60 210.80 L 788.50 213.90 L 787.70 217.60 L 787.40 222.00 L 787.60 226.40 L 788.30 230.90 L 789.50 235.50 L 793.00 244.50 L 795.40 249.00 L 798.00 253.20 L 804.10 260.80 L 807.50 264.10 L 811.10 267.00 L 814.70 269.40 Z'
                  fill='#4c7891'
                  fill-rule='nonzero'
                  group-id='1,184'
                  node-id='1301'
                  stroke='none'
                  target-height='139.6'
                  target-width='108.29999'
                  target-x='760.7'
                  target-y='168'
                />
                <path
                  d='M 690.90 105.00 L 702.70 109.30 L 703.60 105.60 L 704.80 102.40 L 697.00 87.80 L 706.40 81.10 L 715.50 93.60 L 720.20 93.20 L 722.90 93.50 L 723.50 81.30 L 737.40 88.40 L 739.40 101.90 L 743.40 105.50 L 747.10 109.60 L 755.50 105.90 L 766.00 122.50 L 759.30 129.70 L 761.00 134.60 L 762.20 139.20 L 774.30 146.90 L 775.10 163.60 L 762.40 158.90 L 761.40 161.80 L 760.20 164.30 L 768.90 180.70 L 759.70 187.50 L 748.20 171.80 L 743.30 171.60 L 742.50 187.20 L 728.60 180.20 L 726.10 162.90 L 721.00 158.10 L 710.60 162.70 L 700.10 146.00 L 707.60 137.90 L 704.70 129.90 L 691.80 121.70 L 690.90 105.00 Z M 711.90 123.70 L 712.90 130.40 L 713.90 133.90 L 715.90 138.90 L 718.50 143.70 L 721.60 148.30 L 725.10 152.30 L 727.60 154.80 L 732.90 158.60 L 737.40 160.60 L 740.10 161.30 L 742.60 161.50 L 744.80 161.30 L 746.90 160.60 L 748.80 159.50 L 750.50 158.10 L 751.90 156.10 L 752.90 154.00 L 753.70 151.50 L 754.10 148.50 L 754.10 144.90 L 753.10 138.20 L 752.10 134.80 L 750.10 129.80 L 747.50 124.90 L 744.40 120.40 L 741.00 116.30 L 738.40 113.90 L 733.10 110.00 L 728.60 108.00 L 725.90 107.30 L 723.50 107.10 L 721.20 107.30 L 719.10 108.00 L 717.20 109.10 L 715.60 110.60 L 714.10 112.50 L 713.10 114.70 L 712.40 117.20 L 711.90 120.20 L 711.90 123.70 Z'
                  fill='#f9607f'
                  fill-rule='nonzero'
                  group-id='1,185'
                  node-id='1306'
                  stroke='none'
                  target-height='106.4'
                  target-width='84.19995'
                  target-x='690.9'
                  target-y='81.1'
                />
                <path
                  d='M 686.70 212.30 L 698.50 216.50 L 699.40 212.80 L 700.60 209.70 L 692.90 195.10 L 702.20 188.40 L 711.20 200.90 L 715.90 200.50 L 718.70 200.80 L 719.20 188.50 L 733.20 195.60 L 735.20 209.10 L 739.10 212.60 L 743.00 216.90 L 751.20 213.10 L 761.70 229.80 L 755.00 237.00 L 756.80 241.80 L 758.00 246.50 L 770.00 254.20 L 770.90 270.80 L 758.10 266.20 L 757.20 269.10 L 755.90 271.60 L 764.70 288.00 L 755.40 294.70 L 744.00 279.20 L 739.10 278.90 L 738.30 294.50 L 724.30 287.40 L 721.80 270.10 L 716.80 265.40 L 706.40 270.00 L 695.80 253.30 L 703.40 245.10 L 700.40 237.20 L 687.60 228.90 L 686.70 212.30 Z M 707.70 230.90 L 708.70 237.60 L 709.70 241.10 L 711.70 246.10 L 714.30 251.00 L 717.30 255.50 L 720.80 259.60 L 726.00 264.10 L 730.10 266.60 L 733.10 267.90 L 735.90 268.60 L 738.30 268.80 L 740.50 268.50 L 742.70 267.90 L 744.60 266.80 L 746.20 265.30 L 747.60 263.40 L 748.70 261.20 L 749.40 258.70 L 749.80 255.70 L 749.90 252.20 L 748.80 245.50 L 747.80 242.00 L 745.80 237.00 L 743.20 232.10 L 740.10 227.50 L 736.60 223.50 L 731.40 218.90 L 727.40 216.50 L 724.40 215.20 L 721.70 214.50 L 719.20 214.30 L 717.00 214.60 L 714.80 215.20 L 712.90 216.30 L 711.30 217.80 L 709.90 219.70 L 708.80 221.90 L 708.10 224.40 L 707.70 227.40 L 707.70 230.90 Z'
                  fill='#bac1ce'
                  fill-rule='nonzero'
                  group-id='1,186'
                  node-id='1311'
                  stroke='none'
                  target-height='106.30002'
                  target-width='84.20001'
                  target-x='686.7'
                  target-y='188.4'
                />
              </g>
            </g>
          </svg>
        )}
      />
    </>
  );
};
