/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

export const CPUIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M818.176 894.976H206.848c-43.008 0-78.848-34.816-78.848-78.848V204.8c0-43.008 34.816-78.848 78.848-78.848h611.328c43.008 0 78.848 34.816 78.848 78.848v611.328c0 43.008-35.84 78.848-78.848 78.848zM206.848 186.368c-10.24 0-18.432 8.192-18.432 18.432v611.328c0 10.24 8.192 18.432 18.432 18.432h611.328c10.24 0 18.432-8.192 18.432-18.432V204.8c0-10.24-8.192-18.432-18.432-18.432H206.848z'
              fill='#6462F3'
            ></path>
            <path
              d='M701.44 715.776H323.584c-4.096 0-8.192-4.096-8.192-8.192V313.344c0-4.096 4.096-8.192 8.192-8.192h377.856c4.096 0 8.192 4.096 8.192 8.192v395.264c0 4.096-3.072 7.168-8.192 7.168z'
              fill='#D7D7FF'
            ></path>
            <path
              d='M631.808 643.072H393.216c-4.096 0-8.192-4.096-8.192-8.192V386.048c0-4.096 4.096-8.192 8.192-8.192h238.592c4.096 0 8.192 4.096 8.192 8.192V634.88c0 5.12-3.072 8.192-8.192 8.192zM963.584 415.744h-98.304c-16.384 0-30.72-13.312-30.72-30.72s13.312-30.72 30.72-30.72h98.304c16.384 0 30.72 13.312 30.72 30.72s-14.336 30.72-30.72 30.72zM963.584 540.672h-98.304c-16.384 0-30.72-13.312-30.72-30.72 0-16.384 13.312-30.72 30.72-30.72h98.304c16.384 0 30.72 13.312 30.72 30.72s-14.336 30.72-30.72 30.72zM963.584 665.6h-98.304c-16.384 0-30.72-13.312-30.72-30.72s13.312-30.72 30.72-30.72h98.304c16.384 0 30.72 13.312 30.72 30.72s-14.336 30.72-30.72 30.72zM632.832 999.424c-16.384 0-29.696-13.312-30.72-29.696v-102.4c0-16.384 13.312-30.72 29.696-30.72 16.384 0 29.696 13.312 30.72 29.696v102.4c0 16.384-13.312 30.72-29.696 30.72zM513.024 999.424c-16.384 0-30.72-13.312-30.72-29.696v-102.4c0-16.384 13.312-30.72 29.696-30.72 16.384 0 30.72 13.312 30.72 29.696v102.4c0 17.408-13.312 30.72-29.696 30.72zM393.216 1006.592c-16.384 0-30.72-13.312-30.72-29.696v-102.4c0-16.384 13.312-30.72 29.696-30.72 16.384 0 30.72 13.312 30.72 29.696v102.4c1.024 17.408-13.312 30.72-29.696 30.72z'
              fill='#6462F3'
            ></path>
            <path
              d='M632.832 177.152c-16.384 0-29.696-13.312-30.72-29.696v-102.4c0-16.384 13.312-30.72 29.696-30.72 16.384 0 29.696 13.312 30.72 29.696v102.4c0 17.408-13.312 30.72-29.696 30.72zM513.024 177.152c-16.384 0-30.72-13.312-30.72-29.696v-102.4c0-16.384 13.312-30.72 29.696-30.72 16.384 0 30.72 13.312 30.72 29.696v102.4c0 17.408-13.312 30.72-29.696 30.72zM393.216 185.344c-16.384 0-30.72-13.312-30.72-29.696v-102.4c0-16.384 13.312-30.72 29.696-30.72 16.384 0 30.72 13.312 30.72 29.696v102.4c1.024 16.384-13.312 30.72-29.696 30.72z'
              fill='#6462F3'
            ></path>
            <path
              d='M155.648 415.744H57.344c-16.384 0-30.72-13.312-30.72-30.72s13.312-30.72 30.72-30.72h98.304c16.384 0 30.72 13.312 30.72 30.72s-14.336 30.72-30.72 30.72zM155.648 540.672H57.344c-16.384 0-30.72-13.312-30.72-30.72 0-16.384 13.312-30.72 30.72-30.72h98.304c16.384 0 30.72 13.312 30.72 30.72s-14.336 30.72-30.72 30.72zM155.648 665.6H57.344c-16.384 0-30.72-13.312-30.72-30.72s13.312-30.72 30.72-30.72h98.304c16.384 0 30.72 13.312 30.72 30.72s-14.336 30.72-30.72 30.72z'
              fill='#6462F3'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const HeapIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M512 512m-512 0a512 512 0 1 0 1024 0 512 512 0 1 0-1024 0Z'
              fill='#3396FA'
            ></path>
            <path
              d='M371.2 302.933333L512 221.866667l140.8 81.066666v162.133334L512 546.133333l-140.8-81.066666V302.933333z m29.866667 17.066667v123.733333l110.933333 64 110.933333-64V320L512 260.266667 401.066667 320z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M371.2 302.933333L512 384v162.133333l-140.8-81.066666V302.933333zM512 384l140.8-81.066667v162.133334L512 546.133333V384z m34.133333 106.666667l76.8-42.666667v-85.333333l-76.8 42.666666v85.333334z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M243.2 516.266667L384 435.2l140.8 81.066667v162.133333L384 759.466667l-140.8-81.066667v-162.133333z m34.133333 17.066666v123.733334l110.933334 64 110.933333-64v-123.733334l-110.933333-59.733333-110.933334 59.733333z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M243.2 516.266667L384 597.333333v162.133334l-140.8-81.066667v-162.133333zM388.266667 597.333333l140.8-81.066666v162.133333l-140.8 81.066667V597.333333z m29.866666 106.666667l76.8-42.666667v-85.333333l-76.8 42.666667v85.333333z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M494.933333 516.266667l140.8-81.066667 140.8 81.066667v162.133333l-140.8 81.066667-140.8-81.066667v-162.133333z m34.133334 17.066666v123.733334l110.933333 64 110.933333-64v-123.733334L640 473.6c-4.266667 0-110.933333 59.733333-110.933333 59.733333z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M494.933333 516.266667l140.8 81.066666v162.133334l-140.8-81.066667v-162.133333z m140.8 81.066666l140.8-81.066666v162.133333l-140.8 81.066667V597.333333z m34.133334 106.666667l76.8-42.666667v-85.333333l-76.8 42.666667v85.333333z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ThreadIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M961.592889 0.398222H63.687111C31.829333 0.398222 0 25.884444 0 64.085333V732.728889c0 38.229333 25.486222 70.058667 63.687111 70.058667h891.534222c31.857778 0 63.687111-25.486222 63.687111-63.687112V57.742222c6.371556-31.857778-25.486222-57.315556-57.315555-57.315555z'
              fill='#5077FD'
            ></path>
            <path
              d='M853.333333 369.777778h-159.203555l-108.259556 108.231111c-6.371556 0-19.114667 6.371556-31.857778 0-12.714667-6.371556-12.714667-6.371556-12.714666-19.114667l-38.200889-159.203555-82.773333 331.150222c-6.4 12.743111-19.143111 25.486222-25.486223 25.486222-6.371556 0-25.486222-12.743111-31.857777-25.486222L318.407111 369.777778H165.575111c-19.114667 0-25.486222-12.743111-25.486222-25.457778 0-12.743111 12.743111-31.857778 25.486222-31.857778h171.946667c12.714667 0 25.457778 12.743111 25.457778 25.486222l31.857777 159.203556 82.773334-331.150222c0-12.743111 12.743111-25.486222 25.486222-25.486222 12.714667 0 25.457778 12.743111 25.457778 25.486222l44.572444 235.605333 76.430222-76.401778c6.371556-6.371556 12.743111-6.371556 25.457778-6.371555h171.946667c19.114667 0 25.486222 12.743111 25.486222 25.486222 6.371556 19.086222-6.371556 25.457778-19.114667 25.457778z'
              fill='#FFD92F'
            ></path>
            <path
              d='M846.961778 930.133333H171.946667c-19.114667 0-38.229333 19.114667-38.229334 38.229334 0 19.086222 19.114667 44.572444 38.229334 44.572444h675.015111c19.114667 0 38.200889-19.114667 38.200889-38.200889 0-19.114667-19.086222-44.572444-38.200889-44.572444z'
              fill='#20C997'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const OutHeapIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M690.45248 735.66208h0.55808c19.73248 0 35.91168-16.256 35.91168-35.84 0-19.73248-16.1792-35.92192-35.91168-35.92192h-0.55808c-19.67104 0-35.85024 16.18432-35.85024 35.92192-0.64 20.224 16.1792 35.84 35.85024 35.84z m0 145.30048h0.55808c19.73248 0 35.91168-16.1792 35.91168-35.92192 0-19.66592-16.1792-35.92192-35.91168-35.92192h-0.55808c-19.67104 0-35.85024 16.256-35.85024 35.92192-0.64 19.16416 16.1792 35.92192 35.85024 35.92192z m144.64-145.30048h0.56832c19.6608 0 35.84512-16.256 35.84512-35.84 0-19.73248-16.18432-35.92192-35.84512-35.92192h-0.56832c-19.73248 0-35.9168 16.18432-35.9168 35.92192 0.00512 20.224 16.82944 35.84 35.9168 35.84z m0 145.30048h0.56832c19.6608 0 35.84512-16.1792 35.84512-35.92192 0-19.66592-16.18432-35.92192-35.84512-35.92192h-0.56832c-19.73248 0-35.9168 16.256-35.9168 35.92192 0.00512 19.16416 16.82944 35.92192 35.9168 35.92192z m-289.30048 0h0.64c19.6608 0 35.84-16.1792 35.84-35.92192 0-19.66592-16.1792-35.92192-35.84-35.92192h-0.64c-19.58912 0-35.80928 16.256-35.80928 35.92192-0.00512 19.16416 16.78336 35.92192 35.80928 35.92192z m0-145.30048h0.64c19.6608 0 35.84-16.256 35.84-35.84 0-19.73248-16.1792-35.92192-35.84-35.92192h-0.64c-19.58912 0-35.80928 16.18432-35.80928 35.92192-0.00512 20.224 16.78336 35.84 35.80928 35.84z m-373.07392 145.30048h96.60416c13.30688 0 24.27392-10.99776 24.27392-24.27904v-23.20384c0-13.27616-10.97216-24.35072-24.27392-24.35072H172.71808c-13.30688 0-24.30976 11.07456-24.30976 24.35072v22.64064c-0.56832 13.83424 10.40384 24.84224 24.30976 24.84224z m0-145.30048h96.60416c13.30688 0 24.27392-10.99776 24.27392-24.34048v-22.5792c0-13.27104-10.97216-24.2688-24.27392-24.2688H172.71808c-13.30688 0-24.30976 10.99776-24.30976 24.2688v22.5792c-0.56832 13.33248 10.40384 24.34048 24.30976 24.34048z m228.48512 145.30048h0.60416c19.6608 0 35.84512-16.1792 35.84512-35.92192 0-19.66592-16.18432-35.92192-35.84512-35.92192h-0.60416c-19.6608 0-35.84512 16.256-35.84512 35.92192-0.60416 19.16416 16.18432 35.92192 35.84512 35.92192z m0-145.30048h0.60416c19.6608 0 35.84512-16.256 35.84512-35.84 0-19.73248-16.18432-35.92192-35.84512-35.92192h-0.60416c-19.6608 0-35.84512 16.18432-35.84512 35.92192-0.60416 20.224 16.18432 35.84 35.84512 35.84z m618.43456-146.432h0.55808L944.96768 37.04832c-2.27328-17.95584-17.88928-31.26784-35.84-31.26784H116.57728c-17.92 0-33.536 13.312-35.84512 31.26784L3.22048 589.23008H3.7888l-0.56832 0.56832v391.86944c0 22.56896 19.09248 41.66656 41.63072 41.66656h934.26176c22.56896 0 41.66656-19.09248 41.66656-41.66656v-391.86944l-1.14176-0.56832z m-71.75168 361.7024H76.68736v-362.27072h871.19872v362.27072z'
              fill='#227FF1'
            ></path>
            <path
              d='M350.50496 108.416h322.98496l97.28512 344.69888H253.22496l97.28-344.69888z'
              fill='#A6D3FF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
