/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

export const ClusterInstanceIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M629.4528 924.8256H397.312a285.7472 285.7472 0 0 1-251.5968-153.344 284.16 284.16 0 0 1-30.0032-176.9984c0-2.304 0.768-4.6592 1.1776-6.9632l1.024-5.3248 1.536 1.536a4.352 4.352 0 0 1 1.28 2.4064c0.8192 2.56 1.536 5.2224 2.304 7.7824 1.5872 5.4784 3.2256 11.1616 5.12 16.384 14.9504 41.472 36.9664 80.0256 65.024 114.0224a14.4896 14.4896 0 0 1 2.56 4.6592A180.3776 180.3776 0 0 0 247.808 808.448c24.576 21.6576 53.504 37.888 84.8896 47.5136a254.2592 254.2592 0 0 1-57.6-34.048 186.2144 186.2144 0 0 1-60.7744-81.1008 14.848 14.848 0 0 1-0.5632-11.264 34.816 34.816 0 0 0 1.2288-4.4032c0-1.024 0.5632-2.048 0.9216-3.072 5.2224-19.0464 15.5136-36.352 29.7984-50.176 14.08-12.6976 30.976-21.8624 49.3568-26.7264 19.3024-5.12 38.912-8.704 58.7776-10.6496l8.192-1.024c10.9056-1.4336 21.9136-3.072 32.9728-4.7104l6.4-1.024 7.2704-1.3824 5.888-1.28-1.536 2.7136v0.512a166.4 166.4 0 0 0-25.088 37.2736 5.2736 5.2736 0 0 1-2.9696 2.56l-4.3008 1.3824c-4.5568 1.6896-9.216 3.0208-13.9264 3.9936-5.12 1.024-10.3424 1.7408-15.4624 2.4576-5.12 0.768-8.192 1.1776-12.1856 1.8944-11.7248 1.536-22.784 6.1952-32.1024 13.4656a40.8064 40.8064 0 0 1 5.376-1.024 42.9568 42.9568 0 0 0 7.3216-1.4336 129.024 129.024 0 0 1 43.264-6.4H380.4672l-0.4096 1.4848a184.2176 184.2176 0 0 0 1.024 116.1216 202.752 202.752 0 0 1-3.072-71.68 151.296 151.296 0 0 1 45.1584-88.4736 219.4432 219.4432 0 0 1 65.28-42.1888 411.8016 411.8016 0 0 1 70.5536-22.016l4.352-1.024c16.4864-3.9424 32.9216-8.192 49.408-12.8a158.6176 158.6176 0 0 0 71.68-43.3664 146.688 146.688 0 0 1 59.7504-46.8992 4.9152 4.9152 0 0 0 1.8944-1.792 78.848 78.848 0 0 1 28.16-28.16 14.0288 14.0288 0 0 1 16.4352 1.3312c1.0752 0.9216 2.1504 1.792 3.072 2.7136a48.64 48.64 0 0 1 9.9328 15.2576 1.7408 1.7408 0 0 0 1.536 1.1264c2.9184 0 5.7856 0.768 8.7552 1.3312a106.752 106.752 0 0 1 87.3472 95.6928v3.9936c0.256 3.072 0.8704 6.144 1.792 9.0624 1.3312 3.6864 2.9184 7.3216 4.7616 10.8032l2.2528 4.6592 1.8944 4.096c1.6384 3.1744 3.072 6.4512 4.352 9.7792 2.048 5.0176 2.2528 10.496 0.7168 15.6672-0.6656 2.2016-2.048 2.56-2.7648 2.56a3.584 3.584 0 0 1-1.8944-0.6144 30.6176 30.6176 0 0 1-3.7376-2.6624l-1.792-1.4336-2.2016-1.1264a32.9216 32.9216 0 0 0-4.5568-3.2768 3.7888 3.7888 0 0 0-1.792-0.512 3.4816 3.4816 0 0 0-1.7408 0.512l2.304 2.048c4.0448 3.5328 8.192 7.168 11.9296 10.752 0.8704 0.8704 1.3824 2.048 1.3312 3.2768a27.4432 27.4432 0 0 1-7.4752 18.3808 24.7296 24.7296 0 0 1-17.92 8.192 18.2784 18.2784 0 0 1-4.2496 0 4.8128 4.8128 0 0 1-2.8672 4.608 81.92 81.92 0 0 1-39.424 10.6496h-2.048a55.808 55.808 0 0 0-27.7504 8.192 40.3456 40.3456 0 0 1-9.216 3.9424 118.272 118.272 0 0 1-24.6784 3.4304c3.4816 0.512 7.0144 0.7168 10.496 0.6656h12.3392c1.28-0.0512 2.5088 0.1536 3.6352 0.5632 6.912 2.816 13.6704 6.2464 19.968 9.4208 0.9728 0.5632 2.048 0.8704 3.072 0.9216a3.7376 3.7376 0 0 0 1.3312 0l1.8944-0.6656c3.4816-1.3312 7.0144-2.6112 10.4448-4.1984 6.912-3.2768 14.4384-5.12 22.0672-5.2224a37.4784 37.4784 0 0 1 20.736 4.864c2.9696 1.536 5.0688 4.4032 5.6832 7.68l0.5632 0.7168 1.8432 1.536 1.9456 1.6896c3.7888 3.3792 5.6832 8.3456 5.12 13.312 0 1.536-0.512 4.9664-3.4816 4.9664a8.2432 8.2432 0 0 1-3.4304-1.024l-1.7408-0.768 4.3008 2.7648c3.328 2.2528 5.12 6.144 4.7616 10.1888a21.9648 21.9648 0 0 1-21.4016 19.0976 14.4384 14.4384 0 0 1-3.7888-0.4096 13.1584 13.1584 0 0 1-9.3696-5.8368h-2.2528a41.3184 41.3184 0 0 0-5.9904 0h-0.5632a46.848 46.848 0 0 1-14.8992 1.536l-4.9664-1.1264h-1.2288a51.6096 51.6096 0 0 1-9.1136 17.152c-9.728 12.0832-22.9888 20.992-37.888 25.4464a120.32 120.32 0 0 1-37.5808 5.7344c-7.2192 0-14.4384-0.512-21.5552-1.536a72.6528 72.6528 0 0 1-60.672-47.2064 123.392 123.392 0 0 1-4.3008-13.9264 164.352 164.352 0 0 0-1.8944-6.8096 144.64 144.64 0 0 0-13.2608-31.6416 93.3376 93.3376 0 0 0-37.888-37.8368 85.1968 85.1968 0 0 0-40.192-9.8304c-6.1952 0-12.3904 0.512-18.5344 1.6384l-3.84 0.8192c4.4032 0 8.704 0 13.056 0.8192a124.928 124.928 0 0 1 54.1696 18.2272c19.8656 11.3664 34.4576 30.0544 40.6528 52.0704 3.2256 12.1856 7.7312 24.0128 13.4144 35.2768 3.5328 7.5776 8.1408 14.592 13.6704 20.8384 9.5232 9.6768 21.5552 16.4352 34.816 19.5584l12.3392 3.6864c2.304 0.768 4.096 2.56 4.864 4.864a32.7168 32.7168 0 0 1 1.7408 18.6368 54.2208 54.2208 0 0 1-13.312 25.7536c-5.6832 6.0928-12.2368 11.3664-19.4048 15.7184a107.52 107.52 0 0 0-9.5232 7.2192 9.6768 9.6768 0 0 0-3.584 8.192c0 4.864 0.512 5.0176 1.4336 5.0176a16.4864 16.4864 0 0 0 3.8912-0.9216l2.7648-1.1264 5.6832-2.4064 9.728-4.1472a54.784 54.784 0 0 1 20.6336-4.4544c3.584 0 7.168 0.512 10.6496 1.3312 11.776 2.048 21.2992 10.5984 24.6784 22.016a9.5744 9.5744 0 0 1-0.512 8.192 5.6832 5.6832 0 0 1-4.4032 2.6624 6.0928 6.0928 0 0 1-3.9424-2.56 3.5328 3.5328 0 0 1-0.9216-2.2016v-0.7168a15.0528 15.0528 0 0 0-4.9664-8.704 27.648 27.648 0 0 1 5.6832 18.2784 11.52 11.52 0 0 1-12.0832 11.264h-0.9216a4.2496 4.2496 0 0 1-4.4032-3.8912v-9.2672-5.12a8.192 8.192 0 0 0-6.5024-7.3216h-0.8704a7.3728 7.3728 0 0 1 2.9184 2.8672 32.768 32.768 0 0 1 3.1744 7.4752c2.048 5.5296 0.1024 11.776-4.7616 15.1552a20.992 20.992 0 0 1-11.6736 2.7136 55.3984 55.3984 0 0 1-12.288-1.8944l-1.9456-0.512a44.1856 44.1856 0 0 0-10.2912-1.28 42.0352 42.0352 0 0 0-8.192 1.024h-1.28c-18.9952 3.584-38.2976 5.4784-57.6 5.632l-4.096 0.0512z'
              fill='#E65270'
            ></path>
            <path
              d='M798.5152 681.8816s-30.4128 37.12-82.2272 15.872c-47.4112-19.5584-30.1056-73.2672-30.1056-73.2672s8.192 33.3824 32.6144 45.9776c35.84 18.2272 79.7184 11.4176 79.7184 11.4176zM646.144 698.4704c5.12 6.3488 8.192 14.1312 8.8576 22.2208 3.1232 15.5136 9.5744 30.1568 18.8416 42.9056 9.3184 12.288 21.9136 21.76 36.352 27.2384 13.0048 5.0176 29.7472 3.584 27.1872 22.9888l-4.352 16.4864c-32.8704 0-64.256-15.2576-76.9536-48.384-11.1616-29.0816 1.9968-64.2048-31.744-113.3568 2.7648 3.328 18.3808 26.4704 21.8112 29.9008z'
              fill='#430A1D'
              opacity='.2'
            ></path>
            <path
              d='M643.6864 680.1408c11.1104 17.0496 22.1696 34.1504 31.3856 51.2-31.3856-14.336-43.008-33.28-31.3856-51.2z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M244.6336 811.4176c-124.7232-12.544-139.1616-138.496-139.1616-138.496a343.296 343.296 0 0 1 9.0112-115.6608C124.416 661.504 206.848 733.696 206.848 733.696s18.0736 59.3408 37.8368 77.7728z'
              fill='#BF73F2'
            ></path>
            <path
              d='M211.968 762.1632s-25.4976 2.4064-59.648-38.9632c32.8704 59.6992 75.52 60.928 75.52 60.928l-15.872-21.9648z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M280.6272 832.4096c-6.6048-115.8656 61.4912-62.208 96.6144-124.1088a199.68 199.68 0 0 1 39.424-87.6544s-210.6368-39.5776-214.016 114.3808c7.3728 33.0752 39.68 65.536 59.8016 82.7392-3.9424-8.9088-54.272-147.5584 113.3056-136.2944-57.856-4.864-141.312 55.6032-101.5296 146.2272 4.0448 3.1232 6.4 4.7104 6.4 4.7104z'
              fill='#BF73F2'
            ></path>
            <path
              d='M339.0464 668.5696c-42.8544 16.3328-115.5584 16.3328-94.8224 125.9008-3.328 2.4064-19.968-23.3472-15.7696-20.8384-19.0464-98.0992 66.4576-92.416 110.592-105.0624z'
              fill='#FFFFFF'
              opacity='.2'
            ></path>
            <path
              d='M391.8336 627.968c41.7792-16.4864 8.192 30.5664 1.9456 38.144-13.7216 17.5104-48.3328 11.776-66.816 17.664-10.6496 3.3792-53.248 9.6256-67.328 50.3808a125.1328 125.1328 0 0 0 4.7104 83.3536c-3.328 2.56-25.2928-21.7088-21.1456-19.2-35.1744-158.9248 130.9696-101.888 148.6336-170.3424z'
              fill='#8B4FBA'
              opacity='.6'
            ></path>
            <path
              d='M814.336 562.6368a26.5216 26.5216 0 0 1 5.5296-9.5232c0.6144 0 1.2288 0 1.6384 0.6144a30.464 30.464 0 0 1 15.7184-2.3552 32.9728 32.9728 0 0 1 10.5984 0c4.3008 1.7408 3.84 6.1952 5.632 9.6256 3.328 6.4 13.824 6.5024 13.824 15.5136 0.6144 4.7104 0.6144 9.472 0 14.1312-0.8192 3.072-4.2496 2.2016-7.2704 2.2016h-27.1872l-12.5952-8.7552c-3.3792 1.1264-5.9904-5.888-6.5024-8.1408a27.648 27.648 0 0 1 0.6144-13.312z'
              fill='#F9E0E7'
            ></path>
            <path
              d='M857.4976 575.6416a14.2848 14.2848 0 0 0 4.608-4.2496c0.6656-0.9216 0.512-1.536 1.9456-1.536 3.7888 0 3.7888 4.9152 3.6352 7.5776-0.1536 2.6624-1.5872 6.144-2.048 9.216-1.2288 0-1.9968-1.6896-3.328-2.048a12.6464 12.6464 0 0 0-3.7888 0c-1.6896 0-4.0448 1.024-5.4784 0.4096l4.4544-9.3696z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M353.1264 402.0224l0.9216-1.024a105.984 105.984 0 0 0 30.4128-57.6 57.088 57.088 0 0 0-7.424-39.6288l-0.5632-0.6656c-1.2288 4.096-2.4576 8.2432-3.8912 12.032-3.072 9.728-7.7312 18.8416-13.9264 26.9824-2.6624 3.1744-111.9232 63.7952-100.6592 197.888v2.56c2.048-1.8944 3.7888-3.84 5.8368-5.4272a69.12 69.12 0 0 1 24.6784-11.776c16.384-4.5056 32.1536-8.192 48.384-12.544a452.096 452.096 0 0 0 54.528-15.4624c9.984-3.8912 19.456-8.9088 28.2624-15.0016a154.624 154.624 0 0 0 34.5088-32.8704c5.12-6.2976 8.8576-13.6192 11.008-21.504 1.4336 8.2944 0.8704 16.7424-1.6384 24.7296a61.5424 61.5424 0 0 1-12.4928 21.76 23.04 23.04 0 0 0 3.9936-1.28c15.7184-8.4992 29.3376-20.48 39.68-34.9696a64.3584 64.3584 0 0 0 11.6224-34.048c4.7616 20.7872-0.512 42.6496-14.2336 58.9824 5.9904-2.1504 11.4176-4.3008 16.9984-5.9392a16.4352 16.4352 0 0 0 10.0864-8.192c11.52-17.408 20.0704-36.5056 25.3952-56.6272 4.3008-15.36 4.5568-31.5392 0.768-47.0016a78.1824 78.1824 0 0 0-30.4128-42.5984 138.2912 138.2912 0 0 0-32.8704-17.92l-2.0992-0.8192-0.6144-0.6656 11.3664 3.1232c16.9984 4.608 33.1264 12.1856 47.5648 22.3744 12.7488 8.9088 22.2208 21.7088 27.136 36.5056 3.9424 13.5168 4.2496 27.904 0.768 41.5744-4.9664 19.968-13.6192 38.7584-25.5488 55.552l-1.024 1.536v0.512a188.16 188.16 0 0 0 63.5904-49.8176c16.7424-20.1728 28.5184-43.9296 34.3552-69.4272a97.792 97.792 0 0 0-21.8112-87.3984 162.2016 162.2016 0 0 0-48.2304-38.5024 223.1296 223.1296 0 0 0-75.4176-25.1392 135.8848 135.8848 0 0 0-45.4144 0c-8.192 1.536-15.9232 4.608-22.9376 9.1136 1.1776-1.024 2.304-2.048 3.584-2.9696 8.192-5.888 17.7152-9.8816 27.6992-11.5712 16.64-3.072 33.6384-3.3792 50.3808-1.0752 25.7024 2.816 50.688 10.0864 73.9328 21.3504l7.0656 3.7376v-5.8368c0-1.8432 1.6384-4.4544 3.84-4.7104a2.8672 2.8672 0 0 1 3.7888 2.56 15.36 15.36 0 0 0 0.6656 5.4272 18.9952 18.9952 0 0 0 5.2736 10.4448 3.1232 3.1232 0 0 0 0.9728 0.7168h0.8704v-4.096-8.192c0-0.6656 0.512-1.7408 1.024-1.8432 0.768-0.2048 1.536 0 2.0992 0.5632 1.1776 1.3824 2.0992 2.9184 2.7136 4.608 1.0752 3.584 1.536 7.2704 2.6624 10.752a22.528 22.528 0 0 0 3.2768 6.3488c1.6384 2.048 3.2256 1.536 3.7888-0.8704 0.5632-2.4576 0.8192-4.864 1.1264-7.2704a12.9024 12.9024 0 0 1 0-2.4576 5.8368 5.8368 0 0 1 1.0752-1.792c0.512 0.512 1.3312 0.8192 1.536 1.4848 0.6656 1.3824 1.024 2.816 1.1776 4.352v9.7792a13.6704 13.6704 0 0 0 1.536 5.12c0.9216 1.6384 2.5088 1.4336 2.9696-0.4096 0.512-1.8944 1.1776-5.4272 1.6384-8.2432 0.512-2.816 0.768-3.6864 1.2288-5.9392a8.192 8.192 0 0 1 2.9184 5.9392c0.512 5.3248 0.8704 10.7008 1.28 15.9232 0.4096 3.9936 1.792 7.7312 4.096 10.9568 4.3008 6.2464 8.192 12.8 11.9296 19.3536 1.9968 3.2768 3.7888 3.584 5.632 0 1.9968-3.9936 3.7888-8.0384 5.376-12.1856 0.8192-1.7408 1.4848-3.584 2.2016-5.376 0.768-1.792 1.0752-1.536 1.6896-2.4576a5.2736 5.2736 0 0 1 2.2016 5.5296c-0.6656 2.9696-1.7408 5.8368-2.4576 8.8064-0.768 2.9696-1.7408 6.4-2.2528 9.6256a7.7312 7.7312 0 0 0 1.024 4.1472c0.8192 1.8944 2.2016 2.048 3.584 0.6656 1.3824-1.3824 2.6624-3.2768 4.0448-4.7616a18.944 18.944 0 0 1 2.9696-2.048c0.512 1.2288 1.6384 2.4576 1.536 3.584a27.3408 27.3408 0 0 1-1.7408 7.2704c-1.792 4.608-4.2496 9.0624-5.8368 13.7216-0.9216 3.584-1.536 7.168-1.6896 10.8544 0 1.0752 0.512 2.0992 1.3824 2.7136 0.6656 0 2.1504-0.512 2.816-1.2288 2.9184-3.2768 5.7344-6.7584 8.704-10.0864a30.6688 30.6688 0 0 1 2.4576-2.1504h0.8704a31.232 31.232 0 0 1-0.8704 5.7344 45.824 45.824 0 0 1-4.352 8.192c-2.6624 4.3008-5.632 8.2432-8.192 12.4416a79.0016 79.0016 0 0 0-10.4448 25.2416c-1.536 6.5024-3.6352 12.8512-5.5296 19.2512a11.264 11.264 0 0 0-0.5632 2.4064l4.9152-7.8336a42.3936 42.3936 0 0 1 21.9136-18.688c16.0768-5.376 31.744-11.6736 47.104-18.8928 4.3008-2.2016 8.448-4.8128 12.288-7.68 4.096-3.072 5.9904-8.192 4.9664-13.2096l-3.1232-12.8c-2.56 4.096-4.864 8.192-7.424 11.776a25.3952 25.3952 0 0 1-10.5984 8.96l0.8192-1.536c6.3488-9.216 10.9056-19.5584 13.5168-30.464a10.9568 10.9568 0 0 0 0-3.584 104.5504 104.5504 0 0 1 0-23.808 23.1936 23.1936 0 0 0 0-4.7616 2.4576 2.4576 0 0 0-1.3312-1.8944s-1.4848 0.4096-1.8944 0.9216a43.6736 43.6736 0 0 0-4.2496 6.656c-4.096 9.5232-8.192 19.2-12.032 28.928a124.672 124.672 0 0 1-18.8928 33.8944 44.6976 44.6976 0 0 1-13.9264 11.0592 22.528 22.528 0 0 1-3.328 1.28 43.2128 43.2128 0 0 0 10.5472-30.464c0.512-14.1312 0-28.2624 0-42.496a156.3648 156.3648 0 0 1 5.9904-45.2096 3.072 3.072 0 0 0-0.512-2.048c-1.2288-2.56-2.8672-4.864-3.9424-7.5264-2.2016-5.4272-4.096-11.008-6.2976-16.384-1.3312-3.2256-1.7408-3.4816-5.1712-3.2256a8.8576 8.8576 0 0 1-8.192-4.5568c-1.536-1.9456-2.2016-1.8944-3.1744 0.4096-0.9728 2.304-2.048 5.1712-3.2768 7.68 0 0.8704-1.4848 1.4848-2.2016 2.0992-0.6144-0.8704-1.536-1.6896-1.7408-2.6112 0-3.072 0-6.0928-0.4096-9.1136a16.896 16.896 0 0 0-0.8192-4.5568 2.7136 2.7136 0 0 0-1.9968-1.3824c-0.512 0-1.4336 0.8192-1.6896 1.4848-0.768 2.2016-1.1776 4.4544-1.8432 6.656-0.6144 2.2016-1.3824 1.8944-2.3552 0.512-7.68-9.7792-17.152-17.92-27.9552-24.064l-9.5232-5.888h-0.6656l1.28 10.5984h-0.8704a18.4832 18.4832 0 0 1-3.0208-2.56c-2.048-2.4576-3.9936-5.12-6.144-7.6288a29.2352 29.2352 0 0 0-14.6432-9.728l4.7104 16.4864h-0.768a16.4352 16.4352 0 0 1-1.536-1.9968c-1.2288-2.048-2.4576-3.9936-3.584-6.0416a28.928 28.928 0 0 0-22.3232-15.36 242.176 242.176 0 0 0-20.2752-2.0992 40.2944 40.2944 0 0 1-14.336-3.2768 83.9168 83.9168 0 0 0-9.8816-3.584 4.0448 4.0448 0 0 0-1.9968 0 5.9392 5.9392 0 0 0 0 2.1504c1.536 3.072 3.2768 6.144 4.9152 9.216 0.6144 1.0752 0.9216 2.304 1.4336 3.4816l-0.512 0.5632a31.3856 31.3856 0 0 1-2.9696-1.024c-4.352-2.2016-8.7552-4.1472-13.056-6.5536a31.744 31.744 0 0 0-13.7216-3.072 113.8176 113.8176 0 0 0-42.496 4.7104c-8.6528 2.4576-16.64 6.7072-23.4496 12.544h2.6112c8.448-2.048 17.0496-3.072 25.7024-3.1232 5.9392-0.0512 11.776 1.3824 17.0496 4.1472 0.8704 0.512 1.3824 1.536 2.048 2.2528a8.192 8.192 0 0 1-3.584 1.024c-2.6624 0-5.3248-1.28-8.192-1.536a71.8848 71.8848 0 0 0-25.344 3.584 171.008 171.008 0 0 0-55.2448 27.0336c-4.1984 2.8672-8.192 5.5808-12.6976 8.192a66.56 66.56 0 0 0-20.48 20.48 22.1184 22.1184 0 0 0-1.536 3.1232 5.1712 5.1712 0 0 0 2.56 7.0656 30.72 30.72 0 0 0 6.656 2.4576 73.1648 73.1648 0 0 1 55.808 62.7712c1.7408 11.52 2.56 23.1424 2.4064 34.816-1.024 25.9584-11.264 50.7392-28.8256 69.9392-10.6496 11.6736-23.1424 21.504-36.864 29.2864l-1.6896 0.6144z'
              fill='#FAA100'
            ></path>
            <path
              d='M449.1776 332.8c15.872-15.5136-68.608 32.512-64.7168 10.5984a57.088 57.088 0 0 0-7.424-39.6288l-0.5632-0.6656c-1.2288 4.096-2.4576 8.2432-3.8912 12.032-3.072 9.728-7.7312 18.8416-13.9264 26.9824-2.6624 3.1744-111.9232 63.7952-100.6592 197.888v2.56c2.048-1.8944 3.7888-3.84 5.8368-5.4272a69.12 69.12 0 0 1 24.6784-11.776c16.384-4.5056 32.1536-8.192 48.384-12.544a452.096 452.096 0 0 0 54.528-15.4624c9.984-3.8912 19.456-8.9088 28.2624-15.0016a154.624 154.624 0 0 0 34.5088-32.8704c19.1488-13.4144 17.4592-52.2752-5.0176-116.6848z'
              fill='#D391E9'
            ></path>
            <path
              d='M741.888 225.4336c-13.1072 100.352-58.2656 77.6704-87.9104 133.6832-1.5872-2.048-5.2736 15.0528 2.0992-16.5376s28.8768-17.408 49.1008-53.8624c25.344-46.336 20.48-50.4832 36.6592-63.2832z'
              fill='#8B4FBA'
              opacity='.2'
            ></path>
            <path
              d='M609.6896 228.5568c-4.8128 29.6448-45.3632 28.2624-80.128 15.7696-37.7344-13.6192-116.0192-18.0224-122.368-1.792-3.1232 3.7376-9.4208-11.5712-9.4208-11.5712s59.4432-66.9184 159.1296 3.7376c-4.0448-6.5536 35.7376-25.5488 35.7376-25.5488s12.0832-3.7888 17.0496 19.456z'
              fill='#FFFFFF'
              opacity='.3'
            ></path>
            <path
              d='M402.9952 506.4192c2.1504 5.376 19.712 1.7408 21.3504-6.656-25.9584-29.5424 42.4448-83.8144-20.5824-154.624 41.1648 109.2608-46.592 113.7152-0.768 161.28z'
              fill='#8B4FBA'
              opacity='.2'
            ></path>
            <path
              d='M402.5344 505.856c2.048 5.3248 1.6384 3.84 3.2256-4.608-24.9856-29.44 41.5744-72.3456-2.56-156.16 39.7312 108.9024-44.8 113.3568-0.6656 160.768z'
              fill='#8B4FBA'
              opacity='.6'
            ></path>
            <path
              d='M496.3328 483.7376c124.416-132.4032-32.8704-110.1824-84.0704-200.0896v-4.608c0-12.0832-2.7648-23.9616-8.192-34.7136 47.9744 72.0384 169.5232 8.2944 145.92 155.5968-2.0992 7.5776-18.5344 82.176-53.6576 83.8144z'
              fill='#E65271'
            ></path>
            <path
              d='M500.1216 484.4544c-51.2 24.6784-96 25.8048-93.9008 18.432 101.7856-69.12 19.6608-140.288 0.512-207.36 1.3312-5.376 9.472-7.424 9.472-13.5168v-1.9968a22.2208 22.2208 0 0 0 8.192 12.3392c47.36 47.7184 197.632 63.6928 75.7248 192.1024z'
              fill='#E65271'
            ></path>
            <path
              d='M481.3824 481.9968C560.7424 364.6464 412.672 342.6304 413.696 305.152c-11.776 76.4928 130.1504 109.2096-3.2256 200.8064-1.7408 7.5264 19.3536 1.1264 70.912-24.064z'
              fill='#E65271'
            ></path>
            <path
              d='M698.368 276.1728c6.144 10.3936-0.7168 22.6304-8.0896 34.0992-7.3216 11.4688-22.5792 7.168-33.4336 32.768l1.024-19.9168c11.9296-21.1968-8.0896-50.3296-14.0288-70.0416-9.5744-33.5872-19.968-64.512-7.3216-98.304 0.8704-2.2528 1.6384-4.7616 2.5088-7.0656 6.2976 4.608 11.9296 10.0864 16.64 16.384 3.584 4.7104 2.304-12.3904 7.0656-8.8064 3.4816 2.6624 0 14.7456 3.1744 17.5616 3.1232 2.7648 5.9904-15.2576 8.6528-11.1616 6.2976 9.5744 9.9328 3.4304 12.5952 6.4 2.6624 2.9184 8.0384 22.6816 10.3936 25.4464 2.3552 2.816 4.4544 5.3248 6.5536 8.192a194.56 194.56 0 0 1-8.704 44.3904 28.16 28.16 0 0 0 2.9696 30.0544z'
              fill='#F6E8A0'
            ></path>
            <path
              d='M526.848 122.0096h0.9216c3.4304 0-9.216-16.3328-5.5296-16.3328 6.144 0 14.7456 6.4 20.6848 6.8608 12.544-0.2048 25.088 1.7408 36.9664 5.7856 10.752 4.9152 15.4624 20.224 17.92 20.8896 2.4064 0.6656-5.888-17.7152-3.5328-16.896a31.232 31.232 0 0 1 9.9328 5.5808c10.5984 15.1552 14.0288 90.368-1.536 88.4736-15.5648-1.8432 25.7536 5.8368 25.9072 5.12a92.3136 92.3136 0 0 0-15.8208-83.5584c1.2288 2.048 2.8672 3.7376 4.9152 4.9664 3.328 1.28-2.048-12.8 0.9728-10.9568 9.728 5.9904 16.2816 10.1376 22.3232 14.336 0 0 0 0.8704 0.512 0.768 4.096-1.792 29.8496-8.192 10.24 84.7872 29.7984-60.3136 6.5024-83.968 8.7552-81.6128 10.496 11.4176 12.6976 39.2704 14.08 55.808 1.3824 16.5888-8.1408 50.8928-21.0432 62.5664-8.9088 8.192-8.704-1.9456-12.0832-9.8816a138.7008 138.7008 0 0 0-24.4224-33.8944 285.184 285.184 0 0 0-22.4768-20.8384c-8.1408-7.68-12.4416-18.432-19.712-26.9312-7.2192-8.448-14.7456-13.4144-20.9408-21.3504-6.144-7.936-11.52-18.944-19.2-27.0848a58.88 58.88 0 0 0-7.8336-6.6048z'
              fill='#E65271'
            ></path>
            <path
              d='M583.5264 112.128c18.2272 0 29.6448 8.704 44.5952 17.1008 12.544 6.9632 27.904 7.0656 38.4 16.384 12.9536 11.264 21.0944 27.1872 22.6304 44.3904 3.328 23.1936 3.072 46.7456-0.6656 69.888-2.048 10.9568-9.6768 33.28-17.8176 41.1136l-9.728-6.2464c-19.2-49.9712-76.9536-70.5536-98.816-119.6544a130.9184 130.9184 0 0 1-9.1136-49.3568c-0.1536-15.872 17.3056-13.6704 30.5152-13.6704z'
              fill='#FAA100'
            ></path>
            <path
              d='M402.0736 233.8304a76.8 76.8 0 0 0-47.7184-32.4096c-5.12-1.1264-14.2336-4.1984-5.2224-14.848 8.2944-10.7008 18.8416-19.456 30.9248-25.8048 30.0544-21.76 17.6128-24.32 35.072-26.0096 6.8608-0.7168 5.0688-1.3824 8.2944 0s-2.6624-0.9728-4.9152-2.3552c-19.2512-12.8512-17.8176 12.288-9.4208 7.3216 24.832-18.8928 82.7392-32.4096 98.6112-29.4912 2.304 0 18.5344 9.5744 20.992 9.5744 2.5088 0-9.3184-16.2304-5.632-16.2304 6.2464 0 15.0016 6.3488 20.992 6.8096 30.5152 6.0928 51.968 32.9216 50.688 63.3344 0.5632 10.8032 0.2048 21.6576-1.1776 32.4096-13.9264 66.1504-155.136-26.624-191.488 27.648z'
              fill='#F6E8A0'
            ></path>
            <path
              d='M567.7056 196.4544c-6.3488-8.4992-47.872-23.552-47.872-23.552s-69.0176-24.8832-132.5568 46.2336c32.256-27.136 89.6-15.8208 130.9696-10.8032 5.376 0.6656-11.776-5.12-7.2704-6.8608 15.36-5.9392 29.44 10.752 44.8 7.5264a13.312 13.312 0 0 0 11.9296-12.544z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M514.56 186.0608c-25.4464-6.7584-51.0464 3.072-55.9616 3.4304 2.304-3.4816 6.0416-11.4688 25.0368-14.2336a158.72 158.72 0 0 1 17.6128 0 41.472 41.472 0 0 1 20.48 5.4272c6.0928 2.56 12.6464 3.8912 19.2512 3.9936 0 0 39.2192 2.9184 26.1632 16.2816-13.0048 13.312-31.8464-17.1008-73.3184-7.3216a26.3168 26.3168 0 0 1 20.7872-7.5776z'
              fill='#F6E8A0'
            ></path>
            <path
              d='M478.464 129.024c-16.64-10.752-45.312-1.536-49.0496-1.536 0 0 0-0.8704 0.8192-1.28 24.9344-19.0976 62.3104-17.408 78.4896-14.6432h0.512c3.4816 1.3312 14.9504 7.68 19.2 9.1136 24.3712 13.568 63.0784 42.3424 66.56 87.9104a164.7104 164.7104 0 0 1-31.4368-17.8176c-2.56-1.9456-60.928-62.0032-215.552 10.1376a5.632 5.632 0 0 1-1.8944-7.7824c34.9696-54.784 98.6624-70.656 200.192-18.688-14.336-16.384-21.3504-31.8464-67.84-45.4144z'
              fill='#F8D285'
            ></path>
            <path
              d='M576.9216 441.7536c56.9856-57.4976 80.2304-101.0176 52.5824-147.8144-44.6464-75.3664-182.272 3.328-242.2272-72.704 9.5232 11.0592 20.6848 20.6336 33.1264 28.3648 44.3904 28.7744 127.8976 19.456 154.624 41.728 33.9456 28.928 42.8032 86.4768 1.8944 150.4256z'
              fill='#E68452'
            ></path>
            <path
              d='M390.2464 322.048c0 3.84 8.704 26.2144 7.3728 31.3856-11.776 44.032-62.976 65.792-62.976 65.792s-57.0368 23.2448-66.3552 129.7408c-10.5472 7.5776-9.0624-8.192-8.704-15.7696 6.5024-139.776 121.4464-124.16 130.6624-211.1488z'
              fill='#FAA7B5'
            ></path>
            <path
              d='M589.2096 550.8096a28.9792 28.9792 0 0 0-2.816-1.3312l-15.2576-4.352c-1.536-0.512-3.1232-1.28-4.7104-1.8432v-1.024a40.2944 40.2944 0 0 1 5.5296-0.9728h21.8624c10.24 0.512 20.5824-0.512 30.5664-3.072 4.864-1.536 9.5744-3.6352 14.0288-6.1952a221.8496 221.8496 0 0 0 100.0448-115.2c4.0448-10.24 7.2704-20.8384 9.728-31.6416v-2.2528l-1.7408 1.024a244.5312 244.5312 0 0 1-94.0544 40.192c-12.2368 2.2528-24.576 3.584-37.0688 3.8912a3.9424 3.9424 0 0 0-2.7136 1.024 235.2128 235.2128 0 0 1-123.8528 64.1024c-26.368 5.2224-52.736 10.0864-79.1552 15.2576a704.512 704.512 0 0 0-95.7952 23.8592c-19.968 6.3488-39.0144 15.2576-56.7296 26.5216a106.1376 106.1376 0 0 0-33.3824 33.1264c-2.9696 4.864-5.0176 10.24-7.4752 15.4112a9.3696 9.3696 0 0 1-1.7408 2.56 72.2944 72.2944 0 0 0-21.6064 62.464c2.2528 17.664 8.192 34.6112 17.5104 49.7152 1.0752 1.8432 1.9968 3.7376 2.816 5.3248 0-3.8912 0.8192-8.2944 1.3824-12.6976 3.1232-26.3168 18.8416-49.4592 42.0864-61.9008 13.9776-7.7312 28.9792-13.312 44.6464-16.5376 17.152-3.84 34.4064-7.0656 51.712-10.24 21.0432-3.072 41.9328-7.6288 62.464-13.4656 3.8912-1.2288 8.192-2.6624 11.7248-4.1472a57.856 57.856 0 0 0 14.0288-7.6288 199.168 199.168 0 0 1 47.0016-25.4976l1.3312-0.6144H432.7936a358.144 358.144 0 0 0-49.8688 2.56 294.912 294.912 0 0 0-66.8672 17.3568 469.4016 469.4016 0 0 0-72.96 36.4544 6.1952 6.1952 0 0 1-2.1504 0.9216l1.2288-1.0752a343.7568 343.7568 0 0 1 83.0464-48.128 254.0544 254.0544 0 0 1 64.9216-15.7696c19.6096-1.9456 39.424-2.0992 59.0848-0.512l51.2 3.7376a11.52 11.52 0 0 0 4.4544-0.5632c16.896-4.9152 34.0992-8.4992 51.5072-10.752 10.24-1.4336 20.48-3.9424 30.6688-5.9392a9.984 9.984 0 0 0 1.9968-0.8192l0.1536-1.3312z'
              fill='#CC7EDF'
            ></path>
            <path
              d='M269.824 609.792c67.328-78.592 242.2784-37.376 316.7744-56.7296-47.104 26.5216-85.504 21.8624-85.504 21.8624s-161.1264-17.2544-231.3216 34.816z'
              fill='#FFFFFF'
              opacity='.2'
            ></path>
            <path
              d='M781.7216 307.3536a49.664 49.664 0 0 0-5.5296 0.9728c-6.0928 1.536-12.0832 3.5328-17.92 5.9392-5.3248 2.7648-10.3424 6.144-14.8992 9.984-9.0624 7.2192-17.664 14.9504-26.5216 22.272a69.376 69.376 0 0 1-24.1664 14.1824 71.168 71.168 0 0 1-9.216 1.9456 69.12 69.12 0 0 0 25.7024-27.5968h-0.9728c-18.432 8.3968-36.0448 18.6368-52.48 30.464a31.6416 31.6416 0 0 0-10.1888 12.032c-3.9424 8.1408-8.8576 15.6672-13.3632 23.5008l-1.024 1.6384c3.9424-0.8192 7.424-1.3824 10.752-2.2016a196.608 196.608 0 0 0 41.1136-16.2816c20.3264-10.5984 39.936-22.528 58.7264-35.6352a8.8064 8.8064 0 0 1 1.9456-0.9728l-0.5632 0.7168a238.2848 238.2848 0 0 1-76.8 52.3264 139.264 139.264 0 0 1-39.5264 10.1888c-0.512 0-1.024 0.2048-1.4336 0.512l-9.3696 11.52c8.192-1.792 16.384-3.328 23.9616-5.12a342.4256 342.4256 0 0 0 63.6416-20.48c15.0528-6.4 28.928-15.2576 41.0624-26.112 15.9232-14.7456 27.8528-33.1776 34.6624-53.6576 1.024-3.328 1.792-6.7072 2.4064-10.1376z'
              fill='#E65271'
            ></path>
            <path
              d='M406.1696 511.232c6.5024-2.2016 13.9264-4.9664 21.8624-8.2432 93.3376-29.184 123.904-53.4016 123.904-53.4016l93.696-69.376s15.36 11.6736 35.1744-3.584c-13.4144 16.5376-54.9888 28.8256-54.9888 28.8256a37.888 37.888 0 0 1-15.4112 22.6816c36.864-12.544 99.072-9.0112 141.9264-47.7184-32.2048 92.3648-112.9472 22.2208-191.0784 79.36-9.0112 5.4784-128.1536 35.84-68.9664 33.792 59.2384-2.048 98.2016 38.2976 147.6608 24.7808-46.3872 16.4864-87.4496-10.1888-152.1152-14.6944 11.3152 1.8944 21.8112 7.2704 29.9008 15.4112-23.4496-16.4864-69.2736-17.5104-80.1792-13.6192-10.5984 1.3312-21.0432 3.2768-31.3856 5.7856z'
              fill='#8B4FBA'
              opacity='.6'
            ></path>
            <path
              d='M626.4832 536.8832c-67.7888 27.3408-307.3024-51.6608-414.8224 70.8096 0 0-8.192-3.6864 34.7136-52.224 168.448-81.6128 293.6832-4.5056 380.1088-18.5856z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M732.672 429.6704c20.0704-11.264 3.7888 16.384-16.384 32.7168-78.848 54.784-114.4832-7.6288-192.6144 22.3744 119.7056-66.2528 131.4816 15.5648 209.0496-55.0912z'
              fill='#000000'
              opacity='.7'
            ></path>
            <path
              d='M726.784 446.3104c20.0704-11.5712 9.8816 0.6656-10.24 17.408-78.8992 56.5248-114.6368-7.7824-192.8704 23.0912 77.0048-43.9808 125.44 32.768 203.1104-40.4992z'
              fill='#8B4FBA'
              opacity='.2'
            ></path>
            <path
              d='M339.0464 416.5632c-36.6592 33.024-8.2944 105.8304-8.2944 105.8304l-26.0608 5.4784s-25.9072-70.3488 34.304-111.3088z'
              fill='#BF73F2'
              opacity='.7'
            ></path>
            <path
              d='M401.92 361.984c27.3408 48.7936-45.0048 115.0976-6.144 138.2912-0.6656 3.1744-22.2208 13.9264-21.248 10.8544-47.9232-73.216 31.1296-90.9312 20.736-136.8064-55.4496 75.4176-56.0128 90.4192-29.1328 138.3424 0 0-3.2256 4.1472-6.144 1.9456-42.1888-31.3344-54.016-66.816 41.984-152.6784z'
              fill='#B771B8'
              opacity='.7'
            ></path>
            <path
              d='M490.752 461.824c1.7408 23.1424 17.8176-14.4384 20.2752-40.2944 2.048-96.9728-95.6416-73.5232-100.096-152.0128-9.3184 89.2928 96.256 87.296 79.872 192.3072z'
              fill='#8B4FBA'
              opacity='.2'
            ></path>
            <path
              d='M586.496 423.936c1.7408 23.04 47.9744-36.2496 50.432-62.0032-15.5136-165.7344-186.1632-64.9216-230.7584-126.0032 37.2224 66.8672 275.4048-25.9584 180.3264 188.0064z'
              fill='#FFFFFF'
              opacity='.3'
            ></path>
            <path
              d='M896.3072 744.192c-2.4064 2.2016-4.4544 4.1472-6.7584 5.888a35.1744 35.1744 0 0 1-5.6832 3.584 15.872 15.872 0 0 1-14.9504 0 40.8064 40.8064 0 0 0-24.4736-3.4816 6.0416 6.0416 0 0 0-5.2224 3.7376c-8.448 16.7424-23.04 29.5424-40.7552 35.7888a4.608 4.608 0 0 0-3.3792 3.9936 41.8304 41.8304 0 0 0 0 16.2816 33.4336 33.4336 0 0 0 15.104 20.224c7.8336 4.864 16.4352 8.3456 25.4464 10.3424 10.6496 2.816 21.6064 4.3008 32.6144 4.4544 5.5296 0 11.0592-0.768 16.384-2.3552a30.5664 30.5664 0 0 0 22.3744-24.4224c1.9456-8.0896 3.3792-16.2304 4.352-24.4736a63.3856 63.3856 0 0 0-15.4624-49.5616 5.12 5.12 0 0 1 0.4096 0z'
              fill='#FAA100'
            ></path>
            <path
              d='M861.2864 745.8304c0.9216 5.632 11.5712 7.0656 16.4864 6.912a27.136 27.136 0 0 0 19.968-11.6736c0.8704-1.024 1.5872-2.048 2.2528-3.1744a31.6416 31.6416 0 0 1 13.824 28.7744c-2.7648 18.432-26.2144 30.9248-52.5312 27.3408a52.992 52.992 0 0 1-39.7312-23.7568c4.8128-6.0928 6.7072-13.7216 13.0048-18.944a44.2368 44.2368 0 0 1 26.7264-5.4784z'
              fill='#F6E8A0'
              opacity='.3'
            ></path>
            <path
              d='M220.3136 565.0944a16.384 16.384 0 0 0 13.0048 2.1504 272.384 272.384 0 0 1-5.376-62.0544c0.256-23.04 5.3248-45.824 14.848-66.816a46.1312 46.1312 0 0 1 4.5568-7.68v1.1776c-5.2736 13.6192-8.192 28.0576-8.7552 42.5984a245.9136 245.9136 0 0 0 6.7584 69.376l9.472-6.4a2.9696 2.9696 0 0 0 0-1.9456 185.6 185.6 0 0 1 0-40.448c2.2016-19.2 6.7584-37.9904 13.568-56.0128 9.5232-25.088 22.272-48.896 37.9392-70.656 0-0.6144 0.768-1.0752 1.0752-1.5872 0.3072-0.512 0 0 0-0.6656l-6.5536 2.304c-14.4384 5.12-28.4672 11.1616-42.0352 18.2272a26.7264 26.7264 0 0 0-5.9904 4.096 112.1792 112.1792 0 0 0-35.4816 63.232c-0.7168 3.6864-1.2288 7.4752-2.304 11.1616 0-4.096 0-8.192 0.768-12.3904a226.304 226.304 0 0 1 11.9296-57.4976 25.4976 25.4976 0 0 0 0-13.3632 18.944 18.944 0 0 0-1.792-3.9424 18.2784 18.2784 0 0 0-3.072 3.072c-5.2736 8.704-9.216 18.0736-11.8272 27.8528a307.2 307.2 0 0 0-9.3696 45.9264 306.688 306.688 0 0 0-3.1744 43.3152 131.584 131.584 0 0 0 6.0416 43.264c2.2016 6.656 5.5808 12.9024 9.9328 18.432 1.6384 1.9456 3.584 3.584 5.4272 5.376l0.4096-0.1024z'
              fill='#FAA7B5'
            ></path>
            <path
              d='M290.816 366.1312s-35.7888 5.2224-50.7904 30.4128c-15.0016 25.1904-19.456 68.7616-19.456 68.7616s-7.9872 64.768 17.8688 102.4512c-16.0768-137.984 52.3264-201.6256 52.3264-201.6256z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M223.232 567.3472a42.3936 42.3936 0 0 1-18.2272-14.4896 77.5168 77.5168 0 0 1-12.9536-31.5904 183.3984 183.3984 0 0 1-2.2016-50.9952c0.8192-9.8304 2.2016-19.5072 3.4304-29.2864a9.216 9.216 0 0 1 0-1.3312 7.3728 7.3728 0 0 0-1.3824 1.1776 284.4672 284.4672 0 0 0-62.464 101.1712 6.0416 6.0416 0 0 0 0 3.3792c8.3456 26.2656 19.968 51.3536 34.6112 74.6496 6.0416 9.8816 12.8512 19.4048 19.3536 29.0816 0.512 0.768 1.024 1.4336 2.048 2.6624 0-4.864 2.7648-8.7552 0.8192-13.568a43.8272 43.8272 0 0 1-3.84-19.2 12.6976 12.6976 0 0 1 2.4576-7.1168 31.1296 31.1296 0 0 0 6.656 13.312 6.5536 6.5536 0 0 0 0.7168-5.8368 65.8944 65.8944 0 0 1-3.9424-24.8832 42.3936 42.3936 0 0 1 1.3824-7.68 51.2 51.2 0 0 0 10.496 16.5376 141.9264 141.9264 0 0 1 22.784-34.0992 5.5296 5.5296 0 0 0 0.6656-1.8944H223.232z'
              fill='#D391E9'
            ></path>
            <path
              d='M196.352 598.016s-40.5504-79.2576-21.8112-147.456c2.3552-1.8944-3.7888 2.9696-11.1616 11.4176-1.1264 1.28-14.6944 91.2384 12.8512 130.8672-36.608-43.9296-19.5072-122.5728-21.0432-120.2176-3.4304 5.0176-6.144 10.4448-8.1408 16.1792a149.76 149.76 0 0 0 46.4896 141.9776l2.816-32.768z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M826.5728 888.4736c-1.6384 2.56-3.584 5.1712-5.12 8.192a10.496 10.496 0 0 0-0.8192 8.2944 6.0928 6.0928 0 0 0 7.3728 4.5056c2.9696-0.5632 5.9904-0.9216 9.0112-1.024 3.1744 0 3.4304 0 3.84 3.4304 0.256 4.096 3.072 7.5776 7.0144 8.704a8.192 8.192 0 0 0 8.192-4.1984 12.8 12.8 0 0 0-8.8064-19.968 58.1632 58.1632 0 0 0-9.2672 0h-1.792v-0.512c0.8192-1.024 1.4336-2.304 2.56-2.8672a11.1104 11.1104 0 0 1 7.2704-1.536c16.2816 2.7136 32.9728-0.9216 46.7456-10.0864 7.68-5.5808 13.8752-12.9536 18.1248-21.504 0.5632-1.4336 1.6896-3.328 0-4.608-1.7408-1.1776-2.8672 0-4.1984 0-6.1952 2.048-12.288 4.7104-18.5856 6.4512a90.624 90.624 0 0 1-28.2624 2.048 121.5488 121.5488 0 0 1-37.5296-7.3216 107.52 107.52 0 0 1-36.9152-22.2208 36.2496 36.2496 0 0 0-3.8912-3.1744c-2.2528-1.536-3.8912-0.768-3.9936 2.048 0 2.048 0.1536 4.0448 0.5632 5.9904 4.2496 18.944 16.896 34.816 34.304 43.1104 4.7104 2.6624 9.728 4.352 14.1824 6.2464z'
              fill='#E65270'
            ></path>
            <path
              d='M116.736 517.376a271.9744 271.9744 0 0 0 67.072 186.88c-0.6656-4.9152-1.536-9.728-1.8944-14.592-0.6656-8.192-1.024-16.4864-1.4336-24.6784a7.9872 7.9872 0 0 0-1.3824-4.4544 535.6032 535.6032 0 0 1-45.312-81.6128 207.0528 207.0528 0 0 1-14.6944-45.4144c-1.1264-5.376-1.6896-10.5472-2.3552-16.128z'
              fill='#BF73F2'
            ></path>
            <path
              d='M702.464 282.112c9.1648-14.1312 15.872-29.7984 19.968-46.2848a40.2432 40.2432 0 0 0 0-8.7552c-1.024-16.1792 0.9216-32.4608 5.888-47.872a11.52 11.52 0 0 0 0.9216-4.1984 5.632 5.632 0 0 0-0.9216-3.4816c-0.9728-1.1264-2.2528-0.7168-3.4304 0a25.7536 25.7536 0 0 0-9.0624 9.5744 79.2064 79.2064 0 0 0-8.8064 25.7024 324.2496 324.2496 0 0 0-4.5568 74.3936v0.9216z'
              fill='#F6E8A0'
            ></path>
            <path
              d='M707.2256 187.2896c2.7648-4.7616 6.1952-9.0112 10.1376-12.8l5.632-3.6864a129.2288 129.2288 0 0 0-7.936 46.1824c0 13.5168 3.9424 26.0096 4.608 39.424 0.512 11.008-4.096 16.5376-9.5744 25.4976-2.4576 4.0448-5.7856 12.8-11.1616 12.8a61.184 61.184 0 0 1-2.1504-21.1968c0-8.2432-1.3312-16.128-1.024-24.3712 1.9456-20.992 5.7856-41.6768 11.4688-61.8496z'
              fill='#8B4FBA'
              opacity='.4'
            ></path>
            <path
              d='M908.8512 829.952a34.9696 34.9696 0 0 1-30.976 19.968 125.44 125.44 0 0 1-64.1024-11.776 38.6048 38.6048 0 0 1-20.0704-18.6368 93.7984 93.7984 0 0 1-3.9936-12.288 10.9056 10.9056 0 0 0-10.0864 9.1648c0 1.6384 0.512 3.2256 1.2288 4.7104a41.984 41.984 0 0 0 11.8784 14.2848c12.544 10.0352 27.136 17.1008 42.8032 20.6336a114.176 114.176 0 0 0 61.696-1.0752c4.864-1.6384 9.5232-3.7376 13.9264-6.3488a8.2944 8.2944 0 0 0 4.6592-9.216 11.5712 11.5712 0 0 0-6.9632-9.3696z'
              fill='#E65270'
            ></path>
            <path
              d='M908.8512 829.952a34.9696 34.9696 0 0 1-30.976 19.968 125.44 125.44 0 0 1-64.1024-11.776 38.6048 38.6048 0 0 1-20.0704-18.6368 93.7984 93.7984 0 0 1-3.9936-12.288 10.9056 10.9056 0 0 0-10.0864 9.1648c0 1.6384 0.512 3.2256 1.2288 4.7104a41.984 41.984 0 0 0 11.8784 14.2848c12.544 10.0352 27.136 17.1008 42.8032 20.6336a114.176 114.176 0 0 0 61.696-1.0752c4.864-1.6384 9.5232-3.7376 13.9264-6.3488a8.2944 8.2944 0 0 0 4.6592-9.216 11.5712 11.5712 0 0 0-6.9632-9.3696z'
              fill='#2B2B2B'
              opacity='.4'
            ></path>
            <path
              d='M685.2096 620.288a47.5648 47.5648 0 0 0 5.0176 22.528c7.0144 13.568 18.944 24.1152 33.4848 29.6448 12.7488 5.12 26.5216 7.3728 40.2944 6.4h0.9216a132.608 132.608 0 0 1-27.5456-7.168 93.44 93.44 0 0 1-38.8608-26.7264 70.144 70.144 0 0 1-12.6464-22.1696c-0.0512-1.024-0.4096-1.792-0.6656-2.56zM796.416 506.88a29.952 29.952 0 0 0 12.0832-19.3024 31.6416 31.6416 0 0 0-4.4544-22.7328c2.048 14.5408-0.6144 29.3888-7.68 41.984zM820.0704 589.6704c6.8096 5.4272 15.36 8.0384 23.9104 7.424 3.5328 0 7.0144-0.768 10.4448-0.9216a22.2208 22.2208 0 0 1 5.7344 0.512c3.5328 0.8192 5.12 0 6.2976-3.2256 2.8672-7.8848 3.8912-16.384 3.1232-24.7296a45.2096 45.2096 0 0 0-2.7648-11.8784 27.7504 27.7504 0 0 0-16.4352-15.0016 26.624 26.624 0 0 0-26.7264 5.8368c-1.6896 1.3824-3.2256 2.9696-4.864 4.608 0.7168 0.9216 1.3312 1.8432 2.048 2.56 1.6384 1.536 2.304 3.9424 1.7408 6.144a13.7216 13.7216 0 0 0 7.424 15.872 79.7696 79.7696 0 0 0 20.6848 7.5776 2.048 2.048 0 0 0 1.6896-0.6656 20.8896 20.8896 0 0 0 7.936-9.8816 20.1216 20.1216 0 0 1 0 9.728 15.36 15.36 0 0 0 0.7168 8.2432l-1.28-0.7168a36.352 36.352 0 0 0-15.4624-4.1984 41.5744 41.5744 0 0 1-18.8416-6.4512 24.9344 24.9344 0 0 1-10.8032-19.968v-1.2288a22.8352 22.8352 0 0 0 5.4272 30.3616z'
              fill='#0D0D0D'
            ></path>
            <path
              d='M829.952 562.432a13.6704 13.6704 0 1 0 27.3408 0.1536 13.6704 13.6704 0 0 0-27.3408-0.1536z'
              fill='#FEA8B6'
            ></path>
            <path
              d='M835.2256 561.4592a1.6896 1.6896 0 0 0 0.9216-0.256l3.4816-2.2528a1.792 1.792 0 0 0 0.8192-1.536V552.96a1.792 1.792 0 0 0-0.8192-1.536l-3.4816-2.2528a1.6896 1.6896 0 0 0-1.8432 0l-3.5328 2.2528a1.792 1.792 0 0 0-0.8192 1.536v4.5056c0 0.6144 0.3072 1.2288 0.8192 1.536l3.5328 2.2528a1.6896 1.6896 0 0 0 0.9216 0.256zM891.4944 802.048a5.376 5.376 0 0 0 4.352 0.8192 5.632 5.632 0 0 0 3.584-2.7136 40.6016 40.6016 0 0 0-0.4608-36.0448 5.4272 5.4272 0 0 0-4.5568-3.072 5.376 5.376 0 0 0-4.8128 2.56 5.9392 5.9392 0 0 0-0.3072 5.7344c4.096 7.68 4.4032 16.896 0.8192 24.7808a6.0416 6.0416 0 0 0 1.3824 7.936z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M281.2416 834.56c-3.5328-99.8912 58.9824-67.3792 86.7328-109.568a30.72 30.72 0 0 0 4.608-8.0896c-31.1296 17.2032-118.528 6.0928-91.3408 117.6064z'
              fill='#430A1D'
              opacity='.2'
            ></path>
            <path
              d='M234.496 633.088c85.9648-73.7792 255.5392-65.5872 268.1856-64.512-71.2192 50.176-284.8768 2.9184-292.7104 156.7232a82.432 82.432 0 0 1 24.4736-92.2112z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M374.6816 719.0016v39.8848c0 16.4352-19.6608 7.424-27.2896-15.2064 11.4688-4.8128 21.0432-13.5168 27.2896-24.6784z'
              fill='#430A1D'
              opacity='.2'
            ></path>
            <path
              d='M360.8064 724.6336a41.6256 41.6256 0 0 0-2.7648-48.3328c8.2944 0 24.064-15.7696 27.8016-20.8896 4.9152-8.9088 7.168-19.0464 6.656-29.184 11.6736-0.512 19.8656-7.5776 30.464-10.1376a117.0944 117.0944 0 0 0-26.7264 29.696 239.2576 239.2576 0 0 0-12.032 32.4096 246.784 246.784 0 0 0-6.7584 26.624c-2.56 7.2704-4.096 14.848-4.7616 22.4768 0 0-1.4848 59.136 10.4448 88.32a73.1136 73.1136 0 0 1-38.5024-32.9728c-4.608-8.2944-13.312-28.0064-2.56-40.704a40.6528 40.6528 0 0 0 18.7392-17.3056z'
              fill='#430A1D'
              opacity='.2'
            ></path>
            <path
              d='M153.088 801.9968A299.9808 299.9808 0 0 0 333.5168 921.6c24.9856 5.4272 50.4832 7.8848 76.032 7.3728H724.0704c10.0864 0.3072 20.1216-1.024 29.696-4.096a32.9216 32.9216 0 0 0 20.736-18.3296 33.792 33.792 0 0 0-11.6224-39.68 46.6944 46.6944 0 0 0-30.8736-8.192c-2.9696 0-5.9392 0.512-8.8576 0.8704a6.3488 6.3488 0 0 1-2.1504 0c-0.9216 0-1.8432-0.768-2.7136-1.0752a11.3664 11.3664 0 0 1 1.536-2.304c11.3664-9.3696 19.456-22.1184 23.1424-36.352a46.6432 46.6432 0 0 0 1.3312-16.4864v-1.3312c0-2.816 0.8192-3.584 3.584-3.7888 8.2432 0 16.4864-0.6656 24.7296-1.3312 3.9424 0 8.192-1.28 12.1856-1.536-0.512 0.6656-0.9216 1.6384-1.536 1.9456a23.6544 23.6544 0 0 0-12.9536 14.848c-2.816 7.936-4.096 16.3328-3.9424 24.7296 0.6656 13.1584 5.7344 25.6512 14.336 35.5328 7.7312 9.0624 17.3056 16.384 28.0064 21.4528 1.4336 0.6656 1.7408 1.28 1.2288 2.8672a21.1968 21.1968 0 0 0 0 13.312 10.752 10.752 0 0 0 5.12 6.0416c5.632 3.2256 12.4416 3.584 18.3808 1.024l0.512 2.7648c1.792 6.7584 6.144 9.4208 12.6976 13.3632h4.5568s0-0.512 0.5632-0.512a18.9952 18.9952 0 0 0 15.1552-22.528c0-2.6624-1.1776-5.12-1.6384-7.5264 5.2736-1.3824 10.7008-2.4576 15.7696-4.1984 22.9376-7.0656 40.448-25.6512 46.2848-48.9472a24.7808 24.7808 0 0 0-6.6048-25.9072 3.4816 3.4816 0 0 1 0-2.4576c1.4848-9.216 3.7888-18.4832 4.352-27.8016a74.24 74.24 0 0 0-20.8896-57.7024 2.7136 2.7136 0 0 1-0.7168-2.8672c1.024-4.9664 2.2016-9.8816 2.7648-14.9504a31.3344 31.3344 0 0 0-9.728-26.0096 5.0176 5.0176 0 0 1-1.536-2.1504 20.48 20.48 0 0 0-10.9568-12.032 51.9168 51.9168 0 0 0-32.9216-4.4032c-7.2704 1.536-14.336 4.096-20.8896 7.5264a6.912 6.912 0 0 1-8.192 0c-0.512-0.4096-1.28-0.512-1.6896-0.9216-0.4096-0.4096-2.048-1.7408-1.8944-2.304a4.1984 4.1984 0 0 1 2.2016-2.4064 44.032 44.032 0 0 1 16.4864-3.072 92.7232 92.7232 0 0 0 49.8688-14.0288 9.1136 9.1136 0 0 1 2.4576-1.024 35.584 35.584 0 0 0 29.5424-28.8256c0-1.536 0.3584-3.072 1.024-4.4544a33.8432 33.8432 0 0 0 3.072-30.8224c-2.2528-6.7584-5.4784-13.2096-8.192-19.8656a43.52 43.52 0 0 1-3.072-11.008 167.0656 167.0656 0 0 0-5.12-31.2832 106.3936 106.3936 0 0 0-94.72-80.7936 3.9424 3.9424 0 0 1-3.9936-2.816 40.6016 40.6016 0 0 0-24.6784-23.2448 12.0832 12.0832 0 0 0-9.0112 0c-4.096 1.792-8.0896 3.9424-11.8272 6.4512-9.4208 6.7072-17.408 15.3088-23.4496 25.1904-0.512 0.768-1.0752 1.6896-1.8432 1.8944a3.9424 3.9424 0 0 1-3.1744 0c-0.5632 0-0.6656-1.9456-0.512-2.8672a11.4688 11.4688 0 0 1 1.8432-3.072c16.4352-23.8592 27.4432-51.0464 32.1536-79.6672a4.7616 4.7616 0 0 1 1.4848-2.56c4.0448-4.1984 8.192-8.2432 12.3392-12.4416a49.4592 49.4592 0 0 0 13.568-31.0784c0-0.768-0.6656-1.536-0.9728-2.2528a7.7312 7.7312 0 0 0-2.304 1.3312c-1.024 1.536-1.8944 3.2768-2.8672 4.864a36.864 36.864 0 0 1-2.4064 2.8672 1.6384 1.6384 0 0 1 0-1.2288c4.4032-11.0592 7.3728-22.6304 8.9088-34.4576 0-3.2768 0.6656-6.656 0.7168-9.984 0.1024-3.2768-1.4848-3.9424-3.072-3.2768a7.7312 7.7312 0 0 0-2.3552 1.7408 101.7856 101.7856 0 0 1-22.016 15.7184v-0.512c0-0.512-0.4608-2.304-0.6144-3.4304a259.4816 259.4816 0 0 0-9.8816-40.2944 66.4576 66.4576 0 0 1-3.4304-31.8464 23.9104 23.9104 0 0 1 8.192-16.4864 9.3696 9.3696 0 0 0 1.1776-1.3312 5.8368 5.8368 0 0 0-1.3824-0.7168 16.4352 16.4352 0 0 0-20.1728 8.192c-0.512 1.024-1.1776 1.9456-2.048 3.4304a26.8288 26.8288 0 0 1-2.304-4.7104 71.424 71.424 0 0 1-1.28-21.3504c1.2288-8.704 4.0448-17.0496 8.2432-24.7296a46.9504 46.9504 0 0 0 2.6624-6.3488 4.9664 4.9664 0 0 0-5.2224-6.7584 16.896 16.896 0 0 0-6.0928 1.0752 41.9328 41.9328 0 0 0-23.04 20.2752c0 0.8192-0.8192 1.536-1.2288 2.56a35.2768 35.2768 0 0 1-9.728-13.2096 88.576 88.576 0 0 0-4.608-9.7792c-1.2288-2.2528-2.0992-2.2528-3.584 0l-1.1776 1.7408c-1.1264 1.3824-2.048 1.3824-2.9696 0a29.184 29.184 0 0 1-1.8944-4.4032 40.6528 40.6528 0 0 0-12.9024-18.1248s-0.9216 0-1.792-1.024l0.8192 5.888c0 1.8432 0.512 3.584 0.6656 5.5296h-0.768a232.0896 232.0896 0 0 0-80.5888-36.096 80.0768 80.0768 0 0 1-25.6-7.936l-0.6144-0.256a3.072 3.072 0 0 0-3.8912 0.9216 5.0176 5.0176 0 0 1-3.2256 1.0752c-3.5328 0-6.9632-0.8192-10.4448-1.1264a61.6448 61.6448 0 0 1-9.3696-1.7408c-5.2736-1.3312-10.3424-6.4512-15.5648-6.4512h-3.6864c-1.2288 0-2.6112 3.4816-3.584 4.7104-1.024 1.2288-3.84 4.608-6.5536 4.7616a288.8704 288.8704 0 0 0-52.4288 8.2432c-26.2656 6.144-51.0464 17.408-73.0624 32.9728-16.2816 11.264-29.9008 25.9584-39.8336 43.008a97.28 97.28 0 0 0-5.1712 11.1616 12.8 12.8 0 0 0-0.512 9.0624 4.608 4.608 0 0 0 5.2736 3.4816 49.3056 49.3056 0 0 1 37.888 11.2128c11.264 7.8336 19.8656 18.944 24.7296 31.744a48.1792 48.1792 0 0 1-10.24 51.9168c-1.3824 1.536-2.9184 2.9696-4.608 4.7104-0.6144-2.4064-1.1264-4.5568-1.792-6.656a70.0416 70.0416 0 0 0-14.848-28.9792c-4.4032-4.7616-6.144 0.8192-4.9664 9.472 2.3552 17.5104-3.7376 35.072-16.4864 47.3088a6.4 6.4 0 0 1-3.0208 1.6896c-13.4144 4.7616-26.9312 9.3184-40.2432 14.2336a409.344 409.344 0 0 0-68.608 32.9728l-0.9216 0.512a5.9392 5.9392 0 0 1-2.816-5.5296c0-2.9696 0.5632-5.9392 0.9216-8.9088v-1.024c0.6656-5.2224-1.4336-6.9632-6.144-4.6592a20.48 20.48 0 0 0-6.4 5.2736 82.432 82.432 0 0 0-12.288 22.4256c-1.7408 4.096-3.1744 8.2432-4.9152 12.5952a11.264 11.264 0 0 1-2.8672 4.096c-19.0464 15.8208-36.3008 33.6896-51.3536 53.3504a290.304 290.304 0 0 0-32.512 54.5792l-0.7168 1.536h-0.512a192.7168 192.7168 0 0 1-1.792-51.0464c-1.3312 5.12-2.816 10.1376-4.096 15.2576a208.7936 208.7936 0 0 0-4.8128 62.72 8.2432 8.2432 0 0 1-0.5632 3.2256 288.8704 288.8704 0 0 0 41.7792 257.536z m-17.1008-222.1568c13.4144 28.7232 29.3376 56.1664 47.616 82.0224a7.7312 7.7312 0 0 1 1.536 4.4544c0 8.2432 0.8192 16.4864 1.4848 24.7296 0 4.9664 1.28 9.8304 1.9456 14.6944a264.7552 264.7552 0 0 1-70.3488-187.2896c0.7168 5.632 1.3312 10.752 2.304 15.872 3.328 15.7696 8.4992 31.0272 15.4624 45.568z m176.64-212.736v0.6656l-1.0752 1.4848a310.9888 310.9888 0 0 0-38.0928 71.0144 234.752 234.752 0 0 0-13.6704 56.2688 186.368 186.368 0 0 0 0 40.6016v1.8944c-3.1232 2.2528-6.2464 4.3008-9.472 6.4512a247.6544 247.6544 0 0 1-6.8096-69.632c0.512-14.6432 3.5328-29.0816 8.7552-42.752v-1.2288a43.3152 43.3152 0 0 0-4.5056 7.7824c-9.5744 20.992-14.6944 43.6736-15.0016 66.7648-0.5632 20.8896 1.2288 41.7792 5.376 62.3104a16.4352 16.4352 0 0 1-13.1072-2.1504c0 0.6656 0 1.536-0.512 1.9968-8.96 9.8816-16.4864 20.992-22.3744 32.9728l-0.512 0.8704a51.7632 51.7632 0 0 1-10.5984-16.4864 41.7792 41.7792 0 0 0-1.3824 7.68c-0.3072 8.448 1.024 16.8448 3.9424 24.7296 0.768 1.8944 0.512 4.096-0.6656 5.7856a30.4128 30.4128 0 0 1-6.7072-13.312 12.544 12.544 0 0 0-2.5088 7.1168 43.52 43.52 0 0 0 3.8912 19.2c1.9968 4.7104-0.5632 8.704-0.8192 13.5168a26.2144 26.2144 0 0 1-2.048-2.7136c-6.5024-9.6256-13.312-19.0464-19.456-28.928a318.7712 318.7712 0 0 1-34.7136-74.1888 5.9392 5.9392 0 0 1 0-3.3792 283.6992 283.6992 0 0 1 62.7712-100.5056l1.4336-1.1264v1.3824c-1.2288 9.6768-2.6624 19.4048-3.4816 29.0304-1.6384 16.896-0.8704 34.048 2.2528 50.7904 1.9456 11.264 6.3488 22.016 13.0048 31.3856a42.496 42.496 0 0 0 18.2784 14.4384c-1.8432-1.8432-3.7888-3.584-5.4784-5.5296a57.7536 57.7536 0 0 1-9.9328-18.432 132.096 132.096 0 0 1-6.0928-43.4176c0-14.592 1.024-29.184 3.072-43.6736 1.8944-15.4624 4.9664-30.8224 9.216-45.824a108.544 108.544 0 0 1 11.8272-27.9552 18.7904 18.7904 0 0 1 3.1232-3.1232c0.7168 1.28 1.3312 2.56 1.792 3.9424a25.9072 25.9072 0 0 1 0 13.5168 225.9456 225.9456 0 0 0-11.9808 57.7024c0 4.1984-0.512 8.2432-0.768 12.4416 1.0752-3.6864 1.536-7.4752 2.4064-11.1616 4.5056-24.576 16.9984-46.848 35.5328-63.488a29.5424 29.5424 0 0 1 6.0416-4.096c13.6192-7.0144 27.7504-13.1584 42.1888-18.3296l6.8608-2.304z m420.4544-191.5904a13.2096 13.2096 0 0 1-1.024 4.1984c-5.12 15.36-7.168 31.5904-6.0416 47.7184a38.656 38.656 0 0 1 0 8.7552 147.456 147.456 0 0 1-20.6848 46.2336V281.6a321.024 321.024 0 0 1 4.7104-74.24c1.536-8.96 4.608-17.6128 9.1136-25.4976a26.368 26.368 0 0 1 9.4208-9.6768c1.2288-0.6656 2.6112-1.1264 3.584 0a6.144 6.144 0 0 1 0.9216 3.3792z m10.24 131.8912a86.3744 86.3744 0 0 1-12.3904 7.7824c-15.36 7.168-31.0784 13.5168-47.104 18.944a42.496 42.496 0 0 0-22.016 18.688c-1.6384 2.56-3.2768 5.2736-4.9152 8.2432a12.032 12.032 0 0 1 0.512-2.4576c1.9456-6.4512 4.096-12.8 5.5808-19.3024a79.872 79.872 0 0 1 10.4448-25.1904c2.7136-4.2496 5.7344-8.2432 8.192-12.544a45.9264 45.9264 0 0 0 4.4032-8.2432 31.2832 31.2832 0 0 0 0.8704-5.7856H686.08a30.72 30.72 0 0 0-2.5088 2.1504c-2.9184 3.3792-5.7344 6.8608-8.704 10.1376-0.6656 0.768-2.1504 1.4848-2.816 1.2288a3.2256 3.2256 0 0 1-1.3824-2.7136c0.2048-3.6864 0.768-7.3216 1.7408-10.8544 1.536-4.7104 4.0448-9.216 5.8368-13.824a27.392 27.392 0 0 0 1.7408-7.2192c0-1.1776-1.0752-2.4064-1.536-3.584a18.9952 18.9952 0 0 0-3.0208 2.048c-1.3824 1.536-2.56 3.2768-3.9936 4.7616-1.536 1.4848-2.816 1.1264-3.6352-0.6656a7.5776 7.5776 0 0 1-1.024-4.096c0.6144-3.328 1.3312-6.5536 2.2528-9.728 0.7168-3.0208 1.792-5.888 2.4576-8.8576a5.2736 5.2736 0 0 0-2.2016-5.5296c-0.6144 0.9216-1.2288 1.6384-1.6384 2.5088-0.4096 0.8192-1.4336 3.584-2.2528 5.3248-1.536 4.1984-3.3792 8.2432-5.4272 12.2368-1.792 3.4304-3.584 3.072-5.632 0-3.84-6.5536-7.6288-13.1072-11.8784-19.4048a22.3744 22.3744 0 0 1-4.096-10.9568c-0.512-5.2736-0.768-10.6496-1.3312-15.9744a8.2432 8.2432 0 0 0-2.9184-5.9392c-0.512 2.2016-0.8192 4.096-1.2288 5.9392-0.4096 1.792-0.8704 5.5296-1.6384 8.192-0.7168 2.7648-2.048 2.0992-2.9696 0a14.1824 14.1824 0 0 1-1.536-5.12v-9.728a13.824 13.824 0 0 0-1.1776-4.4032c0-0.5632-1.024-1.024-1.536-1.4848a5.8368 5.8368 0 0 0-1.0752 1.792 12.9536 12.9536 0 0 0 0 2.5088 68.5056 68.5056 0 0 1-1.1776 7.168c-0.5632 2.56-2.1504 3.072-3.7888 1.024a22.5792 22.5792 0 0 1-3.2768-6.4512c-1.024-3.4816-1.536-7.168-2.6112-10.752a16.4864 16.4864 0 0 0-2.7136-4.608 2.2016 2.2016 0 0 0-2.1504-0.5632c-0.512 0-0.9216 1.1264-1.024 1.792v12.3392h-0.8704a19.5584 19.5584 0 0 1-6.2464-11.264c0-1.792 0-3.584-0.6656-5.4272a2.9696 2.9696 0 0 0-3.7888-2.6624 4.608 4.608 0 0 0-3.8912 4.8128v5.7344l-6.912-4.9152a223.9488 223.9488 0 0 0-74.0352-21.76 157.3376 157.3376 0 0 0-50.176 1.3312 67.5328 67.5328 0 0 0-28.16 11.6736c-1.1776 0.9216-2.3552 1.9968-3.4816 2.9696 6.9632-4.5056 14.7968-7.6288 22.9376-9.1648 15.0528-2.56 30.464-2.56 45.568 0a223.4368 223.4368 0 0 1 75.52 25.2416c18.432 9.6768 34.816 22.784 48.2816 38.656l2.9184 3.7376c-27.4432-13.1072-58.4704 11.52-89.4976 0.512 42.5472 22.016 67.6864-6.1952 91.6992 11.9808 6.0928 4.7104 7.168 16.4864-6.7584 14.6944-13.8752-1.792 19.968 4.7104 26.0096 39.424a120.0128 120.0128 0 0 1-2.4576 17.3056 167.0144 167.0144 0 0 1-34.4064 68.9664 188.3648 188.3648 0 0 1-62.6176 49.4592h-1.2288v-0.512l0.9728-1.536a165.376 165.376 0 0 0 25.6-55.6544c3.3792-13.568 3.072-27.8016-0.8192-41.216a72.5504 72.5504 0 0 0-27.648-36.608 152.8832 152.8832 0 0 0-47.616-22.0672c-3.584-1.1776-7.3216-2.048-11.3152-3.2256 0 0.512 0.512 0.6656 0.512 0.6656l2.2016 0.9216a138.24 138.24 0 0 1 32.9216 17.8688c14.8992 10.1376 25.856 25.1392 31.0272 42.496a93.184 93.184 0 0 1-0.512 47.5136 191.744 191.744 0 0 1-25.4464 56.6272 17.3056 17.3056 0 0 1-10.0864 8.2432c-5.632 1.6384-11.0592 3.7888-17.0496 5.9392a68.096 68.096 0 0 0 14.2336-59.0848v0.6656a64.512 64.512 0 0 1-11.6224 33.4336 116.8384 116.8384 0 0 1-39.7312 35.072 23.0912 23.0912 0 0 1-4.0448 1.28c5.632-6.3488 9.8816-13.7728 12.544-21.8112 2.5088-7.9872 3.072-16.4864 1.6384-24.7296a58.5728 58.5728 0 0 1-11.0592 21.5552c-9.728 12.6976-21.4016 23.8592-34.56 32.9728a139.1616 139.1616 0 0 1-28.3136 15.0016c-17.92 6.2976-36.1984 11.4688-54.7328 15.5136-16.4352 3.9424-32.3072 8.2432-48.384 12.544a70.7072 70.7072 0 0 0-24.6784 11.776 73.1136 73.1136 0 0 1-3.8912-21.248c-1.2288-96.256 75.3152-147.5584 98.6112-174.4384 6.3488-8.0896 11.1104-17.2544 13.9776-27.136 1.4336-3.84 2.6624-8.192 3.8912-11.9296l0.5632 0.6656c7.168 11.8784 9.7792 26.0096 7.3216 39.7312A106.0864 106.0864 0 0 1 358.0416 404.48l-0.9216 1.024 1.4336-0.7168c13.824-7.7312 26.2656-17.664 36.9152-29.3376 17.6128-19.2 27.8528-44.0832 28.8256-70.144a215.2448 215.2448 0 0 0-2.304-34.8672c-3.584-30.72-26.0096-55.808-56.064-62.9248a31.744 31.744 0 0 1-6.5536-2.4576 5.1712 5.1712 0 0 1-2.56-7.0656 15.872 15.872 0 0 1 1.536-3.1232c5.2224-8.3456 12.288-15.4112 20.48-20.736 4.3008-2.7648 8.2432-5.4784 12.6976-8.192 16.6912-12.288 35.4816-21.504 55.3984-27.136 8.192-2.7136 16.7936-3.8912 25.4464-3.584 2.7648 0 5.4272 1.28 8.192 1.5872 1.1776 0 2.4064-0.6656 3.584-1.024a10.2912 10.2912 0 0 0-1.9968-2.2016 36.1472 36.1472 0 0 0-17.0496-4.1984c-8.704 0.0512-17.408 1.1264-25.8048 3.1232h-2.6624c6.912-5.8368 15.0016-10.0864 23.7056-12.4416 13.9776-4.096 28.672-5.4272 43.1104-4.0448 4.7616 0 9.472 1.024 13.7728 3.072 4.2496 2.4064 8.704 4.352 13.056 6.5024 0.9216 0 1.9968 0.6656 2.9696 1.024l0.1536-0.6144c-0.512-1.1264-0.8192-2.4064-1.3824-3.5328l-4.9152-9.1648a6.144 6.144 0 0 1 0-2.1504 4.0448 4.0448 0 0 1 1.9456 0c3.3792 1.024 6.7072 2.1504 9.984 3.584 4.5056 2.048 9.3696 3.1232 14.336 3.2768 6.7072 0.512 13.568 1.024 20.2752 2.048 9.5744 1.1264 17.92 6.912 22.3232 15.4112l3.584 6.144 1.5872 1.9456h0.768l-4.7104-16.0768a28.2112 28.2112 0 0 1 14.6432 9.728c2.1504 2.4576 4.096 5.12 6.144 7.5776a29.3888 29.3888 0 0 0 3.072 2.56h0.8192l-1.2288-10.5472h0.6656l9.5744 5.8368c11.0592 6.144 20.7872 14.4384 28.672 24.32 1.024 1.536 1.7408 1.2288 2.3552-0.512 0.512-1.6896 1.024-4.4032 1.8944-6.5536 0-0.6656 1.024-1.536 1.6384-1.536 0.8192 0.1024 1.536 0.6656 1.9456 1.4336 0.512 1.4336 0.768 2.9696 0.8192 4.4544 0 3.072 0 6.144 0.4096 9.1648 0 0.9216 1.1776 1.792 1.7408 2.6112 0.768-0.6144 1.8432-1.2288 2.2528-2.048 1.2288-2.4576 2.0992-5.1712 3.2768-7.68 1.1264-2.4576 1.6384-2.4576 3.1232 0a8.9088 8.9088 0 0 0 8.192 4.5568c3.4816 0 3.9936 0 5.2224 3.2256 2.2016 5.4272 4.096 11.0592 6.3488 16.4864 1.024 2.56 2.7136 4.9152 4.0448 7.424a3.8912 3.8912 0 0 1 0 2.048 156.8768 156.8768 0 0 0-6.0416 45.4144v42.5984a43.3152 43.3152 0 0 1-10.5472 30.5152l3.328-1.3312a44.6976 44.6976 0 0 0 13.4656-11.264c8.0896-10.2912 14.4896-21.76 18.944-34.048 3.9424-9.6256 8.192-19.3536 12.032-29.0304a48.2304 48.2304 0 0 1 4.2496-6.656c0-0.512 1.536-1.0752 1.8944-0.8192a2.4576 2.4576 0 0 1 1.3312 1.8944 23.296 23.296 0 0 1 0 4.7616c-0.9216 7.8848-0.9216 15.872 0 23.7568a9.5744 9.5744 0 0 1 0 3.6864 93.3888 93.3888 0 0 1-13.9776 31.0272 25.4464 25.4464 0 0 0 10.5984-9.6768c2.56-3.6864 4.864-7.68 7.424-11.6736 1.024 4.352 2.1504 8.192 3.072 12.8a13.056 13.056 0 0 1-5.3248 15.36z m5.12 63.3856c-12.2368 11.0592-26.112 20.0192-41.216 26.5728a334.4896 334.4896 0 0 1-63.8464 20.8384c-7.8336 1.792-15.7184 3.4816-24.064 5.1712l9.4208-11.6224a2.4576 2.4576 0 0 1 1.4848-0.512 139.776 139.776 0 0 0 39.5776-10.24 240.0768 240.0768 0 0 0 76.9536-53.0944l0.5632-0.768a6.4 6.4 0 0 0-1.9456 1.0752c-18.8416 13.2608-38.5024 25.2928-58.88 36.0448a195.6864 195.6864 0 0 1-41.1136 16.4864c-3.3792 0.8192-6.8608 1.3824-10.8032 2.2016a11.7248 11.7248 0 0 0 1.024-1.6384c4.5056-8.2432 9.4208-15.5648 13.3632-23.808a31.9488 31.9488 0 0 1 10.2912-12.3904 309.1968 309.1968 0 0 1 52.5824-30.976h1.024a69.6832 69.6832 0 0 1-25.7536 27.9552c3.072-0.512 6.144-1.1264 9.216-1.9968 8.96-3.072 17.152-7.936 24.1664-14.336 8.9088-7.424 17.5616-15.2576 26.624-22.5792 4.5568-3.9424 9.5744-7.3216 14.9504-10.0864 5.8368-2.3552 11.776-4.2496 17.92-5.632a27.8016 27.8016 0 0 1 5.5296-1.024c-0.512 3.4816-1.1776 6.912-2.048 10.2912a129.536 129.536 0 0 1-35.072 54.0672z m-110.6432 162.9696c-4.5056 2.56-9.216 4.608-14.08 6.1952a106.24 106.24 0 0 1-30.6176 3.072h-21.9136a40.6016 40.6016 0 0 0-5.4784 0.9728v1.024c1.536 0.512 3.072 1.28 4.6592 1.792l15.36 4.096a29.1328 29.1328 0 0 1 2.7648 1.3312v0.5632a10.0352 10.0352 0 0 1-1.9968 0.8192c-10.24 1.9968-20.3776 4.4544-30.72 5.9392-17.408 2.2016-34.6624 5.7856-51.5584 10.752a13.4144 13.4144 0 0 1-4.4544 0.512l-51.2512-3.6864a329.984 329.984 0 0 0-59.1872 0c-22.272 2.4064-44.1344 7.68-65.024 15.872a341.8112 341.8112 0 0 0-83.1488 47.7184l-1.2288 1.1264a8.192 8.192 0 0 0 2.1504-0.9216 464.0256 464.0256 0 0 1 73.0624-36.2496c21.6064-8.3456 44.032-14.1824 66.9184-17.3056 16.5888-1.9456 33.28-2.816 49.9712-2.56H488.96l-1.4336 0.512a204.288 204.288 0 0 0-46.9504 25.4464c-4.352 3.1744-9.0624 5.632-14.08 7.5264-3.8912 1.4848-8.2432 2.9696-11.776 4.1984-20.5312 5.7856-41.472 10.24-62.5664 13.4144-17.2544 3.1232-34.56 6.3488-51.712 10.1376-15.7184 3.1744-30.72 8.704-44.7488 16.4864-23.552 12.5952-39.424 36.0448-42.1888 62.6688-0.6656 4.3008-1.024 8.192-1.4336 12.5952-0.8192-1.536-1.6896-3.4304-2.7648-5.2736a123.7504 123.7504 0 0 1-17.5616-49.4592c-3.328-23.04 4.7616-46.336 21.76-62.3104a8.2432 8.2432 0 0 0 1.6384-2.56c2.56-5.12 4.608-10.4448 7.5776-15.36 8.4992-13.312 19.968-24.576 33.3824-32.9216a244.8384 244.8384 0 0 1 56.7296-26.4192 726.528 726.528 0 0 1 96.0512-23.808c26.4192-5.0176 52.8384-9.984 79.2576-15.104a236.032 236.032 0 0 0 123.8528-63.488 4.4544 4.4544 0 0 1 2.7136-1.1264c12.4416-0.256 24.8832-1.536 37.12-3.7888a247.5008 247.5008 0 0 0 94.464-39.6288l1.7408-1.024v2.2528a210.944 210.944 0 0 1-9.728 31.488 221.184 221.184 0 0 1-100.4544 114.4832z m275.8656 261.5808a206.336 206.336 0 0 1-4.352 24.7296 30.976 30.976 0 0 1-22.6304 24.7296c-5.376 1.536-10.9056 2.3552-16.4864 2.3552a136.8064 136.8064 0 0 1-32.9216-4.5056 81.3056 81.3056 0 0 1-25.6512-10.5472 33.3824 33.3824 0 0 1-15.2576-20.3776 42.4448 42.4448 0 0 1 0-16.4864 4.7104 4.7104 0 0 1 3.3792-4.0448c17.92-6.2464 32.6656-19.2512 41.1648-36.2496a6.0928 6.0928 0 0 1 5.2736-3.7376 41.1136 41.1136 0 0 1 24.6784 3.4816c4.7104 2.56 10.3424 2.56 15.0528 0a35.4816 35.4816 0 0 0 5.7856-3.584c2.304-1.792 4.352-3.7376 6.8096-5.9904a5.1712 5.1712 0 0 0 0.5632 1.024c11.52 13.6192 16.7936 31.488 14.592 49.152z m-132.352 36.6592c1.3824 0.9728 2.6624 2.048 3.8912 3.2256 10.5984 9.8304 23.04 17.408 36.608 22.3232a128 128 0 0 0 37.6832 7.3728c9.5232 0.8192 19.0976 0.0512 28.416-2.1504 6.3488-1.7408 12.3904-4.4032 18.688-6.4512 1.28 0 3.3792-0.7168 4.1984 0 0.8192 0.768 0.4096 3.072 0 4.608-4.2496 8.5504-10.496 15.872-18.2272 21.4528a64.9216 64.9216 0 0 1-47.4112 10.2912 11.6736 11.6736 0 0 0-7.3216 1.536c-1.024 0.512-1.6896 1.8432-2.56 2.816v0.6144h1.8432a50.176 50.176 0 0 1 9.3184 0 12.6976 12.6976 0 0 1 8.96 19.7632 8.192 8.192 0 0 1-8.192 4.1984c-3.6864 0-5.376-3.072-6.656-6.2464a7.7824 7.7824 0 0 1-0.512-2.4064c0-3.1232-0.6144-3.584-3.84-3.4304-3.072 0.1024-6.0416 0.4096-9.0624 0.9728a5.9904 5.9904 0 0 1-7.3728-4.5568 10.5472 10.5472 0 0 1 0.8192-8.192c1.536-2.816 3.5328-5.4784 5.1712-8.2944-4.5056-1.8944-9.5232-3.584-14.2336-5.9904a62.8736 62.8736 0 0 1-34.4064-43.2128 24.7808 24.7808 0 0 1-0.6656-5.9904c0.8192-2.9696 2.4064-3.7888 4.864-2.2528z m9.3184-24.7296c1.024 4.1984 2.4064 8.2944 4.0448 12.288 4.096 8.2944 11.0592 14.848 19.5584 18.432 20.1216 9.5232 42.3936 13.568 64.512 11.776a35.1232 35.1232 0 0 0 31.1296-19.9168c3.9424 1.6896 6.656 5.376 7.0144 9.6768a8.704 8.704 0 0 1-3.8912 8.96c-4.4032 2.56-9.0624 4.7104-13.9264 6.3488a116.2752 116.2752 0 0 1-61.952 1.024 107.3152 107.3152 0 0 1-43.2128-20.8896 42.1888 42.1888 0 0 1-12.5952-14.0288 10.496 10.496 0 0 1-1.2288-4.6592 10.9568 10.9568 0 0 1 10.3936-9.1648l0.1536 0.1536z m-651.264-104.7552a220.3136 220.3136 0 0 1-25.6-64.512c-0.0512-14.848 1.024-29.5424 3.2768-44.1344 0.512-3.3792 1.1776-6.7584 1.7408-10.1376 0.512 0.512 0.8704 1.1264 1.0752 1.792 2.4576 8.2432 4.608 16.4864 7.424 24.7296a389.9904 389.9904 0 0 0 65.1776 115.4048c1.024 1.28 1.8432 2.7648 2.3552 4.3008 5.888 18.2784 14.592 35.4816 25.856 51.0464-12.4416-5.376-26.624-7.2704-43.6224-26.8288 20.8384 40.2432 70.144 56.1664 70.144 56.1664 27.1872 24.064 59.648 41.4208 94.8224 50.5856 2.8672 0.8192 5.7344 1.4336 8.6016 2.1504a4.7104 4.7104 0 0 0-2.048-1.1264 254.976 254.976 0 0 1-72.6016-39.9872 185.344 185.344 0 0 1-60.3136-81.0496 13.824 13.824 0 0 1-0.6656-10.3936c1.024-2.4576 1.4336-5.12 2.2528-7.68a111.616 111.616 0 0 1 29.1328-50.4832c14.08-12.6976 31.0272-21.8112 49.3568-26.5728 22.016-5.632 44.3392-9.5744 66.9184-11.776 13.0048-1.6384 26.0096-3.6864 38.912-5.6832 3.584-0.5632 7.0144-1.3824 10.752-2.1504a3.3792 3.3792 0 0 0-0.512 0.8192c-10.24 11.264-18.7904 23.9616-25.5488 37.5808a3.7888 3.7888 0 0 1-2.2016 1.9968 175.616 175.616 0 0 1-18.1248 5.4272c-9.1136 1.8432-18.432 2.4576-27.5456 4.3008-48.9984 9.728-64 35.9936-63.7952 35.7888 14.848-15.872 38.6048-20.2752 44.9536-22.528 14.592-4.7104 29.8496-6.8608 45.1584-6.3488 4.4544 0 8.96 0 13.568 0.5632a185.6512 185.6512 0 0 0 6.7584 131.8912 7.5776 7.5776 0 0 0 0-2.304 210.0224 210.0224 0 0 1-6.0928-84.6336c4.608-33.792 20.5312-65.024 45.2096-88.576 18.944-17.8176 40.96-32.1024 64.9216-42.1888 22.784-9.472 46.3872-16.896 70.5536-22.0672 18.0224-4.352 36.1984-8.2432 54.0672-13.9264a159.1808 159.1808 0 0 0 72.192-43.776c14.9504-20.0704 34.816-35.9424 57.6-46.1824a50.4832 50.4832 0 0 1 8.192-15.5648c5.8368-7.4752 12.6464-14.08 20.3264-19.6096a20.736 20.736 0 0 1 7.68-3.072 4.608 4.608 0 0 1 5.632 3.6352c0 0.8192 0 1.6384 0.6144 2.4576 1.6896 0.5632 3.2768 1.4336 4.7104 2.56l2.9696 2.56c4.096 4.4032 7.3728 9.472 9.728 15.0016 0.3072 1.0752 1.3312 1.792 2.4576 1.8432l8.192 1.28a105.7792 105.7792 0 0 1 86.272 95.0784c0.1536 4.608 0.768 9.1136 1.792 13.568 2.048 5.4784 4.4032 10.752 7.0656 15.9232 2.048 4.608 4.4544 9.1648 6.2976 13.9264a22.6304 22.6304 0 0 1 0.6144 14.9504c-0.512 1.6896-1.536 2.2016-2.8672 1.3824-1.28-0.8192-3.584-2.7136-5.4272-4.096a56.064 56.064 0 0 0-6.7584-4.864 4.4544 4.4544 0 0 0-5.8368 1.1264l1.024 0.8192 14.336 12.8512c0.512 0.6656 0.8192 1.4848 0.8704 2.304a26.8288 26.8288 0 0 1-7.4752 17.7664 22.3744 22.3744 0 0 1-22.3232 7.3728c0 3.3792-0.512 3.9936-2.4064 5.0688a80.384 80.384 0 0 1-40.2432 10.24c-10.24 0.1536-20.3264 2.9696-29.1328 8.2944a39.1168 39.1168 0 0 1-8.96 3.7888c-9.7792 2.4064-19.8656 3.584-29.952 3.584h-2.4576a2.4576 2.4576 0 0 0 1.536 0.8704c8.0896 1.8432 16.4352 2.3552 24.7296 1.536a20.2752 20.2752 0 0 1 8.192 0c6.7584 2.816 13.312 6.144 19.968 9.5232 1.536 1.024 3.4304 1.28 5.2224 0.7168 4.1984-1.536 8.192-3.1232 12.4416-4.9152a49.3056 49.3056 0 0 1 26.88-4.864c5.2224 0.512 10.24 2.0992 14.848 4.6592a9.728 9.728 0 0 1 5.4272 8.2432c0.1536 0.6144 0.512 1.1776 1.024 1.536l3.7376 3.2768a14.1824 14.1824 0 0 1 4.096 12.3392c0 4.096-1.536 4.8128-5.12 2.9696a4.7104 4.7104 0 0 0-5.376 0c2.304 1.536 4.608 2.816 6.7584 4.3008 2.9696 2.048 4.608 5.632 4.1984 9.216a20.6336 20.6336 0 0 1-23.6544 17.7152 12.288 12.288 0 0 1-8.704-5.5296 1.7408 1.7408 0 0 0-1.024-1.1264c-2.7136 0-5.4784 0.3072-8.192 0.7168a35.7376 35.7376 0 0 1-15.0528 1.3312c-2.304 0-4.7104-1.024-7.1168-1.6384-2.048 6.4512-5.3248 12.4928-9.6256 17.7152-9.728 11.776-22.6816 20.4288-37.376 24.7296-18.944 5.9392-38.9632 7.3216-58.5728 4.096a71.2704 71.2704 0 0 1-59.5968-46.4384 209.2032 209.2032 0 0 1-6.144-20.7872 151.9104 151.9104 0 0 0-13.4144-32.0512 95.0272 95.0272 0 0 0-38.4-38.6048 89.8048 89.8048 0 0 0-59.5456-8.192c-3.8912 0.7168-7.7312 1.6896-12.0832 2.6624 7.5264 0 14.5408 0.6144 21.3504 1.3312 19.0976 1.6896 37.4784 7.936 53.7088 18.1248 19.6096 11.264 34.048 29.7984 40.1408 51.6096 3.2768 12.288 7.7824 24.2176 13.5168 35.6352 3.5328 7.68 8.192 14.848 13.824 21.248 9.728 9.8816 22.016 16.896 35.4304 20.1216 4.1984 1.1264 8.2432 2.4576 12.3904 3.7888a6.6048 6.6048 0 0 1 4.096 4.096 32.256 32.256 0 0 1 1.6384 18.0736 52.9408 52.9408 0 0 1-13.0048 25.2928 92.16 92.16 0 0 1-19.1488 15.6672 92.7744 92.7744 0 0 0-9.6768 7.3216 10.752 10.752 0 0 0-3.9936 8.8576c0 6.2464 0.6656 7.2192 6.912 5.1712l2.8672-1.1264 15.3088-6.656a49.3056 49.3056 0 0 1 30.6176-3.072 30.5664 30.5664 0 0 1 23.552 21.3504c0.9728 2.2528 0.9728 4.8128 0 7.0656a4.7616 4.7616 0 0 1-3.3792 2.1504c-1.0752 0-2.304-1.1776-3.2256-2.1504-0.9216-1.024-0.512-1.6384-0.7168-2.56a15.5136 15.5136 0 0 0-7.5776-10.752 16.4352 16.4352 0 0 0-2.7136-0.7168c5.632 5.632 8.704 13.4656 8.192 21.4528a10.5472 10.5472 0 0 1-11.6736 10.1376c-1.8944 0-3.072-1.024-3.3792-2.816a60.2624 60.2624 0 0 1 0-6.656v-8.2432a9.7792 9.7792 0 0 0-7.3216-8.2432 7.5776 7.5776 0 0 0-5.632 0.6656 8.192 8.192 0 0 1 6.2976 3.6864 33.024 33.024 0 0 1 3.1232 7.2704c1.8944 5.12 0.1536 10.8032-4.2496 14.0288a20.1216 20.1216 0 0 1-8.2432 2.4576 47.36 47.36 0 0 1-17.3056-2.2528 50.3808 50.3808 0 0 0-10.4448-1.28 58.88 58.88 0 0 0-9.9328 1.28c-19.968 2.56-40.1408 3.1232-60.16 1.8432H397.4144c-22.1696 0-44.288-2.7648-65.792-8.2432-82.2784-21.504-143.872-65.9456-184.5248-140.9536a274.3296 274.3296 0 0 1-31.9488-104.8064c-0.512-4.2496 24.2176 41.5744 24.2176 37.12z'
              fill='#0D0D0D'
            ></path>
            <path
              d='M781.1584 508.928c-6.8096-14.4896-6.8608-20.6336 0.6144-34.3552 5.632-10.3936 20.6336-1.1264 18.6368-12.7488a51.5584 51.5584 0 0 0-13.312-23.5008c-2.3552-2.816-3.6864-5.632-7.168-4.864a23.1936 23.1936 0 0 0-8.96 4.096 119.808 119.808 0 0 0-24.2176 23.808c-12.3904 16.6912-7.3216 26.8288 7.2704 40.5504 8.192 4.8128 17.6128 7.2192 27.136 7.0144z'
              fill='#E65270'
            ></path>
            <path
              d='M768.4608 453.2736c4.4544-4.352 9.4208-8.192 14.7456-11.4176 3.0208-2.048-6.0416 22.784-8.6528 29.3888-8.6528 21.6576 2.7136 35.0208-0.512 33.3824a41.472 41.472 0 0 1-17.5104-24.064 43.1616 43.1616 0 0 1 11.9296-27.2896z'
              fill='#2B2B2B'
              opacity='.2'
            ></path>
            <path
              d='M780.288 508.7232c-7.0656-14.5408-7.168-20.6336 0.6144-34.4576a46.7456 46.7456 0 0 0 5.5296-36.3008 5.632 5.632 0 0 0-2.56-3.7376 5.888 5.888 0 0 0-4.5568-0.7168 24.576 24.576 0 0 0-9.5744 3.6864c-9.472 6.7072-17.92 14.7456-25.088 23.7568-9.8816 12.8-8.3456 21.6064-1.28 31.232 2.0992 2.8672 3.4304 2.816 6.1952 3.2768 2.7648 0.512 4.352-4.1984 3.1744-6.144a33.3824 33.3824 0 0 1-4.6592-12.5952 34.7648 34.7648 0 0 1 10.4448-24.3712 73.728 73.728 0 0 1 25.088-17.7152c0.6144 9.5744-1.024 19.1488-4.7616 28.0576-3.072 8.0896-12.544 23.6032-10.24 33.5872a32.256 32.256 0 0 0 6.4512 10.9568c3.584 2.6112 5.1712 1.4848 5.1712 1.4848z'
              fill='#0D0D0D'
            ></path>
            <path
              d='M407.8592 699.5968c-16.896 3.9936-34.304 3.9936-51.2 0a94.8224 94.8224 0 0 1 51.2 0z'
              fill='#8B4FBA'
              opacity='.2'
            ></path>
            <path
              d='M786.432 798.5152c8.2432-12.288 17.2032-16.4352 27.5456-26.112 10.3424-9.5744 17.3056-20.0704 27.0848-29.1328 8.0384 0.8704 16.128 1.1264 24.1664 0.768 5.5296 13.7216 33.1264 0.6144 35.328-8.192l3.584 5.2736c7.8848 15.36-20.2752 16.4352-36.352 14.848-11.264-1.1264-59.8528 11.5712-57.9584 73.9328-5.4272 8.192-18.2784 0-18.3808 11.0592-0.0512 11.1104 0 30.72 9.8816 37.7856-2.7648 9.728-12.3392-0.512-15.0016-4.4032a111.7696 111.7696 0 0 1-16.5376-34.4576c-3.4816-17.7152 7.7824-28.0064 16.64-41.3696z'
              fill='#430A1D'
              opacity='.2'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const DatabaseIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M512 93.088c282.752 0 512 73.984 512 165.248s-229.248 165.248-512 165.248S0 349.6 0 258.336s229.216-165.248 512-165.248z'
              fill='#0091FF'
            ></path>
            <path
              d='M932.256 416.832c57.888 26.784 91.808 59.328 91.808 94.432 0 91.264-229.248 165.248-512 165.248s-512-73.984-512-165.248c0-35.2 33.92-67.648 91.808-94.432 92.512 42.816 246.24 70.816 420.192 70.816 172.992 0 325.92-27.68 418.624-70.08z'
              fill='#0091FF'
              opacity='.7'
            ></path>
            <path
              d='M932.256 671.2c57.888 26.784 91.808 59.328 91.808 94.432 0 91.264-229.248 165.248-512 165.248s-512-73.984-512-165.248c0-35.2 33.92-67.648 91.808-94.432 92.512 42.816 246.24 70.816 420.192 70.816 172.992 0 325.92-27.68 418.624-70.08z'
              fill='#0091FF'
              opacity='.4'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const GlobalVarIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M42.659585 977.431369l3.739087-934.771784 934.771784 3.739087-3.739087 934.771784z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M84.979253 84.979253h849.792531v849.792531H84.979253V84.979253M0 0v1019.751037l1019.751037 4.248963 4.248963-1019.751037L4.248963 0z'
              fill='#04BEBD'
            ></path>
            <path d='M169.958506 169.958506h254.93776v84.979253H169.958506z' fill='#04BEBD'></path>
            <path
              d='M254.937759 169.958506v254.93776H169.958506V169.958506zM854.041494 169.958506v254.93776h-84.979253V169.958506z'
              fill='#04BEBD'
            ></path>
            <path
              d='M854.041494 254.937759h-254.93776V169.958506h254.93776zM854.041494 854.041494h-254.93776v-84.979253h254.93776z'
              fill='#04BEBD'
            ></path>
            <path
              d='M769.062241 854.041494v-254.93776h84.979253v254.93776zM169.958506 854.041494v-254.93776h84.979253v254.93776z'
              fill='#04BEBD'
            ></path>
            <path
              d='M169.958506 769.062241h254.93776v84.979253H169.958506zM426.595851 426.595851h169.958506v169.958506h-169.958506z'
              fill='#04BEBD'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const AlertInstanceIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1084 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M1061.948235 722.251294l-19.425882-19.395765A312.560941 312.560941 0 0 1 950.994824 481.882353v-70.535529C950.994824 184.169412 766.825412 0 539.648 0 312.440471 0 128.301176 184.169412 128.301176 411.346824V481.882353c0 82.883765-32.948706 162.394353-91.557647 220.973176l-19.365647 19.395765c-37.044706 37.074824-10.812235 100.472471 41.622589 100.472471h297.803294v-1.445647a182.904471 182.904471 0 0 1 365.748706 0v1.445647h297.773176c52.434824 0 78.697412-63.397647 41.622588-100.472471'
              fill='#6C5FEA'
            ></path>
            <path
              d='M539.648 1004.182588a182.874353 182.874353 0 0 0 182.844235-181.428706H356.803765a182.844235 182.844235 0 0 0 182.844235 181.428706'
              fill='#F9D11F'
            ></path>
            <path
              d='M539.648 638.403765a182.904471 182.904471 0 0 0-182.904471 182.874353l0.060236 1.475764h365.68847l0.030118-1.475764a182.874353 182.874353 0 0 0-182.874353-182.874353'
              fill='#41398C'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const AlertGroupIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M902.4 825.6h-96V518.4c0-153.6-121.6-275.2-275.2-275.2S249.6 364.8 249.6 518.4v307.2H153.6c-6.4 0-12.8 6.4-12.8 12.8v57.6c0 6.4 6.4 12.8 12.8 12.8h748.8c6.4 0 12.8-6.4 12.8-12.8v-57.6c0-6.4-6.4-12.8-12.8-12.8z'
              fill='#FE6D68'
            ></path>
            <path
              d='M486.4 76.8h83.2v108.8H486.4V76.8zM268.8 160l70.4-38.4 57.6 96L320 256l-51.2-96zM121.6 332.8l44.8-70.4L256 320l-38.4 70.4-96-57.6zM793.6 320l96-57.6 38.4 70.4-96 57.6-38.4-70.4zM652.8 211.2l57.6-96 70.4 38.4-51.2 102.4-76.8-44.8zM633.6 505.6H544l19.2-115.2c0-6.4 0-6.4-6.4-6.4h-6.4L409.6 550.4v12.8h96l-19.2 115.2c0 6.4 0 6.4 6.4 6.4h6.4L640 518.4s0-6.4-6.4-12.8c6.4 0 0 0 0 0z'
              fill='#F9D65D'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ClusterConfigIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1034 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M512 572.16h256a183.466667 183.466667 0 0 1 145.493333-71.68h-364.8V357.546667h139.946667a42.666667 42.666667 0 0 0 42.666667-42.666667V42.666667a42.666667 42.666667 0 0 0-42.666667-42.666667H335.36a42.666667 42.666667 0 0 0-42.666667 42.666667v272.213333a42.666667 42.666667 0 0 0 42.666667 42.666667h139.946667v142.933333H194.986667a85.333333 85.333333 0 0 0-85.333334 85.333333v128H42.666667a42.666667 42.666667 0 0 0-42.666667 42.666667v200.533333a42.666667 42.666667 0 0 0 42.666667 42.666667h207.36a42.666667 42.666667 0 0 0 42.666666-42.666667v-200.533333a42.666667 42.666667 0 0 0-42.666666-42.666667H183.04v-98.986666a42.666667 42.666667 0 0 1 42.666667-42.666667h249.6v142.933333H408.32a42.666667 42.666667 0 0 0-42.666667 42.666667v200.533333a42.666667 42.666667 0 0 0 42.666667 42.666667h67.84a174.506667 174.506667 0 0 1-33.706667-71.253333h-3.413333v-142.933334h37.973333a170.666667 170.666667 0 0 1 34.986667-34.986666z m-292.693333 213.333333v142.933334H72.96v-141.653334zM365.653333 285.866667v-213.333334h292.693334v213.333334z'
              fill='#3575BE'
            ></path>
            <path
              d='M914.346667 572.16A109.653333 109.653333 0 0 0 810.666667 643.413333h-226.133334v71.68H810.666667a110.506667 110.506667 0 0 0 103.253333 71.68 107.52 107.52 0 1 0 0-213.333333z m0 142.933333a35.84 35.84 0 1 1 36.693333-35.84 36.693333 36.693333 0 0 1-36.693333 35.84zM621.653333 786.773333a107.093333 107.093333 0 0 0-18.773333 213.333334A110.506667 110.506667 0 0 0 725.333333 929.706667h226.133334v-71.68H725.333333a109.653333 109.653333 0 0 0-103.68-71.253334z m0 142.933334a35.84 35.84 0 1 1 36.693334-35.84 36.693333 36.693333 0 0 1-36.693334 35.84z'
              fill='#3575BE'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
export const K8sIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            p-id='7302'
          >
            <path
              d='M512.742 12.62c-9.036 0-35.558 9.422-35.558 9.422l-354.842 170.88s-16.64 8.73-20.659 13.772-8.013 21.146-8.013 21.146L3.405 623.386 0.69 635.316s-2.253 9.625 1.408 16.92l5.12 10.24 7.143 11.06 258.56 321.638s7.68 10.24 12.8 12.8c5.12 5.12 23.193 2.56 23.193 2.56h407.578s20.48 1.05 25.805-2.56c7.68-5.12 16.281-17.92 16.281-17.92l245.76-308.224s16.973-21.248 19.021-29.85c2.56-20.633-4.25-41.778-4.25-41.778L934.758 240.64s-4.428-25.293-9.344-32.026-26.188-17.612-26.188-17.612L550.656 23.168S522.445 12.8 512.742 12.621z'
              fill='#316CE4'
              p-id='7303'
            ></path>
            <path
              d='M866.38 589.824c-18.713-4.275-22.143-0.82-47.308-5.555-8.909-1.664-22.477-5.12-32.666-17.92h-0.23a281.42 281.42 0 0 0 2.304-35.84 275.2 275.2 0 0 0-45.133-151.629l0.435-0.307a69.94 69.94 0 0 1 21.658-30.26c20.608-15.18 25.19-13.542 40.218-25.6 11.596-9.267 15.36-23.935 8.243-32.767s-22.195-8.525-33.792 0.742c-15.002 11.98-14.439 16.82-33.843 33.536-6.836 5.914-17.92 14.362-34.407 14.336l-0.358 0.333A275.686 275.686 0 0 0 537.6 255.078v-1.177a70.195 70.195 0 0 1-10.24-35.84c0.973-25.6 5.12-28.16 5.12-47.36 0-14.848-9.165-26.88-20.48-26.88s-20.48 12.032-20.48 26.88c0 19.2 4.147 21.785 5.12 47.36 0.358 9.037 0 23.04-10.24 35.84v1.177a275.891 275.891 0 0 0-175.386 85.402 69.811 69.811 0 0 1-32.69-14.029c-19.406-16.742-18.817-21.555-33.844-33.536-11.597-9.241-26.726-9.6-33.766-0.742s-3.354 23.577 8.243 32.947c15.001 11.98 19.61 10.24 40.217 25.6 7.04 5.12 17.28 13.798 21.248 28.826a275.072 275.072 0 0 0-44.902 151.04 279.04 279.04 0 0 0 2.56 37.53 69.555 69.555 0 0 1-30.874 16.383c-25.164 4.736-28.595 1.28-47.308 5.53-14.49 3.123-24.218 14.72-21.658 25.753s16.307 17.28 30.72 13.978c18.714-4.275 20.3-8.883 45.03-15.514 8.27-2.227 20.941-4.812 34.765 0.896a277.3 277.3 0 0 0 120.525 152.09l-1.382 2.56a70.246 70.246 0 0 1-6.324 36.736c-12.006 22.63-16.844 23.04-25.164 40.448-6.426 13.363-3.405 28.16 6.784 33.1s23.68-1.945 30.13-15.36c8.32-17.305 5.71-21.4 15.924-44.902 3.61-8.294 10.01-20.736 24.78-27.827l1.178-2.688a277.274 277.274 0 0 0 196.967-1.305 69.12 69.12 0 0 1 20.787 24.985c10.24 23.501 7.68 27.597 15.923 44.903 6.451 13.363 19.943 20.224 30.131 15.36s13.21-19.738 6.784-33.101c-8.345-17.306-13.184-17.92-25.164-40.448a53.146 53.146 0 0 1-7.168-31.847A277.248 277.248 0 0 0 774.86 616.09h0.128a69.94 69.94 0 0 1 37.222-2.023c24.73 6.656 26.317 11.264 45.03 15.514 14.465 3.302 28.16-2.944 30.72-13.978s-7.116-22.502-21.58-25.779z m-199.04-215.45c-39.014 29.696-82.815 59.444-105.855 69.3a102.758 102.758 0 0 0-11.93-5.812c-5.12-19.686-10.035-75.161-11.699-126.08a219.546 219.546 0 0 1 129.485 62.592zM528.206 496.64l20.94 25.062-6.425 32.128-29.107 14.823-29.773-13.491-7.987-31.668 19.789-26.01z m-41.651-185.011c-1.152 49.382-5.3 102.4-12.058 126.131a97.485 97.485 0 0 0-13.696 6.912c-20.762-10.24-65.638-40.243-104.832-69.58a219.443 219.443 0 0 1 130.586-63.36zM291.84 530.38a219.162 219.162 0 0 1 32.46-115.2c37.428 31.18 76.238 67.2 91.649 87.859a101.094 101.094 0 0 0-2.56 12.186c-20.992 9.907-72.704 26.316-120.167 38.681a224.896 224.896 0 0 1-1.382-23.526z m101.709 185.55a220.62 220.62 0 0 1-89.088-112.052c46.976-9.728 98.739-17.587 125.158-17.1a95.898 95.898 0 0 0 7.68 9.881c-2.534 17.741-22.579 71.168-43.75 119.27zM512 750.54a220.16 220.16 0 0 1-72.192-12.16c23.04-44.825 50.15-91.366 66.15-108.364a94.6 94.6 0 0 0 6.042 0.205q4.838 0 9.6-0.461c14.95 19.942 41.805 65.869 63.718 108.237A220.16 220.16 0 0 1 512 750.54z m119.117-35.046c-19.815-43.29-39.04-91.827-44.903-118.348a99.84 99.84 0 0 0 8.039-10.24c21.453-0.359 76.032 7.27 125.312 16.87a220.774 220.774 0 0 1-88.448 111.718z m99.84-161.664c-47.59-11.98-98.279-27.724-120.32-39.577a98.432 98.432 0 0 0-2.74-12.007c12.621-16.69 52.865-54.886 91.418-87.705a219.06 219.06 0 0 1 32.845 115.84 221.517 221.517 0 0 1-1.254 23.45z'
              fill='#F2F2F2'
              p-id='7304'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
export const HadoopIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1365 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            p-id='6267'
          >
            <path
              d='M506.24 224.992L415.802667 239.68l-82.506667 36.176-70.074667 44.08L196.533333 401.312l-37.669333 39.904-36.437333 13.429333-9.632-23.552 16.848-24.314666 3.786666-34.293334 11.28 0.458667 12.330667 11.248-3.328-34.933333-13.669333-9.173334 0.426666-13.312-32.378666 18.314667-29.317334 34.592-6.117333 30.912 12.544 24.757333 11.690667 42.053334 23.781333 11.258666 25.013333-1.226666 23.722667-13.781334-15.824 80.250667 15.824 89.290667-17.418667 41.226666L94.933333 745.898667l10.144 36.725333 27.029334 42.554667 50.96 35.856 27.029333 3.706666 30.053333 1.013334-18.752 76.976 68.949334 28.250666 85.898666 11.306667 29.386667-19.210667 2.261333-52 32.784-54.256 2.261334-42.949333 79.12 5.653333 73.466666-6.778666-73.466666 44.074666 12.437333 53.130667 46.336 72.336 45.210667 19.210667 36.170666-14.693334 14.688-29.386666 75.733334-57.642667 14.693333 12.426667 118.682667 4.528 23.733333-19.210667 2.256-33.92-7.904-14.682667-5.658667-91.557333-39.557333-79.12 6.784-35.04 23.733333 12.437333 66.688 62.16 32.778667 2.266667 36.165333-14.698667 36.176-27.125333 18.08-58.773333 106.250667 6.778666 64.426667-24.858666 51.989333-48.608 37.301333-70.08 9.034667-82.506667-7.909333-96.08-20.341334-85.893333-20.346666-27.125334-28.250667-9.045333-49.738667 54.250667-45.210666 15.824-39.562667-65.557334-39.557333-36.165333-21.477334-13.562667-85.904-71.210666-68.944-37.301334-68.949333-5.648-80.245333 13.562667-70.08 25.989333-48.602667 39.562667-38.426667 46.346667-39.557333 11.306666-68.954667 65.552'
              fill='#FFFF00'
              p-id='6268'
            ></path>
            <path
              d='M243.984 428.986667c-77.450667 90.341333-60.245333 199.898667-38.778667 307.253333a495463.466667 495463.466667 0 0 0-34.368-86.826667l-12.666666-79.610666c1.205333-27.136 2.405333-54.272 3.621333-81.402667L194.346667 410.613333l48.842666-72.362666 75.978667-63.306667 83.210667-34.373333 97.690666-12.661334-90.453333 103.109334c-72.629333 23.552-115.450667 39.424-165.637333 97.968'
              fill='#FFFFCC'
              p-id='6269'
            ></path>
            <path
              d='M608.608 153.733333c-53.84 52.533333-83.253333 92.16-117.525333 153.669334-24.506667 44-52 86.384-77.776 129.770666-13.029333 21.962667-14.261333 40.373333-18.16 65.701334l-37.989334-45.226667c6.037333-18.090667 12.064-36.181333 18.090667-54.266667l61.509333-110.346666 130.250667-128.442667c13.866667-3.621333 27.733333-7.232 41.6-10.858667m265.925333-130.24c-43.130667 16.165333-114.746667 21.493333-119.717333 70.986667-3.536 35.157333 2.650667 52.821333 23.84 90.016-52.336-54.16-65.28-45.781333-166.426667-28.949333l43.413334-61.504 75.978666-47.04 97.690667-21.706667 45.226667-1.802667'
              fill='#FFFFCC'
              p-id='6270'
            ></path>
            <path
              d='M993.536 693.04c14.357333 8.864 14.048 15.285333 11.648 21.36 11.322667-4.533333 22.650667-9.066667 33.973333-13.584l22.016-29.562667 16.336-42.112-20.88-15.696-91.253333 11.648c-2.250667 6.144-4.522667 12.293333-6.789333 18.448 0.645333 8.730667 1.301333 17.472 1.941333 26.202667 2.912 5.184 5.829333 10.357333 8.746667 15.536 4.528 2.261333 9.050667 4.533333 13.584 6.794667 3.568 0.32 7.12 0.650667 10.677333 0.965333m-8.490667-156.048c-45.744 13.2-45.386667 16.837333-58.890666 62.218667 17.829333-28.608 31.029333-43.045333 58.890666-62.218667m304.128-339.578667c-8.128 3.76-16.053333 5.562667-21.130666 13.002667-10.944 16.010667-20.32 29.477333-38.416 40.714667-9.114667 5.664-18.538667 9.333333-28.202667 12.346666-8.016 2.490667-12.837333 0.261333-19.658667 5.173334 4.053333 0.693333 8.101333 1.408 12.149334 2.117333h26.773333l33.008-20.378667 19.413333-20.389333 16.064-32.586667M560.576 298.917333c-17.989333 49.242667-33.717333 91.450667-60.970667 136.026667 34.922667-37.632 56.101333-69.621333 76.106667-112.165333 7.776-16.533333 9.242667-35.925333 30.890667-28.714667 0.970667 16.512 4.458667 33.002667 5.429333 49.504 11.696-83.829333 44.677333-118.896 121.344-151.434667l-65.04 7.770667-61.162667 13.589333-30.090666 43.68-16.506667 41.744m148.528-1.941333c16.533333 77.813333 40.341333 152.501333 50.682667 231.552 6.714667 51.365333 7.445333 76.042667-18.394667 120.362667-28.245333-1.829333-45.781333 1.354667-73.104 10.309333-108.762667 35.653333-171.146667 88.08-244.426667-17.552l70.186667 33.077333c16.677333-3.28 33.354667-6.549333 50.026667-9.84 29.450667-17.141333 58.896-34.293333 88.346666-51.44l68.917334-13.6L723.669333 506.666667l-16.506666-123.290667c-0.64-19.413333-1.290667-38.826667-1.941334-58.24 1.301333-9.386667 2.597333-18.773333 3.882667-28.154667m187.354667 481.488c-9.136 63.221333 21.04 97.205333 8.544 114.666667-3.536 4.938667-8.330667 13.568-13.68 15.936-19.12 8.442667-45.408-1.584-47.28 3.36h-63.098667l-25.237333-10.677333 38.826666-45.626667c12.618667-27.498667 25.242667-55.008 37.856-82.517333l24.266667-83.477334h12.624l27.178667 88.336'
              fill='#CCCC00'
              p-id='6271'
            ></path>
            <path
              d='M790.405333 594.677333c5.125333 28.704 14.026667 35.525333 27.530667 63.312-8.986667 45.333333-23.424 99.237333-40.8 139.237334-7.328 16.869333-13.237333 26.170667-26.165333 39.205333-21.813333 22.026667-43.856 41.205333-68.586667 60.298667-17.813333 13.722667-30.24 6.842667-52.208 3.733333-9.344 16.933333-11.92 26.346667-29.12 34.944-26.442667 13.216-50.106667-15.269333-70.864-32.037333 14.986667 23.413333 29.973333 46.810667 44.949333 70.218666 10.357333 9.706667 20.714667 19.408 31.066667 29.12l26.213333 3.888 34.938667-21.365333c6.154667-11.642667 12.298667-23.296 18.448-34.938667 12.944-9.706667 25.893333-19.413333 38.826667-29.130666 15.861333-13.584 31.717333-27.178667 47.573333-40.768l30.090667-42.714667 27.173333-50.474667c11.658667-34.944 23.306667-69.893333 34.96-104.837333 0.965333-13.269333 1.930667-26.533333 2.906667-39.808-14.56-6.464-29.12-12.944-43.685334-19.413333-10.677333-10.026667-22.570667-18.437333-33.248-28.469334m-348.256 202.234667c48.992 0 100.736-2.72 145.616-23.301333 12.693333-19.04 25.232-34.602667 40.768-51.44-14.138667 26.709333-18.576 41.802667-22.325333 71.829333l-14.56 21.36c-36.890667 0.965333-73.776 1.936-110.666667 2.912-11.978667-1.301333-23.946667-2.592-35.92-3.882667-1.296-1.306667-2.586667-2.597333-3.882666-3.888 0.330667-4.533333 0.650667-9.061333 0.970666-13.589333m-6.789333-33.973333l-3.808-34.474667c-8.368 50.389333-6.357333 84.16-29.546667 129.296-17.322667 20.064-38.650667 38.325333-63.077333 48.101333 2.064 12.373333 2.682667 20.106667 1.482667 29.178667-4.304 32.64-69.584 18.218667-96.442667 16.917333l129.258667 33.28 29.12-11.648c3.242667-18.762667 6.48-37.541333 9.712-56.304l27.178666-50.474666 4.853334-31.066667-8.736-72.8M362.544 478.506667c-1.349333 24.506667-2.933333 34.72 7.872 56.352 13.733333 27.498667 30.597333 53.344 45.52 80.522666l4.853333-54.362666c-19.408-27.509333-38.826667-55.008-58.24-82.506667m-199.274666 185.066667c-4.208 8.938667-8.4 17.888-12.608 26.832 11.562667 38.96 21.850667 63.637333 43.872 97.669333-3.84 13.786667-6.709333 19.818667-15.530667 31.056-19.381333-2.976-36.592-3.84-56.234667-3.776 21.68 16.816 43.36 33.653333 65.04 50.48 10.677333-1.952 21.36-3.893333 32.037334-5.829333l32.037333-32.032-45.626667-70.869334c-14.336-31.173333-28.661333-62.357333-42.986666-93.530666m1126.037333-479.050667c13.205333 59.397333 30.24 114.218667 28.656 175.061333-1.941333 74.64-16.485333 168.928-85.648 213.936-77.450667 50.410667-168.373333 26.565333-253.349333 4.965334l103.872 42.714666c32.357333 1.621333 64.72 3.242667 97.077333 4.853334 22.005333-6.469333 44.010667-12.938667 66.005333-19.413334 17.152-14.24 34.304-28.469333 51.456-42.714666l38.826667-81.536 14.56-94.165334c-3.877333-30.746667-7.770667-61.482667-11.648-92.224l-21.354667-91.248c-9.482667-6.746667-18.965333-13.493333-28.453333-20.229333M133.482667 361.573333c-35.157333 22.885333-48.970667 32.933333-45.114667 75.349334l10.506667 38.106666 14.896 10.08 18.4 6.133334 33.290666-7.888c5.701333-17.669333 11.392-35.333333 17.082667-53.002667l-47.306667 23.221333h-10.949333a37838.4 37838.4 0 0 0-12.266667-18.837333l14.896-21.904 7.882667-41.616c3.36 1.018667 6.72 2.048 10.074667 3.061333 4.090667 3.221333 8.176 6.432 12.266666 9.637334l-1.754666-21.898667-8.32-14.016c-2.773333-2.346667-5.546667-4.672-8.32-7.013333l-5.264 20.586666M922.336 27.36c31.210667 28.981333 69.509333 54.165333 94.469333 89.578667 9.658667 13.706667 20.389333 20.72-0.16 40.085333 21.712-6.202667 29.786667-5.530667 47.173334-3.424 31.626667 3.829333 61.269333 48.789333 63.157333 81.002667-0.373333 3.013333-8.784 9.856-33.237333 16.608-0.48 0.938667-13.802667-1.824-13.472-0.917334 2.544 6.949333 5.936 8.016 11.125333 11.264 1.12 7.733333 1.845333 19.664 7.114667 28.122667 15.386667-0.277333 30.426667 1.402667 45.493333 4.384 5.066667 8.410667 4.309333 16.821333 3.882667 25.237333l17.472-2.906666c-1.610667-13.269333-3.232-26.533333-4.848-39.802667 5.173333-8.736 10.346667-17.477333 15.530666-26.202667l-22.330666-50.485333c-14.234667-13.589333-28.469333-27.184-42.714667-40.773333l-4.106667-0.202667a380710.346667 380710.346667 0 0 1-48.037333-29.482667l-78.346667-64.096-58.165333-37.989333m52.570667 239.184c-1.648 2.88-4.133333 7.477333-7.317334 10.666667 12.997333 12.293333 19.413333 20.528 24.048 37.92-14.698667 7.290667-29.386667 14.592-44.08 21.877333l-37.301333 35.76c-16.368-8.810667-20.442667-15.573333-28.362667-32.373333-9.226667 2.448-17.957333 4.8-25.573333 2 4.832 0.037333 7.797333-1.168 12.629333-4.154667l23.733334-24.656c13.973333-10.581333 27.946667-21.173333 41.92-31.749333l27.44-8.944c3.493333-1.434667 9.370667-4.906667 12.864-6.346667'
              fill='#CCCC00'
              p-id='6272'
            ></path>
            <path
              d='M1015.466667 310.394667c-46.752 25.173333-91.52 50.485333-115.424 98.288 0-60.677333 60.922667-87.386667 115.418666-98.293334m-124.698666-119.36c-34.714667 23.669333-59.258667 71.434667-56.176 117.984-11.306667-40.309333-7.301333-78.394667 27.413333-106.234666 5.866667-2.842667 11.717333-5.696 17.578667-8.538667 3.728-1.066667 7.450667-2.133333 11.184-3.210667'
              fill='#CCCC00'
              p-id='6273'
            ></path>
            <path
              d='M1357.893333 300.928c-6.293333-39.696-16.730667-78.229333-31.216-105.936-1.76-3.386667-4.437333-6.821333-7.754666-10.096-7.194667-7.093333-17.845333-13.813333-28.848-17.594667-11.658667-4.010667-23.952-4.826667-33.712 0.272-2.533333 1.333333-4.890667 3.04-6.986667 5.173334-6.32 6.4-11.653333 14.186667-16.992 21.978666-5.936 8.682667-11.909333 17.408-19.056 23.504-8.282667 7.082667-18.645333 11.381333-28.421333 15.306667a192.650667 192.650667 0 0 0-14.789334-28.752c-6.682667-10.656-14.293333-20.634667-22.666666-30.613333a125.626667 125.626667 0 0 0-20.698667-19.749334c-7.221333-5.509333-14.613333-10.149333-23.221333-15.536-23.077333-14.453333-42.730667-31.690667-62.773334-49.28-9.109333-7.989333-18.309333-16.053333-27.306666-23.472-47.733333-39.36-92.256-58.448-139.872-61.44-47.290667-2.976-97.226667 10.016-156.186667 34.837334-28.458667 11.973333-49.589333 26.128-68 43.146666-17.584 16.266667-32.512 34.997333-48.922667 56.869334-9.546667 0.677333-18.005333 2.090667-26.64 5.546666-9.514667 3.808-19.093333 9.973333-30.570666 20.101334a691.072 691.072 0 0 0-23.466667 21.690666 810.005333 810.005333 0 0 0-20.661333 20.784c-53.674667 8.624-97.408 18.144-136.576 33.312-40.053333 15.52-75.36 36.864-111.621334 69.013334a293.536 293.536 0 0 0-38.864 41.722666c-11.029333 14.448-20.469333 29.637333-28.752 45.653334-7.253333 8.026667-14.522667 16.128-22.389333 23.216-7.669333 6.906667-15.845333 12.725333-25.008 16.250666l0.005333 0.005334c-5.328 2.053333-7.530667 3.253333-7.770666 3.173333-0.266667-0.149333-0.416-0.949333-0.789334-2.421333 13.157333-12.554667 15.226667-31.002667 16.442667-49.317334 1.578667 1.888 3.093333 4.213333 4.666667 6.645334 1.738667 2.682667 3.52 5.450667 5.653333 8.144l8.933333 11.269333 3.136-14.058667c2.634667-11.781333 4.608-27.466667 1.536-41.066666-1.984-8.826667-6.08-16.693333-13.216-22.266667 0.682667-1.781333 1.328-3.424 1.962667-5.045333 2.24-5.733333 4.549333-11.616 6.506667-17.173334l3.872-11.013333-11.52 1.994667c-15.328 2.666667-48.266667 20.768-71.466667 44.837333-8.613333 8.944-16.021333 18.826667-20.88 29.194667-5.056 10.789333-7.322667 22.08-5.36 33.376 1.706667 9.877333 6.650667 19.573333 15.626667 28.714666 1.637333 6.597333 3.146667 12.32 4.762666 17.482667 1.850667 5.872 3.84 11.125333 6.330667 16.298667 6.752 14.037333 17.514667 22.613333 29.973333 26.613333 10.010667 3.216 21.082667 3.376 31.941334 0.997333a291.664 291.664 0 0 0-3.978667 39.12c-0.688 18.32-0.016 38.56 2 62.048a327.466667 327.466667 0 0 0 4.554667 32.538667c-2.026667 5.536-4.069333 11.082667-6.106667 16.618667l-9.477333 25.797333-20.853334 20.666667c-6.490667 6.416-12.981333 12.848-19.466666 19.274666-0.533333 0.533333-2.725333 2.634667-4.709334 4.549334-13.146667 12.650667-15.749333 15.162667-12.016 37.424a135.733333 135.733333 0 0 0 13.776 40.8c6.453333 12.293333 15.114667 24.261333 26.229334 35.408 13.866667 13.898667 36.597333 31.168 60.394666 40.213333 13.6 5.162667 27.616 7.690667 40.773334 5.578667-0.672 2.026667-1.322667 4.042667-2.064 6.08a229.808 229.808 0 0 1-6.933334 17.056c-16.144 35.386667 0.426667 53.866667 26.218667 65.626666 12.88 5.866667 28.192 9.856 42.416 13.568 2.912 0.746667 5.824 1.514667 9.493333 2.506667 16.853333 4.554667 45.978667 12.922667 72.581334 14.602667 29.034667 1.834667 55.221333-4.16 62.24-30.218667 2.773333-10.330667 4.389333-18.24 5.045333-25.989333 0.602667-7.189333 0.373333-14.453333-0.469333-23.445334 8.277333-18.346667 11.786667-23.504 17.84-32.352 1.184-1.749333 2.618667-3.84 3.050666-4.501333 6.490667-9.616 9.530667-16.442667 10.634667-24.128 1.066667-7.418667 0.16-14.810667-1.178667-26.106667-0.128-1.072-0.32-2.64-0.602666-4.714666a416.693333 416.693333 0 0 0 50.410666 3.456c8.458667 0.053333 16.912-0.197333 25.365334-0.64-2.16 1.104-4.277333 2.202667-6.592 3.392l-3.146667 1.616c-22.421333 11.530667-23.354667 33.370667-16.336 55.84 6.325333 20.261333 19.349333 40.949333 27.52 53.530666 17.173333 26.469333 33.562667 48.874667 53.434667 61.050667 20.826667 12.762667 44.624 14.266667 75.338666-2.357333 15.626667-8.458667 20.554667-17.082667 27.189334-28.709334 2.032-3.546667 4.272-7.413333 6.768-11.226666 6.453333-4.277333 22.522667-17.530667 38.293333-30.570667 5.370667-4.437333 10.736-8.853333 16.789333-13.786667 4.170667 3.066667 9.205333 5.194667 15.290667 6.645334 7.904 1.893333 17.317333 2.746667 28.597333 3.557333 8.442667 0.618667 35.973333 0.597333 53.76 0.592 5.493333 0 10.053333 0 12.789334 0.016 18.362667 0.112 33.184-0.853333 44.384-7.2 11.936-6.768 19.013333-18.752 20.56-40.245333 0.672-9.546667 0.8-15.434667-0.528-21.445334-1.237333-5.632-3.653333-10.736-7.802667-18.202666a48773.813333 48773.813333 0 0 1-0.746667-27.866667c-0.256-9.850667-0.533333-19.712-0.789333-29.562667-0.314667-11.616-1.594667-21.056-3.952-30.341333-2.336-9.221333-5.674667-18.090667-10.144-28.736a483.552 483.552 0 0 1-7.882667-20.298667l-6.442666 2.357334 0.992-0.362667 5.450666-1.994667v-0.026666c-3.84-10.357333-7.626667-20.442667-12.928-31.232 0.341333-2.08 0.688-4.32 1.024-6.709334l10.24 9.866667 15.093334 14.544c11.509333 11.088 22.032 21.173333 34.394666 28.458667 12.784 7.546667 27.157333 11.925333 45.770667 11.04 19.488-0.917333 40.341333-9.125333 57.509333-21.792 16.608-12.261333 29.936-28.794667 35.498667-47.093334l4.821333-15.872 3.850667-12.666666c27.328 4.629333 56.661333 6.122667 84.992 3.157333 27.338667-2.874667 53.749333-9.834667 76.528-21.984 33.482667-17.866667 58.586667-44.181333 76.629333-75.429333h0.010667c20.16-34.922667 31.450667-76.074667 35.738667-118.421334 3.44-33.962667 1.562667-80.133333-5.509334-124.661333z m-354.064 285.429333c-15.749333-5.301333-26.698667-13.034667-40.533333-21.754666 3.765333 16.976 5.477333 34.928 0.464 51.872-7.957333 26.890667-20.810667 70.88 15.696 78.997333 13.893333 3.082667 20.197333 2.64 39.808-7.482667-15.872 3.594667-23.877333 2.72-34.789333 0.693334-9.888-1.818667-15.130667-8.096-17.893334-15.504 3.456 2.490667 9.088 3.845333 18.72 6.165333 27.061333 6.528 52.848-6.506667 57.893334-25.269333 2.933333-10.965333 2.437333-16.725333 8.672-31.669334 5.6 1.733333 11.386667 3.306667 17.328 4.746667l-10.058667 32.794667c-8.693333 28.373333-42.586667 51.253333-72.506667 50.725333-27.658667-0.485333-45.2-17.813333-64.298666-34.8-13.152-11.712-25.813333-22.906667-38.357334-34-34.426667-10.864-62.021333-23.557333-93.973333-47.210667 22.741333 26.72 38.16 41.514667 69.872 54.810667-4.608 47.04-20.96 81.344-34.896 126.362667-6.314667 20.352-56.112 101.925333-69.914667 109.877333-9.84 5.669333-71.482667 57.584-83.072 64.437333-8.64 11.466667-16.218667 27.317333-29.205333 34.176-39.562667 20.922667-64.986667-19.136-86.277333-52.965333-9.690667-15.413333-36.613333-59.808-13.146667-72.245333 22.186667-11.749333 34.613333-20.144 57.253333-35.013334 3.328 6.064 9.029333 11.92 12.746667 17.973334l-2.464-19.872c-1.493333-12-1.429333-21.744-0.48-33.818667 0.928-11.690667 1.845333-23.381333 2.762667-35.077333-3.408 11.888-10.213333 23.770667-13.610667 35.648-1.36 4.757333-2.485333 8.597333-3.136 12.16-50.794667 10.378667-101.221333 11.024-152.026667 1.962666-3.242667-18.810667-7.189333-38.410667-10.501333-52.464-1.002667 15.733333-0.357333 59.242667-0.437333 83.605334-0.064 18.869333-0.853333 25.333333-10.592 41.386666-9.109333 15.029333-12.965333 18.442667-25.728 43.84 1.066667 16.026667 1.082667 26.613333-3.173334 41.824-7.077333 25.285333-78.506667 5.696-97.344 0.533334-23.205333-6.346667-71.173333-15.786667-59.109333-46.72 10.613333-27.221333 17.344-55.925333 22.533333-94.016-42.512-61.242667-82.042667-145.162667-89.632-219.52-5.893333-57.733333-2.357333-93.269333 10.133334-128.586667 19.797333-55.957333 47.498667-104.394667 91.936-143.397333C332.437333 276.96 388.469333 255.84 476.213333 242.48c-21.098667 23.626667-41.973333 48.597333-64.725333 75.376-23.034667 27.109333-36.714667 54.490667-51.344 84.149333-20.202667 40.954667-19.765333 56.538667 7.013333 92.496 23.077333 30.986667 35.536 44.933333 45.616 75.253334-8.32 17.152-11.349333 31.653333-14.144 55.072 28.256 30.896 49.258667 52.058667 76.693334 58.576 26.917333 6.4 49.386667 5.162667 73.472-7.146667 53.477333-27.338667 102.96-62.645333 163.285333-64.106667 27.909333-68.608 25.088-125.941333 11.690667-192.325333-9.152-45.338667-12.826667-88.266667-15.669334-134.485333-11.312 47.6-13.44 89.456-5.045333 136.874666 10.122667 57.136 17.989333 120.266667-10.16 170.485334-54.554667 4.176-101.301333 37.365333-150.464 62.826666-19.765333 10.24-40.341333 11.237333-62.213333 5.232-20.304-5.578667-34.005333-19.013333-55.877334-44.24-0.346667-25.328 5.370667-37.013333 17.002667-59.957333 18.688-36.837333 39.312-71.125333 61.946667-107.365333-27.712 33.450667-53.973333 61.402667-75.786667 95.04-8.341333-23.754667-20.266667-35.818667-40.016-62.570667-19.290667-26.128-21.306667-37.562667-6.88-67.802667 14.501333-30.384 26.8-57.088 51.488-83.744 42.650667-46.064 81.728-97.328 128.373333-142.693333 25.328-24.629333 35.610667-23.781333 69.205334-28.869333 30.368-4.608 60.010667-10.416 90.976-17.605334-29.946667 2.789333-58.896 3.813333-88.053334 4.533334l-0.906666 0.026666c28.693333-36.634667 45.338667-57.050667 91.925333-77.296 114.709333-49.813333 187.594667-55.2 277.701333 20.538667 23.354667 19.637333 43.749333 38.693333 67.424 55.626667-8.586667 0.736-15.984 2.277333-25.770666 6.117333 11.909333-2.272 25.664-0.021333 38.026666 2.24 3.466667 2.250667 7.04 4.448 10.682667 6.597333 16.72 9.850667 26.208 15.290667 37.514667 31.04 11.946667 16.645333 21.909333 33.28 30.682666 51.616-5.749333-2.058667-10.576-3.792-14.874666-5.066666a32.016 32.016 0 0 0-30.170667 1.866666l-0.693333 0.32c-9.248 4.506667-23.573333 9.637333-33.157334 11.194667 4.890667 1.685333 15.706667 2.32 20.805334 0.298667 0.682667-0.266667 1.376-0.48 2.090666-0.645334a31.994667 31.994667 0 0 0-4.266666 13.162667 32 32 0 0 0 3.418666 17.786667l0.026667 0.058666c0.864 2.037333 2.069333 3.909333 3.392 5.264-4.378667 1.616-8.853333 3.461333-13.466667 5.461334 21.381333-3.253333 40.656-3.813333 61.514667-1.066667 1.376 6.576 2.762667 13.546667 4.053333 20.634667l-7.754666 0.608a27.546667 27.546667 0 0 0-0.624 0.053333c-9.872-7.888-20.869333-6.56-35.893334-3.130667-45.696 10.416-34.96 36.053333-55.973333 74.688 21.824-26.677333 20.202667-54.592 55.770667-63.018666 8.288-1.957333 13.930667-4.416 19.541333-3.573334-10.096 5.077333-18.826667 13.498667-22.293333 23.274667-9.76 27.568-3.701333 50.794667-14.426667 76.544 13.28-23.018667 14.085333-45.482667 25.968-69.706667 4.266667-8.693333 20.096-22.613333 29.813333-22.826666l8-0.176c2.346667 15.317333 3.770667 30.533333 2.864 43.152-1.658667 23.029333-7.642667 57.210667-11.221333 70.293333 12.032-15.472 17.514667-48.234667 22.8-71.306667 5.504-24.010667 4.112-52.826667-0.704-78.629333-6.613333-35.397333 29.845333-29.637333 51.008-46.32 15.557333-12.266667 26.272-31.845333 40.533333-45.722667 14.149333-13.76 36.426667 6.458667 41.989334 19.904 24.128 58.384 35.12 150.229333 28.752 209.082667-7.157333 66.037333-39.050667 138.128-97.296 170.64-74.250667 41.44-161.797333 16.122667-235.573334-8.730667z m-105.504 293.301334c-2.421333 27.248-11.504 29.045333-35.429333 28.629333-10.869333-0.192-54.154667-0.389333-65.141333-1.333333-15.52-1.338667-24.234667-2.725333-28.976-6.266667 24.384-17.898667 65.813333-91.797333 73.893333-117.242667 8.544-26.88 17.893333-50.336 24.848-75.178666 3.2 10.384 5.722667 20.672 10.378667 31.701333 7.770667 18.432 11.573333 29.818667 12.128 49.589333l1.76 62.576c6.682667 11.690667 7.722667 14.186667 6.538666 27.52zM164.496 673.248c15.482667 53.562667 41.861333 106.197333 71.104 150.448v0.773333c-1.84 7.610667-3.957333 15.013333-8.4 20.96-20.906667 27.968-74.069333-13.082667-89.461333-28.784-16.821333-17.184-28.08-37.52-30.762667-56.602666-1.952-13.909333-0.053333-14.250667 9.653333-24.096l39.264-39.749334 8.602667-22.949333z m-29.573333-336.853333c-3.968 8.517333-6.784 14.976-8.698667 21.621333-8.336 28.789333 3.770667 54.485333-22.368 75.354667 12.282667 24.778667 11.717333 34.666667 40.288 23.216 11.018667-4.426667 20.106667-10.613333 28.224-17.941334a529.92 529.92 0 0 0-10.832 30.965334c-0.565333 1.76-1.104 3.536-1.621333 5.296-20.432 8.672-47.306667 14.181333-57.589334-7.290667-4.992-10.426667-7.813333-20.656-11.456-33.829333-33.648-34.858667 16.650667-80.885333 44.053334-97.392z m16.538666 36.928c-4.154667-4.16-7.477333-6.970667-12.848-6.362667 0.453333-3.52 1.056-6.917333 1.904-10.106667 0.426667-1.642667 0.885333-3.253333 1.376-4.869333 6.965333 4.058667 8.8 11.413333 9.568 21.333333z m1008.949334-130.208c1.269333 2.677333 2.517333 5.402667 3.744 8.16-1.013333 0.746667-1.978667 1.530667-2.88 2.357333a32.512 32.512 0 0 0-7.045334-10.336c2.005333-0.074667 4.064-0.138667 6.186667-0.181333zM188.976 401.349333l-0.005333-0.005333v0.005333z m-109.525333 37.008z m368.186666 384.901334h0.010667-0.010667z m303.269334 90.538666h-0.005334 0.005334z m123.253333-234.277333h0.010667l-0.005334 0.005333zM138.4 443.253333h-0.005333l-0.229334-0.586666 0.229334 0.592z m1183.221333 97.269334l0.16 0.096-0.16-0.096zM19.669333 434.869333c5.354667-60.624 17.141333-86.8 60.213334-132.426666C25.856 340.512 12.373333 357.813333 19.669333 434.864'
              p-id='6274'
            ></path>
            <path
              d='M5.733333 385.349333c5.946667-27.285333 11.493333-37.584 28.32-59.978666C6.752 344.437333 3.2 352.266667 5.728 385.349333M639.6 4.981333c-32.368 7.802667-38.538667 13.786667-48.245333 45.514667 15.488-23.232 24.405333-30.789333 48.245333-45.514667'
              p-id='6275'
            ></path>
            <path
              d='M690.64 0.362667c-64.197333 15.733333-83.061333 26.922667-104.384 101.328 27.104-54.496 47.626667-74.56 104.384-101.333334m138.261333 271.237334c6.842667-30.314667 19.002667-59.525333 66.08-82.128-62.4 15.626667-74.101333 41.84-66.08 82.133333m397.056 2.090667c36.954667-13.173333 54.768-42.885333 63.616-77.84-14.464 29.296-36.784 53.797333-67.104 68.805333-16.272 8.053333-26.666667 5.242667-44.837333 3.52 18.48 5.306667 30.186667 11.978667 48.325333 5.514667m-251.744 29.706666a41.989333 41.989333 0 0 0-23.536-21.381333c9.066667-4.837333 17.968-9.92 24.912-16.24-20.346667 9.418667-44.032 7.12-61.493333 18.912-15.376 10.389333-36.602667 43.306667-52.229333 57.264 11.317333-4.394667 22.224-11.994667 32.266666-20a41.850667 41.850667 0 0 0 22.522667 36.816 94.405333 94.405333 0 0 0-13.642667 24.906667c29.754667-35.264 72.896-61.898667 113.461334-73.285334-11.338667-0.16-24.762667 1.957333-38.437334 6.453334a41.770667 41.770667 0 0 0-3.824-13.445334m-42.810666 266.464c-1.445333 9.130667-3.429333 20.48-4.874667 29.616 3.866667-10.336 8.517333-22.346667 13.013333-32.202666 4.768-10.432 7.450667-11.413333 17.568-16.917334 7.173333-3.904 20.197333-9.269333 27.370667-13.173333-7.381333 1.242667-20.608 3.957333-27.989333 5.2-19.712 3.328-22.032 8.064-25.088 27.477333M594.666667 217.312c-22.88 22.613333-45.104 100.213333-52.202667 131.264 11.184-25.792 39.173333-97.941333 60.645333-116.293333 5.930667-5.072 10.074667-8.186667 14.528-10.453334-15.370667 25.776-14.24 32.186667-8.848 66.72 4.581333-35.109333 16.72-48.672 36.64-74.864 21.834667-5.477333 42.272-12.042667 64.672-20.778666a4148.64 4148.64 0 0 1-75.76 7.861333c-21.216 2.010667-24.634667 1.669333-39.68 16.544'
              p-id='6276'
            ></path>
            <path
              d='M906.346667 349.408a17.562667 17.562667 0 0 1 8.298666-23.392 17.626667 17.626667 0 0 1 24.416 10.810667c-8.352 6.202667-16.005333 13.498667-22.426666 21.957333-4.32-1.738667-8.149333-4.896-10.293334-9.376m195.381334-75.584c0.704-7.226667 6.864-12.554667 14.090666-11.856a13.216 13.216 0 0 1 11.861334 14.384 13.226667 13.226667 0 0 1-1.189334 4.304c-6.613333 1.136-13.226667 3.066667-20.042666 5.573333-2.848-2.917333-5.12-8.24-4.72-12.405333'
              fill='#FFFFCC'
              p-id='6277'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const BatchJobIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M512 54.272A457.728 457.728 0 1 0 969.728 512 458.752 458.752 0 0 0 512 54.272z m0 893.952A436.224 436.224 0 1 1 948.224 512 437.248 437.248 0 0 1 512 948.224z'
              fill='#1296db'
            ></path>
            <path
              d='M751.616 600.064a93.184 93.184 0 0 0-72.704 34.816l-43.008-31.744a154.624 154.624 0 0 0-112.64-246.784v-40.96a93.184 93.184 0 1 0-21.504 0v39.936a154.624 154.624 0 0 0-122.88 234.496L335.872 624.64a92.16 92.16 0 1 0 14.336 16.384l41.984-32.768a154.624 154.624 0 0 0 230.4 12.288l45.056 33.792a93.184 93.184 0 1 0 83.968-53.248zM272.384 764.928a71.68 71.68 0 1 1 71.68-71.68 71.68 71.68 0 0 1-71.68 71.68zM440.32 223.232a71.68 71.68 0 1 1 71.68 71.68 71.68 71.68 0 0 1-71.68-71.68z m71.68 420.864a133.12 133.12 0 1 1 133.12-133.12 133.12 133.12 0 0 1-133.12 133.12z m239.616 120.832a71.68 71.68 0 1 1 71.68-71.68 71.68 71.68 0 0 1-71.68 71.68z'
              fill='#1296db'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const StreamingJobIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M85.333333 243.825778L512 0 938.666667 243.825778v487.708444l-426.666667 243.712L85.333333 731.534222V243.825778z m782.222223 452.835555v-418.133333L512 69.745778 156.444444 278.584889v417.962667L512 905.671111l355.555556-209.009778zM552.106667 526.051556v235.918222a30.947556 30.947556 0 0 1-31.175111 30.492444 30.776889 30.776889 0 0 1-22.186667-8.760889 29.525333 29.525333 0 0 1-8.874667-21.731555V525.994667L271.928889 402.944a30.321778 30.321778 0 0 1 7.68-55.808 30.947556 30.947556 0 0 1 23.495111 3.356444l217.884444 121.912889 215.836445-121.856a30.947556 30.947556 0 0 1 42.268444 10.865778 30.151111 30.151111 0 0 1-11.150222 41.528889L551.992889 524.743111v1.251556l0.056889 0.056889z'
              fill='#1890FF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const GitIcon = (props: any) => {
  const imgStyle = props.style || {};
  return (
    <>
      <Icon
        {...props}
        style={{ ...imgStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M512.416 15.072C229.056 15.072 0 242.848 0 524.608 0 749.856 146.784 940.512 350.368 1008c25.44 5.056 34.784-10.976 34.784-24.48 0-11.808-0.864-52.288-0.864-94.496-142.528 30.368-172.224-60.736-172.224-60.736-22.912-59.04-56.832-74.24-56.832-74.24-46.656-31.2 3.392-31.2 3.392-31.2 51.744 3.36 78.912 52.288 78.912 52.288 45.824 77.6 119.616 55.68 149.312 42.176 4.256-32.896 17.824-55.68 32.224-68.32-113.696-11.808-233.312-55.68-233.312-251.392 0-55.68 20.352-101.248 52.608-136.672-5.088-12.64-22.912-64.96 5.088-134.976 0 0 43.264-13.504 140.832 52.32 40.736-10.976 84.832-16.864 128.096-16.864s87.392 5.92 128.096 16.864c97.568-65.792 140.832-52.32 140.832-52.32 28 70.016 10.176 122.336 5.088 134.976 33.088 35.424 52.608 80.992 52.608 136.672 0 195.712-119.616 238.752-234.144 251.392 18.656 16.032 34.784 46.4 34.784 94.496 0 68.32-0.832 123.168-0.832 140.032 0 13.504 9.344 29.536 34.784 24.48 203.616-67.488 350.368-258.144 350.368-483.392C1024.8 242.848 794.912 15.072 512.384 15.072z'
              fill='#242F3E'
            ></path>
            <path
              d='M192.64 746.656c-0.768 2.624-4.576 3.488-7.648 1.76s-5.344-5.248-3.808-7.84c0.768-2.624 4.576-3.488 7.648-1.76s4.576 5.248 3.808 7.84z m18.304 23.552c-2.304 2.624-6.88 0.864-9.152-2.624-3.04-3.488-3.808-8.736-1.536-11.36s6.112-0.864 9.152 2.624c3.04 4.352 3.808 9.6 1.536 11.36z m18.336 30.56c-3.04 2.624-7.648 0-9.92-4.352-3.04-4.352-3.04-10.464 0-12.224 3.04-2.624 7.648 0 9.92 4.352 3.04 4.352 3.04 9.6 0 12.224z m25.184 29.664c-2.304 3.488-7.648 2.624-12.224-1.76-3.808-4.352-5.344-10.464-2.304-13.088 2.304-3.488 7.648-2.624 12.224 1.76 3.808 3.488 4.576 9.6 2.304 13.088z m34.336 16.576c-0.768 4.352-6.112 6.112-11.456 4.352s-8.384-6.976-7.648-10.464c0.768-4.352 6.112-6.112 11.456-4.352s8.384 6.112 7.648 10.464z m37.408 3.488c0 4.352-4.576 7.84-9.92 7.84s-9.92-3.488-9.92-7.84 4.576-7.84 9.92-7.84 9.92 3.488 9.92 7.84z m35.104-6.976c0.768 4.352-3.04 8.736-8.384 9.6s-9.92-1.76-10.688-6.112c-0.768-4.352 3.04-8.736 8.384-9.6s9.92 1.76 10.688 6.112z'
              fill='#1296DB'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
