/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

const defaultSvgSize = '100%';

// const style = {overflow: "hidden",width: "100%",height: "100%"};
const style = { overflow: 'hidden' };

export const AllJobIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg className='icon' viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M505.7536 487.68l434.5856-245.6576L512 0 77.4656 245.6576z'
              fill='#6D88FF'
              p-id='1877'
            ></path>
            <path
              d='M480.768 544.2048L51.2 301.2608v480.1024L480.768 1024v-479.8464z'
              fill='#B6C3FF'
              p-id='1878'
            ></path>
            <path
              d='M543.232 537.1904v486.7584L972.8 781.312V294.3488l-429.568 242.944z'
              fill='#6D88FF'
              p-id='1879'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const BatchIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M816.1 842.8h-580c-19.3 0-35-15.7-35-35v-580c0-19.3 15.7-35 35-35h580c19.3 0 35 15.7 35 35v580c0 19.3-15.7 35-35 35z'
              fill='#B9F4E8'
              p-id='5075'
            ></path>
            <path
              d='M816.1 850.3h-580c-23.4 0-42.5-19.1-42.5-42.5v-580c0-23.4 19.1-42.5 42.5-42.5h580c23.4 0 42.5 19.1 42.5 42.5v580c0 23.4-19 42.5-42.5 42.5z m-580-650c-15.2 0-27.5 12.3-27.5 27.5v580c0 15.2 12.3 27.5 27.5 27.5h580c15.2 0 27.5-12.3 27.5-27.5v-580c0-15.2-12.3-27.5-27.5-27.5h-580z'
              fill='#20DAB4'
              p-id='5076'
            ></path>
            <path
              d='M695.5 392.6c-30.9 0-56 24.9-56 55.7 0 11 3.2 21.3 8.7 29.9l-38.4 38.4c-11.4-8-25.3-12.7-40.3-12.7-17.5 0-33.5 6.4-45.8 17l-17.3-17.3c4-7.1 6.3-15.3 6.3-24 0-27.3-22.3-49.4-49.7-49.4-27.4 0-49.7 22.1-49.7 49.4 0 6.5 1.3 12.7 3.5 18.3l-29.2 29.2c-8.9-5.9-19.5-9.3-31-9.3-30.9 0-56 24.9-56 55.7 0 30.7 25.1 55.7 56 55.7s56-24.9 56-55.7c0-9.2-2.3-18-6.3-25.6l28-28c8.1 5.7 18 9.1 28.7 9.1 8.5 0 16.5-2.1 23.5-5.9l20 20c-4.5 9.2-7 19.5-7 30.4 0 38.4 31.3 69.6 70 69.6s70-31.1 70-69.6c0-13.5-3.9-26.1-10.5-36.7l39.7-39.7c8 4.3 17.1 6.8 26.9 6.8 30.9 0 56-24.9 56-55.7-0.1-30.7-25.1-55.6-56.1-55.6z m0 0'
              fill='#20DAB4'
              p-id='5077'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const SteamIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M716.8 642.24c-119.936 91.328-227.872 26.112-230.848 22.88-224.864-150.208-374.72 9.632-374.72 9.632-3.776 3.296-9.504 10.72-11.2 17.152-1.696 6.4-4.256 20.8 1.76 30.56 6.048 9.792 27.328 13.568 36.416 7.04 9.12-6.528 125.92-133.664 323.808-3.232 3.008 3.232 50.976 32.608 119.936 32.608 44.96 0 101.92-13.088 158.88-55.488 7.04-8 17.92-28.544 13.696-41.6-4.224-13.056-14.112-20.896-18.24-22.4-4.16-1.6-16.512-0.416-19.488 2.88z m96 128c-119.936 91.328-227.872 26.112-230.848 22.88-224.864-150.208-374.72 9.632-374.72 9.632-3.776 3.296-9.504 10.72-11.2 17.152-1.696 6.4-4.256 20.8 1.76 30.56 6.048 9.792 27.328 13.568 36.416 7.04 9.12-6.528 125.92-133.664 323.808-3.232 3.008 3.232 50.976 32.608 119.936 32.608 44.96 0 101.92-13.088 158.88-55.488 7.04-8 17.92-28.544 13.696-41.6-4.224-13.056-14.112-20.896-18.24-22.4-4.16-1.6-16.512-0.416-19.488 2.88z m-310.24-218.4c0-35.072 28.032-63.52 62.592-63.52s62.592 28.448 62.592 63.52-28.032 63.52-62.592 63.52-62.592-28.448-62.592-63.52z m-53.376-210.816c27.296 0 49.504 22.464 49.504 50.272 0 27.744-22.112 50.24-49.504 50.24a49.888 49.888 0 0 1-49.536-50.24c0.096-27.808 22.112-50.24 49.536-50.24z m-122.976 26.784a18.912 18.912 0 0 0 18.72-19.04 18.912 18.912 0 0 0-18.72-19.008 18.912 18.912 0 0 0-18.752 19.008c0 10.56 8.416 19.04 18.752 19.04z m-75.04 147.52c0-27.328 21.824-49.472 48.736-49.472 26.912 0 48.736 22.144 48.736 49.472 0 27.328-21.824 49.44-48.736 49.44a49.088 49.088 0 0 1-48.736-49.44z m544-96c0-27.328 21.824-49.472 48.736-49.472 26.912 0 48.736 22.144 48.736 49.472 0 27.328-21.824 49.44-48.736 49.44a49.088 49.088 0 0 1-48.736-49.44z m-576-224c0-27.328 21.824-49.472 48.736-49.472 26.912 0 48.736 22.144 48.736 49.472 0 27.328-21.824 49.44-48.736 49.44a49.088 49.088 0 0 1-48.736-49.44z m381.792 96.32c0-31.488 25.184-57.056 56.224-57.056 31.04 0 56.192 25.6 56.192 57.056 0 31.488-25.184 57.056-56.192 57.056-31.04 0-56.224-25.504-56.224-57.056z m160.128 293.76a37.76 37.76 0 0 0 37.472-38.048 37.76 37.76 0 0 0-37.44-38.048 37.76 37.76 0 0 0-37.504 38.048 37.76 37.76 0 0 0 37.472 38.048z m-192-416a37.76 37.76 0 0 0 37.472-38.048 37.76 37.76 0 0 0-37.44-38.048 37.76 37.76 0 0 0-37.504 38.048 37.76 37.76 0 0 0 37.472 38.048zM416.96 268.064a37.76 37.76 0 0 0 37.504-38.016A37.76 37.76 0 0 0 416.96 192a37.76 37.76 0 0 0-37.44 38.048 37.76 37.76 0 0 0 37.44 38.016z m232.512 149.12c0 10.464 8.416 19.008 18.72 19.008a18.912 18.912 0 0 0 18.752-19.008 18.912 18.912 0 0 0-18.752-19.008 18.88 18.88 0 0 0-18.72 19.008z m-480 0c0 10.464 8.416 19.008 18.72 19.008a18.912 18.912 0 0 0 18.752-19.008 18.912 18.912 0 0 0-18.752-19.008 18.88 18.88 0 0 0-18.72 19.008z m232.16 175.712c0 10.496 8.416 19.04 18.72 19.04a18.912 18.912 0 0 0 18.752-19.04 18.912 18.912 0 0 0-18.752-19.008 18.912 18.912 0 0 0-18.72 19.008z'
              fill='#1296db'
              p-id='6430'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const RunningIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M813.3 749.3H216.7c-48.2 0-87.6-39.4-87.6-87.6V268.2c0-48.2 39.4-87.6 87.6-87.6h596.6c48.2 0 87.6 39.4 87.6 87.6v393.5c-0.1 48.1-39.6 87.6-87.6 87.6z'
              fill='#1890ff'
              opacity='.7'
              p-id='7692'
            ></path>
            <path
              d='M499.5 619L300 818.4c-12.8 12.8-3.8 34.9 14.4 34.9h400.9c18.2 0 27.4-22.1 14.3-35L528.3 618.9c-8-7.9-20.9-7.9-28.8 0.1z'
              fill='#1890ff'
              opacity='.7'
              p-id='7693'
            ></path>
            <path
              d='M308.5 594.6c-10.2 0-20.5-3.9-28.3-11.7-15.6-15.6-15.6-40.9 0-56.6l133.2-133.2c15.6-15.6 40.9-15.6 56.6 0l85.8 85.8 137.4-137.4c15.6-15.6 40.9-15.6 56.6 0 15.6 15.6 15.6 40.9 0 56.6L584 563.8c-15.6 15.6-40.9 15.6-56.6 0L441.6 478 336.7 582.9c-7.8 7.8-18 11.7-28.2 11.7z'
              fill='#1890ff'
              p-id='7694'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const CancelIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M646.2 648.2c-9 9-21.3 13.8-33.7 13.8-12.3 0-24.7-4.7-33.7-13.8l-65.4-65.4c-0.8-0.8-2-0.8-2.8 0l-65.4 65.4c-18.5 18.5-48.8 18.5-67.3 0s-18.5-48.8 0-67.3l65.4-65.4c0.8-0.8 0.8-2 0-2.8l-65.4-65.4c-18.5-18.5-18.5-48.8 0-67.3s48.8-18.5 67.3 0l65.4 65.4c0.8 0.8 2 0.8 2.8 0l65.4-65.4c18.5-18.5 48.8-18.5 67.3 0 9 9 13.8 21.3 13.8 33.7 0 12.3-4.8 24.6-13.8 33.7l-65.4 65.4c-0.8 0.8-0.8 2 0 2.8l65.4 65.4c18.6 18.4 18.6 48.7 0.1 67.2z'
              fill='#faad14'
              p-id='17826'
            ></path>
            <path
              d='M512 87.4c-235.6 0-426.7 191-426.7 426.7 0 235.6 191 426.7 426.7 426.7s426.7-191 426.7-426.7S747.7 87.4 512 87.4z m165.3 591.9c-16.9 16.9-40.5 26.7-64.8 26.7-24.2 0-47.8-9.7-64.8-26.6L512 643.6l-35.7 35.7C459 696.5 436 706 411.5 706s-47.5-9.5-64.8-26.8c-35.7-35.7-35.7-93.8 0-129.5l35.7-35.7-35.7-35.7c-35.7-35.7-35.7-93.8 0-129.5C364 331.5 387 322 411.5 322s47.5 9.5 64.8 26.8l35.7 35.7 35.7-35.7C565 331.5 588 322 612.5 322s47.5 9.5 64.8 26.8c16.9 16.9 26.6 40.5 26.6 64.8s-9.7 47.8-26.6 64.8L641.5 514l35.7 35.7c35.8 35.8 35.8 93.9 0.1 129.6z'
              fill='#faad14'
              p-id='17827'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ErrorIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M800.3 205.1L534.8 116c-16-5.4-33.3-5.3-49.2 0.2l-264.5 92.3c-29.3 10-49 37.5-49.1 68.4l1.7 265.4c0.7 81 31.1 158.9 85.6 218.9 25 27.7 56.9 51.5 97.8 72.7l144 74.6c9 4.7 19.7 4.6 28.7-0.2L672.5 832c40.4-21.6 72.2-45.7 96.9-73.8 53.6-60.6 83-138.9 82.6-219.8l-1.7-265.6c-0.5-30.9-20.5-58.1-50-67.7z'
              fill='#FA5151'
              p-id='22708'
            ></path>
            <path
              d='M549.8 512l94.4-94.4c10.4-10.4 10.4-27.4 0-37.8-10.4-10.4-27.4-10.4-37.8 0L512 474.2l-94.4-94.4c-10.4-10.4-27.4-10.4-37.8 0s-10.4 27.4 0 37.8l94.4 94.4-94.4 94.4c-10.4 10.4-10.4 27.4 0 37.8 5.2 5.2 12 7.8 18.9 7.8s13.7-2.6 18.9-7.8l94.5-94.4 94.4 94.4c5.2 5.2 12 7.8 18.9 7.8s13.7-2.6 18.9-7.8c10.4-10.4 10.4-27.4 0-37.8L549.8 512z'
              fill='#FFFFFF'
              p-id='22709'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const RestartIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M465.408 828.586667l-18.773333 126.72a451.669333 451.669333 0 0 0 119.978666 1.365333l-15.530666-127.061333a323.242667 323.242667 0 0 1-85.674667-1.024z m143.36-11.52l38.826667 122.026666c38.656-12.202667 75.093333-29.610667 108.373333-51.285333l-69.717333-107.349333a318.549333 318.549333 0 0 1-77.397334 36.693333zM512 64a448 448 0 0 0-145.92 871.68l41.813333-121.002667A320.170667 320.170667 0 0 1 512 192c96.512 0 183.04 42.666667 241.749333 110.250667L667.306667 388.693333a16.042667 16.042667 0 0 0 11.349333 27.306667h265.386667a16.042667 16.042667 0 0 0 15.957333-16.042667v-265.386666a16.042667 16.042667 0 0 0-27.306667-11.264L844.373333 211.626667l-4.522666-4.864A446.805333 446.805333 0 0 0 512 64z m275.370667 611.072a321.365333 321.365333 0 0 1-54.613334 68.608l88.32 92.672c29.696-28.330667 55.466667-60.586667 76.458667-96.085333l-110.08-65.194667z m-323.413334-387.072a16.042667 16.042667 0 0 0-15.957333 16.042667v239.957333a63.914667 63.914667 0 0 0 32.085333 55.808L632.490667 687.786667c7.68 4.437333 17.408 1.792 21.845333-5.802667l48.042667-83.2a15.957333 15.957333 0 0 0-5.973334-21.845333L576 507.392V304.042667a16.042667 16.042667 0 0 0-16.042667-16.042667z'
              fill='#707070'
              p-id='28926'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const UnknownIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M524.054 731.32c0-108.306 69.937-200.084 167.027-233.194L441.038 66.62 37.452 763.082h486.602v-31.763z m-46.562-73.872H400.71v-74.223h76.782v74.223zM458.49 552.684h-38.267L398.921 376.16v-95.951h80.374v95.951L458.49 552.684z m541.064 232.519l0.207-81.39s-53.749-10.667-54.64-14.26c-5.599-21.823-13.284-40.931-23.094-58.705 26.118 35.31 56.401 9.667 56.401 9.667l-60.585-80.665s-39.27 32.311-49.037 36.972c-4.557-1.771-9.289-3.365-14.353-4.858-5.293-1.295-19.853-53.055-19.853-53.055l-81.617-0.673s-8.761 50.135-21.997 53.541c-11.927 3.607-22.31 8.956-31.469 15.842 8.434-15.595-30.804-48.445-30.804-48.445l-60.617 82.022s30.416 30.623 32.426 40.855a182.397 182.397 0 0 0-3.646 9.849c-13.028 4.516-50.114 11.909-50.114 11.909l0.176 81.39s43.145 8.978 51.337 16.187a161.202 161.202 0 0 0 5.758 13.732c-9.963 12.438-36.547 33.182-36.547 33.182l62.511 81.339s49.078-31.743 57.156-33.554c3.987 1.719 8.058 3.356 12.24 4.805 7.394 2.589 12.635 49.979 12.635 49.979l81.442 0.187s2.775-46.53 8.709-48.353a172.006 172.006 0 0 0 17.326-6.483c6.866 2.682 39.024 34.755 39.024 34.755l80.521-82.001s-29.888-20.661-38.122-31.793a180.659 180.659 0 0 0 6.099-14.219c2.785-7.385 52.527-17.762 52.527-17.762z m-207.219 61.661h-0.02c-56.745 0-102.745-46-102.745-102.745v-0.012-0.032c0-56.739 45.997-102.735 102.735-102.735h0.033c56.741 0 102.734 46.002 102.734 102.765 0 56.742-46.034 102.756-102.735 102.756z'
              fill='#8c8c8c'
              p-id='24881'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
export const FinishIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg viewBox='0 0 1024 1024' width={size} height={size}>
            <path
              d='M694.1184 935.8848H236.6464c-73.5232 0-133.12-59.5968-133.12-133.12V217.4976c0-73.5232 59.5968-133.12 133.12-133.12h457.472c73.5232 0 133.12 59.5968 133.12 133.12v585.2672c0 73.5232-59.5968 133.12-133.12 133.12z'
              fill='#4BE2AC'
              p-id='34154'
            ></path>
            <path
              d='M629.3504 326.0416h-325.12c-22.6304 0-40.96-18.3296-40.96-40.96s18.3296-40.96 40.96-40.96h325.12c22.6304 0 40.96 18.3296 40.96 40.96s-18.3296 40.96-40.96 40.96zM629.3504 488.448h-325.12c-22.6304 0-40.96-18.3296-40.96-40.96s18.3296-40.96 40.96-40.96h325.12c22.6304 0 40.96 18.3296 40.96 40.96s-18.3296 40.96-40.96 40.96zM459.9296 650.8544H304.2304c-22.6304 0-40.96-18.3296-40.96-40.96s18.3296-40.96 40.96-40.96h155.6992c22.6304 0 40.96 18.3296 40.96 40.96s-18.3808 40.96-40.96 40.96z'
              fill='#FFFFFF'
              p-id='34155'
            ></path>
            <path
              d='M739.84 742.5024m-189.952 0a189.952 189.952 0 1 0 379.904 0 189.952 189.952 0 1 0-379.904 0Z'
              fill='#4BE2AC'
              p-id='34156'
            ></path>
            <path
              d='M740.096 552.8064c-104.9088 0-189.952 85.0432-189.952 189.952 0 99.9936 77.2608 181.8624 175.36 189.3376 58.368-14.08 101.7856-66.6624 101.7856-129.3824V573.952a189.9008 189.9008 0 0 0-87.1936-21.1456z'
              fill='#06CC76'
              p-id='34157'
            ></path>
            <path
              d='M706.5088 848.9472h-0.7168c-9.728-0.2048-18.9952-4.352-25.6-11.52l-64.8192-70.2464a35.84 35.84 0 0 1 2.048-50.6368 35.84 35.84 0 0 1 50.6368 2.048l39.5264 42.8032 92.8256-92.8256c13.9776-13.9776 36.7104-13.9776 50.688 0s13.9776 36.7104 0 50.688l-119.1936 119.1936a36.1472 36.1472 0 0 1-25.3952 10.496z'
              fill='#FFFFFF'
              p-id='34158'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
