/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

const defaultSvgSize = '100%';

// const style = {overflow: "hidden",width: "100%",height: "100%"};
const style = { overflow: 'hidden' };

export const MysqlIcons = (props: any) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M987.428571 555.885714l-7.314285-7.314285c-7.314286-14.628571-14.628571-21.942857-29.257143-29.257143-7.314286-7.314286-29.257143-14.628571-29.257143-21.942857h51.2c0-7.314286-7.314286-14.628571-14.628571-14.628572-14.628571-14.628571-29.257143-21.942857-43.885715-36.571428-7.314286-7.314286-14.628571-7.314286-29.257143-14.628572 0 0-7.314286 0-7.314285-7.314286s-7.314286-14.628571-7.314286-21.942857c7.314286-36.571429-7.314286-58.514286-14.628571-73.142857 0-14.628571-7.314286-21.942857-14.628572-36.571428-29.257143-51.2-51.2-80.457143-95.085714-109.714286-7.314286-7.314286-14.628571-7.314286-29.257143-7.314286h-21.942857s-7.314286-7.314286-14.628572-7.314286c-14.628571-7.314286-51.2-36.571429-65.828571 0 0 7.314286 14.628571 29.257143 21.942857 36.571429 0 7.314286 7.314286 14.628571 14.628572 21.942857v14.628572c7.314286 14.628571 7.314286 29.257143 14.628571 43.885714l7.314286 14.628571 7.314285 7.314286c0 7.314286 0 14.628571-7.314285 21.942857-7.314286 36.571429 0 73.142857 7.314285 102.4 0 7.314286 14.628571 21.942857 29.257143 14.628572 14.628571-7.314286 7.314286-21.942857 14.628572-36.571429v-7.314286c7.314286 7.314286 7.314286 14.628571 7.314285 21.942857 7.314286 14.628571 21.942857 29.257143 36.571429 36.571429l14.628571 14.628571-7.314285-7.314285c-7.314286-7.314286-7.314286-14.628571-14.628572-14.628572-14.628571-14.628571-21.942857-36.571429-29.257143-51.2 0-7.314286-7.314286-14.628571-14.628571-29.257143V365.714286c0 7.314286-7.314286 14.628571-14.628571 14.628571 7.314286 21.942857 7.314286 36.571429 7.314285 51.2-7.314286 0-14.628571-14.628571-14.628571-21.942857-7.314286-21.942857-7.314286-51.2 0-80.457143 0-7.314286 7.314286-21.942857 7.314286-29.257143-7.314286-7.314286-14.628571-7.314286-14.628572-14.628571l-14.628571-14.628572c0-14.628571-7.314286-36.571429-14.628572-51.2 0-7.314286-7.314286-14.628571-14.628571-21.942857 0-7.314286-7.314286-14.628571-7.314286-21.942857v-14.628571h14.628572c7.314286 0 14.628571 7.314286 21.942857 14.628571 0 0 7.314286 7.314286 14.628571 7.314286h29.257143c14.628571 7.314286 21.942857 14.628571 36.571429 21.942857 36.571429 21.942857 58.514286 58.514286 80.457142 102.4 0 7.314286 0 14.628571 7.314286 21.942857 7.314286 14.628571 14.628571 29.257143 14.628572 43.885714 7.314286 14.628571 7.314286 29.257143 14.628571 36.571429 0 7.314286 14.628571 7.314286 29.257143 14.628571l21.942857 14.628572c7.314286 7.314286 14.628571 14.628571 21.942857 14.628571 0 0 14.628571 7.314286 14.628572 14.628572-21.942857 0-36.571429 0-51.2 7.314285h-14.628572v7.314286c0 7.314286 7.314286 14.628571 14.628572 14.628572 7.314286 7.314286 14.628571 7.314286 14.628571 14.628571 7.314286 7.314286 21.942857 14.628571 29.257143 14.628571 21.942857 14.628571 29.257143 21.942857 36.571428 29.257143z'
              fill='#02608A'
            ></path>
            <path
              d='M702.171429 212.114286h-7.314286l14.628571 21.942857s7.314286-7.314286 7.314286-14.628572c-7.314286 7.314286-7.314286 0-14.628571-7.314285zM212.114286 548.571429l-51.2 190.171428-58.514286-190.171428H51.2C43.885714 629.028571 36.571429 716.8 29.257143 811.885714H73.142857c0-73.142857 0-131.657143 7.314286-197.485714l51.2 197.485714h36.571428L219.428571 614.4c7.314286 73.142857 7.314286 131.657143 7.314286 197.485714h43.885714c0-80.457143-14.628571-160.914286-21.942857-263.314285h-36.571428z m182.857143 65.828571c-7.314286 58.514286-7.314286 109.714286-29.257143 160.914286 0-14.628571 0-14.628571-7.314286-43.885715l-29.257143-117.028571h-43.885714l43.885714 146.285714c7.314286 21.942857 7.314286 36.571429 7.314286 43.885715v14.628571c-7.314286 7.314286-14.628571 7.314286-29.257143 7.314286H292.571429v36.571428c0 14.628571 14.628571 14.628571 21.942857 14.628572 21.942857 0 43.885714-14.628571 65.828571-51.2 21.942857-43.885714 43.885714-109.714286 58.514286-212.114286h-43.885714z'
              fill='#02608A'
            ></path>
            <path
              d='M928.914286 768v-219.428571h-43.885715V804.571429h109.714286v-36.571429h-65.828571z m-117.028572 21.942857s7.314286-7.314286 7.314286-14.628571c14.628571-21.942857 29.257143-58.514286 29.257143-109.714286 0-87.771429-29.257143-124.342857-87.771429-124.342857-29.257143 0-51.2 14.628571-65.828571 36.571428-21.942857 21.942857-29.257143 58.514286-29.257143 102.4 0 43.885714 7.314286 80.457143 21.942857 102.4 14.628571 14.628571 36.571429 29.257143 65.828572 29.257143h29.257142l51.2 36.571429 14.628572-29.257143-36.571429-29.257143z m-51.2-21.942857c-14.628571 0-29.257143-7.314286-36.571428-21.942857-7.314286-14.628571-14.628571-36.571429-14.628572-73.142857 0-58.514286 14.628571-87.771429 43.885715-87.771429 14.628571 0 29.257143 7.314286 36.571428 21.942857 14.628571 21.942857 14.628571 36.571429 14.628572 73.142857 0 58.514286-14.628571 87.771429-43.885715 87.771429zM621.714286 680.228571S585.142857 658.285714 570.514286 650.971429c-14.628571-14.628571-21.942857-21.942857-21.942857-36.571429 0-7.314286 7.314286-14.628571 14.628571-21.942857 0-14.628571 7.314286-14.628571 21.942857-14.628572 14.628571 0 29.257143 7.314286 43.885714 14.628572l7.314286-36.571429c-14.628571-7.314286-36.571429-14.628571-58.514286-14.628571-21.942857 0-36.571429 7.314286-51.2 14.628571-14.628571 14.628571-21.942857 36.571429-21.942857 58.514286 0 29.257143 7.314286 43.885714 21.942857 58.514286 0 0 29.257143 21.942857 51.2 29.257143 14.628571 14.628571 29.257143 21.942857 29.257143 36.571428s0 21.942857-14.628571 29.257143c-7.314286 7.314286-14.628571 0-29.257143 0s-29.257143-7.314286-51.2-14.628571v36.571428c21.942857 14.628571 43.885714 21.942857 65.828571 21.942857 21.942857 0 43.885714-7.314286 58.514286-21.942857 14.628571-14.628571 21.942857-36.571429 21.942857-51.2-7.314286-29.257143-14.628571-43.885714-36.571428-58.514286z'
              fill='#E58E01'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const SQLIcons = (props: any) => {
  const { size = 16 } = props;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M841.14 36.57H182.86A146.29 146.29 0 0 0 36.57 182.86v658.28a146.29 146.29 0 0 0 146.29 146.29h658.28a146.29 146.29 0 0 0 146.29-146.29V182.86A146.29 146.29 0 0 0 841.14 36.57zM249.42 658.29a146.29 146.29 0 0 1-105.33-43.52l27.43-32.18a114.83 114.83 0 0 0 79 36.57c36.57 0 56-16.82 56-41.69s-20.11-36.57-47.54-47.54l-39.5-20.11a85.21 85.21 0 0 1-62.17-77.9 88.14 88.14 0 0 1 93.86-82q2.45 0.16 4.89 0.47a126.9 126.9 0 0 1 89.6 36.57l-24.5 29.62a94.35 94.35 0 0 0-65.1-25.6c-30.35 0-49.74 14.63-49.74 36.57s23.77 36.57 47.91 44.62l38.4 19a82.65 82.65 0 0 1 60.34 80.09c0.68 47.53-38.82 87.03-103.55 87.03z m365.71 73.14a119.59 119.59 0 0 1-115.2-73.14c-64-11-106.79-67.29-106.79-152.87 0-95.45 52.66-152.5 128.73-152.5S651 410 651 505.42c0 83.38-40.59 139-101.3 151.77a75.7 75.7 0 0 0 70.58 36.57 109.71 109.71 0 0 0 31.45-4.39l8.78 36.57a117.39 117.39 0 0 1-45.35 2.93z m269.53-76.8H712.78V355.84h46.81v256h125.07z'
              fill='#FF5C5C'
            ></path>
            <path
              d='M603.43 502.86c0-69.49-32.18-111.91-81.19-111.91s-80.82 42.42-80.82 111.91 31.82 116.3 80.82 116.3 81.19-44.62 81.19-116.3z'
              fill='#FF5C5C'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const OracleIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 8165 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M3398.499037 666.115306h520.24153l-274.800972-442.904953-504.499351 800.60224-229.885787 0.187407 614.069914-961.397353A143.303803 143.303803 0 0 1 3643.564782 0.008746c48.350978 0 92.703942 22.801172 118.878438 60.907239l616.193859 963.084015-230.073194-0.187407-107.883901-178.973581h-527.175585l-114.942893-178.723706z m2386.751699 178.911113V10.00378h-195.090574v916.669574c0 25.362399 10.307379 49.600357 28.423379 67.716357 19.115503 18.928096 44.352964 29.360413 71.464494 29.360413h888.995824l114.693017-178.661236H5785.250736z m-3225.2726-149.425762a342.829673 342.829673 0 0 0 0-685.596877H1706.777029v1013.808813h194.903167V188.665016h644.867113a163.856092 163.856092 0 0 1 164.043499 164.105968 163.98103 163.98103 0 0 1-164.043499 164.168437l-549.414537-0.187407 581.77346 507.060579h283.234282l-391.430527-328.399343 89.268149 0.187407zM506.935641 1023.812593a506.873172 506.873172 0 1 1 0-1013.808813h589.269735a506.935641 506.935641 0 0 1 506.873173 506.935641 506.935641 506.935641 0 0 1-506.873173 507.060579l-589.269735-0.187407z m576.151253-178.661236a328.086998 328.086998 0 0 0 328.149467-328.211936 328.086998 328.086998 0 0 0-328.149467-328.211936H519.991655a328.274405 328.274405 0 0 0 0 656.423872h563.095239z m3702.285608 178.661236a506.935641 506.935641 0 1 1 0-1013.808813h700.277084l-114.755487 178.723705h-572.340646a328.274405 328.274405 0 1 0 0 656.423872h702.838312l-114.505611 178.661236h-601.576121z m2384.752692-178.661236a328.086998 328.086998 0 0 1-315.593205-238.506504h833.335977l114.755486-178.723705-948.341339-0.062469a328.211936 328.211936 0 0 1 315.843081-239.193663l572.028302 0.062469 114.942893-178.723705h-700.277084a506.935641 506.935641 0 0 0 0 1013.808813h601.576121l114.505611-178.661236h-702.775843zM7961.482027 117.950149a89.455556 89.455556 0 1 1 179.036051 0 89.455556 89.455556 0 1 1-179.036051 0z m89.580494 114.318204l0 0z m-10.744661-181.597278c17.553779 0 24.800179 0.187407 33.420895 3.435793 22.488827 7.558745 24.800179 28.235972 24.800179 35.794717a49.975171 49.975171 0 0 1-1.374317 10.494785 34.795213 34.795213 0 0 1-15.867117 21.926607c-1.311848 0.999503-2.061476 1.624193-5.747145 2.99851l29.672758 53.098619h-28.673254l-25.987089-48.850729h-17.303903v48.78826h-24.987586V50.671075h32.046579z m8.933061 57.721323c7.683683-0.124938 16.241931-0.687159 21.239448-7.996028a18.990565 18.990565 0 0 0 2.873572-10.932068 16.86662 16.86662 0 0 0-9.62022-15.492303c-5.747145-2.248883-11.619227-2.248883-23.425861-2.248883h-7.058993v36.669282h15.992054z'
              fill='#FF0000'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const PostgresqlIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M986.064 614.272c-3.6-23.344-23.208-38.632-46.016-39.664-8.256-0.376-16.64 0.488-24.872 1.536-9.944 1.264-19.768 3.504-29.688 4.984-6.856 1.024-13.808 1.496-20.656 2.2l-0.168-0.888c12.784-24.144 26.104-48.024 38.2-72.512 9.272-18.784 17.208-38.248 25.408-57.552 13.568-31.984 24.408-64.96 33.384-98.472 8.6-32.088 15.96-64.528 18.272-97.816 0.928-13.296 1.568-26.648 1.496-39.96-0.064-10.616-1.208-21.248-2.272-31.832-1.2-12.128-4.864-23.624-9.936-34.688-6.688-14.576-17.056-26.536-27.968-37.896-8.736-9.096-18.344-17.384-27.872-25.664-13.584-11.816-28.856-21.248-44.72-29.624a257.44 257.44 0 0 0-56.72-22c-11.944-3.048-24.16-5.312-36.256-7.728-4.352-0.88-8.712-2.696-13.064-2.696H680.688c-2.96 0-5.896 1.528-8.88 1.864-19.616 2.184-39 5.88-57.824 11.712-7.04 2.184-13.472 0.808-20.16 0.192-5.128-0.472-10.168-1.848-15.296-2.104-19.536-0.976-39.096-2.408-58.624-2.2-18.712 0.192-37.232 3.272-55.344 8.416-15.16 4.304-29.992 9.56-43.576 17.528-5.816 3.408-10.424 2.768-16.44 1.032-20.216-5.832-40.576-11.312-61.112-15.912-12.8-2.864-25.96-4.288-39.032-5.656a457.712 457.712 0 0 0-37.744-2.352c-12.304-0.264-24.696-0.256-36.944 0.832a241.28 241.28 0 0 0-57.264 12.104 190.504 190.504 0 0 0-56.688 30.92c-17.336 13.72-31.24 30.472-42.424 49.6-11.784 20.184-19.864 41.792-24.888 64.488-2.72 12.296-4.44 24.936-6.304 37.424-0.584 3.888 5.856 7.776-2.144 11.648v54.352c8 3.616 1.664 7.224 2.128 10.848 1.112 8.712 2.096 17.496 3.568 26.144 2.328 13.688 5.088 27.336 7.904 40.936a2598.88 2598.88 0 0 0 12.368 56.888c3.168 13.76 6.776 27.44 10.552 41.048 5.768 20.784 11.448 41.608 17.968 62.16 6.056 19.096 12.992 37.92 19.872 56.744 9.528 26.04 20.936 51.24 34.616 75.392 11.832 20.912 25.352 40.496 43.488 56.608 11.952 10.616 25.256 18.776 40.744 22.856 12.168 3.2 24.536 3.584 36.992 1.032a87.832 87.832 0 0 0 38.592-18.488c1.304-1.072 2.736-1.888 4.28 0.08 5.88 7.448 13.752 12.416 21.984 16.712 22.216 11.584 46.424 15.056 71.016 16.472 5.952 0.344 11.968-0.512 17.968-0.68 11.688-0.32 23.048-2.6 34.224-5.832 5.856-1.696 11.576-3.848 17.536-5.856 0.312 6.344 0.712 12.456 0.896 18.568l0.832 33.328c0.152 5.072 0.352 10.16 0.824 15.208 1.208 13.016 2.392 26.04 3.944 39.016 1.08 8.944 2.2 17.96 4.304 26.688a305.408 305.408 0 0 0 17.264 51.424 110.48 110.48 0 0 0 31.2 41.48c17.76 14.688 38.576 20.952 61.056 22.112 9.296 0.488 18.856 0.032 28.008-1.632a392.08 392.08 0 0 0 43.096-10.2c28.728-8.672 53.56-23.648 72.112-47.848 10.56-13.792 19.232-28.712 24.8-45.184 4.592-13.608 8.92-27.352 12.36-41.28 2.72-10.976 4.064-22.296 5.72-33.504 1.096-7.416 1.752-14.904 2.44-22.376 1.12-12.136 2.264-24.264 3.072-36.424 0.56-8.464 0.536-16.968 0.872-25.448 0.104-2.584 0.52-5.152 0.76-7.728 0.224-2.384 1.424-3.208 3.856-3.168 8.568 0.128 17.152 0.352 25.696-0.032 9.576-0.432 19.24-0.84 28.664-2.424a452.336 452.336 0 0 0 39.92-8.536c15.544-4.064 29.8-11.344 43.52-19.64 15.984-9.656 30.552-20.984 42.376-35.576 10.28-12.728 15.152-27.44 12.672-43.504z m-27.296 7.856c-0.528 7.32-3.88 13.592-8.744 18.952-22.952 25.304-51.744 40.656-84.68 48.216-12.512 2.864-25.424 4.352-38.232 5.536a256.744 256.744 0 0 1-32.912 0.776c-8.048-0.304-16.032-2.144-24.256-3.328-0.824 7.52-1.608 15.352-2.56 23.168l-3.832 29.96c-1.16 9.496-2.064 19.024-3.256 28.512-1.168 9.208-2.624 18.384-3.848 27.592-1.144 8.576-1.984 17.192-3.256 25.752-1.96 13.12-3.832 26.272-6.392 39.288-3.072 15.56-7.784 30.632-15.472 44.664-9.376 17.128-22.672 30.176-39.592 39.84-17.44 9.968-36.504 15.152-55.832 19.488-13.68 3.072-27.776 3.576-41.632 2.328-24.032-2.176-44.544-12.456-60.048-31.088-14.8-17.784-24.816-38.168-28.4-61.24a504.816 504.816 0 0 1-3.928-33.088 864.536 864.536 0 0 1-2.392-36.96 2001.624 2001.624 0 0 1-1.576-46.968c-0.424-19.248-0.56-38.496-0.832-57.744l-0.048-0.736c-9.792 5.872-19.416 12.304-29.624 17.6a99.136 99.136 0 0 1-38.384 10.824c-10.544 0.8-21.224 1.528-31.72 0.688-17.208-1.384-34.4-4.08-49.808-12.552-6.248-3.44-12.768-7.624-17.072-13.12-10.32-13.168-5.376-29.808 10.184-37.816 10.752-5.544 22.488-7.856 34.144-10.552a354.944 354.944 0 0 0 30.088-8.232c9.776-3.2 15.944-11.128 22.032-18.904l9.648-12.408c-4.024-0.424-7.816-0.856-11.608-1.208-11.512-1.088-22.496-4.256-33-8.912-8.992-3.976-9.128-4.408-15.72 2.744-11.008 11.952-21.712 24.184-32.496 36.336-7.936 8.936-15.824 17.928-23.72 26.888-7.824 8.864-15.152 18.232-23.576 26.48-12.512 12.248-27.592 19.616-45.584 18.784-11.544-0.528-22.112-4.576-31.616-11.192-19.616-13.664-32.832-32.776-44.864-52.848-15.416-25.72-27.248-53.12-37.376-81.272-7.008-19.456-14.048-38.928-20.168-58.664-6.648-21.448-12.48-43.168-18.216-64.88a1258.984 1258.984 0 0 1-11.856-49.456 1728.936 1728.936 0 0 1-11.712-56.632c-2.384-12.792-3.768-25.768-5.696-38.648-2.6-17.36-3.08-34.88-2.136-52.312 0.84-15.704 3.096-31.368 5.336-46.968 3.104-21.584 10.216-41.952 20.448-61.184 6.264-11.784 14.04-22.496 23.032-32.448 14.76-16.336 32.624-28.144 52.496-37.008 13.888-6.192 28.56-9.92 43.512-12.832 22.192-4.32 44.584-4.152 66.984-3.688 9.792 0.2 19.544 1.984 29.328 2.952 21.064 2.096 41.712 6.528 62.096 12 14.856 3.984 29.408 9.144 44.144 13.624 1.48 0.448 3.648 0.408 4.856-0.384 19.968-13.032 41.792-21.632 65-26.552 8.808-1.864 17.896-2.68 26.904-3.256 10.952-0.696 21.992-1.336 32.92-0.704 13.136 0.752 26.208 2.688 39.264 4.48 6.336 0.864 12.52 3.064 18.872 3.664 3.04 0.288 6.264-1.936 9.48-2.68 16.392-3.784 32.712-8 49.248-10.992 12.312-2.224 24.888-3.272 37.408-3.992 13.96-0.8 28.024-1.384 41.976-0.712a293.28 293.28 0 0 1 52.44 7.384c21.416 4.984 41.96 12.224 61.488 22.272 14.592 7.504 28.464 16.208 40.952 26.912 8.184 7.024 16.56 13.96 23.952 21.784 9.12 9.648 18.424 19.304 24.144 31.664 4.304 9.32 7.376 18.968 8.224 29.176 1.056 12.688 2.336 25.424 2.216 38.128-0.112 12.152-1.768 24.296-2.944 36.416-2.672 27.632-8.68 54.664-15.976 81.336a935.776 935.776 0 0 1-20.712 65.36c-7.032 19.848-15.144 39.336-23.344 58.744a640.56 640.56 0 0 1-19.664 42.424c-13.416 26.288-27.368 52.304-43.504 77.064-2.784 4.28-5.424 8.664-8.144 13.032 7.04 4.752 15.016 6.424 23.048 7.288 7.64 0.832 15.432 1.328 23.064 0.76 12.216-0.904 24.392-2.648 36.536-4.352 12.032-1.68 23.824-5.104 36.176-4.2 12.336 0.896 21.16 10.272 20.32 21.832z m-176.104-26.824c-5.24-6.768-10.584-13.456-15.712-20.304-8.048-10.752-13.832-22.76-19.64-34.824-5.504-11.432-12.256-22.256-18.056-33.56-10.12-19.72-20.424-39.376-29.744-59.48-11.72-25.256-20.96-51.408-23.872-79.384-1.232-11.84-1.544-23.664 0.848-35.392 3.832-18.728 13.616-33.376 30.064-43.424 15.256-9.32 32.256-12.328 49.672-13.272 10.808-0.584 21.664-0.104 32.88-0.104l-0.376-1.896c-6.976-14.584-13.496-29.416-21.128-43.656-10.768-20.096-24.544-38.216-39.888-55.016-11.368-12.44-23.68-23.984-37.168-34.184-13.264-10.04-27.24-19.008-42.152-26.344-17.784-8.744-36.304-15.504-55.736-19.816-18.672-4.144-37.464-6.68-56.616-6.888-16.336-0.176-32.568 0.56-48.48 4.248-24.016 5.56-45.984 15.448-65.096 31.464a169.144 169.144 0 0 0-28.136 30.16c-9.568 13.144-17.288 27.336-23.888 42.216-9.056 20.416-15.272 41.664-19.52 63.504-2.128 10.888-3.792 21.872-5.488 32.848-0.592 3.84-0.64 7.768-0.984 12.168 2.952-1.536 5.08-2.72 7.256-3.776l7.08-3.176c23.944-10.952 48.752-18 75.416-17.192 11.328 0.344 22.168 2.584 32.24 7.544 19.32 9.528 30.624 25.728 35.536 46.232 3.392 14.152 5.712 28.584 7.968 42.976 1.768 11.24 3.576 22.6 3.784 33.936 0.296 16.568-0.544 33.168-1.448 49.728a139.088 139.088 0 0 1-8.64 41.168c-8.96 23.944-18.944 47.496-28.272 71.304-3.08 7.864-5.448 16.008-8.36 24.656 4.496 0 8.144-0.032 11.792 0.016 1.424 0.024 2.88 0.064 4.256 0.392 10.72 2.528 20.016 7.384 27.64 15.632 10.168 10.976 15.504 23.784 15.776 38.608 0.152 8.216-0.712 16.456-0.672 24.672 0.168 38.288 0.456 76.576 0.776 114.856 0.056 6.256 0.368 12.52 0.816 18.768 0.936 13.08 1.88 26.168 3.16 39.216 0.896 9.256 2.144 18.496 3.608 27.688 2.072 13.024 8 24.616 14.728 35.696 5.792 9.528 13.32 17.624 23.24 23.208 16.856 9.488 35.008 10.28 53.304 6.784 12.36-2.36 24.496-6.152 36.496-10.064a81.024 81.024 0 0 0 31.496-18.832c8.408-8.152 14.376-18.088 18.4-29.056 7.808-21.272 10.24-43.672 13.472-65.896 1.208-8.32 2.256-16.664 3.36-25 1.256-9.488 2.528-18.968 3.744-28.448 0.896-7.064 1.712-14.144 2.576-21.208 1.232-10.144 2.536-20.28 3.712-30.432 0.904-7.848 1.672-15.728 2.472-23.592 1.032-10.048 2.144-20.096 3.032-30.16 0.688-7.64 0.408-15.416 1.76-22.912 2.488-13.744 8.984-25.44 21.168-33 5.096-3.16 10.848-5.24 16.504-7.912l-0.96-1.488z m-460.776-56.416a140.208 140.208 0 0 1-10.832-44.976c-1.024-14.6 0.712-29.144 2.208-43.68 1.456-14.08 2.664-28.224 3.088-42.368 0.704-23.248-0.864-46.464-1.976-69.696-0.672-13.832 0.936-27.832 2.168-41.696 1.112-12.488 2.496-25.008 4.856-37.312 3.96-20.648 9.216-41 16.688-60.728 7.096-18.704 15.248-36.92 26.76-53.32 7.888-11.248 16.84-21.76 25.44-32.752l-2.552-0.904c-27.984-8.888-56.424-15.832-85.672-18.864-13.832-1.432-27.712-2.272-41.584-3.096-4.256-0.256-8.576 0.32-12.848 0.728-10.576 1.008-21.28 1.408-31.688 3.392-17.712 3.368-34.704 9.032-50.44 18.256-14.128 8.28-25.992 18.984-35.928 31.824-10.976 14.176-18.36 30.208-23.664 47.304-6.264 20.168-9.248 40.92-10.056 61.864-0.704 18.36-1.056 36.824 2.112 55.112 2.36 13.616 3.936 27.376 6.536 40.936 3.544 18.488 7.344 36.936 11.736 55.232 6.28 26.192 12.552 52.424 19.992 78.296 7.12 24.792 15.152 49.36 23.856 73.632 7.12 19.808 15.352 39.248 24.024 58.432 5.648 12.496 12.488 24.52 19.656 36.224 7.624 12.424 16.296 24.216 28.064 33.232 14.848 11.384 26.344 13.152 41.432 0.664 6.464-5.352 11.928-11.96 17.552-18.256 8.936-10 17.56-20.272 26.456-30.304 11.328-12.784 22.8-25.432 34.184-38.152 2.408-2.688 4.72-5.456 7.064-8.176l-3.872-3.4a141.56 141.56 0 0 1-32.76-47.448z m429.504-380.552a491.904 491.904 0 0 1 26.472 33.632c16 22.472 28.784 46.736 38.2 72.696 4.168 11.44 7.496 22.992 6.008 35.512-1.032 8.768-0.944 17.664-1.72 26.48-0.648 7.336-1.808 14.632-2.76 21.944-1.424 11.024-3.488 22.016-4.104 33.088-0.584 10.536 0.024 21.184 0.688 31.744 0.672 10.728 2.12 21.408 3.104 32.12 1.112 12.144 2.608 24.288 2.952 36.456 0.28 9.992-0.608 20.048-1.48 30.024-1.04 12.016-4.088 23.648-8.632 34.808-3.192 7.856-7.008 15.472-10.616 23.336l1.448 1.536 2.2 1.704 2.216-3.968a748.968 748.968 0 0 0 49.776-91.944 1490.664 1490.664 0 0 0 26.296-62.128c12.992-32.512 23.272-65.936 31.224-100.024 3.568-15.304 6.296-30.84 8.72-46.376 1.888-12.144 3.464-24.432 3.816-36.688 0.376-13-0.344-26.104-1.544-39.072-0.896-9.792-3.312-19.648-9.448-27.608-9.864-12.816-20.512-25.072-33.608-34.768-11.024-8.168-22.008-16.544-33.84-23.416-18.76-10.88-39.064-18.128-60.28-23.064-20.704-4.824-41.68-6.904-62.792-7.344-12.448-0.264-24.952 1.072-37.376 2.24-11.256 1.056-22.44 2.856-33.776 4.344 12.16 6.84 24.152 12.92 35.464 20.088 23.784 15.064 45.096 33.192 63.392 54.648zM442.392 580.112c7.688-24.584 18.16-48.056 28.304-71.672 8.224-19.152 12.72-39.328 14.216-60.048 0.744-10.216 0.536-20.56 0.032-30.808a357.024 357.024 0 0 0-3.136-34.072c-2.128-14.408-4.552-28.824-7.96-42.968-3.696-15.304-13.016-25.96-28.984-29.888-9.728-2.392-19.392-2.296-29.224-0.744-24.016 3.784-46 12.632-66.48 25.592-4.12 2.608-6.384 4.712-5.672 10.624 1.504 12.52 1.832 25.24 1.776 37.88-0.08 17.888-0.84 35.776-1.52 53.656-0.224 5.824-1.064 11.616-1.688 17.416-0.96 8.88-2.808 17.752-2.752 26.616 0.056 9.136 0.992 18.488 3.208 27.336 7.04 28.056 21.952 51.016 46.392 67.216 15.032 9.96 31.664 14.984 49.92 15.936 1.24-4.192 2.344-8.152 3.568-12.072z m-28.688-240.696c-3.216-6.752-1.376-12.344 6.08-14.936 1.816-0.64 3.688-1.32 5.576-1.504 2.592-0.256 5.232-0.064 7.856-0.064 9.456 0.048 18.552 1.368 26.36 7.384 5.008 3.856 6.352 8.976 3.112 14.232-4.6 7.456-11.616 11.2-20.232 11.92-13.576 1.128-23.104-5.2-28.752-17.032z m376.32-2.464c1.088-8.992 1.96-18.008 3.072-27 0.448-3.616-1.456-4.592-4.488-4.68-9.536-0.264-19.072-0.6-28.608-0.776-10.752-0.192-21.216 1.536-31.168 5.624-11.04 4.544-19.448 11.824-22.88 23.84a72.336 72.336 0 0 0-2.344 27.28 160.88 160.88 0 0 0 9.544 41.408c6.672 17.768 13.656 35.528 22 52.552 11.304 23.048 24.096 45.36 36.104 68.056 3.208 6.056 5.904 12.376 9.248 19.448a110.264 110.264 0 0 0 10.808-44.976c0.328-12.88-0.704-25.816-1.456-38.704-0.472-7.888-1.584-15.728-2.352-23.6-1.072-10.968-2.696-21.928-2.944-32.92-0.248-11.176 0.544-22.416 1.504-33.576 0.904-10.704 2.672-21.32 3.96-31.976z m-21.512-8.656c-3.544 9.784-11.12 15.304-20.944 16.928-9.16 1.504-17.184-1.88-23.152-9.184-4.248-5.2-2.624-11.36 3.744-14.872 7.312-4.048 15.352-5.072 24.832-5.688 2.576 0.472 6.456 0.864 10.144 1.92 5.352 1.512 7.328 5.536 5.376 10.896z m-283.376 301.28c-5.24-4.28-12.168-4.528-17.152 0.168-6.184 5.84-11.624 12.52-17.064 19.104-6.28 7.608-12.168 15.52-20.272 21.416-11.792 8.568-25.536 12.12-39.352 15.48-10.984 2.672-22.016 5.152-33.032 7.72l-0.136 1.424c3.272 1.512 6.44 3.4 9.848 4.48 16.8 5.32 33.888 7.968 51.64 6.464 12.816-1.088 25.024-3.88 36.592-9.368 15.92-7.544 28.168-19.496 38.584-33.4 1.744-2.32 2.536-5.752 2.744-8.744 0.712-10.568-4.656-18.424-12.4-24.744z m414.008 4.208c-13.52 1.448-27.056 2.984-40.616 3.76-6.544 0.376-13.184-0.872-19.792-1.408-11.08-0.896-21.896-3.36-31.264-9.28-5.424-3.416-9.928-3.8-15.688-1.864-8.224 2.768-14.936 6.976-16.92 15.888-1.352 6.024-1.84 12.264-2.384 18.432-0.104 1.088 1.256 3.088 2.296 3.36 6.344 1.672 12.72 3.648 19.208 4.232 7.968 0.72 16.08 0.488 24.104 0.088 8.664-0.432 17.384-0.992 25.92-2.432 20.12-3.376 39.584-8.88 56.872-20.288 6.232-4.12 12.408-8.328 18.6-12.496l-0.512-0.88c-6.608 0.984-13.184 2.184-19.824 2.888z'
              fill='#336791'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ClickHouseIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1160 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M0 0h122.802644v901.197356H0zM259.142587 0H381.945231v1024H259.142587zM518.76865 0h122.802644v1024h-122.802644zM777.911237 0h122.802644v1024h-122.802644zM1037.537299 409.503305H1160.339943v204.99339h-122.802644z'
              fill='#FFCB14'
            ></path>
            <path d='M0 901.197356h122.802644v122.802644H0z' fill='#FF0000'></path>
          </svg>
        )}
      />
    </>
  );
};

export const SqlServerIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M492.458667 240.576c-34.837333-52.245333-42.368-122.069333-44.010667-150.762667-88.490667 19.136-176.405333 53.461333-171.328 78.741334 0.64 3.178667 4.650667 6.997333 11.306667 10.709333l-10.410667 18.624c-12.714667-7.125333-19.861333-15.338667-21.802667-25.152-5.738667-28.608 26.666667-54.485333 99.029334-79.125333a899.242667 899.242667 0 0 1 101.354666-27.285334l12.736-2.56V76.8c0 0.896 0.554667 91.477333 40.874667 151.957333l-17.749333 11.818667zM528.021333 917.333333H522.666667c-174.762667 0-369.258667-54.890667-392.234667-146.752-14.016-56.106667 31.829333-118.101333 132.565333-179.221333l11.093334 18.218667c-90.645333 55.018667-134.314667 110.336-122.944 155.84 19.946667 79.744 204.266667 129.450667 365.930666 130.56 19.221333-28.736 122.496-197.546667 63.552-423.957334l20.629334-5.376c67.178667 257.962667-68.650667 444.522667-70.016 446.378667l-3.221334 4.309333z'
              fill='#CFD8DC'
            ></path>
            <path
              d='M211.861333 838.528c-11.498667 0-17.194667-1.258667-18.133333-1.493333a10.624 10.624 0 0 1-4.970667-17.92c1.536-1.536 153.536-153.770667 174.058667-276.864l21.034667 3.498666c-17.642667 105.898667-121.92 226.624-163.328 271.082667 41.365333-2.368 145.813333-21.738667 346.325333-133.973333-156.48-17.152-181.226667-142.421333-181.482667-143.765334l20.970667-3.861333c1.002667 5.248 26.154667 128.234667 197.205333 128.234667h0.170667a10.666667 10.666667 0 1 1 5.354667 19.904c-239.68 138.858667-355.904 155.136-397.205334 155.157333z'
              fill='#CFD8DC'
            ></path>
            <path
              d='M309.845333 889.6a10.645333 10.645333 0 0 1-6.208-19.349333c0.725333-0.533333 38.677333-28.544 79.061334-90.197334a424.448 424.448 0 0 1-46.848-24.256c-18.944-11.370667-33.258667-23.573333-43.946667-36.074666-54.826667 14.464-105.429333 20.181333-149.866667 16.405333l1.792-21.248c40.021333 3.392 85.525333-1.344 134.848-13.653333-33.557333-57.344-2.752-114.261333-2.325333-115.029334l18.645333 10.389334c-1.429333 2.602667-26.986667 50.56 5.312 98.837333 46.954667-13.482667 97.045333-33.429333 148.885334-59.349333a686.698667 686.698667 0 0 0 26.133333-133.888 10.688 10.688 0 0 1 15.061333-8.661334c0.682667 0.32 69.632 31.808 119.552 52.352a10.666667 10.666667 0 0 1 1.941334 18.688 1333.205333 1333.205333 0 0 1-144.597334 86.229334 580.053333 580.053333 0 0 1-52.458666 119.274666c78.976 29.504 147.52 29.952 148.394666 29.952a10.666667 10.666667 0 0 1 5.184 20.010667c-96.853333 53.802667-251.029333 68.949333-257.536 69.568h-1.024z m93.546667-100.970667c-22.186667 34.432-43.989333 59.157333-60.288 75.306667 42.624-6.272 117.354667-20.010667 179.370667-45.632a506.304 506.304 0 0 1-119.082667-29.674667z m-88.362667-75.434666c8.384 8.362667 18.837333 16.533333 31.786667 24.32 15.701333 9.429333 31.637333 17.429333 47.36 24.213333a557.141333 557.141333 0 0 0 45.696-97.450667c-43.114667 20.522667-84.970667 36.906667-124.842667 48.917334z m179.946667-194.176a724.266667 724.266667 0 0 1-19.477333 103.466666 1332.266667 1332.266667 0 0 0 107.989333-64.554666 4418.133333 4418.133333 0 0 1-88.512-38.912zM382.378667 226.133333a10.752 10.752 0 0 1-6.933334-2.56c-34.346667-29.397333-74.773333-89.216-76.48-91.754666a10.666667 10.666667 0 0 1 13.952-15.317334c0.234667 0.064 20.010667 8.213333 153.962667 30.528a10.645333 10.645333 0 0 1 6.186667 17.664c-37.504 41.664-84.885333 60.010667-86.890667 60.757334a11.242667 11.242667 0 0 1-3.797333 0.682666z m-48.576-82.218666c13.461333 18.112 32.853333 42.581333 50.602666 59.072a238.634667 238.634667 0 0 0 58.538667-38.357334c-55.104-9.408-88.725333-16.106667-109.141333-20.714666z'
              fill='#CFD8DC'
            ></path>
            <path
              d='M465.984 520.533333a10.666667 10.666667 0 0 1-10.602667-11.776c6.229333-58.645333-83.754667-82.176-84.672-82.389333a10.666667 10.666667 0 0 1-4.906666-17.877333c4.416-4.416 109.632-108.757333 241.642666-166.058667a10.666667 10.666667 0 0 1 14.698667 11.925333c-25.301333 122.538667-143.146667 256.938667-148.138667 262.592a10.88 10.88 0 0 1-8.021333 3.584z m-72.277333-109.12c25.258667 9.493333 69.504 31.466667 80.704 71.594667 30.912-38.570667 96.896-127.424 121.536-211.925333-93.589333 45.013333-172.394667 112.896-202.24 140.330666z'
              fill='#B71C1C'
            ></path>
            <path
              d='M279.018667 605.013333l-10.133334-18.773333c40.170667-21.653333 86.186667-61.504 123.882667-107.818667-32.085333 21.973333-50.453333 37.013333-51.029333 37.504l-13.632-16.426666c0.832-0.682667 37.632-30.869333 98.794666-68.693334 16.789333-27.008 29.696-54.784 36.330667-81.408 1.130667-4.522667 2.112-8.896 2.901333-13.12-41.066667-14.656-78.954667-23.338667-104.981333-27.072a10.666667 10.666667 0 0 1-6.336-17.813333c1.813333-1.962667 45.141333-48.384 99.285333-73.877333a10.666667 10.666667 0 0 1 12.394667 2.432c1.429333 1.557333 30.72 34.453333 23.274667 102.506666 24.64 9.6 50.026667 21.269333 74.474666 35.157334 58.858667-26.453333 125.696-50.261333 196.885334-64.64a10.88 10.88 0 0 1 10.261333 3.584c2.496 2.986667 3.178667 7.104 1.770667 10.730666-27.733333 71.082667-102.101333 147.008-105.258667 150.208a10.730667 10.730667 0 0 1-15.957333-0.853333c-23.893333-30.037333-55.125333-54.912-88.810667-75.157333a1176.234667 1176.234667 0 0 0-121.258667 65.045333c-43.093333 67.264-108.138667 129.024-162.858666 158.485333z m307.477333-233.898666c27.52 17.749333 53.141333 38.613333 74.325333 62.890666 17.664-19.157333 60.053333-67.584 84.096-115.669333-56.533333 13.013333-110.037333 31.850667-158.421333 52.778667z m-100.117333-27.178667c-0.704 3.477333-1.514667 7.04-2.410667 10.666667-4.48 17.898667-11.605333 36.288-20.736 54.634666a1198.570667 1198.570667 0 0 1 77.184-40.490666 543.488 543.488 0 0 0-54.037333-24.810667z m-101.354667-52.266667c23.701333 4.650667 52.906667 12.245333 84.074667 23.168 3.242667-39.317333-7.381333-63.402667-13.802667-74.069333-29.354667 15.317333-55.061333 36.864-70.272 50.901333z'
              fill='#B71C1C'
            ></path>
            <path
              d='M385.066667 394.666667c0 93.44-77.866667 167.68-133.973334 221.866666-9.386667 9.173333-41.173333 10.666667-41.173333 10.666667 7.893333-8.106667 16.853333-16.64 26.453333-25.813333 53.333333-51.626667 127.36-122.24 127.36-206.72 0-100.053333-40.32-139.52-72.106666-171.093334-14.08-14.293333-26.026667-27.946667-33.28-44.586666l6.613333-2.773334c7.253333 3.2 15.573333 6.826667 21.973333 9.6 5.12 7.466667 11.946667 14.72 19.84 22.613334 32.64 32.64 78.293333 77.44 78.293334 186.24z'
              fill='#B71C1C'
            ></path>
            <path
              d='M915.946667 422.272s-12.906667 1.834667-16.533334 2.261333c-186.88 20.693333-379.733333 74.453333-490.026666 118.613334-39.893333 16-81.28 35.413333-119.04 57.173333-0.213333 0.213333-0.426667 0.213333-0.853334 0.426667-22.186667 12.8-76.16 39.253333-119.893333 62.506666 64-68.053333 183.893333-120.533333 231.68-139.733333 108.16-43.306667 293.973333-95.573333 476.8-117.973333-21.546667-25.173333-74.24-78.506667-177.92-118.186667-60.586667-23.466667-152.746667-36.693333-234.026667-48.426667-129.28-18.56-202.88-30.933333-209.92-66.133333-1.493333-7.04-0.426667-14.08 2.773334-20.906667 7.04 11.52 17.066667 19.626667 23.68 24.32 3.2 2.133333 5.546667 3.413333 6.4 3.84l0.213333 0.213334c30.293333 16 112 27.733333 180.053333 37.546666 82.346667 11.946667 175.573333 25.386667 238.506667 49.493334 146.56 56.533333 197.12 137.386667 199.253333 140.8 1.92 3.2 8.853333 14.165333 8.853334 14.165333z'
              fill='#B71C1C'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const DorisIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M589.758464 184.60672l-102.514688-102.342656a140.845056 140.845056 0 0 0-45.666304-30.543872A141.04576 141.04576 0 0 0 387.674112 40.96a131.117056 131.117056 0 0 0-91.46368 36.769792 133.955584 133.955584 0 0 0-30.06464 43.433984 133.771264 133.771264 0 0 0 28.22144 147.521536l185.99936 185.683968a21.254144 21.254144 0 0 0 29.220864 0l80.048128-79.91296c5.033984-6.004736 88.764416-101.482496 0.12288-189.8496z'
              fill='#15A9CA'
            ></path>
            <path
              d='M757.710848 348.106752c-19.521536-18.874368-39.780352-38.363136-58.068992-59.445248v-0.73728c-0.65536 1.921024-1.14688 3.8912-1.47456 5.885952a210.194432 210.194432 0 0 1-62.738432 117.170176c-107.917312 106.999808-217.063424 216.326144-322.646016 322.101248l-14.241792 14.094336a136.482816 136.482816 0 0 0-41.865216 75.501568 145.850368 145.850368 0 0 0 6.361088 61.411328 146.030592 146.030592 0 0 0 31.207424 53.305344 122.88 122.88 0 0 0 96.62464 41.426944c42.10688 0.6144 62.611456-4.902912 93.302784-34.684928a82243.305472 82243.305472 0 0 0 338.485248-332.886016c43.831296-43.507712 53.899264-115.576832 22.839296-164.110336a563.07712 563.07712 0 0 0-87.785472-99.033088z'
              fill='#52CAA3'
            ></path>
            <path
              d='M163.49184 284.004352v452.018176a25.116672 25.116672 0 0 0 15.536128 23.22432 25.194496 25.194496 0 0 0 27.435008-5.451776l227.868672-227.479552a23.154688 23.154688 0 0 0 0-32.60416L206.462976 266.235904a24.559616 24.559616 0 0 0-17.555456-7.356416 25.43616 25.43616 0 0 0-17.887232 7.344128 25.350144 25.350144 0 0 0-7.528448 17.780736z'
              fill='#5268AD'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const PhoenixIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            {/*<path*/}
            {/*  d="M896 1024H128C57.6 1024 0 966.4 0 896V128C0 57.6 57.6 0 128 0h768c70.4 0 128 57.6 128 128v768c0 70.4-57.6 128-128 128z"*/}
            {/*  fill="#CAD0D1"></path>*/}
            <path
              d='M726.4 216.533c39.467-129.066 55.467-141.866 55.467-141.866s-107.734 38.4-141.867 147.2C605.867 331.733 663.467 464 675.2 508.8c10.667 44.8 76.8 304-145.067 318.933C369.067 838.4 323.2 670.933 339.2 596.267c4.267-19.2 21.333-90.667 52.267-141.867C422.4 403.2 435.2 324.267 435.2 324.267s25.6 5.333 37.333-14.934c0 0-23.466 0-8.533-11.733 13.867-11.733 8.533-25.6 8.533-25.6s-25.6 17.067-52.266 3.2c-25.6-13.867-84.267-52.267-124.8 8.533 0 0-43.734 7.467-64 35.2 0 0 43.733-17.066 64-5.333 21.333 11.733 54.4 37.333 20.266 118.4C281.6 513.067 190.933 577.067 240 724.267c49.067 147.2 160 205.866 304 205.866S792.533 784 792.533 641.067c0-142.934-105.6-295.467-66.133-424.534zM487.467 541.867c-51.2-43.734-52.267-150.4-52.267-150.4-17.067 120.533-8.533 194.133 72.533 240C588.8 678.4 612.267 736 612.267 736c3.2-32-72.534-150.4-124.8-194.133z m145.066 179.2s32-109.867 0-208c-28.8-87.467-53.333-117.334-52.266-179.2 1.066-61.867 29.866-182.4 45.866-197.334 0 0-100.266 89.6-101.333 185.6-1.067 96 39.467 141.867 64 182.4 24.533 40.534 57.6 110.934 43.733 216.534zM522.667 214.4s-80 118.4-60.8 228.267C464 461.867 476.8 498.133 528 552.533c51.2 54.4 92.8 148.267 96 167.467 0 0-2.133-104.533-40.533-173.867C545.067 476.8 478.933 388.267 502.4 294.4c4.267-23.467 20.267-80 20.267-80z'
              fill='#EC4C2E'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const HiveIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path d='M608.6656 764.3136V954.368h46.42133333v-87.38133333h9.8304v87.38133333h46.96746667v-190.0544H664.91733333v70.4512h-9.8304v-70.4512h-46.42133333z m161.65546667 0H724.992V954.368h45.32906667v-190.0544z m7.09973333 0l36.0448 190.0544h54.0672l36.0448-190.0544h-48.05973333l-12.01493334 81.37386667c-1.09226667 3.2768-4.36906667 3.2768-4.9152 0l-12.01493333-81.37386667h-49.152z m226.0992 0h-90.112V954.368H1003.52v-49.69813333l-50.24426667-0.54613334v-21.2992h24.02986667v-49.69813333h-24.02986667v-19.11466667h50.24426667v-49.69813333z'></path>
            <path
              d='M516.36906667 187.5968c-7.64586667-20.75306667-269.24373333-122.33386667-272.52053334-111.4112-48.05973333 12.56106667-67.72053333 67.72053333-100.48853333 102.67306667l-73.18186667-4.36906667c-32.22186667 41.50613333-49.152 84.10453333-37.6832 127.7952C74.00106667 359.08266667 122.0608 407.1424 151.552 477.5936c2.18453333 33.31413333 143.63306667 3.2768 174.21653333-3.2768-41.50613333 29.4912-77.55093333 75.3664-61.71306666 208.0768 14.19946667 62.2592 24.02986667 131.61813333 149.0944 201.5232 16.384 9.28426667 50.7904 20.20693333 71.54346666 27.8528 20.20693333 9.28426667 43.69066667 13.1072 110.31893334-7.09973333 38.77546667-16.384 80.2816-26.76053333 117.9648-43.14453334l-45.32906667 2.18453334c-62.2592 1.09226667-110.86506667 6.00746667-125.61066667-11.4688L484.69333333 752.29866667l33.31413334-64.98986667c46.42133333 4.9152 61.71306667 42.5984 102.67306666 56.79786667l48.05973334-35.49866667c139.81013333 82.46613333 195.51573333-52.4288 211.3536-157.2864-1.6384-42.5984-92.84266667 13.65333333-86.8352-6.5536 2.18453333-45.8752-35.49866667-105.94986667-59.52853334-152.91733333l27.8528-108.68053334c12.56106667-11.4688-58.9824-132.16426667-117.41866666-146.90986666-50.7904-13.65333333-127.7952 51.33653333-127.7952 51.33653333z'
              fill='#FDEE21'
            ></path>
            <path
              d='M746.2912 418.06506667c0.54613333 11.4688 0.54613333 25.66826667 1.6384 34.4064 0 6.5536-5.46133333 7.09973333-9.28426667 8.192l27.30666667 9.8304c5.46133333 9.28426667 9.8304 18.0224 14.19946667 27.30666666 4.9152 22.39146667 1.09226667 22.9376-2.18453334 24.576-9.8304 0-19.6608 0-28.94506666-1.6384 4.36906667 2.18453333 4.9152 3.82293333 5.46133333 6.5536 0.54613333 4.9152-2.73066667 12.01493333-8.192 19.11466667 8.192 4.36906667 22.9376 8.73813333 33.86026667 13.1072l12.56106666-27.8528c-6.00746667-40.41386667-22.9376-77.55093333-46.42133333-113.59573333z m50.7904 136.53333333c15.29173333 6.5536 36.0448 4.36906667 64.98986667-10.37653333 4.36906667-3.2768 8.192-1.09226667 0.54613333 3.82293333-38.22933333 33.86026667-56.25173333 16.93013333-65.536 6.5536z'
              fill='#C8C037'
            ></path>
            <path
              d='M864.80213333 539.8528c4.36906667 8.73813333 1.6384 15.29173333 0 22.9376-4.9152 37.13706667-16.384 66.08213333-38.77546666 96.6656-73.18186667 117.9648-147.456 44.2368-206.4384-3.82293333l-24.576 61.16693333c-1.09226667 5.46133333-6.5536 9.28426667 31.67573333 26.2144l38.77546667-27.30666667c148.54826667 112.50346667 253.40586667-158.37866667 199.33866666-175.85493333zM637.61066667 645.25653333c-9.8304 0.54613333-39.86773333 10.92266667-40.96 16.93013334l13.65333333-20.20693334 27.30666667 3.2768z m-19.6608-125.06453333c1.6384 0 10.37653333 2.18453333 9.8304 1.6384-1.09226667-0.54613333 0 12.56106667 2.73066666 19.11466667l-10.92266666 23.48373333c20.75306667-23.48373333 52.97493333-22.39146667 83.01226666-25.12213333l-14.19946666-8.73813334c2.73066667-8.192-0.54613333-14.7456-1.6384-21.84533333l-68.8128 11.4688z m50.7904-70.4512c-21.84533333 6.5536-43.14453333 18.0224-57.344 41.50613333 10.92266667-38.77546667 13.1072-37.13706667 16.384-39.3216 15.29173333-7.09973333 27.8528-2.73066667 40.96-2.18453333z'
              fill='#C8C037'
            ></path>
            <path
              d='M550.77546667 904.66986667c-26.76053333 29.4912-86.28906667-2.18453333-135.44106667-18.56853334-125.61066667-79.73546667-150.18666667-155.10186667-151.82506667-228.82986666-6.5536-105.94986667 26.2144-167.1168 67.1744-181.8624-27.30666667 52.4288-39.86773333 146.36373333-27.30666666 216.2688 10.37653333 38.77546667 10.37653333 104.31146667 75.3664 139.81013333 31.67573333 18.0224 23.48373333 31.67573333 44.78293333 48.60586667 23.48373333 18.56853333 89.56586667 36.0448 127.24906667 24.576z m39.86773333-488.2432c-45.32906667-63.8976-108.68053333-87.92746667-180.224-90.65813334 14.19946667-4.9152 28.94506667-7.09973333 43.14453333-14.19946666 3.2768-3.82293333 2.18453333-10.37653333 1.09226667-16.93013334-68.8128-18.0224-112.50346667-40.41386667-167.66293333-61.16693333L435.54133333 269.5168c100.48853333 3.82293333 91.7504 28.94506667 155.10186667 146.90986667z'
              fill='#FCF6A0'
            ></path>
            <path
              d='M639.24906667 385.29706667c-33.31413333-47.5136-65.536-105.40373333-109.7728-142.5408C423.5264 195.24266667 318.12266667 159.744 195.24266667 127.52213333l39.3216-50.24426666C365.09013333 107.3152 487.424 157.01333333 597.1968 238.93333333c19.11466667 46.96746667 31.1296 93.93493333 42.05226667 146.36373334z m67.1744-84.10453334s-18.56853333-42.05226667-27.8528-57.89013333c-21.2992-23.48373333-31.67573333-67.1744-75.3664-87.92746667 13.65333333 3.82293333 22.9376-0.54613333 50.7904 24.576l44.2368 83.5584 8.192 37.6832z'
              fill='#FCF6A0'
            ></path>
            <path
              d='M729.9072 373.82826667c4.36906667-36.59093333 12.56106667-94.48106667 3.2768-117.9648-26.2144-34.95253333-52.4288-71.54346667-78.6432-104.8576-4.36906667-3.82293333-7.64586667-9.8304-10.92266667-13.65333334 37.13706667 9.8304 75.91253333 35.49866667 127.7952 137.07946667l-41.50613333 99.39626667z'
              fill='#FCF6A0'
            ></path>
            <path d='M573.71306667 378.19733333c-14.7456-11.4688-27.8528-52.4288-50.24426667-61.16693333-20.75306667-1.6384-28.39893333-8.192-55.7056-2.73066667 9.8304-4.9152 19.11466667-11.4688 29.4912-14.7456 7.09973333-1.6384 13.65333333 0 20.75306667 1.09226667 1.6384-0.54613333 2.73066667-1.6384 2.18453333-3.2768-27.30666667-16.93013333-83.5584-16.93013333-121.78773333-26.76053333 44.2368 1.6384 92.84266667-1.09226667 126.1568 9.8304 26.76053333 23.48373333 35.49866667 68.26666667 49.152 97.75786666z m80.82773333-198.2464c6.00746667 0.54613333 38.77546667 52.4288 40.41386667 61.16693334 2.73066667 19.11466667 9.28426667 39.86773333 11.4688 60.07466666-5.46133333-19.11466667-11.4688-38.22933333-18.56853334-56.79786666-2.18453333-5.46133333-7.64586667-16.93013333-22.9376-33.86026667-7.09973333-12.01493333-8.73813333-21.2992-10.37653333-30.58346667z m111.4112 283.4432h-14.19946667l15.29173334 3.82293334-1.09226667-3.82293334z m-96.11946667-13.65333333c-14.19946667-1.6384-28.39893333-2.18453333-42.5984 1.09226667-6.00746667 7.64586667-6.00746667 15.83786667-8.73813333 22.9376 16.93013333-19.11466667 24.02986667-20.20693333 51.33653333-24.02986667z m193.3312 97.75786667c-7.64586667 6.00746667-8.73813333 12.01493333-32.22186666 19.11466666-16.93013333 3.82293333-26.76053333-2.73066667-34.4064-12.01493333 12.01493333 3.2768 14.19946667 12.56106667 46.42133333 2.18453333l20.20693333-9.28426666z m-70.4512 3.82293333c-5.46133333 15.83786667-12.01493333 31.1296-18.0224 45.8752-14.7456 17.47626667-8.192 7.64586667-30.58346666 33.86026667 7.09973333-10.92266667 16.384-21.2992 20.75306666-32.768 3.2768-7.64586667 7.64586667-15.29173333 9.28426667-21.84533334-6.00746667-2.73066667-17.47626667-3.2768-19.11466667-2.18453333-19.6608 11.4688-22.9376 23.48373333-34.4064 35.49866667 8.192-13.1072 15.29173333-27.8528 25.12213334-39.86773334 1.09226667-1.6384 8.192-1.6384 12.56106666-2.73066666-7.09973333-1.09226667-19.6608-3.82293333-20.75306666-3.2768-12.56106667 3.2768-19.6608 14.19946667-29.4912 21.2992 7.09973333-9.8304 13.1072-20.20693333 21.84533333-28.94506667 1.09226667-1.09226667 24.576 1.09226667 36.59093333 6.00746667v4.9152l7.09973334 2.73066666 5.46133333-13.1072 13.65333333-5.46133333z m-154.55573333 93.93493333c-3.2768-1.09226667-31.1296-4.9152-31.1296-3.82293333-10.92266667 7.64586667-12.01493333 14.7456-12.01493333 21.2992 17.47626667-17.47626667 16.93013333-17.47626667 43.14453333-17.47626667z m-21.2992-125.61066666s20.20693333-2.73066667 19.6608-1.09226667c-1.6384 7.09973333 2.73066667 24.02986667 2.73066667 21.2992l-11.4688 9.28426667c23.48373333-12.01493333 48.60586667-9.28426667 73.728-11.4688 0 0-21.2992-6.00746667-19.6608-6.00746667 4.9152-0.54613333-1.09226667-21.84533333-2.73066667-22.39146667 3.82293333-1.09226667 8.192-2.18453333 12.01493333-3.2768-30.58346667-7.64586667-48.05973333-3.2768-74.27413333 13.65333334z'></path>
            <path d='M789.98186667 534.9376l-4.36906667 2.18453333c-0.54613333-13.1072-14.7456-12.01493333-26.2144-12.01493333l-9.8304-2.18453333c2.73066667 2.73066667 12.01493333 2.73066667 8.192 8.192-3.2768 1.6384-4.36906667 8.73813333-6.00746667 14.7456h-5.46133333c9.28426667 3.82293333 18.0224 6.5536 27.8528 10.92266666l6.00746667 1.09226667 14.19946666-7.64586667-4.36906666-15.29173333z'></path>
            <path
              d='M657.27146667 525.65333333c-2.18453333-4.36906667-13.65333333-3.82293333-15.83786667-1.09226666-2.18453333 2.18453333 0 17.47626667 2.18453333 14.7456 3.82293333-3.2768 8.73813333-4.36906667 14.19946667-4.36906667 1.09226667-2.73066667 0.54613333-6.00746667-0.54613333-9.28426667z m108.68053333 22.39146667c1.09226667-0.54613333 3.2768-8.192 2.73066667-10.37653333-1.6384-5.46133333-12.01493333-4.36906667-12.01493334-4.36906667-2.73066667 1.6384-4.9152 9.8304-3.82293333 12.56106667 0.54613333 2.73066667 11.4688 3.2768 13.1072 2.18453333z'
              fill='#FFFFFF'
            ></path>
            <path d='M315.392 808.5504l6.5536 0.54613333c39.3216 19.11466667 104.31146667 48.05973333 198.79253333 32.768l14.7456 23.48373334c-41.50613333 20.20693333-86.28906667 15.29173333-127.7952 16.93013333L315.392 808.5504z m-56.79786667-153.46346667l19.6608 83.01226667c52.97493333 33.31413333 143.63306667 70.99733333 218.99946667 67.72053333l-16.93013333-38.22933333c-157.2864-32.768-170.3936-75.3664-221.73013334-112.50346667z m49.152-169.84746666c9.8304 64.44373333 22.39146667 113.0496 78.6432 154.0096 34.4064 24.576 68.26666667 49.152 109.7728 69.35893333 0 0-3.82293333 19.11466667-6.5536 18.56853333-123.42613333-13.65333333-213.53813333-115.78026667-224.4608-162.74773333 10.37653333-35.49866667 25.66826667-57.89013333 42.5984-79.18933333z m58.9824-36.59093334c16.384 71.54346667 55.7056 143.63306667 94.48106667 209.16906667 14.19946667 18.0224 18.0224 26.2144 39.86773333 37.13706667 29.4912 9.28426667 50.7904 7.09973333 72.0896 5.46133333-6.00746667-10.92266667-10.92266667-22.39146667-18.0224-32.768-48.05973333-38.22933333-26.2144-73.18186667-13.1072-95.0272-26.76053333-6.5536-62.2592-21.2992-67.1744-40.41386667-7.64586667-61.16693333-3.2768-80.2816 4.36906667-111.95733333-36.0448 7.64586667-73.18186667 15.29173333-112.50346667 28.39893333z'></path>
            <path d='M233.472 69.632c-12.01493333 7.64586667-23.48373333 19.11466667-36.0448 31.67573333-20.75306667 21.2992-34.4064 42.05226667-55.15946667 57.344-4.36906667 3.82293333-15.83786667 9.28426667-30.58346666 10.37653334-7.09973333 0.54613333-11.4688 1.6384-24.02986667 0-11.4688-6.00746667-21.84533333-2.18453333-32.22186667 10.37653333-11.4688 16.384-26.2144 47.5136-32.22186666 67.72053333C10.6496 296.82346667 42.32533333 338.3296 72.9088 370.00533333c27.30666667 26.2144 42.5984 43.14453333 53.52106667 67.1744 8.192 15.83786667 14.7456 37.13706667 21.2992 52.4288 2.18453333 4.9152 2.18453333 4.9152 8.73813333 6.00746667 14.19946667 3.2768 33.86026667 3.2768 51.33653333 4.36906667 7.64586667 0 18.0224 0 27.8528-1.09226667 13.65333333-2.73066667 29.4912-4.9152 42.5984-9.8304 13.1072-3.2768 24.576-7.64586667 34.95253334-11.4688-1.09226667 4.36906667-11.4688 8.73813333-15.29173334 14.7456-35.49866667 50.7904-45.32906667 96.11946667-38.77546666 167.1168 3.2768 31.67573333 10.92266667 57.89013333 21.84533333 87.92746667 4.9152 13.65333333 15.83786667 35.49866667 25.66826667 49.69813333 30.58346667 43.14453333 98.304 97.75786667 192.78506666 119.05706667 16.384 2.18453333 34.95253333 1.09226667 52.97493334-3.82293334 46.42133333-14.19946667 141.99466667-47.5136 141.99466666-47.5136s-84.65066667 7.09973333-122.88 3.2768c-8.73813333-1.6384-18.56853333-1.6384-25.12213333-8.192-1.09226667-1.09226667-4.9152-8.73813333-2.18453333-9.28426666 3.2768 0 13.1072-3.82293333 27.8528-5.46133334-31.67573333-3.2768-31.1296-3.2768-33.31413334-9.28426666-4.36906667-10.92266667-9.28426667-21.2992-14.7456-31.67573334 13.65333333 1.09226667 44.78293333 2.73066667 55.15946667-7.64586666 0 0-18.0224 2.18453333-34.4064 0-5.46133333-0.54613333-14.7456-3.82293333-17.47626667-4.9152-7.09973333-2.73066667-13.1072-3.82293333-14.7456-5.46133334-2.73066667-6.5536-4.36906667-8.73813333-7.09973333-16.93013333-4.36906667-11.4688-4.36906667-24.02986667-5.46133333-35.49866667 10.37653333 13.1072 24.02986667 24.02986667 41.50613333 29.4912 0-0.54613333 22.9376 9.8304 39.86773333 4.36906667l3.2768-1.09226667c0 0.54613333-10.92266667 1.09226667-15.29173333-1.09226666-33.86026667-14.19946667-38.77546667-26.76053333-44.2368-33.31413334l-14.7456-21.84533333c4.36906667-8.73813333 7.09973333-9.28426667 12.56106667-9.28426667 17.47626667 2.18453333 25.66826667 3.2768 36.0448 1.09226667 7.09973333 15.29173333 9.28426667 30.03733333 25.66826666 40.96 55.15946667 16.384 67.1744-4.9152 80.82773334-23.48373333 39.86773333 29.4912 104.8576 38.22933333 149.64053333 0.54613333 57.344-66.08213333 75.3664-170.3936 70.4512-176.40106667-7.09973333-12.01493333-16.384-24.576-24.576-22.9376-28.94506667 7.64586667-39.3216 22.39146667-67.72053333 19.11466667 3.2768 0 9.28426667 0 9.28426666-0.54613333 2.18453333-24.02986667 0-35.49866667-1.09226666-37.6832-8.73813333-19.11466667-20.20693333-39.3216-27.8528-54.0672-2.18453333-3.2768-8.192-26.76053333-18.0224-36.0448-4.36906667-3.82293333-14.7456-13.1072-14.7456-13.1072l-1.09226667 10.37653333s4.36906667 0.54613333 5.46133333 7.09973333c6.00746667 24.02986667 36.0448 81.37386667 38.22933334 84.10453334 10.92266667 17.47626667 1.09226667 38.77546667 9.28426666 50.7904 0.54613333 1.6384 16.384 0 28.94506667 0.54613333 20.20693333-4.36906667 19.11466667-13.1072 36.59093333-14.7456 12.01493333-1.09226667 13.1072 21.2992 12.56106667 22.9376-2.18453333 24.576-9.8304 52.4288-20.75306667 78.6432-23.48373333 45.32906667-49.69813333 86.28906667-87.38133333 91.7504-45.8752 8.192-69.35893333-12.01493333-93.93493333-24.576l-9.28426667 8.192c-32.22186667 32.22186667-70.4512 28.94506667-85.74293333-12.56106667-7.64586667-16.384-18.0224-26.2144-26.76053334-39.86773333l-45.8752 33.31413333c-3.82293333 7.64586667-8.73813333 20.20693333-14.19946666 33.86026667-3.82293333 9.8304-7.09973333 26.2144-7.09973334 39.86773333-6.00746667 9.8304 20.20693333 50.7904 37.13706667 75.3664 4.9152 7.09973333 14.19946667 20.20693333 14.19946667 20.75306667 3.2768 8.73813333 10.37653333 16.384 10.92266666 16.93013333 31.1296 40.41386667-38.77546667 31.1296-53.52106666 28.39893334-28.39893333-4.36906667-56.25173333-16.384-82.46613334-32.22186667-1.6384-1.09226667-3.2768-1.6384-4.36906666-2.73066667-31.1296-19.6608-59.52853333-44.78293333-84.10453334-69.35893333-14.7456-16.384-28.39893333-50.24426667-38.77546666-73.728-15.29173333-57.344-37.13706667-156.74026667 22.39146666-232.10666667 3.82293333-4.36906667 7.64586667-11.4688 11.4688-13.1072 17.47626667-12.01493333 37.13706667-20.20693333 57.344-24.576l-2.18453333-13.1072c-10.37653333 2.18453333-44.78293333 15.29173333-54.61333333 20.20693334-22.39146667 6.5536-40.96 13.1072-69.35893334 20.20693333-9.28426667 1.09226667-18.0224 1.09226667-27.30666666 0-20.20693333-2.73066667-55.15946667-0.54613333-57.344-2.18453333-13.65333333-19.11466667-17.47626667-54.0672-30.03733334-72.63573334-7.64586667-9.8304-15.83786667-18.0224-24.576-26.2144-30.03733333-30.03733333-56.25173333-58.9824-63.35146666-90.112-1.6384-9.28426667-6.5536-18.56853333-3.82293334-45.32906666 7.09973333-25.12213333 19.11466667-45.8752 39.3216-66.08213334 20.75306667 0.54613333 41.50613333 0.54613333 57.89013334 3.82293334 7.64586667 1.09226667 22.9376 3.2768 38.77546666 9.28426666 40.41386667 14.7456 93.3888 39.86773333 93.3888 39.86773334-39.86773333-21.84533333-84.65066667-50.24426667-112.50346666-56.25173334-4.36906667-0.54613333-6.5536-2.73066667-8.192-6.00746666 42.5984-25.12213333 50.24426667-54.0672 78.09706666-80.2816 12.56106667-5.46133333 17.47626667-8.192 28.39893334-9.28426667 99.9424 15.83786667 163.29386667 55.7056 212.992 82.46613333 20.20693333 10.92266667 38.77546667 19.11466667 56.25173333 29.4912 15.29173333 4.9152 61.71306667 39.86773333 75.3664 58.9824 13.65333333 28.94506667 24.02986667 60.6208 33.31413333 91.20426667 6.5536 31.1296 12.56106667 43.69066667 12.56106667 43.69066667s-5.46133333-25.66826667-4.9152-30.58346667c6.00746667 2.18453333 19.6608 6.5536 25.12213333 6.00746667 0 0-25.66826667-13.1072-28.94506666-24.576-10.92266667-37.13706667-21.2992-95.57333333-24.576-98.304-8.192-10.37653333-42.05226667-36.0448-62.80533334-48.05973334-7.64586667-4.36906667-12.01493333-7.64586667-12.56106666-9.28426666 6.5536-6.5536 14.7456-15.83786667 22.39146666-21.2992 7.09973333-5.46133333 13.65333333-11.4688 23.48373334-15.29173334 43.14453333-19.6608 68.26666667 7.64586667 73.728 2.18453334 0 0-9.28426667-10.92266667-4.9152-8.73813334 4.36906667 2.18453333 18.0224 4.9152 19.6608 6.5536 15.83786667 12.56106667 57.344 57.344 81.92 105.40373334 6.00746667 11.4688 8.192 19.11466667 5.46133333 33.31413333-2.73066667 14.19946667-4.9152 21.84533333-8.192 31.1296-2.73066667 6.00746667-18.0224 49.152-18.0224 55.15946667-3.2768 23.48373333 10.37653333 52.97493333 10.37653333 52.97493333 0-8.192-0.54613333-12.56106667 0-18.0224l1.09226667-10.37653333s-0.54613333-2.73066667-0.54613333-3.82293334c0.54613333-7.09973333 2.18453333-13.1072 2.73066666-16.93013333 4.9152-30.58346667 13.65333333-52.97493333 23.48373334-80.2816 2.73066667-6.5536 6.5536-10.37653333 6.5536-15.83786667 0-9.28426667-8.192-21.2992-14.19946667-33.86026666-6.5536-13.65333333-14.19946667-27.30666667-22.39146667-40.41386667-21.2992-31.1296-39.86773333-55.15946667-73.18186666-70.4512-9.28426667-4.36906667-46.42133333-8.192-58.9824-6.00746667-15.29173333 3.2768-28.94506667 6.5536-39.3216 13.1072-16.93013333 10.92266667-30.03733333 27.30666667-45.32906667 37.13706667-33.86026667-16.93013333-50.24426667-30.03733333-53.52106667-31.67573333-20.20693333-10.92266667-44.78293333-23.48373333-70.4512-35.49866667C382.5664 103.49226667 305.01546667 75.09333333 233.472 69.632z m435.8144 635.6992c-20.75306667-16.384-38.77546667-33.31413333-50.24426667-50.7904-3.82293333 20.20693333-17.47626667 34.95253333-28.39893333 49.152-2.18453333 3.2768-3.82293333 8.192 6.5536 22.39146667 2.73066667 3.82293333 13.1072 4.36906667 19.6608 4.36906666-7.09973333-5.46133333-17.47626667-10.92266667-19.11466667-15.83786666 12.56106667 8.192 23.48373333 10.92266667 33.86026667 9.28426666 2.18453333 0 5.46133333-2.73066667 7.64586667-6.5536 4.36906667-9.8304 8.192-12.01493333 12.01493333-14.7456l8.192 10.37653334 9.8304-7.64586667z'></path>
          </svg>
        )}
      />
    </>
  );
};

export const StarRocksIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M726.976 525.248c8.96-3.712 19.2-3.104 27.648 1.664l173.344 98.24 0.032 93.408c0 29.6-15.936 56.96-41.76 71.808l-332.48 190.528a84.064 84.064 0 0 1-83.52 0l-159.68-91.52 392.064-246.528c12.096-7.616 19.424-20.832 19.424-35.04v-54.976c0-7.84-2.24-15.328-6.176-21.76l8.16-4.416 2.944-1.408zM96 454.304l147.84 83.808 3.424 1.76a52.544 52.544 0 0 0 47.52-1.312l8-4.352c1.792 1.44 3.712 2.752 5.696 3.904l123.392 69.632a41.216 41.216 0 0 1 13.184 60.32l-153.248 210.56L137.76 790.4A82.816 82.816 0 0 1 96 718.56v-264.256zM719.744 170.24L886.176 265.6A82.816 82.816 0 0 1 928 337.44v263.84l-163.04-92.352-3.424-1.792a52.544 52.544 0 0 0-47.488 1.344l-14.208 7.68-128.864-68.608a41.216 41.216 0 0 1-13.728-61.376l162.528-215.936z m-165.952-95.136l150.08 86.016-2.72 0.896-394.496 250.56c-12 7.616-19.264 20.768-19.264 34.88v54.624c0 5.28 1.024 10.464 2.944 15.232l-5.568 3.072-2.912 1.376a31.52 31.52 0 0 1-27.648-1.664l-158.176-89.632v-93.024c0-29.6 15.904-56.96 41.76-71.808l332.48-190.528a84.064 84.064 0 0 1 83.52 0z'
              fill='#215B71'
            ></path>
            <path
              d='M553.792 75.104l150.08 86.016-2.72 0.896-394.496 250.56c-12 7.616-19.264 20.768-19.264 34.88v54.624c0 5.28 1.024 10.464 2.944 15.232l-5.568 3.072-2.912 1.376a31.552 31.552 0 0 1-24.768-0.192l-2.88-1.472-158.176-89.632v-93.024c0-29.6 15.904-56.96 41.76-71.808l332.48-190.528a84.064 84.064 0 0 1 83.52 0z'
              fill='#FABF01'
            ></path>
            <path
              d='M107.168 296.128l198.848 116.864-2.24 1.6a41.344 41.344 0 0 0-16.384 32.896v54.592c0 5.28 1.024 10.464 2.944 15.232l-5.568 3.072-2.912 1.376a31.552 31.552 0 0 1-24.768-0.192l-2.88-1.472-158.176-89.632v-93.024c0-14.72 3.968-28.96 11.136-41.312z'
              fill='#FCCC4C'
            ></path>
            <path
              d='M512 762.688v229.28c-14.4 0-28.832-3.712-41.76-11.104l-159.68-91.52L512 762.688zM96 454.304l147.84 83.808 3.424 1.76c13.824 6.528 29.824 6.72 43.776 0.512l3.744-1.856 8-4.32c1.792 1.472 3.712 2.752 5.696 3.904l123.392 69.632a41.216 41.216 0 0 1 13.184 60.32l-153.248 210.56L137.76 790.4A82.816 82.816 0 0 1 96 718.56v-264.256zM719.744 170.24L886.176 265.6a83.2 83.2 0 0 1 31.552 32.064l-295.232 177.344-51.584-27.488a41.216 41.216 0 0 1-13.696-61.376l162.528-215.936z'
              fill='#318492'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const PrestoIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1187 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M646.057196 75.587078m-37.794021 37.794021a53.448817 53.448817 0 1 0 75.588042-75.588042 53.448817 53.448817 0 1 0-75.588042 75.588042Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M792.98762 222.522579m-41.987198 41.987198a59.378865 59.378865 0 1 0 83.974396-83.974396 59.378865 59.378865 0 1 0-83.974396 83.974396Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M939.904169 369.472297m-46.180375 46.180375a65.308913 65.308913 0 1 0 92.36075-92.360751 65.308913 65.308913 0 1 0-92.36075 92.360751Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M1086.688672 516.237553m-50.371143 50.371142a71.235553 71.235553 0 1 0 100.742286-100.742285 71.235553 71.235553 0 1 0-100.742286 100.742285Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M352.355104 75.586514m-33.600844 33.600844a47.518769 47.518769 0 1 0 67.201688-67.201688 47.518769 47.518769 0 1 0-67.201688 67.201688Z'
              fill='#32DBFC'
            ></path>
            <path
              d='M499.280708 222.524011m-37.794021 37.794021a53.448817 53.448817 0 1 0 75.588042-75.588042 53.448817 53.448817 0 1 0-75.588042 75.588042Z'
              fill='#32DBFC'
            ></path>
            <path
              d='M646.068377 369.312539m-41.987199 41.987198a59.378865 59.378865 0 1 0 83.974397-83.974397 59.378865 59.378865 0 1 0-83.974397 83.974397Z'
              fill='#32DBFC'
            ></path>
            <path
              d='M792.934774 516.161627m-46.180376 46.180375a65.308913 65.308913 0 1 0 92.360751-92.360751 65.308913 65.308913 0 1 0-92.360751 92.360751Z'
              fill='#32DBFC'
            ></path>
            <path
              d='M939.884677 663.183056m-50.371143 50.371142a71.235553 71.235553 0 1 0 100.742286-100.742285 71.235553 71.235553 0 1 0-100.742286 100.742285Z'
              fill='#32DBFC'
            ></path>
            <path d='M58.816387 75.755438m-29.407667 29.407667a41.588721 41.588721 0 1 0 58.815334-58.815334 41.588721 41.588721 0 1 0-58.815334 58.815334Z'></path>
            <path d='M205.512179 222.438032m-33.600844 33.600844a47.518769 47.518769 0 1 0 67.201688-67.201688 47.518769 47.518769 0 1 0-67.201688 67.201688Z'></path>
            <path d='M352.506216 369.465763m-37.794021 37.794021a53.448817 53.448817 0 1 0 75.588043-75.588042 53.448817 53.448817 0 1 0-75.588043 75.588042Z'></path>
            <path d='M499.354161 516.311201m-41.987198 41.987198a59.378865 59.378865 0 1 0 83.974397-83.974397 59.378865 59.378865 0 1 0-83.974397 83.974397Z'></path>
            <path d='M646.20262 663.198776m-46.180376 46.180375a65.308913 65.308913 0 1 0 92.360751-92.360751 65.308913 65.308913 0 1 0-92.360751 92.360751Z'></path>
            <path d='M792.93938 809.862404m-50.371142 50.371142a71.235553 71.235553 0 1 0 100.742285-100.742285 71.235553 71.235553 0 1 0-100.742285 100.742285Z'></path>
            <path
              d='M352.378155 662.972266m-33.600844 33.600844a47.518769 47.518769 0 1 0 67.201688-67.201688 47.518769 47.518769 0 1 0-67.201688 67.201688Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M205.540915 809.81621m-47.518769 0a47.518769 47.518769 0 1 0 95.037539 0 47.518769 47.518769 0 1 0-95.037539 0Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M58.738147 956.772341m-47.518769 0a47.518769 47.518769 0 1 0 95.037539 0 47.518769 47.518769 0 1 0-95.037539 0Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M352.391396 956.68714m-47.518769 0a47.518769 47.518769 0 1 0 95.037538 0 47.518769 47.518769 0 1 0-95.037538 0Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M646.125041 956.798059m-33.600844 33.600844a47.518769 47.518769 0 1 0 67.201688-67.201688 47.518769 47.518769 0 1 0-67.201688 67.201688Z'
              fill='#5D88D6'
            ></path>
            <path
              d='M499.221859 809.809957m-33.600844 33.600844a47.518769 47.518769 0 1 0 67.201688-67.201688 47.518769 47.518769 0 1 0-67.201688 67.201688Z'
              fill='#5D88D6'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const PaimonIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 350.43 277.75'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <g>
              <path
                className='cls-5'
                d='m343.94,76.12l-50.19,14.1c.47.94.92,1.89,1.36,2.84l48.83-16.94Z'
              />
              <path
                className='cls-5'
                d='m99.32,200.04l-12.62,25.69h-50.11l22.99,4.72c7.55,1.55,14.28,5.8,18.93,11.96l20.16-23.6c3.71-4.16,7.5-8.23,11.36-12.24-2.97-3.76-5.69-7.71-8.15-11.84-.86,1.74-1.72,3.51-2.56,5.31Z'
              />
              <path
                className='cls-5'
                d='m142.18,140.85c-3.51-10.04-11.49-18.15-21.95-21.65l-12.74-4.26h80.4c19.85-7.47,43.6-13.02,72.56-17.39l19.6-3.48,13.7-3.85c-17.9-35.95-55.01-60.65-97.9-60.65-60.37,0-109.3,48.94-109.3,109.3,0,20.41,5.6,39.51,15.34,55.85,11.13-22.5,23.81-40.04,40.29-53.88Z'
              />
              <path
                className='cls-5'
                d='m268.95,102.14c-60.11,22.53-114.4,58.22-158.92,104.43,20.02,25.34,51.02,41.61,85.82,41.61,60.37,0,109.3-48.94,109.3-109.3,0-16.36-3.6-31.88-10.04-45.81l-26.17,9.08Z'
              />
            </g>
          </svg>
        )}
      />
    </>
  );
};
export const DefaultDBIcons = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M662.820571 225.660343c-115.390171-0.599771-216.429714 61.586286-271.228342 154.8288a242.190629 242.190629 0 0 0-98.450286-21.547886C155.896686 357.522286 44.631771 467.968 43.900343 606.281143c-0.131657 13.253486 0.936229 26.375314 2.794057 39.160686l0.599771 4.154514C62.902857 741.712457 143.1552 808.6528 235.885714 808.6528H727.04c101.434514 0 192.833829-63.063771 227.766857-158.997943 0.468114-1.3312 1.009371-2.808686 1.536-4.213028a317.147429 317.147429 0 0 0 17.671314-104.565029c0.058514-173.714286-138.708114-314.280229-311.222857-315.216457'
              fill='#4AADFF'
            ></path>
            <path
              d='M498.512457 445.059657c24.722286 0 44.880457 6.465829 60.094172 20.158172 15.213714 13.312 22.820571 31.568457 22.820571 54.769371 0 19.017143-4.944457 34.6112-14.072686 46.782171-3.423086 3.803429-14.453029 14.072686-32.709485 30.047086a58.953143 58.953143 0 0 0-15.213715 19.017143c-3.803429 7.606857-5.705143 15.594057-5.705143 24.722286v5.3248h-43.739428v-5.3248c0-14.453029 2.282057-27.004343 7.606857-37.2736 4.944457-10.269257 19.777829-26.243657 44.500114-48.303543l4.564115-5.3248c6.846171-8.367543 10.269257-17.495771 10.269257-27.004343 0-12.551314-3.803429-22.440229-10.6496-29.666743-7.226514-7.226514-17.495771-10.6496-30.427429-10.6496-16.735086 0-28.525714 4.944457-35.752228 15.594057-6.465829 8.747886-9.508571 21.2992-9.508572 37.2736h-43.359086c0-28.145371 7.9872-50.205257 24.722286-66.179657 16.354743-15.9744 38.414629-23.9616 66.56-23.9616z m-6.846171 219.457829c8.367543 0 15.594057 2.6624 21.2992 7.9872 5.3248 5.3248 8.367543 12.170971 8.367543 20.538514s-3.042743 15.594057-8.747886 20.918857c-5.705143 5.3248-12.551314 7.9872-20.918857 7.9872s-15.213714-3.042743-20.918857-8.367543c-5.705143-5.3248-8.367543-12.170971-8.367543-20.538514s2.6624-15.213714 8.367543-20.538514c5.705143-5.3248 12.551314-7.9872 20.918857-7.9872z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
