/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon, { DeleteTwoTone } from '@ant-design/icons';

const IconStyle = {
  height: '16px',
  width: '16px'
};

/**
 *  This is a custom icon that is used to indicate a dangerous action.{@link DeleteTwoTone}
 * @constructor
 */
export const DangerDeleteIcon = (props: any) => {
  return (
    <>
      <DeleteTwoTone {...props} twoToneColor={'red'} />
    </>
  );
};

export const PushpinIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1293 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M304.061663 1024l-10.075639-558.583565 673.072886-298.727501 37.527055 84.565975-616.984683 273.834748 4.307805 239.256659 131.89401-166.298629 199.358866 217.963381L1116.921383 123.047108 189.774722 276.899361l105.06419 107.911966-66.293943 64.5448L0 214.595197 1293.252283 0l-552.497706 972.320793-211.935344-231.710773-224.75757 283.38998z'
              fill='#1262B3'
            ></path>
            <path
              d='M304.061663 1024l-10.075639-558.583565 673.072886-298.727501 37.527055 84.565975-616.984683 273.834748 4.307805 239.256659 98.154354-123.769894 72.480992 57.490407-258.48277 325.933171z'
              fill='#FF584D'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * This is a custom icon that is used to indicate a show log action.
 * @constructor
 */
export const ShowLogIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M426.666667 834.133333c0-10.666667-8.533333-21.333333-21.333334-21.333333l-149.333333-2.133333c-23.466667 0-42.666667-19.2-42.666667-42.666667V256c0-23.466667 19.2-42.666667 42.666667-42.666667h426.666667c23.466667 0 42.666667 19.2 42.666666 42.666667v149.333333c0 12.8 8.533333 21.333333 21.333334 21.333334h42.666666c12.8 0 21.333333-8.533333 21.333334-21.333334v-192c0-46.933333-38.4-85.333333-85.333334-85.333333H213.333333c-46.933333 0-85.333333 38.4-85.333333 85.333333v597.333334c0 46.933333 38.4 85.333333 85.333333 85.333333h192c12.8 0 21.333333-10.666667 21.333334-21.333333v-40.533334z'
              fill='#1890ff'
            ></path>
            <path
              d='M887.466667 868.266667l-91.733334-89.6c21.333333-34.133333 36.266667-74.666667 36.266667-117.333334 0-117.333333-96-213.333333-213.333333-213.333333s-213.333333 96-213.333334 213.333333 96 213.333333 213.333334 213.333334c42.666667 0 83.2-12.8 117.333333-36.266667l91.733333 89.6c8.533333 8.533333 21.333333 8.533333 29.866667 0l29.866667-29.866667c8.533333-8.533333 8.533333-21.333333 0-29.866666zM618.666667 789.333333c-70.4 0-128-57.6-128-128s57.6-128 128-128 128 57.6 128 128-57.6 128-128 128z'
              fill='#297AFF'
            ></path>
            <path
              d='M576 384H320c-12.8 0-21.333333-8.533333-21.333333-21.333333v-42.666667c0-12.8 8.533333-21.333333 21.333333-21.333333h256c12.8 0 21.333333 8.533333 21.333333 21.333333v42.666667c0 12.8-8.533333 21.333333-21.333333 21.333333zM407.466667 512h-85.333334c-12.8 0-21.333333-8.533333-21.333333-21.333333v-42.666667c0-12.8 8.533333-21.333333 21.333333-21.333333h85.333334c12.8 0 21.333333 8.533333 21.333333 21.333333v42.666667c0 12.8-10.666667 21.333333-21.333333 21.333333z'
              fill='#1890ff'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * This is a custom icon that is used to indicate a show code tree action.
 * @constructor
 */
export const ShowCodeTreeIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M432.6912 784.6912h-199.68c-33.8944 0-61.44-25.6-61.44-57.088v-74.752a20.48 20.48 0 1 1 40.96 0v74.752c0 6.3488 8.7552 13.5168 20.48 13.5168h199.68a21.8112 21.8112 0 0 1 0 43.5712zM599.4496 784.6912h-61.44a21.8112 21.8112 0 0 1 0-43.5712h61.44a21.8112 21.8112 0 0 1 0 43.5712zM865.28 784.6912h-186.88a21.8112 21.8112 0 0 1 0-43.5712H865.28c11.6736 0 20.48-7.168 20.48-13.5168V180.4288c0-6.3488-8.7552-13.5168-20.48-13.5168H232.8576c-11.6736 0-20.48 7.168-20.48 13.5168v75.9296a20.48 20.48 0 1 1-40.96 0V180.4288c0-31.488 27.4432-57.088 61.184-57.088H865.28c33.792 0 61.44 25.6 61.44 57.088v547.1744c0 31.488-27.4432 57.088-61.44 57.088z'
              fill='#1296db'
            ></path>
            <path
              d='M91.0336 405.3504h301.4144a20.48 20.48 0 0 1 20.48 20.48v133.7344a20.48 20.48 0 0 1-20.48 20.48H111.5136a20.48 20.48 0 0 1-20.48-20.48V405.3504zM311.3984 405.3504h-220.16v-48.7424a20.48 20.48 0 0 1 20.48-20.48h157.9008a20.48 20.48 0 0 1 19.2 13.0048z'
              fill='#1296db'
            ></path>
            <path
              d='M369.9712 849.92m20.48 0l266.24 0q20.48 0 20.48 20.48l0 10.24q0 20.48-20.48 20.48l-266.24 0q-20.48 0-20.48-20.48l0-10.24q0-20.48 20.48-20.48Z'
              fill='#1296db'
            ></path>
            <path
              d='M507.4944 307.1488m20.48 0l266.24 0q20.48 0 20.48 20.48l0 10.24q0 20.48-20.48 20.48l-266.24 0q-20.48 0-20.48-20.48l0-10.24q0-20.48 20.48-20.48Z'
              fill='#1296db'
            ></path>
            <path
              d='M507.4944 428.3904m20.48 0l266.24 0q20.48 0 20.48 20.48l0 10.24q0 20.48-20.48 20.48l-266.24 0q-20.48 0-20.48-20.48l0-10.24q0-20.48 20.48-20.48Z'
              fill='#1296db'
            ></path>
            <path
              d='M507.4944 549.6832m20.48 0l266.24 0q20.48 0 20.48 20.48l0 10.24q0 20.48-20.48 20.48l-266.24 0q-20.48 0-20.48-20.48l0-10.24q0-20.48 20.48-20.48Z'
              fill='#1296db'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const WebIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M221.866667 405.333333c-14.933333 36.266667-23.466667 76.8-23.466667 117.333334 0 34.133333 6.4 68.266667 17.066667 98.133333 19.2-32 44.8-68.266667 76.8-106.666667-4.266667-8.533333-8.533333-19.2-8.533334-29.866666 0-8.533333 2.133333-14.933333 4.266667-21.333334-29.866667-21.333333-51.2-40.533333-66.133333-57.6zM332.8 778.666667c10.666667-8.533333 19.2-17.066667 29.866667-23.466667 87.466667-66.133333 166.4-104.533333 228.266666-125.866667 0-4.266667-2.133333-8.533333-2.133333-12.8v-6.4c-21.333333-6.4-44.8-12.8-66.133333-21.333333-55.466667-19.2-102.4-42.666667-142.933334-64-10.666667 10.666667-25.6 17.066667-40.533333 17.066667-8.533333 0-14.933333-2.133333-21.333333-4.266667-40.533333 46.933333-68.266667 91.733333-87.466667 125.866667 25.6 46.933333 59.733333 85.333333 102.4 115.2zM535.466667 556.8c23.466667 8.533333 46.933333 14.933333 70.4 21.333333 6.4-6.4 12.8-10.666667 19.2-12.8-6.4-23.466667-14.933333-46.933333-25.6-70.4-14.933333-34.133333-32-66.133333-49.066667-93.866666-6.4 2.133333-10.666667 2.133333-17.066667 2.133333-12.8 0-25.6-4.266667-36.266666-12.8-23.466667 14.933333-46.933333 29.866667-72.533334 49.066667l-32 25.6c2.133333 6.4 4.266667 14.933333 4.266667 21.333333v8.533333c38.4 19.2 85.333333 42.666667 138.666667 61.866667zM834.133333 522.666667c0-89.6-38.4-172.8-102.4-228.266667-32 6.4-81.066667 19.2-140.8 44.8v6.4c0 12.8-4.266667 23.466667-10.666666 34.133333 19.2 29.866667 36.266667 64 53.333333 102.4 10.666667 27.733333 21.333333 55.466667 29.866667 81.066667 17.066667 4.266667 32 17.066667 40.533333 34.133333 12.8 2.133333 25.6 2.133333 38.4 2.133334 32 2.133333 61.866667 0 85.333333 0 2.133333-27.733333 6.4-51.2 6.4-76.8zM516.266667 290.133333c6.4-2.133333 10.666667-2.133333 17.066666-2.133333 17.066667 0 32 6.4 42.666667 19.2 46.933333-21.333333 87.466667-34.133333 119.466667-42.666667-51.2-34.133333-113.066667-55.466667-179.2-55.466666-23.466667 0-49.066667 2.133333-70.4 8.533333 19.2 19.2 44.8 42.666667 70.4 72.533333zM661.333333 800c2.133333-32 0-74.666667-10.666666-128h-4.266667c-14.933333 0-27.733333-4.266667-36.266667-12.8-59.733333 21.333333-138.666667 57.6-224 123.733333-6.4 4.266667-12.8 10.666667-21.333333 14.933334 44.8 23.466667 96 36.266667 149.333333 36.266666 53.333333 2.133333 104.533333-10.666667 147.2-34.133333zM238.933333 371.2c14.933333 17.066667 38.4 40.533333 72.533334 66.133333 8.533333-4.266667 19.2-8.533333 29.866666-8.533333 10.666667 0 21.333333 2.133333 29.866667 8.533333l32-25.6c25.6-19.2 51.2-36.266667 74.666667-51.2-2.133333-4.266667-2.133333-8.533333-2.133334-14.933333 0-12.8 4.266667-23.466667 10.666667-34.133333-32-36.266667-59.733333-64-83.2-81.066667-70.4 25.6-128 76.8-164.266667 140.8zM733.866667 633.6c-6.4 0-17.066667 0-32 4.266667-4.266667 8.533333-8.533333 14.933333-14.933334 21.333333 8.533333 46.933333 12.8 87.466667 12.8 119.466667 51.2-36.266667 91.733333-85.333333 115.2-145.066667h-81.066666z'
              fill='#00C1DE'
            ></path>
            <path
              d='M661.333333 87.466667C652.8 61.866667 629.333333 42.666667 599.466667 42.666667c-34.133333 0-64 27.733333-64 61.866666s27.733333 61.866667 64 61.866667c17.066667 0 34.133333-6.4 44.8-19.2C804.266667 202.666667 917.333333 349.866667 917.333333 522.666667c0 42.666667-6.4 83.2-19.2 121.6l55.466667 32c17.066667-46.933333 27.733333-100.266667 27.733333-153.6C981.333333 320 846.933333 147.2 661.333333 87.466667zM842.666667 740.266667c-34.133333 0-64 27.733333-64 61.866666 0 6.4 2.133333 10.666667 2.133333 17.066667-70.4 61.866667-164.266667 100.266667-266.666667 100.266667-117.333333 0-224-51.2-298.666666-130.133334l-57.6 32c85.333333 98.133333 213.333333 160 354.133333 160 119.466667 0 230.4-44.8 311.466667-119.466666 4.266667 2.133333 8.533333 2.133333 14.933333 2.133333 34.133333 0 64-27.733333 64-61.866667s-25.6-61.866667-59.733333-61.866666zM121.6 599.466667c-4.266667-25.6-8.533333-49.066667-8.533333-76.8 0-189.866667 136.533333-347.733333 317.866666-386.133334v-64C213.333333 110.933333 49.066667 298.666667 49.066667 522.666667c0 32 4.266667 64 10.666666 93.866666-10.666667 10.666667-17.066667 25.6-17.066666 42.666667 0 34.133333 27.733333 61.866667 64 61.866667 34.133333 0 64-27.733333 64-61.866667 0-29.866667-21.333333-53.333333-49.066667-59.733333z'
              fill='#00C1DE'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const BackIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M710.6 277.1H318.7v-157L0.1 355.5l318.6 235.4v-157h391.9c86.6 0 156.7 70.2 156.7 156.8 0 86.6-70.2 156.8-156.7 156.8h-78.4v156.8h78.4c173.1 0 313.5-140.4 313.5-313.5S883.8 277.1 710.6 277.1z'
              fill='#2C66E1'
            ></path>
            <path d='M240.4 747.4h78.4v156.8h-78.4z' fill='#8FB3FF'></path>
            <path d='M397.1 747.4h156.8v156.8H397.1z' fill='#2C66E1'></path>
          </svg>
        )}
      />
    </>
  );
};

export const StartIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M512 962C263.4 962 62 760.5 62 512 62 263.4 263.5 62 512 62s450 201.4 450 450c0 78.6-20.3 152.5-55.8 216.8l-0.2-0.2c-5.2 16.7-20.1 29.1-38.5 29.1-22.6 0-40.9-18.3-40.9-41l0.3-3.7c9.2-26.2 18.9-44.5 18.9-44.5 22.5-47.7 35.5-100.9 35.5-157.1 0-203.7-165.1-368.8-368.8-368.8-203.7 0-368.8 165.1-368.8 368.8 0 203.7 165.1 368.8 368.8 368.8 81.3 0 156.2-26.7 217.1-71.3 7.4-7.8 17.8-12.9 29.5-12.9 22.6 0 40.9 18.3 40.9 40.9l-0.4 3.8c0 19.1-11.9 21.2-31.3 38.9C695.6 930.7 607.7 962 512 962z'
              fill='#2E9DFB'
            ></path>
            <path
              d='M445.5 694.7c-9 6.6-21.1 6.9-30.5 0.9-9.9-6.8-15.7-18.1-15.5-30.1V321.4c0-12.5 5.9-24.1 15.5-30.1 9.4-6 21.5-5.7 30.5 0.9l239.9 172c8.7 6.4 14.1 17.4 14.1 29.2s-5.3 22.9-14.1 29.1L445.5 694.7z'
              fill='#FF9000'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const StopIcon = (props: any) => {
  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M710.6 277.1H318.7v-157L0.1 355.5l318.6 235.4v-157h391.9c86.6 0 156.7 70.2 156.7 156.8 0 86.6-70.2 156.8-156.7 156.8h-78.4v156.8h78.4c173.1 0 313.5-140.4 313.5-313.5S883.8 277.1 710.6 277.1z'
              fill='#2C66E1'
            ></path>
            <path d='M240.4 747.4h78.4v156.8h-78.4z' fill='#8FB3FF'></path>
            <path d='M397.1 747.4h156.8v156.8H397.1z' fill='#2C66E1'></path>
          </svg>
        )}
      />
    </>
  );
};

const defaultSvgSize = '100%';

export const DinkyIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        component={() => (
          <svg
            version='1.1'
            className='icon'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
            viewBox='0 0 32 32'
            enableBackground='new 0 0 32 32'
          >
            <image
              href='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAACBjSFJN
                            AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAH
                            QklEQVRYw82XeWwcZxnGn5md3dljdnZndtf22l7Hrr12rjoJjlGiJKROoTStVBWlIIiANogz4ihS
                            FfgjQgipKKgSEkKiBURRJCpUtVIDolRKCbEanATXOZyNr/jatb229z5md2bn/Pgjpkrq0DghRrz/
                            faMZPb95v+f53hng/7EoivqfadluW9A0TQjBga4eyJqKIOdDSamsKwB968K0LL7OK3ytKEsHU1Le
                            IXr4mzetY0duAyCn4kXNNKqCX3j56Z19r0hKNXr0U58DTdPwc/z6Azg+G0VRlvolS4s1RSJHerq6
                            Tw1OXT9kmCbNMg60hBofOMBtHrAsC50t7dJ0Mj7Ccd5ND3du7vW5vI8LHq8ZS9y41BFpNZ7a9xgu
                            jV9bHwAAyJUK0A09X5BKoa3Rjb0b6pt9bpp9pL2pNTSxNDMkBiLV0anrcLIuGKYBAGAYB4hlgaJo
                            AOQjUkTdHQAAKIqylJpS4T3cwW2dW4JuO2tr8AV6O1o6e4YTk5Pzi/H5106+jj29j2Ji+jqefeYE
                            roycpgBiJ4RYk8MMZCWPro4ebGzfi2ef+Rn6L/yB8bj9jK7XrFsBbQDgcrlgmia6OrrQGemA6PYj
                            VUhnbTZb1cf7eyL1zbzg8cPrDra5vY1P/PY3r3om47EJjmuvxOevIeBvOvBk39Hjj+z+4ldPvTGw
                            N5WZsVS9AoB0V2Vp/+jUwMG6wIbHdEPbXJULCYqiKwC5CRAMBOF0OFGVq1S4obHBYbNvgIVwwCe6
                            JhdmeDEQ2tkSeSjs4wV4uQBoZ9Ab9Df01QXaet6PXTjX2/3pjx3Ye+Q1YcvOfTXRHXV7hN46f/1n
                            aKLsUmqSV9eNBd3Qrqia8o9qtTCo1KQCRcH6dwcY0zCRK+f8Xzh0+IWNbV2HtIIcqKaLtKWbyu6m
                            benh6TE+FpogfE+IcnqdCPJ+cEYjuPCmvuWy4xfRSDQgRzc0DPIFuC4PwTe7iJKU+WciPvTt4dGL
                            Ywf2fJnk8klI1RwUVQIAEPIhDxiGsYXzcD/YFu3eUuer87hop9tuMbzLcoS9xC3OZxYp1i8SB8tT
                            lrMeFXsjiC0AaLZOLtwYudJCQbJbCFVNJM6dq1y6+u7zLpa/kC0sYDE1gWRqEiUpA91QV5twxcmp
                            fC4fV6pKBw1bvcPhsMmqCtW04HZ4AB1IljJUqLEVQqARMHmwpIJaZRmUEMasaMGkCeQrMcQvvPuX
                            5fzYz3OFRQMgMFeScrcYkr7evskzg2cGSpVS3AKpk1U1ZOgWrWgqYALpUgpiSwRNkQiglTA1PQ7O
                            24GgrxkLThkVoiLff7acHRk45vM33zAsHYap4m71QQynF6bhdDizy7nl90dnxy4upBakXCkjFop5
                            UdI1WrOzkIkCD+dFOmPA598BUWgBYwE0RWOutoTswN9+n5ob+pVcy1uGUbv3g8i0TAAgDsaxXFEr
                            7+UquTN5pZBUaPg84WhQh4cJ+rrRHOmD2yWArJiZN+xIJ2KxS5ff+K7YEM1p+RwsS18TwO3DaMWe
                            mqEBgAZg9NDjXz9hEPmF9ubW3FOffA7dWw+Aok1kS4uoaQpAM8hn5kqV8/0/+tbTv5xJXx+Abshr
                            EgfudDauVGO4GX5fEKPjV73Hj/36lU1d+w6D8mImuYBLE0OYyy8iJDYj7BSQXxp/8c9v/+Q4AFAU
                            DUKsNQMwd7ro9wmQ5SoWlxZszx89fkzwi5+PxYYxVUjiRjaPmqGDGFWAbYJaxyC7VNoe7tjbxvKB
                            2dTUeSjlzP0D0BSNYqkAQgi+ceTol0Ds3796PUHnMilk/Aw8YhugpCF07kbhxhXwu/bA29D0pKWp
                            0yOnX/4e6/atWXyVBwDAIhZ+/MOf4rnDX3mUYYQXZ5YNT7pURCo1A9bLg6FtRCsv66Gt3XD5A4id
                            PJHTNeU8K4SCFEWxNrvzngBWTcON0U24fG1ws9fb/LuKFWw3KQcsvQZKL2plVU4qSm05M33hJaHj
                            4c2WpkzNvffW+I3TJ79pZ7m3lWyyTIhFTH1tEbzjFoxPjrGh4EPHqghudRg0/GIQTtGJ2dJ0cv7q
                            37+j02xNSo2dmT375oBlqMXi8kQWQFGV8gZAgaxZ+g4ADOOEYdRC4bbtYV3X5zkvFwkEWVTyBRQL
                            6cF8ZuadUMcnLCk1BpfYcJFm7B88uzRy9h6l77AFFEWDpinWULWEwG/cF24L1gtuB2ZmJszM3PhL
                            na07hpOJIWi6inTsHFLD/fcl+h87QFEUuqKHMrqm1HMBVz3PKPNVwkekdHKqWFzqL0hpVOTyfy16
                            a92WAsPQMDL2Oquauf1aZfatSOsmdn56DKRW/lOqnJnPFFMPVHwVwMoHJZeID7y5++N7luZTizbR
                            qU/SDvLHXTv2g6Zt96fyEbUqBYSQPIDTqWzqiXKl+E6935McGDp7zePlYN0cVg+0Vr0STdNwOt2u
                            RHycVuViTZJKf92yeftiLptGtbq+/4kfBnMD2AOAXU+hfwGQaGun1sRttgAAACV0RVh0ZGF0ZTpj
                            cmVhdGUAMjAyMy0wNi0zMFQwOTowMjoxNCswMDowMEAnZX0AAAAldEVYdGRhdGU6bW9kaWZ5ADIw
                            MjMtMDYtMzBUMDk6MDI6MTQrMDA6MDAxet3BAAAAKHRFWHRkYXRlOnRpbWVzdGFtcAAyMDIzLTA2
                            LTMwVDA5OjAyOjE0KzAwOjAwZm/8HgAAAABJRU5ErkJggg=='
            />
          </svg>
        )}
      />
    </>
  );
};

export const FlinkIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1025 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M839.501367 888.329389a93.762247 93.762247 0 0 0 5.384299 51.27087l45.852276 32.374383-2.709296 10.802892v16.187191l10.802892 2.709297 16.187191-2.709297 2.709297 5.384299 8.093596 10.802893h10.802892l10.802893-24.280787v-10.802893l10.802892-2.709296s72.84236-24.280787 56.655169-51.270871l-5.384299-2.709297a125.485027 125.485027 0 0 1-45.852276 10.802893 182.345965 182.345965 0 0 1-91.738849-18.896488z'
              fill='#D77083'
            ></path>
            <path
              d='M855.688558 866.723604s-29.665086 0-10.802892 29.665086a152.200751 152.200751 0 0 0 86.320254 40.467978s83.645253 0 89.166732-26.990084c0 0-2.709297-32.374382-26.990084-29.665085-24.383671 8.093596-137.69401-13.477894-137.69401-13.477895z'
              fill='#733D48'
            ></path>
            <path
              d='M985.186088 780.40335a113.687582 113.687582 0 0 1 21.57149 102.507445 44.103237 44.103237 0 0 1-24.280787 35.08368 145.101707 145.101707 0 0 1-51.270871 2.709296s-51.27087-2.709297-67.458061-29.665085a34.67214 34.67214 0 0 1-2.709297-45.852277s37.724386-16.187191 45.852277-40.467978a41.565415 41.565415 0 0 1 29.665085-8.093595 95.408402 95.408402 0 0 1 29.665086 10.802892s24.349377-18.930783 18.965078-27.024378z'
              fill='#D59D52'
            ></path>
            <path
              d='M885.353644 812.777732a80.044289 80.044289 0 0 0 64.748764 43.177275 83.988202 83.988202 0 0 0 62.073763-26.990084l-16.187191-40.467978-29.665085-8.093595s-78.260954-24.280787-80.970251 32.374382z'
              fill='#DBAE62'
            ></path>
            <path
              d='M985.323267 780.369055s18.896488 24.280787-5.384298 29.665085a82.92506 82.92506 0 0 1-37.724387 0s-83.645253 24.280787-62.073763 94.448145c0 0-16.187191 0-24.280786-40.467978l8.093595-83.645252s113.138864-21.57149 121.369639 0z'
              fill='#B88F4D'
            ></path>
            <path
              d='M974.383195 820.837033s10.802892 21.57149 2.709297 32.374382c0 0-2.709297 5.384299 10.802893 8.093596a40.467978 40.467978 0 0 0-2.709297-48.561574s-10.802892-2.675002-10.802893 8.093596z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M974.383195 818.162031a5.384299 5.384299 0 1 0 5.384299-5.384299 5.384299 5.384299 0 0 0-5.384299 5.384299z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M977.092492 855.920712a5.384299 5.384299 0 1 0 5.384299-5.384299 5.384299 5.384299 0 0 0-5.384299 5.384299z'
              fill='#FFFFFF'
            ></path>
            <path d='M1014.885468 888.329389a110.566747 110.566747 0 0 0-21.57149-110.635336h-8.093595v13.477894a79.872814 79.872814 0 0 1 18.896488 64.748765 215.131886 215.131886 0 0 1-8.093596 43.177275 67.080818 67.080818 0 0 1-40.467978 18.896488 191.022574 191.022574 0 0 1-83.645253-21.57149 51.613819 51.613819 0 0 1-10.802892-45.886572h-5.384299c0-2.709297-2.709297-5.384299-13.477894 0 0 0 5.384299 8.093596-5.384299 10.802892 0 0-21.57149 10.802892-16.187191 53.980168 2.709297 37.724386 51.27087 62.039468 51.27087 62.039468a11.831739 11.831739 0 0 1 2.709297 8.093595c0 5.384299-2.709297 18.896488 13.477894 21.57149 0 0 10.802892 2.709297 16.187192-2.709297 0 0 8.093596 24.280787 24.280786 18.896488a23.18335 23.18335 0 0 0 13.477895-35.083679 108.166104 108.166104 0 0 0 62.073763-35.083679 43.931763 43.931763 0 0 0 10.734302-64.71447z m-10.802892 51.27087a75.860311 75.860311 0 0 1-53.980168 40.467978 145.273182 145.273182 0 0 1-29.665085-2.709296s-21.57149 8.093596 2.709297 5.384298c0 0 18.896488 0 16.187191 13.477895 0 0-2.709297 13.477894-8.093596 13.477894 0 0-5.384299 5.384299-13.477894-10.802892 0 0 2.709297-5.384299-8.093596-5.384299 0 0-18.896488 8.093596-18.896488-10.802892a37.724386 37.724386 0 0 1 10.802893-13.477895s-53.980167-16.187191-62.039468-62.039468c0 0-5.384299-10.802892 2.709297-8.093595a164.10108 164.10108 0 0 0 83.645253 40.467978 152.063571 152.063571 0 0 0 75.448772-10.802893c2.743592 2.709297 5.452889 5.315709 2.743592 10.802893z m8.093595-24.280786a38.753233 38.753233 0 0 1-5.384298 8.093595c-2.709297 0-2.709297 2.709297-5.384299 2.709297a164.615504 164.615504 0 0 1-107.92604 0c-45.886572-24.280787-48.561574-40.467978-48.561573-43.177275s0-5.384299 2.709296-5.384298c0 0 5.384299-10.802892 10.802893-5.418594a40.159324 40.159324 0 0 0 10.802892 24.280787 121.643998 121.643998 0 0 0 72.842361 26.990083c35.083679 2.709297 53.945872-8.093596 62.073763-24.280786 5.350004 2.675002 10.734303 10.768598 8.025005 16.152896z'></path>
            <path
              d='M11.211025 564.55127a374.157322 374.157322 0 0 0 118.728932 218.527081l121.403933-105.216742 180.7684-5.384299 232.039271-132.206826s140.300422-89.166731 134.916123-188.861996c0 0-153.778316 70.133064-188.861996 48.561574l-59.364466 29.665085-64.748764 45.852277-94.448146 8.093596-13.477894 16.187191-175.384101 53.945872s-24.280787-75.448773 56.655169-202.33989l26.990084-43.14298-116.019636 53.945873-2.709296-26.990084-13.477895 2.709297-21.57149 67.458061-24.280786 8.093596-67.458062 116.019635-8.093596-18.896488H22.013917v53.945872H11.211025z'
              fill='#BB75E8'
            ></path>
            <path
              d='M772.043305 456.625231l24.280787-8.093596 29.665086-43.177275h10.905777l18.896488 2.709297 8.093595 16.187191 16.187192 16.187192 29.665085 8.093595 26.990084 10.802893 24.280787 21.57149 10.802892 16.187191 13.477894 24.280787 10.802893 37.724386 8.093595 26.990083 5.384299 18.896488 5.384299 16.187192-2.709297 24.280786-8.093595 18.896488-10.802893 13.477895-26.990084 8.093595-8.093595 8.093596-35.083679 5.384299h-24.280787l-16.187191 10.802892 2.709297 13.477895h16.187191l29.665085-8.093596 29.665086 2.709297 18.896488 16.187191 8.093595 8.093596 2.709297 18.896488v26.990083l-18.896488 16.187191-18.896488-2.709296-13.477894-5.384299-24.280787 2.709297-8.093596 10.802892-16.187191 16.187191-29.665085 16.187191-26.990084 5.384299-40.467978 5.384299-2.709297 10.802892v10.802893l-5.384298 21.57149-16.187192 21.57149-16.187191 24.280787 32.374383 2.709296 29.665085 5.384299 13.477894 16.187191 5.384299 16.187192-5.384299 13.477894-18.896488 16.187191-43.177274 2.709297H378.132123s-215.852079 0-304.881631-156.487613S16.595323 602.275657 16.595323 602.275657l5.384299-24.280787s35.083679 124.113231 94.448145 186.152699l16.187191 18.896488s10.802892-2.709297 18.896488-45.852277c0 0 18.896488-89.166731 240.064277-89.166731l91.738848-48.561574 91.738848-26.990084 67.458062-16.187191 53.945872-26.990083z'
              fill='#E6516F'
            ></path>
            <path d='M890.772237 556.457675a36.112526 36.112526 0 0 1 48.561574-8.093596 44.137532 44.137532 0 0 1 10.802892 62.073763 65.434663 65.434663 0 0 0-24.280786 0c-2.709297 0-64.748765 2.675002-35.08368-53.980167z'></path>
            <path
              d='M901.540835 583.447758a16.701615 16.701615 0 0 1-2.709297-18.896488l-8.093596-8.093595s-13.477894 16.187191 10.802893 35.083679a61.730814 61.730814 0 0 0 35.083679 8.093596s8.093596 2.709297 8.093596 5.384298v-21.57149s-5.384299 13.477894-13.477895 13.477895a60.187544 60.187544 0 0 1-29.665085-13.477895z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M906.959429 569.935569a16.187191 16.187191 0 1 0 16.187191-16.187191 16.187191 16.187191 0 0 0-16.187191 16.187191z'
              fill='#D19B52'
            ></path>
            <path
              d='M901.540835 559.166972a8.093596 8.093596 0 1 0 8.093596-8.093596 8.093596 8.093596 0 0 0-8.093596 8.093596z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M302.546171 132.881407l2.709297-26.990084 70.133063-51.27087 32.374383-16.187191a173.532177 173.532177 0 0 1 105.216743-37.724386l75.448772 8.093595 53.945872 18.896488 40.467978 24.280787 32.374383 16.187191 40.467978 26.990084-8.093596 48.561573-8.093595 35.08368 10.802892 48.561573-16.187191 24.280787a165.541466 165.541466 0 0 1-51.270871 56.655169l-24.280786 45.852277-43.177275 53.945872-75.448773 48.561574-64.748764 18.896488-51.270871 5.384298-186.152699 56.65517-35.083679 16.187191a256.320057 256.320057 0 0 1 56.655169-202.33989l48.561574-43.177275a118.934701 118.934701 0 0 0 37.724386-70.133063l29.665086 51.27087 21.57149-45.852277c0-2.709297 2.709297-118.728932-94.448146-110.635336z'
              fill='#E7DFAB'
            ></path>
            <path
              d='M780.136901 76.191943l-24.280787 29.665085-8.093595 26.990084-5.384299 62.039468-8.093596 56.655169s-32.374382 51.27087-45.886571 45.852277l-10.700008 24.349377-5.384299 18.896488 43.177275-37.724387 56.655169-24.280787 32.374382-13.477894 13.477895-26.990083-13.477895-51.270871-2.709296-32.374382-16.187192-5.384299s-8.093596-43.177275 5.384299-59.364466z'
              fill='#D19456'
            ></path>
            <path
              d='M650.639371 364.886382a389.521435 389.521435 0 0 1 121.403934-94.448145v16.187191l67.458062-37.724386h16.187191l-5.384299 35.083679-18.896488 24.280787-21.57149 35.083679-35.083679 24.280787-72.84236 26.990084-70.133064 16.187191z'
              fill='#D77083'
            ></path>
            <path
              d='M391.610018 154.452897s89.166731-24.280787 118.728932 0 110.635336-5.384299 110.635336-5.384299l72.84236 43.177275-5.384298 102.541741a91.293015 91.293015 0 0 0-86.320255-75.448773c-78.226659-8.093596-75.448773-21.57149-124.113231-45.852276s-37.827271 2.537822-86.388844-19.033668z'
              fill='#D89E52'
            ></path>
            <path
              d='M391.610018 154.452897s10.802892 32.374382 64.748764 35.083679 226.620677 91.738848 159.19691 164.615504c0 0-10.802892 80.935956-78.226659 99.832444a151.480558 151.480558 0 0 0 18.896488-145.684721 104.42796 104.42796 0 0 0-83.645253-80.935956 254.605312 254.605312 0 0 1-80.97025-72.91095z'
              fill='#D89E52'
            ></path>
            <path
              d='M442.880888 259.66964s26.990084 83.645253 72.84236 97.123147c0 0 53.945872 48.561574 5.384299 83.645253l-97.123147 40.467978-167.290506 43.177274-59.364466 21.57149s67.458062-86.320255 113.173159-107.926039a188.827701 188.827701 0 0 0 116.019635-107.92604z'
              fill='#D89E52'
            ></path>
            <path
              d='M364.654229 259.66964a360.302184 360.302184 0 0 1-99.832444 159.19691 215.852079 215.852079 0 0 0-56.655169 121.403934 278.097316 278.097316 0 0 1 80.935956-124.113231 201.894056 201.894056 0 0 0 75.551657-156.487613z'
              fill='#814879'
            ></path>
            <path
              d='M434.787292 494.383912a157.51646 157.51646 0 0 1 70.167359 18.896488 139.751704 139.751704 0 0 0-29.665086-18.896488 665.320994 665.320994 0 0 1 113.173159 24.280787 136.047855 136.047855 0 0 0 59.364466 0 223.534136 223.534136 0 0 1-83.645253-18.896488 230.153051 230.153051 0 0 0-78.226659-16.187191z'
              fill='#785085'
            ></path>
            <path
              d='M607.496392 432.344444a163.346592 163.346592 0 0 1 56.655169 0 111.115465 111.115465 0 0 0 110.635336-13.477894s-45.852277 56.655169-83.645253 48.561573a539.355839 539.355839 0 0 0-126.891117-10.802892 59.364466 59.364466 0 0 0 43.245865-24.280787z'
              fill='#E1CAC9'
            ></path>
            <path
              d='M372.747824 135.487819a288.077131 288.077131 0 0 1 53.945873-37.724386s72.84236-18.896488 43.177275 0l-13.477895 16.187191a118.454573 118.454573 0 0 1 56.655169-10.802892l-13.477894 10.802892s45.852277-8.093596 51.27087 0c0 0 18.896488 21.57149 37.724387 10.802892 0 0-8.093596 21.57149-53.945873-2.709296 0 0-32.374382 0 0 13.477894a366.955394 366.955394 0 0 0-161.871912-0.034295z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M337.664145 718.329587s-37.724386 5.384299-37.724386 62.039468a83.439483 83.439483 0 0 0 43.177275 59.364466 207.861368 207.861368 0 0 1 8.093595-118.694637z'
              fill='#A04F5D'
            ></path>
            <path
              d='M685.723051 734.516778s-5.384299 94.41385 32.374382 134.916123a99.729559 99.729559 0 0 0 75.448773 26.990084s24.280787-40.467978-24.280787-43.177275a88.069294 88.069294 0 0 1-62.073763-59.364466c-2.572117 2.675002-7.990711-53.980167-21.468605-59.364466z'
              fill='#9A505E'
            ></path>
            <path
              d='M726.191029 648.162228a79.667045 79.667045 0 0 0 62.039468 97.123147s64.748765 8.093596 83.645252-26.990083c0 0-67.458062 13.477894-102.54174-21.57149-2.675002 0.034295-40.467978-26.955789-43.14298-48.561574z m116.019635-226.620676s-51.27087 32.374382-13.477895 67.458061a198.498861 198.498861 0 0 1 16.187192-48.561573 11.454495 11.454495 0 0 0-2.743592-18.896488z'
              fill='#A04F5E'
            ></path>
            <path d='M836.826365 445.822338s-13.477894 29.665086-8.093596 40.467978c0 0 8.093596 18.896488 13.477895 16.187192a54.666065 54.666065 0 0 1 2.709297-51.270871 45.543623 45.543623 0 0 0 0-45.852277 52.402602 52.402602 0 0 1-8.093596 40.467978z m26.990084 53.945873a32.442972 32.442972 0 0 0 10.802892-48.561574 66.737869 66.737869 0 0 1-10.837187 48.595869z m-137.591125 145.68472z m0 0a87.863525 87.863525 0 0 0 94.448145 72.842361c-83.679548-16.152896-94.48244-70.133064-94.48244-72.808066z'></path>
            <path d='M1012.107582 594.216356a296.273612 296.273612 0 0 1-10.802893-56.655169 132.275416 132.275416 0 0 0-121.403934-105.216743 48.012855 48.012855 0 0 0-43.177275-32.374382s-18.896488 2.709297-48.561573 40.467978c-5.384299 5.384299-5.384299-2.709297-5.384299-2.709297a16.701615 16.701615 0 0 0 5.384299-10.802893 253.336401 253.336401 0 0 0 35.083679-86.320254 141.397859 141.397859 0 0 0 26.990084-29.665086l10.802892-35.083679s-5.384299 0-10.802892 8.093595 18.896488-43.177275 10.802892-56.655169c0 0-32.374382 16.187191-35.083679 24.280787a405.022729 405.022729 0 0 0-18.896488-72.84236s0-35.083679 10.802892-40.467978c0 0-10.802892-13.477894-26.990083 10.802892 0 0-18.896488-18.896488 8.093595-70.133063 0 0 5.384299-10.802892-21.57149-2.709297a270.106606 270.106606 0 0 0-24.280787 26.990083 109.743669 109.743669 0 0 1-16.187191-29.665085 3.738144 3.738144 0 0 0-5.384298 0s-5.384299 8.093596-8.093596-8.093596c0 0-10.802892-18.896488-16.187191-18.896488 0 0 2.709297 13.477894 0 13.477895 0 0-2.709297 0-10.802893-5.384299A326.453121 326.453121 0 0 0 593.984202 14.083885s-13.477894-5.384299-18.896488-8.093595a8.367955 8.367955 0 0 0-5.384298 2.709296 71.196205 71.196205 0 0 1-18.896489-2.709296c-29.665086-13.477894-43.177275 0-43.177274 0-153.778316 0-202.33989 99.832444-202.33989 99.832444-16.187191 16.187191-2.709297 26.990084-2.709297 26.990083h24.280787c102.541741 64.748765 37.724386 126.891117 37.724386 126.891118l-10.802892-35.08368c-24.280787-24.280787-16.187191 0-16.187192 0a68.109665 68.109665 0 0 1-18.896488 62.039468 701.36493 701.36493 0 0 0-140.300422 59.364466c-16.187191-2.709297 8.093596-26.990084-10.802892-24.280786s-29.665086 51.27087-29.665086 51.27087a500.70549 500.70549 0 0 0-110.635336 137.591125c0-5.384299-2.709297-40.467978-2.709297-59.364466a176.310063 176.310063 0 0 0-8.093595 94.448145 349.533586 349.533586 0 0 0-13.477895 48.561574 26.887199 26.887199 0 0 1-2.709297 10.802892v35.083679a369.973344 369.973344 0 0 0 29.665086 161.871912s40.467978 126.891117 207.758484 196.955591a443.295833 443.295833 0 0 0 126.891117 24.280787h404.67978s56.655169 0 64.748764-29.665085c8.093596-32.374382-10.802892-64.748765-64.748764-56.655169 0 0-16.187191 2.709297 5.384298-13.477895a68.589793 68.589793 0 0 0 18.896488-51.27087s-8.093596-13.477894 18.896488-10.802893a160.260052 160.260052 0 0 0 29.665086-2.709296 106.314179 106.314179 0 0 0 70.133064-53.945873s18.896488-8.093596 29.665085 0c0 0 21.57149 10.802892 26.990084 2.709297a107.034372 107.034372 0 0 1 16.187191-10.802892s5.384299 2.709297 10.802892-37.724387a33.368934 33.368934 0 0 0-10.802892-24.280786s-5.384299-8.093596-8.093596-13.477895c0 0-13.477894-18.896488-59.364466-10.802892 0 0-24.280787 16.187191-29.665085 8.093595s8.093596-8.093596 8.093595-8.093595a184.19789 184.19789 0 0 0 75.448773-18.896488 42.011248 42.011248 0 0 0 37.724386-40.467978 43.0058 43.0058 0 0 0 2.709297-56.655169z m-232.039271-178.059103a262.287369 262.287369 0 0 1-143.009719 129.497529 334.443832 334.443832 0 0 0-59.364466 2.709297c35.083679 5.384299 26.990084 10.802892 26.990084 10.802893a341.199926 341.199926 0 0 0-102.541741 21.57149 477.59073 477.59073 0 0 0-153.778316-5.384299 314.415612 314.415612 0 0 0-172.674804 78.226659 475.464446 475.464446 0 0 1 180.7684-67.458062c118.728932-8.093596 126.891117 0 126.891117 0a219.041505 219.041505 0 0 0-72.84236 34.980795 445.593591 445.593591 0 0 1-102.541741 26.990083 586.442732 586.442732 0 0 0-83.645253 18.896488 113.173159 113.173159 0 0 0-83.645253 102.541741 127.268361 127.268361 0 0 1-24.280787-80.935956l-2.709296-2.709296a330.431329 330.431329 0 0 1 18.896488-45.852277c24.280787-56.655169 40.467978-59.364466 83.645252-86.320255s202.33989-56.655169 202.33989-56.655169c156.487613-18.896488 199.664888-75.448773 199.664888-75.448773a102.88469 102.88469 0 0 1 16.187191-13.477894h2.709297a353.443204 353.443204 0 0 0 164.615504-51.27087 213.657206 213.657206 0 0 1-21.605785 59.295876zM847.492078 254.148161a128.777337 128.777337 0 0 1-40.467978 75.448773 313.35247 313.35247 0 0 1-161.871912 70.133063l-5.384299 2.709297a107.583091 107.583091 0 0 1 18.896488-18.896488 251.004348 251.004348 0 0 0 143.009719-78.226659 377.655401 377.655401 0 0 1-137.591125 67.458062c8.093596-10.802892 13.477894-24.280787 21.57149-37.724387a262.561728 262.561728 0 0 1 75.448772-45.852276 119.689189 119.689189 0 0 1-29.665085 35.083679 134.881828 134.881828 0 0 0 64.748765-40.467978c-2.572117-5.247119 29.83656-29.665086 51.305165-29.665086z m-97.123147-99.832444a110.532452 110.532452 0 0 1 29.665085-67.458061 9.465391 9.465391 0 0 1 0 16.187191 167.39339 167.39339 0 0 0-2.709297 62.039468l-26.990083 62.039468a264.550832 264.550832 0 0 1 0.137179-72.670886zM348.467038 251.576044c35.083679 45.852277-21.57149 121.403934-21.57149 121.403934 97.123147-75.448773 75.448773-145.684721 75.448772-145.684721a96.540134 96.540134 0 0 0-56.655169-91.738848c-29.665086-5.384299-24.280787-16.187191-24.280787-16.187191 80.935956-91.738848 156.487613-75.448773 156.487613-75.448773 0-13.477894-56.655169-5.384299-56.655169-5.384299 18.896488-26.990084 83.645253-21.57149 83.645253-21.57149a330.637098 330.637098 0 0 1 35.083679 13.477895l-10.802892-21.57149a131.520928 131.520928 0 0 1 18.896488 8.093595 26.887199 26.887199 0 0 0 10.802892 2.709297c8.093596 0 18.896488 2.709297 35.083679 2.709297 0 0 16.187191 2.709297 29.665086 29.665086a121.369639 121.369639 0 0 0-5.384299-21.57149 87.074742 87.074742 0 0 1 26.990084 24.280787s2.709297-2.709297 0-13.477895a133.750097 133.750097 0 0 1 48.561573 37.724386s2.709297 2.709297 2.709297-5.384298c0 0 2.709297-16.187191 8.093596 0 0 0-2.709297 16.187191 2.709297 13.477894a20.576938 20.576938 0 0 0 5.384298-13.477894s5.384299-2.709297 5.384299 5.384298a7.476287 7.476287 0 0 0 10.802893 0 36.764129 36.764129 0 0 1 8.093595 16.187192 67.149408 67.149408 0 0 0 8.093596 18.896488 137.7626 137.7626 0 0 0-8.093596 56.655169 292.261109 292.261109 0 0 1-10.802892 89.166731A96.02571 96.02571 0 0 0 772.043305 189.536576s18.896488-48.561574 21.57149-18.896488a46.709649 46.709649 0 0 0 0 29.665086s-8.093596 32.374382-16.187191 37.724386a92.596221 92.596221 0 0 0 24.280787-24.280787s8.093596 26.990084-5.384299 35.083679a276.725521 276.725521 0 0 1-72.84236 32.374383 92.596221 92.596221 0 0 0-32.374383 29.665085l-5.384298 8.093596a517.852939 517.852939 0 0 0 21.57149-64.817355 68.932742 68.932742 0 0 0 18.896488-32.374382c-5.384299 0-16.187191 13.477894-16.187192 13.477894-10.802892 10.802892-5.384299-18.896488-5.384298-18.896488a146.679273 146.679273 0 0 0 10.802892-21.57149c0-10.802892-10.802892 2.709297-10.802892 2.709297-10.802892 5.384299-5.384299-13.477894-5.384299-13.477894 8.093596-16.187191 2.709297-21.57149 2.709297-21.57149-5.384299 0-13.477894 24.280787-13.477895 24.280787-2.709297 16.187191-16.187191-16.187191-16.187191-16.187192-13.477894-10.802892-10.802892-37.724386-10.802892-37.724386-2.709297-16.187191-5.384299 0-5.384299 0-2.709297 18.896488-5.384299 8.093596-5.384299 8.093596a111.321234 111.321234 0 0 0-2.709297-24.280787v21.57149c-5.384299 8.093596-10.802892-10.802892-10.802892-10.802892-2.709297-18.896488-8.093596-16.187191-8.093596-16.187192-2.709297 10.802892 2.709297 16.187191 0 18.896488s-10.802892-8.093596-10.802892-18.896488-8.093596-5.384299-8.093596-5.384298c0 18.896488-5.384299 10.802892-5.384298 10.802892-140.334717-62.005173-199.733478-13.37501-199.733478-13.37501 129.49753-53.945872 245.517165 72.84236 245.517165 72.842361a115.608096 115.608096 0 0 0-51.270871-2.709297 74.52281 74.52281 0 0 1-59.364466 5.384299c13.477894 16.187191 67.458062 8.093596 67.458062 8.093595a51.442345 51.442345 0 0 1 40.467978 2.709297c24.280787 21.57149-5.384299 21.57149-5.384299 21.57149 26.990084 10.802892 35.083679 51.27087 35.083679 51.27087-8.093596 110.635336-124.113231 167.290506-124.113231 167.290506 56.655169-86.320255 21.57149-137.591125 21.57149-137.591125-18.896488-43.177275-97.123147-62.039468-97.123147-62.039468 78.226659 35.083679 83.645253 80.935956 83.645253 80.935956a172.29756 172.29756 0 0 1-37.724386 129.497529l-26.990084 10.802893a117.562906 117.562906 0 0 0 16.187191-67.458062 138.962921 138.962921 0 0 1-67.458061 83.645253 97.054557 97.054557 0 0 0 16.187191-56.655169c-5.384299 26.990084-48.561574 59.364466-48.561574 59.364466-18.896488 24.280787-143.009719 53.945872-153.778316 53.945872a198.430272 198.430272 0 0 0-48.561574 16.187191c-29.665086-86.320255 86.320255-210.433485 86.320255-210.433485a137.865484 137.865484 0 0 0 51.270871-78.226659zM116.427767 421.541552c-13.477894 153.778316 37.724386 151.103314 37.724387 151.103314-59.364466-40.467978-5.384299-210.433485-5.384299-210.433486 16.187191-40.467978 18.896488 0 18.896488 0a148.874146 148.874146 0 0 0-16.187191 89.166732 137.179586 137.179586 0 0 1 113.173158-121.403934 383.416944 383.416944 0 0 0-67.286587 215.680604h2.709297a15.775652 15.775652 0 0 0-10.802892 2.709297 266.780001 266.780001 0 0 1 0-137.591125c-37.724386 40.467978-16.187191 164.615504-16.187192 164.615504-2.709297 8.093596-13.477894 2.709297-13.477894 2.709297-10.802892 0-29.665086 40.467978-29.665085 40.467977-5.384299 0-13.477894-18.896488-13.477895-18.896488-5.384299 13.477894 0 18.896488 0 18.896488 5.384299 32.374382 2.709297 26.990084 2.709297 26.990084-5.384299 2.709297-10.802892-16.187191-10.802892-16.187191a41.59971 41.59971 0 0 0 2.709296 35.083679l-2.709296 16.187191A554.960017 554.960017 0 0 1 38.132518 542.97978a448.817312 448.817312 0 0 1 78.226659-121.403934zM24.688919 518.664699s-5.384299 35.083679 83.645253 178.059103a293.255661 293.255661 0 0 0 2.709296 48.561573 300.766243 300.766243 0 0 1-80.935955-167.290505 343.566274 343.566274 0 0 1-5.384299-59.364466z m984.777955 121.403934s-18.896488-21.57149-24.280786-10.802893l18.896488 16.187191a36.592655 36.592655 0 0 1-37.724387 35.08368s-13.477894 18.896488-56.655169 18.896488a81.3132 81.3132 0 0 0-35.083679 10.802892s-10.802892 8.093596-48.561573 5.384299a78.329544 78.329544 0 0 0 32.374382 5.384299s13.477894-2.709297 16.187191 2.709296c0 0 21.57149 8.093596 21.57149 10.802893s56.655169-32.374382 78.226659 0c0 0 5.384299 10.802892 10.802893 10.802892 0 0 2.709297 13.477894 0 16.187191s-10.802892-8.093596-10.802893 0c0 0 18.896488 2.709297 10.802893 24.280787a24.417966 24.417966 0 0 1-37.724387 5.384299s-29.665086 5.384299-37.724386 0c0 0-24.280787 78.226659-145.684721 56.655169a109.023476 109.023476 0 0 1-70.133063-80.935956s-29.665086-126.891117-148.394018-94.448145c0 0 75.448773-5.384299 110.635337 43.177275a164.066785 164.066785 0 0 1 43.177275 86.320255 94.996864 94.996864 0 0 0 67.458061 53.945872s35.083679 2.709297 10.802893 48.561573a123.461628 123.461628 0 0 1-43.314455 37.827271s-10.802892 5.384299-8.093595 13.477895c0 0-2.709297 16.187191 13.477894 2.709297 0 0 62.039468-35.083679 80.935956 13.477894 0 0 5.384299 10.802892 0 13.477894a9.568276 9.568276 0 0 1-8.093596-5.384298s-5.384299-13.477894-13.477894-10.802893a30.042329 30.042329 0 0 1 10.802892 32.374383s-13.477894 16.187191-18.896488 0c0 0 5.384299-29.665086-16.187191-24.280787 0 0 21.57149 16.187191 5.384299 32.374382a35.392333 35.392333 0 0 1-24.280787 2.709297s-8.093596-10.802892-48.561573 0H356.560633a382.559571 382.559571 0 0 1-291.506621-164.615504A455.641996 455.641996 0 0 1 13.783142 699.398804l40.467978 53.945872-34.9465-86.28596v-59.330171c0-10.802892 2.709297-21.57149 2.709297-26.990083a601.498191 601.498191 0 0 0 94.448145 186.152698 198.9104 198.9104 0 0 0 32.340088 70.270243c-21.57149 0-51.27087-29.665086-51.270871-29.665085a154.978638 154.978638 0 0 0 80.935956 64.748765 329.9512 329.9512 0 0 0 129.49753 67.458061 293.358545 293.358545 0 0 1-97.123147-53.945872 265.545384 265.545384 0 0 1-72.842361-100.038214 160.294347 160.294347 0 0 1 24.280787-59.364466c32.374382-48.561574 116.019635-62.039468 116.019635-62.039467a1047.091783 1047.091783 0 0 0 107.92604-13.477895c-13.477894 5.384299-32.374382 45.852277-32.374383 45.852277-2.709297 5.384299-24.280787 8.093596-24.280786 8.093596-94.448145 10.802892-113.173159 48.561574-113.173159 48.561573a189.10206 189.10206 0 0 1 45.852277-24.280787 330.637098 330.637098 0 0 1 75.448772-10.802892 257.623263 257.623263 0 0 0 10.802892 164.615504 216.057849 216.057849 0 0 1 13.477895-172.674805 267.500193 267.500193 0 0 1 156.281844-107.891744c35.083679-10.802892 121.403934-32.374382 121.403934-32.374383a203.162967 203.162967 0 0 0 89.166731-62.039468 133.750097 133.750097 0 0 1 53.945872-40.467978 27.435917 27.435917 0 0 0 13.477894 21.57149s10.802892 2.709297 5.384299-16.187191c0 0-10.802892-10.802892 5.384299-35.083679a88.343654 88.343654 0 0 1 32.374382-24.280787 77.575056 77.575056 0 0 1 26.990084 37.724386s102.541741 16.187191 116.019635 105.216743c0 0 2.709297 16.187191 2.709297 21.57149a54.494591 54.494591 0 0 0 10.802892 26.990084c5.452889-5.315709 21.64008 21.64008 13.546484 35.152269z'></path>
          </svg>
        )}
      />
    </>
  );
};

export const MavenIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M580.571429 950.784c10.130286 0.475429 21.613714-2.633143 26.916571-16.713143 4.352-11.556571 7.936-34.669714 10.057143-65.609143l0.987428-17.627428-39.753142-21.577143c0.512 21.540571 0.073143 42.057143-1.28 61.330286l-0.987429 11.446857 0.512-11.154286 0.219429-9.874286 0.036571-11.922285-0.219429-13.970286-0.548571-16.091429a1021.732571 1021.732571 0 0 0-0.365714-8.777143l-1.206857-19.931428-1.901715-24.685714a1861.741714 1861.741714 0 0 0-10.057143-88.210286l-1.974857-13.641143-4.388571-28.781714 0.365714-0.365715-0.438857-0.475428-4.022857-24.246857-5.339429-30.793143a2504.009143 2504.009143 0 0 0-9.654857-50.468572l-8.192-39.314285-6.326857-29.257143-6.582857-28.781714-6.656-28.16-7.168-29.513143-12.617143-49.737143-7.862857-29.403429c3.218286 1.499429 6.4 3.145143 9.508571 4.937143l6.180572 23.917714 2.084571 8.374858 0.109714 0.073142 8.374858 33.499429 12.434285 52.662857c3.291429 13.970286 6.326857 28.013714 9.435429 42.24l8.996571 42.861714c3.035429 14.628571 5.888 29.257143 8.630857 43.995429 2.742857 14.482286 5.229714 29.184 7.789715 43.629714l3.547428 21.357715 3.657143 22.893714-0.146286 0.073143 5.668572 42.057143c1.792 14.665143 3.437714 29.366857 4.973714 44.032 3.035429 29.257143 4.900571 58.697143 5.595429 88.137142l39.68 21.577143 0.402285-8.411428 0.621715-22.308572 0.146285-11.702857c0.073143-14.08 0-28.196571-0.219428-42.313143l-0.841143-27.721143c-0.182857-4.681143-0.365714-9.472-0.621714-14.262857l-1.024-18.505143-1.316572-20.297142-0.182857-0.146286c-0.109714-0.841143-0.219429-1.828571-0.182857-2.779429-1.097143-13.458286-2.084571-27.026286-3.474286-40.740571a1411.401143 1411.401143 0 0 0-6.107428-51.931429l-4.315429-29.366857-0.585143-3.547428a947.419429 947.419429 0 0 0-24.612571-109.714286l-6.290286-19.931429c-5.046857-15.433143-10.605714-30.427429-16.64-45.056l-0.219428-0.146285-0.621715-1.828572a489.325714 489.325714 0 0 0-17.92-38.692571l-7.606857-14.043429c7.387429 3.328 17.627429 4.242286 25.965714 4.278857l6.582858-0.109714 8.192-0.621714c-26.989714-10.532571-50.614857-23.405714-65.536-42.971429 5.924571-7.314286 17.005714-12.873143 30.976-17.444571-19.309714-2.340571-30.025143 1.426286-33.974858 3.364571 10.093714-9.508571 15.725714-26.770286 20.626286-45.348571-11.337143 20.845714-22.601143 34.706286-33.572571 40.009143l-7.936-28.818286A5705.398857 5705.398857 0 0 0 550.656 73.142857a18.505143 18.505143 0 0 0-13.970286 11.410286l-22.198857 52.224-19.565714 44.580571-15.945143 35.437715-4.315429 9.472a5249.060571 5249.060571 0 0 0-45.056-150.272 19.894857 19.894857 0 0 0-2.486857 17.005714c15.030857 47.762286 29.220571 95.853714 42.532572 144.274286l-15.725715 34.084571a110.153143 110.153143 0 0 1-12.653714-5.668571c-6.582857-6.802286-11.446857-17.956571-15.652571-30.72-1.206857 14.445714 2.669714 28.891429 10.861714 40.155428-43.410286-9.435429-82.797714-3.291429-106.861714 29.622857-2.194286 3.035429-4.278857 6.217143-6.217143 9.435429 10.532571-11.117714 22.125714-14.774857 42.642286-9.984-32.365714 10.24-49.481143 22.564571-66.157715 44.617143a317.805714 317.805714 0 0 0-12.068571 17.554285c30.683429-26.404571 62.683429-30.061714 94.281143-18.029714l1.462857 0.658286c-29.696-0.731429-71.606857 17.334857-100.498286 43.483428-13.312 12.068571-25.856 26.697143-38.034286 44.251429-9.106286 13.129143-17.883429 27.794286-26.660571 44.470857-7.606857 14.372571-15.213714 30.134857-22.747429 47.286857 7.789714-2.889143 15.872-4.571429 24.064-5.010285l4.681143-0.292572 4.754286-0.073143c-28.781714 7.241143-48.786286 27.062857-64.841143 52.918857 7.789714-4.278857 20.406857-9.581714 34.779429-10.861714l2.925714-0.219428 4.534857 0.073142c-9.947429 2.852571-18.651429 6.509714-26.331428 11.300572-4.022857 2.56-7.936 5.485714-11.629715 8.630857l-4.242285 3.876571a83.858286 83.858286 0 0 0-6.217143 6.729143l-2.889143 3.766857c-0.914286 1.243429-1.828571 2.304-2.56 3.584l-3.401143 5.339429a313.782857 313.782857 0 0 0-11.410286 19.931429l-6.692571 13.531428-3.547429 8.301714-2.267428 6.326858a48.64 48.64 0 0 0-0.731429 2.377142 15.981714 15.981714 0 0 1 3.510857-1.828571c7.387429-3.437714 18.870857-5.888 29.257143-6.948571l6.034286-0.438858c0.146286 0 0.256 0 0.438857-0.146285h2.194286c-23.405714 7.826286-34.742857 16.457143-46.262857 29.915428-13.531429 16.457143-26.038857 33.901714-37.485715 52.224-8.594286 13.531429-16.457143 26.989714-22.528 39.204572-3.547429 7.058286-6.765714 14.262857-9.654857 21.650285a286.537143 286.537143 0 0 0-5.595428 16.457143c10.093714-0.219429 20.955429-0.329143 31.853714-0.256l-16.274286 0.146286c-5.376 0.036571-10.605714 0.146286-15.725714 0.292571-10.825143 36.205714-8.118857 60.928-5.12 73.362286l1.28 4.571429 1.060571 3.072 2.925715 6.656 2.742857 5.12c6.985143 12.214857 21.138286 30.098286 40.594285 21.065143 8.886857-4.096 22.089143-13.970286 38.253715-28.525715l11.190857-10.422857 5.888-5.705143 12.361143-12.397714-16.713143-53.028571c-12.946286 15.689143-26.587429 30.610286-40.850286 44.726857l-12.580571 11.995428 10.605714-10.971428 7.021714-7.643429 12.507429-14.445714 9.691428-11.702857 10.752-13.494857 6.4-8.228572 13.714286-18.285714 7.314286-9.947429c0.548571-0.731429 1.133714-1.389714 1.536-2.194285a1876.224 1876.224 0 0 0 54.125714-79.981715l8.118857-12.690285 16.786286-27.062858h0.512l0.073143-0.841142 13.897143-23.076572 11.410285-19.529143 6.070858-10.130285 18.139428-31.926858a3667.492571 3667.492571 0 0 0 75.702857-142.482285l14.262857-28.708572c0.402286-0.621714 0.694857-1.462857 1.133715-2.084571l21.723428-44.726857 14.372572-30.244572 7.094857-15.250285 15.725714-34.377143c2.304 2.523429 4.864 4.754286 7.606857 6.656l-17.188571 36.461714-17.737143 36.571429-4.242286 8.557714 0.036572 0.438857-16.896 34.377143-27.209143 53.467428a3455.122286 3455.122286 0 0 1-69.412572 128.146286c-8.045714 14.116571-16.347429 28.16-24.502857 42.130286l-16.822857 27.794286-8.704 14.153142h-0.182857l-25.124571 38.948572c-9.033143 13.641143-17.993143 26.88-26.989715 39.862857-18.249143 26.258286-37.522286 51.565714-57.782857 75.885714l16.786286 52.882286 6.217143-6.509714c8.338286-8.740571 16.566857-17.627429 24.649143-26.660572l9.654857-10.971428 20.004571-23.222857c12.141714-14.555429 24.027429-29.403429 35.693714-44.434286l18.285715-23.990857v-0.292572c0.512-0.731429 1.024-1.609143 1.718857-2.340571 8.667429-11.812571 17.481143-23.734857 26.038857-36.022857 10.861714-15.469714 21.467429-31.195429 31.744-47.177143l17.298286-27.501714 2.048-3.401143c16.457143-27.209143 31.707429-55.296 45.604571-84.224l8.228572-17.664 3.803428-8.484572c3.145143-7.131429 6.107429-14.445714 9.033143-21.613714 6.838857-16.932571 12.946286-34.011429 18.395429-51.2l-0.036572-0.182857 0.841143-2.121143c3.510857-11.081143 6.582857-22.235429 9.435429-33.426286 4.534857-6.363429 9.801143-11.885714 15.689142-16.822857 1.353143 1.901714 2.779429 3.766857 4.242286 5.595429a203.264 203.264 0 0 0-26.770286 80.822857c-1.718857 18.139429-1.536 36.388571 0.512 54.454857 1.499429 14.628571 4.096 29.988571 7.753143 46.592 3.145143 14.372571 7.058286 29.622857 11.776 45.641143 2.962286-6.765714 7.168-13.421714 12.324572-19.931429l2.816-3.437714 2.962285-3.437714c-14.08 24.649143-15.798857 51.090286-11.629714 78.518857 3.584-11.337143 8.996571-21.869714 15.945143-31.085714l1.718857-2.084572 1.828572-2.121143c0.365714-0.256 0.621714-0.658286 1.097142-1.024a116.992 116.992 0 0 0-11.629714 30.829715c-0.512 2.742857-0.950857 5.485714-1.243428 8.228571l-0.585143 5.339429-0.219429 6.509714 0.292572 6.436571c0.073143 1.462857 0.109714 2.779429 0.329142 4.132572l0.877715 5.632c1.024 6.948571 2.304 13.787429 3.803428 20.589714l2.852572 11.702857 0.438857 1.499429c0.877714 2.925714 1.572571 5.485714 2.340571 7.68 0.877714 2.56 1.828571 5.12 2.925715 7.606857a18.066286 18.066286 0 0 1 1.133714-3.657143c2.779429-7.314286 8.594286-16.896 14.555428-24.758857l3.547429-4.498286c0.109714-0.109714 0.256-0.182857 0.256-0.365714l1.28-1.572572c-10.313143 21.211429-12.653714 34.596571-12.507429 51.126858 0.585143 19.821714 2.304 39.533714 5.193143 59.062857 1.901714 13.604571 4.388571 27.062857 7.533715 40.374857 1.645714 6.948571 3.620571 13.714286 5.851428 20.406857 1.718857 4.864 3.584 9.618286 5.595429 14.299429l-0.036572 0.146285c12.251429 28.233143 26.331429 42.020571 35.291429 48.420572l3.766857 2.450285 2.852571 1.572572 5.12 2.121143 4.205715 1.389714c2.486857 0.694857 5.485714 1.389714 8.777143 1.792l3.291428 0.256z'
              fill='#E15F2A'
            ></path>
            <path
              d='M576 828.16l0.109714 2.048 0.402286 8.850286 0.548571 16.091428 0.219429 13.933715v11.885714l-0.256 9.874286-0.512 10.752 0.987429-11.008c0.987429-14.445714 1.499429-29.622857 1.462857-45.348572l-0.182857-16.018286 39.753142 21.613715-0.987428 17.627428c-2.121143 30.939429-5.705143 54.052571-10.057143 65.609143-4.754286 12.690286-14.555429 16.457143-23.844571 16.749714h-3.072l-3.364572-0.292571a54.564571 54.564571 0 0 1-6.070857-1.097143l-2.669714-0.731428-4.205715-1.353143-5.12-2.121143-2.852571-1.572572-3.766857-2.450285c-8.923429-6.4-23.04-20.187429-35.254857-48.566857l-3.364572-8.411429 62.061715-56.064zM138.422857 804.571429l0.731429 2.523428-3.218286 4.132572-10.752 13.494857-9.691429 11.702857-12.507428 14.445714-7.021714 7.68-10.605715 10.934857 12.580572-11.995428c9.508571-9.398857 18.724571-19.2 27.684571-29.293715l13.165714-15.433142 16.713143 53.028571-15.323428 15.286857-14.116572 13.238857c-16.164571 14.555429-29.366857 24.429714-38.253714 28.525715-18.176 8.411429-31.670857-6.582857-39.131429-18.541715l-1.462857-2.523428-2.706285-5.12-2.962286-6.656-1.097143-3.072-1.243429-4.571429c-2.779429-11.556571-5.339429-33.645714 2.998858-65.755428l2.084571-7.533715 7.789714-0.256 7.972572-0.109714 16.274285-0.146286h-10.861714l-12.397714 0.109715L138.459429 804.571429z'
              fill='#F79A23'
            ></path>
            <path
              d='M550.656 73.142857c-15.506286 37.302857-31.378286 74.422857-47.616 111.323429l-24.685714 55.222857 7.936 28.818286c10.971429-5.302857 22.198857-19.163429 33.572571-40.009143-4.937143 18.578286-10.532571 35.84-20.626286 45.348571 3.949714-1.938286 14.628571-5.705143 33.974858-3.364571-13.970286 4.571429-25.051429 10.130286-30.976 17.444571 13.421714 17.590857 33.901714 29.805714 57.526857 39.716572l8.009143 3.254857-8.155429 0.621714-6.582857 0.109714a81.188571 81.188571 0 0 1-21.248-2.56l-4.754286-1.718857 7.606857 14.043429c4.315429 8.338286 8.411429 16.822857 12.251429 25.526857l5.668571 13.165714 0.621715 1.828572c4.169143 9.874286 8.045714 19.785143 11.629714 29.878857l5.229714 15.323428 6.290286 19.931429a945.700571 945.700571 0 0 1 20.882286 88.32l4.315428 24.941714 4.315429 29.403429c2.340571 17.225143 4.388571 34.523429 6.107428 51.894857 0.914286 9.142857 2.633143 30.72 5.156572 64.694857-10.788571-21.942857-19.309714-37.814857-25.526857-47.542857a637.988571 637.988571 0 0 0-36.022858-48.749714c-2.56-14.262857-4.973714-28.708571-7.68-42.971429l-4.205714-22.052571-4.388571-21.942858-9.033143-42.861714-4.681143-21.211428-4.754286-20.992-12.434285-52.699429-8.374858-33.499429-0.109714-0.073142-2.084571-8.411429-6.180572-23.881143-4.754285-2.56-4.754286-2.377143 7.862857 29.44 12.617143 49.700572 7.168 29.476571 6.656 28.196572 6.582857 28.818285 6.326857 29.220572 8.192 39.277714 4.973714 25.234286 4.681143 25.234285 3.547429 20.626286c-4.022857 3.364571-10.605714 13.970286-19.821714 31.817143a625.737143 625.737143 0 0 0-25.307429 55.844571l-5.083429 6.436572a111.542857 111.542857 0 0 0-14.555428 24.758857 18.066286 18.066286 0 0 0-1.097143 3.657143 82.176 82.176 0 0 1-2.925714-7.643429l-1.170286-3.547428-1.645714-5.632-2.852572-11.666286-2.084571-10.24-2.596572-15.981714-0.365714-4.132572-0.256-6.436571 0.219429-6.509714 0.585143-5.339429c0.292571-2.742857 0.731429-5.485714 1.243428-8.228571a116.992 116.992 0 0 1 11.629714-30.866286l-1.097142 1.060571-1.828572 2.121143-1.718857 2.121143c-6.948571 9.142857-12.361143 19.712-15.945143 31.085714-3.766857-24.978286-2.706286-49.115429 8.118857-71.789714l3.510857-6.765714-2.962285 3.437714-2.816 3.437714c-5.156571 6.509714-9.362286 13.165714-12.324572 19.931429a654.994286 654.994286 0 0 1-11.776-45.641143c-3.657143-16.603429-6.253714-31.963429-7.753143-46.592a263.094857 263.094857 0 0 1-0.512-54.418286c3.254857-28.928 12.434286-56.612571 26.770286-80.859428a125.44 125.44 0 0 1-4.242286-5.595429c-5.888 4.937143-11.154286 10.459429-15.725714 16.822857-1.865143 7.460571-3.876571 14.884571-6.034286 22.308572l-3.364571 11.117714-0.841143 2.121143c-5.412571 17.371429-11.52 34.450286-18.358857 51.382857-2.925714 7.168-5.888 14.482286-9.033143 21.577143l-3.803428 8.521143-8.228572 17.664a1000.813714 1000.813714 0 0 1-33.462857 63.634285l-14.189714 23.990858-17.298286 27.501714c-10.276571 15.981714-20.845714 31.707429-31.744 47.177143-8.557714 12.288-17.371429 24.210286-26.038857 36.022857l-0.914286 1.170286-0.841143 1.170285 0.073143 0.292572-7.606857 9.910857a333.750857 333.750857 0 0 0-2.121143-44.836572 296.96 296.96 0 0 0-8.118857-42.422857l5.302857-8.557714 16.822857-27.830857c8.155429-13.970286 16.457143-28.013714 24.502857-42.130286 16.018286-28.086857 31.597714-56.466286 46.848-85.065143l22.564572-43.081143 27.209143-53.467428 16.896-34.377143V357.668571l4.205714-8.521142 17.737143-36.608 17.188571-36.461715a44.544 44.544 0 0 1-5.193143-4.242285l-2.413714-2.413715-15.725714 34.377143-7.094857 15.250286-14.372572 30.244571-21.723428 44.726857-1.097143 2.084572-14.299429 28.708571a3674.770286 3674.770286 0 0 1-59.977143 114.102857l-15.725714 28.379429-18.139428 31.926857-6.070858 10.130286-11.446857 19.529143-8.411428 14.189714c-7.314286-0.731429-18.541714-0.365714-33.645715 1.097143-15.104 1.426286-32.036571 3.328-50.834285 5.741714h-8.155429c-8.301714 0.841143-17.334857 2.56-24.393143 5.010286l-4.864 1.901714a15.981714 15.981714 0 0 0-3.510857 1.865143l0.731429-2.377143 2.267428-6.326857 3.547429-8.265143 6.692571-13.568 5.522286-10.093714 5.851429-9.874286 3.401142-5.302857 2.596572-3.584 2.925714-3.766857 3.035429-3.510857 3.145143-3.218286 4.242285-3.876571c3.693714-3.181714 7.570286-6.034286 11.629715-8.630858 5.741714-3.620571 12.068571-6.582857 19.090285-9.033142l7.241143-2.267429-4.534857-0.073143-2.925714 0.219429c-14.372571 1.28-26.989714 6.582857-34.742857 10.861714 14.701714-23.734857 32.731429-42.349714 57.782857-50.834286l7.021714-2.084571-4.754286 0.073143-4.681143 0.292571a82.944 82.944 0 0 0-24.064 5.010286c7.533714-17.188571 15.140571-32.914286 22.747429-47.286857 8.777143-16.676571 17.554286-31.341714 26.697143-44.470857 12.141714-17.554286 24.685714-32.182857 38.034286-44.251429 26.806857-24.283429 64.841143-41.618286 93.915428-43.373714l6.582857-0.109715-1.462857-0.658285c-31.634286-12.068571-63.634286-8.411429-94.281143 18.029714a317.805714 317.805714 0 0 1 12.068572-17.554286c16.64-22.052571 33.755429-34.377143 66.121143-44.617143-20.48-4.790857-32.109714-1.133714-42.678858 9.984 1.974857-3.254857 4.059429-6.4 6.217143-9.435428 24.100571-32.914286 63.488-39.058286 106.898286-29.622857a60.269714 60.269714 0 0 1-10.861714-40.155429c4.205714 12.763429 9.069714 23.917714 15.652571 30.72 2.925714 1.462857 5.741714 2.852571 8.521143 4.022857l4.132571 1.645715 15.725715-34.084572a4135.350857 4135.350857 0 0 0-42.532572-144.274286 19.894857 19.894857 0 0 1 2.486857-17.005714c16.457143 52.297143 31.634286 102.619429 45.056 150.272l4.315429-9.508571 15.945143-35.401143 19.565714-44.580572 22.198857-52.224A18.505143 18.505143 0 0 1 550.656 73.142857z'
              fill='#CA2137'
            ></path>
            <path
              d='M489.984 343.917714l-7.862857-29.44c3.218286 1.499429 6.4 3.145143 9.508571 4.937143l6.180572 23.917714 2.084571 8.374858 52.662857 28.379428a489.325714 489.325714 0 0 0-17.92-38.692571l-7.606857-14.043429c7.387429 3.328 17.627429 4.242286 25.965714 4.278857l6.582858-0.109714 8.192-0.621714c-26.989714-10.532571-50.614857-23.405714-65.536-42.971429 5.924571-7.314286 17.005714-12.873143 30.976-17.444571-19.309714-2.340571-30.025143 1.426286-33.974858 3.364571 10.093714-9.508571 15.725714-26.770286 20.626286-45.348571-11.337143 20.845714-22.601143 34.706286-33.572571 40.009143l-7.936-28.818286A5705.398857 5705.398857 0 0 0 550.656 73.142857a18.505143 18.505143 0 0 0-13.970286 11.410286l-22.198857 52.224-19.565714 44.580571-15.945143 35.437715-4.315429 9.472a5249.060571 5249.060571 0 0 0-45.056-150.272 19.894857 19.894857 0 0 0-2.486857 17.005714c15.030857 47.762286 29.220571 95.853714 42.532572 144.274286l-15.725715 34.084571a110.153143 110.153143 0 0 1-12.653714-5.668571c-6.582857-6.802286-11.446857-17.956571-15.652571-30.72-1.206857 14.445714 2.669714 28.891429 10.861714 40.155428-43.410286-9.435429-82.797714-3.291429-106.861714 29.622857-2.194286 3.035429-4.278857 6.217143-6.217143 9.435429 10.532571-11.117714 22.125714-14.774857 42.642286-9.984-32.365714 10.24-49.481143 22.564571-66.157715 44.617143a317.805714 317.805714 0 0 0-12.068571 17.554285c30.683429-26.404571 62.683429-30.061714 94.281143-18.029714l24.795428 0.987429 14.372572-30.244572 7.094857-15.250285 15.725714-34.377143c2.304 2.523429 4.864 4.754286 7.606857 6.656l-17.188571 36.461714-17.737143 36.571429-4.242286 8.557714 17.078857 85.321143c6.326857-16.64 11.264-32.877714 14.774858-48.676572 4.534857-6.363429 9.801143-11.885714 15.689142-16.822857 0.914286 1.28 2.340571 3.145143 4.242286 5.595429l25.673143-39.204572z'
              fill='#81277A'
            ></path>
            <path
              d='M946.285714 950.784c10.130286 0.475429 21.613714-2.633143 26.916572-16.713143 4.352-11.556571 7.936-34.669714 10.057143-65.609143l0.987428-17.627428-39.753143-21.577143c0.512 21.540571 0.073143 42.057143-1.28 61.330286l-0.987428 11.446857 0.512-11.154286 0.219428-9.874286 0.036572-11.922285-0.219429-13.970286-0.548571-16.091429a1021.732571 1021.732571 0 0 0-0.365715-8.777143l-1.206857-19.931428-1.901714-24.685714a1861.741714 1861.741714 0 0 0-10.057143-88.210286l-1.974857-13.641143-4.388571-28.781714 0.365714-0.365715-0.438857-0.475428-4.022857-24.246857-5.339429-30.793143a2504.009143 2504.009143 0 0 0-9.654857-50.468572l-8.192-39.314285-6.326857-29.257143-6.582857-28.781714-6.656-28.16-7.168-29.513143-12.617143-49.737143-7.862857-29.403429c3.218286 1.499429 6.4 3.145143 9.508571 4.937143l6.180571 23.917714 2.084572 8.374858 0.109714 0.073142 8.374857 33.499429 12.434286 52.662857c3.291429 13.970286 6.326857 28.013714 9.435429 42.24l8.996571 42.861714c3.035429 14.628571 5.888 29.257143 8.630857 43.995429 2.742857 14.482286 5.229714 29.184 7.789714 43.629714l3.547429 21.357715 3.657143 22.893714-0.146286 0.073143 5.668572 42.057143c1.792 14.665143 3.437714 29.366857 4.973714 44.032 3.035429 29.257143 4.900571 58.697143 5.595428 88.137142l39.68 21.577143 0.402286-8.411428 0.621714-22.308572 0.146286-11.702857c0.073143-14.08 0-28.196571-0.219428-42.313143l-0.841143-27.721143c-0.182857-4.681143-0.365714-9.472-0.621715-14.262857l-1.024-18.505143-1.316571-20.297142-0.182857-0.146286c-0.109714-0.841143-0.219429-1.828571-0.182857-2.779429-1.097143-13.458286-2.084571-27.026286-3.474286-40.740571a1411.401143 1411.401143 0 0 0-6.107429-51.931429l-4.315428-29.366857-0.585143-3.547428a947.419429 947.419429 0 0 0-24.612571-109.714286l-6.290286-19.931429c-5.046857-15.433143-10.605714-30.427429-16.64-45.056l-0.219429-0.146285-0.621714-1.828572a489.325714 489.325714 0 0 0-17.92-38.692571l-7.606857-14.043429c7.387429 3.328 17.627429 4.242286 25.965714 4.278857l6.582857-0.109714 8.192-0.621714c-26.989714-10.532571-50.614857-23.405714-65.536-42.971429 5.924571-7.314286 17.005714-12.873143 30.976-17.444571-19.309714-2.340571-30.025143 1.426286-33.974857 3.364571 10.093714-9.508571 15.725714-26.770286 20.626286-45.348571-11.337143 20.845714-22.601143 34.706286-33.572572 40.009143l-7.936-28.818286A5705.398857 5705.398857 0 0 0 916.370286 73.142857a18.505143 18.505143 0 0 0-13.970286 11.410286l-22.198857 52.224-19.565714 44.580571-15.945143 35.437715-4.315429 9.472a5249.060571 5249.060571 0 0 0-45.056-150.272 19.894857 19.894857 0 0 0-2.486857 17.005714c15.030857 47.762286 29.220571 95.853714 42.532571 144.274286l-15.725714 34.084571a110.153143 110.153143 0 0 1-12.653714-5.668571c-6.582857-6.802286-11.446857-17.956571-15.652572-30.72-1.206857 14.445714 2.669714 28.891429 10.861715 40.155428-43.410286-9.435429-82.797714-3.291429-106.861715 29.622857-2.194286 3.035429-4.278857 6.217143-6.217142 9.435429 10.532571-11.117714 22.125714-14.774857 42.642285-9.984-32.365714 10.24-49.481143 22.564571-66.157714 44.617143a317.805714 317.805714 0 0 0-12.068571 17.554285c30.683429-26.404571 62.683429-30.061714 94.281142-18.029714l1.462858 0.658286c-29.696-0.731429-71.606857 17.334857-100.498286 43.483428-13.312 12.068571-25.856 26.697143-38.034286 44.251429-9.106286 13.129143-17.883429 27.794286-26.660571 44.470857-7.606857 14.372571-15.213714 30.134857-22.747429 47.286857 7.789714-2.889143 15.872-4.571429 24.064-5.010285l4.681143-0.292572 4.754286-0.073143c-28.781714 7.241143-48.786286 27.062857-64.841143 52.918857 7.789714-4.278857 20.406857-9.581714 34.779428-10.861714l2.925715-0.219428 4.534857 0.073142c-9.947429 2.852571-18.651429 6.509714-26.331429 11.300572-4.022857 2.56-7.936 5.485714-11.629714 8.630857l-4.242286 3.876571a83.858286 83.858286 0 0 0-6.217143 6.729143l-2.889142 3.766857c-0.914286 1.243429-1.828571 2.304-2.56 3.584l-3.401143 5.339429a313.782857 313.782857 0 0 0-11.410286 19.931429l-6.692571 13.531428-3.547429 8.301714-2.267429 6.326858a48.64 48.64 0 0 0-0.731428 2.377142 15.981714 15.981714 0 0 1 3.510857-1.828571c7.387429-3.437714 18.870857-5.888 29.257143-6.948571l6.034286-0.438858c0.146286 0 0.256 0 0.438857-0.146285h2.194285c-23.405714 7.826286-34.742857 16.457143-46.262857 29.915428-13.531429 16.457143-26.038857 33.901714-37.485714 52.224-8.594286 13.531429-16.457143 26.989714-22.528 39.204572-3.547429 7.058286-6.765714 14.262857-9.654857 21.650285a286.537143 286.537143 0 0 0-5.595429 16.457143c10.093714-0.219429 20.955429-0.329143 31.853715-0.256l-16.274286 0.146286c-5.376 0.036571-10.605714 0.146286-15.725714 0.292571-10.825143 36.205714-8.118857 60.928-5.12 73.362286l1.28 4.571429 1.060571 3.072 2.925714 6.656 2.742857 5.12c6.985143 12.214857 21.138286 30.098286 40.594286 21.065143 8.886857-4.096 22.089143-13.970286 38.253714-28.525715l11.190858-10.422857 5.888-5.705143 12.361142-12.397714-16.713142-53.028571c-12.946286 15.689143-26.587429 30.610286-40.850286 44.726857l-12.580572 11.995428 10.605715-10.971428 7.021714-7.643429 12.507429-14.445714 9.691428-11.702857 10.752-13.494857 6.4-8.228572 13.714286-18.285714 7.314286-9.947429c0.548571-0.731429 1.133714-1.389714 1.536-2.194285a1876.224 1876.224 0 0 0 54.125714-79.981715l8.118857-12.690285 16.786286-27.062858h0.512l0.073143-0.841142 13.897142-23.076572 11.410286-19.529143 6.070857-10.130285 18.139429-31.926858a3667.492571 3667.492571 0 0 0 75.702857-142.482285l14.262857-28.708572c0.402286-0.621714 0.694857-1.462857 1.133714-2.084571l21.723429-44.726857 14.372571-30.244572 7.094858-15.250285 15.725714-34.377143c2.304 2.523429 4.864 4.754286 7.606857 6.656l-17.188571 36.461714-17.737143 36.571429-4.242286 8.557714 0.036571 0.438857-16.896 34.377143-27.209142 53.467428a3455.122286 3455.122286 0 0 1-69.412572 128.146286c-8.045714 14.116571-16.347429 28.16-24.502857 42.130286l-16.822857 27.794286-8.704 14.153142h-0.182857l-25.124572 38.948572c-9.033143 13.641143-17.993143 26.88-26.989714 39.862857-18.249143 26.258286-37.522286 51.565714-57.782857 75.885714l16.786286 52.882286 6.217142-6.509714c8.338286-8.740571 16.566857-17.627429 24.649143-26.660572l9.654857-10.971428 20.004572-23.222857c12.141714-14.555429 24.027429-29.403429 35.693714-44.434286l18.285714-23.990857v-0.292572c0.512-0.731429 1.024-1.609143 1.718858-2.340571 8.667429-11.812571 17.481143-23.734857 26.038857-36.022857 10.861714-15.469714 21.467429-31.195429 31.744-47.177143l17.298285-27.501714 2.048-3.401143c16.457143-27.209143 31.707429-55.296 45.604572-84.224l8.228571-17.664 3.803429-8.484572c3.145143-7.131429 6.107429-14.445714 9.033143-21.613714 6.838857-16.932571 12.946286-34.011429 18.395428-51.2l-0.036571-0.182857 0.841143-2.121143c3.510857-11.081143 6.582857-22.235429 9.435428-33.426286 4.534857-6.363429 9.801143-11.885714 15.689143-16.822857 1.353143 1.901714 2.779429 3.766857 4.242286 5.595429a203.264 203.264 0 0 0-26.770286 80.822857c-1.718857 18.139429-1.536 36.388571 0.512 54.454857 1.499429 14.628571 4.096 29.988571 7.753143 46.592 3.145143 14.372571 7.058286 29.622857 11.776 45.641143 2.962286-6.765714 7.168-13.421714 12.324571-19.931429l2.816-3.437714 2.962286-3.437714c-14.08 24.649143-15.798857 51.090286-11.629714 78.518857 3.584-11.337143 8.996571-21.869714 15.945143-31.085714l1.718857-2.084572 1.828571-2.121143c0.365714-0.256 0.621714-0.658286 1.097143-1.024a116.992 116.992 0 0 0-11.629714 30.829715c-0.512 2.742857-0.950857 5.485714-1.243429 8.228571l-0.585143 5.339429-0.219428 6.509714 0.292571 6.436571c0.073143 1.462857 0.109714 2.779429 0.329143 4.132572l0.877714 5.632c1.024 6.948571 2.304 13.787429 3.803429 20.589714l2.852571 11.702857 0.438858 1.499429c0.877714 2.925714 1.572571 5.485714 2.340571 7.68 0.877714 2.56 1.828571 5.12 2.925714 7.606857a18.066286 18.066286 0 0 1 1.133715-3.657143c2.779429-7.314286 8.594286-16.896 14.555428-24.758857l3.547429-4.498286c0.109714-0.109714 0.256-0.182857 0.256-0.365714l1.28-1.572572c-10.313143 21.211429-12.653714 34.596571-12.507429 51.126858 0.585143 19.821714 2.304 39.533714 5.193143 59.062857 1.901714 13.604571 4.388571 27.062857 7.533714 40.374857 1.645714 6.948571 3.620571 13.714286 5.851429 20.406857 1.718857 4.864 3.584 9.618286 5.595428 14.299429l-0.036571 0.146285c12.251429 28.233143 26.331429 42.020571 35.291429 48.420572l3.766857 2.450285 2.852571 1.572572 5.12 2.121143 4.205714 1.389714c2.486857 0.694857 5.485714 1.389714 8.777143 1.792l3.291429 0.256z'
              fill='#E15F2A'
            ></path>
            <path
              d='M941.714286 828.16l0.109714 2.048 0.402286 8.850286 0.548571 16.091428 0.219429 13.933715v11.885714l-0.256 9.874286-0.512 10.752 0.987428-11.008c0.987429-14.445714 1.499429-29.622857 1.462857-45.348572l-0.182857-16.018286 39.753143 21.613715-0.987428 17.627428c-2.121143 30.939429-5.705143 54.052571-10.057143 65.609143-4.754286 12.690286-14.555429 16.457143-23.844572 16.749714h-3.072l-3.364571-0.292571a54.564571 54.564571 0 0 1-6.070857-1.097143l-2.669715-0.731428-4.205714-1.353143-5.12-2.121143-2.852571-1.572572-3.766857-2.450285c-8.923429-6.4-23.04-20.187429-35.254858-48.566857l-3.364571-8.411429 62.061714-56.064zM504.137143 804.571429l0.731428 2.523428-3.218285 4.132572-10.752 13.494857-9.691429 11.702857-12.507428 14.445714-7.021715 7.68-10.605714 10.934857 12.580571-11.995428c9.508571-9.398857 18.724571-19.2 27.684572-29.293715l13.165714-15.433142 16.713143 53.028571-15.323429 15.286857-14.116571 13.238857c-16.164571 14.555429-29.366857 24.429714-38.253714 28.525715-18.176 8.411429-31.670857-6.582857-39.131429-18.541715l-1.462857-2.523428-2.706286-5.12-2.962285-6.656-1.097143-3.072-1.243429-4.571429c-2.779429-11.556571-5.339429-33.645714 2.998857-65.755428l2.084572-7.533715 7.789714-0.256 7.972571-0.109714 16.274286-0.146286h-10.861714l-12.397714 0.109715L504.173714 804.571429z'
              fill='#F79A23'
            ></path>
            <path
              d='M916.370286 73.142857c-15.506286 37.302857-31.378286 74.422857-47.616 111.323429l-24.685715 55.222857 7.936 28.818286c10.971429-5.302857 22.198857-19.163429 33.572572-40.009143-4.937143 18.578286-10.532571 35.84-20.626286 45.348571 3.949714-1.938286 14.628571-5.705143 33.974857-3.364571-13.970286 4.571429-25.051429 10.130286-30.976 17.444571 13.421714 17.590857 33.901714 29.805714 57.526857 39.716572l8.009143 3.254857-8.155428 0.621714-6.582857 0.109714a81.188571 81.188571 0 0 1-21.248-2.56l-4.754286-1.718857 7.606857 14.043429c4.315429 8.338286 8.411429 16.822857 12.251429 25.526857l5.668571 13.165714 0.621714 1.828572c4.169143 9.874286 8.045714 19.785143 11.629715 29.878857l5.229714 15.323428 6.290286 19.931429a945.700571 945.700571 0 0 1 20.882285 88.32l4.315429 24.941714 4.315428 29.403429c2.340571 17.225143 4.388571 34.523429 6.107429 51.894857 0.914286 9.142857 2.633143 30.72 5.156571 64.694857-10.788571-21.942857-19.309714-37.814857-25.526857-47.542857a637.988571 637.988571 0 0 0-36.022857-48.749714c-2.56-14.262857-4.973714-28.708571-7.68-42.971429l-4.205714-22.052571-4.388572-21.942858-9.033142-42.861714-4.681143-21.211428-4.754286-20.992-12.434286-52.699429-8.374857-33.499429-0.109714-0.073142-2.084572-8.411429-6.180571-23.881143-4.754286-2.56-4.754285-2.377143 7.862857 29.44 12.617143 49.700572 7.168 29.476571 6.656 28.196572 6.582857 28.818285 6.326857 29.220572 8.192 39.277714 4.973714 25.234286 4.681143 25.234285 3.547429 20.626286c-4.022857 3.364571-10.605714 13.970286-19.821715 31.817143a625.737143 625.737143 0 0 0-25.307428 55.844571l-5.083429 6.436572a111.542857 111.542857 0 0 0-14.555428 24.758857 18.066286 18.066286 0 0 0-1.097143 3.657143 82.176 82.176 0 0 1-2.925715-7.643429l-1.170285-3.547428-1.645715-5.632-2.852571-11.666286-2.084571-10.24-2.596572-15.981714-0.365714-4.132572-0.256-6.436571 0.219428-6.509714 0.585143-5.339429c0.292571-2.742857 0.731429-5.485714 1.243429-8.228571a116.992 116.992 0 0 1 11.629714-30.866286l-1.097143 1.060571-1.828571 2.121143-1.718857 2.121143c-6.948571 9.142857-12.361143 19.712-15.945143 31.085714-3.766857-24.978286-2.706286-49.115429 8.118857-71.789714l3.510857-6.765714-2.962286 3.437714-2.816 3.437714c-5.156571 6.509714-9.362286 13.165714-12.324571 19.931429a654.994286 654.994286 0 0 1-11.776-45.641143c-3.657143-16.603429-6.253714-31.963429-7.753143-46.592a263.094857 263.094857 0 0 1-0.512-54.418286c3.254857-28.928 12.434286-56.612571 26.770286-80.859428a125.44 125.44 0 0 1-4.242286-5.595429c-5.888 4.937143-11.154286 10.459429-15.725714 16.822857-1.865143 7.460571-3.876571 14.884571-6.034286 22.308572l-3.364571 11.117714-0.841143 2.121143c-5.412571 17.371429-11.52 34.450286-18.358857 51.382857-2.925714 7.168-5.888 14.482286-9.033143 21.577143l-3.803429 8.521143-8.228571 17.664a1000.813714 1000.813714 0 0 1-33.462857 63.634285l-14.189715 23.990858-17.298285 27.501714c-10.276571 15.981714-20.845714 31.707429-31.744 47.177143-8.557714 12.288-17.371429 24.210286-26.038857 36.022857l-0.914286 1.170286-0.841143 1.170285 0.073143 0.292572-7.606857 9.910857a333.750857 333.750857 0 0 0-2.121143-44.836572 296.96 296.96 0 0 0-8.118857-42.422857l5.302857-8.557714 16.822857-27.830857c8.155429-13.970286 16.457143-28.013714 24.502857-42.130286 16.018286-28.086857 31.597714-56.466286 46.848-85.065143l22.564572-43.081143 27.209142-53.467428 16.896-34.377143V357.668571l4.205715-8.521142 17.737143-36.608 17.188571-36.461715a44.544 44.544 0 0 1-5.193143-4.242285l-2.413714-2.413715-15.725714 34.377143-7.094858 15.250286-14.372571 30.244571-21.723429 44.726857-1.097142 2.084572-14.299429 28.708571a3674.770286 3674.770286 0 0 1-59.977143 114.102857l-15.725714 28.379429-18.139429 31.926857-6.070857 10.130286-11.446857 19.529143-8.411429 14.189714c-7.314286-0.731429-18.541714-0.365714-33.645714 1.097143-15.104 1.426286-32.036571 3.328-50.834286 5.741714h-8.155428c-8.301714 0.841143-17.334857 2.56-24.393143 5.010286l-4.864 1.901714a15.981714 15.981714 0 0 0-3.510857 1.865143l0.731428-2.377143 2.267429-6.326857 3.547429-8.265143 6.692571-13.568 5.522286-10.093714 5.851428-9.874286 3.401143-5.302857 2.596572-3.584 2.925714-3.766857 3.035428-3.510857 3.145143-3.218286 4.242286-3.876571c3.693714-3.181714 7.570286-6.034286 11.629714-8.630858 5.741714-3.620571 12.068571-6.582857 19.090286-9.033142l7.241143-2.267429-4.534857-0.073143-2.925715 0.219429c-14.372571 1.28-26.989714 6.582857-34.742857 10.861714 14.701714-23.734857 32.731429-42.349714 57.782857-50.834286l7.021715-2.084571-4.754286 0.073143-4.681143 0.292571a82.944 82.944 0 0 0-24.064 5.010286c7.533714-17.188571 15.140571-32.914286 22.747429-47.286857 8.777143-16.676571 17.554286-31.341714 26.697143-44.470857 12.141714-17.554286 24.685714-32.182857 38.034285-44.251429 26.806857-24.283429 64.841143-41.618286 93.915429-43.373714l6.582857-0.109715-1.462857-0.658285c-31.634286-12.068571-63.634286-8.411429-94.281143 18.029714a317.805714 317.805714 0 0 1 12.068571-17.554286c16.64-22.052571 33.755429-34.377143 66.121143-44.617143-20.48-4.790857-32.109714-1.133714-42.678857 9.984 1.974857-3.254857 4.059429-6.4 6.217143-9.435428 24.100571-32.914286 63.488-39.058286 106.898286-29.622857a60.269714 60.269714 0 0 1-10.861715-40.155429c4.205714 12.763429 9.069714 23.917714 15.652572 30.72 2.925714 1.462857 5.741714 2.852571 8.521143 4.022857l4.132571 1.645715 15.725714-34.084572a4135.350857 4135.350857 0 0 0-42.532571-144.274286 19.894857 19.894857 0 0 1 2.486857-17.005714c16.457143 52.297143 31.634286 102.619429 45.056 150.272l4.315429-9.508571 15.945143-35.401143 19.565714-44.580572 22.198857-52.224A18.505143 18.505143 0 0 1 916.370286 73.142857z'
              fill='#CA2137'
            ></path>
            <path
              d='M855.698286 343.917714l-7.862857-29.44c3.218286 1.499429 6.4 3.145143 9.508571 4.937143l6.180571 23.917714 2.084572 8.374858 52.662857 28.379428a489.325714 489.325714 0 0 0-17.92-38.692571l-7.606857-14.043429c7.387429 3.328 17.627429 4.242286 25.965714 4.278857l6.582857-0.109714 8.192-0.621714c-26.989714-10.532571-50.614857-23.405714-65.536-42.971429 5.924571-7.314286 17.005714-12.873143 30.976-17.444571-19.309714-2.340571-30.025143 1.426286-33.974857 3.364571 10.093714-9.508571 15.725714-26.770286 20.626286-45.348571-11.337143 20.845714-22.601143 34.706286-33.572572 40.009143l-7.936-28.818286A5705.398857 5705.398857 0 0 0 916.370286 73.142857a18.505143 18.505143 0 0 0-13.970286 11.410286l-22.198857 52.224-19.565714 44.580571-15.945143 35.437715-4.315429 9.472a5249.060571 5249.060571 0 0 0-45.056-150.272 19.894857 19.894857 0 0 0-2.486857 17.005714c15.030857 47.762286 29.220571 95.853714 42.532571 144.274286l-15.725714 34.084571a110.153143 110.153143 0 0 1-12.653714-5.668571c-6.582857-6.802286-11.446857-17.956571-15.652572-30.72-1.206857 14.445714 2.669714 28.891429 10.861715 40.155428-43.410286-9.435429-82.797714-3.291429-106.861715 29.622857-2.194286 3.035429-4.278857 6.217143-6.217142 9.435429 10.532571-11.117714 22.125714-14.774857 42.642285-9.984-32.365714 10.24-49.481143 22.564571-66.157714 44.617143a317.805714 317.805714 0 0 0-12.068571 17.554285c30.683429-26.404571 62.683429-30.061714 94.281142-18.029714l24.795429 0.987429 14.372571-30.244572 7.094858-15.250285 15.725714-34.377143c2.304 2.523429 4.864 4.754286 7.606857 6.656l-17.188571 36.461714-17.737143 36.571429-4.242286 8.557714 17.078857 85.321143c6.326857-16.64 11.264-32.877714 14.774857-48.676572 4.534857-6.363429 9.801143-11.885714 15.689143-16.822857 0.914286 1.28 2.340571 3.145143 4.242286 5.595429l25.673143-39.204572z'
              fill='#81277A'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const DSIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M268.126316 113.178947m83.536842 0l326.063158 0q83.536842 0 83.536842 83.536842l0 0q0 83.536842-83.536842 83.536843l-326.063158 0q-83.536842 0-83.536842-83.536843l0 0q0-83.536842 83.536842-83.536842Z'
              fill='#95CCEC'
            ></path>
            <path
              d='M268.126316 334.147368m83.536842 0l326.063158 0q83.536842 0 83.536842 83.536843l0 0q0 83.536842-83.536842 83.536842l-326.063158 0q-83.536842 0-83.536842-83.536842l0 0q0-83.536842 83.536842-83.536843Z'
              fill='#95CCEC'
            ></path>
            <path
              d='M543.258947 722.189474a839.653053 839.653053 0 0 0 27.987537-41.833095 471.729853 471.729853 0 0 0 7.248842-11.943074c1.315032-2.255495 3.443874-5.912253 4.527158-8.628547 1.827032-4.564884 4.085221-11.466105 4.688842-19.030232 0.555116-6.912 0.107789-19.8656-10.056758-30.030147-7.127579-7.127579-15.987874-11.436463-25.810189-11.953853-9.0624-0.476968-16.448674 2.417179-21.04859 4.71579l-0.266778 0.134737-26.473095 14.063831c-17.378358-15.351916-38.674863-20.485389-59.486316-18.690695-25.532632 2.2016-49.990063 14.546189-68.384337 28.340548-7.000926 5.252042-13.519495 10.760084-19.970695 16.211537-21.4016 18.084379-42.051368 35.535495-77.139536 40.879158A83.159579 83.159579 0 0 1 265.431579 638.652632c0-46.136589 37.400253-83.536842 83.536842-83.536843h326.063158c46.136589 0 83.536842 37.400253 83.536842 83.536843 0 46.136589-37.400253 83.536842-83.536842 83.536842h-131.772632z'
              fill='#95CCEC'
            ></path>
            <path
              d='M216.926316 210.189474l-59.284211-61.978948v41.8816C90.936589 192.916211 37.726316 247.888842 37.726316 315.284211c0 69.203537 56.101726 125.305263 125.305263 125.305263a20.210526 20.210526 0 0 0 0-40.421053C116.151242 400.168421 78.147368 362.164547 78.147368 315.284211c0-45.069474 35.125895-81.936168 79.494737-84.717137V272.168421l59.284211-61.978947z m649.431579 482.357894v-41.8816C933.060716 647.841684 986.273684 592.871747 986.273684 525.473684c0-69.203537-56.101726-125.305263-125.305263-125.305263a20.210526 20.210526 0 0 0 0 40.421053c46.880337 0 84.884211 38.003874 84.884211 84.88421 0 45.069474-35.125895 81.936168-79.494737 84.717137V568.589474l-59.284211 61.978947 59.284211 61.978947zM541.642105 625.178947l-43.115789 22.905264c-26.947368-40.421053-75.452632-25.6-107.789474-1.347369-5.680505 4.260379-11.358316 9.102821-17.302905 14.168926l-0.002695 0.002695C345.540716 684.684126 311.861895 713.393853 245.221053 710.063158c-48.462147-2.422568-56.589474-48.505263-43.11579-79.494737s20.210526-60.631579 12.126316-70.063158c-5.615832-6.5536-26.844968 9.008505-40.636632 19.119158C167.542568 584.065347 162.921095 587.452632 161.684211 587.452632c-1.344674 0-7.302737-3.128589-15.357306-7.351243-16.168421-8.483032-40.765979-21.390821-53.358484-22.290863-11.083453-0.792253-13.406316 43.045726 10.778947 66.021053 26.947368 25.6 30.989474 32.336842 41.768421 99.705263 13.295832 83.105684 109.136842 119.915789 109.136843 119.91579s4.042105-19.313179 6.736842-26.947369l8.08421 1.347369c-1.312337 15.758821-8.003368 37.276295-13.76741 55.821473-6.063158 19.509895-11.105011 35.732211-7.790485 38.494316 6.467368 5.389474 47.157895-12.126316 68.71579-32.336842 27.836632-26.095832 40.871074-58.386863 47.157895-75.452632h6.736842s-5.389474 25.6-14.821053 37.726316c26.947368-9.431579 70.063158-29.642105 106.442105-61.978947 45.7728-40.687832 96.234442-124.038737 98.357895-129.347369 2.694737-6.736842 5.389474-17.515789 0-22.905263-6.736842-6.736842-13.473684-5.389474-18.863158-2.694737z m-98.357894 56.589474c0 7.440168-5.429895 13.473684-12.126316 13.473684s-12.126316-6.033516-12.126316-13.473684 5.429895-13.473684 12.126316-13.473684 12.126316 6.033516 12.126316 13.473684z m13.646147 174.926147c0.501221-6.219453 0.493137-13.937179-1.519832-19.978779-4.042105-12.126316-12.126316-28.294737-12.126315-28.294736-0.218274 0-1.218021 0.913516-2.826779 2.379452l-0.002695 0.002695c-3.513937 3.204042-9.922021 9.046232-17.381053 13.786274-10.312758 6.5536-22.905263 10.778947-22.905263 10.778947l29.642105 17.51579 15.9744 9.248336c4.753516 2.751326 10.706189 0.035032 11.145432-5.437979zM437.894737 676.378947c0 2.977684-1.810863 5.389474-4.042105 5.389474s-4.042105-2.411789-4.042106-5.389474 1.810863-5.389474 4.042106-5.389473 4.042105 2.411789 4.042105 5.389473z'
              fill='#4396DA'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const LDAPIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M897.216 481.696c-5.696 16.736-24.64 30.304-42.304 30.304h-160L803.84 192h160c17.664 0 27.392 13.568 21.696 30.304l-88.352 259.392z'
              fill='#2E6FCD'
            ></path>
            <path d='M665.92 512h-192l108.992-320h192L665.92 512z' fill='#59B8FD'></path>
            <path d='M444.96 512h-192L361.92 192h192l-108.96 320z' fill='#2E6FCD'></path>
            <path
              d='M224 512H64c-17.664 0-27.392-13.568-21.696-30.304l88.32-259.392C136.384 205.568 155.328 192 172.992 192h160L224 512z'
              fill='#59B8FD'
            ></path>
            <path
              d='M171.072 756.704H22.336l64.16-222.176h48.768l-53.44 184.96h100l-10.752 37.216zM300.736 571.744l-42.656 147.712h26.24c45.376 1.6 74.944-22.816 88.672-73.28 15.648-51.2 0.32-76.032-45.984-74.432h-26.24z m-102.144 184.96l64.16-222.176h78.752c76.448 0.8 104.416 38.016 84 111.68-21.888 72.864-71.264 109.696-148.16 110.496H198.592zM458.56 756.704h-47.488l147.936-222.176h58.752l17.088 222.176h-50.016l-3.968-46.848H489.6l-31.04 46.848z m54.304-84.064h66.24l-3.84-94.88h-1.248l-61.152 94.88zM707.328 756.704h-48.736l64.16-222.176h71.264c63.552-0.8 88.224 22.016 73.952 68.448-14.144 43.2-47.392 66.048-99.744 68.448h-36.256l-24.64 85.28z m53.44-184.96l-18.048 62.464h15.008c32.384 3.2 51.648-7.232 57.76-31.232 6.24-21.632-7.008-32-39.744-31.232h-15.008z'
              fill='#2E6FCD'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const MetricsIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path d='M863 672.317H159V232.832h704z' fill='#E7F7FF'></path>
            <path
              d='M903 160.916H547V95.895c0-4.395-3.6-7.991-8-7.991h-56c-4.4 0-8 3.596-8 7.99v65.022H119c-17.7 0-32 14.283-32 31.962V712.27c0 17.68 14.3 31.963 32 31.963h356.4v31.963L310.6 884.169c-3.7 2.397-4.7 7.292-2.3 10.987l30.3 47.145v0.1c2.4 3.696 7.4 4.695 11.1 2.297L511 839.022l161.3 105.676c3.7 2.398 8.7 1.399 11.1-2.297v-0.1l30.3-47.145c2.4-3.695 1.3-8.59-2.3-10.987L547 776.495v-32.262h356c17.7 0 32-14.283 32-31.963V192.878c0-17.679-14.3-31.962-32-31.962z m-40 511.401H159V232.832h704v439.485z'
              fill='#1890FF'
            ></path>
            <path
              d='M322.4 591.911l101.8-101.68 86.1 86.099c3.1 3.096 8.2 3.096 11.3 0l226.3-226.236c3.1-3.096 3.1-8.19 0-11.286l-36.8-36.757c-3.1-3.097-8.2-3.097-11.3 0L516 485.835l-86.1-86.099c-3.1-3.096-8.2-3.096-11.3 0L274.3 543.868c-3.1 3.096-3.1 8.19 0 11.286l36.8 36.757c3.1 3.097 8.2 3.097 11.3 0z'
              fill='#66CCFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ResourceIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M403.2 130.133333h-187.733333c-46.933333 0-85.333333 38.4-85.333334 85.333334v187.733333c0 46.933333 38.4 85.333333 85.333334 85.333333h187.733333c46.933333 0 85.333333-38.4 85.333333-85.333333v-187.733333c0-49.066667-38.4-85.333333-85.333333-85.333334zM426.666667 390.4c0 19.2-17.066667 36.266667-36.266667 36.266667h-160c-21.333333 0-38.4-17.066667-38.4-36.266667v-162.133333c0-19.2 17.066667-36.266667 36.266667-36.266667h160c19.2 0 36.266667 17.066667 36.266666 36.266667v162.133333z'
              fill='#0171F1'
            ></path>
            <path
              d='M808.533333 130.133333h-187.733333c-46.933333 0-85.333333 38.4-85.333333 85.333334v187.733333c0 46.933333 38.4 85.333333 85.333333 85.333333h187.733333c46.933333 0 85.333333-38.4 85.333334-85.333333v-187.733333c0-49.066667-36.266667-85.333333-85.333334-85.333334zM832 390.4c0 19.2-17.066667 36.266667-36.266667 36.266667h-160c-19.2 0-36.266667-17.066667-36.266666-36.266667v-162.133333c-2.133333-19.2 14.933333-36.266667 34.133333-36.266667h160c19.2 0 36.266667 17.066667 36.266667 36.266667v162.133333zM403.2 535.466667h-187.733333c-46.933333 0-85.333333 38.4-85.333334 85.333333V810.666667c0 46.933333 38.4 85.333333 85.333334 85.333333h187.733333c46.933333 0 85.333333-38.4 85.333333-85.333333v-189.866667c0-46.933333-38.4-85.333333-85.333333-85.333333zM426.666667 795.733333c0 21.333333-17.066667 36.266667-36.266667 36.266667h-162.133333c-21.333333 0-36.266667-17.066667-36.266667-36.266667v-162.133333c0-21.333333 17.066667-36.266667 36.266667-36.266667h162.133333c19.2 0 36.266667 17.066667 36.266667 36.266667v162.133333z'
              fill='#55ABE5'
            ></path>
            <path
              d='M808.533333 535.466667h-187.733333c-46.933333 0-85.333333 38.4-85.333333 85.333333V810.666667c0 46.933333 38.4 85.333333 85.333333 85.333333h187.733333c46.933333 0 85.333333-38.4 85.333334-85.333333v-189.866667c0-46.933333-36.266667-85.333333-85.333334-85.333333zM832 795.733333c0 21.333333-17.066667 36.266667-36.266667 36.266667h-162.133333c-19.2 0-36.266667-17.066667-36.266667-36.266667v-162.133333c0-21.333333 17.066667-36.266667 36.266667-36.266667h162.133333c21.333333 0 36.266667 17.066667 36.266667 36.266667v162.133333z'
              fill='#0171F1'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const MenuIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M352.256 102.4H150.528c-51.2 0-92.672 38.4-92.672 89.6v204.8c0 51.2 41.472 89.6 89.6 89.6h204.8c51.2 0 89.6-41.472 89.6-89.6v-204.8c-0.512-51.2-38.4-89.6-89.6-89.6z m585.216 128L793.6 86.528c-35.328-35.328-92.672-35.328-128 0L521.728 230.4c-15.872 15.872-25.6 38.4-25.6 64s9.728 48.128 25.6 64L665.6 502.272c15.872 15.872 38.4 25.6 64 25.6s48.128-9.728 64-25.6L937.472 358.4c15.872-15.872 25.6-38.4 25.6-64 3.584-25.6-6.144-48.128-25.6-64zM352.256 582.656H150.528c-51.2 0-89.6 41.472-89.6 89.6v204.8c0 51.2 41.472 89.6 89.6 89.6h201.728c51.2 0 89.6-41.472 89.6-89.6v-204.8c-0.512-51.712-38.4-89.6-89.6-89.6z m479.744 0h-204.8c-51.2 0-89.6 41.472-89.6 89.6v204.8c0 51.2 41.472 89.6 89.6 89.6h204.8c51.2 0 89.6-41.472 89.6-89.6v-204.8c0-51.712-38.4-89.6-89.6-89.6z'
              fill='#0D65E5'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ButtonIcon = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        {...props}
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M329.4 460.5c10-2.3 16.3-12.2 14.1-22.3-4.7-21.1-5.5-42.7-2.1-64.3 14.6-94.2 103.1-159.1 197.4-144.5 22.2 3.4 43.2 11 62.3 22.4 8.9 5.3 20.3 2.4 25.5-6.4 5.3-8.8 2.4-20.3-6.4-25.6-23.3-13.9-48.7-23.1-75.7-27.3-114.5-17.7-222.2 61-239.9 175.6-4 26.2-3.2 52.5 2.6 78.2 1.9 8.7 9.6 14.6 18.2 14.6 1.3 0.1 2.7-0.1 4-0.4z'
              fill='#23dff9'
            ></path>
            <path
              d='M847.9 599.4c0-26.6-10.5-50.1-28-66.4 17.6-40.7 27.5-85.5 27.5-132.7 0-184.8-150.3-335.1-335.1-335.1S177.2 215.5 177.2 400.3c0 110.7 54.1 208.8 137 269.9 0.6 3.3 1.3 6.6 2.3 9.9 3.2 10.8 7.5 20.4 13 28.8 30.1 45.8 64.1 97.7 97.9 148.3 34.2 51.2 83.8 83.1 147.2 94.7 8 1.4 15.3 2.4 22.3 3.3 3.4 0.5 6.8 0.9 10.2 1.4 2.7 0.4 5.3 0.6 8 0.6h37.8c3 0 6-0.2 8.9-0.7 3.3-0.5 6.7-1.1 10-1.6 5.7-0.9 11.5-1.8 17.2-2.8 80.2-13.8 140.7-74.1 154.3-153.7 2.8-15.9 4.2-32 4.3-47.7 0.2-59.7 0.2-67.2 0.2-91.4 0.1-12.3 0.1-29.1 0.1-59.9z m-614.8-199c0-154.2 125-279.2 279.3-279.2 154.2 0 279.2 125 279.2 279.2 0 39.1-8.2 76.3-22.7 110.1-2.6-0.2-5.2-0.4-7.9-0.4-8.1 0-16 1.1-23.5 3.2-8.7-8.2-19.1-14.7-30.8-18.7-1.9-0.6-3.9-1.2-5.8-1.7 9.2-18.6 15.9-38.8 19.2-60.4 7.2-46.4-1-92.7-23.7-133.7-5-9-16.3-12.3-25.3-7.3-9 5-12.3 16.3-7.3 25.3 18.7 33.8 25.4 71.8 19.5 110-3.7 24.1-12.4 46.2-24.7 65.5-1.1 0.3-2.3 0.4-3.3 0.7-7.7-7-16.9-12.8-27.4-17.3-8-4.2-17-6.5-26.2-6.5h-1.9v-65c0-45.4-30.1-80.6-75-87.7-4.2-0.7-8.4-1-12.5-1-43.9 0-82.4 35.3-85.9 78.6-0.4 5.6-0.4 10.2-0.4 14V550c-17.4-10-33.1-22.9-46.2-38.6-6.6-7.9-18.3-8.9-26.2-2.3-7.9 6.6-8.9 18.3-2.3 26.2 9.1 10.9 19.3 20.6 30.2 29.3-22.6 5.8-42.5 20.2-54.8 40.5-0.5 0.8-0.8 1.6-1.3 2.4-56.8-51.1-92.3-125-92.3-207.1z m558.8 350.2c0 12.8-1.3 25.9-3.5 38.6-9.6 56.2-52.1 98.3-108.5 108-8.9 1.5-17.8 2.8-26.8 4.3h-37.8c-10.1-1.5-20.4-2.6-30.5-4.4-46.5-8.5-84.3-31-110.8-70.7-32.8-49.2-65.3-98.5-97.7-147.9-2.7-4.2-4.7-9-6.1-13.8-6.1-20.9 6.2-42.4 26.8-46.4 3-0.6 5.9-0.9 8.6-0.9 12.5 0 23.1 5.6 31.3 16.2 13.6 17.6 26.4 35.7 39.6 53.6l4.2 5.7c0.3-0.2 0.7-0.3 1.1-0.4v-5-279.2c0-3.2 0-6.3 0.2-9.5 1.2-14.7 15.6-27.2 30.2-27.2 1.3 0 2.6 0.1 3.9 0.3 17.4 2.7 27.8 14.8 27.8 32.5 0 49.7 0 132.9 0.1 182.6 0 2.6 0.2 5.3 0.9 7.7 1.3 4 4.3 6.2 8.6 6.5h0.9c4.1 0 7.2-2.1 8.8-5.7 1-2.3 1.1-5.1 1.1-7.7v-22.5-6.6c0-11.2 3.8-21 13.3-27.6 3.5-2.4 7.7-3.9 11.6-5.8h12.6c0.5 0.3 0.8 0.7 1.3 0.9 16.3 5.6 23.9 16.2 23.9 33.4v22.2-16.4 22.2c0 1.6-0.1 3.2 0.1 4.7 0.7 5.4 4.8 8.9 10 8.9h1c5.5-0.5 8.7-4.2 9-11.1v-0.2-1.2-10.6c0.2-7.3 2-14.2 6.7-20.2 6.2-7.8 15.2-12.1 24.6-12.1 3.4 0 6.9 0.6 10.2 1.7 12.9 4.4 21.2 17 21.2 31.9v28c0 1.9 0 3.9 0.2 5.8 0.6 5.1 3.9 7.7 8.6 8.6 0.5 0.1 1 0.1 1.5 0.1 3.7 0 7.7-2.6 8.9-6.3 0.8-2.4 1-5.1 1-7.7V602v11.3s0.1-3.4 0.1-13.2c0-5.4 1-11.3 3.2-16.3 4.7-11.1 16-17.8 27.7-17.8 2.2 0 4.3 0.2 6.4 0.7 15.1 3.3 24.6 16.1 24.6 32.7 0 90.3 0.1 60.8-0.1 151.2z'
              fill='#1296db'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
