/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

const IconStyle = {
  height: '16px',
  width: '16px'
};

/**
 *
 * default icon
 * @returns {JSX.Element}
 * @constructor
 */
export const FileIcon = () => {
  return (
    <>
      <Icon
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M848.410947 804.163368H706.56a27.809684 27.809684 0 1 1 0-55.619368h141.850947a36.810105 36.810105 0 0 0 36.163369-36.163368V167.235368a36.810105 36.810105 0 0 0-36.163369-36.163368H392.272842a36.810105 36.810105 0 0 0-36.163368 36.163368v38.938948a27.809684 27.809684 0 0 1-55.619369 0V167.235368A92.591158 92.591158 0 0 1 392.272842 75.452632h456.138105a92.591158 92.591158 0 0 1 91.782737 91.782736v542.369685a93.210947 93.210947 0 0 1-91.782737 94.558315z'
              fill='#83D2EA'
            ></path>
            <path
              d='M717.689263 467.644632h-175.157895a73.647158 73.647158 0 0 1-72.380631-72.380632v-175.157895z m-194.694737-114.041264v41.660632a17.946947 17.946947 0 0 0 16.680421 16.680421h41.714527z'
              fill='#208BB5'
            ></path>
            <path
              d='M639.811368 940.463158H183.673263a92.591158 92.591158 0 0 1-91.782737-91.782737v-545.145263a92.591158 92.591158 0 0 1 91.782737-91.782737h311.511579l239.184842 239.21179v394.940631a93.776842 93.776842 0 0 1-94.558316 94.558316zM183.673263 267.371789a36.810105 36.810105 0 0 0-36.163368 36.163369v542.369684a36.810105 36.810105 0 0 0 36.163368 36.163369h456.138105a36.810105 36.810105 0 0 0 36.163369-36.163369V473.141895L470.150737 267.317895H183.673263z'
              fill='#208BB5'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * java icon
 * @returns {JSX.Element}
 * @constructor
 */
export const JavaSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M590.222222 73.955556L859.022222 342.254933V876.088889c0 37.700267-30.5664 68.266667-68.266666 68.266667H233.244444c-37.700267 0-68.266667-30.5664-68.266666-68.266667V142.222222c0-37.700267 30.5664-68.266667 68.266666-68.266666h356.977778z m-11.764622 28.444444H233.244444a39.822222 39.822222 0 0 0-39.799466 38.456889L193.422222 142.222222v733.866667a39.822222 39.822222 0 0 0 38.456889 39.799467L233.244444 915.911111h557.511112a39.822222 39.822222 0 0 0 39.799466-38.456889L830.577778 876.088889V354.053689L578.4576 102.4z'
              fill='#ED5F38'
            ></path>
            <path
              d='M854.755556 370.648178h-215.1424c-45.528178 0-82.551467-36.431644-83.5072-81.737956l-0.017067-1.792V73.955556h28.444444v213.162666c0 29.895111 23.819378 54.232178 53.515378 55.062756l1.564445 0.022755h215.1424v28.444445z'
              fill='#ED5F38'
            ></path>
            <path
              d='M56.888889 489.244444m28.444444 0l853.333334 0q28.444444 0 28.444444 28.444445l0 284.444444q0 28.444444-28.444444 28.444445l-853.333334 0q-28.444444 0-28.444444-28.444445l0-284.444444q0-28.444444 28.444444-28.444445Z'
              fill='#ED5F38'
            ></path>
            <path
              d='M250.453333 757.504c42.752 0 62.464-30.72 62.464-68.096V563.2H267.093333v122.624c0 24.832-7.936 32.256-22.784 32.256-9.216 0-18.944-5.888-25.6-18.944L187.733333 722.432c13.568 23.552 33.024 35.072 62.72 35.072zM445.525333 563.2l59.136 190.72h-48.128l-11.008-43.776h-56.32l-11.008 43.776h-46.592L390.741333 563.2h54.784z m-27.904 34.304h-1.024c-4.608 19.968-9.728 42.24-14.592 61.184l-4.096 16.128h38.912l-4.096-16.128c-5.12-18.944-9.984-41.728-15.104-61.184zM612.437333 753.92L669.525333 563.2h-46.592l-21.504 87.04c-5.376 20.48-9.216 39.936-14.848 60.928h-1.28c-5.376-20.992-9.216-40.448-14.848-60.928L548.693333 563.2h-48.384l57.088 190.72h55.04zM779.093333 563.2l59.136 190.72h-48.128l-11.008-43.776h-56.32l-11.008 43.776h-46.592L724.309333 563.2h54.784z m-27.904 34.304h-1.024c-4.608 19.968-9.728 42.24-14.592 61.184l-4.096 16.128h38.912l-4.096-16.128c-5.12-18.944-9.984-41.728-15.104-61.184z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * yaml icon
 * @returns {JSX.Element}
 * @constructor
 */
export const YAMLSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M354.40128 0c-87.04 0-157.44 70.55872-157.44 157.59872v275.68128H78.72c-21.6576 0-39.36256 17.69984-39.36256 39.36256v236.31872c0 21.6576 17.69984 39.35744 39.36256 39.35744h118.24128v118.08256c0 87.04 70.4 157.59872 157.44 157.59872h472.63744c87.04 0 157.59872-70.55872 157.59872-157.59872V315.0336c0-41.74848-38.9888-81.93024-107.52-149.27872l-29.11744-29.12256L818.87744 107.52C751.5392 38.9888 711.39328 0 669.59872 0H354.4064z m0 78.72h287.20128c28.35456 7.0912 27.99616 42.1376 27.99616 76.8v120.16128c0 21.6576 17.69984 39.35744 39.36256 39.35744h118.07744c39.38816 0 78.87872-0.0256 78.87872 39.36256v512c0 43.32032-35.55328 78.87872-78.87872 78.87872H354.4064c-43.32544 0-78.72-35.5584-78.72-78.87872v-118.08256h393.91744c21.66272 0 39.36256-17.69472 39.36256-39.35744V472.64256c0-21.66272-17.69984-39.36256-39.36256-39.36256H275.68128V157.59872c0-43.32032 35.39456-78.87872 78.72-78.87872zM261.2736 506.39872h20.16256l65.28 176.64h-23.04l-19.2-54.71744h-65.28l-19.2 54.71744h-23.04l64.31744-176.64z m-181.43744 0.96256h23.99744l40.32 89.27744 41.28256-89.27744h23.99744l-53.76 107.52v68.15744h-22.07744v-67.2l-53.76-108.47744z m290.87744 0h32.64l49.92 143.03744h0.96256l48.95744-143.03744h33.60256v175.67744h-22.08256v-106.55744c0-10.88 0.32256-26.56256 0.96256-47.04256h-0.96256l-52.79744 153.6h-19.2l-52.80256-153.6h-0.95744c1.28 22.4 1.92 38.72256 1.92 48.96256v104.63744h-20.16256V507.36128z m214.08256 0h22.07744v155.52h69.12v20.15744H584.8064V507.36128z m-312.96 23.04c-1.92 8.96-4.80256 18.23744-8.64256 27.83744l-17.28 50.88256h51.84l-18.23744-50.88256c-3.84-10.88-6.4-20.15744-7.68-27.83744z'
              fill='#1890FF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * folder icon
 * @returns {JSX.Element}
 * @constructor
 */
export const FolderSvgExpand = () => {
  return (
    <>
      <Icon
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M809.2 924.48H235.9c-89.6 0-162.9-76.6-162.9-170.3v-511.4c0-93.7 73.3-170.3 162.9-170.3l115 2c20.1 0 39.5 7.6 54.7 21.5l86 80.9c15.1 13.9 34.5 21.5 54.7 21.5h263c89.6 0 162.9 76.6 162.9 170.3v385.5c-0.1 93.7-73.4 170.3-163 170.3z'
              fill='#6477FF'
            ></path>
            <path
              d='M761.2 888.48H284c-116 0-210.9-94.9-210.9-210.9v-297c0-25.5 20.7-46.1 46.1-46.1h806.7c25.5 0 46.1 20.7 46.1 46.1v297c0.1 116-94.8 210.9-210.8 210.9z'
              fill='#465CDB'
              opacity='.69'
            ></path>
            <path
              d='M829 738.48H216.1c-31.4 0-57-25.7-57-57v-318c0-31.4 25.7-57 57-57H829c31.4 0 57 25.7 57 57v317.9c0.1 31.4-25.6 57.1-57 57.1z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M831 719.48H218.1c-31.4 0-57-25.7-57-57v-318c0-31.4 25.7-57 57-57H831c31.4 0 57 25.7 57 57v317.9c0.1 31.4-25.6 57.1-57 57.1z'
              fill='#FFFFFF'
              opacity='.16'
            ></path>
            <path
              d='M807.3 924.48H237.8c-90.6 0-164.8-74.1-164.8-164.8v-356.2h899v356.2c0.1 90.7-74.1 164.8-164.7 164.8z'
              fill='#6477FF'
            ></path>
            <path
              d='M805.3 924.48H235.8c-90.6 0-164.8-74.1-164.8-164.8v-17.2h899v17.2c0.1 90.7-74.1 164.8-164.7 164.8z'
              fill='#465CDB'
              opacity='.14'
            ></path>
            <path
              d='M595.6 598.48H413.1c-39.9 0-72.5-32.6-72.5-72.5s32.6-72.5 72.5-72.5h182.5c39.9 0 72.5 32.6 72.5 72.5s-32.6 72.5-72.5 72.5z'
              fill='#5D75CE'
              opacity='.52'
            ></path>
            <path
              d='M585.5 583.48H423.6c-31.6 0-57.5-25.9-57.5-57.5s25.9-57.5 57.5-57.5h161.9c31.6 0 57.5 25.9 57.5 57.5s-25.9 57.5-57.5 57.5z'
              fill='#FFD629'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ZipSvg = () => {
  return (
    <Icon
      style={{ ...IconStyle }}
      component={() => (
        <svg viewBox='0 0 1024 1024' version='1.1' xmlns='http://www.w3.org/2000/svg'>
          <path d='M0 0h1024v341.76H0V0z' fill='#55C7F7'></path>
          <path d='M0 682.24h1024V1024H0V682.24z' fill='#7ECF3B'></path>
          <path d='M352 430.08h320v172.8h-320z' fill='#F95F5D'></path>
          <path
            d='M0 341.76v341.76h1024V341.76H0z m720.64 304.64H304.64V386.56h416v259.84z'
            fill='#F95F5D'
          ></path>
          <path
            d='M352 0h320v386.56h-320zM352 646.4h320V1024h-320zM352 430.08h320v172.8h-320z'
            fill='#FDAF42'
          ></path>
        </svg>
      )}
    />
  );
};

export const ConfigSvg = () => {
  return (
    <Icon
      style={{ ...IconStyle }}
      component={() => (
        <svg
          className='icon'
          viewBox='0 0 1024 1024'
          version='1.1'
          xmlns='http://www.w3.org/2000/svg'
          width='200'
          height='200'
        >
          <path
            d='M400.384 965.12h-220.16c-59.904 1.536-109.568-45.568-111.616-105.472V131.072C70.656 71.168 120.32 24.064 180.224 25.6h539.136c59.392-1.024 108.032 46.08 110.08 105.472v322.048c-4.608 20.48-25.088 33.28-45.568 28.672-14.336-3.072-25.6-14.336-28.672-28.672V131.072c-1.536-19.968-17.92-34.816-37.888-34.816H180.224c-19.968 0-36.352 15.36-37.888 34.816v728.576c1.536 19.968 17.92 35.328 37.888 35.328h220.16c19.456 0 34.816 15.872 34.816 34.816 0.512 19.456-15.36 35.328-34.816 35.328z'
            fill='#A6C5F6'
          ></path>
          <path
            d='M626.688 297.472H274.944c-19.456 0-34.816-15.872-34.816-34.816 0-19.456 15.872-34.816 34.816-34.816h351.744c19.456 0 34.816 15.872 34.816 34.816 0 19.456-15.872 34.816-34.816 34.816z m0 178.176H274.944c-19.456 0-34.816-15.872-34.816-34.816 0-19.456 15.872-34.816 34.816-34.816h351.744c19.456 0 34.816 15.872 34.816 34.816 0 19.456-15.872 34.816-34.816 34.816z m327.68 260.096c0-19.968-13.312-30.208-35.328-32.256-25.088 0-45.568-19.968-46.08-45.056 0-3.584 0.512-7.168 1.024-10.752 8.192-37.888 6.656-43.52-29.184-62.976l-23.04-12.8c-20.48-16.896-50.688-14.336-68.096 5.632-26.112 20.48-37.888 19.968-62.976 0-16.896-20.48-47.616-23.04-68.096-6.656l-37.888 20.992c-17.408 7.68-25.088 27.648-18.432 45.056 11.776 37.888-5.12 62.464-46.592 66.56-16.896 2.048-28.672 11.264-29.184 26.112-2.048 30.208-2.048 59.904 0 90.112 0 19.456 12.8 29.184 34.304 31.232 25.6 0 47.104 20.48 47.104 46.592 0 2.56 0 5.632-0.512 8.192-7.68 39.936-7.68 44.032 30.208 64.512 8.192 4.608 15.872 9.728 24.576 13.824 19.456 13.312 45.568 9.728 61.44-8.192 29.184-25.088 37.888-24.576 68.608 0 12.288 8.192 25.088 15.36 37.888 22.016 27.648-17.408 55.296-32.768 79.872-51.2 5.632-8.704 7.168-19.968 3.584-30.208-13.824-34.304 8.192-64.512 48.128-68.096 16.384 0 27.136-10.24 28.16-24.576 1.536-28.672 1.536-58.368 0.512-88.064z m-233.472 132.096c-50.688 0-91.648-40.96-91.648-91.648 0-50.688 40.96-91.648 91.648-91.648s91.648 40.96 91.648 91.648c0 50.176-40.448 91.648-91.136 91.648h-0.512zM237.568 584.192h247.808v70.144H237.568v-70.144z'
            fill='#4E8CEE'
          ></path>
        </svg>
      )}
    />
  );
};
export const JarSvg = () => {
  return (
    <>
      <Icon
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width='200'
            height='200'
          >
            <path
              d='M590.222222 73.955556L859.022222 342.254933V876.088889c0 37.700267-30.5664 68.266667-68.266666 68.266667H233.244444c-37.700267 0-68.266667-30.5664-68.266666-68.266667V142.222222c0-37.700267 30.5664-68.266667 68.266666-68.266666h356.977778z m-11.764622 28.444444H233.244444a39.822222 39.822222 0 0 0-39.799466 38.456889L193.422222 142.222222v733.866667a39.822222 39.822222 0 0 0 38.456889 39.799467L233.244444 915.911111h557.511112a39.822222 39.822222 0 0 0 39.799466-38.456889L830.577778 876.088889V354.053689L578.4576 102.4z'
              fill='#FF4D4F'
            ></path>
            <path
              d='M854.755556 370.648178h-215.1424c-45.528178 0-82.551467-36.431644-83.5072-81.737956l-0.017067-1.792V73.955556h28.444444v213.162666c0 29.895111 23.819378 54.232178 53.515378 55.062756l1.564445 0.022755h215.1424v28.444445z'
              fill='#FF4D4F'
            ></path>
            <path
              d='M56.888889 489.244444m28.444444 0l853.333334 0q28.444444 0 28.444444 28.444445l0 284.444444q0 28.444444-28.444444 28.444445l-853.333334 0q-28.444444 0-28.444444-28.444445l0-284.444444q0-28.444444 28.444444-28.444445Z'
              fill='#FF4D4F'
            ></path>
            <path
              d='M330.097778 757.504c42.752 0 62.464-30.72 62.464-68.096V563.2H346.737778v122.624c0 24.832-7.936 32.256-22.784 32.256-9.216 0-18.944-5.888-25.6-18.944L267.377778 722.432c13.568 23.552 33.024 35.072 62.72 35.072zM525.169778 563.2l59.136 190.72h-48.128l-11.008-43.776h-56.32l-11.008 43.776h-46.592L470.385778 563.2h54.784z m-27.904 34.304h-1.024c-4.608 19.968-9.728 42.24-14.592 61.184l-4.096 16.128h38.912l-4.096-16.128c-5.12-18.944-9.984-41.728-15.104-61.184zM674.161778 563.2c40.704 0 74.496 14.08 74.496 60.16 0 27.904-13.056 45.824-32.768 55.04l42.496 75.52h-51.2l-35.072-67.072h-22.016v67.072h-45.824V563.2z m-3.584 36.352h-20.48v51.2h20.48c21.76 0 33.536-9.472 33.536-27.392 0-17.92-11.776-23.808-33.536-23.808z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * folder icon
 * @returns {JSX.Element}
 * @constructor
 */
export const FolderSvgExpanded = () => {
  return (
    <>
      <Icon
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
          >
            <path
              d='M81.16 540.07333298L0 837.65333298V266.66666698a53.393333 53.393333 0 0 1 53.333333-53.333334h253.413334a52.986667 52.986667 0 0 1 37.713333 15.62l109.253333 109.253334a10.573333 10.573333 0 0 0 7.54 3.126666H842.666667a53.393333 53.393333 0 0 1 53.333333 53.333334v74.666666H173.773333a96.2 96.2 0 0 0-92.613333 70.74z m922-7.113333a52.933333 52.933333 0 0 0-42.386667-20.96H173.773333a53.453333 53.453333 0 0 0-51.453333 39.333333L11.773333 956.66666698a53.333333 53.333333 0 0 0 51.453334 67.333333h787a53.453333 53.453333 0 0 0 51.453333-39.333333l110.546667-405.333334a52.953333 52.953333 0 0 0-9.073334-46.373333z'
              fill='#209BFD'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * shell icon
 * @returns {JSX.Element}
 * @constructor
 */
export const ShellSvg = (props: { size?: number }) => {
  const { size = 16 } = props;

  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M144 112h736c17.673 0 32 14.327 32 32v736c0 17.673-14.327 32-32 32H144c-17.673 0-32-14.327-32-32V144c0-17.673 14.327-32 32-32z m112 211.24v72.43a8.81 8.81 0 0 0 3.35 7L386.09 509 259.35 615.37a9.32 9.32 0 0 0-3.35 7v72.43a9.2 9.2 0 0 0 15.15 7L492.7 516.04a9.29 9.29 0 0 0 0-14.2l-221.55-185.6a9.2 9.2 0 0 0-15.15 7zM521.57 624a9.82 9.82 0 0 0-9.57 10v60a9.82 9.82 0 0 0 9.57 10h236.86a9.82 9.82 0 0 0 9.57-10v-60a9.82 9.82 0 0 0-9.57-10H521.57z'
              fill='#000000'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * xml icon
 * @constructor
 */
export const XMLSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M870.4 1024h-716.8A51.2 51.2 0 0 1 102.4 972.8v-921.6A51.2 51.2 0 0 1 153.6 0h569.685333a42.666667 42.666667 0 0 1 30.037334 12.288l155.989333 155.989333a42.666667 42.666667 0 0 1 12.288 30.037334V972.8a51.2 51.2 0 0 1-51.2 51.2zM153.6 34.133333a17.066667 17.066667 0 0 0-17.066667 17.066667v921.6a17.066667 17.066667 0 0 0 17.066667 17.066667h716.8a17.066667 17.066667 0 0 0 17.066667-17.066667V198.314667a7.168 7.168 0 0 0-2.389334-5.802667l-155.989333-155.989333a7.168 7.168 0 0 0-5.802667-2.389334z'
              fill='#4D4D4D'
            ></path>
            <path
              d='M904.533333 204.8h-170.666666a17.066667 17.066667 0 0 1-17.066667-17.066667v-170.666666h34.133333V170.666667h153.6z'
              fill='#4D4D4D'
            ></path>
            <path
              d='M204.8 170.666667h443.733333v34.133333H204.8zM204.8 307.2h614.4v34.133333H204.8zM204.8 443.733333h614.4v34.133334H204.8zM204.8 580.266667h614.4v34.133333H204.8zM204.8 853.333333h614.4v34.133334H204.8zM204.8 716.8h614.4v34.133333H204.8z'
              fill='#B3B3B3'
            ></path>
            <path
              d='M51.2 460.8m17.066667 0l887.466666 0q17.066667 0 17.066667 17.066667l0 273.066666q0 17.066667-17.066667 17.066667l-887.466666 0q-17.066667 0-17.066667-17.066667l0-273.066666q0-17.066667 17.066667-17.066667Z'
              fill='#4295E5'
            ></path>
            <path
              d='M955.733333 477.866667v273.066666H68.266667v-273.066666h887.466666m0-34.133334H68.266667a34.133333 34.133333 0 0 0-34.133334 34.133334v273.066666a34.133333 34.133333 0 0 0 34.133334 34.133334h887.466666a34.133333 34.133333 0 0 0 34.133334-34.133334v-273.066666a34.133333 34.133333 0 0 0-34.133334-34.133334z'
              fill='#267ACB'
            ></path>
            <path
              d='M308.906667 614.4l-55.637334-84.309333h31.061334l40.96 63.488h2.048l41.642666-63.488h29.354667L341.333333 614.4l55.978667 83.968h-30.72l-41.301333-62.122667-43.690667 62.464H252.586667zM587.776 698.709333V576.853333l-49.493333 117.76h-19.797334L467.626667 576.853333v121.856h-24.576v-168.618666h30.72l53.589333 129.024h2.048L580.266667 530.090667h30.378666v168.618666zM771.413333 698.709333h-105.130666v-168.618666h26.282666v144.384h78.848z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * markdown icon
 * @returns {JSX.Element}
 * @constructor
 */
export const MarkDownSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326z m1.8 562H232V136h302v216c0 23.2 18.8 42 42 42h216v494zM429 481.2c-1.9-4.4-6.2-7.2-11-7.2h-35c-6.6 0-12 5.4-12 12v272c0 6.6 5.4 12 12 12h27.1c6.6 0 12-5.4 12-12V582.1l66.8 150.2c1.9 4.3 6.2 7.1 11 7.1H524c4.7 0 9-2.8 11-7.1l66.8-150.6V758c0 6.6 5.4 12 12 12H641c6.6 0 12-5.4 12-12V486c0-6.6-5.4-12-12-12h-34.7c-4.8 0-9.1 2.8-11 7.2l-83.1 191-83.2-191z'
              fill='#1296DB'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
export const FlinkSQLSvg = (props: { size?: number }) => {
  const { size = 16 } = props;

  return (
    <Icon
      component={() => (
        <svg
          className='icon'
          viewBox='0 0 1024 1024'
          version='1.1'
          xmlns='http://www.w3.org/2000/svg'
          p-id='6264'
          width={size}
          height={size}
        >
          <path
            d='M821.76 870.4s-5.12 33.28 5.12 48.64l43.52 30.72-2.56 10.24v15.36l10.24 2.56 15.36-2.56 2.56 5.12 7.68 10.24h10.24l10.24-23.04v-10.24l10.24-2.56s69.12-23.04 53.76-48.64l-5.12-2.56s-30.72 12.8-43.52 10.24c0 0-58.88 2.56-87.04-17.92l-30.72-25.6z'
            fill='#D77083'
            p-id='6265'
          ></path>
          <path
            d='M837.12 849.92s-28.16 0-10.24 28.16c0 0 28.16 30.72 81.92 38.4 0 0 79.36 0 84.48-25.6 0 0-2.56-30.72-25.6-28.16-23.04 7.68-130.56-12.8-130.56-12.8z'
            fill='#733D48'
            p-id='6266'
          ></path>
          <path
            d='M960 768s35.84 38.4 20.48 97.28c0 0-2.56 25.6-23.04 33.28 0 0-38.4 7.68-48.64 2.56 0 0-48.64-2.56-64-28.16 0 0-20.48-20.48-2.56-43.52 0 0 35.84-15.36 43.52-38.4 0 0 12.8-10.24 28.16-7.68 15.36 2.56 28.16 10.24 28.16 10.24s23.04-17.92 17.92-25.6z'
            fill='#D59D52'
            p-id='6267'
          ></path>
          <path
            d='M865.28 798.72s17.92 38.4 61.44 40.96c0 0 40.96 0 58.88-25.6l-15.36-38.4-28.16-7.68s-74.24-23.04-76.8 30.72z'
            fill='#DBAE62'
            p-id='6268'
          ></path>
          <path
            d='M960 768s17.92 23.04-5.12 28.16c0 0-23.04 5.12-35.84 0 0 0-79.36 23.04-58.88 89.6 0 0-15.36 0-23.04-38.4L844.8 768s107.52-20.48 115.2 0z'
            fill='#B88F4D'
            p-id='6269'
          ></path>
          <path
            d='M949.76 806.4s10.24 20.48 2.56 30.72c0 0-2.56 5.12 10.24 7.68 0 0 15.36-17.92-2.56-46.08 0 0-10.24-2.56-10.24 7.68z'
            fill='#FFFFFF'
            p-id='6270'
          ></path>
          <path
            d='M954.88 803.84m-5.12 0a5.12 5.12 0 1 0 10.24 0 5.12 5.12 0 1 0-10.24 0Z'
            fill='#FFFFFF'
            p-id='6271'
          ></path>
          <path
            d='M957.44 839.68m-5.12 0a5.12 5.12 0 1 0 10.24 0 5.12 5.12 0 1 0-10.24 0Z'
            fill='#FFFFFF'
            p-id='6272'
          ></path>
          <path
            d='M988.16 870.4s23.04-58.88-20.48-104.96h-7.68v12.8s25.6 28.16 17.92 61.44c0 0-2.56 28.16-7.68 40.96 0 0-17.92 17.92-38.4 17.92 0 0-43.52 0-79.36-20.48 0 0-17.92-20.48-10.24-43.52h-5.12c0-2.56-2.56-5.12-12.8 0 0 0 5.12 7.68-5.12 10.24 0 0-20.48 10.24-15.36 51.2 2.56 35.84 48.64 58.88 48.64 58.88s2.56 2.56 2.56 7.68-2.56 17.92 12.8 20.48c0 0 10.24 2.56 15.36-2.56 0 0 7.68 23.04 23.04 17.92 15.36-5.12 20.48-20.48 12.8-33.28 0 0 35.84-5.12 58.88-33.28 5.12 0 35.84-33.28 10.24-61.44z m-10.24 48.64c-5.12 7.68-15.36 30.72-51.2 38.4 0 0-20.48 0-28.16-2.56 0 0-20.48 7.68 2.56 5.12 0 0 17.92 0 15.36 12.8 0 0-2.56 12.8-7.68 12.8 0 0-5.12 5.12-12.8-10.24 0 0 2.56-5.12-7.68-5.12 0 0-17.92 7.68-17.92-10.24 0 0 5.12-10.24 10.24-12.8 0 0-51.2-15.36-58.88-58.88 0 0-5.12-10.24 2.56-7.68 35.84 33.28 79.36 38.4 79.36 38.4 38.4 5.12 71.68-10.24 71.68-10.24 2.56 2.56 5.12 5.12 2.56 10.24z m7.68-23.04s-2.56 5.12-5.12 7.68c-2.56 0-2.56 2.56-5.12 2.56-46.08 20.48-102.4 0-102.4 0-43.52-23.04-46.08-38.4-46.08-40.96 0-2.56 0-5.12 2.56-5.12 0 0 5.12-10.24 10.24-5.12 0 7.68 5.12 17.92 10.24 23.04 15.36 12.8 35.84 23.04 69.12 25.6 33.28 2.56 51.2-7.68 58.88-23.04 5.12 2.56 10.24 10.24 7.68 15.36z'
            p-id='6273'
          ></path>
          <path
            d='M35.84 563.2s15.36 125.44 112.64 207.36l115.2-99.84L435.2 665.6l220.16-125.44s133.12-84.48 128-179.2c0 0-145.92 66.56-179.2 46.08L547.84 435.2 486.4 478.72l-89.6 7.68-12.8 15.36-166.4 51.2s-23.04-71.68 53.76-192l25.6-40.96-110.08 51.2-2.56-25.6-12.8 2.56-20.48 64-23.04 7.68-64 110.08-7.68-17.92h-10.24v51.2h-10.24z'
            fill='#947BB0'
            p-id='6274'
          ></path>
          <path
            d='M757.76 460.8l23.04-7.68 28.16-40.96h10.24l17.92 2.56 7.68 15.36 15.36 15.36 28.16 7.68 25.6 10.24 23.04 20.48 10.24 15.36 12.8 23.04 10.24 35.84 7.68 25.6 5.12 17.92 5.12 15.36-2.56 23.04-7.68 17.92-10.24 12.8-25.6 7.68-7.68 7.68-33.28 5.12h-23.04l-15.36 10.24 2.56 12.8h15.36l28.16-7.68 28.16 2.56 17.92 15.36 7.68 7.68 2.56 17.92v25.6l-17.92 15.36-17.92-2.56-12.8-5.12-23.04 2.56-7.68 10.24-15.36 15.36-28.16 15.36-25.6 5.12-38.4 5.12-2.56 10.24v10.24l-5.12 20.48-15.36 20.48-15.36 23.04 30.72 2.56 28.16 5.12 12.8 15.36 5.12 15.36-5.12 12.8-17.92 15.36-40.96 2.56H384s-204.8 0-289.28-148.48-53.76-243.2-53.76-243.2l5.12-23.04s33.28 117.76 89.6 176.64l15.36 17.92s10.24-2.56 17.92-43.52c0 0 17.92-84.48 227.84-84.48l87.04-46.08 87.04-25.6 64-15.36 51.2-25.6 71.68-69.12z'
            fill='#D77083'
            p-id='6275'
          ></path>
          <path
            d='M870.4 555.52s15.36-23.04 46.08-7.68c0 0 30.72 17.92 10.24 58.88 0 0-12.8-2.56-23.04 0-2.56 0-61.44 2.56-33.28-51.2z'
            p-id='6276'
          ></path>
          <path
            d='M880.64 581.12s-7.68-7.68-2.56-17.92l-7.68-7.68s-12.8 15.36 10.24 33.28c0 0 10.24 7.68 33.28 7.68 0 0 7.68 2.56 7.68 5.12v-20.48s-5.12 12.8-12.8 12.8c0 0-17.92-2.56-28.16-12.8z'
            fill='#FFFFFF'
            p-id='6277'
          ></path>
          <path
            d='M901.12 568.32m-15.36 0a15.36 15.36 0 1 0 30.72 0 15.36 15.36 0 1 0-30.72 0Z'
            fill='#D19B52'
            p-id='6278'
          ></path>
          <path
            d='M888.32 558.08m-7.68 0a7.68 7.68 0 1 0 15.36 0 7.68 7.68 0 1 0-15.36 0Z'
            fill='#FFFFFF'
            p-id='6279'
          ></path>
          <path
            d='M312.32 153.6l2.56-25.6 66.56-48.64 30.72-15.36s40.96-35.84 99.84-35.84l71.68 7.68 51.2 17.92 38.4 23.04 30.72 15.36 38.4 25.6-7.68 46.08-7.68 33.28 10.24 46.08-15.36 23.04s-7.68 20.48-48.64 53.76l-23.04 43.52-40.96 51.2L537.6 460.8l-61.44 17.92-48.64 5.12L250.88 537.6l-33.28 15.36s-20.48-110.08 53.76-192l46.08-40.96s30.72-25.6 35.84-66.56l28.16 48.64 20.48-43.52c0-2.56 2.56-112.64-89.6-104.96z'
            fill='#E7DFAB'
            p-id='6280'
          ></path>
          <path
            d='M765.44 99.84L742.4 128l-7.68 25.6-5.12 58.88-7.68 53.76s-30.72 48.64-43.52 43.52l-10.24 23.04-5.12 17.92 40.96-35.84 53.76-23.04 30.72-12.8 12.8-25.6-12.8-48.64-2.56-30.72-15.36-5.12s-7.68-40.96 5.12-56.32l-10.24-12.8z'
            fill='#D19456'
            p-id='6281'
          ></path>
          <path
            d='M642.56 373.76s51.2-61.44 115.2-89.6v15.36l64-35.84h15.36l-5.12 33.28-17.92 23.04-20.48 33.28-33.28 23.04-69.12 25.6-66.56 15.36 17.92-43.52z'
            fill='#D77083'
            p-id='6282'
          ></path>
          <path
            d='M396.8 174.08s84.48-23.04 112.64 0c28.16 23.04 104.96-5.12 104.96-5.12l69.12 40.96-5.12 97.28s-7.68-64-81.92-71.68-71.68-20.48-117.76-43.52-35.84 2.56-81.92-17.92z'
            fill='#D89E52'
            p-id='6283'
          ></path>
          <path
            d='M396.8 174.08s10.24 30.72 61.44 33.28 215.04 87.04 151.04 156.16c0 0-10.24 76.8-74.24 94.72 0 0 51.2-66.56 17.92-138.24 0 0-7.68-58.88-79.36-76.8 2.56 0-43.52-20.48-76.8-69.12z'
            fill='#D89E52'
            p-id='6284'
          ></path>
          <path
            d='M445.44 273.92s25.6 79.36 69.12 92.16c0 0 51.2 46.08 5.12 79.36l-92.16 38.4-158.72 40.96-56.32 20.48s64-81.92 107.52-102.4c0 0 76.8-20.48 110.08-102.4l15.36-66.56z'
            fill='#D89E52'
            p-id='6285'
          ></path>
          <path
            d='M371.2 273.92s-17.92 76.8-94.72 151.04C238.08 460.8 230.4 506.88 222.72 540.16c0 0 20.48-71.68 76.8-117.76 33.28-28.16 69.12-71.68 71.68-148.48z'
            fill='#814879'
            p-id='6286'
          ></path>
          <path
            d='M437.76 496.64s48.64 2.56 66.56 17.92c0 0-15.36-12.8-28.16-17.92 0 0 76.8 10.24 107.52 23.04 0 0 35.84 7.68 56.32 0 0 0-56.32-2.56-79.36-17.92 0 0-46.08-17.92-74.24-15.36l-48.64 10.24z'
            fill='#785085'
            p-id='6287'
          ></path>
          <path
            d='M601.6 437.76s23.04-5.12 53.76 0c0 0 48.64 25.6 104.96-12.8 0 0-43.52 53.76-79.36 46.08 0 0-99.84-17.92-120.32-10.24 2.56 2.56 33.28-7.68 40.96-23.04z'
            fill='#E1CAC9'
            p-id='6288'
          ></path>
          <path
            d='M378.88 156.16s35.84-30.72 51.2-35.84c0 0 69.12-17.92 40.96 0l-12.8 15.36s25.6-12.8 53.76-10.24l-12.8 10.24s43.52-7.68 48.64 0c0 0 17.92 20.48 35.84 10.24 0 0-7.68 20.48-51.2-2.56 0 0-30.72 0 0 12.8-2.56 0-84.48-20.48-153.6 0z'
            fill='#FFFFFF'
            p-id='6289'
          ></path>
          <path
            d='M345.6 709.12s-35.84 5.12-35.84 58.88c0 0 7.68 43.52 40.96 56.32 0 0-15.36-66.56 7.68-112.64l-12.8-2.56z'
            fill='#A04F5D'
            p-id='6290'
          ></path>
          <path
            d='M675.84 724.48s-5.12 89.6 30.72 128c0 0 30.72 30.72 71.68 25.6 0 0 23.04-38.4-23.04-40.96 0 0-46.08-10.24-58.88-56.32-2.56 2.56-7.68-51.2-20.48-56.32z'
            fill='#9A505E'
            p-id='6291'
          ></path>
          <path
            d='M714.24 642.56s-17.92 71.68 58.88 92.16c0 0 61.44 7.68 79.36-25.6 0 0-64 12.8-97.28-20.48-2.56 0-38.4-25.6-40.96-46.08zM824.32 427.52s-48.64 30.72-12.8 64c0 0 7.68-35.84 15.36-46.08 10.24-10.24-2.56-17.92-2.56-17.92z'
            fill='#A04F5E'
            p-id='6292'
          ></path>
          <path
            d='M819.2 450.56s-12.8 28.16-7.68 38.4c0 0 7.68 17.92 12.8 15.36 0 0-12.8-25.6 2.56-48.64 0 0 12.8-17.92 0-43.52 0 2.56 5.12 20.48-7.68 38.4zM844.8 501.76s30.72-17.92 10.24-46.08c0 0 5.12 25.6-10.24 46.08zM714.24 640c0-2.56 0 0 0 0zM714.24 640c10.24 74.24 89.6 69.12 89.6 69.12-79.36-15.36-89.6-66.56-89.6-69.12z'
            p-id='6293'
          ></path>
          <path
            d='M985.6 591.36s-10.24-35.84-10.24-53.76c0 0-17.92-94.72-115.2-99.84 0 0-10.24-30.72-40.96-30.72 0 0-17.92 2.56-46.08 38.4-5.12 5.12-5.12-2.56-5.12-2.56 5.12-5.12 5.12-10.24 5.12-10.24 17.92-20.48 28.16-64 33.28-81.92 10.24-7.68 17.92-17.92 25.6-28.16l10.24-33.28s-5.12 0-10.24 7.68 17.92-40.96 10.24-53.76c0 0-30.72 15.36-33.28 23.04 0 0-7.68-46.08-17.92-69.12 0 0 0-33.28 10.24-38.4 0 0-10.24-12.8-25.6 10.24 0 0-17.92-17.92 7.68-66.56 0 0 5.12-10.24-20.48-2.56 0 0-20.48 20.48-23.04 25.6 0 0-10.24-12.8-15.36-28.16 0 0-2.56-2.56-5.12 0 0 0-5.12 7.68-7.68-7.68 0 0-10.24-17.92-15.36-17.92 0 0 2.56 12.8 0 12.8 0 0-2.56 0-10.24-5.12 0 0-38.4-25.6-97.28-38.4 0 0-12.8-5.12-17.92-7.68 0 0-2.56 0-5.12 2.56 0 0-10.24 0-17.92-2.56-28.16-12.8-40.96 0-40.96 0-145.92 0-192 94.72-192 94.72-15.36 15.36-2.56 25.6-2.56 25.6h23.04c97.28 61.44 35.84 120.32 35.84 120.32l-10.24-33.28c-23.04-23.04-15.36 0-15.36 0 7.68 35.84-17.92 58.88-17.92 58.88-76.8 23.04-133.12 56.32-133.12 56.32-15.36-2.56 7.68-25.6-10.24-23.04s-28.16 48.64-28.16 48.64C107.52 417.28 66.56 486.4 51.2 512c0-5.12-2.56-38.4-2.56-56.32 0 0-17.92 43.52-7.68 89.6 0 0-7.68 20.48-12.8 46.08 0 0 0 5.12-2.56 10.24v33.28c0 40.96 2.56 102.4 28.16 153.6 0 0 38.4 120.32 197.12 186.88 0 0 64 23.04 120.32 23.04h384s53.76 0 61.44-28.16c7.68-30.72-10.24-61.44-61.44-53.76 0 0-15.36 2.56 5.12-12.8 0 0 17.92-15.36 17.92-48.64 0 0-7.68-12.8 17.92-10.24 0 0 17.92 0 28.16-2.56 0 0 48.64-10.24 66.56-51.2 0 0 17.92-7.68 28.16 0 0 0 20.48 10.24 25.6 2.56 0 0 2.56-2.56 15.36-10.24 0 0 5.12 2.56 10.24-35.84 0 0 0-15.36-10.24-23.04 0 0-5.12-7.68-7.68-12.8 0 0-12.8-17.92-56.32-10.24 0 0-23.04 15.36-28.16 7.68-5.12-7.68 7.68-7.68 7.68-7.68s51.2-2.56 71.68-17.92c0 0 33.28-2.56 35.84-38.4 2.56-5.12 23.04-23.04 2.56-53.76z m-220.16-168.96c-46.08 94.72-135.68 122.88-135.68 122.88-46.08 0-56.32 2.56-56.32 2.56 33.28 5.12 25.6 10.24 25.6 10.24-71.68 7.68-97.28 20.48-97.28 20.48-94.72-15.36-145.92-5.12-145.92-5.12-115.2 20.48-163.84 74.24-163.84 74.24 102.4-58.88 171.52-64 171.52-64 112.64-7.68 120.32 0 120.32 0-30.72 5.12-69.12 33.28-69.12 33.28-17.92 12.8-97.28 25.6-97.28 25.6-28.16 2.56-79.36 17.92-79.36 17.92-79.36 25.6-79.36 97.28-79.36 97.28-25.6-28.16-23.04-76.8-23.04-76.8l-2.56-2.56c2.56-10.24 7.68-20.48 17.92-43.52 23.04-53.76 38.4-56.32 79.36-81.92s192-53.76 192-53.76c148.48-17.92 189.44-71.68 189.44-71.68 2.56-2.56 7.68-7.68 15.36-12.8h2.56s87.04-2.56 156.16-48.64c-2.56 23.04-20.48 56.32-20.48 56.32z m64-153.6s-5.12 43.52-38.4 71.68c0 0-48.64 48.64-153.6 66.56l-5.12 2.56c7.68-10.24 17.92-17.92 17.92-17.92 84.48-12.8 135.68-74.24 135.68-74.24-74.24 53.76-130.56 64-130.56 64 7.68-10.24 12.8-23.04 20.48-35.84 10.24-7.68 43.52-35.84 71.68-43.52 0 0-12.8 23.04-28.16 33.28 0 0 23.04-2.56 61.44-38.4-2.56-5.12 28.16-28.16 48.64-28.16z m-92.16-94.72c5.12-43.52 28.16-64 28.16-64 10.24 7.68 0 15.36 0 15.36-7.68 25.6-2.56 58.88-2.56 58.88l-25.6 58.88c0-2.56-5.12-25.6 0-69.12z m-381.44 92.16c33.28 43.52-20.48 115.2-20.48 115.2 92.16-71.68 71.68-138.24 71.68-138.24 0-66.56-53.76-87.04-53.76-87.04-28.16-5.12-23.04-15.36-23.04-15.36 76.8-87.04 148.48-71.68 148.48-71.68 0-12.8-53.76-5.12-53.76-5.12 17.92-25.6 79.36-20.48 79.36-20.48 10.24 2.56 33.28 12.8 33.28 12.8l-10.24-20.48c7.68 2.56 12.8 5.12 17.92 7.68 5.12 2.56 10.24 2.56 10.24 2.56 7.68 0 17.92 2.56 33.28 2.56 0 0 15.36 2.56 28.16 28.16 0 0-2.56-15.36-5.12-20.48 0 0 17.92 10.24 25.6 23.04 0 0 2.56-2.56 0-12.8 0 0 33.28 15.36 46.08 35.84 0 0 2.56 2.56 2.56-5.12 0 0 2.56-15.36 7.68 0 0 0-2.56 15.36 2.56 12.8 0 0 5.12-5.12 5.12-12.8 0 0 5.12-2.56 5.12 5.12 0 0 5.12 5.12 10.24 0 0 0 5.12 5.12 7.68 15.36 2.56 10.24 7.68 17.92 7.68 17.92s-10.24 25.6-7.68 53.76c0 0 0 71.68-10.24 84.48 0 0 30.72-12.8 43.52-66.56 0 0 17.92-46.08 20.48-17.92 0 0-5.12 12.8 0 28.16 0 0-7.68 30.72-15.36 35.84 0 0 15.36-10.24 23.04-23.04 0 0 7.68 25.6-5.12 33.28 0 0-35.84 23.04-69.12 30.72 0 0-23.04 12.8-30.72 28.16l-5.12 7.68c12.8-30.72 20.48-61.44 20.48-61.44 12.8-10.24 17.92-30.72 17.92-30.72-5.12 0-15.36 12.8-15.36 12.8-10.24 10.24-5.12-17.92-5.12-17.92 5.12-7.68 10.24-20.48 10.24-20.48 0-10.24-10.24 2.56-10.24 2.56-10.24 5.12-5.12-12.8-5.12-12.8 7.68-15.36 2.56-20.48 2.56-20.48-5.12 0-12.8 23.04-12.8 23.04-2.56 15.36-15.36-15.36-15.36-15.36-12.8-10.24-10.24-35.84-10.24-35.84-2.56-15.36-5.12 0-5.12 0-2.56 17.92-5.12 7.68-5.12 7.68 0-12.8-2.56-23.04-2.56-23.04v20.48c-5.12 7.68-10.24-10.24-10.24-10.24-2.56-17.92-7.68-15.36-7.68-15.36-2.56 10.24 2.56 15.36 0 17.92-2.56 2.56-10.24-7.68-10.24-17.92 0-10.24-7.68-5.12-7.68-5.12 0 17.92-5.12 10.24-5.12 10.24-133.12-58.88-189.44-12.8-189.44-12.8 122.88-51.2 232.96 69.12 232.96 69.12-17.92-7.68-48.64-2.56-48.64-2.56-35.84 15.36-56.32 5.12-56.32 5.12 12.8 15.36 64 7.68 64 7.68 20.48-7.68 38.4 2.56 38.4 2.56 23.04 20.48-5.12 20.48-5.12 20.48 25.6 10.24 33.28 48.64 33.28 48.64-7.68 104.96-117.76 158.72-117.76 158.72 53.76-81.92 20.48-130.56 20.48-130.56-17.92-40.96-92.16-58.88-92.16-58.88 74.24 33.28 79.36 76.8 79.36 76.8 7.68 76.8-35.84 122.88-35.84 122.88l-25.6 10.24c17.92-23.04 15.36-64 15.36-64-12.8 53.76-64 79.36-64 79.36 17.92-28.16 15.36-53.76 15.36-53.76-5.12 25.6-46.08 56.32-46.08 56.32-17.92 23.04-135.68 51.2-145.92 51.2-5.12 0-30.72 7.68-46.08 15.36-28.16-81.92 81.92-199.68 81.92-199.68 38.4-25.6 48.64-74.24 48.64-74.24z m-220.16 161.28c-12.8 145.92 35.84 143.36 35.84 143.36-56.32-38.4-5.12-199.68-5.12-199.68 15.36-38.4 17.92 0 17.92 0-23.04 43.52-15.36 84.48-15.36 84.48 12.8-102.4 107.52-115.2 107.52-115.2-69.12 99.84-64 204.8-64 204.8h2.56c-7.68 0-10.24 2.56-10.24 2.56-20.48-56.32 0-130.56 0-130.56-35.84 38.4-15.36 156.16-15.36 156.16-2.56 7.68-12.8 2.56-12.8 2.56-10.24 0-28.16 38.4-28.16 38.4-5.12 0-12.8-17.92-12.8-17.92-5.12 12.8 0 17.92 0 17.92 5.12 30.72 2.56 25.6 2.56 25.6-5.12 2.56-10.24-15.36-10.24-15.36-7.68 15.36 2.56 33.28 2.56 33.28l-2.56 15.36s-46.08-64-66.56-130.56c20.48-56.32 74.24-115.2 74.24-115.2z m-87.04 92.16s-5.12 33.28 79.36 168.96c0 15.36 0 30.72 2.56 46.08 0 0-61.44-56.32-76.8-158.72 0 0-7.68-48.64-5.12-56.32z m934.4 115.2s-17.92-20.48-23.04-10.24l17.92 15.36s0 30.72-35.84 33.28c0 0-12.8 17.92-53.76 17.92 0 0-25.6 2.56-33.28 10.24 0 0-10.24 7.68-46.08 5.12 0 0 10.24 5.12 30.72 5.12 0 0 12.8-2.56 15.36 2.56 0 0 20.48 7.68 20.48 10.24s53.76-30.72 74.24 0c0 0 5.12 10.24 10.24 10.24 0 0 2.56 12.8 0 15.36s-10.24-7.68-10.24 0c0 0 17.92 2.56 10.24 23.04 0 0-15.36 23.04-35.84 5.12 0 0-28.16 5.12-35.84 0 0 0-23.04 74.24-138.24 53.76 0 0-46.08-10.24-66.56-76.8 0 0-28.16-120.32-140.8-89.6 0 0 71.68-5.12 104.96 40.96 0 0 25.6 20.48 40.96 81.92 0 0 17.92 43.52 64 51.2 0 0 33.28 2.56 10.24 46.08 0 0-12.8 20.48-40.96 35.84 0 0-10.24 5.12-7.68 12.8 0 0-2.56 15.36 12.8 2.56 0 0 58.88-33.28 76.8 12.8 0 0 5.12 10.24 0 12.8 0 0-5.12 0-7.68-5.12 0 0-5.12-12.8-12.8-10.24 0 0 15.36 10.24 10.24 30.72 0 0-12.8 15.36-17.92 0 0 0 5.12-28.16-15.36-23.04 0 0 20.48 15.36 5.12 30.72 0 0-7.68 5.12-23.04 2.56 0 0-7.68-10.24-46.08 0h-332.8s-174.08-2.56-276.48-156.16c0 0-46.08-84.48-48.64-140.8L76.8 742.4l-33.28-81.92v-56.32c0-10.24 2.56-20.48 2.56-25.6 2.56-10.24 12.8 79.36 89.6 176.64 10.24 40.96 30.72 66.56 30.72 66.56-20.48 0-48.64-28.16-48.64-28.16 30.72 48.64 76.8 61.44 76.8 61.44 61.44 51.2 122.88 64 122.88 64-43.52-10.24-92.16-51.2-92.16-51.2-46.08-35.84-69.12-94.72-69.12-94.72 0-20.48 23.04-56.32 23.04-56.32 30.72-46.08 110.08-58.88 110.08-58.88 46.08-2.56 102.4-12.8 102.4-12.8-12.8 5.12-30.72 43.52-30.72 43.52-2.56 5.12-23.04 7.68-23.04 7.68C248.32 706.56 230.4 742.4 230.4 742.4c15.36-12.8 43.52-23.04 43.52-23.04 15.36-7.68 71.68-10.24 71.68-10.24-23.04 87.04 10.24 156.16 10.24 156.16-30.72-94.72 12.8-163.84 12.8-163.84 56.32-84.48 148.48-102.4 148.48-102.4 33.28-10.24 115.2-30.72 115.2-30.72 56.32-20.48 84.48-58.88 84.48-58.88 12.8-20.48 40.96-33.28 51.2-38.4 0 7.68 5.12 15.36 12.8 20.48 0 0 10.24 2.56 5.12-15.36 0 0-10.24-10.24 5.12-33.28 0 0 17.92-20.48 30.72-23.04 0 0 23.04 17.92 25.6 35.84 0 0 97.28 15.36 110.08 99.84 0 0 2.56 15.36 2.56 20.48 0 0 0 10.24 10.24 25.6 5.12-5.12 20.48 20.48 12.8 33.28z'
            p-id='6294'
          ></path>
        </svg>
      )}
    />
  );
};
export const FlinkSQLEnvSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <Icon
      component={() => (
        <svg
          className='icon'
          viewBox='0 0 1024 1024'
          version='1.1'
          xmlns='http://www.w3.org/2000/svg'
          width={size}
          height={size}
        >
          <path
            d='M662.235 337.091l-1.219 12.434-1.414 8.046 0.537-0.634c3.267-3.755 6.68-7.51 10.581-11.556l16.994-16.775 1.365-5.022a368.45 368.45 0 0 1 6.339-20.285l3.51-9.655c6.779-17.432 15.117-33.402 26.162-49.25 13.458-19.992 40.496-24.868 61.635-10.508 4.486 3.511 8.29 7.802 11.069 12.435l2.438 4.778 25.526 56.345 4.438 2.633 5.217 3.316c9.972 6.778 17.31 12.678 23.48 19.505 26.818 27.306 42.203 62.22 43.153 95.524 1.536 45.983-24.795 79.409-62.488 89.234l-1.56 0.317 4.047 7.607c3.486 7.168 6.558 14.629 9.094 22.333l3.755 13.068c7.802 32.525-4.048 56.564-32.988 64.269a49.917 49.917 0 0 1-33.085-1.853l-20.48-4.51 0.512 5.12c19.261 19.382 17.481 42.885 17.993 58.513a309.638 309.638 0 0 1-3.925 25.357c-2.121 11.507-4.632 25.697-7.485 42.593 8.777 12.24 17.823 12.849 16.945 36.23-0.902 23.357-31.549 23.577-58.929 25.966l-6.485 0.244-43.593 0.146a21.699 21.699 0 0 1-3.901-43.057l3.9-0.39 46.276-0.853c-10.387-10.947-8.485-25.113-3.926-39.497 3.024-9.582 5.267-24.99 6.73-46.202 3.486-11.386-2.243-39.083-13.727-54.711-11.459-15.628-16.92-24.674-17.067-33.085-0.195-8.411-0.39-16.994 4.706-24.283 5.071-7.266 12.337-7.412 22.723-8.753 10.386-1.366 24.235 1.121 35.084 6.339l32.695 11.142c7.85 3.608 11.215 4.242 13.75 3.56l2.658-0.878c1.22-0.683 1.415-1.853 0.78-5.12l-1.706-7.46a137.704 137.704 0 0 0-12.654-31.501l-6.193-10.337-6.046-7.9-7.51-9.118a21.723 21.723 0 0 1 21.212-35.426c34.012 7.826 58.563-11.02 57.442-45.69-0.634-22.284-11.46-46.811-31.232-67.047a89.137 89.137 0 0 0-16.458-13.41 96.84 96.84 0 0 0-11.459-6.583 21.748 21.748 0 0 1-8.338-7.314l-1.853-3.218-28.55-62.928-6.193 9.509a197.302 197.302 0 0 0-10.654 19.992l-4.389 10.484c-4.144 10.996-7.704 22.43-11.312 36.328a21.748 21.748 0 0 1-5.95 10.167l-7.655 7.363c-7.436 6.973-14.507 14.311-21.236 21.943l-3.9 4.68-8.534 6.437c-9.07 3.852-82.164 43.008-115.395 79.458-12.995 14.263-46.47 68.218-52.541 80.945-7.144 13.628-30.306 14.287-33.012 1.511-2.682-12.751-3.803-46.836 28.038-89.966 26.088-35.352 40.74-41.008 73.338-78.896 14.507-16.823 24.771-33.89 27.55-49.055 2.804-15.19 7.12-51.249-4.998-74.557-37.79-72.777-183.052-65.048-267.995-7.265l0.878-0.342 1.95-0.097c43.886 0 66.56 26.258 66.56 66.682 0 28.477-7.022 57.831-21.82 98.011l-8.778 23.065-10.045 24.722a217.38 217.38 0 0 0-16.896 76.97 21.748 21.748 0 0 1-43.422-1.267 257.867 257.867 0 0 1 15.457-80.043l4.876-12.678 5.12-12.532 9.192-23.26c15.311-40.325 22.845-68.802 22.845-92.988 0-16.092-3.95-22.187-18.286-23.113l-4.657-0.147c-46.982 0.342-63.439-62.537-24.551-80.579 99.596-68.12 265.606-72.265 326.07 21.31 16.994 26.233 24.406 58.148 21.87 94.963z m136.192 40.911a24.381 24.381 0 1 1 0.025 48.762 24.381 24.381 0 0 1 0-48.762z'
            fill='#D95470'
          ></path>
          <path
            d='M299.74 797.598c12.604-13.312 18.919-30.012 18.919-50.151 0-19.627-5.413-34.621-16.189-44.983-6.948-6.68-17.213-12.02-30.842-15.994l-31.061-9.118c-12.02-3.487-19.846-6.534-23.528-9.119-5.437-3.316-8.777-10.215-8.557-17.627-0.22-8.095 3.096-15.702 8.68-20.041 5.802-4.78 13.555-7.168 23.259-7.168 8.752 0 16.042 1.853 21.918 5.534 8.802 5.559 13.531 14.994 14.19 28.258h36.23c-0.658-23.406-7.705-41.277-21.114-53.59-13.41-12.312-29.647-18.456-48.64-18.456-22.772 0-40.034 6.534-51.785 19.553-11.727 13.069-17.628 29.477-17.628 49.201 0 21.626 6.096 37.498 18.237 47.665 7.193 6.095 20.163 11.703 38.912 16.896l19.115 5.242c11.19 2.999 19.383 6.412 24.6 10.289 4.974 3.437 7.973 9.947 7.827 16.896 0 12.458-5.267 20.967-15.775 25.575-5.559 2.39-12.775 3.56-21.674 3.56-14.873 0-25.357-4.51-31.452-13.58-3.34-4.974-5.608-12.508-6.729-22.577h-35.986c0 22.918 6.729 40.935 20.187 54.028 13.483 13.117 31.94 19.675 55.467 19.675 22.991 0 40.79-6.656 53.394-19.992z m183.734 31.354l19.7-25.112-20.797-23.747c6.193-8.363 10.898-18.895 14.068-31.549 3.9-13.239 5.876-29.696 5.876-49.323 0-37.059-9.143-65.901-27.404-86.552-15.848-17.823-35.426-26.746-58.759-26.746-23.161 0-42.569 8.411-58.124 25.283-19.114 20.626-28.647 51.054-28.647 91.307 0 39.96 9.289 70.241 27.916 90.868 15.335 17.14 34.743 25.697 58.246 25.697 11.264 0 20.919-1.633 29.013-4.9a84.846 84.846 0 0 0 17.14-10.338l21.772 25.112z m-97.524-61.586c-12.75-13.044-19.114-34.645-19.114-64.853 0-25.82 4.437-45.178 13.336-58.149 8.9-12.97 20.822-19.431 35.743-19.431 15.92 0 28.013 6.753 36.279 20.285 8.289 13.482 12.434 32.597 12.434 57.295 0 10.752-0.902 20.187-2.682 28.282-1.17 5.363-3.17 11.63-5.998 18.773l-18.237-21.211-19.456 24.844 18.213 21.211a41.301 41.301 0 0 1-20.919 5.681c-11.508 0-21.382-4.242-29.623-12.727z m247.955 4.974h-76.093V591.604h-37.693v220.33h113.786V772.34z'
            fill='#D95470'
          ></path>
          <path
            d='M512 0c282.77 0 512 229.23 512 512s-229.23 512-512 512S0 794.77 0 512 229.23 0 512 0z m0 48.762C256.17 48.762 48.762 256.17 48.762 512S256.17 975.238 512 975.238 975.238 767.83 975.238 512 767.83 48.762 512 48.762z'
            fill='#D95470'
          ></path>
        </svg>
      )}
    />
  );
};

export const FlinkJarSvg = (props: { size?: number }) => {
  const { size = 16 } = props;

  return (
    <Icon
      component={() => (
        <svg
          className='icon'
          viewBox='0 0 1084 1024'
          version='1.1'
          xmlns='http://www.w3.org/2000/svg'
          width={size}
          height={size}
        >
          <path
            d='M705.636962 230.301473l-1.686542 17.166584-1.98771 11.143221 0.783038-0.903504c4.758457-5.421027 9.637381-10.78182 14.636771-15.961912l23.491116-23.189947 1.867242-6.987101a525.83958 525.83958 0 0 1 8.79411-28.008637l4.81869-13.371866c9.45668-24.153685 20.961303-46.199193 36.260645-68.124234 18.612191-27.707469 56.017275-34.393402 85.230585-14.576538 6.204064 4.81869 11.444389 10.842053 15.359575 17.166584l3.373083 6.625699 35.296907 78.00255 6.14383 3.614017 7.228035 4.577756c13.733267 9.396446 23.972984 17.58822 32.465926 26.984666 37.103915 37.766485 58.42662 86.134089 59.631293 132.152582 2.228644 63.606712-34.272935 109.866139-86.375024 123.478939l-2.168411 0.421635 5.601728 10.540885c4.81869 9.938549 9.035044 20.238499 12.588828 30.899852l5.180092 18.070088c10.842053 44.994521-5.601727 78.303717-45.65709 88.904836-15.058407 4.397055-31.261253 3.49355-45.777558-2.529812l-8.011073-3.192382 0.66257 7.047334c0.602336 11.926259-0.481869 24.093452-3.252616 36.441346l-3.192382 12.528595-9.516914 31.441954c12.106959 16.92565 18.672425 38.067653 18.190556 58.486853l-0.84327 10.11925c-4.999391 34.754804-30.478216 58.968723-68.365169 62.281572l-8.974811 0.361402h-79.146988a30.056581 30.056581 0 0 1-30.056581-27.346067c-1.385373-15.480043-432.658156-265.449602-448.559834-265.931472a30.116814 30.116814 0 0 1-29.21331-29.092842 356.583083 356.583083 0 0 1 21.382938-110.829878l6.746167-17.467752 7.107568-17.347285 12.649062-32.164758c21.202237-55.77634 31.622655-95.169134 31.622655-128.659031 0-22.286443-5.421027-30.719151-25.298124-31.923823l-6.444998-0.240935c-65.052319 0.481869-87.760397-86.555725-33.971767-111.492447 137.814543-94.265629 367.48537-99.987824 451.14988 29.514478 23.491115 36.260645 33.730832 80.411894 30.237282 131.309311z'
            fill='#FFCEE8'
          ></path>
          <path
            d='M675.39968 98.811461c23.491115 36.381112 33.730832 80.532362 30.237282 131.490012l-1.686542 17.166584-1.98771 11.143221 0.783038-0.903504c4.758457-5.421027 9.637381-10.78182 14.636771-15.961912l23.491116-23.189947 1.867242-6.987101a525.83958 525.83958 0 0 1 8.79411-28.008637l4.81869-13.371866c9.45668-24.153685 20.961303-46.199193 36.260645-68.124234 18.612191-27.707469 56.017275-34.393402 85.230585-14.576538 6.204064 4.81869 11.444389 10.842053 15.359575 17.166584l3.373083 6.625699 35.296907 78.00255 6.14383 3.614017 7.228035 4.577756c13.733267 9.396446 23.972984 17.58822 32.465926 26.984666 37.103915 37.766485 58.42662 86.134089 59.631293 132.152582 2.228644 63.606712-34.272935 109.866139-86.375024 123.478939l-2.168411 0.421635 5.601728 10.540885c4.81869 9.938549 9.035044 20.238499 12.588828 30.899852l5.180092 18.070088c10.842053 44.994521-5.601727 78.303717-45.65709 88.904836-15.058407 4.397055-31.261253 3.49355-45.777558-2.529812l-8.011073-3.192382 0.66257 7.047334c0.602336 11.926259-0.481869 24.093452-3.252616 36.441346l-3.192382 12.528595-9.516914 31.441954c12.106959 16.92565 18.672425 38.067653 18.190556 58.486853l-0.84327 10.11925c-4.999391 34.754804-30.478216 58.968723-68.365169 62.281572l-8.974811 0.301168h-79.146988a30.056581 30.056581 0 0 1-5.421027-59.510825l5.421027-0.602336h79.146988c12.829763 0 16.684715-3.192382 17.768921-11.022754a37.284616 37.284616 0 0 0-7.228036-25.840227l-3.373083-3.674251a30.116814 30.116814 0 0 1-9.878315-28.430273l3.614018-14.034436 11.082987-37.103915c8.372474-27.2256 2.830981-52.523724-13.191164-76.85811a30.116814 30.116814 0 0 1 31.923823-45.777558c12.046726 2.65028 23.792283 7.348503 38.790457 14.576538l24.936722 12.347894c10.842053 4.999391 15.540276 5.902896 19.033827 4.939157l3.674251-1.204672c1.686542-0.963738 1.927476-2.590046 1.084206-7.107569l-2.409346-10.29995a190.518968 190.518968 0 0 0-17.467752-43.609147l-8.553175-14.27537-8.372475-10.902287-10.420417-12.649062a30.116814 30.116814 0 0 1 29.39401-49.030174c47.042464 10.842053 81.014231-15.239108 79.50839-63.24531-0.903504-30.779384-15.901678-64.690917-43.247745-92.759789a123.298238 123.298238 0 0 0-22.768312-18.491724 129.984171 129.984171 0 0 0-15.841444-9.095278 30.116814 30.116814 0 0 1-11.564857-10.119249l-2.529812-4.457289-39.513261-87.097827-8.613409 13.130931a265.931471 265.931471 0 0 0-14.697005 27.707469l-6.023363 14.456071a486.928656 486.928656 0 0 0-15.660744 50.29508 30.116814 30.116814 0 0 1-8.31224 14.094669l-10.540885 10.179484c-10.239717 9.637381-20.057798 19.75663-29.394011 30.357748l-5.421027 6.444999-11.805791 8.914577c-22.165975 9.45668-45.777558 20.901069-71.557551 34.513869-27.105133 14.395837-55.836574-16.142613-39.814429-42.16354 13.432099-21.804574 21.382938-42.645409 24.274153-64.57045 5.601727-44.572885-1.385373-80.472128-19.455462-108.420532C563.606065 36.650356 371.64149 41.469046 254.185914 121.399072l1.204672-0.481869 2.710514-0.120467c60.655264 0 92.097218 36.381112 92.097218 92.277919 0 39.392793-9.757848 79.990259-30.177048 135.585899l-12.167193 31.923823-13.913968 34.212701a300.746509 300.746509 0 0 0-23.370648 106.493056 30.116814 30.116814 0 0 1-60.052928-1.807009 356.583083 356.583083 0 0 1 21.382938-110.70941l6.746166-17.527986 7.107569-17.347285 12.649062-32.164758c21.202237-55.77634 31.622655-95.169134 31.622655-128.659031 0-22.286443-5.421027-30.719151-25.298124-31.923823l-6.444999-0.240935c-65.052319 0.481869-87.760397-86.555725-33.971766-111.492447 137.814543-94.265629 367.48537-99.987824 451.14988 29.514478V98.811461zM106.011187 637.42057v291.831932c0 50.475781-27.285834 76.19554-80.773297 76.19554H0v-44.81382h20.599901c20.599901 0 30.839618-11.323922 30.839618-33.429664v-289.723754h54.571668z m193.530649-7.228035c39.151859 0 67.943533 9.818082 86.495491 29.394011 15.901678 16.985883 24.153685 41.681671 24.153685 74.087363V903.532742h-50.415547v-37.585784a110.829877 110.829877 0 0 1-38.609756 31.923823c-17.467752 8.252007-38.067653 12.889997-61.73947 12.889997-27.827937 0-49.391576-7.228035-64.871618-21.08177a66.377459 66.377459 0 0 1-25.23789-54.089799c0-29.815646 11.866025-53.005593 35.537841-68.967505 21.623873-15.419809 52.463491-23.129713 91.555115-24.153685l59.75176-1.566075v-10.842053c0-37.043682-20.057798-55.535406-60.233629-55.535406-16.985883 0-30.839618 3.011681-41.139568 9.215746a47.223165 47.223165 0 0 0-23.189947 32.947795l-54.029565-4.63799c5.661961-28.791675 20.057798-50.415547 42.765876-63.847646 19.515696-12.28766 46.259427-17.949621 79.207222-17.949622z m296.469921 0c13.371866 0 25.177657 2.108177 34.453636 6.746166v54.571668a129.923937 129.923937 0 0 0-38.549522-5.661961c-16.504014 0-31.441954 6.625699-44.271718 20.057798-13.913968 14.456071-20.599901 33.429664-20.599901 56.619611V903.532742h-54.571667v-266.112172h54.571667v40.175831c6.625699-14.456071 15.419809-25.23789 25.71976-32.405693a65.052319 65.052319 0 0 1 43.247745-14.93794z m-239.85031 150.343137l-56.077508 1.505841c-49.993912 1.084205-74.6897 18.551958-74.6897 51.499753a30.116814 30.116814 0 0 0 12.889997 25.23789c8.252007 6.625699 19.575929 10.239717 33.489897 10.239717 23.129713 0 42.705643-7.228035 59.149424-21.08177 16.504014-13.853735 25.23789-31.381721 25.23789-51.981622v-15.419809zM78.725353 530.927514c10.842053 0 20.118032 3.011681 27.285834 10.239717 7.228035 6.746166 10.842053 15.480043 10.842053 26.261862 0 10.842053-3.614018 19.575929-10.842053 26.803965a40.898634 40.898634 0 0 1-27.285834 10.239717 37.34485 37.34485 0 0 1-26.201629-10.239717 35.417374 35.417374 0 0 1-11.323922-26.803965c0-10.842053 3.614018-19.515696 11.323922-26.201628 7.228035-7.228035 15.901678-10.299951 26.201629-10.299951z m815.3224-244.066664a33.730832 33.730832 0 1 1 0 67.461665 33.730832 33.730832 0 0 1 0-67.461665z'
            fill='#E04D9D'
          ></path>
        </svg>
      )}
    />
  );
};

export const LogSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        style={{ ...IconStyle }}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M109.7 697c40.2-24.1 115.8-36.2 226.6-36.2 77.9 0 168.5 42.8 335.4 70.6 83.9 14 164.8 14 242.6 0l-22.4 208-782.2 11.4V697z m782.2-104.2c-40.4 0-73.1-32.7-73.1-73.1s32.7-73.1 73.1-73.1 73.1 32.7 73.1 73.1-32.7 73.1-73.1 73.1z'
              fill='#66CCFF'
            ></path>
            <path
              d='M71.7 688.9V324.5H64c-15.1 0-27.4-12.3-27.4-27.4 0-15.1 12.3-27.4 27.4-27.4h7.7V139c0-51.5 41.8-93.3 93.3-93.3h672.9c51.5 0 93.3 41.8 93.3 93.3v309.6h-54.9V139c0-21.2-17.2-38.4-38.4-38.4h-673c-21.2 0-38.4 17.2-38.4 38.4v130.7h7.7c15.1 0 27.4 12.3 27.4 27.4 0 15.1-12.3 27.4-27.4 27.4h-7.7v364.3h7.7c15.1 0 27.4 12.3 27.4 27.4 0 15.1-12.3 27.4-27.4 27.4h-7.7V885c0 21.2 17.2 38.4 38.4 38.4h672.9c21.2 0 38.4-17.2 38.4-38.4V558.8h54.9V885c0 51.5-41.8 93.3-93.3 93.3H164.9c-51.5 0-93.3-41.8-93.3-93.3V743.7H64c-15.1 0-27.4-12.3-27.4-27.4 0-15.1 12.3-27.4 27.4-27.4h7.7z m211.7-396.3h384c15.1 0 27.4 12.3 27.4 27.4s-12.3 27.4-27.4 27.4h-384c-15.1 0-27.4-12.3-27.4-27.4s12.3-27.4 27.4-27.4z m0 182.8h384c15.1 0 27.4 12.3 27.4 27.4 0 15.1-12.3 27.4-27.4 27.4h-384c-15.1 0-27.4-12.3-27.4-27.4 0-15.1 12.3-27.4 27.4-27.4zM896 594.3c-50.5 0-91.4-40.9-91.4-91.4s40.9-91.4 91.4-91.4 91.4 40.9 91.4 91.4-40.9 91.4-91.4 91.4z m0-36.6c30.3 0 54.9-24.6 54.9-54.9S926.3 448 896 448s-54.9 24.6-54.9 54.9 24.6 54.8 54.9 54.8z'
              fill='#4E5F80'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const ScalaSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M213.844 203.564l596.4-87.928v197.952l-596.4 87.928zM213.788 457.312l596.4-87.928v197.952l-596.4 87.928zM213.768 710.4l596.392-87.932v197.952L213.768 908.348z'
              fill='#F44336'
            ></path>
            <path
              d='M225.12 366.636l382.416 123.684-11.328 35.028-382.416-123.684zM427.76 245.496l382.416 123.688-11.328 35.028-382.416-123.688zM225.112 620.148l382.416 123.684-11.328 35.032-382.416-123.688zM427.792 498.604l382.416 123.688-11.332 35.028-382.412-123.688z'
              fill='#F44336'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const PythonSvg = (props: { size?: number }) => {
  const { size = 16 } = props;
  return (
    <>
      <Icon
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M366.635375 495.627875c8.93024999-1.488375 17.8605-2.480625 26.79075-2.48062499h-7.44187499 241.61287499c10.418625 0 20.341125-1.488375 30.26362501-3.969 44.65124999-12.403125 77.3955-52.093125 77.3955-101.20950002V185.053625c0-57.5505-49.116375-101.2095-107.65912501-110.63587501-37.209375-5.9535-91.287-8.93024999-128.00025-8.93024999-36.71325001 0-71.938125 3.472875-103.194 8.93024999C305.115875 90.29374999 288.74374999 123.534125 288.74374999 185.053625v66.48075h223.25625001V288.74374999H216.3095C133.456625 288.74374999 65.983625 387.96874999 65.4875 510.0155v1.9845c0 22.325625 1.9845 43.659 6.449625 63.504C90.29374999 667.78325001 147.84424999 735.25625001 216.3095 735.25625001h35.224875v-106.66687501c0-62.51174999 46.63574999-120.558375 115.101-132.9615z m23.814-283.7835c-22.325625 0-40.68225001-18.356625-40.18612499-40.68225 0-22.325625 17.8605-40.68225001 40.18612499-40.68225s40.68225001 18.356625 40.68225 40.68225c-0.496125 22.82175001-18.356625 40.68225001-40.68225 40.68225z'
              fill='#0075AA'
            ></path>
            <path
              d='M949.086125 434.108375C927.75275001 349.271 872.682875 288.74374999 807.6905 288.74374999h-35.224875v94.75987501c0 78.883875-51.597 135.93825001-115.101 145.86075-6.449625 0.99224999-12.89925001 1.488375-19.34887499 1.48837501H396.402875c-10.418625 0-20.341125 1.488375-30.26362499 3.969-44.65124999 11.907-77.3955 48.62025001-77.3955 96.74437499V834.48125001c0 57.5505 58.046625 91.783125 115.10099998 108.15524999 67.969125 19.845 142.387875 23.317875 224.24850002 0 54.077625-15.379875 107.163-46.63574999 107.16299998-108.15525001v-61.5195h-223.25624999V735.25625001h295.6905c58.54275001 0 109.643625-49.6125 134.449875-122.04675001 10.418625-30.263625 16.372125-64.49625001 16.372125-101.2095 0-27.286875-3.472875-53.5815-9.426375-77.891625z m-316.52775 372.58987501c22.325625 0 40.186125 18.356625 40.186125 40.68224999 0 22.325625-18.356625 40.68225001-40.186125 40.68225001-22.325625 0-40.68225001-18.356625-40.68225-40.68225001 0.496125-22.325625 18.356625-40.68225001 40.68225-40.68225001z'
              fill='#FFD400'
            ></path>
          </svg>
        )}
      />
    </>
  );
};
