/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import Icon from '@ant-design/icons';

const defaultSvgSize = '100%';

const style = { overflow: 'hidden' };

export const DingTalkSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M512.003 79C272.855 79 79 272.855 79 512.003 79 751.145 272.855 945 512.003 945 751.145 945 945 751.145 945 512.003 945 272.855 751.145 79 512.003 79z m200.075 375.014c-0.867 3.764-3.117 9.347-6.234 16.012h0.087l-0.347 0.648c-18.183 38.86-65.631 115.108-65.631 115.108l-0.215-0.52-13.856 24.147h66.8L565.063 779l29.002-115.368h-52.598l18.27-76.29c-14.76 3.55-32.253 8.436-52.945 15.1 0 0-27.967 16.36-80.607-31.5 0 0-35.501-31.29-14.891-39.078 8.744-3.33 42.466-7.573 69.004-11.122 35.93-4.845 57.965-7.441 57.965-7.441s-110.607 1.643-136.841-2.468c-26.237-4.11-59.525-47.905-66.626-86.377 0 0-10.953-21.117 23.595-11.122 34.547 10 177.535 38.95 177.535 38.95s-185.933-56.992-198.36-70.929c-12.381-13.846-36.406-75.902-33.289-113.981 0 0 1.343-9.521 11.127-6.926 0 0 137.49 62.75 231.475 97.152 94.028 34.403 175.76 51.885 165.2 96.414z'
              fill='#3AA2EB'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const WeChatSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M523.9 691.2c-28.2 8.6-57.1 13.3-85.4 13.3-20.6 0-42.5-2.6-61.8-4.9-30.8-3.6-55.2-6.5-73.6 0.1-15.2 5.4-30.9 17.5-47.5 30.4-8.8 6.8-17.9 13.8-26.1 19.1 1.1-4.9 2.3-9.9 3.3-13.8 6.8-27.4 13.9-55.7-0.2-77.4-3.6-5.5-9-12.5-15.8-21.3-32.2-41.5-99.3-128-86.6-210.3 5.3-34.1 23-99.2 82.4-152.2 57.7-51.6 138.5-77.7 240.2-77.7 60.8 0 132.1 26.9 185.9 70.1 60.3 48.4 93.5 111.6 93.5 177.9 0 4.7-0.2 9.3-0.5 13.9 2.2 0 4.3-0.1 6.5-0.1 18.4 0 36.2 1.8 53.3 5.1 0.4-6.3 0.7-12.6 0.7-19 0-84.8-41.2-164.6-115.9-224.6-65-52.2-148.5-83.4-223.5-83.4-60.6 0-116 8.7-164.5 25.7-44.2 15.6-83.1 38.2-115.7 67.3C118.2 278 82.1 344.7 70.9 417.2c-7.3 47.3 3 99 30.7 153.9 22 43.5 50.6 80.4 67.7 102.4 4.7 6 8.8 11.4 11.4 15 0.2 6.7-3.8 22.6-6.2 32.4-3.3 13.3-6.7 27-7.6 39.7-2 29 10.7 43 21.7 49.6 7.7 4.6 16.1 6.9 25.2 6.9 11.1 0 23.2-3.5 36.1-10.4 14.4-7.7 28.6-18.6 42.3-29.2 10.4-8 24.6-19 30.9-21.3 6.7-1.8 30.7 1.1 46.6 2.9 21 2.5 44.8 5.3 68.8 5.3 38.5 0 79-7.2 117.8-20.8-14.2-15.7-25.2-33.3-32.4-52.4z'
              fill='#0685EE'
            ></path>
            <path
              d='M811.4 547.7c-5.2-13-11.1-25.7-20.8-35.6-8.9-9-20.4-14.4-33.1-14.4-28.1 0-50.9 22.8-50.9 50.9 0 14.3 6.2 28.2 16.9 37.8 5.2 4.7 11.4 8.3 18.1 10.5 18.9 6.2 37.6 13.3 55.7 21.7 9.1 4.2 18.1 8.8 26.9 13.8 8.5 4.9 16.1 12.6 26.2 13.7 7 0.7 6.2-5.6 3.7-10.1-11-19.9-22.3-39.8-31.7-60.5-4-8.9-7.3-18.4-11-27.8z'
              fill='#36BB06'
            ></path>
            <path
              d='M904.2 740c13-5.1 25.7-11.1 35.6-20.8 9-8.9 14.4-20.4 14.4-33.1 0-28.1-22.8-50.9-50.9-50.9-14.3 0-28.2 6.2-37.8 16.9-4.7 5.2-8.3 11.4-10.5 18.1-6.2 18.9-13.3 37.6-21.7 55.7-4.2 9.1-8.8 18.1-13.8 26.9-4.9 8.5-12.6 16.1-13.7 26.2-0.7 7 5.6 6.2 10.1 3.7 19.9-11 39.8-22.3 60.5-31.7 8.9-4 18.4-7.3 27.8-11z'
              fill='#0383EE'
            ></path>
            <path
              d='M620.5 632.3c-13 5.1-25.7 11.1-35.6 20.8-9 8.9-14.4 20.4-14.4 33.1 0 28.1 22.8 50.9 50.9 50.9 14.3 0 28.2-6.2 37.8-16.9 4.7-5.2 8.3-11.4 10.5-18.1 6.2-18.9 13.3-37.6 21.7-55.7 4.2-9.1 8.8-18.1 13.8-26.9 4.9-8.5 12.6-16.1 13.7-26.2 0.7-7-5.6-6.2-10.1-3.7-19.9 11-39.8 22.3-60.5 31.7-8.9 4-18.4 7.3-27.8 11z'
              fill='#FFD301'
            ></path>
            <path
              d='M710.5 831.9c5.1 13 11.1 25.7 20.8 35.6 8.9 9 20.4 14.4 33.1 14.4 28.1 0 50.9-22.8 50.9-50.9 0-14.3-6.2-28.2-16.9-37.8-5.2-4.7-11.4-8.3-18.1-10.5-18.9-6.2-37.6-13.3-55.7-21.7-9.1-4.2-18.1-8.8-26.9-13.8-8.5-4.9-16.1-12.6-26.2-13.7-7-0.7-6.2 5.6-3.7 10.1 11 19.9 22.3 39.8 31.7 60.5 4 8.9 7.3 18.5 11 27.8z'
              fill='#FF6005'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const FeiShuSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M738.588528 406.663717c-2.36797 0.127998-2.943963-0.959988-3.19996-3.19996-0.255997-2.36797-0.127998-5.183935-1.279984-7.039912-2.239972-3.519956-1.59998-7.679904-3.519956-11.327859a20.095749 20.095749 0 0 1-2.239972-6.207922c-0.127998-1.279984 0.191998-3.071962-0.703991-3.775953-2.047974-1.471982-1.279984-3.839952-2.559968-5.759928-1.407982-2.047974-1.471982-5.055937-2.559968-7.551906-1.087986-2.623967-2.43197-5.439932-2.687966-8.319896-0.127998-1.407982-1.727978-1.471982-1.66398-2.879964 0.127998-2.36797-1.59998-4.287946-2.175972-6.527918-0.76799-3.007962-2.43197-5.887926-3.583956-8.83189-0.895989-2.36797-1.855977-4.79994-2.943963-6.911913-1.59998-3.19996-2.943963-6.463919-4.79994-9.59988-1.791978-2.751966-2.303971-6.335921-4.223947-9.343883a52.287346 52.287346 0 0 1-4.095949-7.871902c-1.855977-4.351946-4.543943-8.127898-6.655917-12.287846a169.533881 169.533881 0 0 0-6.591917-12.095849c-2.239972-3.775953-4.223947-7.743903-6.847915-11.391858-1.023987-1.471982-2.687966-2.943963-2.943963-4.607942-0.383995-2.43197-2.239972-4.159948-3.391957-5.567931-1.59998-1.919976-1.663979-5.311934-4.79994-6.015924 0 0-0.127998-0.319996-0.064-0.447995 0.255997-2.559968-3.327958-3.263959-3.007962-5.887926-2.751966-0.959988-1.983975-4.991938-5.119936-5.759928 0 0-0.127998-0.255997-0.063999-0.383995 0.255997-2.559968-2.239972-3.96795-3.327959-5.63193a43.19946 43.19946 0 0 0-4.79994-6.015925c-0.83199-0.895989-2.239972-1.663979-2.559968-2.751965-1.087986-3.839952-4.735941-5.759928-6.591917-9.087887-1.727978-3.071962-4.735941-5.119936-7.103912-7.679904a24.575693 24.575693 0 0 0-8.319896-6.39992c-3.007962-1.151986-5.375933-3.583955-8.959888-3.775953-3.711954-0.191998-7.23191-2.36797-11.13586-2.239972 0-0.83199-0.255997-1.471982-1.279984-1.471981H214.883074c-1.023987 0-1.279984 0.639992-1.279984 1.471981-2.559968-0.191998-3.96795 1.919976-4.79994 3.455957-1.919976 3.391958 0.83199 9.59988 4.543944 11.071862 1.535981 0.575993 2.36797 1.663979 3.455956 2.687966 0.575993 0.575993 1.087986 1.471982 1.919976 1.343983 1.535981-0.127998 2.239972 0.959988 2.687967 1.855977 0.575993 1.215985 1.663979 1.663979 2.559968 2.111974a32.511594 32.511594 0 0 1 7.423907 5.311933c3.327958 3.071962 7.039912 5.56793 10.623867 8.191898 3.007962 2.175973 5.439932 5.055937 8.703891 6.847914 2.495969 1.279984 3.839952 4.159948 6.207923 5.311934 3.327958 1.663979 5.183935 4.863939 8.383895 6.527918 1.983975 1.023987 3.519956 2.687966 4.927938 4.351946 1.279984 1.471982 3.583955 1.535981 4.607943 3.007962 3.007962 4.479944 8.127898 6.527918 11.647854 10.559868 3.455957 3.903951 8.319896 6.271922 11.903851 10.367871 4.223947 4.927938 9.983875 8.447894 14.591818 13.055837 3.19996 3.19996 6.463919 6.207922 9.727878 9.279884 2.559968 2.36797 5.119936 4.735941 7.551906 7.231909 1.791978 1.791978 4.095949 3.19996 5.759928 4.79994 4.159948 4.03195 8.959888 7.615905 11.839852 12.79984l0.639992 0.767991c3.19996 3.007962 6.39992 6.015925 9.471882 9.087886 3.839952 3.839952 7.551906 7.935901 11.711853 11.583855a15.743803 15.743803 0 0 1 4.223947 4.735941c0.83199 1.919976 2.303971 3.19996 3.583956 4.415945 3.519956 3.455957 7.359908 6.655917 9.855876 11.007862 1.023987 1.791978 3.135961 2.43197 4.223948 4.159948 1.407982 2.175973 3.519956 3.711954 4.927938 6.015925 2.047974 3.391958 5.56793 5.759928 7.935901 9.279884 2.303971 3.455957 5.375933 6.783915 8.319896 9.727879 3.327958 3.327958 5.63193 7.423907 9.151885 10.431869 1.855977 1.535981 2.047974 4.479944 4.415945 5.439932 1.215985 0.511994 1.59998 1.535981 1.919976 2.367971 1.279984 2.751966 3.647954 4.671942 5.119936 7.231909 1.471982 2.559968 3.96795 4.159948 5.63193 6.655917 3.071962 4.735941 6.591918 9.279884 10.431869 13.439832 1.215985 1.407982 1.087986 3.583955 2.879964 4.287946 2.687966 1.087986 3.135961 3.96795 4.543944 5.887927 1.791978 2.495969 4.223947 4.607942 5.56793 7.359908 1.407982 2.943963 3.839952 5.119936 5.375933 7.807902 1.407982 2.43197 3.19996 4.607942 4.671941 7.039912 1.087986 1.855977 2.111974 3.96795 3.711954 5.567931 1.727978 1.727978 2.239972 4.351946 4.223947 5.951925 1.791978 1.471982 2.175973 3.839952 3.839952 5.503931 1.727978 1.919976 2.43197 4.735941 4.351946 6.591918 1.663979 1.59998 2.495969 3.775953 3.647954 5.63193 0.83199 1.279984 2.559968 2.047974 2.751966 3.775952 0.191998 1.919976 1.663979 3.071962 2.623967 4.479944 1.471982 2.175973 3.391958 4.351946 4.223947 6.39992 1.535981 3.839952 4.159948 6.783915 6.015925 10.239872 2.175973 3.839952 4.863939 7.679904 7.039912 11.647855 1.663979 2.879964 3.327958 5.759928 5.119936 8.447894 0.76799 1.343983 0.639992 3.135961 2.111974 4.159948 1.791978 1.279984 2.175973 3.455957 3.19996 5.247935 0.895989 1.59998 1.535981 3.519956 2.815964 4.607942 1.023987 0.895989 1.023987 1.727978 1.215985 2.751966 1.535981 0.639992 2.303971-0.575993 3.19996-1.407983l7.167911-7.103911 14.783815-14.591818c4.223947-4.159948 8.127898-8.575893 12.479844-12.607842 7.679904-7.039912 14.719816-14.591818 22.39972-21.695729 4.991938-4.671942 9.471882-9.791878 14.975813-13.951825 4.79994-3.711954 8.83189-8.319896 13.183835-12.607843l9.663879-9.59988c3.327958-3.327958 7.679904-5.503931 10.751866-9.087886a2.687966 2.687966 0 0 1 0.959988-0.83199c3.19996-1.279984 5.439932-3.903951 8.127898-5.887926 3.135961-2.239972 6.271922-4.479944 9.343883-6.847915 1.535981-1.215985 3.519956-1.791978 4.86394-3.13596 3.839952-3.839952 8.959888-5.56793 13.439832-8.255897 4.735941-2.815965 9.59988-5.56793 14.591817-7.935901 3.519956-1.663979 6.655917-4.351946 10.495869-5.119936 4.415945-0.895989 7.679904-3.903951 11.839852-5.183935 1.279984-0.383995 2.879964-0.511994 4.03195-1.407983 2.43197-1.919976 5.695929-1.919976 8.447894-3.19996 1.279984-0.639992 2.687966-1.471982 4.159948-1.663979 3.327958-0.447994 6.271922-1.983975 9.471882-2.815965 0.895989-0.191998 1.59998-0.703991 0.831989-1.791977'
              fill='#00D6B9'
            ></path>
            <path
              d='M830.747376 641.156786c-0.959988-0.639992-1.535981 0.191998-2.111973 0.76799-1.727978 1.535981-2.943963 3.583955-4.415945 5.375933l-7.359908 8.575893c-5.055937 5.56793-10.495869 10.879864-15.9998 15.871801-4.287946 3.903951-9.087886 7.23191-13.695829 10.751866-1.727978 1.279984-3.455957 2.687966-5.247934 3.839952-1.919976 1.343983-3.647954 3.135961-5.759928 4.031949-4.03195 1.727978-7.615905 4.223947-11.327859 6.39992a167.037912 167.037912 0 0 1-20.223747 9.407883c-3.903951 1.59998-7.743903 3.327958-11.775853 4.607942-3.19996 1.023987-6.335921 2.36797-9.59988 3.19996-1.087986 0.255997-2.239972 0.127998-3.263959 0.511994-3.19996 1.215985-6.591918 1.919976-9.919876 2.751965-2.879964 0.76799-6.015925 0.127998-8.511894 1.279984-3.839952 1.791978-8.191898 0.127998-11.775852 2.559968-5.56793-0.063999-11.135861 0.575993-16.703792 1.023988-9.855877 0.76799-19.711754-0.639992-29.56763-0.895989-4.479944-0.127998-8.703891-2.36797-13.247835-1.727979-0.255997 0-0.511994-0.063999-0.703991-0.255996-1.471982-1.151986-3.19996-1.087986-4.863939-1.087987-3.455957 0-6.783915-0.76799-10.047874-1.407982-3.19996-0.639992-6.463919-1.855977-9.59988-2.943963-1.855977-0.639992-3.839952-0.255997-5.503932-1.087987a28.607642 28.607642 0 0 0-7.679904-2.431969c-6.143923-1.279984-11.839852-3.839952-18.047774-4.86394-4.095949-0.703991-7.679904-3.007962-11.775853-3.839952-2.879964-0.639992-5.695929-1.663979-8.447894-2.559968-3.519956-1.151986-7.039912-2.36797-10.623867-3.263959-5.695929-1.535981-10.943863-3.96795-16.511794-5.759928-6.655917-2.175973-13.119836-4.79994-19.775753-7.039912-3.903951-1.279984-7.423907-3.647954-11.647854-4.287946a14.591818 14.591818 0 0 1-5.119936-1.919976c-3.135961-1.791978-6.655917-2.43197-9.855877-3.967951-2.687966-1.279984-5.695929-1.919976-8.319896-3.19996-4.351946-2.239972-9.407882-2.943963-13.375833-6.079924-0.255997-0.191998-0.639992-0.255997-0.959988-0.255996-3.19996-0.319996-6.079924-1.791978-8.831889-3.19996-6.079924-2.943963-12.607842-4.927938-18.559768-8.191898-4.735941-2.623967-9.983875-4.095949-14.719816-6.655917-1.087986-0.255997-2.047974-0.063999-3.19996-0.639992-1.983975-0.959988-3.839952-2.559968-5.887927-3.071961-3.903951-1.087986-6.847914-3.903951-10.687866-5.055937-2.175973-0.639992-3.839952-2.559968-5.887927-3.071962-2.559968-0.639992-4.671942-1.919976-6.719916-3.071961-3.391958-1.919976-7.039912-3.19996-10.431869-5.311934-1.855977-1.151986-4.287946-1.535981-5.887927-2.879964-2.43197-2.047974-6.207922-1.919976-7.871901-4.991938-4.095949-0.319996-6.847914-3.455957-10.367871-4.927938-4.159948-1.727978-7.935901-4.351946-11.903851-6.591918-1.663979-0.959988-3.19996-2.687966-4.79994-3.007962-4.351946-0.895989-7.295909-3.96795-10.879864-5.887926a124.414445 124.414445 0 0 1-12.159848-7.295909c-0.639992-0.383995-1.59998-0.319996-2.047974-0.83199-2.559968-2.879964-6.207922-4.351946-9.343883-6.271921a424.186698 424.186698 0 0 1-9.279884-5.63193c-3.775953-2.36797-7.679904-4.735941-11.26386-7.295909-2.36797-1.727978-5.375933-2.751966-7.423907-4.735941-1.535981-1.407982-3.391958-1.919976-4.927938-3.19996-2.815965-2.303971-6.079924-4.159948-9.151886-6.271921-1.407982-0.959988-3.263959-1.855977-4.223947-2.879964-1.855977-2.047974-4.351946-3.071962-6.335921-4.735941-2.943963-2.495969-6.655917-4.223947-9.59988-6.847914-1.727978-1.535981-4.287946-1.791978-5.56793-3.967951-0.447994-0.83199-1.279984-1.407982-2.43197-1.727978-1.919976-0.511994-3.263959-2.111974-4.863939-3.19996-2.36797-1.59998-4.479944-3.775953-6.911914-5.439932-2.943963-1.983975-5.503931-4.607942-8.511893-6.39992-3.263959-1.983975-5.56793-5.055937-8.83189-6.911914-1.983975-1.215985-3.19996-3.455957-5.119936-4.351945-3.455957-1.535981-5.503931-4.543943-8.639892-6.39992-2.43197-1.535981-4.095949-4.415945-6.655917-5.759928-3.007962-1.59998-4.79994-4.415945-7.487906-6.271922-0.76799-0.575993-1.663979-0.639992-2.36797-1.535981-1.727978-2.111974-4.095949-3.647954-6.079924-5.503931-2.111974-1.919976-4.735941-3.19996-6.655917-5.503931-1.535981-1.663979-3.19996-3.903951-5.119936-4.671942-2.943963-1.087986-4.223947-3.711954-6.527919-5.375933-2.879964-2.047974-4.991938-4.991938-7.807902-7.231909-1.791978-1.407982-3.839952-2.559968-5.247934-4.351946C128.03616 453.383133 125.348194 451.143161 122.916224 448.83919 119.716264 445.703229 116.644302 442.43927 113.316344 439.431307 110.756376 437.127336 108.388406 434.567368 105.764438 432.263397 103.332469 430.087424 101.156496 427.655454 98.724526 425.479482 95.524566 422.535518 92.580603 419.20756 89.508642 416.071599 86.500679 412.871639 83.23672 409.927676 80.292757 406.663717 77.732789 403.783753 75.172821 400.263797 70.180883 401.351783 67.748914 401.863777 66.596928 403.399758 65.700939 405.383733 63.20497 405.63973 64.228958 407.559706 64.228958 408.647692V771.075162c0 1.471982 0.127998 2.879964 0.063999 4.287946 0 1.087986 0.383995 1.59998 1.407982 1.663979-0.639992 3.327958 1.59998 6.015925 2.111974 9.087887 0.319996 2.175973 1.727978 4.03195 2.559968 6.079924 1.215985 2.815965 3.583955 5.183935 5.247934 7.871901a21.823727 21.823727 0 0 0 5.63193 5.823927c2.303971 1.663979 4.671942 3.455957 7.16791 4.927939 2.943963 1.663979 5.759928 3.775953 8.511894 5.695929 0.83199 0.511994 1.791978 0.639992 2.687966 1.471981 2.559968 2.303971 5.823927 4.03195 8.959888 5.63193 2.111974 1.087986 4.095949 2.559968 6.39992 3.519956 5.119936 2.111974 9.471882 5.951926 14.719816 7.9999 2.943963 1.087986 5.183935 3.19996 8.191898 4.095949 0.703991 0.255997 1.535981 0.319996 2.111973 0.703991 4.223947 2.943963 9.023887 4.607942 13.567831 6.911913 0.959988 0.511994 2.175973 0.511994 2.943963 1.151986a18.815765 18.815765 0 0 0 8.319896 3.711954c0.511994 0.127998 1.023987 0.191998 1.59998 0.639992 1.279984 0.959988 2.879964 1.663979 4.351946 2.495968 1.663979 0.959988 3.839952 0.383995 5.375932 2.047975 0.575993 0.639992 1.919976 1.471982 3.007963 1.663979 4.479944 0.83199 8.639892 2.943963 12.79984 4.607942 1.279984 0.511994 2.943963 0 3.839952 0.959988 1.663979 1.727978 4.03195 1.663979 5.951925 2.559968 2.815965 1.215985 5.759928 2.175973 8.895889 2.943964 1.343983 0.319996 3.19996 0.063999 4.03195 0.959988 1.59998 1.791978 4.03195 1.919976 5.759928 2.36797 4.607942 1.087986 9.087886 2.559968 13.56783 4.095949 3.583955 1.279984 7.615905 1.535981 11.391858 2.687966 3.19996 0.895989 6.39992 1.919976 9.59988 2.495969 1.471982 0.255997 3.647954-0.319996 4.479944 0.447994 2.43197 2.43197 5.759928 1.023987 8.511893 2.367971 2.687966 1.279984 6.39992 1.791978 9.855877 1.535981 0.639992-0.063999 1.59998-0.191998 1.919976 0.127998 2.559968 2.559968 6.527918 0 8.959888 2.623967 5.759928 0.511994 11.519856 0.76799 17.151786 2.43197 3.647954 1.087986 7.679904 0.511994 11.519856 1.407982 4.671942 1.087986 9.727878 0.76799 14.591817 1.279984 3.19996 0.255997 6.335921 0.127998 9.471882 0.191998 0 1.023987 0.575993 1.407982 1.59998 1.343983h69.119136c1.023987 0 1.59998-0.319996 1.59998-1.343983 7.679904 0.383995 15.23181-1.407982 22.847714-1.151986h4.223948c1.023987 0.063999 1.59998-0.319996 1.53598-1.407982a78.079024 78.079024 0 0 0 10.239872-1.279984c5.375933-1.087986 11.007862-0.83199 16.383796-2.559968 2.687966-0.895989 5.759928-0.76799 8.639892-1.471982 3.327958-0.76799 6.847914-1.663979 10.495868-1.407982 0.383995 0 1.023987 0 1.215985-0.191998 1.791978-2.36797 4.79994-1.279984 7.167911-2.36797a18.495769 18.495769 0 0 1 8.319896-1.471982c0.383995 0 0.895989 0 1.279984-0.191997a20.479744 20.479744 0 0 1 8.191897-2.623968 54.39932 54.39932 0 0 0 11.327859-2.943963 49.983375 49.983375 0 0 1 8.383895-2.239972c0.639992-0.127998 1.343983-0.127998 1.663979-0.511993 1.59998-1.663979 3.96795-1.727978 5.759928-2.239972 3.711954-0.959988 7.23191-2.36797 10.879864-3.455957 1.215985-0.319996 2.623967 0.063999 3.647954-0.639992a22.527718 22.527718 0 0 1 9.471882-3.839952c0.575993-0.063999 1.087986-0.127998 1.59998-0.511994 1.663979-1.023987 3.19996-2.239972 5.311934-2.495969 2.943963-0.319996 5.759928-1.791978 8.319896-3.071961 2.175973-1.087986 4.607942-1.919976 6.847914-3.071962 1.727978-0.895989 3.583955-1.983975 5.695929-2.36797 3.007962-0.511994 4.991938-3.135961 8.063899-3.775953a22.719716 22.719716 0 0 0 6.527918-2.751966c3.263959-1.855977 6.655917-3.391958 9.983876-4.991937 2.111974-1.087986 4.543943-1.983975 6.271921-3.263959a47.871402 47.871402 0 0 1 8.319896-4.607943c3.711954-1.663979 6.975913-4.03195 10.687867-5.631929 3.19996-1.471982 6.079924-3.839952 9.279884-5.63193 1.59998-0.895989 3.071962-2.303971 4.607942-3.071962a63.807202 63.807202 0 0 0 5.119936-3.007962c2.175973-1.471982 4.735941-2.36797 6.591918-4.223947 1.663979-1.663979 3.903951-2.239972 5.631929-3.775953 2.047974-1.727978 4.79994-2.559968 6.719916-4.479944 0.639992-0.639992 1.023987-1.279984 1.919976-1.279984a3.071962 3.071962 0 0 0 2.367971-1.59998 5.503931 5.503931 0 0 1 2.559968-2.175973c3.007962-1.087986 4.607942-3.96795 7.423907-5.375933 1.727978-0.83199 3.19996-2.43197 4.79994-3.583955 2.751966-1.919976 5.375933-3.96795 7.9999-6.015925 1.471982-1.151986 2.751966-3.135961 4.223947-3.583955 3.19996-1.023987 4.159948-4.479944 7.167911-5.759928a9.919876 9.919876 0 0 0 2.751965-2.047974c2.303971-2.559968 5.119936-4.607942 7.679904-7.103911 1.59998-1.663979 3.775953-2.43197 5.311934-4.223948a46.207422 46.207422 0 0 1 6.015925-6.079924c1.919976-1.535981 3.711954-3.327958 5.375932-5.119936l9.59988-9.53588c3.19996-3.071962 6.207922-6.207922 9.407883-9.215885a40.319496 40.319496 0 0 0 5.119936-6.015925 32.255597 32.255597 0 0 1 5.759928-6.079924c1.663979-1.343983 2.175973-3.391958 3.711953-4.79994a27.135661 27.135661 0 0 0 5.823928-6.591918c1.727978-2.943963 4.671942-4.79994 6.271921-7.807902 1.151986-2.175973 3.391958-3.583955 4.735941-5.759928 1.343983-2.303971 3.19996-4.351946 4.927938-6.39992 1.919976-2.303971 4.095949-4.735941 5.375933-7.295909 1.343983-2.751966 3.775953-4.479944 5.119936-7.231909a43.519456 43.519456 0 0 1 4.927939-7.103912c1.279984-1.59998 2.047974-3.391958 3.13596-5.055936 1.663979-2.559968 3.455957-5.055937 5.247935-7.551906 0.703991-1.087986 0.83199-2.239972 1.791977-3.327958 1.727978-1.791978 3.647954-3.96795 3.19996-6.911914'
              fill='#3370FF'
            ></path>
            <path
              d='M958.745776 423.23951c-0.383995-0.447994-0.76799-0.447994-1.279984-0.575993-1.407982-0.447994-3.007962-0.76799-4.287946-1.535981a26.36767 26.36767 0 0 0-4.479944-2.559968c-2.36797-0.959988-5.119936-1.279984-7.103911-2.687966-2.751966-2.111974-6.207922-2.047974-9.151886-3.583956a22.783715 22.783715 0 0 0-6.655917-2.36797c-1.791978-0.319996-3.647954-1.151986-5.375933-1.663979-2.36797-0.76799-4.863939-1.59998-7.295908-2.239972a143.806202 143.806202 0 0 1-11.327859-3.263959 19.96775 19.96775 0 0 0-8.063899-1.343984c-0.639992-2.623967-2.751966-1.087986-4.223947-1.407982-1.919976 0-3.711954-0.959988-5.503931-1.279984-5.823927-1.023987-11.775853-1.215985-17.66378-2.559968-4.671942-1.023987-9.727878-0.447994-14.591817-1.151986-2.879964-0.383995-5.759928-0.127998-8.703891-0.191997 0-1.151986-0.575993-1.407982-1.59998-1.407983h-28.095649c-1.023987 0-1.59998 0.319996-1.59998 1.407983-7.16791-0.383995-14.207822 1.215985-21.375733 1.151985h-4.223947c-1.023987-0.063999-1.471982 0.383995-1.535981 1.343984-4.095949-0.383995-7.935901 1.407982-12.03185 1.151985a1.279984 1.279984 0 0 0-0.703991 0.191998c-3.135961 2.175973-6.975913 1.407982-10.36787 2.559968-2.687966 0.895989-5.951926 0.76799-8.511894 1.727978-2.047974 0.703991-4.351946 1.279984-6.39992 2.111974a18.623767 18.623767 0 0 1-7.9999 1.59998c0.063999 0.511994 0.191998 1.151986-0.511993 1.215985-1.59998 0.127998-3.071962 0.959988-4.479944 1.279984-4.223947 1.087986-8.191898 2.687966-12.287847 4.095948-3.583955 1.279984-6.911914 3.19996-10.431869 4.03195-4.03195 0.959988-6.847914 4.159948-11.071862 4.671942a7.103911 7.103911 0 0 0-3.647954 1.279984 13.119836 13.119836 0 0 1-3.903952 2.36797 26.36767 26.36767 0 0 0-6.39992 3.135961c-2.943963 1.919976-6.143923 3.19996-8.959888 5.119936-1.087986 0.76799-2.879964 0.447994-3.391957 1.279984-2.047974 3.583955-6.271922 3.647954-9.151886 5.887926-3.071962 2.36797-6.719916 4.159948-9.791877 6.463919-2.559968 1.919976-5.247934 3.711954-7.679904 5.759928-3.19996 2.751966-6.655917 5.247934-10.047875 7.679904-1.791978 1.279984-2.879964 3.647954-4.735941 4.223948-2.943963 1.023987-4.479944 3.455957-6.39992 5.247934-1.919976 1.919976-4.095949 3.903951-6.015925 5.951926-2.943963 3.007962-6.079924 5.823927-9.151885 8.76789-2.303971 2.175973-4.287946 4.927938-6.847915 6.591918-3.839952 2.559968-6.655917 5.951926-9.855876 8.959888-3.19996 3.007962-6.39992 6.143923-9.471882 9.279884-3.583955 3.647954-7.551906 6.911914-10.943863 10.687866-2.943963 3.327958-6.335921 6.207922-9.471882 9.279884-3.19996 3.135961-6.207922 6.463919-9.59988 9.471882a155.96605 155.96605 0 0 0-9.471881 9.471881c-2.43197 2.559968-4.991938 5.055937-7.551906 7.487907-2.559968 2.43197-4.735941 5.311934-7.935901 7.039912-0.319996 1.535981-1.59998 2.175973-2.751965 2.943963-3.327958 2.111974-5.951926 4.991938-8.83189 7.679904-1.919976 1.727978-3.455957 4.03195-5.63193 5.247934-3.583955 1.919976-6.143923 5.119936-9.343883 7.423907-3.839952 2.815965-7.807902 5.695929-11.19986 9.087887-1.663979 1.59998-4.223947 1.855977-5.311933 3.96795-0.895989 1.791978-3.19996 1.407982-4.287947 2.815965-2.239972 3.007962-5.887926 4.223947-8.575893 6.655917-1.59998 1.471982-3.839952 2.687966-5.759928 3.839952-1.215985 0.639992-2.559968 1.087986-3.583955 2.047974a41.59948 41.59948 0 0 1-8.255897 5.759928c-1.279984 0.76799-3.007962 1.279984-3.96795 2.367971-1.791978 1.919976-4.287946 2.815965-6.335921 4.479944a25.727678 25.727678 0 0 1-6.783915 4.095948c-3.19996 1.215985-5.63193 3.455957-8.575893 4.927939-3.96795 1.919976-7.679904 4.287946-11.583855 6.207922-1.023987 0.511994-2.751966 0.83199-3.327958 2.239972 0 0.895989 0.383995 1.151986 1.151985 1.59998 1.727978 1.023987 3.647954 1.279984 5.375933 1.983975 2.815965 1.279984 5.503931 2.879964 8.319896 4.03195 2.687966 1.087986 4.927938 2.943963 8.127898 3.19996a7.9999 7.9999 0 0 1 3.903952 1.919976c1.919976 1.663979 4.351946 2.303971 6.39992 3.071962 1.791978 0.639992 3.519956 1.791978 5.56793 2.175972 1.279984 0.255997 3.007962 0.191998 4.03195 0.959988 1.791978 1.407982 3.839952 2.175973 5.759928 3.327959 1.279984 0.76799 3.007962-0.255997 3.775952 0.895989 1.087986 1.59998 3.071962 1.855977 4.287947 2.303971 3.647954 1.279984 7.039912 2.751966 10.623867 4.223947 3.071962 1.279984 6.207922 2.175973 9.215885 3.839952 2.495969 1.343983 5.823927 1.407982 8.703891 2.623967 1.087986 0.511994 1.663979 1.535981 2.879964 1.663979a18.047774 18.047774 0 0 1 7.871902 2.367971c0.76799 0.511994 1.59998 1.407982 2.559968 1.59998 2.815965 0.575993 5.56793 1.279984 8.319896 2.431969 2.559968 1.023987 5.247934 2.175973 7.9359 2.559968 1.471982 0.191998 1.791978 1.663979 3.19996 1.66398 2.495969 0 4.479944 1.59998 6.847915 2.111973 3.19996 0.76799 6.335921 1.919976 9.471881 2.879964 0.703991 0.191998 1.919976-0.127998 2.239972 0.255997 1.919976 2.559968 5.119936 1.279984 7.679904 2.559968 2.751966 1.407982 6.39992 2.047974 9.59988 3.135961 2.879964 1.023987 5.759928 2.111974 8.83189 2.239972 0.511994 0 0.959988 0.127998 1.407982 0.447994 2.047974 1.279984 4.415945 1.983975 6.783916 2.559968a50.751366 50.751366 0 0 0 3.391957 0.575993c2.047974 0.319996 3.711954 1.727978 5.695929 1.855977 2.943963 0.127998 5.439932 1.919976 8.511894 2.047974 1.151986 0.063999 3.071962-0.127998 4.031949 0.83199 1.983975 1.983975 4.79994 1.855977 7.039912 2.431969 4.863939 1.279984 10.047874 0.959988 15.039812 2.623968 2.879964 1.023987 6.143923 0.639992 9.343883 1.407982 5.119936 1.151986 10.687866 0.76799 16.127799 1.087986 10.047874 0.639992 20.159748 0.383995 30.143623-0.76799 2.559968-0.319996 4.927938-0.447994 7.423907-1.087986a62.39922 62.39922 0 0 1 10.879864-1.791978c3.135961-0.255997 6.015925-1.59998 9.215885-1.279984a1.215985 1.215985 0 0 0 0.639992-0.191998c2.751966-1.727978 5.951926-1.727978 8.83189-2.687966 2.047974-0.639992 4.479944-0.575993 6.207922-1.59998a17.663779 17.663779 0 0 1 5.823927-2.239972c3.19996-0.511994 5.439932-3.19996 8.703892-2.943963 0.127998 0 0.255997-0.191998 0.383995-0.255997 2.175973-1.663979 4.863939-2.559968 7.295909-3.391958a68.479144 68.479144 0 0 0 7.743903-3.19996c3.327958-1.663979 6.527918-3.839952 9.791877-5.759928 0.959988-0.575993 2.36797 0.255997 3.071962-1.279984 0.511994-1.279984 1.727978-1.919976 3.19996-2.239972 1.663979-0.447994 3.583955-1.087986 4.287946-3.007962 0.319996-0.83199 0.959988-0.895989 1.59998-0.83199a2.43197 2.43197 0 0 0 2.175973-1.215984c2.047974-3.071962 5.56793-4.479944 8.383895-6.527919 2.943963-2.047974 5.247934-4.79994 8.319896-6.655917 3.647954-2.111974 6.271922-5.503931 9.215885-8.447894 2.495969-2.559968 4.863939-5.183935 7.487907-7.487906 2.047974-1.791978 3.007962-4.223947 5.055936-6.015925 1.407982-1.279984 3.647954-2.559968 4.223948-4.479944 0.895989-3.007962 3.327958-4.223947 5.375932-6.079924a11.711854 11.711854 0 0 1 3.135961-4.03195l0.767991-1.215985c1.087986-0.639992 0.511994-2.239972 1.663979-2.943963 2.047974-1.343983 2.815965-3.839952 3.711953-5.759928 1.407982-2.943963 3.135961-5.823927 4.79994-8.575893 1.791978-3.007962 2.879964-6.335921 5.119936-9.151885 1.663979-2.175973 2.751966-5.055937 3.967951-7.615905 2.175973-4.479944 4.415945-8.895889 6.783915-13.247834 1.407982-2.559968 2.751966-5.247934 3.96795-7.935901 1.215985-2.815965 2.815965-5.439932 4.095949-8.127899 1.279984-2.815965 3.071962-5.375933 4.095949-8.127898 1.279984-3.391958 3.19996-6.271922 4.671942-9.535881 0.447994-1.151986 0.319996-2.559968 1.151985-3.391957a16.383795 16.383795 0 0 0 3.583955-6.271922c1.279984-3.391958 4.159948-6.015925 4.479944-9.791878l0.255997-0.127998c1.279984-0.959988 1.727978-2.559968 2.43197-3.903951 1.151986-2.111974 1.663979-4.607942 3.071961-6.527919 2.175973-3.071962 3.455957-6.527918 5.119936-9.791877 1.087986-2.047974 1.919976-4.351946 3.071962-6.207923 1.919976-3.007962 3.19996-6.39992 4.991938-9.407882a38.463519 38.463519 0 0 0 3.19996-6.719916c0.575993-1.535981 1.663979-3.071962 2.623967-4.479944 1.727978-2.687966 2.943963-5.759928 5.183935-8.127898 0.959988-1.023987 0.895989-2.43197 2.047974-3.583956 1.919976-1.919976 2.943963-4.479944 4.479944-6.719916 1.151986-1.663979 1.919976-3.711954 3.26396-4.991937 2.559968-2.43197 4.479944-5.439932 6.207922-8.191898 1.727978-2.751966 3.96795-5.247934 5.951926-7.615905 3.263959-3.96795 6.783915-7.871902 10.36787-11.711853a4652.741841 4652.741841 0 0 0 9.727878-10.367871c1.919976-1.983975 1.407982-2.43197 0-3.839952'
              fill='#133C9A'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const EmailSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1036 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M41.451064 207.245088c-22.617114 31.327496-36.391838 69.3863-36.391838 110.965278l0 382.754381c0 41.387619 13.71128 79.446423 36.201503 110.648053l316.950675-368.974539L41.451064 207.245088 41.451064 207.245088zM933.812955 159.38608c-29.728068-19.416212-65.157999-30.883381-103.216803-30.883381L194.767915 128.502699c-40.044018 0-77.008908 12.559037-107.637486 33.69952l421.449681 313.109184L933.812955 159.38608 933.812955 159.38608zM980.778616 203.529463 658.953933 442.569698l321.115532 373.848547c24.861224-32.03767 40.238446-71.821769 40.238446-115.516944L1020.307911 318.210365C1020.24549 274.902 1005.184469 235.498572 980.778616 203.529463L980.778616 203.529463zM527.292288 540.342512c-2.116197 1.602498-4.740978 0.76748-6.985088 1.792832-4.037966 1.666966-7.366781 3.01159-11.657504 2.948145-4.361331 0.063445-7.689123-1.281179-11.728112-2.948145-2.306532-1.026376-4.931313-0.190335-7.04751-1.730411l-80.537268-59.904345L86.490863 856.334349c30.693046 21.400403 67.979254 34.148751 108.278075 34.148751l635.827213 0c38.058804 0 73.42529-11.403724 103.090936-30.755468L607.891977 480.500589 527.292288 540.342512 527.292288 540.342512zM527.292288 540.342512'
              fill='#1296db'
              data-spm-anchor-id='a313x.7781069.0.i7'
              className=''
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const AliYunSmsSvg = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path d='M512 0A512 512 0 1 1 0 512 512 512 0 0 1 512 0z' fill='#FF6A00'></path>
            <path
              d='M298.141538 615.581538a30.72 30.72 0 0 1-24.418461-29.735384v-163.052308A31.901538 31.901538 0 0 1 298.141538 393.846154l151.236924-32.689231 16.147692-64.984615H289.476923A111.458462 111.458462 0 0 0 177.230769 406.252308v193.378461a113.033846 113.033846 0 0 0 112.246154 112.246154h176.049231l-15.950769-64.590769zM738.658462 295.384615h-177.23077l16.147693 64.984616L728.615385 393.846154a30.72 30.72 0 0 1 24.418461 29.538461v163.249231A31.704615 31.704615 0 0 1 728.615385 615.581538l-151.63077 32.886154-16.147692 64.984616h177.230769a112.443077 112.443077 0 0 0 112.836923-112.049231v-194.56a113.033846 113.033846 0 0 0-112.246153-111.458462z'
              fill='#FFFFFF'
            ></path>
            <path d='M449.378462 495.852308h129.378461V512h-129.378461z' fill='#FFFFFF'></path>
          </svg>
        )}
      />
    </>
  );
};

export const TencentSmsSvg = (props: any) => {
  const size = props.size || defaultSvgSize;
  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M515.12132 140c143.23 0 264.603 91.954 305.177 218.55-15.114-1.86-30.46-1.976-45.69-0.698-18.601 1.744-36.854 5.697-54.641 11.625C686.48532 291.94 607.31332 237.65 515.00432 237.65c-110.096 0-201.475 77.306-218.914 178.792-32.32-6.626-65.453-8.137-98.238-4.185C217.84932 258.808 352.24232 140 515.12132 140z'
              fill='#006DFE'
            ></path>
            <path
              d='M236.68232 410.514c59.757 0 114.398 22.087 156.135 58.59 17.671 15.461 49.642 43.477 95.913 84.281l-8.138-7.207-67.662 66.727-59.757-59.636c-37.551-37.549-72.545-52.545-116.607-52.545-81.032 0-146.718 65.565-146.718 146.591 0 81.026 65.686 146.591 146.718 146.591 11.742 0 32.204 0.814 61.617 2.558l-99.284 84.63C69.73632 859.936-17.92268 738.222 3.12032 609.185c18.718-114.39 117.537-198.439 233.562-198.671z'
              fill='#00CDD8'
            ></path>
            <path
              d='M693.34432 429.346c120.443-51.034 259.604 5.115 310.758 125.434 51.153 120.319-5.116 259.354-125.559 310.388-16.857 7.09-41.97 17.553-69.29 17.786-79.172 0.697-268.09 0.93-566.99 1.046h-46.968C340.85032 744.965 486.17132 605.814 631.26132 466.43c20.113-19.298 45.225-29.876 62.082-37.084z m46.038 88.35c-10.114 4.301-25.344 10.695-37.435 22.32-33.134 31.969-120.792 115.901-262.976 251.914h58.71c162.762 0 266.58-0.233 311.572-0.581 16.509-0.117 31.622-6.394 41.853-10.812 72.661-30.806 106.609-114.622 75.684-187.162-30.808-72.656-114.747-106.485-187.408-75.679z'
              fill='#00A2FF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const SmsSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M102.4 143.36h368.64c12.288 0 20.48 8.192 20.48 20.48v696.32c0 12.288-8.192 20.48-20.48 20.48H102.4c-12.288 0-20.48-8.192-20.48-20.48V163.84c0-12.288 8.192-20.48 20.48-20.48z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M491.52 921.6H81.92c-22.528 0-40.96-18.432-40.96-40.96V143.36c0-22.528 18.432-40.96 40.96-40.96h409.6c22.528 0 40.96 18.432 40.96 40.96v737.28c0 22.528-18.432 40.96-40.96 40.96zM81.92 143.36v737.28h409.6V143.36H81.92z'
              fill='#13173C'
            ></path>
            <path d='M102.4 204.8h368.64v552.96H102.4z' fill='#579AFF'></path>
            <path
              d='M286.72 819.2m-40.96 0a40.96 40.96 0 1 0 81.92 0 40.96 40.96 0 1 0-81.92 0Z'
              fill='#C5C5C5'
            ></path>
            <path
              d='M194.56 163.84h102.4c6.144 0 10.24 4.096 10.24 10.24s-4.096 10.24-10.24 10.24h-102.4c-6.144 0-10.24-4.096-10.24-10.24s4.096-10.24 10.24-10.24zM337.92 163.84h20.48c6.144 0 10.24 4.096 10.24 10.24s-4.096 10.24-10.24 10.24h-20.48c-6.144 0-10.24-4.096-10.24-10.24s4.096-10.24 10.24-10.24z'
              fill='#C5C5C5'
            ></path>
            <path
              d='M450.56 368.64h491.52v325.632h-178.176c-8.192 0-16.384 6.144-24.576 10.24l-102.4 75.776 2.048-63.488c0-12.288-10.24-22.528-22.528-22.528h-169.984V368.64h4.096z'
              fill='#8DCC4A'
            ></path>
            <path
              d='M616.448 839.68c-4.096 0-6.144 0-8.192-2.048-6.144-4.096-12.288-10.24-12.288-18.432v-83.968H430.08c-12.288 0-20.48-8.192-20.48-20.48V348.16c0-12.288 8.192-20.48 20.48-20.48h532.48c12.288 0 20.48 8.192 20.48 20.48v366.592c0 12.288-8.192 20.48-20.48 20.48h-198.656l-135.168 100.352c-4.096 2.048-8.192 4.096-12.288 4.096zM450.56 694.272h165.888c12.288 0 20.48 8.192 20.48 20.48V778.24l108.544-79.872c4.096-2.048 8.192-4.096 12.288-4.096h184.32V368.64H450.56v325.632z'
              fill='#13173C'
            ></path>
            <path
              d='M593.92 512m-40.96 0a40.96 40.96 0 1 0 81.92 0 40.96 40.96 0 1 0-81.92 0Z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M798.72 512m-40.96 0a40.96 40.96 0 1 0 81.92 0 40.96 40.96 0 1 0-81.92 0Z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M174.08 286.72h163.84c16.384 0 30.72 14.336 30.72 30.72s-14.336 30.72-30.72 30.72h-163.84c-16.384 0-30.72-14.336-30.72-30.72S157.696 286.72 174.08 286.72z'
              fill='#FFFFFF'
            ></path>
            <path
              d='M174.08 430.08h61.44c16.384 0 30.72 14.336 30.72 30.72s-14.336 30.72-30.72 30.72h-61.44c-16.384 0-30.72-14.336-30.72-30.72S157.696 430.08 174.08 430.08z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const HttpSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            viewBox='0 0 1490 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M1203.118794 1023.767378a286.589732 286.589732 0 1 0 0-573.179463 302.407996 302.407996 0 0 0-46.524307 3.954566 390.80418 390.80418 0 0 0 2.093594-40.708769 413.833712 413.833712 0 0 0-827.667424 0 390.80418 390.80418 0 0 0 2.093593 40.708769 302.407996 302.407996 0 0 0-46.524307-3.954566 286.589732 286.589732 0 0 0 0 573.179463z'
              fill='#4674CE'
            ></path>
            <path
              d='M301.2451 610.39891v116.310767H442.911615v-116.310767h45.3612v277.28487H442.911615v-122.824171h-141.666515v122.824171H256.814387V610.39891zM747.413206 610.39891v38.847796h-90.722399v238.437074h-46.524308V649.246706h-90.722398v-38.847796zM986.315523 610.39891v38.847796h-90.955021v238.437074h-46.524307V649.246706h-89.791913v-38.847796zM1134.262819 610.39891c66.762381 0 100.492503 28.379827 100.492504 84.90686s-33.730123 85.837347-101.42299 85.837347h-69.786461v106.540663h-46.524307V610.39891z m-69.78646 131.89641h66.064516a74.438891 74.438891 0 0 0 44.198092-10.70059 43.732849 43.732849 0 0 0 13.957292-36.28896 41.639255 41.639255 0 0 0-14.422536-35.358473 71.647433 71.647433 0 0 0-43.732848-10.700591h-65.831895z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

/**
 * random rgb color
 */
function randomRgbColor() {
  let r = Math.floor(Math.random() * 256); //random generate r value less than 256
  let g = Math.floor(Math.random() * 256); //random generate g value less than 256
  let b = Math.floor(Math.random() * 256); //random generate b value less than 256
  return `rgb(${r},${g},${b})`; //return rgb(r,g,b) format color
}

export const AlertGroupSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path
              d='M754.176 732.032H684.16V512a200 200 0 0 0-400 0v220.032H214.208a9.984 9.984 0 0 0-10.048 9.984v40c0 5.504 4.48 9.984 10.048 9.984h539.968c5.504 0 9.984-4.48 9.984-9.984v-40a9.984 9.984 0 0 0-9.984-9.984zM454.208 192h59.968v80h-59.968zM298.24 249.92l51.968-30.08 40 69.312-51.968 30.08zM192 377.984l30.016-51.968 69.248 40-29.952 51.968zM677.12 365.952l69.248-40 30.016 51.968-69.312 40zM578.176 289.088l40-69.248 51.904 30.016-40 69.248-51.904-30.016z'
              fill={randomRgbColor()}
            ></path>
            <path
              d='M563.392 502.016H499.84l11.904-83.136a4.992 4.992 0 0 0-8.704-3.84L401.216 533.76a4.992 4.992 0 0 0 3.776 8.192h63.488l-11.904 83.072a4.992 4.992 0 0 0 8.704 3.904l101.888-118.784a4.992 4.992 0 0 0-3.84-8.192z'
              fill='#FFFFFF'
            ></path>
          </svg>
        )}
      />
    </>
  );
};

export const DefaultSvg = (props: any) => {
  const size = props.size || defaultSvgSize;

  return (
    <>
      <Icon
        style={style}
        component={() => (
          <svg
            className='icon'
            viewBox='0 0 1024 1024'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            width={size}
            height={size}
          >
            <path d='M950.896028 907.262252 799.11209 753.232157c-12.108782-12.302187-31.893384-12.434194-44.163849-0.325411-12.286838 12.103666-12.434194 31.878035-0.325411 44.163849l151.783938 154.030096c6.110161 6.206352 14.177907 9.31311 22.24463 9.31311 7.919367 0 15.839757-2.989077 21.919219-8.987698C962.857455 939.323459 963.004811 919.54909 950.896028 907.262252z'></path>
            <path d='M884.039341 602.546226c30.65723-17.944697 39.848567-39.624463 42.156122-54.645574 2.26253-14.700817 0.147356-37.530778-22.773679-62.84021-44.830021-49.441039-119.794363-128.689964-142.222165-152.352897-5.586229-32.177863-24.425296-139.980101-37.535895-206.1655-4.869914-24.50716-19.174712-44.387953-39.248909-54.53915-19.896142-10.060123-43.38102-9.739828-66.149583 0.919952-61.168128 28.716019-160.318312 77.455069-189.568497 91.861174-32.803103-3.975545-145.002488-17.466814-211.030297-24.145933-21.283746-2.170432-42.202171 5.363148-57.380872 20.608364-15.971763 16.038278-24.099884 38.928614-21.751397 61.238736 7.060813 67.115584 20.99415 179.407066 25.055652 211.919551-14.049994 29.635971-62.535265 132.146693-90.514503 194.163141-13.837146 30.555923-8.352225 53.30402-1.311879 67.004043 9.378601 18.249643 27.083845 31.165814 48.677653 35.461653 64.594157 12.617365 177.831174 32.345686 211.060997 38.104853 23.967878 22.915919 104.747669 99.984179 153.59826 144.738475 19.759019 18.116613 38.028105 22.941502 51.890834 22.941502 3.360538 0 6.461155-0.284479 9.261944-0.726547 14.365172-2.292206 34.922371-11.127432 51.245128-40.153512 33.336246-59.07342 87.722924-160.679539 103.425557-190.086289 28.390607-15.70775 124.57218-69.067029 183.102225-103.293551C884.029108 602.551342 884.034225 602.551342 884.039341 602.546226zM852.482625 548.642548c-68.234057 39.898709-188.638311 106.333794-189.842743 106.998943-5.301749 2.922563-9.642614 7.324826-12.484336 12.672624-0.681522 1.276063-68.345598 128.328737-107.075691 196.964954-2.948145 5.236258-5.428639 7.848759-6.699586 8.860808-1.514493-0.568958-4.666276-2.272763-9.06854-6.308683-57.065693-52.281737-158.473291-149.420101-159.490457-150.396335-4.493338-4.306072-10.17678-7.172353-16.312524-8.230452-1.428535-0.243547-143.858432-24.786523-218.98548-39.45664-2.917446-0.579191-4.793166-1.942235-5.195326-2.725064-0.457418-0.889253-0.873903-4.900613 2.673899-12.728906 32.568766-72.198346 93.310176-200.045105 93.920066-201.331401 2.562359-5.383614 3.523243-11.391445 2.780323-17.309224-0.178055-1.408069-17.827017-141.622508-26.047236-219.706911-0.381693-3.634784 1.183965-7.90504 3.89368-10.623965 2.115174-2.124384 4.122901-2.592035 5.779633-2.592035 0.37146 0 0.721431 0.020466 1.057075 0.056282 76.915787 7.777127 217.582527 24.954345 218.995713 25.127284 6.019087 0.726547 12.164041-0.310062 17.619286-2.99931 1.245364-0.615007 125.360126-61.899792 196.786898-95.439676 4.895497-2.297322 9.063423-2.922563 11.437493-1.733481 2.699482 1.367137 5.118578 5.67321 6.17156 10.959609 15.310707 77.302597 38.628786 212.590839 38.862099 213.947743 1.046842 6.089695 3.883447 11.732206 8.138354 16.211217 0.950651 0.9967 95.328136 100.345406 147.737786 158.14788 5.880941 6.491855 7.284917 10.608615 7.345292 11.30037C864.163665 539.349905 861.291245 543.483038 852.482625 548.642548z'></path>
            <path d='M348.905458 492.080322c-12.169157-12.220323-31.948643-12.266371-44.168965-0.085958-12.220323 12.169157-12.261255 31.943526-0.085958 44.168965l22.676465 22.768563c6.099928 6.125511 14.111392 9.190313 22.127973 9.190313 7.970532 0 15.94618-3.035126 22.040992-9.104355 12.220323-12.169157 12.261255-31.948643 0.085958-44.168965L348.905458 492.080322z'></path>
            <path d='M508.766352 376.774179c6.105045 6.125511 14.116509 9.190313 22.127973 9.190313 7.970532 0 15.94618-3.035126 22.040992-9.104355 12.220323-12.174274 12.261255-31.948643 0.085958-44.168965l-22.681582-22.768563c-12.17939-12.220323-31.948643-12.256138-44.168965-0.085958-12.220323 12.174274-12.261255 31.948643-0.085958 44.168965L508.766352 376.774179z'></path>
            <path d='M564.67878 441.515692c-16.851806 3.680832-27.53103 20.322861-23.856337 37.174668 0.056282 0.248663 4.707209 25.564235-11.290137 41.621956-15.524578 15.575744-39.035038 11.153014-40.616046 10.832719-16.673751-3.715625-33.310663 6.668886-37.225833 23.352871-3.934612 16.790408 6.486738 33.596166 23.281239 37.535895 6.003737 1.408069 13.852496 2.409886 22.748097 2.409886 22.895453 0 52.745295-6.634094 76.067466-30.04734 32.16763-32.289404 32.777521-77.43972 28.065196-99.023294C598.167498 448.51613 581.51933 437.856349 564.67878 441.515692z'></path>
          </svg>
        )}
      />
    </>
  );
};
