/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.dinky.data.constant;

public final class NetConstant {

    /** http:// */
    public static final String HTTP = "http://";
    /** https:// */
    public static final String HTTPS = "https://";
    /** 冒号: */
    public static final String COLON = ":";
    /** 斜杠/ */
    public static final String SLASH = "/";
    /** 连接运行服务器超时时间 10秒 */
    public static final Integer SERVER_TIME_OUT_ACTIVE = 10000;
    /** 读取服务器超时时间 3000 */
    public static final Integer READ_TIME_OUT = 3000;
    /** 连接FLINK历史服务器超时时间 2000 */
    public static final Integer SERVER_TIME_OUT_HISTORY = 3000;
}
