/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.dinky.service.impl;

import org.dinky.data.dto.AssignMenuToRoleDTO;
import org.dinky.data.enums.Status;
import org.dinky.data.model.rbac.RoleMenu;
import org.dinky.data.result.Result;
import org.dinky.mapper.RoleMenuMapper;
import org.dinky.mybatis.service.impl.SuperServiceImpl;
import org.dinky.service.RoleMenuService;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import cn.hutool.core.collection.CollUtil;

@Service
public class RoleMenuServiceImpl extends SuperServiceImpl<RoleMenuMapper, RoleMenu> implements RoleMenuService {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Result<Void> assignMenuToRole(AssignMenuToRoleDTO assignMenuToRoleDto) {

        if (CollUtil.isEmpty(assignMenuToRoleDto.getMenuIds())) {
            return Result.failed(Status.SELECT_MENU);
        }

        // 先删除原有的关系
        getBaseMapper()
                .delete(new LambdaQueryWrapper<RoleMenu>().eq(RoleMenu::getRoleId, assignMenuToRoleDto.getRoleId()));
        List<RoleMenu> newRoles = assignMenuToRoleDto.getMenuIds().stream()
                .map(menuId -> {
                    RoleMenu roleMenu = new RoleMenu();
                    roleMenu.setRoleId(assignMenuToRoleDto.getRoleId());
                    roleMenu.setMenuId(menuId);
                    return roleMenu;
                })
                .collect(Collectors.toList());
        boolean res = saveBatch(newRoles);
        if (res) {
            return Result.succeed(Status.ASSIGN_MENU_SUCCESS);
        } else {
            return Result.failed(Status.ASSIGN_MENU_FAILED);
        }
    }
}
