/*
 *
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

package org.dinky.data.model.rbac;

import org.dinky.mybatis.model.DateBaseEntity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/** role */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("dinky_role")
@ApiModel(value = "Role", description = "Role Information")
public class Role extends DateBaseEntity<Role> implements Serializable {

    private static final long serialVersionUID = 6877230738922824958L;

    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty(value = "ID", dataType = "Integer", example = "1", notes = "Unique identifier for the role")
    private Integer id;

    @ApiModelProperty(
            value = "Tenant ID",
            dataType = "Integer",
            example = "1001",
            notes = "ID of the tenant associated with the role")
    private Integer tenantId;

    @ApiModelProperty(
            value = "Role Code",
            dataType = "String",
            example = "ROLE_ADMIN",
            notes = "Code representing the role")
    private String roleCode;

    @ApiModelProperty(value = "Role Name", dataType = "String", example = "Administrator", notes = "Name of the role")
    private String roleName;

    @ApiModelProperty(
            value = "Is Delete",
            dataType = "Boolean",
            notes = "Flag indicating if the role is marked as deleted")
    private Boolean isDelete;

    @ApiModelProperty(value = "Note", dataType = "String", notes = "Additional notes or details about the role")
    private String note;

    @TableField(exist = false)
    @ApiModelProperty(value = "Tenant", dataType = "Tenant", notes = "Associated tenant information")
    private Tenant tenant;
}
