import { h, type VNode } from 'vue'

const clearIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
      <g transform="translate(-579.000000, -1679.000000)" fill="currentColor">
        <g transform="translate(119.000000, 1482.000000)">
          <g transform="translate(0.000000, 104.000000)">
            <g transform="translate(0.000000, 93.000000)">
              <g transform="translate(460.000000, 0.000000)">
                <path d="M12,22 C17.5228475,22 22,17.5228475 22,12 C22,6.4771525 17.5228475,2 12,2 C6.4771525,2 2,6.4771525 2,12 C2,17.5228475 6.4771525,22 12,22 Z M15.5355339,8.46446609 C15.906532,8.83546417 15.906532,9.4369709 15.5355339,9.80796898 L13.34421,11.9992929 L15.5355339,14.192031 C15.906532,14.5630291 15.906532,15.1645358 15.5355339,15.5355339 C15.1645358,15.906532 14.5630291,15.906532 14.192031,15.5355339 L12,13.3420887 L9.80796898,15.5355339 C9.4369709,15.906532 8.83546417,15.906532 8.46446609,15.5355339 C8.09346802,15.1645358 8.09346802,14.5630291 8.46446609,14.192031 L10.6572042,11.9992929 L8.46446609,9.80796898 C8.09346802,9.4369709 8.09346802,8.83546417 8.46446609,8.46446609 C8.83546417,8.09346802 9.4369709,8.09346802 9.80796898,8.46446609 L12.0007071,10.65579 L14.192031,8.46446609 C14.5630291,8.09346802 15.1645358,8.09346802 15.5355339,8.46446609 Z"></path>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const errorIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill-rule="evenodd">
      <g transform="translate(-132.000000, -3776.000000)">
        <g transform="translate(119.000000, 3344.000000)">
          <g transform="translate(1.000000, 420.000000)">
            <g transform="translate(12.000000, 12.000000)">
              <path d="M12,22 C17.5228475,22 22,17.5228475 22,12 C22,6.4771525 17.5228475,2 12,2 C6.4771525,2 2,6.4771525 2,12 C2,17.5228475 6.4771525,22 12,22 Z M15.5355339,8.46446609 C15.906532,8.83546417 15.906532,9.4369709 15.5355339,9.80796898 L13.34421,11.9992929 L15.5355339,14.192031 C15.906532,14.5630291 15.906532,15.1645358 15.5355339,15.5355339 C15.1645358,15.906532 14.5630291,15.906532 14.192031,15.5355339 L12,13.3420887 L9.80796898,15.5355339 C9.4369709,15.906532 8.83546417,15.906532 8.46446609,15.5355339 C8.09346802,15.1645358 8.09346802,14.5630291 8.46446609,14.192031 L10.6572042,11.9992929 L8.46446609,9.80796898 C8.09346802,9.4369709 8.09346802,8.83546417 8.46446609,8.46446609 C8.83546417,8.09346802 9.4369709,8.09346802 9.80796898,8.46446609 L12.0007071,10.65579 L14.192031,8.46446609 C14.5630291,8.09346802 15.1645358,8.09346802 15.5355339,8.46446609 Z"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const successIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill-rule="evenodd">
      <g transform="translate(-132.000000, -3572.000000)">
        <g transform="translate(119.000000, 3344.000000)">
          <g transform="translate(1.000000, 216.000000)">
            <g transform="translate(12.000000, 12.000000)">
              <path d="M12,2 C17.5228475,2 22,6.4771525 22,12 C22,17.5228475 17.5228475,22 12,22 C6.4771525,22 2,17.5228475 2,12 C2,6.4771525 6.4771525,2 12,2 Z M16.6315494,9.76758839 C16.2605513,9.39659031 15.6590446,9.39659031 15.2880465,9.76758839 L15.2880465,9.76758839 L10.9400469,14.115588 L8.71195347,11.8889087 C8.34095539,11.5179107 7.73944866,11.5179107 7.36845058,11.8889087 C6.99745251,12.2599068 6.99745251,12.8614135 7.36845058,13.2324116 L7.36845058,13.2324116 L10.2569818,16.1195286 L10.2675884,16.1315494 C10.6385865,16.5025475 11.2400932,16.5025475 11.6110913,16.1315494 L11.6110913,16.1315494 L16.6315494,11.1110913 C17.0025475,10.7400932 17.0025475,10.1385865 16.6315494,9.76758839 Z"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const warningIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill-rule="evenodd">
      <g transform="translate(-132.000000, -3708.000000)">
        <g transform="translate(119.000000, 3344.000000)">
          <g transform="translate(1.000000, 352.000000)">
            <g transform="translate(12.000000, 12.000000)">
              <path d="M12,2 C17.5228475,2 22,6.4771525 22,12 C22,17.5228475 17.5228475,22 12,22 C6.4771525,22 2,17.5228475 2,12 C2,6.4771525 6.4771525,2 12,2 Z M12,15 C11.4477153,15 11,15.4477153 11,16 C11,16.5522847 11.4477153,17 12,17 C12.5522847,17 13,16.5522847 13,16 C13,15.4477153 12.5522847,15 12,15 Z M12,7 C11.4871642,7 11.0644928,7.38604019 11.0067277,7.88337887 L11,8 L11,13 C11,13.5522847 11.4477153,14 12,14 C12.5128358,14 12.9355072,13.6139598 12.9932723,13.1166211 L13,13 L13,8 C13,7.44771525 12.5522847,7 12,7 Z"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const attachIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke-width="1" fill-rule="evenodd">
      <g
        transform="translate(-119.000000, -1654.000000)"
        fill="currentColor"
        fill-rule="nonzero"
      >
        <g transform="translate(119.000000, 1482.000000)">
          <g transform="translate(0.000000, 104.000000)">
            <g transform="translate(12.000000, 80.000000) rotate(-360.000000) translate(-12.000000, -80.000000) translate(0.000000, 68.000000)">
              <path d="M11.7720703,11.6476562 C12.2599609,11.1526758 12.2577734,10.3655664 11.7720703,9.87988281 C11.2872656,9.39505859 10.5014844,9.39242187 10.0042969,9.87988281 L6.0259375,13.8564453 C4.80662109,15.0863672 4.80972656,17.0596484 6.0259375,18.2758789 C7.24261719,19.4925391 9.21587891,19.495625 10.4453711,18.2758789 L17.9583789,10.7628516 C19.1781445,9.54310547 19.1781445,7.56320312 17.9583789,6.3434375 C16.739043,5.12412109 14.7587109,5.12367187 13.5389648,6.3434375 L13.3188672,6.5653125 C12.9529492,6.93123047 12.3589648,6.93123047 11.9930469,6.5653125 C11.6275586,6.19980469 11.6271094,5.60628906 11.9930469,5.23947266 L12.213125,5.01759766 C14.1735938,3.066875 17.3356836,3.06910156 19.2842188,5.01759766 C21.2327148,6.96613281 21.2358203,10.1273633 19.2842188,12.0886914 L11.7707422,19.60125 C9.81691406,21.5400586 6.6596875,21.535625 4.71292969,19.5888867 C2.76664063,17.6425586 2.76175781,14.4849023 4.70101563,12.5315039 L8.67847656,8.55402344 C9.9053125,7.33427734 11.8807813,7.33693359 13.0978906,8.55402344 C14.315,9.77113281 14.3176563,11.7466211 13.0978906,12.973457 L9.34140625,16.7299805 C8.97548828,17.0958984 8.38152344,17.0958984 8.01558594,16.7299805 C7.64966797,16.364043 7.64966797,15.7700781 8.01558594,15.4041602 L11.7720703,11.6476367 L11.7720703,11.6476562 Z"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const trashIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke-width="1" fill-rule="evenodd">
      <g transform="translate(-271.000000, -2058.000000)">
        <g transform="translate(119.000000, 1482.000000)">
          <g transform="translate(0.000000, 104.000000)">
            <g transform="translate(0.000000, 404.000000)">
              <g transform="translate(152.000000, 68.000000)">
                <g transform="translate(4.000000, 2.000000)">
                  <path
                    d="M5.61803399,0 L10.381966,0 C10.7607381,1.71347806e-15 11.1070012,0.214002376 11.2763932,0.552786405 L12,2 L12,2 L15,2 C15.5522847,2 16,2.44771525 16,3 C16,3.55228475 15.5522847,4 15,4 L1,4 C0.44771525,4 6.76353751e-17,3.55228475 0,3 C-6.76353751e-17,2.44771525 0.44771525,2 1,2 L4,2 L4,2 L4.7236068,0.552786405 C4.89299881,0.214002376 5.23926193,2.91623903e-16 5.61803399,0 Z"
                    fill="currentColor"
                  />
                  <path
                    d="M3,5 L13,5 C13.5522847,5 14,5.44771525 14,6 L14,16 C14,18.209139 12.209139,20 10,20 L6,20 C3.790861,20 2,18.209139 2,16 L2,6 C2,5.44771525 2.44771525,5 3,5 Z"
                    fill="currentColor"
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const cancelIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
      <g transform="translate(-579.000000, -1679.000000)" fill="currentColor">
        <g transform="translate(119.000000, 1482.000000)">
          <g transform="translate(0.000000, 104.000000)">
            <g transform="translate(0.000000, 93.000000)">
              <g transform="translate(460.000000, 0.000000)">
                <path d="M12,22 C17.5228475,22 22,17.5228475 22,12 C22,6.4771525 17.5228475,2 12,2 C6.4771525,2 2,6.4771525 2,12 C2,17.5228475 6.4771525,22 12,22 Z M15.5355339,8.46446609 C15.906532,8.83546417 15.906532,9.4369709 15.5355339,9.80796898 L13.34421,11.9992929 L15.5355339,14.192031 C15.906532,14.5630291 15.906532,15.1645358 15.5355339,15.5355339 C15.1645358,15.906532 14.5630291,15.906532 14.192031,15.5355339 L12,13.3420887 L9.80796898,15.5355339 C9.4369709,15.906532 8.83546417,15.906532 8.46446609,15.5355339 C8.09346802,15.1645358 8.09346802,14.5630291 8.46446609,14.192031 L10.6572042,11.9992929 L8.46446609,9.80796898 C8.09346802,9.4369709 8.09346802,8.83546417 8.46446609,8.46446609 C8.83546417,8.09346802 9.4369709,8.09346802 9.80796898,8.46446609 L12.0007071,10.65579 L14.192031,8.46446609 C14.5630291,8.09346802 15.1645358,8.09346802 15.5355339,8.46446609 Z"></path>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const retryIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill-rule="evenodd">
      <g transform="translate(-263.000000, -1861.000000)" fill-rule="nonzero">
        <g transform="translate(119.000000, 1482.000000)">
          <g transform="translate(0.000000, 104.000000)">
            <g transform="translate(0.000000, 207.000000)">
              <g transform="translate(144.000000, 68.000000)">
                <path d="M12.0486674,4 C16.7612582,4 20.5789474,7.84236252 20.5789474,12.5789474 C20.5789474,17.3155322 16.7612582,21.1578947 12.0486674,21.1578947 C8.7674824,21.1578947 5.82198031,19.2776604 4.39577271,16.3724135 C4.15239625,15.876645 4.35700037,15.2774497 4.85276881,15.0340733 C5.34853725,14.7906968 5.94773258,14.9953009 6.19110904,15.4910693 C7.28483103,17.7190286 9.53890279,19.1578947 12.0486674,19.1578947 C15.6537942,19.1578947 18.5789474,16.2138366 18.5789474,12.5789474 C18.5789474,8.94405811 15.6537942,6 12.0486674,6 C9.9165536,6 7.95982642,7.036359 6.74256582,8.74298254 L8.14644661,10.1464466 C8.2402148,10.2402148 8.29289322,10.3673918 8.29289322,10.5 C8.29289322,10.7454599 8.11601806,10.9496084 7.88276885,10.9919443 L7.79289322,11 L3.5,11 C3.25454011,11 3.05039163,10.8231248 3.00805567,10.5898756 L3,10.5 L3,6.20710678 C3,6.07449854 3.05267842,5.94732158 3.14644661,5.85355339 C3.32001296,5.67998704 3.58943736,5.66070189 3.7843055,5.79569794 L3.85355339,5.85355339 L5.31281859,7.31434173 C6.91054253,5.24764778 9.37465889,4 12.0486674,4 Z"></path>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

const toIcon = (
  <svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
      <g
        transform="translate(-339.000000, -1254.000000)"
        fill="currentColor"
        fill-rule="nonzero"
      >
        <g transform="translate(119.000000, 288.000000)">
          <g transform="translate(0.000000, 900.000000)">
            <g transform="translate(0.000000, 62.000000)">
              <g transform="translate(100.000000, 0.000000)">
                <g transform="translate(120.000000, 4.000000)">
                  <path d="M14.2928932,7.29289322 C14.6533772,6.93240926 15.2206082,6.90467972 15.6128994,7.20970461 L15.7071068,7.29289322 L20.7071068,12.2928932 C21.3096819,12.8954683 20.9276677,13.9071808 20.1136309,13.9940167 L20,14 L4,14 C3.44771525,14 3,13.5522847 3,13 C3,12.4871642 3.38604019,12.0644928 3.88337887,12.0067277 L4,12 L17.585,12 L14.2928932,8.70710678 C13.9324093,8.34662282 13.9046797,7.77939176 14.2097046,7.38710056 L14.2928932,7.29289322 Z"></path>
                </g>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>
)

function clear (): VNode {
  return clearIcon
}

function success (): VNode {
  return successIcon
}

function warning (): VNode {
  return warningIcon
}

function error (): VNode {
  return errorIcon
}

function attach (): VNode {
  return attachIcon
}

function trash (): VNode {
  return trashIcon
}

function cancel (): VNode {
  return cancelIcon
}

function to (): VNode {
  return toIcon
}

function retry (): VNode {
  return retryIcon
}

export const icons = {
  clear,
  success,
  warning,
  error,
  attach,
  trash,
  cancel,
  to,
  retry
}
