import type { CSSProperties } from 'vue'
import type { ThemeProps } from '../../_mixins'
import type { TypographyTheme } from '../styles'
import { computed, defineComponent, h } from 'vue'
import { useConfig, useTheme, useThemeClass } from '../../_mixins'
import { typographyLight } from '../styles'
import style from './styles/hr.cssr'

export default defineComponent({
  name: 'Hr',
  props: {
    ...(useTheme.props as ThemeProps<TypographyTheme>)
  },
  setup(props) {
    const { mergedClsPrefixRef, inlineThemeDisabled } = useConfig(props)
    const themeRef = useTheme(
      'Typography',
      '-hr',
      style,
      typographyLight,
      props,
      mergedClsPrefixRef
    )
    const cssVarsRef = computed(() => {
      const {
        common: { cubicBezierEaseInOut },
        self: { hrColor }
      } = themeRef.value
      return {
        '--n-bezier': cubicBezierEaseInOut,
        '--n-color': hrColor
      }
    })
    const themeClassHandle = inlineThemeDisabled
      ? useThemeClass('hr', undefined, cssVarsRef, props)
      : undefined
    return {
      mergedClsPrefix: mergedClsPrefixRef,
      cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
      themeClass: themeClassHandle?.themeClass,
      onRender: themeClassHandle?.onRender
    }
  },
  render() {
    this.onRender?.()
    return (
      <hr
        class={[`${this.mergedClsPrefix}-hr`, this.themeClass]}
        style={this.cssVars as CSSProperties}
      />
    )
  }
})
