<!--anchor:on-->

# Third-Party Libraries

Naive UI is a high-quality Vue component library of unified design specifications. We prefer to provide only UI components with a unified specification and visual presentation. So we recommend the following great resources from the community that complement Naive UI.

If you want to contribute excellent resources, please contact 07akioni or amadeus711 in the community of `Discord` or `DingTalk`.

| Resources | Descriptions |
| --- | --- |
| [Naive UI Admin](https://github.com/jekip/naive-ui-admin) | A free open source out-of-box UI solution for enterprise applications. |
| [Admin Work](https://github.com/qingqingxuan/admin-work) | A free open source, powerful, easy to use, beautiful back-office management system solution. |
| [Soybean Admin](https://github.com/honghuangdc/soybean-admin) | A beautiful vue admin template, based on Vue3 + Vite + Naive UI + TypeScript. |
| [Rengar Admin](https://github.com/RengarJS/rengar-admin) | A mid-backend management system template based on Vue 3.5 + Vite 7 + TypeScript + Naive UI + Pinia + UnoCSS, which is concise without excessive encapsulation and has simple and easy-to-understand code. |
| [GoView](https://github.com/dromara/go-view) | A free open source and powerful yet accessible data visualization tool. |
| [Vue Naive Admin](https://github.com/zclzone/vue-naive-admin) | A lightweight backend management template base on Vue3 + Vite4 + Pinia + Unocss + Naive UI. |
| [Vue Bag Admin](https://vite.itnavs.com/admin/) | 🎉vue-bag-admin，Using Vite4, Vue3, TypeScript, JavaScript construction, support a variety of writing and call, a complete framework system, responsive background management system |
| [Celeris Web](https://github.com/kirklin/celeris-web) | Celeris Web, based on Vue 3 and Vite, is a free and open-source front-end framework with Naive UI components and TypeScript support, featuring a Monorepo structure. It also integrates with OpenAI, providing natural language processing capabilities for modern web development. |
| [Nova admin](https://github.com/chansee97/nova-admin) | a clean and concise back-end management template based on Vue3, Vite5, Typescript, and Naive UI. It implements complete functionality in a simple way, while also considering code standards, readability, and avoiding excessive encapsulation to facilitate secondary development. |
| [chatgpt-web](https://github.com/Chanzhaoyu/chatgpt-web) | ChatGPT demo web page built with Express and Vue3 |
| [pro-naive-ui](https://github.com/Zheng-Changfu/pro-naive-ui) | Based on Naive UI secondary encapsulation, more functions are extended on the original components |
| [vue3-dynamic-form](https://github.com/yayaluoya/vue3-dynamic-form) | A dynamic form designer based on Vue3, Naive UI, to implement a lot of basic controls, can be very convenient to customize the control. |
| [astral-3d-editor](https://github.com/mlt131220/Astral3DEditor) | 3D scene building tool based on Vue3 + Naive UI + ThreeJS + Vite5 + Typescript, supporting CAD & BIM analysis, including weather system, particle system, plug-in center... |
| [it-tools](https://github.com/CorentinTh/it-tools) | Developed based on Vue3 and the Naive UI component library, it brings together a variety of practical online tools |
| [Lithe Admin](https://github.com/tenianon/lithe-admin) | A lightweight and elegant backend management template, built using Vue3 + Naive UI + Vite + TypeScript + Pinia, featuring a Tailwind CSS Color color scheme and a frosted texture design. |
