// CuNNy 8x8C BILINEAR RGB NVL - https://github.com/funnyplanter/CuNNy

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME CuNNy-D08N08
//!USE MulAdd
//!CAPABILITY FP16

#include "../StubDefs.hlsli"

//!TEXTURE
Texture2D INPUT;

//!TEXTURE
//!WIDTH INPUT_WIDTH * 2
//!HEIGHT INPUT_HEIGHT * 2
Texture2D OUTPUT;

//!SAMPLER
//!FILTER POINT
SamplerState SP;

//!SAMPLER
//!FILTER LINEAR
SamplerState SL;

//!COMMON
#define O(t, p) t.SampleLevel(SP, pos + p * pt, 0)
#define V4 MF4
#define M4 MF4x4

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t0;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t1;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t2;

//!TEXTURE
//!WIDTH INPUT_WIDTH
//!HEIGHT INPUT_HEIGHT
//!FORMAT R8G8B8A8_SNORM
Texture2D t3;

//!PASS 1
//!DESC in
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN INPUT
//!OUT t0, t1

#define l0(x, y) (dot(MF3(-2.295e-01, -4.396e-01, -9.400e-02), O(INPUT, float2(x, y)).rgb) + MF(4.020e-01))

V4 f0(MF s0_0, MF s0_1, MF s0_2, MF s0_3, MF s0_4, MF s0_5, MF s0_6, MF s0_7, MF s0_8) {
	V4 r = { -5.020e-03, -2.675e-02, -3.797e-02, 7.620e-03 };
	r = mad(s0_0, V4(-6.143e-02, 4.017e-02, -1.294e-02, -3.488e-02), r);
	r = mad(s0_1, V4(4.633e-02, 1.525e-01, -6.941e-02, -8.333e-03), r);
	r = mad(s0_2, V4(1.821e-02, -4.740e-02, 4.913e-03, 2.561e-02), r);
	r = mad(s0_3, V4(2.997e-02, 7.561e-02, -1.418e-01, 1.597e-01), r);
	r = mad(s0_4, V4(6.072e-01, -2.588e-01, 3.815e-01, -1.866e-02), r);
	r = mad(s0_5, V4(-3.722e-01, 8.227e-02, -5.957e-02, -2.609e-01), r);
	r = mad(s0_6, V4(3.887e-02, -2.027e-02, 2.253e-02, 1.248e-01), r);
	r = mad(s0_7, V4(-1.460e-01, 4.258e-02, -4.664e-02, 2.242e-01), r);
	r = mad(s0_8, V4(-1.609e-01, -3.864e-03, -3.072e-02, -2.202e-01), r);
	return r;
}

V4 f1(MF s0_0, MF s0_1, MF s0_2, MF s0_3, MF s0_4, MF s0_5, MF s0_6, MF s0_7, MF s0_8) {
	V4 r = { 1.049e-01, -1.181e-02, -1.058e-02, -1.062e-02 };
	r = mad(s0_0, V4(-1.903e-03, 1.630e-02, -2.729e-02, -8.977e-03), r);
	r = mad(s0_1, V4(1.878e-02, -3.107e-01, -4.692e-01, 2.842e-01), r);
	r = mad(s0_2, V4(-9.660e-03, -8.709e-02, -1.921e-01, 1.169e-01), r);
	r = mad(s0_3, V4(-4.066e-03, 2.283e-02, 2.079e-02, -7.654e-02), r);
	r = mad(s0_4, V4(-1.286e-02, 5.680e-01, 2.607e-01, -3.642e-01), r);
	r = mad(s0_5, V4(1.919e-02, -2.319e-01, 3.279e-01, 8.074e-02), r);
	r = mad(s0_6, V4(5.403e-02, -2.921e-02, 1.082e-02, 6.616e-02), r);
	r = mad(s0_7, V4(-3.475e-01, 2.298e-02, 1.890e-01, -5.933e-02), r);
	r = mad(s0_8, V4(9.621e-03, 3.558e-02, -1.195e-01, -2.875e-02), r);
	return r;
}

void Pass1(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	MF s0_0 = l0(-1.0, -1.0);
	MF s0_1 = l0(0.0, -1.0);
	MF s0_2 = l0(1.0, -1.0);
	MF s0_3 = l0(-1.0, 0.0);
	MF s0_4 = l0(0.0, 0.0);
	MF s0_5 = l0(1.0, 0.0);
	MF s0_6 = l0(-1.0, 1.0);
	MF s0_7 = l0(0.0, 1.0);
	MF s0_8 = l0(1.0, 1.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8);
}

//!PASS 2
//!DESC conv1
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -1.907e-02, -5.779e-04, 2.647e-01, -6.629e-03 };
	r = MulAdd(s0_0, M4(-1.079e-01, -6.209e-03, -5.165e-02, 3.059e-01, -1.088e-01, 1.518e-02, -1.715e-01, -4.790e-01, 9.833e-03, 8.433e-03, -1.041e-01, -1.785e-01, 3.452e-02, -9.679e-03, 4.601e-02, -9.835e-02), r);
	r = MulAdd(s0_1, M4(-3.255e-02, 1.189e-01, 2.081e-01, 4.694e-01, 8.376e-01, 7.644e-02, 4.126e-03, -2.069e-01, 3.555e-01, 7.616e-02, 6.639e-03, 1.045e-01, 2.174e-02, 1.988e-01, 8.994e-02, -1.614e-01), r);
	r = MulAdd(s0_2, M4(-2.806e-01, -2.092e-01, 1.030e-01, -1.734e-01, 1.701e-01, 3.388e-02, -8.975e-02, -2.286e-01, 8.847e-01, 2.175e-01, -3.606e-01, -2.783e-01, 5.524e-02, 6.168e-02, -1.753e-01, 9.562e-03), r);
	r = MulAdd(s0_3, M4(-5.390e-02, 1.193e-01, -2.307e-01, 7.918e-01, 1.093e-01, 1.514e-01, -1.198e-01, 1.970e-01, -6.404e-02, -3.627e-02, -3.039e-01, 3.989e-01, -4.519e-02, 2.935e-02, -7.276e-02, 1.666e-01), r);
	r = MulAdd(s0_4, M4(-4.617e-01, 4.250e-01, -1.689e-01, 2.009e-01, 2.763e-01, -5.223e-01, 6.812e-02, 7.042e-01, 6.269e-01, 4.437e-01, -8.346e-01, 2.686e-01, -1.802e-02, -1.487e-01, -3.822e-02, 2.222e-01), r);
	r = MulAdd(s0_5, M4(3.233e-01, -1.180e-03, -4.640e-02, 1.197e-01, 4.480e-01, -6.224e-01, -1.695e-01, -3.179e-02, 1.063e+00, -2.599e-01, -8.862e-02, -1.894e-01, -2.136e-01, 1.618e-01, 1.563e-01, 1.551e-01), r);
	r = MulAdd(s0_6, M4(7.462e-02, -1.786e-01, 1.469e-01, 3.023e-01, 1.644e-01, -1.871e-01, 2.594e-01, -4.580e-01, 1.328e-01, -1.746e-01, -9.667e-02, -5.360e-02, 6.538e-02, 3.959e-02, 7.461e-02, -1.333e-01), r);
	r = MulAdd(s0_7, M4(-5.538e-02, -4.836e-01, -6.220e-02, -4.814e-01, 1.075e+00, -2.161e-01, 2.104e-01, 3.135e-01, -8.273e-02, 9.291e-02, 7.861e-02, 1.998e-01, -2.965e-02, -1.596e-01, -6.912e-02, 2.828e-02), r);
	r = MulAdd(s0_8, M4(3.116e-02, 2.568e-01, 1.662e-02, -1.116e-01, 9.998e-01, -5.913e-01, -1.385e-01, -6.196e-01, 1.286e-02, 2.039e-01, -1.960e-01, 4.033e-01, 1.547e-01, -9.270e-02, -2.751e-02, 1.296e-01), r);
	r = MulAdd(s1_0, M4(-4.361e-02, -2.010e-02, 2.791e-02, 1.056e-02, -1.917e-01, 1.587e-02, -7.196e-02, 1.375e-01, -2.334e-03, 4.510e-02, 3.333e-02, -1.447e-02, 3.589e-02, -4.001e-02, 7.667e-02, 6.927e-02), r);
	r = MulAdd(s1_1, M4(1.005e-01, 3.245e-01, 2.143e-01, -2.198e-02, 9.360e-02, -8.266e-02, 2.428e-02, 7.946e-02, -8.792e-02, -5.322e-02, 1.436e-02, 5.331e-03, 1.547e-01, 1.074e-01, 2.043e-02, 3.151e-01), r);
	r = MulAdd(s1_2, M4(-1.417e-01, -1.429e-01, 9.010e-02, -2.719e-01, -2.314e-01, -1.211e-01, -5.093e-02, 1.336e-03, -5.519e-02, -4.103e-02, -1.465e-01, 4.377e-02, 1.625e-01, 9.260e-02, -1.132e-01, 1.579e-01), r);
	r = MulAdd(s1_3, M4(-4.690e-02, 3.414e-02, -3.446e-01, 5.756e-01, 4.127e-02, 5.835e-02, -7.117e-02, -1.233e-01, -1.676e-01, -6.558e-02, -1.035e-01, 2.054e-01, 3.734e-02, 1.632e-02, -1.065e-01, 1.426e-01), r);
	r = MulAdd(s1_4, M4(2.777e-03, 5.095e-02, 7.937e-03, -5.967e-02, 1.193e-01, 3.256e-02, 9.556e-02, 8.563e-02, -1.386e-01, 2.129e-01, 1.093e-01, -4.675e-02, 1.955e-02, -5.246e-02, -2.056e-01, 2.337e-01), r);
	r = MulAdd(s1_5, M4(3.632e-01, -1.052e-01, -4.334e-02, 7.445e-02, -1.537e-01, -5.209e-02, -7.747e-02, 9.552e-02, -1.148e-01, -2.824e-01, 1.545e-03, -7.691e-02, -7.978e-02, 2.649e-01, 1.413e-01, 9.935e-02), r);
	r = MulAdd(s1_6, M4(-5.139e-02, 1.473e-01, 1.323e-01, 1.844e-01, -1.223e-01, -9.135e-02, 3.014e-01, -1.103e-01, 4.372e-02, 9.732e-02, 1.080e-01, 1.003e-01, 3.050e-02, -2.316e-02, 6.663e-02, -4.809e-02), r);
	r = MulAdd(s1_7, M4(1.893e-01, -4.030e-01, 4.219e-02, -2.791e-01, 2.341e-01, 2.789e-01, -4.978e-02, -1.129e-01, 7.288e-02, -1.657e-01, 5.783e-02, -2.239e-01, -4.618e-02, -1.246e-01, -4.753e-02, -2.995e-02), r);
	r = MulAdd(s1_8, M4(1.227e-01, -3.217e-02, 4.234e-02, -1.821e-01, -2.965e-01, -1.050e-01, -7.545e-03, -7.288e-02, -8.445e-02, 1.968e-01, -3.038e-02, -1.015e-02, 1.080e-01, -3.768e-02, -2.808e-02, 1.682e-01), r);
	r = MulAdd(s2_0, M4(4.262e-02, 5.784e-02, 1.454e-02, 3.577e-02, -1.138e-01, 1.886e-01, 1.264e-01, 1.255e-01, -9.393e-02, -8.500e-02, -9.118e-02, -9.240e-04, -4.070e-02, -6.934e-02, 9.588e-02, -2.368e-01), r);
	r = MulAdd(s2_1, M4(-3.233e-01, -1.860e-01, -1.585e-01, 9.243e-02, -6.862e-02, -2.190e-01, -1.071e-01, -3.454e-01, 4.177e-02, 4.386e-02, 2.941e-02, 5.866e-02, 2.344e-01, 2.047e-01, -2.278e-01, 4.611e-02), r);
	r = MulAdd(s2_2, M4(8.711e-02, 2.480e-02, -9.937e-02, -3.438e-02, 9.121e-03, 3.109e-01, 7.038e-03, 2.100e-01, 1.072e-01, -1.671e-01, -1.322e-01, -6.579e-02, 2.988e-01, -2.884e-01, -1.310e-01, -2.357e-02), r);
	r = MulAdd(s2_3, M4(-7.846e-02, 7.704e-02, -2.691e-01, -3.412e-01, 6.088e-02, -1.093e-01, -1.281e-01, 5.138e-01, 1.810e-02, 9.831e-02, 2.666e-01, -2.339e-01, 7.093e-02, -1.529e-01, 4.167e-02, -1.516e-01), r);
	r = MulAdd(s2_4, M4(5.444e-02, 2.909e-02, -2.713e-01, -5.557e-02, -1.632e-01, 2.026e-01, -1.414e-01, -1.113e-02, -1.238e-01, -1.247e-01, 2.065e-01, 2.474e-01, 4.052e-01, -2.307e-02, 7.400e-02, -2.563e-01), r);
	r = MulAdd(s2_5, M4(-8.010e-02, -2.663e-01, -1.548e-01, 5.065e-02, 1.857e-01, -4.630e-01, -9.547e-02, -1.356e-01, -1.459e-01, -1.654e-01, -1.372e-01, -1.509e-01, -2.538e-01, 8.992e-02, 6.959e-02, -4.835e-02), r);
	r = MulAdd(s2_6, M4(-6.965e-02, -1.484e-02, -1.520e-01, 8.388e-03, -6.074e-01, -3.065e-02, -1.481e-01, -5.162e-01, 2.566e-02, -6.327e-04, -2.711e-01, 1.572e-01, 7.159e-02, 2.031e-01, 5.821e-02, -1.886e-01), r);
	r = MulAdd(s2_7, M4(8.521e-02, 1.798e-01, -1.517e-01, 1.224e-01, -3.837e-01, -1.884e-01, -1.653e-01, -1.620e-01, -1.856e-01, 3.767e-01, -8.799e-03, 1.930e-01, 1.777e-01, -6.695e-01, 5.634e-02, -1.042e-01), r);
	r = MulAdd(s2_8, M4(2.738e-02, 7.023e-02, -6.588e-02, 4.945e-02, -2.180e-01, -4.060e-01, -1.982e-01, -2.085e-01, 9.355e-02, 6.833e-03, -8.415e-02, -3.284e-02, 1.634e-01, 6.600e-01, 2.179e-02, 3.345e-01), r);
	r = MulAdd(s3_0, M4(-3.002e-01, -2.938e-01, -1.650e-01, -7.428e-01, -9.888e-02, 2.103e-02, 8.913e-02, -1.157e-01, 2.042e-02, -9.108e-03, -5.994e-02, 5.539e-03, -1.426e-01, 1.501e-01, 1.070e-01, 5.497e-02), r);
	r = MulAdd(s3_1, M4(-1.402e+00, -8.043e-01, -6.448e-01, -4.208e-02, 4.390e-02, 3.385e-02, -4.404e-02, -3.245e-02, 1.901e-01, -9.100e-02, -3.288e-02, -5.554e-02, -1.932e-01, -2.189e-01, -2.138e-01, -1.562e-01), r);
	r = MulAdd(s3_2, M4(-2.942e+00, -1.968e-01, -2.618e-01, -9.005e-02, -3.651e-02, -3.300e-02, 4.116e-02, 1.509e-01, 9.940e-02, -3.205e-02, -1.049e-01, -4.534e-02, 4.099e-01, 1.030e-01, -1.503e-01, 8.364e-02), r);
	r = MulAdd(s3_3, M4(2.111e-01, 4.100e-01, -2.844e-01, -7.623e-01, 1.595e-02, -3.347e-01, -1.606e-01, 3.324e-01, 6.465e-02, 2.734e-01, 2.176e-01, 7.220e-03, -7.500e-03, -2.152e-01, 6.906e-02, 1.170e-02), r);
	r = MulAdd(s3_4, M4(1.670e-01, 4.952e-01, -5.006e-01, 9.297e-01, -7.439e-02, 6.976e-01, 3.422e-01, 1.587e-01, 2.158e-01, -5.071e-01, 7.355e-02, -3.825e-01, -3.580e-02, -3.637e-01, 5.284e-02, -6.810e-02), r);
	r = MulAdd(s3_5, M4(-5.111e-01, -2.216e-01, -1.097e-01, -6.024e-01, 7.385e-02, -1.143e-01, -3.750e-02, 2.547e-02, -4.781e-02, 3.365e-02, -1.393e-01, -7.232e-02, -3.006e-01, -8.865e-02, 9.295e-02, 1.912e-02), r);
	r = MulAdd(s3_6, M4(4.437e-01, 4.625e-01, 5.880e-02, 1.085e-01, -1.008e-01, 1.997e-01, 1.448e-02, 1.818e-01, -5.865e-02, -1.208e-01, -3.001e-01, 5.187e-02, -3.114e-01, 2.439e-01, 3.744e-02, -3.896e-01), r);
	r = MulAdd(s3_7, M4(2.651e-01, 3.014e-01, 3.736e-02, 8.684e-01, 1.542e-01, -5.957e-01, -1.418e-01, -4.727e-01, -3.251e-01, 1.105e-01, -8.376e-02, -2.022e-01, -3.469e-01, 5.911e-01, 4.129e-02, 2.129e-01), r);
	r = MulAdd(s3_8, M4(-1.414e-01, -1.073e-01, 1.316e-01, -1.006e-01, 1.568e-01, 3.334e-01, -1.739e-01, 2.173e-02, 2.287e-01, 2.815e-01, -7.362e-02, -1.505e-02, -2.690e-02, -1.337e-01, -9.948e-04, 1.909e-01), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -1.419e-02, 1.370e-02, -1.518e-02, 1.616e-02 };
	r = MulAdd(s0_0, M4(-1.029e-02, -4.427e-02, -1.311e-02, -6.809e-02, -1.820e-01, 2.692e-02, -4.692e-01, 1.900e-01, -2.938e-01, -6.187e-02, 1.741e-01, -1.017e-01, 1.412e-01, 1.843e-02, 2.606e-02, 9.392e-02), r);
	r = MulAdd(s0_1, M4(-4.781e-01, -1.942e-01, 1.552e-01, -3.645e-01, 1.029e-01, 1.159e-01, -8.964e-02, 9.631e-02, -3.120e-01, 2.637e-02, -1.032e-02, -1.627e-02, 1.046e-01, -3.700e-02, -3.136e-01, -1.138e-01), r);
	r = MulAdd(s0_2, M4(-5.959e-01, 5.592e-02, -1.873e-01, -5.695e-02, 3.835e-01, 1.844e-01, 1.652e-02, 5.765e-01, -5.859e-01, 4.167e-02, -1.965e-01, -1.344e-01, 5.900e-01, 1.509e-02, 1.127e-01, -2.605e-02), r);
	r = MulAdd(s0_3, M4(1.675e-01, 9.790e-02, 2.316e-01, -1.930e-01, -1.233e-01, 1.554e-01, 7.309e-01, -9.317e-02, 3.019e-01, 3.548e-02, 1.979e-01, 2.452e-01, -1.320e-01, -2.426e-03, -6.473e-02, 2.362e-01), r);
	r = MulAdd(s0_4, M4(3.238e-01, -3.543e-01, 1.936e-02, -3.525e-01, 6.310e-02, 5.911e-01, 3.797e-01, -2.553e-01, 4.402e-01, -4.429e-02, 8.982e-01, 4.717e-01, -8.769e-02, 2.790e-01, -1.748e-01, 2.149e-01), r);
	r = MulAdd(s0_5, M4(-1.619e-01, -8.726e-02, 9.183e-02, -2.527e-01, 2.260e-01, 3.167e-01, 1.057e-01, -6.114e-01, -1.583e-01, 1.678e-01, 2.295e-01, -3.196e-02, 4.209e-01, -6.903e-02, -1.373e-01, 2.212e-01), r);
	r = MulAdd(s0_6, M4(6.322e-02, -5.028e-02, -5.582e-02, -8.759e-02, 1.828e-01, -7.608e-02, 3.712e-01, -2.018e-01, 7.812e-02, -1.612e-01, 3.925e-02, 2.454e-02, -3.222e-02, -5.491e-02, -4.835e-02, -8.672e-02), r);
	r = MulAdd(s0_7, M4(2.302e-01, 3.311e-01, -1.024e-01, 1.689e-01, 1.384e-01, -6.313e-01, 2.495e-01, 1.109e+00, -1.373e-01, 4.860e-04, 3.466e-02, -4.459e-01, -8.015e-02, -1.001e-01, 1.988e-01, -7.793e-02), r);
	r = MulAdd(s0_8, M4(-1.753e-01, 6.144e-02, 6.860e-03, -6.542e-02, 1.729e-01, 3.502e-02, -2.058e-01, 2.777e-01, 2.547e-01, -3.623e-01, -1.117e-01, -4.370e-01, 2.300e-01, -3.608e-02, 7.399e-02, -2.717e-02), r);
	r = MulAdd(s1_0, M4(6.933e-02, 7.252e-03, -4.641e-01, 3.847e-01, -1.899e-01, -4.916e-02, -8.596e-02, 6.860e-02, -1.260e-02, -1.411e-02, -1.429e-01, -7.949e-02, 7.628e-02, -3.338e-02, 1.520e-01, -1.907e-01), r);
	r = MulAdd(s1_1, M4(-1.096e-01, -1.356e-01, -5.957e-01, 1.985e-01, -1.362e-01, -3.702e-02, 5.611e-02, -1.867e-01, -1.512e-01, 7.857e-02, -5.154e-02, 5.215e-02, -8.526e-02, -7.589e-02, 4.015e-01, -3.616e-01), r);
	r = MulAdd(s1_2, M4(-5.254e-01, 5.750e-02, -2.225e-01, 3.322e-01, -5.401e-02, 5.723e-02, -1.843e-01, 1.116e-01, -6.092e-02, -1.324e-02, 1.852e-01, 2.526e-01, 5.620e-01, -4.316e-02, 1.137e-01, -2.298e-01), r);
	r = MulAdd(s1_3, M4(1.092e-01, 1.151e-01, -6.113e-01, 4.262e-01, -1.108e-02, 1.270e-01, 1.070e-01, 6.105e-02, -6.840e-02, 9.359e-03, 1.322e-02, 6.144e-02, -3.119e-02, -7.442e-02, -3.225e-02, 2.445e-01), r);
	r = MulAdd(s1_4, M4(4.469e-01, -3.722e-01, 1.759e-02, 1.817e-02, -1.038e-01, 1.900e-01, -1.480e-02, -1.003e-01, 2.094e-02, -3.295e-01, 3.884e-02, -3.455e-01, -6.084e-02, 2.868e-01, -2.548e-01, 1.942e-01), r);
	r = MulAdd(s1_5, M4(-2.857e-01, -4.954e-02, 1.537e-01, -3.915e-01, 1.973e-01, 1.338e-02, 1.035e-01, -5.796e-02, -3.144e-01, 9.483e-02, -1.388e-01, -1.597e-01, 2.885e-01, -5.359e-02, -1.151e-01, 2.880e-01), r);
	r = MulAdd(s1_6, M4(-8.887e-03, 3.547e-03, -7.855e-02, -3.055e-01, 2.156e-01, 2.369e-02, -1.089e-01, 1.467e-02, 3.331e-02, 4.691e-02, -3.707e-02, -4.816e-02, 1.843e-02, -2.316e-02, -5.976e-02, -1.949e-01), r);
	r = MulAdd(s1_7, M4(-1.638e-02, 2.342e-01, 1.319e-01, 1.744e-01, 1.130e-01, -3.627e-01, -1.653e-02, 5.432e-02, 1.635e-01, 3.669e-01, 2.821e-02, 7.278e-02, 4.355e-02, -3.466e-02, 1.538e-01, 1.175e-02), r);
	r = MulAdd(s1_8, M4(-1.298e-01, 1.342e-01, 9.409e-03, -8.570e-02, 1.419e-01, -1.479e-01, -5.092e-02, 1.062e-01, -2.235e-03, -2.221e-01, -8.666e-02, 2.477e-01, 2.057e-01, -9.286e-02, 9.491e-03, 8.760e-02), r);
	r = MulAdd(s2_0, M4(-3.941e-02, -5.823e-02, -8.454e-02, -6.757e-03, -4.737e-01, -2.306e-02, 6.786e-02, 1.628e-01, 3.545e-01, -1.548e-02, -4.186e-02, -1.596e-01, 3.441e-01, -5.585e-02, -1.227e-01, 4.865e-03), r);
	r = MulAdd(s2_1, M4(-2.910e-02, 4.163e-02, -9.177e-02, 3.575e-02, -1.154e-01, 1.228e-01, -1.005e-01, 4.365e-01, 8.323e-02, -7.856e-04, 9.573e-02, -2.650e-01, 1.488e-01, -1.503e-02, 3.164e-02, 1.331e-01), r);
	r = MulAdd(s2_2, M4(-7.101e-02, 3.065e-02, 4.069e-02, 8.709e-02, 1.813e-01, -7.222e-02, 4.975e-02, 2.198e-01, -1.686e-01, 7.047e-02, 9.845e-02, -2.971e-02, -1.017e-01, 3.237e-02, 8.955e-02, -4.723e-02), r);
	r = MulAdd(s2_3, M4(-1.017e-01, 5.565e-02, 3.915e-02, -4.115e-02, -1.513e-01, 1.492e-02, -1.683e-01, 5.292e-01, -3.045e-01, 1.206e-02, -2.988e-02, -1.685e-01, -1.559e-01, -1.358e-02, -1.107e-02, 8.501e-02), r);
	r = MulAdd(s2_4, M4(-1.248e-02, -3.360e-02, -1.182e-01, -9.052e-02, 4.120e-01, -2.568e-01, 1.347e-02, 2.203e-01, 5.053e-02, 7.868e-02, 1.555e-01, -5.636e-01, 1.146e-01, -5.034e-02, 3.738e-02, 1.086e-01), r);
	r = MulAdd(s2_5, M4(-1.433e-02, 1.914e-02, 5.146e-02, 5.477e-02, -1.658e-01, 7.262e-03, -1.016e-01, 2.164e-01, -1.221e-02, 2.271e-01, 8.276e-02, -1.134e-01, -7.808e-02, 7.249e-02, -1.490e-01, 1.520e-01), r);
	r = MulAdd(s2_6, M4(9.872e-02, 7.283e-02, 4.571e-03, 4.956e-03, 1.392e-01, 6.305e-02, 2.820e-01, 2.562e-01, 2.470e-01, 2.919e-01, -2.354e-01, 8.940e-02, -3.639e-01, 1.666e-02, -3.139e-01, 3.009e-01), r);
	r = MulAdd(s2_7, M4(7.391e-02, -9.179e-03, 2.303e-02, -9.008e-02, -1.926e-01, 1.451e-01, -3.073e-02, 3.175e-01, 1.068e-01, 4.190e-01, -3.119e-01, -3.721e-01, 1.989e-01, 6.877e-02, -6.490e-02, 3.883e-01), r);
	r = MulAdd(s2_8, M4(3.436e-02, -1.500e-01, 6.370e-02, 6.487e-02, -6.616e-02, 1.150e-01, -1.577e-02, -1.150e-02, 3.625e-02, 1.807e-01, 8.368e-02, -1.030e-01, 2.969e-01, -3.736e-01, -5.248e-01, -6.410e-02), r);
	r = MulAdd(s3_0, M4(-1.904e-01, 3.793e-01, -4.094e-01, -3.506e-01, -3.057e-01, -5.702e-02, -1.412e-01, 1.145e-01, 3.071e-01, -1.208e-02, -2.916e-02, -1.679e-01, 2.943e-01, -3.413e-02, 1.985e-01, -1.143e-01), r);
	r = MulAdd(s3_1, M4(-4.336e-01, 7.680e-01, -6.700e-01, -5.162e-01, 1.232e-01, 7.445e-02, -1.558e-01, 1.520e-01, 1.238e-01, -4.562e-02, 8.931e-02, 1.176e-01, -1.373e-01, 1.201e-01, 9.010e-02, 6.615e-02), r);
	r = MulAdd(s3_2, M4(7.564e-02, 1.828e-02, -3.335e-01, 7.187e-01, -2.198e-01, -3.277e-02, 1.775e-01, -9.321e-02, -5.860e-02, 4.389e-02, -1.336e-02, -2.077e-03, 1.672e-01, 2.256e-02, 2.100e-01, 5.344e-02), r);
	r = MulAdd(s3_3, M4(-6.569e-02, 1.159e-01, 7.211e-01, -2.791e-01, -1.254e-01, 9.532e-02, -1.811e-01, 3.237e-01, -4.603e-01, -7.759e-02, 9.809e-02, -5.216e-02, -3.020e-01, -5.589e-02, -8.145e-02, -1.713e-02), r);
	r = MulAdd(s3_4, M4(-2.708e-01, -1.237e+00, 2.507e-01, -1.349e+00, 3.077e-01, -4.526e-01, 3.560e-01, -2.586e-01, 2.017e-01, 2.772e-01, 9.947e-02, 1.834e-01, -2.344e-01, 8.792e-02, 1.398e-01, 4.550e-02), r);
	r = MulAdd(s3_5, M4(2.083e-01, 2.553e-01, 2.108e-01, 1.616e+00, 2.526e-01, 9.398e-03, -1.027e-01, -9.457e-03, 1.998e-02, 1.143e-01, 1.341e-01, 1.702e-03, -2.370e-01, 1.658e-01, -6.104e-02, 8.290e-02), r);
	r = MulAdd(s3_6, M4(-8.079e-02, 1.286e-02, -2.603e-01, -3.768e-01, -1.689e-01, 1.810e-02, 4.330e-02, -1.769e-01, -3.120e-02, 3.590e-01, 2.761e-02, 1.187e-01, 1.727e-01, 7.357e-02, -1.063e-01, -2.804e-02), r);
	r = MulAdd(s3_7, M4(1.037e-01, -5.252e-01, 3.481e-01, 3.128e-01, -8.170e-02, 7.354e-01, -5.280e-02, -1.332e-01, 2.176e-01, 6.305e-01, -1.500e-01, 3.806e-01, 3.882e-02, -3.656e-01, -3.983e-02, -2.263e-01), r);
	r = MulAdd(s3_8, M4(-1.199e-02, 1.848e-01, -4.894e-01, -3.677e-01, 1.045e-01, -3.526e-02, -5.185e-02, 2.838e-02, 9.936e-02, 1.189e-01, -6.276e-03, 2.501e-01, 1.499e-01, -4.103e-01, -1.141e-01, 1.415e-01), r);
	return r;
}

void Pass2(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 3
//!DESC conv2
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -6.188e-04, 6.040e-03, 8.696e-03, 2.214e-02 };
	r = MulAdd(s0_0, M4(2.433e-01, -3.881e-01, 1.184e-01, -6.328e-02, 2.093e-01, -1.453e-01, -1.044e-01, -1.624e-03, -1.289e-01, 7.280e-02, -2.728e-02, -3.045e-02, -2.419e-02, -1.908e-02, -1.990e-03, 6.380e-02), r);
	r = MulAdd(s0_1, M4(1.241e-01, 2.907e-01, -7.679e-02, 6.609e-02, 4.055e-01, 1.399e-01, 1.488e-01, -8.759e-02, 9.889e-02, -1.191e-02, -2.143e-02, -4.582e-02, 1.655e-02, -1.023e-01, -3.922e-02, 7.866e-02), r);
	r = MulAdd(s0_2, M4(1.018e-01, 5.323e-02, -1.317e-01, 1.143e-02, 3.795e-01, 1.037e-01, -5.552e-02, 9.257e-03, -1.724e-01, -1.334e-01, -1.614e-02, -1.734e-02, 3.272e-01, -1.067e-01, 1.857e-01, 1.775e-02), r);
	r = MulAdd(s0_3, M4(-9.351e-02, -8.100e-02, 1.528e-01, -6.036e-02, 5.321e-01, -2.519e-01, -1.133e-01, -1.084e-01, 9.980e-02, 6.664e-02, -4.920e-02, 5.423e-02, -3.489e-02, 6.527e-03, 4.906e-02, 3.445e-02), r);
	r = MulAdd(s0_4, M4(-7.289e-01, -1.403e-01, -2.049e-01, -8.240e-03, -2.363e-01, 2.203e-01, 2.280e-01, -2.894e-01, 6.564e-03, -1.410e-01, 4.797e-02, -4.672e-02, 2.459e-01, 7.236e-02, 2.042e-01, 1.049e-01), r);
	r = MulAdd(s0_5, M4(-1.679e-01, -1.223e-01, 5.324e-02, -2.159e-03, -1.943e-03, 1.791e-01, 1.407e-02, 6.576e-02, 1.712e-02, 2.206e-02, 1.580e-02, 5.191e-02, -2.160e-01, -4.008e-01, 1.662e-01, -1.676e-01), r);
	r = MulAdd(s0_6, M4(2.380e-02, -1.506e-01, -1.850e-01, -7.010e-02, -7.339e-02, -1.088e-01, -1.633e-02, 8.762e-02, 4.002e-02, -9.515e-03, 1.053e-01, -1.318e-03, 3.687e-02, 1.289e-03, -8.238e-02, 3.815e-02), r);
	r = MulAdd(s0_7, M4(1.500e-01, -2.010e-01, 7.452e-02, -9.216e-02, -9.507e-02, -9.233e-02, -1.655e-01, 9.834e-03, 9.053e-02, 1.116e-01, -6.831e-02, 1.544e-01, -1.290e-02, 2.871e-02, 4.676e-02, 6.820e-02), r);
	r = MulAdd(s0_8, M4(1.485e-01, 1.043e-02, -1.230e-01, 7.149e-02, -2.033e-01, 3.896e-02, -1.704e-01, 2.718e-02, -8.099e-02, -1.492e-02, 2.033e-02, -1.470e-01, 3.724e-01, -6.581e-02, -8.568e-02, 1.446e-02), r);
	r = MulAdd(s1_0, M4(2.111e-01, 7.064e-02, 1.062e-01, -3.356e-02, -1.960e-01, 7.451e-02, -4.637e-02, 4.996e-02, 3.633e-01, -2.194e-01, -1.977e-01, -4.877e-01, -4.173e-02, 7.349e-02, -8.448e-02, -2.853e-02), r);
	r = MulAdd(s1_1, M4(-7.255e-02, 2.476e-01, -4.985e-02, -9.240e-03, -2.809e-01, 1.161e-01, -3.182e-02, -2.748e-02, -6.600e-02, -4.941e-03, -3.764e-01, -6.918e-01, -8.408e-02, 1.003e-01, -8.359e-02, -5.399e-02), r);
	r = MulAdd(s1_2, M4(2.199e-01, -5.369e-03, -6.957e-02, -4.640e-02, 1.564e-01, -1.217e-01, -1.722e-02, -1.767e-02, -6.967e-01, -7.661e-01, -3.545e-01, 5.396e-01, 1.185e-01, -1.727e-01, -4.389e-02, -1.500e-01), r);
	r = MulAdd(s1_3, M4(-1.075e-01, 1.627e-01, 1.380e-01, -1.190e-02, 9.164e-02, -1.048e-01, -1.901e-01, 3.976e-02, 1.650e-01, 6.450e-01, -3.591e-01, -2.435e-01, 1.574e-02, -1.217e-02, 3.572e-02, -4.591e-02), r);
	r = MulAdd(s1_4, M4(-2.832e-02, -9.011e-02, -1.354e-01, -9.056e-02, -2.266e-01, 2.679e-01, 4.178e-01, 5.121e-02, -3.697e-01, 5.771e-01, -4.159e-01, -2.154e+00, 8.549e-02, -4.675e-02, 1.880e-01, 6.462e-04), r);
	r = MulAdd(s1_5, M4(-2.837e-01, -1.020e-01, 1.500e-01, -6.129e-02, 8.551e-02, 6.597e-03, 1.699e-01, 3.306e-03, -1.656e-01, -7.203e-01, -3.878e-01, 6.471e-01, 1.882e-02, -5.250e-02, -6.837e-02, -2.959e-01), r);
	r = MulAdd(s1_6, M4(8.637e-02, -1.856e-01, -1.333e-01, -8.966e-02, 7.885e-02, -4.568e-02, 5.150e-02, 7.534e-02, 2.183e-01, 5.912e-02, 3.611e-01, 1.868e-01, 7.463e-02, -6.546e-02, 8.653e-03, 2.389e-03), r);
	r = MulAdd(s1_7, M4(-2.107e-01, -6.405e-02, 1.977e-01, -7.070e-02, 1.735e-01, -3.623e-02, 1.193e-01, -1.876e-02, -3.815e-01, 6.116e-01, -7.696e-01, 1.309e-02, -9.006e-02, 2.588e-01, 2.957e-02, 7.022e-02), r);
	r = MulAdd(s1_8, M4(1.908e-01, 6.329e-02, -2.448e-01, 2.592e-02, -4.052e-02, -5.949e-02, 8.518e-02, 1.000e-02, -7.463e-01, -5.402e-02, 1.745e-01, 1.433e-01, 2.647e-01, -4.770e-02, 4.625e-02, 1.604e-02), r);
	r = MulAdd(s2_0, M4(7.971e-02, -1.099e-01, -2.069e-02, -9.078e-02, -5.069e-02, -5.648e-02, 4.399e-02, 1.920e-01, 2.338e-02, -7.457e-02, -2.665e-02, -4.715e-02, 9.422e-02, -7.926e-02, 1.338e-02, -6.313e-02), r);
	r = MulAdd(s2_1, M4(-1.406e-01, -1.581e-01, -1.626e-01, -2.596e-02, 5.828e-01, -2.151e-01, 1.535e-01, -6.966e-01, -5.149e-02, -8.108e-02, 1.054e-02, -4.783e-02, -1.567e-01, 2.909e-01, -6.311e-02, -2.142e-01), r);
	r = MulAdd(s2_2, M4(-2.106e-02, -5.202e-02, 7.175e-02, -3.027e-02, 1.773e-02, 3.321e-01, 7.717e-02, -1.694e-01, -9.209e-02, -2.248e-02, 1.867e-02, -8.038e-02, 1.468e-01, -1.793e-01, -1.160e-01, -9.110e-02), r);
	r = MulAdd(s2_3, M4(-4.802e-02, -2.944e-02, -9.839e-02, -1.450e-01, 8.564e-02, -7.952e-02, 4.528e-02, -2.834e-02, 6.636e-02, -2.842e-02, -8.696e-02, -1.222e-02, -3.515e-02, -7.263e-02, -1.196e-01, -6.308e-02), r);
	r = MulAdd(s2_4, M4(5.217e-02, -1.035e-01, -3.715e-01, -5.292e-01, -1.049e-01, -2.436e-01, 5.207e-01, 9.208e-02, 5.585e-02, 9.715e-02, 4.273e-02, 2.886e-01, -2.044e-01, 8.106e-01, -3.056e-01, 1.353e-01), r);
	r = MulAdd(s2_5, M4(-3.279e-01, 1.316e-01, -7.622e-02, -9.912e-02, -2.721e-01, -9.490e-02, 5.605e-01, -1.344e-01, -9.724e-02, -8.388e-02, -1.390e-01, 4.640e-01, -1.161e-01, -1.181e-01, -1.599e-01, -2.190e-01), r);
	r = MulAdd(s2_6, M4(1.149e-01, 8.812e-02, -1.579e-01, -1.800e-01, 4.197e-02, -1.301e-01, 4.577e-02, 5.256e-02, 7.827e-02, 5.972e-02, 1.893e-02, -6.895e-03, -2.070e-04, 1.411e-01, 9.564e-03, 7.850e-02), r);
	r = MulAdd(s2_7, M4(-1.247e-01, 1.674e-01, 1.048e-01, -6.845e-03, -1.308e-01, 9.539e-02, -1.721e-02, -1.677e-02, 4.760e-03, 1.023e-01, 1.821e-01, -3.942e-02, 2.139e-01, -1.663e-02, -9.827e-03, -6.087e-02), r);
	r = MulAdd(s2_8, M4(3.102e-02, 1.901e-02, -2.138e-01, 5.284e-02, 3.217e-02, -3.770e-02, -3.509e-02, 2.685e-05, 9.077e-02, -2.235e-01, 3.352e-01, 1.639e-01, -1.189e-01, -1.500e-01, -1.289e-01, 1.001e-03), r);
	r = MulAdd(s3_0, M4(-4.771e-02, -2.036e-01, 2.846e-02, 2.345e-03, -4.515e-02, 5.025e-02, -7.379e-02, -4.041e-02, -1.517e-02, 3.365e-02, -1.432e-01, -5.475e-03, 1.335e-02, -2.010e-01, -6.832e-03, -3.554e-02), r);
	r = MulAdd(s3_1, M4(-1.906e-01, -5.119e-02, 1.121e-02, 3.558e-02, -3.803e-01, 2.685e-01, -1.029e-01, 4.900e-02, 2.261e-01, -1.602e-01, 1.923e-02, 1.846e-01, -6.525e-02, -3.315e-02, -1.742e-02, -1.288e-01), r);
	r = MulAdd(s3_2, M4(-1.424e-01, -1.426e-01, 3.269e-03, 2.335e-04, 1.329e-02, -1.127e-01, -6.530e-02, -4.724e-02, 6.465e-02, 9.890e-02, 7.215e-02, -1.801e-01, -5.413e-02, -2.846e-01, -5.021e-02, -2.605e-02), r);
	r = MulAdd(s3_3, M4(2.748e-02, -3.440e-01, 1.746e-01, 1.563e-01, 8.409e-02, -2.266e-01, -1.234e-01, -1.325e-01, 3.038e-02, 1.448e-01, -8.858e-02, -4.470e-02, 2.247e-01, -2.876e-01, -2.567e-02, -1.657e-01), r);
	r = MulAdd(s3_4, M4(1.343e-01, -4.749e-01, 3.036e-02, 1.344e-01, -7.044e-01, 9.586e-01, 2.962e-02, 3.066e-01, 3.292e-01, -4.613e-02, 9.281e-02, -6.577e-02, 3.562e-02, 4.712e-01, -3.727e-02, -2.332e-02), r);
	r = MulAdd(s3_5, M4(-6.552e-02, 1.718e-01, 1.372e-02, 1.942e-01, -3.202e-02, -2.690e-01, 7.061e-02, -2.143e-01, -4.725e-01, 2.260e-01, -1.108e-01, -2.049e-02, -1.247e-01, -3.232e-01, 1.640e-02, -1.974e-01), r);
	r = MulAdd(s3_6, M4(5.384e-02, -4.926e-02, 8.471e-02, -5.508e-03, 3.127e-02, -1.024e-01, -6.807e-02, 1.355e-02, 8.709e-02, 3.431e-01, -2.891e-02, -1.667e-02, 5.495e-03, -8.979e-02, 1.211e-01, 8.106e-02), r);
	r = MulAdd(s3_7, M4(-1.086e-01, 3.082e-01, 3.515e-01, 1.455e-01, -1.311e-01, 1.556e-01, -9.044e-02, -6.178e-02, 1.637e-01, 9.177e-02, -1.618e-01, -7.785e-02, 4.761e-02, -1.013e-01, -9.998e-02, -1.424e-02), r);
	r = MulAdd(s3_8, M4(5.134e-01, 2.088e-01, 3.485e-01, 2.017e-01, 2.709e-01, 1.314e-01, -1.887e-01, 1.701e-02, -7.644e-02, -2.681e-01, 2.699e-01, 2.012e-02, -5.078e-02, -7.899e-02, 3.061e-02, -6.543e-02), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -6.100e-03, -5.629e-03, -2.164e-03, -5.154e-03 };
	r = MulAdd(s0_0, M4(-1.903e-02, -1.951e-01, 3.731e-02, 2.407e-01, -4.087e-02, -1.242e-01, 1.591e-01, 1.461e-01, 1.144e-03, 6.971e-02, 6.376e-02, -4.822e-02, -4.229e-03, -2.948e-02, -2.453e-02, 3.279e-02), r);
	r = MulAdd(s0_1, M4(-1.397e-01, -2.025e-01, -1.174e-01, -2.333e-01, -6.637e-02, 1.611e-01, -2.374e-01, 1.920e-01, -8.692e-03, 1.128e-02, -7.000e-02, 1.043e-01, -1.646e-01, -7.105e-02, -5.099e-02, -7.850e-02), r);
	r = MulAdd(s0_2, M4(-3.493e-02, 1.631e-01, -1.295e-01, -3.915e-02, -8.689e-03, 2.153e-01, -1.786e-01, 8.576e-02, 3.957e-02, -1.725e-02, 6.660e-03, -9.336e-02, -1.944e-01, -2.239e-01, -1.146e-01, 6.279e-02), r);
	r = MulAdd(s0_3, M4(1.048e-01, -2.091e-01, 1.755e-01, 1.312e-01, -4.776e-02, 3.309e-02, -1.652e-01, 4.016e-02, -3.431e-02, -9.573e-02, 2.284e-03, 4.407e-02, -7.497e-03, 5.382e-02, 1.636e-02, -3.983e-02), r);
	r = MulAdd(s0_4, M4(2.202e-01, -1.826e-01, 1.413e-01, -8.920e-01, 2.626e-02, -6.326e-02, 1.165e-02, 2.816e-01, -1.011e-01, 1.952e-02, 1.909e-02, -1.977e-03, 1.714e-02, -1.762e-01, 1.561e-02, 1.896e-02), r);
	r = MulAdd(s0_5, M4(-8.408e-02, -8.961e-02, -7.309e-02, -9.936e-03, 1.714e-01, 3.017e-01, -3.199e-02, 3.944e-02, 5.782e-02, 4.041e-02, 1.135e-01, -1.899e-02, -6.783e-01, -7.227e-01, -5.489e-02, 3.710e-01), r);
	r = MulAdd(s0_6, M4(4.481e-02, -1.328e-01, 3.195e-01, 2.234e-01, 3.281e-02, -1.410e-01, -2.458e-01, -3.179e-02, -9.318e-03, -5.619e-02, -4.831e-02, 9.783e-03, 6.137e-05, -3.615e-02, -4.932e-02, 4.382e-02), r);
	r = MulAdd(s0_7, M4(8.583e-02, -3.896e-01, -2.696e-01, -1.379e-01, 8.896e-04, -4.113e-02, -1.003e-01, -2.234e-01, -2.070e-02, 6.911e-02, 5.273e-02, 5.350e-02, 1.194e-01, -2.388e-01, -7.249e-02, 1.641e-01), r);
	r = MulAdd(s0_8, M4(3.917e-03, 4.653e-02, 4.208e-02, -2.972e-02, 7.932e-02, 7.600e-02, 1.999e-01, 1.265e-01, 1.091e-01, -4.210e-02, -1.266e-01, -6.501e-02, -1.778e-01, -2.900e-01, -1.907e-01, -1.097e-01), r);
	r = MulAdd(s1_0, M4(-1.594e-02, -1.106e-01, -6.409e-02, -8.242e-02, -6.067e-02, -1.114e-02, 1.503e-01, -2.305e-02, 9.436e-02, 5.593e-02, -8.865e-02, -3.842e-01, -1.487e-02, 6.278e-02, -9.395e-02, 1.747e-02), r);
	r = MulAdd(s1_1, M4(-9.406e-02, 1.059e-01, -5.180e-02, 8.490e-02, 2.999e-02, 7.354e-02, 9.773e-02, 6.806e-02, -1.499e-01, 3.132e-01, -1.413e-01, 3.941e-01, -1.043e-01, 8.054e-02, 7.889e-02, 6.038e-02), r);
	r = MulAdd(s1_2, M4(-5.049e-02, 8.765e-02, -3.552e-02, 5.389e-02, 1.399e-02, 4.153e-02, -9.329e-02, 5.096e-02, -5.803e-03, -3.089e-02, -3.274e-01, 2.702e-01, -1.782e-01, -3.271e-02, 3.820e-02, 6.556e-02), r);
	r = MulAdd(s1_3, M4(1.295e-01, -1.074e-01, 1.311e-01, 1.953e-02, -7.175e-02, -2.176e-01, -4.113e-02, -6.624e-02, -1.264e-01, -1.084e+00, -8.971e-02, -4.195e-01, -3.640e-02, 1.017e-01, 1.374e-02, -3.757e-02), r);
	r = MulAdd(s1_4, M4(1.402e-01, 7.449e-02, 2.512e-01, -3.099e-01, -1.449e-01, -2.211e-01, 2.472e-01, -8.322e-02, -5.802e-01, -9.452e-01, -3.769e-01, -7.299e-01, 1.703e-02, 5.013e-02, 2.580e-02, 1.018e-01), r);
	r = MulAdd(s1_5, M4(-1.122e-01, -3.917e-02, 1.255e-01, 1.104e-01, 1.611e-01, 1.474e-01, -6.121e-02, -2.863e-02, 6.412e-01, -4.582e-01, -9.288e-01, -1.703e+00, -8.581e-01, -1.186e-01, -1.852e-02, 1.764e-01), r);
	r = MulAdd(s1_6, M4(-2.302e-02, -1.122e-01, -6.733e-04, 8.064e-02, 6.468e-02, -9.918e-02, 4.609e-02, -3.326e-02, -7.172e-02, -3.604e-01, 4.166e-01, 1.496e-02, 1.941e-02, -8.164e-03, -1.005e-01, 3.534e-03), r);
	r = MulAdd(s1_7, M4(-4.566e-02, 1.576e-01, -8.564e-02, -1.512e-02, 2.097e-02, -1.125e-01, 2.043e-02, -3.300e-01, -1.351e-01, -6.389e-01, -3.509e-01, -1.141e-01, 9.899e-02, -7.529e-02, 1.057e-01, 2.057e-02), r);
	r = MulAdd(s1_8, M4(5.309e-02, 7.249e-02, 3.752e-02, -4.934e-02, 5.045e-02, 9.157e-02, 3.824e-03, -2.342e-02, 3.056e-01, -2.377e-03, 4.013e-01, -8.652e-02, -1.557e-01, -6.980e-02, -3.395e-02, -1.831e-01), r);
	r = MulAdd(s2_0, M4(-2.140e-02, 3.373e-02, -6.324e-02, 1.341e-02, -6.006e-02, -1.390e-01, 1.304e-01, -7.396e-02, 1.053e-02, 4.035e-02, -7.677e-02, 2.362e-02, 1.909e-02, 2.325e-01, 1.447e-01, 7.323e-02), r);
	r = MulAdd(s2_1, M4(1.795e-02, -3.169e-04, 1.030e-01, 1.265e-01, -1.093e-01, -1.128e-01, -1.884e-02, 1.473e-01, 4.227e-02, 4.771e-02, -5.342e-03, 3.107e-02, 9.337e-02, 3.386e-01, 9.080e-02, -1.308e-01), r);
	r = MulAdd(s2_2, M4(-3.594e-02, -3.244e-02, 9.089e-02, 6.626e-02, 8.157e-03, 1.997e-01, 3.726e-01, -1.223e-01, 7.486e-02, 9.483e-02, -7.558e-02, 3.820e-02, 3.465e-02, 9.637e-02, 1.463e-01, 1.243e-01), r);
	r = MulAdd(s2_3, M4(-2.022e-02, 5.208e-02, 1.797e-01, 1.583e-02, -1.421e-01, -2.013e-01, 1.746e-01, -9.217e-02, -5.599e-02, 1.221e-01, -1.353e-01, 2.996e-03, -1.491e-02, 2.928e-02, 2.489e-02, 2.708e-02), r);
	r = MulAdd(s2_4, M4(-2.417e-01, 2.697e-01, 1.544e-02, 3.408e-01, 5.464e-01, -1.619e-01, -1.491e-01, -2.986e-02, -9.208e-02, -4.481e-01, -1.674e-01, -8.227e-02, -1.887e-01, -3.818e-02, 1.558e-01, -5.454e-02), r);
	r = MulAdd(s2_5, M4(2.332e-01, 1.534e-01, -1.023e-01, -1.223e-01, -4.520e-01, 2.117e-02, 4.059e-01, 1.739e-01, 9.972e-02, -3.460e-01, -2.232e-01, -9.188e-02, -3.011e-01, 9.661e-02, 2.294e-01, 4.967e-01), r);
	r = MulAdd(s2_6, M4(-2.340e-02, 4.372e-01, 5.542e-02, -9.070e-02, 6.642e-03, -7.093e-02, 3.614e-02, -1.240e-02, -1.341e-03, -6.169e-02, -1.849e-01, -2.486e-02, 2.831e-02, -1.802e-01, -2.525e-02, -5.149e-02), r);
	r = MulAdd(s2_7, M4(-7.215e-02, 6.276e-01, 2.174e-01, 2.019e-01, 1.082e-01, 5.354e-02, 1.379e-02, -1.519e-01, 3.392e-02, -2.885e-01, 6.024e-02, 1.196e-01, -1.217e-02, 4.156e-02, 7.591e-02, -7.825e-02), r);
	r = MulAdd(s2_8, M4(4.152e-02, 3.043e-02, -9.412e-03, 1.857e-01, -5.486e-02, -1.094e-02, 1.109e-01, 3.213e-02, 9.758e-02, -3.680e-01, -8.002e-02, 1.475e-01, -1.528e-01, 2.880e-01, 3.799e-01, 7.434e-02), r);
	r = MulAdd(s3_0, M4(-1.587e-02, -1.111e-01, -1.103e-01, -8.218e-03, -2.111e-02, -1.207e-03, -2.931e-02, -3.011e-02, -9.070e-03, 8.353e-02, -7.659e-02, 7.656e-03, 9.231e-03, 7.664e-02, -1.290e-02, 1.033e-01), r);
	r = MulAdd(s3_1, M4(-1.663e-02, -2.158e-01, -2.743e-02, -3.814e-02, -7.382e-02, -3.598e-02, -2.445e-01, -2.235e-02, -5.268e-02, 1.668e-02, 5.700e-02, 1.989e-01, 2.021e-02, 1.277e-01, -3.154e-02, -2.325e-02), r);
	r = MulAdd(s3_2, M4(2.185e-02, -7.522e-02, 9.069e-02, -6.605e-02, -7.998e-02, 3.981e-02, -5.009e-02, -1.897e-01, 1.052e-01, 2.140e-01, -1.733e-01, -5.374e-02, -1.005e-02, -3.066e-02, -2.403e-02, 1.075e-01), r);
	r = MulAdd(s3_3, M4(-7.010e-02, -2.416e-01, -9.685e-02, -1.127e-02, -1.742e-01, 6.831e-04, -1.254e-02, -1.752e-02, -7.957e-02, 5.913e-02, 1.330e-01, -3.948e-02, -3.154e-02, 3.913e-02, -1.559e-01, -2.551e-03), r);
	r = MulAdd(s3_4, M4(-3.353e-01, -1.453e-01, -4.606e-01, -9.453e-02, 5.683e-01, 5.758e-02, -6.855e-01, -2.280e-02, -1.119e-01, -3.075e-01, -1.257e-01, 1.525e-01, -1.558e-01, -3.928e-02, -1.199e-01, -2.134e-01), r);
	r = MulAdd(s3_5, M4(1.197e-01, -2.141e-01, -5.354e-02, -2.723e-01, -4.297e-01, -1.564e-01, -3.910e-03, 4.950e-01, 5.365e-01, 4.068e-01, 8.903e-02, -1.515e-01, -1.595e-01, -9.696e-02, 4.988e-02, 3.443e-01), r);
	r = MulAdd(s3_6, M4(-4.645e-02, -1.016e-01, -4.400e-02, -1.985e-02, -1.540e-02, -7.543e-02, -6.173e-02, -4.023e-03, -1.087e-02, 9.029e-02, -2.016e-02, -8.725e-02, 2.866e-02, -1.784e-01, -1.198e-01, -4.092e-02), r);
	r = MulAdd(s3_7, M4(1.047e-01, -3.071e-01, 4.047e-02, 2.940e-02, 9.727e-02, 1.644e-02, -4.037e-04, 9.290e-04, -2.380e-02, 2.100e-01, -4.936e-02, 1.706e-01, 1.528e-02, -1.440e-01, -1.978e-01, -1.937e-01), r);
	r = MulAdd(s3_8, M4(-3.675e-02, -2.837e-01, -2.650e-01, -1.265e-01, -8.426e-02, 8.075e-02, -1.650e-01, 1.255e-01, 4.193e-02, -1.812e-02, 2.658e-02, -1.294e-02, -1.497e-02, 5.846e-02, 5.440e-02, -5.090e-02), r);
	return r;
}

void Pass3(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 4
//!DESC conv3
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 4.531e-03, -8.111e-04, -4.559e-03, 1.344e-02 };
	r = MulAdd(s0_0, M4(1.460e-01, -2.503e-03, -2.140e-02, 2.070e-01, 1.642e-01, 3.938e-02, -3.263e-02, 2.015e-01, -4.626e-02, 3.951e-02, 1.449e-02, 2.009e-01, 5.058e-02, -4.454e-02, -1.328e-02, 1.673e-01), r);
	r = MulAdd(s0_1, M4(6.362e-02, -5.345e-03, -1.315e-02, 2.544e-02, 1.481e-01, 1.702e-02, 4.910e-02, 7.624e-02, -1.192e-01, 7.445e-02, -6.032e-02, 5.518e-02, -1.580e-01, 1.302e-01, 9.593e-02, -3.273e-01), r);
	r = MulAdd(s0_2, M4(8.558e-02, -7.543e-02, -6.527e-02, 2.885e-02, 1.973e-01, -1.098e-01, -3.435e-02, 9.459e-02, 5.094e-02, 7.949e-03, 1.923e-02, -1.689e-01, 3.913e-02, -9.038e-02, 3.628e-02, -2.234e-01), r);
	r = MulAdd(s0_3, M4(1.441e-01, -9.906e-02, 2.901e-02, -8.990e-02, 9.260e-02, 1.779e-01, -5.753e-02, 1.198e-01, -4.089e-02, -2.679e-02, 2.567e-01, -2.316e-01, 2.826e-02, 3.657e-02, -5.245e-02, -1.481e-01), r);
	r = MulAdd(s0_4, M4(-6.895e-02, 1.641e-01, -2.386e-01, -2.188e-01, 1.864e-01, -2.987e-03, -9.756e-02, -2.084e-01, -6.674e-02, 5.989e-02, 2.618e-01, -1.881e-01, -2.528e-01, -7.958e-02, -1.960e-01, -8.874e-02), r);
	r = MulAdd(s0_5, M4(-2.057e-01, 2.163e-01, -1.032e-01, 2.606e-02, 2.536e-01, -1.757e-01, -3.088e-02, 9.971e-02, 3.508e-02, 6.749e-02, -7.082e-02, -5.879e-02, 4.556e-01, -2.563e-01, 3.354e-01, -1.140e-01), r);
	r = MulAdd(s0_6, M4(4.626e-02, -3.616e-02, 3.660e-02, -6.943e-02, -2.409e-02, -7.460e-02, 3.468e-02, -1.478e-01, 3.061e-04, 3.629e-02, 3.037e-02, -4.552e-02, -1.420e-01, -4.576e-02, -2.385e-02, 6.238e-03), r);
	r = MulAdd(s0_7, M4(2.317e-02, -4.572e-02, 1.373e-01, -4.412e-02, -2.654e-01, 1.417e-01, -2.566e-02, 7.823e-02, 5.192e-02, 1.253e-02, 2.714e-02, 4.986e-02, -6.517e-02, 1.725e-01, -3.147e-01, 1.810e-01), r);
	r = MulAdd(s0_8, M4(-7.655e-02, 1.568e-02, 4.386e-02, -2.880e-02, 1.294e-01, -4.386e-02, -1.892e-01, 1.013e-01, -4.186e-02, -1.205e-02, -1.252e-02, 2.672e-02, 9.946e-02, -1.116e-01, -8.791e-02, -5.216e-02), r);
	r = MulAdd(s1_0, M4(1.416e-01, -2.957e-02, 4.620e-02, 2.061e-01, -1.485e-03, 2.902e-02, 8.762e-02, -1.343e-02, -9.476e-02, -8.555e-02, -1.367e-01, -5.685e-01, 1.643e-02, 5.774e-02, -2.975e-02, -5.926e-02), r);
	r = MulAdd(s1_1, M4(-1.076e-01, 1.057e-01, 8.230e-02, 2.622e-01, -3.980e-02, 9.033e-02, 4.219e-02, 2.085e-01, -3.702e-01, 3.284e-01, -1.205e-01, 4.759e-01, -9.593e-03, 6.312e-02, -3.021e-02, -1.414e-01), r);
	r = MulAdd(s1_2, M4(-7.337e-02, 1.111e-02, 2.710e-03, 2.014e-02, 4.307e-03, 5.057e-02, -2.255e-02, 1.778e-01, 3.245e-02, 5.045e-02, -2.178e-02, -4.287e-01, -8.326e-02, -4.708e-02, 3.045e-02, 2.593e-02), r);
	r = MulAdd(s1_3, M4(3.675e-02, -1.743e-01, -1.996e-02, -2.225e-02, 3.629e-02, -4.751e-02, 4.292e-02, -4.781e-02, 1.730e-01, 1.333e-01, 1.877e-01, 7.252e-02, 5.021e-02, 4.278e-03, -8.554e-02, -1.798e-01), r);
	r = MulAdd(s1_4, M4(-2.651e-01, 7.933e-02, -1.525e-01, -4.634e-02, -4.800e-02, 4.021e-02, 9.500e-02, 3.373e-02, -4.455e-02, 1.410e-01, 7.064e-01, 1.166e-01, -2.249e-01, 1.612e-01, -1.835e-01, -1.426e-01), r);
	r = MulAdd(s1_5, M4(-2.822e-01, 1.256e-01, -6.588e-02, 5.687e-02, -1.322e-01, 6.351e-02, -1.372e-01, -4.876e-02, 6.367e-02, 1.225e-02, -3.775e-03, -3.821e-01, -8.246e-02, 2.336e-02, 5.701e-02, -9.513e-02), r);
	r = MulAdd(s1_6, M4(-4.435e-02, -2.383e-02, 2.873e-02, 1.033e-01, -3.893e-02, -4.387e-03, 1.064e-01, -1.552e-03, -3.830e-02, -8.205e-03, 6.505e-02, -1.395e-01, -2.812e-02, -1.357e-01, -4.313e-02, -1.492e-01), r);
	r = MulAdd(s1_7, M4(-4.363e-02, -2.478e-02, 8.346e-03, -4.201e-02, -5.849e-02, -1.863e-02, 6.421e-02, -7.445e-02, 1.853e-02, -3.674e-02, 6.083e-02, -4.624e-02, -2.120e-01, 3.527e-01, -3.120e-01, 9.880e-02), r);
	r = MulAdd(s1_8, M4(-9.998e-02, 1.131e-02, 3.393e-02, 8.990e-02, -5.088e-02, -1.396e-02, 6.092e-02, -2.058e-02, 1.320e-02, -3.463e-02, 4.451e-02, -6.250e-02, 2.477e-01, -9.122e-02, 4.647e-02, 5.444e-02), r);
	r = MulAdd(s2_0, M4(1.738e-02, 5.692e-05, -3.280e-02, 1.116e-01, -4.025e-02, -6.378e-03, 6.333e-02, -2.169e-02, 1.159e-03, 5.745e-02, -1.892e-02, -5.304e-02, -8.005e-03, 6.982e-03, 1.781e-02, -1.290e-01), r);
	r = MulAdd(s2_1, M4(2.053e-02, 1.001e-01, -5.542e-02, 1.997e-01, -1.069e-01, -1.316e-01, -9.407e-03, -2.496e-01, -1.271e-01, 5.652e-02, 9.357e-02, -5.321e-02, -1.236e-02, -3.268e-02, -1.057e-01, 3.677e-01), r);
	r = MulAdd(s2_2, M4(-1.572e-01, 1.607e-01, -1.469e-02, -2.933e-02, 1.361e-01, -1.904e-01, -1.410e-02, -1.019e-01, -2.218e-02, -1.175e-01, 1.221e-02, -9.969e-02, -1.374e-02, 1.115e-01, 5.505e-02, -4.364e-02), r);
	r = MulAdd(s2_3, M4(2.645e-02, -1.315e-01, 5.348e-02, -6.960e-02, -8.126e-02, 2.138e-02, 4.465e-02, -1.993e-03, -2.183e-02, -1.264e-01, -7.401e-02, -1.451e-01, 1.713e-01, -9.877e-02, 1.130e-01, -1.241e-01), r);
	r = MulAdd(s2_4, M4(-8.051e-01, -4.633e-02, -1.499e-01, 4.505e-02, -1.396e-01, 1.184e-01, -3.166e-02, 2.424e-01, -3.324e-02, -4.050e-02, -2.288e-01, 2.254e-02, 1.225e-01, 2.109e-01, 4.975e-01, 2.566e-02), r);
	r = MulAdd(s2_5, M4(-1.325e-01, 3.603e-01, -1.102e-01, 8.552e-02, 1.978e-01, -1.439e-01, 2.342e-02, -1.104e-01, -9.703e-02, 1.217e-03, 6.674e-02, -4.943e-03, 1.047e-01, 1.100e-01, -7.425e-02, -1.426e-01), r);
	r = MulAdd(s2_6, M4(6.620e-02, -5.105e-03, 5.341e-02, 6.188e-02, 1.215e-01, -4.942e-02, -2.350e-02, -2.389e-03, 7.577e-03, -1.194e-02, 7.483e-02, 2.797e-02, 8.517e-02, -1.188e-01, -9.627e-03, -3.775e-02), r);
	r = MulAdd(s2_7, M4(-7.349e-02, -8.638e-02, 1.668e-01, -1.634e-01, -2.610e-02, 5.929e-02, 1.200e-01, 1.551e-01, -6.725e-02, 2.538e-02, 3.603e-02, 6.823e-02, -9.709e-02, -5.752e-03, -5.046e-02, -1.508e-01), r);
	r = MulAdd(s2_8, M4(-1.805e-01, 7.995e-02, -1.702e-02, 6.758e-02, -5.362e-02, -2.128e-02, 5.766e-02, -1.263e-01, 1.730e-02, -2.622e-02, 8.422e-02, -8.742e-03, 1.736e-02, 5.187e-02, -1.939e-02, -6.008e-02), r);
	r = MulAdd(s3_0, M4(2.769e-02, -6.180e-02, -1.595e-02, -5.555e-02, 7.106e-02, 1.989e-02, -8.007e-03, 3.022e-02, 8.952e-02, -8.760e-02, 3.358e-03, 5.172e-01, -5.316e-02, -1.774e-02, -1.529e-02, 3.360e-02), r);
	r = MulAdd(s3_1, M4(2.083e-01, -1.959e-01, -3.492e-02, -1.062e-01, -1.991e-01, 1.627e-01, 4.752e-02, 1.935e-01, -4.772e-02, -4.620e-01, 6.199e-01, -5.559e-01, 5.407e-02, -1.701e-02, -9.253e-02, -2.324e-01), r);
	r = MulAdd(s3_2, M4(-2.318e-02, 4.885e-02, 4.424e-02, -1.622e-01, 3.683e-02, 8.032e-03, 4.170e-03, -2.176e-01, 1.676e-01, -5.978e-01, 1.706e-01, 5.688e-02, -3.584e-02, -3.374e-02, 9.832e-02, 8.184e-02), r);
	r = MulAdd(s3_3, M4(7.349e-02, -1.023e-01, 3.799e-02, -7.277e-02, -6.203e-02, -2.119e-02, 3.634e-02, -6.658e-02, -3.352e-01, 6.581e-01, 4.496e-01, -4.329e-02, 1.106e-01, -1.827e-01, 1.568e-01, 5.295e-02), r);
	r = MulAdd(s3_4, M4(1.424e-01, -9.230e-01, 4.605e-02, 1.233e-02, 3.738e-02, -2.959e-02, -9.470e-02, -1.115e-02, 3.737e-01, -2.685e-01, -1.735e-02, 1.542e-01, -3.248e-01, 3.305e-01, 1.752e-01, 2.610e-02), r);
	r = MulAdd(s3_5, M4(4.717e-01, -2.105e-01, 3.212e-02, 1.470e-02, 6.355e-02, 3.502e-02, -6.022e-04, 7.889e-02, -9.257e-03, -6.054e-01, 5.161e-01, 6.461e-02, 2.712e-01, -2.589e-01, 8.823e-02, 8.179e-02), r);
	r = MulAdd(s3_6, M4(6.777e-02, 4.699e-02, -9.605e-03, 7.196e-02, 3.270e-02, 2.843e-02, 6.386e-02, 2.463e-02, -6.469e-02, -1.302e-01, 3.400e-02, 6.313e-01, 1.639e-01, -1.763e-01, -8.542e-02, 1.369e-01), r);
	r = MulAdd(s3_7, M4(-1.241e-02, -2.214e-03, 2.025e-01, -6.725e-02, 7.727e-02, -1.428e-02, -5.117e-02, 1.164e-01, 3.355e-02, 1.263e-01, 2.701e-01, 3.418e-01, -1.227e-01, 7.170e-02, 3.163e-02, 8.146e-02), r);
	r = MulAdd(s3_8, M4(-5.885e-02, -2.514e-02, -1.081e-01, 3.977e-02, -9.304e-02, 1.579e-02, 5.317e-02, -7.459e-04, -1.390e-02, -3.147e-01, 6.463e-01, 3.237e-01, 3.543e-02, 2.026e-02, -4.326e-02, 8.351e-02), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 7.221e-03, -6.181e-03, -9.146e-03, -1.076e-02 };
	r = MulAdd(s0_0, M4(5.109e-03, -1.013e-01, -4.476e-03, 2.371e-02, -1.188e-02, 2.613e-02, 4.354e-03, 5.263e-02, 2.261e-02, 1.565e-01, 1.185e-01, -7.047e-02, -5.470e-03, -6.023e-02, -5.102e-02, -4.978e-02), r);
	r = MulAdd(s0_1, M4(3.411e-02, -6.323e-02, 2.892e-01, 5.630e-02, -9.362e-02, 2.923e-02, 3.466e-01, 1.604e-01, -1.297e-01, 9.643e-02, -8.275e-02, -6.924e-02, -6.175e-03, 7.658e-03, -1.293e-01, 2.992e-02), r);
	r = MulAdd(s0_2, M4(-6.653e-02, 7.399e-02, -6.861e-02, 2.062e-02, -1.039e-01, -7.505e-02, 1.044e-03, 5.407e-02, -4.158e-02, 1.475e-02, 1.392e-02, 6.334e-02, 9.506e-02, 1.937e-02, -4.186e-02, -3.346e-02), r);
	r = MulAdd(s0_3, M4(-7.411e-02, -9.890e-02, 2.862e-02, -1.133e-02, -6.961e-02, 1.554e-01, -3.630e-02, 4.619e-02, -5.479e-02, -8.802e-02, -3.359e-02, 1.322e-02, 4.674e-02, 6.430e-02, -1.762e-01, -9.326e-02), r);
	r = MulAdd(s0_4, M4(3.798e-01, 3.569e-01, 3.303e-02, -3.879e-01, 1.660e-01, 3.253e-01, 5.718e-01, 4.811e-01, 2.049e-01, 2.783e-01, 1.532e-01, 2.310e-01, 1.625e-01, 2.305e-01, 1.518e-01, 1.102e-01), r);
	r = MulAdd(s0_5, M4(-2.511e-02, 7.963e-02, 1.293e-01, -1.074e-01, -3.559e-01, -3.133e-02, -3.580e-01, 1.722e-01, -2.363e-01, -6.018e-02, 2.465e-02, -2.001e-02, -3.252e-01, -1.818e-01, 3.119e-01, 2.003e-01), r);
	r = MulAdd(s0_6, M4(-6.486e-02, 7.469e-03, 1.003e-02, 1.480e-02, 6.965e-02, -1.185e-02, -4.961e-02, -3.236e-02, -8.740e-02, -5.041e-02, 1.229e-02, 5.909e-02, -6.895e-03, -9.904e-02, 8.634e-02, 4.633e-02), r);
	r = MulAdd(s0_7, M4(6.900e-03, -1.665e-02, -1.701e-02, -9.881e-02, -7.354e-02, -1.694e-01, 1.642e-01, 9.754e-02, 6.378e-02, 1.202e-02, 1.083e-01, -2.660e-02, -3.433e-01, -3.428e-01, 4.544e-02, 4.121e-02), r);
	r = MulAdd(s0_8, M4(1.150e-02, -9.370e-03, 3.042e-02, -6.306e-02, -1.127e-01, 1.582e-02, 1.082e-02, 1.499e-01, 3.286e-03, 9.324e-03, -7.105e-02, 2.163e-02, 2.231e-01, -2.537e-02, 2.663e-02, 1.020e-01), r);
	r = MulAdd(s1_0, M4(-2.882e-02, -1.364e-01, -6.985e-02, -8.632e-02, -1.159e-02, 5.210e-02, -1.038e-01, -3.735e-02, 1.732e-01, 1.714e-01, 4.997e-03, -9.303e-02, -7.473e-02, 5.196e-02, -7.526e-02, -1.339e-02), r);
	r = MulAdd(s1_1, M4(7.270e-02, -5.112e-02, 2.064e-01, -9.973e-02, 1.341e-01, -9.910e-02, 1.171e-01, -1.909e-02, 2.098e-01, 2.391e-01, 1.460e-01, -2.052e-01, -9.156e-02, 3.022e-03, -7.790e-02, -1.620e-02), r);
	r = MulAdd(s1_2, M4(8.411e-02, 2.544e-02, -8.592e-02, -1.476e-01, -8.090e-02, 2.901e-02, 3.733e-03, 7.357e-02, 1.347e-01, 1.987e-02, 1.459e-01, -1.547e-02, 1.014e-01, -2.559e-02, 8.887e-02, 2.969e-02), r);
	r = MulAdd(s1_3, M4(9.597e-02, -3.545e-01, -2.156e-02, -4.908e-02, -5.108e-02, -8.399e-02, 5.381e-02, 1.013e-01, 3.602e-02, 2.681e-01, 2.220e-02, 1.373e-01, 4.991e-02, 4.378e-02, -7.537e-02, -2.068e-01), r);
	r = MulAdd(s1_4, M4(5.888e-01, 2.576e-01, -3.241e-01, -4.970e-01, 1.664e-01, 2.416e-01, 3.465e-01, 7.672e-02, 1.097e-01, 5.451e-01, 1.206e-01, 4.713e-01, -2.924e-03, 2.240e-01, 1.714e-01, -3.315e-04), r);
	r = MulAdd(s1_5, M4(1.887e-01, 8.490e-02, -8.236e-02, -2.263e-01, -4.718e-02, 6.606e-02, -2.596e-01, -2.097e-01, -1.909e-01, -3.157e-01, 1.629e-01, 3.072e-02, 4.002e-01, 1.577e-01, 1.484e-01, 5.068e-02), r);
	r = MulAdd(s1_6, M4(-9.601e-03, -5.944e-02, -6.170e-03, -5.131e-02, -6.913e-02, -1.295e-02, -2.661e-02, 8.608e-03, -1.877e-01, -9.093e-02, 4.880e-02, 7.809e-02, 2.246e-01, 1.962e-01, -1.578e-02, -1.218e-01), r);
	r = MulAdd(s1_7, M4(1.245e-01, -6.743e-02, -7.707e-02, -2.127e-01, -2.682e-02, -5.999e-02, -2.738e-02, -2.108e-02, 7.802e-03, -2.028e-01, 1.086e-01, -8.522e-02, -3.510e-01, -1.243e-01, -7.196e-02, 5.012e-02), r);
	r = MulAdd(s1_8, M4(1.554e-01, 1.041e-01, -8.905e-02, -1.498e-02, -2.704e-02, -4.771e-03, -8.702e-02, 6.094e-02, -7.724e-02, -1.039e-01, -4.334e-02, -6.489e-02, 1.061e-02, -1.715e-01, 3.398e-01, 1.436e-01), r);
	r = MulAdd(s2_0, M4(1.898e-02, -6.796e-02, -9.681e-02, 5.317e-02, -6.710e-02, -2.401e-01, 8.957e-02, -1.326e-01, -1.285e-01, -4.354e-02, -4.742e-02, 5.456e-02, -3.094e-02, 9.700e-02, -1.397e-01, -1.736e-01), r);
	r = MulAdd(s2_1, M4(-1.130e-01, -8.727e-02, -6.717e-02, 1.105e-01, 3.471e-01, 4.923e-02, 3.048e-02, 1.696e-01, -5.733e-02, -4.620e-02, 2.674e-02, 2.742e-02, 1.125e-01, -3.257e-02, -1.607e-01, 2.017e-01), r);
	r = MulAdd(s2_2, M4(-1.016e-01, 8.385e-03, -1.411e-01, -2.757e-02, -7.714e-03, 6.335e-02, 8.580e-02, -8.000e-03, 9.101e-04, -8.858e-02, -4.917e-02, -2.892e-02, -6.813e-02, -1.086e-02, 6.338e-02, -1.416e-02), r);
	r = MulAdd(s2_3, M4(9.098e-02, 1.957e-01, -9.551e-02, 1.372e-02, 5.547e-02, -5.539e-02, -7.710e-02, 4.348e-02, 6.994e-02, -9.307e-03, 4.403e-02, 4.120e-02, -4.607e-02, 1.169e-02, -1.930e-01, 2.159e-02), r);
	r = MulAdd(s2_4, M4(4.111e-01, 8.301e-01, -3.466e-01, -9.503e-01, 6.933e-02, -1.913e-02, 2.897e-01, 6.002e-02, 1.656e-01, -2.074e-01, -2.278e-01, -2.744e-01, 1.898e-01, 3.807e-01, 1.588e-01, 1.337e-01), r);
	r = MulAdd(s2_5, M4(3.547e-02, 9.913e-02, 2.290e-01, -1.001e-01, 2.844e-01, -5.348e-02, 3.102e-01, 2.668e-01, -2.307e-02, 1.603e-02, -1.343e-01, -1.940e-01, -6.855e-02, 7.183e-03, 2.743e-01, 1.129e-01), r);
	r = MulAdd(s2_6, M4(-2.187e-02, -2.622e-02, -4.526e-02, -6.321e-03, -8.359e-02, -1.268e-01, 8.651e-02, -6.939e-03, 2.957e-02, 5.836e-03, -2.792e-02, -3.501e-02, 7.605e-02, 2.245e-02, 3.698e-02, -4.302e-02), r);
	r = MulAdd(s2_7, M4(1.205e-01, -8.147e-02, -2.218e-01, -2.645e-01, 7.159e-02, 2.437e-01, -2.439e-02, 1.300e-01, -3.909e-02, -1.879e-02, -1.024e-01, 1.197e-02, 4.967e-02, 1.628e-01, -2.973e-02, -5.674e-02), r);
	r = MulAdd(s2_8, M4(-4.114e-02, 2.495e-03, -6.669e-02, -1.126e-01, 1.185e-03, -2.611e-01, 4.307e-02, -4.078e-02, 1.727e-02, 3.137e-02, 4.402e-02, -9.532e-03, -1.445e-01, -2.802e-02, 8.805e-02, -3.620e-02), r);
	r = MulAdd(s3_0, M4(5.592e-02, -5.986e-02, 4.212e-02, -1.351e-02, -1.183e-01, -7.062e-02, -2.884e-02, -9.861e-02, 2.923e-01, -3.872e-01, -7.561e-02, -2.126e-01, -1.087e-02, 2.638e-01, -1.060e-01, -2.521e-02), r);
	r = MulAdd(s3_1, M4(-2.393e-03, 1.342e-02, -2.694e-01, -3.229e-02, 9.839e-02, 1.256e-01, 1.459e-01, 5.196e-02, 6.062e-01, -5.927e-01, 5.081e-01, -8.134e-01, -5.183e-01, -9.299e-02, -4.591e-01, 4.634e-01), r);
	r = MulAdd(s3_2, M4(-1.243e-01, -1.546e-03, -2.050e-01, -9.618e-02, 1.164e-01, 3.858e-03, 2.954e-01, 2.534e-02, 2.224e-01, 3.648e-01, -4.268e-01, -7.856e-01, -1.146e-01, -5.429e-03, -3.244e-01, 4.515e-02), r);
	r = MulAdd(s3_3, M4(1.545e-02, 1.267e-01, 1.834e-01, 1.085e-01, 8.707e-02, 3.956e-02, -6.194e-02, -8.369e-02, 1.215e-01, 1.556e-01, -5.293e-01, -1.505e-01, 1.939e-01, 1.340e-01, -4.531e-01, -2.169e-01), r);
	r = MulAdd(s3_4, M4(-4.717e-01, 4.645e-01, 4.459e-01, -9.550e-02, 3.874e-01, 3.174e-01, -2.450e-01, 9.813e-02, 4.528e-01, -9.403e-01, 9.279e-01, -4.499e-01, 5.985e-02, -6.119e-01, 4.211e-01, -1.085e-01), r);
	r = MulAdd(s3_5, M4(-2.976e-01, -2.410e-01, 1.306e-01, 1.568e-01, 2.322e-01, 1.803e-01, 3.317e-01, 1.716e-01, 6.972e-01, 1.567e-01, -3.980e-01, -6.066e-01, 1.686e-02, -8.061e-02, -1.006e-01, 1.342e-01), r);
	r = MulAdd(s3_6, M4(-8.888e-02, -1.646e-01, 7.995e-02, -2.675e-02, -4.782e-02, -7.957e-02, -5.547e-02, -2.723e-04, 2.751e-01, -3.776e-01, 1.641e-01, 3.858e-01, 1.835e-01, 7.779e-02, -5.251e-02, -1.195e-01), r);
	r = MulAdd(s3_7, M4(-9.921e-02, -8.667e-02, -1.878e-02, -1.259e-01, 8.537e-02, -4.571e-02, 2.510e-01, 3.064e-02, 1.216e-01, -1.229e-01, 1.490e-01, -2.311e-01, 1.152e-02, -6.642e-02, -7.519e-02, 1.796e-02), r);
	r = MulAdd(s3_8, M4(-4.726e-02, 2.303e-02, -6.555e-02, -3.746e-02, 4.466e-02, -5.962e-02, -4.969e-02, -8.936e-02, 2.212e-01, -2.673e-02, -1.224e-01, 2.754e-02, -6.249e-02, -4.974e-02, 2.964e-02, 1.651e-02), r);
	return r;
}

void Pass4(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 5
//!DESC conv4
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -2.990e-03, -3.480e-03, 7.394e-03, 1.290e-02 };
	r = MulAdd(s0_0, M4(2.358e-02, 7.106e-02, -1.223e-01, -1.570e-01, -4.561e-02, 2.621e-02, -6.238e-02, -2.642e-02, -1.613e-01, -1.018e-01, -1.182e-01, 9.290e-02, 1.166e-01, -4.284e-02, 3.173e-02, 6.253e-02), r);
	r = MulAdd(s0_1, M4(-1.356e-01, -2.774e-01, 4.431e-02, -2.950e-01, -3.286e-02, -2.192e-01, 5.332e-02, -8.862e-02, -7.113e-02, 1.994e-01, -1.422e-01, 3.142e-01, 7.644e-02, -5.537e-02, -1.903e-01, 1.820e-01), r);
	r = MulAdd(s0_2, M4(-8.536e-02, 1.536e-01, 2.164e-02, -8.691e-02, -7.817e-02, 1.158e-01, 3.551e-02, 9.690e-02, -2.058e-01, -2.366e-01, -2.024e-01, 3.949e-02, 9.990e-02, -1.155e-01, -4.381e-02, 5.952e-02), r);
	r = MulAdd(s0_3, M4(4.764e-02, -2.284e-01, 2.608e-01, -3.773e-01, 6.969e-03, -1.371e-01, 3.378e-02, -1.982e-01, -1.499e-01, 1.022e-01, 2.773e-01, -1.993e-01, 1.287e-01, -1.990e-01, -1.213e-01, 4.326e-02), r);
	r = MulAdd(s0_4, M4(4.182e-01, -4.292e-01, 2.890e-01, -7.257e-02, 5.904e-02, 5.257e-01, 8.142e-02, 4.462e-01, -3.900e-01, -4.610e-02, -3.785e-01, 1.900e-01, 1.028e-01, -7.148e-02, -1.026e-01, 1.641e-01), r);
	r = MulAdd(s0_5, M4(-1.978e-02, 1.734e-01, -1.815e-01, -1.499e-01, 2.661e-03, -5.529e-02, -6.137e-02, -1.076e-02, -9.873e-02, 7.319e-02, -1.055e-01, -1.914e-02, 3.545e-01, -2.098e-01, 2.723e-02, -1.403e-02), r);
	r = MulAdd(s0_6, M4(2.502e-02, 4.622e-02, 1.371e-02, -5.810e-02, 6.768e-02, 6.884e-02, 7.794e-02, 4.459e-02, 1.565e-02, -5.750e-02, -1.899e-01, -3.387e-02, -7.821e-02, -3.829e-01, -2.889e-02, -6.215e-02), r);
	r = MulAdd(s0_7, M4(2.837e-01, 2.153e-01, 6.464e-01, -2.259e-02, 1.787e-01, 5.850e-02, -1.661e-01, 8.230e-02, -2.558e-03, -9.202e-02, -1.143e-01, 5.795e-02, 2.725e-01, -2.512e-01, -3.417e-01, 1.418e-01), r);
	r = MulAdd(s0_8, M4(-7.240e-02, 7.377e-02, 1.601e-02, -5.421e-02, 5.224e-02, 2.011e-02, 3.942e-02, -2.078e-02, 6.665e-02, 5.385e-02, -7.067e-02, -3.002e-02, 6.076e-01, -1.559e-01, -1.351e-01, 3.973e-02), r);
	r = MulAdd(s1_0, M4(5.739e-02, -2.130e-02, 6.867e-02, 8.138e-02, -8.371e-02, 7.208e-02, 9.522e-02, -1.247e-02, 3.673e-02, -1.020e-01, -1.157e-01, -4.893e-02, 4.489e-02, 6.052e-03, -1.856e-02, 1.512e-02), r);
	r = MulAdd(s1_1, M4(-8.925e-02, -1.358e-02, -4.710e-02, -5.965e-02, -1.423e-01, -1.121e-01, 3.344e-01, -2.959e-01, 8.419e-02, -1.992e-01, -1.728e-01, 1.496e-01, 7.465e-02, -6.513e-02, -1.158e-01, 4.417e-02), r);
	r = MulAdd(s1_2, M4(-1.561e-02, 1.173e-01, 6.393e-02, 7.635e-02, -2.358e-01, 4.513e-01, 1.043e-01, 5.412e-02, -1.062e-01, -2.702e-01, -1.967e-01, 2.292e-02, 4.481e-02, -6.181e-02, -7.755e-02, 1.785e-02), r);
	r = MulAdd(s1_3, M4(-1.536e-02, 1.336e-01, -1.401e-01, 1.672e-01, -3.804e-02, 1.629e-01, 3.546e-02, -2.329e-01, -1.882e-01, -6.580e-02, 6.342e-02, -2.430e-01, -4.527e-02, 3.083e-02, -1.829e-02, 5.247e-02), r);
	r = MulAdd(s1_4, M4(-2.110e-01, 9.668e-02, -5.724e-02, 2.095e-01, -2.346e-01, 8.267e-01, -2.799e-01, 3.349e-01, -1.565e-01, 6.647e-02, 1.817e-02, 1.019e-01, 3.862e-02, -1.680e-01, 1.549e-01, 7.007e-02), r);
	r = MulAdd(s1_5, M4(-1.472e-01, 2.887e-02, -9.785e-02, 1.098e-01, 3.725e-02, 4.719e-01, 1.409e-01, -1.149e-01, -1.343e-01, 4.555e-03, -7.537e-02, -6.092e-02, 7.429e-02, 1.599e-01, -7.409e-02, 1.111e-01), r);
	r = MulAdd(s1_6, M4(5.192e-02, 5.279e-02, 5.139e-02, 5.538e-03, 3.032e-02, 1.416e-01, -1.027e-01, -1.048e-01, -1.343e-01, -2.519e-02, 9.241e-02, -3.552e-02, -3.274e-02, -1.035e-01, -2.752e-02, -3.711e-02), r);
	r = MulAdd(s1_7, M4(1.405e-01, 1.283e-01, -1.631e-01, 1.448e-01, -1.476e-01, 3.194e-01, 4.787e-02, 8.664e-02, -2.308e-02, -2.718e-02, 2.198e-01, 5.863e-02, 5.409e-02, -1.074e-01, -3.430e-01, 7.548e-02), r);
	r = MulAdd(s1_8, M4(6.984e-02, 8.299e-02, -1.025e-02, 1.410e-02, -3.269e-01, 1.130e-01, -4.935e-02, -7.883e-02, 2.730e-02, 2.576e-02, 9.849e-02, -8.321e-03, 1.082e-01, 7.446e-02, -4.441e-02, 9.677e-03), r);
	r = MulAdd(s2_0, M4(-3.258e-02, -1.473e-03, 1.278e-01, -6.312e-04, 9.059e-04, -1.729e-02, 8.754e-03, -7.737e-02, -5.027e-02, 8.639e-02, -1.170e-02, 7.257e-02, 8.412e-02, 2.112e-02, -2.565e-01, 7.677e-03), r);
	r = MulAdd(s2_1, M4(-7.643e-04, -2.024e-02, 1.767e-01, -7.645e-03, 6.422e-02, 2.239e-01, 1.450e-02, 1.947e-01, -1.279e-02, -1.349e-02, -1.409e-01, -1.273e-01, -9.158e-02, -1.500e-01, 7.653e-02, 2.805e-01), r);
	r = MulAdd(s2_2, M4(3.071e-02, 2.711e-02, 6.236e-02, 1.223e-02, 2.077e-02, 1.323e-01, 5.334e-03, -5.884e-02, 6.902e-03, 5.473e-03, -3.114e-02, -2.389e-02, 3.126e-03, -7.234e-02, 4.478e-02, -1.808e-02), r);
	r = MulAdd(s2_3, M4(-5.518e-02, 1.332e-01, -2.462e-02, -1.615e-01, -3.965e-02, -2.004e-02, 1.268e-01, -1.470e-02, -1.397e-01, -6.340e-02, 9.022e-02, -1.625e-01, -1.426e-01, -3.068e-01, -3.755e-02, -1.816e-01), r);
	r = MulAdd(s2_4, M4(-2.434e-01, -3.850e-02, -2.343e-01, -1.456e-01, -3.490e-01, 1.238e-01, 4.962e-03, -6.624e-02, 2.030e-01, -1.929e-01, 1.951e-01, -3.391e-01, -9.956e-02, 2.692e-01, -3.039e-01, 1.984e-01), r);
	r = MulAdd(s2_5, M4(-2.289e-02, -9.088e-03, 1.582e-02, 6.333e-02, -4.110e-01, -2.279e-01, -4.103e-02, -4.303e-02, 1.533e-02, 1.511e-01, -6.972e-02, 1.555e-01, -1.127e-01, -1.785e-01, -5.199e-02, -1.169e-01), r);
	r = MulAdd(s2_6, M4(-5.538e-02, -2.687e-03, 7.738e-02, -3.888e-02, -6.798e-03, 5.840e-03, 9.394e-02, -9.093e-02, -2.274e-02, 5.489e-02, -1.046e-01, -9.950e-02, -1.291e-01, -3.497e-02, -1.789e-02, -2.169e-02), r);
	r = MulAdd(s2_7, M4(1.547e-01, -3.511e-02, 6.851e-03, 4.498e-02, -4.047e-02, 1.323e-01, 2.036e-01, -3.356e-02, 2.381e-02, -2.907e-02, -3.230e-01, -5.017e-02, 7.335e-02, 8.047e-02, 2.422e-01, -7.968e-03), r);
	r = MulAdd(s2_8, M4(1.402e-01, -1.278e-01, 4.702e-02, -2.929e-03, -2.774e-03, 4.017e-02, 1.142e-01, -5.435e-02, 5.163e-02, -4.898e-02, -1.112e-01, -1.679e-02, -1.153e-01, -1.449e-01, 3.081e-02, -1.046e-01), r);
	r = MulAdd(s3_0, M4(8.011e-02, -1.008e-01, -3.350e-02, -5.067e-02, 3.134e-02, 1.965e-02, -6.230e-02, 6.086e-02, 1.045e-01, 3.276e-02, -1.810e-01, 6.820e-02, -1.228e-01, -8.570e-02, 2.025e-01, -1.825e-01), r);
	r = MulAdd(s3_1, M4(1.911e-03, 2.398e-02, -6.180e-02, 8.361e-02, 1.777e-01, 9.055e-02, -2.063e-01, 1.300e-01, 8.911e-02, -1.316e-02, -1.055e-01, -1.246e-01, -3.907e-02, 1.910e-01, 1.273e-01, 1.199e-01), r);
	r = MulAdd(s3_2, M4(1.061e-01, 3.932e-02, 1.409e-02, 1.843e-02, 1.023e-01, -1.627e-01, -7.256e-02, 1.090e-02, 5.967e-02, 5.053e-02, -5.669e-02, -3.334e-02, 5.388e-02, 9.133e-02, 8.598e-02, -9.190e-02), r);
	r = MulAdd(s3_3, M4(1.566e-02, -8.323e-03, -2.284e-01, -1.353e-01, -1.207e-01, 2.292e-02, 1.171e-01, 9.358e-02, -4.992e-02, -4.395e-02, 1.335e-01, -1.698e-01, 5.811e-02, -1.714e-01, -1.425e-02, -2.387e-01), r);
	r = MulAdd(s3_4, M4(-5.546e-01, 2.770e-01, -2.630e-01, -2.027e-01, -5.485e-02, -1.584e-01, 4.579e-01, -7.056e-02, -2.309e-01, 1.690e-01, -1.575e-01, -3.097e-01, 1.883e-01, -9.219e-03, -2.047e-01, -3.564e-01), r);
	r = MulAdd(s3_5, M4(5.198e-03, 1.196e-01, -8.158e-02, -4.777e-02, -2.359e-01, -3.586e-01, 2.130e-01, 2.051e-01, 1.191e-03, 7.352e-02, -2.873e-02, 8.438e-02, 9.639e-02, -2.764e-01, -3.439e-02, -1.704e-01), r);
	r = MulAdd(s3_6, M4(-9.012e-02, 9.280e-02, 8.295e-02, 8.577e-03, -3.140e-03, 1.152e-02, 5.301e-02, -5.006e-03, -5.893e-03, 3.360e-02, 3.761e-02, -3.912e-02, -8.357e-02, 8.906e-03, 2.089e-02, 1.899e-02), r);
	r = MulAdd(s3_7, M4(1.114e-03, 3.887e-02, -4.030e-02, -3.748e-02, 3.333e-02, -5.122e-02, -2.400e-01, -2.969e-03, 2.300e-02, -1.357e-01, -2.767e-01, -1.186e-02, -1.660e-01, 8.940e-02, 3.164e-01, -5.897e-02), r);
	r = MulAdd(s3_8, M4(3.387e-02, -8.658e-02, -3.218e-02, -4.372e-02, -1.515e-01, 5.072e-02, -1.683e-01, 4.557e-02, 1.132e-01, -6.613e-03, -1.422e-01, 1.617e-02, -1.129e-01, -1.111e-01, 3.890e-02, -6.358e-02), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -6.316e-03, -5.988e-03, -9.405e-03, -2.136e-03 };
	r = MulAdd(s0_0, M4(3.519e-02, 4.799e-02, -2.984e-03, -1.240e-01, -6.249e-03, 2.523e-02, 1.077e-01, 4.787e-02, 2.420e-02, 7.819e-02, -1.956e-01, -7.709e-02, -5.882e-02, -3.366e-02, -1.714e-01, 1.200e-01), r);
	r = MulAdd(s0_1, M4(-2.273e-01, 8.166e-02, 8.317e-02, 8.376e-02, -5.856e-02, 4.123e-03, -2.466e-01, -3.422e-02, -5.165e-02, 6.070e-02, 7.922e-02, -9.691e-02, 2.510e-01, -1.318e-02, -1.696e-01, 1.123e-01), r);
	r = MulAdd(s0_2, M4(2.300e-01, -4.649e-02, -9.124e-02, -9.431e-02, 1.141e-01, -4.892e-03, 3.389e-02, -7.123e-02, -5.376e-02, 3.972e-02, 1.306e-01, 9.184e-02, 3.181e-02, -1.301e-02, 6.289e-02, -2.389e-02), r);
	r = MulAdd(s0_3, M4(-3.802e-01, -2.023e-01, -2.227e-01, -9.450e-02, 2.842e-02, -1.421e-01, -1.397e-01, -9.477e-02, 8.360e-02, 5.211e-02, -4.870e-02, -2.897e-01, 3.206e-03, -1.743e-01, -3.055e-01, -4.716e-02), r);
	r = MulAdd(s0_4, M4(3.208e-01, -4.644e-01, 8.642e-01, 7.726e-01, 2.570e-01, -3.573e-02, 5.571e-02, 4.619e-01, 1.200e-01, -1.772e-01, 1.733e-01, 3.480e-02, 1.119e-01, 7.200e-02, 5.641e-02, -1.770e-01), r);
	r = MulAdd(s0_5, M4(-5.690e-01, 1.045e-02, 5.379e-01, -2.482e-01, -2.435e-01, 1.075e-02, -3.207e-02, 1.476e-01, 2.284e-02, 8.934e-02, 3.712e-02, 5.994e-02, -1.533e-01, -5.881e-02, 5.651e-02, -1.526e-02), r);
	r = MulAdd(s0_6, M4(2.499e-02, 9.467e-03, 5.746e-02, -8.387e-02, -5.405e-02, -1.732e-02, 7.648e-02, 2.696e-02, -1.241e-01, 2.151e-02, -6.329e-02, -7.248e-02, -1.591e-01, -2.487e-02, -1.833e-01, 2.593e-03), r);
	r = MulAdd(s0_7, M4(-2.208e-01, -3.703e-01, 2.619e-01, 5.898e-02, -1.777e-01, -7.585e-02, 6.970e-02, 4.988e-02, -4.151e-02, -7.482e-03, -1.184e-03, -1.444e-03, -1.106e-01, -1.452e-01, 2.712e-01, -5.314e-02), r);
	r = MulAdd(s0_8, M4(3.481e-02, -3.760e-02, -1.266e-01, 2.756e-02, -1.371e-02, 5.496e-02, -1.166e-01, 4.062e-02, 6.351e-02, 2.666e-02, -1.949e-02, 4.756e-02, 3.367e-01, -3.686e-01, -2.675e-01, 1.228e-01), r);
	r = MulAdd(s1_0, M4(2.598e-03, -6.811e-02, 4.981e-02, -1.319e-02, 1.206e-01, 2.461e-02, -3.766e-02, 2.058e-02, 8.023e-02, -1.693e-02, 3.585e-02, -9.837e-02, 8.781e-03, -1.964e-02, -4.176e-03, -4.753e-03), r);
	r = MulAdd(s1_1, M4(1.442e-01, -8.370e-03, -7.432e-02, -3.089e-02, -1.981e-01, -4.136e-02, -1.909e-01, -1.179e-01, -1.917e-01, 9.283e-03, -6.196e-03, 7.644e-02, -3.266e-02, 2.654e-03, -3.667e-02, -3.045e-03), r);
	r = MulAdd(s1_2, M4(1.606e-01, -5.138e-02, -6.107e-02, -9.435e-02, 1.106e-01, 3.374e-02, 4.798e-02, -1.686e-01, -9.666e-02, 1.708e-01, 1.023e-01, 8.971e-02, -4.152e-03, 3.151e-02, -8.008e-02, -8.659e-04), r);
	r = MulAdd(s1_3, M4(2.334e-01, 1.165e-01, 1.431e-01, -6.154e-02, 2.323e-01, 5.190e-02, -3.558e-01, 5.900e-03, -1.352e-01, -6.950e-02, -1.556e-01, -8.683e-02, 2.186e-03, -3.382e-02, 9.595e-02, -1.367e-02), r);
	r = MulAdd(s1_4, M4(-2.079e-01, 2.013e-01, -1.003e-01, 5.965e-01, 7.281e-01, -2.555e-02, -1.042e-01, 5.471e-01, -8.816e-03, -6.272e-01, 2.632e-01, -7.918e-03, -9.514e-02, -1.219e-01, -1.023e-01, -9.444e-02), r);
	r = MulAdd(s1_5, M4(-2.075e-01, -2.995e-02, -3.489e-02, 1.102e-01, -2.727e-01, -5.656e-02, 1.026e-01, -2.174e-01, 5.193e-02, 9.603e-03, -8.547e-02, 2.008e-01, 3.839e-02, 2.151e-02, -2.244e-02, 7.860e-03), r);
	r = MulAdd(s1_6, M4(-2.778e-01, -3.516e-02, 1.650e-01, -7.376e-02, -8.045e-02, -9.546e-02, -3.107e-02, -6.217e-02, 1.269e-01, 1.594e-01, 4.540e-03, 3.225e-03, -4.082e-02, 6.364e-03, -6.184e-02, 3.507e-02), r);
	r = MulAdd(s1_7, M4(-1.143e-01, 1.010e-01, -5.168e-02, 1.587e-01, -1.409e-01, -7.917e-03, -8.995e-02, 1.142e-01, -1.148e-01, -5.357e-02, 7.352e-02, -1.038e-01, 1.130e-02, -5.021e-02, 7.683e-02, -4.051e-02), r);
	r = MulAdd(s1_8, M4(3.006e-02, 1.525e-01, -1.064e-01, 9.476e-02, -1.579e-01, 1.593e-01, -1.578e-01, -1.912e-02, 5.637e-02, -9.418e-03, -5.185e-03, 4.674e-02, 1.222e-01, -7.692e-02, -7.098e-02, 2.074e-02), r);
	r = MulAdd(s2_0, M4(-1.652e-02, 2.598e-02, -1.013e-01, 6.189e-02, 8.546e-03, 4.699e-02, -2.344e-03, 1.277e-02, 5.113e-02, -1.595e-02, 1.910e-01, -7.417e-02, 3.643e-02, 4.172e-02, -1.039e-01, -6.160e-02), r);
	r = MulAdd(s2_1, M4(-3.874e-02, -3.482e-03, 7.300e-03, -1.355e-02, 2.448e-01, 4.666e-02, -9.449e-02, 2.339e-02, -1.203e-01, 3.261e-02, -3.038e-02, 9.335e-02, 4.708e-02, 9.716e-02, -4.104e-01, 1.606e-02), r);
	r = MulAdd(s2_2, M4(2.614e-02, -7.252e-02, 9.566e-03, 3.402e-02, 6.985e-03, -2.278e-02, -1.924e-01, 5.004e-03, -2.337e-02, 3.580e-02, -4.597e-02, 2.932e-02, -1.673e-01, -8.288e-03, 2.899e-02, 3.634e-02), r);
	r = MulAdd(s2_3, M4(3.155e-01, 9.085e-02, 4.781e-02, -6.959e-02, 3.001e-02, -2.332e-02, -1.132e-01, 1.024e-01, 4.363e-02, -4.525e-02, 6.052e-02, -2.970e-01, -2.196e-01, 2.141e-02, -3.035e-01, 9.429e-02), r);
	r = MulAdd(s2_4, M4(-6.346e-02, 2.127e-01, -4.391e-02, 2.319e-01, -2.695e-01, -7.714e-03, -1.659e-01, -3.199e-01, 1.499e-01, -3.990e-01, 3.229e-02, -4.619e-01, 1.185e-01, 4.742e-02, 7.026e-01, -5.809e-02), r);
	r = MulAdd(s2_5, M4(-7.044e-02, 8.127e-02, 2.569e-01, -8.552e-02, -1.192e-01, 9.709e-02, -3.134e-01, 1.632e-01, 2.647e-01, -5.529e-02, 2.336e-01, -1.118e-01, 4.060e-02, 5.644e-02, -7.560e-02, 1.106e-01), r);
	r = MulAdd(s2_6, M4(-7.387e-02, -2.698e-03, -5.179e-02, 1.077e-03, -1.361e-01, -6.428e-02, -5.398e-02, -5.008e-03, -1.555e-01, 8.817e-02, 2.712e-02, -1.140e-01, 1.123e-01, 2.629e-01, 8.762e-04, 1.070e-01), r);
	r = MulAdd(s2_7, M4(4.489e-02, 1.490e-01, 1.403e-01, 5.900e-02, -1.535e-02, 9.715e-02, -1.662e-01, 1.544e-02, -2.607e-01, 1.782e-01, 5.149e-02, -1.530e-01, 4.158e-02, -1.167e-01, 2.508e-01, -3.826e-02), r);
	r = MulAdd(s2_8, M4(1.833e-02, -6.535e-02, -9.799e-04, 3.795e-02, -1.240e-01, 5.356e-02, -1.377e-01, 2.680e-02, -5.193e-02, 1.129e-01, -6.200e-02, 3.753e-02, -1.182e-01, -8.965e-02, -4.491e-02, 2.043e-02), r);
	r = MulAdd(s3_0, M4(-1.485e-01, -4.827e-02, -6.587e-02, 4.206e-03, 1.429e-03, -7.075e-02, 1.010e-01, -1.434e-02, 1.431e-01, 9.461e-03, 1.974e-02, 6.288e-03, -1.066e-01, 3.071e-02, -5.972e-02, 6.134e-02), r);
	r = MulAdd(s3_1, M4(1.832e-01, 9.780e-02, 6.492e-03, 7.153e-02, 4.468e-02, 4.766e-02, -2.764e-02, 1.125e-01, -6.547e-02, 4.916e-02, -2.809e-01, 2.147e-02, -4.627e-05, -1.787e-02, 1.779e-01, -7.133e-02), r);
	r = MulAdd(s3_2, M4(9.684e-02, -1.149e-01, -7.433e-02, -3.439e-02, -9.873e-02, 6.903e-02, -5.451e-02, 1.204e-01, 2.747e-03, 6.107e-02, -1.211e-02, 1.021e-02, -1.020e-01, -2.111e-02, -3.111e-02, 7.253e-02), r);
	r = MulAdd(s3_3, M4(8.451e-02, 1.777e-01, -6.733e-02, -3.111e-02, 5.124e-02, 6.421e-02, 2.028e-01, 3.174e-03, 5.908e-02, 3.863e-02, -1.465e-02, -3.614e-02, -2.398e-01, -1.425e-01, -1.372e-01, -5.310e-02), r);
	r = MulAdd(s3_4, M4(-4.740e-02, 3.190e-01, -3.018e-01, 2.133e-01, -6.713e-02, -1.594e-01, -2.779e-01, -2.978e-01, 2.122e-01, -1.166e-01, -4.420e-01, -3.385e-01, -1.828e-01, -2.161e-01, 2.861e-01, 4.141e-02), r);
	r = MulAdd(s3_5, M4(-1.008e-01, 1.219e-01, 1.655e-01, -7.892e-02, 1.575e-01, -1.729e-01, -3.729e-01, 2.347e-01, 1.649e-01, -8.625e-02, 1.831e-01, -1.423e-01, -2.275e-03, 1.461e-01, -6.245e-02, -9.654e-02), r);
	r = MulAdd(s3_6, M4(4.563e-02, 1.920e-01, 1.096e-01, 1.130e-02, -4.992e-02, -2.560e-02, 9.352e-02, 4.260e-02, -1.082e-01, -1.228e-02, 4.508e-02, -5.029e-02, 2.940e-01, 7.883e-02, -1.268e-01, 9.003e-02), r);
	r = MulAdd(s3_7, M4(-1.140e-01, 2.337e-01, 6.229e-02, 3.967e-02, -1.837e-02, 1.296e-01, -1.911e-01, -4.436e-02, -5.754e-02, 2.124e-01, -2.095e-02, -3.752e-02, 1.007e-01, -1.105e-01, 2.174e-01, 1.540e-02), r);
	r = MulAdd(s3_8, M4(-5.357e-02, -1.439e-02, 7.558e-02, -2.317e-02, -1.318e-01, 2.876e-01, -1.304e-01, 6.115e-02, 5.664e-03, -1.197e-03, 3.258e-02, 2.902e-02, -5.115e-02, -1.880e-01, -2.181e-02, -9.175e-02), r);
	return r;
}

void Pass5(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 6
//!DESC conv5
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -5.867e-03, 8.204e-04, 8.838e-06, -4.451e-03 };
	r = MulAdd(s0_0, M4(-8.608e-02, 2.569e-01, 1.222e-02, -2.428e-01, 2.819e-02, -2.222e-01, 8.316e-02, 1.236e-01, 7.319e-02, -2.436e-02, -3.285e-02, -4.959e-02, -1.564e-02, -4.520e-03, -2.403e-02, 1.644e-02), r);
	r = MulAdd(s0_1, M4(8.699e-02, -1.096e-01, 1.068e-01, -3.740e-01, -1.080e-01, -1.857e-02, 4.223e-02, -3.891e-03, -8.229e-02, -1.946e-01, -1.551e-03, -1.387e-01, -5.238e-02, 2.071e-02, 2.358e-02, 5.090e-02), r);
	r = MulAdd(s0_2, M4(9.500e-02, 1.498e-02, 3.952e-02, -2.201e-01, -5.773e-03, -4.568e-02, -1.513e-02, 1.650e-02, -3.844e-02, -1.894e-02, -6.321e-03, -1.478e-01, 6.779e-04, -1.872e-02, 3.647e-02, -1.142e-01), r);
	r = MulAdd(s0_3, M4(1.158e-01, 1.180e-01, -7.400e-02, -1.253e-01, -3.329e-02, -9.601e-02, -1.655e-01, 1.764e-01, 4.556e-02, -1.037e-01, 1.404e-02, 4.284e-02, 1.355e-02, -4.159e-02, 1.028e-02, 5.967e-02), r);
	r = MulAdd(s0_4, M4(3.790e-01, -1.771e-01, 4.289e-01, 3.968e-01, -6.453e-01, -3.229e-02, 6.839e-02, 4.000e-01, 7.875e-02, 3.322e-01, -9.510e-02, 6.532e-02, -2.647e-01, -1.873e-01, 1.182e-01, 1.928e-01), r);
	r = MulAdd(s0_5, M4(1.861e-02, 4.475e-02, -4.634e-02, 4.190e-02, 7.957e-02, -1.773e-01, 7.434e-02, -3.605e-02, -1.383e-02, 3.314e-02, 7.457e-02, -3.542e-02, -1.410e-01, 1.218e-02, -1.978e-01, 1.382e-01), r);
	r = MulAdd(s0_6, M4(-1.159e-02, 7.661e-02, -1.156e-02, 4.680e-02, 5.359e-02, -1.324e-01, -1.436e-01, -9.472e-02, -7.470e-02, -1.685e-01, 4.434e-03, -2.265e-02, -1.045e-01, 1.346e-02, -4.403e-02, 2.895e-02), r);
	r = MulAdd(s0_7, M4(-8.194e-02, 2.863e-03, 2.583e-02, -6.814e-02, 4.180e-02, 1.948e-02, -5.094e-02, -8.335e-02, 1.078e-02, -9.731e-02, -7.838e-02, -7.272e-02, -3.306e-03, 8.672e-02, -1.243e-01, -1.003e-01), r);
	r = MulAdd(s0_8, M4(-7.363e-02, 1.894e-02, -4.111e-02, 9.806e-03, 4.223e-02, -5.568e-02, 7.757e-02, 5.330e-02, 2.111e-02, -3.335e-02, 7.667e-03, -2.582e-02, 1.289e-01, -5.085e-02, 1.158e-01, 3.725e-02), r);
	r = MulAdd(s1_0, M4(1.335e-02, 1.003e-01, 6.199e-02, 3.112e-03, -8.718e-02, 2.489e-02, -2.486e-02, 1.969e-01, 6.352e-02, -2.251e-01, 9.885e-03, -1.690e-01, 3.148e-02, -2.993e-02, -1.857e-03, -1.052e-01), r);
	r = MulAdd(s1_1, M4(-8.664e-03, -1.227e-01, -2.031e-02, -2.300e-01, 5.105e-02, 1.422e-02, 1.043e-01, -4.809e-02, -1.366e-01, 1.288e-01, -3.921e-01, -1.088e-01, -5.613e-03, 7.480e-02, 6.498e-02, 2.244e-02), r);
	r = MulAdd(s1_2, M4(1.231e-01, 4.020e-02, 4.395e-03, -1.853e-01, 4.126e-02, 3.574e-02, 3.323e-04, -9.040e-02, -2.706e-01, 5.809e-02, -2.337e-01, -3.410e-02, 6.976e-03, -6.686e-02, 1.172e-01, -5.432e-02), r);
	r = MulAdd(s1_3, M4(-2.134e-01, -1.519e-01, 2.647e-02, -8.512e-02, -1.382e-01, 1.372e-01, -2.530e-02, -4.801e-02, 7.539e-02, -8.842e-02, -5.976e-02, 1.708e-01, 2.436e-01, -1.239e-01, 9.767e-02, 2.307e-02), r);
	r = MulAdd(s1_4, M4(-2.123e-01, 2.003e-02, 2.607e-01, 5.098e-01, 2.415e-01, -4.337e-01, 2.104e-01, 4.542e-02, -5.372e-01, 4.096e-01, -1.995e-01, 1.650e-01, -4.643e-01, 4.214e-01, -2.897e-01, 3.722e-01), r);
	r = MulAdd(s1_5, M4(4.852e-02, -4.823e-02, -9.304e-03, 6.935e-02, 3.634e-02, 4.152e-02, -2.441e-04, 8.184e-02, -3.163e-01, -1.569e-01, -1.265e-01, 2.367e-01, -2.178e-01, 1.617e-02, -3.774e-01, 5.316e-02), r);
	r = MulAdd(s1_6, M4(-6.727e-03, 1.153e-01, 1.338e-02, 1.193e-01, 1.504e-01, 1.519e-01, 9.715e-03, 9.078e-03, -8.618e-02, -1.465e-01, -2.277e-02, -4.322e-03, -2.011e-01, -1.293e-01, 1.793e-02, 2.710e-03), r);
	r = MulAdd(s1_7, M4(-9.969e-03, 2.211e-01, -4.299e-03, -2.202e-02, -4.619e-02, -8.966e-04, 9.219e-02, 1.181e-01, -4.056e-01, -1.222e-01, -3.333e-01, -2.313e-01, -5.614e-02, -1.141e-01, -1.407e-01, -1.764e-01), r);
	r = MulAdd(s1_8, M4(-9.313e-04, 1.319e-02, 7.414e-02, 6.145e-02, -6.932e-02, 3.310e-02, -6.980e-02, -2.850e-02, -1.856e-01, -1.571e-01, -1.655e-01, -1.211e-01, 4.781e-02, -1.536e-01, 1.794e-01, 6.533e-03), r);
	r = MulAdd(s2_0, M4(2.814e-02, 6.999e-02, 1.721e-02, -6.695e-02, 7.155e-02, 1.598e-01, 4.115e-02, -2.464e-02, -6.175e-03, 5.353e-02, -4.210e-02, -6.383e-02, -5.254e-02, 3.658e-02, -6.324e-02, 4.018e-02), r);
	r = MulAdd(s2_1, M4(-7.643e-02, -8.591e-02, -1.327e-01, 1.490e-01, -4.778e-02, -1.665e-03, 3.515e-02, 4.224e-02, 2.654e-02, -3.990e-03, 1.914e-02, -3.699e-02, -1.815e-01, 6.398e-02, -9.678e-02, -1.639e-01), r);
	r = MulAdd(s2_2, M4(3.666e-02, 1.137e-02, -3.516e-03, -1.270e-01, -5.116e-02, -3.455e-02, -1.130e-02, -2.826e-02, -2.717e-02, 1.390e-02, 1.004e-02, 6.270e-02, 5.819e-03, 4.421e-02, 4.943e-02, -2.765e-01), r);
	r = MulAdd(s2_3, M4(-1.111e-01, 2.642e-03, 2.653e-02, -1.920e-02, 1.284e-01, 6.685e-02, -6.475e-02, -2.750e-02, -8.811e-02, -3.021e-01, 1.387e-01, -8.707e-02, -9.734e-02, 3.683e-01, -6.483e-02, 1.673e-02), r);
	r = MulAdd(s2_4, M4(-8.755e-02, -2.692e-01, -1.860e-01, 8.398e-02, -2.588e-01, 5.441e-01, -1.563e-02, 2.783e-02, 7.085e-02, 1.881e-01, 4.063e-02, -1.307e-01, 3.826e-01, 3.605e-02, 1.551e-01, -3.976e-02), r);
	r = MulAdd(s2_5, M4(1.761e-01, 9.465e-02, 1.023e-01, 1.684e-01, 5.145e-02, -9.373e-02, 1.927e-01, -2.001e-01, -8.632e-02, 7.821e-02, 3.875e-02, -3.849e-03, -9.294e-02, 1.570e-01, -9.343e-02, 1.712e-02), r);
	r = MulAdd(s2_6, M4(-6.383e-02, -5.647e-03, -2.071e-02, 3.716e-02, 7.636e-02, 2.504e-02, 4.806e-02, -1.517e-02, 8.862e-02, 8.993e-02, 2.257e-02, -1.228e-02, 1.534e-01, -1.728e-02, -3.967e-02, -3.449e-02), r);
	r = MulAdd(s2_7, M4(-2.106e-01, -1.526e-01, 6.760e-02, -1.012e-02, 2.699e-02, 3.012e-03, -3.014e-02, -1.204e-02, -7.079e-03, -1.713e-01, 3.694e-02, 6.143e-02, -5.451e-02, -1.359e-01, -9.926e-02, -1.442e-01), r);
	r = MulAdd(s2_8, M4(-9.338e-02, 1.171e-01, 9.731e-03, 7.911e-02, 2.203e-02, 5.235e-03, 3.585e-03, -2.420e-02, -3.234e-02, 1.790e-02, -6.909e-02, -2.004e-02, -1.564e-01, 1.182e-01, -1.297e-01, -5.639e-03), r);
	r = MulAdd(s3_0, M4(-3.005e-02, -6.725e-02, 1.321e-02, 4.847e-03, 1.036e-01, 2.312e-01, -1.014e-01, -1.152e-01, 9.548e-02, -1.285e-01, 2.631e-02, 1.150e-01, -7.107e-02, -1.159e-01, -8.623e-02, 3.015e-03), r);
	r = MulAdd(s3_1, M4(-1.199e-01, 1.896e-02, -1.750e-01, 5.793e-02, -1.067e-01, 3.761e-01, 4.887e-02, -3.395e-01, 6.265e-02, 3.455e-02, 5.806e-02, 1.456e-01, -6.617e-02, -1.070e-01, 2.967e-03, 8.557e-03), r);
	r = MulAdd(s3_2, M4(-1.013e-01, -1.106e-02, -3.594e-02, 2.021e-02, 4.372e-02, -1.061e-01, 2.014e-02, -1.715e-01, -4.093e-02, -2.106e-02, -6.451e-02, 1.431e-01, 5.745e-02, -8.813e-03, 1.078e-02, -1.050e-01), r);
	r = MulAdd(s3_3, M4(5.771e-03, 2.398e-01, 5.475e-03, -2.666e-02, 2.469e-01, 2.725e-01, -1.278e-01, 5.428e-02, -9.521e-02, -2.876e-01, 8.087e-02, -8.050e-02, -8.112e-02, -3.085e-02, -4.978e-02, 3.844e-02), r);
	r = MulAdd(s3_4, M4(-2.283e-01, 1.275e-01, -1.267e-01, -1.878e-02, 8.566e-02, 7.676e-01, 4.032e-02, 5.152e-01, -3.872e-02, 5.059e-01, 2.330e-01, 1.399e-02, 5.226e-01, 3.846e-02, 5.762e-01, -1.439e-01), r);
	r = MulAdd(s3_5, M4(-6.461e-04, 2.103e-01, 1.016e-01, 1.416e-01, 1.046e-01, 3.651e-03, 8.893e-02, -8.801e-02, 7.038e-02, -7.385e-02, 1.304e-01, -3.234e-02, -3.917e-02, -4.112e-02, 3.192e-02, -1.320e-01), r);
	r = MulAdd(s3_6, M4(-5.442e-02, 1.120e-01, 1.744e-02, -4.865e-02, -1.390e-01, -2.964e-01, -7.290e-02, -1.213e-01, 9.644e-02, -8.644e-02, 4.706e-02, -1.755e-02, 6.284e-03, -7.466e-02, 5.034e-02, -1.122e-01), r);
	r = MulAdd(s3_7, M4(-1.130e-01, -7.809e-02, 6.065e-03, 2.930e-03, -1.685e-01, -6.866e-02, -1.093e-01, -1.189e-01, 5.726e-02, -1.833e-01, 1.726e-02, -3.833e-02, -1.400e-01, -3.362e-01, 3.635e-02, -3.936e-02), r);
	r = MulAdd(s3_8, M4(-1.190e-01, 7.088e-02, -6.045e-02, -6.491e-02, -8.954e-02, -7.689e-02, -6.903e-02, -1.069e-01, 6.519e-02, -7.405e-02, -6.924e-03, -4.911e-02, -3.081e-02, 6.495e-03, -9.590e-02, 6.956e-02), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -1.543e-03, -4.932e-03, 6.376e-03, 2.635e-03 };
	r = MulAdd(s0_0, M4(-1.613e-01, -4.226e-02, -1.004e-01, 2.744e-02, -5.920e-02, 2.726e-02, 5.529e-02, 1.777e-02, -2.057e-01, -4.471e-02, 4.853e-03, 1.897e-02, 6.077e-02, -8.693e-02, 2.211e-02, 2.221e-02), r);
	r = MulAdd(s0_1, M4(-1.790e-02, -5.945e-02, 2.220e-01, 2.415e-02, -1.960e-02, 4.714e-02, -1.908e-01, 4.480e-02, 2.509e-01, -1.789e-02, 1.996e-01, -5.241e-02, -6.129e-02, 2.228e-02, -9.568e-03, 5.522e-02), r);
	r = MulAdd(s0_2, M4(6.855e-02, -1.714e-01, 3.252e-03, -7.609e-02, -6.607e-03, -1.250e-01, -3.310e-02, 1.991e-02, -3.235e-02, -3.547e-02, -6.805e-03, 5.213e-02, 1.799e-03, -9.400e-02, -4.560e-02, -4.234e-02), r);
	r = MulAdd(s0_3, M4(-3.910e-01, -1.046e-01, 2.434e-01, 7.156e-02, 5.429e-02, -6.191e-02, -1.441e-01, 2.060e-01, -1.385e-01, 1.037e-01, -4.380e-02, -8.286e-02, 1.389e-01, -1.694e-02, -6.093e-02, -5.890e-02), r);
	r = MulAdd(s0_4, M4(-2.968e-02, -1.900e-01, -1.226e-01, -9.187e-02, -4.346e-01, 6.699e-01, 2.262e-01, 4.149e-01, -3.449e-01, -1.810e-01, 4.280e-02, 1.218e-01, 6.111e-02, -1.049e-01, 1.369e-01, 6.181e-02), r);
	r = MulAdd(s0_5, M4(-9.205e-03, 4.332e-02, -1.318e-01, 7.155e-02, 1.343e-01, -9.519e-02, 1.417e-01, 1.615e-01, -1.237e-02, 1.310e-01, 6.284e-02, 4.459e-02, -8.180e-02, -2.356e-01, -7.968e-02, -1.569e-01), r);
	r = MulAdd(s0_6, M4(1.620e-02, -5.617e-02, -5.471e-02, -1.506e-02, -1.750e-02, 2.921e-02, 2.788e-02, -3.191e-02, 6.364e-02, 3.667e-02, -4.515e-02, -2.747e-02, -4.842e-02, 2.758e-02, -9.440e-02, -2.075e-02), r);
	r = MulAdd(s0_7, M4(8.817e-02, -5.475e-02, -2.476e-02, 5.598e-03, -3.989e-02, -7.869e-02, 2.001e-01, 3.282e-02, -2.619e-02, -8.282e-03, 1.138e-01, 4.952e-02, -4.746e-02, 9.597e-02, 1.639e-01, 9.382e-02), r);
	r = MulAdd(s0_8, M4(-1.727e-02, -3.994e-02, 5.955e-03, 1.735e-02, 3.433e-02, 2.114e-01, 3.957e-02, -3.448e-03, 4.624e-02, 4.745e-02, 3.676e-02, 2.724e-02, 3.361e-02, -2.538e-03, 2.072e-02, -4.143e-02), r);
	r = MulAdd(s1_0, M4(6.291e-02, 3.066e-02, -1.528e-01, -1.213e-01, -1.881e-01, 1.398e-01, 1.107e-02, 2.913e-02, -4.372e-02, -1.707e-01, -1.233e-01, 1.214e-02, -5.108e-02, -8.090e-02, 2.695e-03, -4.899e-03), r);
	r = MulAdd(s1_1, M4(-1.290e-01, -3.723e-02, 5.548e-02, -5.796e-02, 7.544e-02, 2.218e-02, 7.075e-02, 8.778e-03, 1.830e-01, -1.635e-01, -1.380e-02, 1.337e-01, -1.343e-01, -7.167e-02, 8.180e-02, 3.701e-02), r);
	r = MulAdd(s1_2, M4(3.819e-02, -2.796e-01, 7.484e-02, -6.969e-02, 3.958e-03, -3.990e-02, -4.936e-03, -1.871e-02, -8.227e-02, -2.647e-01, -5.353e-02, 2.802e-01, 5.236e-02, -1.095e-01, 3.037e-02, 1.371e-02), r);
	r = MulAdd(s1_3, M4(-7.472e-02, 7.277e-02, -9.259e-02, -5.970e-02, 1.904e-01, -7.408e-02, 9.517e-03, 5.773e-02, -2.063e-01, 7.309e-02, -1.632e-01, 9.394e-02, 6.461e-02, -4.990e-02, -4.256e-02, -1.354e-01), r);
	r = MulAdd(s1_4, M4(-1.989e-02, -5.893e-02, -2.870e-01, 3.377e-02, -5.899e-02, -1.292e-01, 2.142e-01, 6.521e-02, -3.446e-01, 7.705e-02, -1.953e-01, 3.493e-01, 8.550e-01, -2.645e-01, -5.125e-02, 3.279e-01), r);
	r = MulAdd(s1_5, M4(-1.666e-02, 4.650e-03, -1.421e-01, 8.864e-02, 8.253e-03, -3.432e-02, -8.438e-02, -1.618e-02, -7.692e-02, 2.310e-01, 1.882e-01, 2.958e-01, -1.735e-01, -4.556e-01, -1.155e-01, -3.658e-01), r);
	r = MulAdd(s1_6, M4(-9.666e-02, 1.958e-02, -3.755e-02, 1.890e-02, -1.861e-01, -2.990e-02, 5.561e-02, -2.582e-02, 7.456e-02, 9.553e-02, -1.765e-01, -1.025e-01, -6.244e-02, 1.110e-01, -1.733e-01, -1.265e-01), r);
	r = MulAdd(s1_7, M4(-3.723e-03, -3.252e-02, -3.220e-02, 7.520e-02, 1.130e-01, 6.318e-02, -2.606e-01, -6.368e-02, 1.609e-01, 6.315e-02, -4.849e-02, 8.580e-02, -7.162e-02, -1.825e-01, 3.036e-01, 3.148e-02), r);
	r = MulAdd(s1_8, M4(-2.751e-02, -1.125e-02, -4.807e-02, -3.768e-02, -3.989e-02, -6.228e-02, -2.268e-02, -5.394e-03, 3.481e-02, -5.196e-03, 4.520e-02, 2.328e-01, -8.159e-03, -1.147e-01, 1.142e-01, 2.181e-02), r);
	r = MulAdd(s2_0, M4(-7.023e-03, -1.082e-01, -1.112e-01, 8.964e-03, 1.738e-02, 6.085e-03, 1.381e-01, -1.118e-01, -8.075e-03, -2.861e-02, 2.852e-02, 3.504e-02, 5.891e-02, 2.802e-02, -7.550e-02, 2.339e-02), r);
	r = MulAdd(s2_1, M4(-6.810e-04, 1.146e-01, -5.968e-03, -6.577e-02, 2.726e-01, 1.593e-01, 7.966e-02, 2.335e-02, -2.240e-02, -1.089e-01, -1.357e-02, -1.583e-02, 4.088e-02, -1.074e-01, -5.411e-02, 3.467e-01), r);
	r = MulAdd(s2_2, M4(5.432e-02, -8.088e-02, 4.341e-02, -1.622e-03, -1.120e-01, -1.209e-01, -9.585e-02, -2.620e-02, 9.254e-03, -1.146e-02, -1.566e-02, 3.510e-02, 8.974e-02, -1.070e-01, -3.833e-03, 8.178e-02), r);
	r = MulAdd(s2_3, M4(-4.635e-02, -1.177e-02, -1.033e-01, 1.648e-02, -1.173e-01, 6.739e-02, 1.362e-01, -6.356e-02, 2.983e-02, 2.365e-02, -5.309e-02, -3.019e-02, 8.626e-02, 3.954e-02, 1.349e-01, 1.739e-01), r);
	r = MulAdd(s2_4, M4(-6.323e-02, -1.185e-02, 7.697e-02, 1.531e-01, 1.064e-02, -2.665e-01, 4.370e-01, -2.230e-02, 1.482e-02, 4.515e-02, -5.242e-02, 2.613e-02, 4.812e-01, -2.269e-02, 1.252e-02, 3.916e-01), r);
	r = MulAdd(s2_5, M4(8.870e-02, 2.979e-01, -1.148e-01, 3.591e-02, 8.996e-02, -1.399e-02, 4.609e-02, -7.584e-02, 1.080e-02, 1.990e-02, -1.944e-02, 2.932e-02, -9.051e-02, -2.288e-01, -3.643e-01, -1.566e-01), r);
	r = MulAdd(s2_6, M4(-4.092e-02, -1.432e-02, 5.140e-02, 7.572e-02, 8.516e-02, 4.077e-03, 2.068e-03, -5.832e-02, -6.287e-03, 2.525e-02, 2.263e-02, -4.400e-03, -4.119e-02, -6.518e-02, 1.449e-01, 3.534e-02), r);
	r = MulAdd(s2_7, M4(-2.346e-03, -1.100e-02, -1.841e-01, -4.504e-02, 4.907e-02, -5.487e-03, -1.495e-02, -1.159e-02, 6.396e-02, 1.176e-01, -1.291e-01, -1.254e-01, 2.271e-01, 4.009e-02, 7.242e-02, -1.274e-01), r);
	r = MulAdd(s2_8, M4(-4.918e-02, -1.015e-02, -5.141e-02, 4.864e-02, -1.127e-01, -6.540e-02, 1.881e-02, -8.765e-03, -2.301e-02, -3.138e-02, -2.005e-02, -9.395e-05, 1.087e-02, -7.551e-02, 1.812e-02, -5.127e-02), r);
	r = MulAdd(s3_0, M4(2.168e-01, -5.872e-02, -6.033e-02, 2.508e-03, -1.379e-01, -5.535e-02, 5.969e-02, 5.551e-02, 8.818e-02, 5.425e-02, 7.221e-02, -6.894e-02, -1.672e-02, 1.812e-02, -3.621e-02, 1.131e-02), r);
	r = MulAdd(s3_1, M4(4.283e-02, -1.942e-04, -1.753e-01, -1.483e-02, 5.554e-02, 4.928e-02, 9.082e-02, 4.843e-02, -6.584e-02, -1.871e-01, -9.180e-02, -8.086e-02, 7.754e-02, -1.453e-02, 1.538e-01, 1.044e-01), r);
	r = MulAdd(s3_2, M4(3.916e-02, 2.089e-02, -9.051e-02, 3.198e-02, -1.236e-02, -6.463e-02, 1.668e-01, 9.283e-02, 1.492e-02, 1.011e-01, 4.945e-02, 1.140e-01, 7.369e-02, -5.768e-02, 5.828e-02, 4.817e-02), r);
	r = MulAdd(s3_3, M4(-1.767e-02, 1.883e-02, -1.172e-01, -4.119e-02, -2.420e-01, -7.944e-02, 2.076e-01, 1.885e-01, -2.633e-02, 9.848e-02, -7.233e-02, -1.787e-01, 5.510e-02, -6.444e-02, 1.024e-01, 8.318e-02), r);
	r = MulAdd(s3_4, M4(-1.234e-02, 8.177e-02, -3.822e-02, 9.576e-02, -1.588e-01, 1.682e-01, -1.860e-01, -3.175e-02, -2.992e-01, -2.866e-02, 5.652e-02, -4.088e-02, 3.770e-01, -6.704e-02, 3.433e-01, 1.025e-01), r);
	r = MulAdd(s3_5, M4(1.490e-01, 3.375e-01, -1.473e-01, 1.287e-01, -7.768e-03, 1.830e-01, -5.415e-02, 3.301e-02, 6.827e-02, 2.061e-01, 1.572e-01, 1.906e-01, -2.636e-02, -1.488e-01, 4.210e-02, -9.244e-02), r);
	r = MulAdd(s3_6, M4(1.140e-03, -3.620e-02, -9.971e-03, 5.804e-02, 1.823e-01, -1.234e-02, 4.516e-02, -2.637e-02, -3.658e-02, -1.711e-02, 3.558e-02, 2.008e-02, 2.854e-02, -5.525e-02, 5.287e-02, -5.876e-02), r);
	r = MulAdd(s3_7, M4(6.883e-02, 6.152e-03, -8.080e-02, 4.011e-02, 1.149e-01, -9.289e-02, 1.060e-01, 4.384e-02, -7.819e-02, 1.448e-02, 1.486e-01, -1.965e-02, 4.570e-02, -2.967e-02, -1.034e-01, -1.041e-01), r);
	r = MulAdd(s3_8, M4(-3.056e-03, 2.109e-02, 2.237e-02, 9.022e-02, -5.609e-02, -8.009e-03, 8.356e-02, 3.819e-02, -1.670e-02, 4.753e-02, 9.900e-02, 2.052e-02, -7.434e-02, 1.339e-02, -1.596e-02, 3.147e-03), r);
	return r;
}

void Pass6(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 7
//!DESC conv6
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 2.856e-05, 8.552e-03, -8.514e-03, -8.667e-03 };
	r = MulAdd(s0_0, M4(-2.209e-01, -5.795e-02, -8.765e-02, -2.009e-02, 6.086e-03, -7.115e-02, 8.973e-03, -1.543e-01, -1.694e-01, -5.479e-02, 4.161e-02, 1.035e-02, 1.328e-02, 5.594e-02, 1.018e-05, 2.955e-02), r);
	r = MulAdd(s0_1, M4(-3.967e-02, 1.680e-01, -2.233e-02, -8.411e-02, -1.698e-02, -2.763e-02, -1.059e-01, -2.100e-01, 3.937e-02, 3.267e-02, -8.229e-02, 3.501e-02, -2.628e-03, -4.292e-02, 2.431e-02, -3.400e-02), r);
	r = MulAdd(s0_2, M4(1.509e-02, -3.018e-02, 5.379e-02, -6.856e-02, 2.673e-03, -4.967e-02, 2.877e-03, -1.595e-02, -1.026e-01, -5.521e-02, 1.200e-02, -4.588e-02, 2.993e-02, -1.958e-02, -2.616e-03, -2.579e-02), r);
	r = MulAdd(s0_3, M4(4.993e-02, 1.236e-01, -1.067e-02, -5.176e-01, 2.549e-01, 4.287e-02, 7.064e-02, 1.690e-01, 9.888e-02, 1.328e-02, 4.869e-02, -5.790e-02, -1.404e-01, -6.974e-03, -4.548e-02, 2.544e-01), r);
	r = MulAdd(s0_4, M4(1.472e-02, 3.096e-01, -3.115e-01, 2.413e-02, -7.457e-02, -1.535e-01, -3.765e-01, 6.845e-01, 1.154e-01, -1.489e-01, -2.606e-01, 6.946e-02, 7.796e-02, 3.208e-02, -1.062e-01, 2.085e-01), r);
	r = MulAdd(s0_5, M4(1.892e-02, 7.663e-02, 7.539e-02, -1.873e-02, -8.866e-02, 4.203e-02, -3.389e-01, 1.615e-01, -7.032e-02, -1.146e-01, 9.530e-02, 6.399e-02, -5.494e-02, -8.184e-02, 1.078e-01, 2.335e-02), r);
	r = MulAdd(s0_6, M4(-5.239e-03, 7.910e-02, 4.204e-03, 1.566e-02, -1.073e-01, -2.478e-02, -1.678e-02, -2.501e-02, 2.174e-02, -1.456e-02, 6.321e-02, 8.639e-02, -2.920e-02, -2.341e-01, 6.144e-02, -9.660e-02), r);
	r = MulAdd(s0_7, M4(-6.268e-02, 2.019e-03, -7.203e-02, 1.529e-02, 1.932e-01, 8.225e-02, 5.777e-02, -2.183e-01, -8.861e-02, -1.371e-01, 2.163e-01, 1.881e-01, -4.031e-02, -2.713e-01, 3.510e-01, 1.920e-01), r);
	r = MulAdd(s0_8, M4(-3.058e-02, 1.151e-01, -3.663e-02, -8.908e-03, 6.323e-02, 1.742e-01, -1.851e-01, -9.976e-02, -2.619e-02, -2.550e-02, 5.783e-02, 1.301e-02, 4.378e-02, -1.185e-01, -2.295e-02, -5.327e-02), r);
	r = MulAdd(s1_0, M4(-2.656e-02, -8.664e-02, -1.887e-02, 3.009e-02, 5.418e-02, -1.342e-02, -6.789e-03, -1.552e-02, 2.416e-02, -1.698e-03, -2.975e-02, 1.135e-01, -3.067e-02, 4.174e-02, 2.610e-02, 2.015e-02), r);
	r = MulAdd(s1_1, M4(7.872e-03, -4.486e-03, 9.428e-02, -1.019e-01, -8.668e-03, 3.952e-02, -1.387e-02, 4.557e-03, -6.755e-02, -1.692e-01, 3.735e-03, 1.189e-01, -3.229e-02, 3.917e-02, -9.192e-03, 2.140e-02), r);
	r = MulAdd(s1_2, M4(5.343e-02, -4.132e-02, 7.494e-02, -5.720e-02, -5.339e-03, 4.912e-02, -3.645e-03, 1.655e-02, -8.378e-03, 1.803e-02, -1.056e-02, -6.085e-03, -2.281e-02, 2.981e-02, -9.818e-04, -3.084e-02), r);
	r = MulAdd(s1_3, M4(7.573e-03, 4.110e-02, 3.253e-03, -1.924e-01, 3.217e-02, -9.499e-03, 2.526e-02, 6.588e-02, 6.349e-02, -3.005e-02, -3.070e-02, 1.590e-01, 6.700e-02, 4.547e-02, 2.119e-03, 9.841e-02), r);
	r = MulAdd(s1_4, M4(-1.378e-01, 8.172e-02, -7.034e-02, 2.066e-01, 5.232e-03, -7.941e-02, -1.010e-01, 1.572e-01, 1.921e-01, 9.517e-02, -9.389e-01, -4.918e-02, 1.478e-01, -3.970e-01, 2.126e-01, -1.827e-02), r);
	r = MulAdd(s1_5, M4(5.501e-02, -7.455e-02, 1.262e-01, 1.406e-02, -4.925e-02, -9.561e-02, 8.075e-02, 2.132e-02, -2.483e-02, 1.129e-01, -5.470e-02, 2.870e-02, -2.324e-02, -1.364e-01, 4.599e-02, 6.126e-03), r);
	r = MulAdd(s1_6, M4(3.095e-02, 1.469e-02, 3.846e-02, 4.155e-03, -8.392e-03, -3.402e-02, 4.176e-02, 6.511e-03, 6.366e-02, -6.091e-02, 8.332e-02, 1.722e-02, 1.256e-01, -9.227e-03, -4.640e-02, -2.004e-02), r);
	r = MulAdd(s1_7, M4(-1.292e-02, -9.372e-02, 6.924e-02, -7.925e-03, 6.668e-03, 7.838e-03, -5.530e-02, -2.253e-03, 1.959e-01, -1.509e-01, 1.427e-01, 1.159e-01, -7.810e-02, 7.828e-02, 1.069e-01, 1.240e-01), r);
	r = MulAdd(s1_8, M4(-6.521e-03, 5.130e-02, -2.057e-02, -3.995e-02, 5.384e-02, 4.676e-02, -6.988e-02, -5.235e-02, 3.864e-02, -7.028e-02, 3.601e-02, 9.088e-03, -1.106e-02, -3.942e-02, 1.250e-04, -4.433e-02), r);
	r = MulAdd(s2_0, M4(2.098e-02, -2.232e-02, -1.023e-01, -2.915e-03, 6.659e-03, -8.768e-02, 1.362e-03, 1.724e-02, -2.860e-02, -1.300e-02, 1.271e-03, -7.769e-02, -1.679e-02, -9.083e-04, -5.349e-02, 2.312e-02), r);
	r = MulAdd(s2_1, M4(-1.207e-01, 4.680e-03, -1.289e-02, 3.844e-02, -2.073e-02, -4.596e-02, -7.886e-02, 2.531e-02, 3.798e-02, -1.523e-02, 1.300e-01, -3.368e-02, 1.875e-02, -1.294e-02, -7.884e-02, -5.748e-02), r);
	r = MulAdd(s2_2, M4(-2.657e-02, 7.694e-02, -6.276e-02, -1.069e-03, 3.325e-02, -1.413e-02, 4.789e-02, 3.326e-02, 4.902e-02, -2.639e-02, 4.732e-03, 6.768e-02, 5.051e-02, -1.277e-01, 1.042e-01, -7.689e-02), r);
	r = MulAdd(s2_3, M4(1.491e-01, 2.843e-02, -6.555e-02, -1.054e-01, -1.957e-01, 2.262e-01, -5.168e-02, -2.061e-01, 3.173e-01, 6.741e-02, -2.873e-02, 2.378e-01, 2.837e-02, 5.813e-03, -2.585e-02, -5.869e-02), r);
	r = MulAdd(s2_4, M4(7.518e-01, -1.003e-01, 7.786e-02, -4.277e-01, -7.067e-02, 6.606e-01, -2.301e-01, -1.439e-02, 1.334e-01, -1.780e-01, 7.624e-03, 2.551e-01, -4.422e-01, -3.284e-02, -1.636e-01, 2.846e-01), r);
	r = MulAdd(s2_5, M4(6.291e-02, -3.015e-01, 1.031e-01, 1.837e-02, -5.147e-02, 1.049e-01, -1.665e-01, -3.407e-02, -1.383e-01, -1.599e-01, 9.878e-03, 5.695e-02, -3.202e-02, -8.912e-02, 3.058e-01, 9.144e-02), r);
	r = MulAdd(s2_6, M4(1.529e-01, 2.058e-02, 1.225e-02, 1.418e-02, 2.851e-02, -9.414e-02, 3.406e-02, -8.937e-02, 7.244e-02, -3.096e-02, 4.924e-03, 7.146e-02, -6.292e-02, -5.805e-02, 2.246e-02, -7.245e-02), r);
	r = MulAdd(s2_7, M4(-9.794e-02, -3.174e-02, -3.934e-02, 1.694e-01, 1.580e-02, -1.106e-01, 1.071e-01, 9.675e-02, -1.938e-01, -9.670e-02, 1.396e-01, 1.392e-01, 1.158e-01, 1.606e-01, -7.912e-02, -4.225e-01), r);
	r = MulAdd(s2_8, M4(4.833e-02, 8.418e-02, 4.940e-02, 7.383e-02, 3.532e-02, -4.740e-02, 4.360e-02, 3.728e-02, 1.727e-02, 1.183e-02, -3.121e-02, -1.380e-01, -5.586e-02, 1.812e-01, -7.809e-02, 2.813e-03), r);
	r = MulAdd(s3_0, M4(-3.128e-02, -8.348e-03, -3.419e-02, 1.555e-02, 2.473e-02, -1.091e-01, -2.974e-02, -7.533e-04, -3.134e-02, 4.890e-02, 4.992e-02, 5.672e-03, -2.057e-01, -6.419e-02, -5.290e-03, -9.112e-02), r);
	r = MulAdd(s3_1, M4(-1.988e-01, -6.346e-02, -2.376e-02, -1.026e-01, 3.478e-02, -1.038e-01, 8.392e-02, -4.286e-02, 8.850e-02, 5.137e-02, 3.114e-02, 3.773e-02, -5.500e-02, 5.521e-02, 3.891e-02, -7.728e-02), r);
	r = MulAdd(s3_2, M4(1.495e-03, 1.989e-03, 8.935e-02, -3.143e-02, -2.298e-02, 3.887e-02, -4.775e-02, 2.035e-02, 2.637e-02, 4.364e-02, -3.181e-02, 5.997e-02, 3.970e-02, -4.506e-02, 4.399e-02, -7.875e-02), r);
	r = MulAdd(s3_3, M4(1.929e-01, 6.065e-02, 1.131e-02, -6.712e-02, 2.405e-01, 8.786e-02, 2.701e-02, 3.849e-01, 6.113e-01, 1.128e-01, -5.000e-02, 4.534e-02, 1.853e-01, 1.202e-01, 7.714e-02, 2.600e-01), r);
	r = MulAdd(s3_4, M4(4.894e-01, 7.720e-02, -2.085e-01, 1.759e-01, -8.599e-02, 2.499e-01, 2.671e-02, 3.832e-02, -7.451e-02, -4.900e-01, 2.272e-01, 3.038e-01, -1.101e-02, 1.394e-01, -2.065e-01, -2.118e-02), r);
	r = MulAdd(s3_5, M4(1.279e-02, -1.004e-02, -1.078e-01, 5.152e-02, 4.421e-02, 9.399e-02, -1.011e-01, -2.129e-02, -4.416e-02, -9.283e-02, -7.153e-03, 8.909e-02, -9.666e-02, 3.185e-02, 1.265e-01, -9.346e-03), r);
	r = MulAdd(s3_6, M4(-3.006e-02, -3.389e-03, -1.226e-02, -4.016e-03, -5.528e-02, -6.337e-02, 3.931e-02, 3.432e-02, -1.850e-01, -4.101e-03, -7.500e-02, 2.523e-01, -4.059e-02, 9.910e-03, 6.657e-02, 1.195e-01), r);
	r = MulAdd(s3_7, M4(-3.706e-02, -4.632e-02, 1.353e-01, -1.655e-02, -1.189e-03, -1.299e-01, 1.459e-01, 7.592e-02, -8.454e-02, -4.301e-02, 1.108e-01, 2.686e-01, -1.628e-01, -9.140e-02, 7.202e-02, -4.312e-02), r);
	r = MulAdd(s3_8, M4(2.611e-02, 4.438e-02, -1.065e-03, 8.827e-02, 5.581e-03, -1.020e-01, 5.709e-02, -1.106e-02, 6.134e-02, 5.575e-02, 5.738e-02, -1.392e-01, 1.741e-02, 1.431e-01, 7.709e-02, 4.472e-02), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 5.044e-03, 1.567e-04, -1.145e-02, 6.927e-04 };
	r = MulAdd(s0_0, M4(-2.060e-02, -3.573e-02, 4.912e-02, 5.192e-02, -1.701e-02, -5.571e-02, 3.012e-02, -7.803e-02, 5.806e-02, -1.605e-02, -2.480e-02, 2.160e-03, 3.288e-02, -1.962e-03, -4.509e-02, 5.333e-03), r);
	r = MulAdd(s0_1, M4(-7.057e-02, -1.169e-02, 8.115e-02, 3.020e-02, -2.626e-02, -1.616e-01, -1.885e-01, 1.023e-01, 8.520e-02, -9.444e-02, -1.475e-01, -9.016e-02, 6.451e-02, -2.741e-02, 5.301e-02, -8.370e-03), r);
	r = MulAdd(s0_2, M4(3.020e-02, -9.219e-02, 8.349e-02, 9.079e-03, -1.881e-02, 4.455e-02, 1.154e-01, -2.889e-02, -1.542e-02, -7.914e-03, -5.572e-02, 3.873e-02, 1.079e-03, -4.719e-02, 2.548e-02, 3.440e-02), r);
	r = MulAdd(s0_3, M4(1.301e-01, -8.388e-02, -5.687e-02, 2.733e-01, 3.401e-02, -1.413e-02, 4.602e-02, -2.813e-01, 4.540e-01, -5.388e-02, 7.387e-02, -6.504e-01, 1.325e-01, -2.873e-02, -2.975e-02, -2.031e-01), r);
	r = MulAdd(s0_4, M4(7.265e-03, 3.294e-01, -4.150e-01, -4.157e-01, -6.122e-01, -2.782e-01, -2.743e-02, 2.658e-01, -2.096e-01, -1.486e-01, 1.571e-01, 3.423e-01, -1.726e-04, -4.478e-01, -7.431e-02, 1.408e-01), r);
	r = MulAdd(s0_5, M4(-5.815e-03, -1.492e-01, 4.425e-02, -1.350e-02, 4.150e-02, 1.274e-01, -2.494e-01, -1.405e-02, 3.992e-02, -2.511e-03, -9.956e-03, 3.636e-02, 2.708e-02, 2.007e-01, 2.176e-01, -1.301e-02), r);
	r = MulAdd(s0_6, M4(-2.974e-02, 3.332e-03, -4.831e-02, 3.652e-02, -2.911e-02, -1.271e-02, 3.832e-02, -2.472e-02, 3.249e-02, -1.190e-03, -4.770e-02, -8.276e-02, 1.235e-01, 8.707e-02, 1.179e-01, 1.313e-01), r);
	r = MulAdd(s0_7, M4(1.030e-01, -1.146e-01, -6.309e-02, -1.055e-01, 3.441e-02, 3.396e-03, -1.176e-01, 1.386e-01, 1.495e-01, 2.413e-02, 1.509e-01, -5.060e-02, -1.727e-01, 7.154e-01, 1.993e-01, -3.198e-02), r);
	r = MulAdd(s0_8, M4(-3.894e-02, 2.181e-02, 4.581e-02, 4.944e-02, -1.211e-01, 1.148e-01, -1.811e-01, -2.012e-02, 4.331e-02, 5.017e-02, -1.258e-02, 1.772e-02, 9.302e-02, -1.110e-02, 1.585e-02, -3.492e-02), r);
	r = MulAdd(s1_0, M4(-1.173e-02, 9.897e-03, 7.565e-02, -8.842e-03, -1.854e-02, -7.564e-03, -2.706e-04, 1.776e-03, -9.569e-02, 2.963e-03, 4.260e-02, 2.437e-02, 1.912e-02, -1.021e-02, -5.637e-02, -2.496e-02), r);
	r = MulAdd(s1_1, M4(-5.787e-02, -1.200e-02, 7.517e-02, 7.302e-02, 2.392e-02, 1.970e-02, -7.769e-02, 9.084e-03, 3.051e-02, 2.814e-02, -2.882e-03, -2.011e-02, 7.490e-02, 1.503e-02, 1.809e-02, -8.811e-02), r);
	r = MulAdd(s1_2, M4(-1.795e-02, -1.067e-02, 1.235e-01, 5.245e-03, -6.887e-02, 4.047e-02, 3.475e-02, 6.296e-03, -3.501e-03, -3.751e-02, -9.597e-02, 2.536e-02, 1.646e-02, -2.891e-02, 1.570e-02, 1.715e-02), r);
	r = MulAdd(s1_3, M4(8.565e-02, -6.574e-05, -5.121e-02, 5.086e-02, -7.024e-02, -5.662e-04, 2.205e-03, 4.116e-02, -4.728e-02, 4.219e-02, 4.900e-02, -1.208e-01, -2.718e-02, 3.903e-02, 2.372e-02, -3.676e-02), r);
	r = MulAdd(s1_4, M4(-1.401e-01, 5.764e-01, -2.054e-01, -1.029e-01, -1.037e-01, -4.536e-02, 6.555e-02, 1.516e-02, -1.173e-01, 8.400e-02, 1.755e-01, 3.744e-01, -1.311e-01, -1.403e-01, 2.332e-01, 1.204e-01), r);
	r = MulAdd(s1_5, M4(4.695e-02, -5.544e-02, 8.989e-02, -6.275e-02, 1.351e-01, -2.991e-02, -8.762e-03, -1.449e-02, -9.402e-03, 2.208e-02, -5.917e-02, -1.552e-02, 2.040e-02, -5.696e-04, 9.425e-02, 2.299e-02), r);
	r = MulAdd(s1_6, M4(-4.948e-02, 7.441e-02, 2.896e-02, 2.147e-02, 2.291e-02, -2.075e-02, 3.712e-03, 2.035e-02, 2.247e-02, -3.774e-02, -4.785e-02, -1.356e-01, -5.951e-03, 5.747e-02, 8.200e-04, -2.847e-02), r);
	r = MulAdd(s1_7, M4(1.020e-01, -2.641e-02, 1.961e-02, -1.182e-01, -8.813e-02, -1.600e-04, -1.931e-02, 1.197e-02, -3.958e-03, 1.959e-02, 4.974e-02, -1.126e-01, -1.102e-01, 1.223e-01, -4.062e-03, 6.450e-04), r);
	r = MulAdd(s1_8, M4(-2.978e-02, 3.062e-02, 1.368e-02, 3.659e-03, -8.098e-02, -3.109e-02, 1.281e-02, 1.060e-03, -2.341e-02, -8.555e-03, -3.087e-02, -2.310e-02, 6.370e-02, -1.293e-02, 2.538e-02, -1.270e-03), r);
	r = MulAdd(s2_0, M4(-7.273e-02, 2.366e-02, 4.031e-02, 6.153e-02, -7.381e-02, 2.800e-02, -1.501e-02, 1.604e-01, -5.307e-03, -4.300e-03, -7.255e-02, 1.191e-01, 2.080e-02, -2.249e-02, 2.204e-02, 5.714e-02), r);
	r = MulAdd(s2_1, M4(-6.031e-02, -3.662e-02, -2.085e-01, 3.811e-02, -1.018e-01, -4.553e-03, -1.082e-01, -2.846e-03, 6.619e-02, 4.708e-02, -6.461e-02, -9.098e-02, -3.929e-03, 2.785e-02, -1.225e-03, -1.047e-01), r);
	r = MulAdd(s2_2, M4(-6.829e-02, 6.371e-02, -8.082e-02, -2.556e-02, 1.878e-02, -2.257e-02, -9.831e-03, -5.339e-02, 6.919e-03, -8.110e-02, 3.922e-02, 1.624e-03, 3.858e-02, -6.258e-02, 1.776e-02, 2.512e-03), r);
	r = MulAdd(s2_3, M4(-1.304e-01, -1.371e-02, -2.400e-02, 2.024e-01, 4.433e-01, -1.796e-01, -8.035e-02, -3.362e-01, 1.620e-01, 7.586e-03, -4.559e-02, 3.404e-02, 1.072e-01, -2.411e-02, 3.556e-02, -2.595e-01), r);
	r = MulAdd(s2_4, M4(-9.545e-02, -6.805e-02, -6.113e-01, -3.604e-01, 1.015e-01, 1.480e-01, -5.419e-01, 7.857e-02, -1.547e-01, 9.204e-02, 1.295e-01, 2.123e-01, -6.725e-02, 1.549e-01, -5.152e-01, -1.548e-01), r);
	r = MulAdd(s2_5, M4(-5.472e-03, 3.834e-02, 1.714e-01, -2.580e-03, -1.310e-02, 6.837e-02, -1.696e-01, 2.731e-02, 2.067e-02, 1.079e-01, 9.934e-02, -2.763e-02, -3.332e-02, -4.433e-02, 2.018e-01, -1.534e-02), r);
	r = MulAdd(s2_6, M4(5.036e-02, 2.648e-02, -6.527e-03, -3.690e-02, -7.802e-02, 2.207e-02, 6.141e-02, 1.958e-01, -8.824e-03, 2.394e-02, -2.215e-02, 1.731e-02, 4.865e-02, -4.820e-02, 4.198e-02, -2.534e-01), r);
	r = MulAdd(s2_7, M4(-5.007e-02, 4.344e-02, 4.250e-03, -4.466e-02, -4.042e-03, 1.976e-01, 1.295e-01, -7.906e-02, 1.381e-02, 4.920e-02, 1.303e-01, -1.579e-02, 3.775e-03, -1.275e-01, 7.502e-02, 2.351e-02), r);
	r = MulAdd(s2_8, M4(-1.144e-01, 1.398e-01, 2.054e-01, -6.233e-02, -6.101e-02, -2.771e-02, 2.633e-02, -2.155e-02, -3.079e-02, -4.460e-02, -4.350e-03, 4.232e-02, 4.897e-02, 8.307e-02, -1.322e-01, -1.186e-02), r);
	r = MulAdd(s3_0, M4(-2.531e-02, -1.739e-02, 2.189e-02, 6.500e-02, -8.803e-02, 3.329e-02, 1.011e-01, -7.934e-02, -1.538e-02, 8.243e-02, 8.416e-03, -5.044e-02, 3.723e-03, -5.774e-02, 1.004e-02, -1.064e-01), r);
	r = MulAdd(s3_1, M4(-3.050e-02, 6.282e-03, 1.975e-02, -4.380e-02, -2.323e-02, -6.742e-02, -2.779e-02, 1.099e-01, 6.210e-02, -4.539e-02, -9.253e-02, -9.297e-02, 4.207e-02, -7.108e-02, -3.079e-02, -9.736e-04), r);
	r = MulAdd(s3_2, M4(3.245e-02, -7.168e-02, -1.138e-01, -1.895e-02, 1.658e-02, 5.894e-02, -5.603e-02, -6.963e-03, -2.875e-02, 1.198e-02, 5.772e-02, -1.160e-02, 9.326e-03, -3.573e-02, 4.991e-03, 1.271e-02), r);
	r = MulAdd(s3_3, M4(9.787e-02, -2.036e-02, 1.718e-02, -1.622e-02, 1.043e-01, -3.425e-02, -6.481e-02, -3.099e-01, 7.831e-02, 8.317e-02, 1.363e-03, -5.345e-02, 1.314e-01, 6.020e-02, -3.589e-02, -7.305e-01), r);
	r = MulAdd(s3_4, M4(-1.829e-02, 4.974e-02, -2.094e-01, -2.861e-01, 1.128e-01, 1.619e-01, -2.358e-01, 2.109e-04, -4.152e-01, 2.425e-02, 2.893e-01, 1.625e-01, -2.212e-01, 9.801e-02, 8.805e-02, -1.555e-01), r);
	r = MulAdd(s3_5, M4(-1.477e-01, 1.423e-01, -8.523e-02, 4.213e-02, 2.496e-02, 1.500e-03, -6.522e-02, -2.658e-02, 7.489e-02, 3.555e-02, -5.523e-03, -3.305e-02, -1.358e-01, -1.811e-02, 2.465e-02, -5.622e-03), r);
	r = MulAdd(s3_6, M4(-5.342e-03, 3.661e-03, -1.275e-03, -7.544e-02, -2.144e-02, 1.679e-02, 3.667e-02, 9.079e-02, -1.567e-01, 2.069e-02, 4.591e-03, 8.125e-03, 8.032e-02, -3.126e-02, 3.645e-02, -2.959e-01), r);
	r = MulAdd(s3_7, M4(8.163e-02, 2.339e-02, -9.055e-04, 3.790e-02, -2.948e-02, 4.977e-02, 7.393e-02, -8.920e-03, 2.544e-02, 3.568e-02, 1.493e-01, -1.212e-01, 1.065e-01, -1.628e-01, 1.593e-01, -8.379e-02), r);
	r = MulAdd(s3_8, M4(1.707e-02, 8.862e-02, -3.193e-02, -8.568e-02, -1.546e-02, -4.577e-02, 8.805e-02, 1.346e-02, 1.543e-02, -5.755e-02, -3.642e-02, 2.221e-02, 1.673e-03, -2.868e-03, -6.763e-02, -6.137e-03), r);
	return r;
}

void Pass7(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 8
//!DESC conv7
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t0, t1
//!OUT t2, t3

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -1.743e-03, -5.471e-03, -9.889e-04, 8.561e-05 };
	r = MulAdd(s0_0, M4(-8.064e-02, -3.833e-02, -3.181e-02, 1.054e-02, 9.509e-02, -6.553e-02, -5.670e-03, -3.696e-02, 2.583e-02, -1.569e-02, 1.094e-02, -2.399e-02, -3.234e-02, -1.243e-01, 5.270e-03, -6.099e-02), r);
	r = MulAdd(s0_1, M4(-4.438e-02, -1.485e-01, -1.386e-02, 4.858e-02, -5.601e-02, 1.331e-01, 3.263e-02, -9.788e-02, -2.371e-02, 9.461e-02, -2.250e-02, 1.755e-01, -5.625e-02, 3.249e-01, 1.192e-01, 7.269e-03), r);
	r = MulAdd(s0_2, M4(-6.456e-02, 1.150e-01, 3.409e-02, -1.190e-02, -2.178e-02, 1.632e-02, -2.622e-02, -3.145e-02, -5.530e-02, 6.932e-03, 2.125e-02, -1.092e-02, 7.237e-03, -1.095e-02, -9.447e-02, 1.069e-01), r);
	r = MulAdd(s0_3, M4(3.359e-02, -7.934e-02, -1.498e-02, -1.134e-02, -1.444e-02, 1.000e-01, -3.456e-02, 9.253e-02, 4.219e-01, -1.332e-01, -2.880e-03, 3.749e-01, 8.414e-02, 5.580e-02, 7.691e-02, 9.379e-02), r);
	r = MulAdd(s0_4, M4(1.168e+00, 3.189e-01, 1.974e-03, 6.336e-01, -2.977e-01, -1.237e-01, -7.846e-02, 1.225e-02, -5.781e-01, 1.313e-02, -8.957e-01, 9.973e-02, -3.968e-01, 4.271e-01, -1.687e-01, -4.163e-01), r);
	r = MulAdd(s0_5, M4(2.994e-02, -3.345e-01, 5.888e-02, 3.474e-01, 1.451e-02, 5.160e-02, 1.694e-02, -1.601e-02, -6.726e-02, -8.100e-02, 3.170e-01, 1.724e-01, 5.414e-02, 5.215e-02, 1.187e-01, 6.467e-02), r);
	r = MulAdd(s0_6, M4(-7.173e-02, -5.387e-02, 2.614e-03, -1.457e-02, -5.838e-02, 1.020e-02, -1.882e-02, 3.052e-02, -1.867e-01, -1.652e-02, -4.128e-02, -3.654e-02, 1.469e-02, 2.656e-02, 2.224e-02, -3.825e-02), r);
	r = MulAdd(s0_7, M4(-2.378e-01, 7.857e-03, -3.584e-02, 4.349e-03, -9.461e-02, 4.763e-02, -6.449e-02, 7.229e-02, 9.332e-02, 3.774e-02, -1.346e-01, -1.196e-01, -2.878e-01, 9.030e-02, 1.203e-01, 3.148e-03), r);
	r = MulAdd(s0_8, M4(9.453e-02, 1.255e-01, -1.324e-01, 6.370e-02, 2.242e-03, -1.721e-03, 6.953e-02, 3.019e-03, -5.313e-02, -1.384e-02, 4.697e-02, 4.914e-02, -9.657e-02, 1.233e-01, -1.883e-01, -8.477e-03), r);
	r = MulAdd(s1_0, M4(-1.283e-02, 3.713e-02, 6.623e-03, 6.693e-03, -5.631e-02, 2.185e-02, -3.356e-02, 2.070e-03, 5.509e-02, -2.332e-01, 4.553e-03, -3.012e-02, -1.517e-02, 1.337e-03, -6.578e-03, -2.650e-02), r);
	r = MulAdd(s1_1, M4(3.377e-02, 2.493e-03, -9.238e-03, -6.058e-02, -1.275e-01, 8.259e-02, 5.112e-02, 3.219e-02, -2.216e-02, 7.512e-02, 3.070e-02, 7.029e-02, -1.924e-02, 4.763e-02, -2.827e-02, 4.378e-03), r);
	r = MulAdd(s1_2, M4(-9.929e-03, 1.398e-02, 1.972e-02, 1.740e-02, -9.611e-03, 5.041e-02, -4.188e-02, 5.115e-02, -1.306e-02, -1.754e-03, -4.642e-02, 1.170e-02, -2.771e-02, -3.207e-02, -2.397e-02, -4.773e-02), r);
	r = MulAdd(s1_3, M4(-2.679e-02, -2.625e-03, 1.924e-02, 9.094e-03, -2.648e-01, -3.603e-02, 1.072e-02, -1.963e-01, 1.635e-01, -2.366e-02, 1.518e-02, 1.552e-01, 6.552e-02, -4.113e-03, 1.333e-02, -2.104e-02), r);
	r = MulAdd(s1_4, M4(2.173e-01, 2.712e-01, 1.597e-02, 2.260e-01, -6.777e-01, 1.775e-01, 3.145e-01, 3.556e-02, -2.059e-01, -2.622e-02, -2.541e-01, -5.547e-03, -1.087e-01, -4.131e-02, 2.261e-02, -9.224e-02), r);
	r = MulAdd(s1_5, M4(-3.171e-02, -5.821e-02, -6.229e-02, 1.392e-01, 2.494e-02, 9.668e-02, -5.215e-02, 1.746e-01, -5.280e-02, -3.489e-02, 7.232e-02, -3.858e-03, 2.566e-02, 4.005e-02, -5.404e-02, -8.660e-02), r);
	r = MulAdd(s1_6, M4(7.131e-03, 2.685e-02, -2.403e-03, 1.059e-02, 1.469e-01, 1.232e-01, 5.431e-02, 1.890e-01, -1.081e-01, 3.885e-02, -3.539e-02, 5.289e-02, -1.438e-02, -3.979e-03, -6.192e-03, -2.331e-02), r);
	r = MulAdd(s1_7, M4(-1.071e-01, 7.591e-04, -6.525e-02, 1.632e-02, -1.323e-01, 3.493e-02, -9.612e-02, 2.512e-02, -7.017e-02, 4.360e-02, -6.099e-02, 3.901e-04, -1.764e-02, -1.061e-02, -3.409e-02, -2.255e-02), r);
	r = MulAdd(s1_8, M4(-4.386e-02, -1.254e-02, 2.400e-02, 1.194e-01, 5.802e-02, 8.040e-02, -3.854e-02, 5.653e-02, -1.702e-02, -2.335e-02, 1.121e-01, 2.440e-02, -3.404e-04, 7.401e-02, -5.980e-02, -3.817e-02), r);
	r = MulAdd(s2_0, M4(-9.579e-02, 4.650e-02, 8.575e-03, -5.575e-02, -8.117e-02, -7.162e-02, 6.056e-03, -3.501e-02, 9.302e-02, -1.216e-01, -6.163e-02, 6.897e-02, -3.371e-02, 1.772e-02, 3.013e-03, -5.936e-03), r);
	r = MulAdd(s2_1, M4(4.708e-02, 1.280e-01, 3.359e-02, 1.003e-01, 9.448e-02, 3.132e-02, 8.137e-02, 9.316e-02, -5.728e-02, 5.457e-02, 9.155e-02, -3.774e-02, -2.305e-02, -1.017e-01, 2.738e-02, -2.373e-02), r);
	r = MulAdd(s2_2, M4(8.975e-03, 8.207e-02, -6.346e-02, 8.974e-02, -2.279e-02, -9.128e-03, -4.230e-02, -8.024e-03, 5.563e-02, 9.479e-02, -9.852e-02, 8.121e-02, -1.145e-02, 6.518e-02, -2.581e-02, 2.733e-02), r);
	r = MulAdd(s2_3, M4(1.479e-01, -2.068e-02, 3.906e-02, 8.235e-02, -3.507e-02, 1.935e-01, 1.466e-02, 2.432e-01, 5.253e-01, -3.897e-02, -4.775e-02, -9.807e-02, 5.332e-02, 9.679e-02, -1.589e-02, 7.846e-02), r);
	r = MulAdd(s2_4, M4(1.030e-01, 3.311e-01, 1.128e-01, -1.244e-01, -1.489e-01, 2.902e-01, 2.805e-01, -1.558e-01, -1.289e-01, 3.306e-01, -1.475e-01, -6.570e-02, 3.265e-02, -1.141e-01, 6.703e-02, -1.717e-01), r);
	r = MulAdd(s2_5, M4(2.855e-02, 1.184e-01, -2.904e-01, 2.258e-02, -7.943e-02, -5.343e-02, -8.054e-02, 1.255e-01, -1.108e-02, 9.190e-02, -1.725e-01, -6.260e-02, -8.194e-03, 5.840e-02, -1.704e-01, 7.028e-03), r);
	r = MulAdd(s2_6, M4(1.684e-02, 1.411e-02, 8.570e-03, -1.440e-02, 3.143e-02, 5.820e-03, 1.764e-02, 5.872e-02, 7.943e-02, -5.400e-02, 8.544e-02, -3.393e-02, -7.690e-02, -2.082e-02, 2.975e-03, -5.316e-02), r);
	r = MulAdd(s2_7, M4(-2.681e-02, 7.370e-04, -5.250e-02, -3.652e-02, -7.367e-02, -2.542e-02, 1.165e-01, -5.653e-02, 3.500e-02, 1.781e-02, -7.241e-02, -1.056e-03, -9.338e-02, 2.896e-03, -3.257e-02, 1.238e-01), r);
	r = MulAdd(s2_8, M4(-6.529e-03, 3.786e-04, -9.472e-02, 5.894e-02, -4.906e-02, 1.019e-02, -3.093e-03, 3.903e-02, 2.610e-02, 6.776e-02, -7.901e-02, -1.485e-03, -9.116e-02, 1.427e-01, -6.813e-02, -1.681e-02), r);
	r = MulAdd(s3_0, M4(-6.420e-03, 1.512e-02, 2.670e-02, -1.570e-01, -6.513e-03, 5.949e-02, 1.094e-02, -6.247e-02, -1.649e-02, -6.791e-02, 1.733e-03, 2.568e-02, -5.164e-02, 2.694e-02, 8.787e-03, -4.768e-02), r);
	r = MulAdd(s3_1, M4(1.001e-01, 2.465e-01, 9.252e-02, -2.858e-02, 1.702e-02, -3.235e-02, 1.258e-01, -3.779e-03, 1.607e-02, 1.508e-01, 3.810e-02, -1.863e-02, -1.536e-02, -2.347e-01, -1.849e-03, 5.462e-03), r);
	r = MulAdd(s3_2, M4(9.057e-03, 1.345e-01, 2.663e-03, -4.507e-02, 2.303e-02, 2.462e-02, -6.214e-02, 7.788e-02, 4.236e-02, 5.039e-02, 2.335e-02, 2.963e-02, -4.921e-02, 4.596e-02, -1.201e-02, 1.782e-02), r);
	r = MulAdd(s3_3, M4(5.325e-02, 2.420e-01, 4.483e-03, 2.510e-01, -7.061e-03, -1.147e-01, -9.773e-03, 1.426e-01, 3.031e-03, 4.003e-02, -1.434e-02, 6.091e-02, 9.825e-02, 8.520e-02, 2.736e-02, 1.416e-02), r);
	r = MulAdd(s3_4, M4(7.373e-02, 4.379e-01, -7.470e-02, 2.506e-01, -2.329e-01, 2.474e-01, 2.903e-01, -4.874e-01, -7.010e-02, 1.753e-01, 6.191e-02, 1.025e-01, 8.968e-02, -1.998e-01, 4.465e-05, -5.672e-01), r);
	r = MulAdd(s3_5, M4(1.284e-01, 1.790e-01, -1.679e-01, 2.744e-01, -3.069e-02, -4.589e-02, -2.251e-01, -1.779e-02, 3.338e-02, 5.997e-02, 1.126e-03, 3.696e-03, -1.154e-01, -5.846e-02, -1.024e-01, 3.392e-01), r);
	r = MulAdd(s3_6, M4(-2.364e-02, -9.130e-03, -3.655e-02, -1.954e-02, -9.995e-02, 2.973e-02, 4.064e-03, -4.305e-02, -2.863e-03, -8.699e-03, -1.583e-02, 4.408e-03, -6.298e-02, 2.150e-02, 1.992e-02, -2.189e-02), r);
	r = MulAdd(s3_7, M4(-4.068e-03, -5.225e-02, 3.381e-02, 8.963e-03, 2.640e-02, -2.133e-02, 1.803e-01, -9.592e-02, -1.579e-01, 1.786e-02, 6.515e-02, 2.114e-01, -2.167e-01, -1.371e-01, 2.144e-03, 2.155e-02), r);
	r = MulAdd(s3_8, M4(-3.349e-03, 1.488e-01, 8.888e-03, 1.001e-01, -4.780e-02, -1.406e-02, -2.940e-02, 4.185e-02, 2.758e-03, 2.820e-02, 5.186e-02, 2.930e-02, 1.372e-01, 1.122e-01, -1.140e-01, 1.343e-01), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 2.086e-03, 2.299e-03, -5.180e-03, 1.039e-03 };
	r = MulAdd(s0_0, M4(-5.525e-02, -5.493e-02, -8.973e-04, 4.167e-02, -5.567e-03, 5.194e-03, -5.363e-02, 1.513e-01, 9.020e-02, -4.135e-02, -3.216e-02, 5.381e-02, 7.401e-03, 7.252e-02, -1.617e-02, -1.196e-01), r);
	r = MulAdd(s0_1, M4(-5.790e-02, -1.934e-02, -1.790e-03, 5.390e-02, -6.975e-02, 4.877e-02, 1.578e-01, -6.377e-03, 1.284e-01, -4.775e-02, -6.735e-02, -9.064e-02, 1.184e-01, 9.055e-02, 9.935e-02, 2.014e-01), r);
	r = MulAdd(s0_2, M4(-4.004e-02, 4.488e-02, -4.212e-02, -6.286e-02, 1.711e-02, 2.731e-02, -2.406e-02, 1.097e-02, -3.399e-02, 8.065e-03, 3.894e-02, 1.282e-02, 2.036e-01, 4.754e-02, -4.522e-02, 6.568e-03), r);
	r = MulAdd(s0_3, M4(-2.372e-02, 6.962e-02, 3.557e-02, -8.888e-03, -6.028e-02, -3.183e-02, -1.608e-01, -3.044e-02, -1.429e-02, 3.901e-02, -6.904e-02, -5.157e-01, -1.547e-02, -1.362e-01, 4.108e-03, -1.772e-01), r);
	r = MulAdd(s0_4, M4(2.381e-01, -3.453e-01, -2.427e-01, 7.987e-02, 1.617e-01, 1.046e-01, 6.711e-02, 4.241e-01, -5.566e-01, 2.310e-01, 1.982e-01, 1.211e-02, 4.338e-02, -1.123e+00, -2.644e-01, -5.025e-01), r);
	r = MulAdd(s0_5, M4(-4.302e-01, -6.545e-02, -6.868e-03, 2.568e-01, 2.493e-02, 2.488e-02, -1.175e-01, -1.257e-02, 5.920e-02, -3.840e-03, -1.888e-01, 7.050e-02, 8.341e-02, -1.762e-01, -9.946e-02, -3.864e-02), r);
	r = MulAdd(s0_6, M4(-6.090e-03, 5.118e-02, 5.784e-02, 1.236e-02, -2.339e-02, 1.262e-03, -6.952e-02, -5.645e-02, 7.682e-02, 8.910e-02, -6.863e-02, -1.345e-01, 1.935e-02, -1.587e-02, 2.932e-03, 2.945e-02), r);
	r = MulAdd(s0_7, M4(1.043e-02, 3.625e-01, -1.154e-01, 7.974e-02, -1.517e-02, 1.574e-02, 8.566e-02, -8.753e-02, 8.905e-02, 1.145e-01, 7.292e-02, -9.528e-02, -6.925e-02, 4.815e-03, -4.870e-03, 1.570e-02), r);
	r = MulAdd(s0_8, M4(2.513e-01, -1.567e-01, 3.452e-02, -2.177e-01, 4.435e-03, 2.229e-02, -5.694e-02, 3.564e-02, -9.355e-03, -3.216e-03, 3.984e-03, -2.533e-02, 5.015e-03, -4.419e-03, 5.343e-03, -5.821e-02), r);
	r = MulAdd(s1_0, M4(1.183e-02, 2.180e-03, 3.312e-02, 1.897e-02, -9.420e-02, -1.052e-01, -7.984e-02, -8.329e-02, 1.925e-02, -1.752e-02, -6.860e-03, -1.326e-01, -3.338e-02, -2.484e-02, 5.283e-03, -2.789e-03), r);
	r = MulAdd(s1_1, M4(-5.266e-02, -3.840e-03, -5.604e-02, 6.279e-02, 2.299e-01, 1.305e-01, 1.038e-01, -9.023e-02, -6.376e-02, 3.853e-02, 1.382e-01, -3.984e-02, 6.131e-02, 1.529e-03, -2.258e-02, 6.728e-02), r);
	r = MulAdd(s1_2, M4(-2.498e-02, 1.543e-02, 6.288e-03, 1.517e-03, 3.486e-02, 3.774e-02, -2.774e-02, 7.099e-02, 2.514e-02, 9.266e-03, -7.521e-03, 6.476e-03, -6.458e-02, 9.736e-03, 1.127e-02, 7.742e-03), r);
	r = MulAdd(s1_3, M4(-1.946e-02, 9.133e-04, 3.637e-02, -4.983e-02, 9.720e-02, -4.280e-01, -1.311e-01, 2.993e-02, 5.112e-02, -4.233e-02, -6.549e-02, -1.818e-01, 6.990e-03, 1.344e-02, -5.027e-02, 1.111e-01), r);
	r = MulAdd(s1_4, M4(-3.156e-02, -8.842e-02, -2.152e-01, 5.452e-03, 1.343e-01, 4.848e-01, 2.658e-01, -8.968e-03, 4.181e-02, -3.102e-02, 4.729e-01, 2.922e-01, 1.338e-01, -1.812e-02, 1.293e-02, -2.395e-01), r);
	r = MulAdd(s1_5, M4(8.511e-02, -2.497e-02, -6.139e-03, 6.542e-02, 2.345e-01, 4.880e-02, -1.407e-01, 5.752e-02, 5.268e-02, 1.468e-02, 1.387e-02, 3.528e-02, -1.074e-01, 1.000e-02, 8.326e-02, 6.166e-02), r);
	r = MulAdd(s1_6, M4(-7.543e-03, -3.122e-02, 1.798e-02, 2.674e-02, -1.737e-02, -2.950e-01, -5.185e-02, 1.724e-01, -1.144e-02, -4.360e-02, -2.832e-02, -3.791e-02, 4.188e-03, -1.949e-02, 3.661e-03, 1.626e-02), r);
	r = MulAdd(s1_7, M4(-2.500e-02, 3.936e-02, -7.625e-02, -1.774e-04, -1.588e-01, 2.302e-02, 8.201e-02, -5.263e-02, -1.705e-02, 3.713e-02, 1.013e-01, -9.792e-02, 1.231e-03, 3.596e-02, -5.049e-02, 4.461e-02), r);
	r = MulAdd(s1_8, M4(-1.184e-02, -1.957e-02, -6.394e-02, -7.422e-03, 3.436e-02, -4.979e-02, -6.860e-02, 5.641e-02, -5.356e-02, -8.266e-03, 3.798e-02, 1.110e-03, 6.696e-02, 2.150e-02, 3.553e-03, -2.353e-02), r);
	r = MulAdd(s2_0, M4(-2.568e-02, 5.060e-02, 4.885e-02, -6.251e-02, -1.792e-01, -4.927e-02, -3.191e-03, -7.133e-04, 2.122e-02, 2.619e-01, -4.819e-02, -1.790e-02, 4.136e-02, 5.090e-02, 6.009e-02, 6.033e-02), r);
	r = MulAdd(s2_1, M4(6.606e-02, -3.492e-02, -6.592e-02, -7.088e-02, -4.980e-03, -1.418e-01, -1.253e-01, -1.462e-02, -1.838e-02, 1.042e-01, 9.550e-02, -1.567e-01, -3.643e-02, -4.484e-02, 3.174e-03, -1.487e-01), r);
	r = MulAdd(s2_2, M4(9.162e-02, 1.759e-02, -8.418e-02, -1.465e-02, -2.496e-02, -1.225e-02, -2.968e-02, -2.787e-02, 4.041e-03, -4.790e-03, -6.679e-02, 7.165e-03, -3.727e-02, 3.796e-02, 3.822e-02, 8.043e-03), r);
	r = MulAdd(s2_3, M4(1.837e-03, -1.714e-01, -6.961e-02, 1.382e-01, 5.682e-02, -4.873e-01, -3.312e-02, 5.158e-01, 1.352e-01, -1.975e-01, 1.597e-02, 6.544e-02, -3.329e-02, -3.234e-02, 5.270e-03, -1.502e-01), r);
	r = MulAdd(s2_4, M4(-5.789e-02, -7.730e-02, 6.364e-02, 5.596e-03, -2.386e-01, -5.458e-02, 8.180e-02, 2.441e-02, 6.474e-02, 5.300e-01, -4.721e-01, -3.701e-02, 2.024e-01, 1.321e-02, -9.498e-02, 4.516e-01), r);
	r = MulAdd(s2_5, M4(2.882e-02, -2.058e-02, -1.082e-01, -6.370e-02, 1.480e-01, 1.513e-02, -1.423e-01, 2.692e-02, 2.782e-02, 7.790e-02, -1.576e-02, -8.523e-02, 2.453e-01, 6.333e-04, 8.954e-02, 2.339e-01), r);
	r = MulAdd(s2_6, M4(4.058e-03, 2.871e-02, 1.125e-02, 5.663e-03, 2.601e-02, 6.732e-02, 1.797e-02, -3.068e-02, -2.809e-02, -5.919e-03, 4.540e-02, 2.821e-03, -7.565e-03, 4.519e-02, 2.327e-02, -3.882e-02), r);
	r = MulAdd(s2_7, M4(-2.998e-02, -6.281e-02, 2.913e-02, -2.864e-02, -6.257e-02, 7.332e-02, 5.505e-04, 1.016e-01, -1.131e-01, -6.519e-02, -1.234e-01, 8.235e-02, -2.776e-02, -4.644e-02, -6.901e-02, 1.809e-02), r);
	r = MulAdd(s2_8, M4(-2.236e-02, -9.187e-03, -1.409e-01, 4.984e-02, 2.245e-02, 1.562e-02, -1.853e-02, -5.231e-02, 3.672e-02, -2.155e-02, -5.280e-02, 3.258e-03, 2.879e-02, 7.168e-02, 4.822e-02, -5.377e-02), r);
	r = MulAdd(s3_0, M4(1.415e-02, 1.026e-01, 1.554e-01, 1.670e-02, 3.504e-02, 3.557e-02, 4.013e-02, 8.621e-02, -1.502e-02, 7.253e-03, -1.344e-02, -5.635e-02, 1.603e-02, 2.626e-02, 2.599e-02, 1.666e-03), r);
	r = MulAdd(s3_1, M4(-3.214e-02, -1.573e-01, 1.001e-01, -1.588e-01, 5.839e-02, -4.139e-02, 3.952e-02, -1.764e-02, 1.964e-02, -1.310e-02, 6.175e-03, -4.100e-02, -1.181e-02, -7.760e-02, -3.020e-02, 7.317e-04), r);
	r = MulAdd(s3_2, M4(-1.052e-01, -3.080e-02, 3.791e-04, -3.890e-02, 6.022e-02, -4.121e-03, -1.037e-01, -2.708e-02, 1.788e-02, -4.931e-03, -3.259e-02, -2.086e-02, -3.673e-02, 4.576e-02, 5.512e-02, 1.266e-02), r);
	r = MulAdd(s3_3, M4(-1.639e-01, -2.842e-01, -8.190e-02, 3.341e-02, 4.371e-02, -3.729e-02, -1.062e-01, 5.776e-02, -9.976e-02, 1.355e-01, 3.865e-02, -2.485e-01, 3.205e-02, -9.464e-02, -3.115e-02, 7.982e-02), r);
	r = MulAdd(s3_4, M4(2.411e-01, -1.693e-01, 7.569e-01, -3.759e-01, -5.648e-01, 1.042e-01, 4.819e-01, 3.628e-03, 5.672e-01, 2.590e-01, -2.252e-01, 1.947e-01, 1.242e-01, 1.440e-01, 8.207e-02, 3.523e-01), r);
	r = MulAdd(s3_5, M4(3.972e-01, -5.478e-02, -2.617e-01, 1.363e-01, 6.289e-02, 8.769e-03, -1.476e-01, 3.871e-02, 1.088e-01, 2.484e-02, -4.114e-02, -4.563e-02, 1.680e-01, 8.067e-02, 1.434e-01, 3.357e-02), r);
	r = MulAdd(s3_6, M4(-1.022e-02, -5.556e-02, -3.107e-02, 4.839e-02, 1.079e-02, 1.388e-01, 2.482e-02, -1.166e-01, -5.799e-02, -3.306e-02, 6.809e-02, -6.095e-02, -4.195e-03, 6.835e-03, -1.020e-03, 1.108e-01), r);
	r = MulAdd(s3_7, M4(-1.105e-01, 2.145e-02, -4.958e-02, 1.012e-01, -3.125e-02, -2.931e-02, 3.629e-02, 1.651e-01, -6.673e-02, 1.906e-02, -6.683e-02, 6.445e-02, -4.213e-02, -2.649e-02, -3.545e-02, 1.384e-01), r);
	r = MulAdd(s3_8, M4(-1.362e-02, -2.108e-02, -1.410e-01, 9.828e-02, -1.097e-02, 2.497e-02, -9.738e-02, 1.768e-02, 5.047e-02, 3.760e-02, -7.576e-02, 2.529e-03, 8.835e-02, -2.202e-01, -1.604e-02, 4.994e-03), r);
	return r;
}

void Pass8(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t2[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t3[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 9
//!DESC conv8
//!BLOCK_SIZE 8
//!NUM_THREADS 64
//!IN t2, t3
//!OUT t0, t1

#define l0(x, y) V4(O(t2, float2(x, y)))
#define l1(x, y) V4(O(t3, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 7.492e-03, 1.996e-03, 3.514e-04, -9.678e-04 };
	r = MulAdd(s0_0, M4(4.333e-02, -2.234e-02, 4.223e-03, -2.379e-02, 4.428e-02, -4.734e-03, -1.071e-03, 9.366e-03, -2.942e-01, 1.902e-01, -1.446e-01, -5.203e-02, -8.944e-02, -3.073e-02, -2.361e-02, 3.757e-02), r);
	r = MulAdd(s0_1, M4(-9.616e-02, -6.887e-02, 1.052e-01, -4.074e-02, -1.591e-02, 5.493e-02, -2.139e-03, -3.894e-02, -1.097e-01, 4.568e-02, -7.025e-02, -2.882e-02, -6.000e-02, 2.235e-02, -5.432e-02, 5.809e-03), r);
	r = MulAdd(s0_2, M4(-1.222e-02, 5.753e-02, 1.194e-01, -2.727e-02, -2.105e-02, 2.036e-02, -8.233e-02, -1.205e-02, -5.085e-02, -6.829e-03, -9.941e-03, -1.337e-02, 7.795e-02, -5.759e-02, 5.618e-02, -9.238e-03), r);
	r = MulAdd(s0_3, M4(1.324e-01, -1.185e-01, 3.684e-03, 2.976e-02, 1.356e-01, -1.205e-01, -1.850e-02, -2.291e-02, -1.569e-01, 4.140e-01, 2.106e-01, -7.525e-01, 1.914e-02, 2.863e-02, -1.284e-02, -1.043e-01), r);
	r = MulAdd(s0_4, M4(-1.022e-01, 2.592e-02, -1.560e-01, -6.939e-01, -1.890e-01, -3.180e-02, 8.099e-02, 8.758e-02, 5.179e-02, 1.440e-01, 1.557e-01, 6.581e-02, 6.784e-02, 2.236e-01, 7.923e-02, 1.808e-01), r);
	r = MulAdd(s0_5, M4(-9.244e-02, -3.930e-02, 1.281e-01, 3.306e-02, -8.861e-02, 1.411e-01, 1.488e-01, 4.144e-02, 8.077e-03, 5.162e-02, 5.214e-02, 6.791e-03, 5.626e-02, -7.312e-02, -8.413e-02, 2.335e-02), r);
	r = MulAdd(s0_6, M4(-3.044e-02, 1.477e-02, 1.234e-02, 1.927e-02, 4.953e-02, -7.250e-02, 4.041e-02, -3.293e-02, 1.257e-01, -6.445e-02, 5.049e-02, -1.587e-01, 6.960e-02, -1.008e-01, -1.715e-02, 1.055e-01), r);
	r = MulAdd(s0_7, M4(1.099e-01, 4.099e-02, -4.497e-02, 1.613e-02, 1.081e-01, -5.289e-02, 7.797e-03, -8.610e-02, 1.004e-01, 2.457e-02, -9.614e-02, 2.222e-04, -1.304e-01, -6.372e-02, 1.048e-01, 7.533e-02), r);
	r = MulAdd(s0_8, M4(-6.962e-02, -9.348e-03, 1.754e-03, -1.924e-03, -6.750e-02, 8.346e-02, -3.537e-02, 2.726e-02, -1.512e-02, 1.457e-03, 5.397e-04, 3.160e-03, 3.225e-03, -2.205e-02, 3.784e-03, -6.457e-02), r);
	r = MulAdd(s1_0, M4(3.216e-03, -2.588e-02, -3.591e-03, 2.124e-02, 5.857e-02, -4.599e-02, 2.350e-02, -5.599e-03, -7.461e-02, 1.149e-02, -5.752e-03, -1.405e-02, -8.179e-02, -1.131e-02, -6.390e-04, -2.175e-02), r);
	r = MulAdd(s1_1, M4(-4.224e-02, 1.465e-01, 2.090e-01, -7.787e-02, 3.813e-02, 6.197e-03, -2.953e-03, -5.295e-03, -1.369e-01, 1.265e-01, -8.472e-02, -1.717e-02, -8.354e-02, 6.081e-02, -1.704e-02, -2.941e-02), r);
	r = MulAdd(s1_2, M4(5.532e-02, 4.211e-02, 1.382e-01, -1.554e-02, -3.309e-02, -1.236e-02, -5.637e-02, -9.740e-03, 3.499e-02, -1.187e-03, 2.183e-02, -4.328e-03, 3.071e-02, 6.290e-03, -3.430e-02, 1.809e-02), r);
	r = MulAdd(s1_3, M4(3.097e-01, -9.147e-02, 5.491e-02, -2.231e-01, 3.357e-02, -1.675e-01, -3.862e-02, -3.948e-02, -9.614e-02, 2.037e-01, -8.482e-02, 1.575e-01, -2.503e-01, 4.100e-02, 4.688e-02, -5.487e-02), r);
	r = MulAdd(s1_4, M4(-9.200e-01, 2.786e-01, -1.781e-01, -1.025e-01, -3.880e-01, 2.259e-01, -5.413e-02, 1.069e-01, -1.934e-01, 6.803e-02, 1.450e-01, 1.164e-02, -1.011e-01, 4.287e-01, 1.492e-02, 1.877e-01), r);
	r = MulAdd(s1_5, M4(2.170e-03, -5.988e-02, 1.469e-01, 8.258e-02, 7.155e-02, 5.736e-02, 2.247e-02, 2.306e-02, -2.195e-02, 6.195e-02, -3.267e-02, 6.251e-02, 1.084e-01, -5.883e-02, 1.627e-02, -2.231e-04), r);
	r = MulAdd(s1_6, M4(-2.249e-02, -2.655e-02, 5.447e-03, 1.252e-01, 2.021e-02, -3.117e-02, 1.387e-03, -3.282e-02, -3.373e-02, 1.007e-02, 8.572e-03, -4.438e-03, 3.576e-02, -2.237e-02, -8.820e-02, 7.987e-02), r);
	r = MulAdd(s1_7, M4(5.065e-02, 2.282e-02, -9.641e-02, 6.878e-03, 6.660e-01, 2.497e-02, -1.353e-01, -1.281e-01, 1.927e-02, -6.053e-03, 4.760e-03, -1.569e-02, -8.824e-02, -1.988e-02, -5.204e-03, 9.302e-02), r);
	r = MulAdd(s1_8, M4(-1.142e-01, -2.133e-02, -5.409e-02, -1.691e-02, -1.052e-01, 6.282e-02, -1.763e-01, 7.171e-03, -5.642e-04, 5.445e-03, -2.252e-02, -8.101e-03, -7.578e-02, -1.884e-02, 4.234e-02, -4.051e-02), r);
	r = MulAdd(s2_0, M4(-3.340e-02, -9.286e-02, -2.409e-02, 5.065e-02, 1.146e-01, -3.051e-02, -5.897e-02, 1.339e-01, -1.820e-01, -8.258e-02, 7.841e-02, -4.576e-03, -2.235e-02, -2.630e-03, -2.450e-02, 1.445e-03), r);
	r = MulAdd(s2_1, M4(3.666e-02, -1.334e-01, 1.470e-01, -2.621e-04, 1.844e-02, 2.054e-02, -1.071e-01, 1.125e-01, -9.043e-02, -3.179e-02, -1.576e-01, 4.819e-03, -1.119e-01, 3.672e-02, -1.960e-02, -2.050e-02), r);
	r = MulAdd(s2_2, M4(-4.321e-02, 1.305e-03, -8.030e-03, 1.275e-02, -2.368e-02, -8.649e-02, 2.123e-01, -2.892e-02, -2.245e-02, -2.036e-02, 5.714e-02, -2.304e-02, 7.935e-02, 2.948e-02, 4.653e-02, 2.831e-02), r);
	r = MulAdd(s2_3, M4(3.771e-02, 2.739e-02, -5.543e-02, -7.737e-02, 1.401e-01, -8.111e-02, -5.889e-02, -9.849e-02, 6.609e-02, -1.088e+00, -3.718e-01, 8.566e-01, -3.921e-02, -1.169e-02, 3.725e-02, 1.351e-02), r);
	r = MulAdd(s2_4, M4(4.463e-02, -4.023e-01, 9.789e-02, -1.354e-02, -3.505e-01, 6.620e-02, 2.244e-01, -1.811e-01, 1.546e-01, 1.551e-01, 5.571e-01, -8.024e-02, 2.007e-01, -2.899e-02, 8.322e-02, 2.466e-02), r);
	r = MulAdd(s2_5, M4(-8.966e-02, 9.537e-03, 1.072e-02, -2.888e-02, -9.071e-02, -2.265e-02, 1.060e-01, 2.784e-02, 2.326e-02, 2.158e-02, -1.252e-02, 4.109e-02, -9.991e-02, 2.266e-02, 1.081e-01, -3.239e-02), r);
	r = MulAdd(s2_6, M4(7.485e-02, -5.121e-02, -7.197e-03, 2.364e-02, 2.601e-02, -3.873e-02, -3.163e-02, 6.095e-03, 1.731e-01, 1.597e-01, -2.013e-01, -1.612e-01, -3.529e-02, 4.730e-02, 3.587e-03, -4.909e-02), r);
	r = MulAdd(s2_7, M4(-2.002e-01, -1.274e-01, 3.759e-02, -7.192e-02, 4.936e-02, 6.713e-03, -9.731e-02, -1.581e-02, 2.900e-01, 2.825e-03, -1.856e-03, 1.151e-01, 4.926e-02, -8.486e-02, 6.889e-02, -7.680e-02), r);
	r = MulAdd(s2_8, M4(2.897e-02, 1.246e-02, 5.703e-02, 3.133e-02, -5.819e-02, 3.870e-02, 2.343e-02, 2.062e-02, -3.449e-02, -1.748e-03, -3.243e-03, 7.889e-03, -3.119e-02, 2.583e-02, 2.955e-02, 2.239e-02), r);
	r = MulAdd(s3_0, M4(-6.212e-02, -2.815e-02, 3.233e-02, 1.243e-02, -7.495e-02, 5.928e-02, -1.435e-02, -3.235e-02, -4.753e-02, -8.307e-02, -6.735e-03, 2.073e-02, 3.210e-02, -1.466e-02, -3.795e-03, -7.752e-03), r);
	r = MulAdd(s3_1, M4(8.327e-02, -6.238e-02, 8.281e-02, 1.640e-02, -2.766e-02, 1.126e-01, -1.703e-01, 5.964e-02, -6.483e-02, -1.239e-01, 9.791e-02, -5.774e-02, -4.405e-02, -1.194e-01, 1.150e-01, 8.248e-03), r);
	r = MulAdd(s3_2, M4(-2.417e-02, -2.032e-03, -2.130e-02, 3.247e-03, 2.558e-02, 9.621e-03, 2.894e-03, 1.745e-02, -3.345e-03, 2.472e-02, 4.561e-02, 1.091e-04, -9.694e-02, 7.448e-02, 1.977e-02, -2.252e-02), r);
	r = MulAdd(s3_3, M4(4.710e-02, 1.175e-01, -5.456e-02, 2.405e-02, -5.599e-02, 5.930e-02, 1.394e-02, -1.948e-01, 9.356e-02, 4.988e-03, -3.550e-02, 2.115e-02, 3.579e-02, 2.519e-03, 3.458e-02, 1.284e-02), r);
	r = MulAdd(s3_4, M4(-1.539e-01, -2.812e-01, -1.729e-01, 3.786e-02, -7.088e-02, 9.694e-02, -3.798e-02, -2.858e-01, 2.162e-01, 2.841e-01, 6.325e-02, 8.461e-02, -1.131e-02, -4.421e-01, -7.511e-02, -1.567e-01), r);
	r = MulAdd(s3_5, M4(-5.525e-02, 9.872e-03, 1.520e-02, -1.043e-02, -1.261e-01, 5.960e-02, -1.696e-01, 1.084e-02, 4.916e-04, -4.675e-02, 4.176e-02, -1.421e-02, -4.200e-03, 5.236e-02, 4.528e-01, -1.819e-02), r);
	r = MulAdd(s3_6, M4(5.756e-02, -5.624e-02, -1.801e-02, 1.356e-01, -2.943e-02, -3.031e-03, 2.097e-02, -2.393e-02, -1.188e-02, 3.476e-02, -8.038e-02, -2.493e-02, -7.363e-02, 9.841e-02, 2.800e-02, -4.719e-02), r);
	r = MulAdd(s3_7, M4(-1.646e-01, -1.462e-01, 4.622e-02, -1.341e-01, 7.500e-02, 9.408e-03, -3.332e-02, -9.753e-02, -1.242e-01, -5.388e-02, 8.329e-06, -8.211e-02, 2.022e-02, -1.792e-01, 2.668e-01, -1.639e-01), r);
	r = MulAdd(s3_8, M4(-5.759e-02, 2.412e-02, -7.751e-03, 5.953e-02, -3.042e-03, 7.494e-02, -7.015e-02, 8.802e-03, 6.651e-02, 2.193e-02, 5.734e-03, 9.387e-04, 8.776e-03, -3.649e-02, -5.357e-02, 2.643e-02), r);
	return r;
}

V4 f1(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { 1.021e-04, 2.892e-03, 4.075e-03, -4.598e-04 };
	r = MulAdd(s0_0, M4(-4.857e-03, 1.681e-02, 1.594e-02, 1.186e-02, 9.703e-03, 1.481e-02, 2.224e-02, -1.211e-02, -3.463e-02, 2.229e-01, -4.089e-02, -2.937e-02, -3.930e-02, -4.065e-02, -5.603e-02, 4.334e-03), r);
	r = MulAdd(s0_1, M4(1.133e-01, -8.282e-02, -1.479e-01, 2.685e-02, -5.441e-02, 5.083e-02, 1.999e-02, -9.091e-03, 1.051e-01, -2.878e-03, 3.581e-02, -1.914e-01, 6.339e-02, 4.883e-02, 8.196e-02, -1.849e-02), r);
	r = MulAdd(s0_2, M4(-1.835e-02, 4.866e-03, -1.972e-02, -5.721e-02, 3.678e-02, 7.178e-03, 4.936e-02, 1.327e-02, 7.159e-03, 1.530e-02, 9.492e-03, -2.915e-02, -3.703e-02, 3.455e-02, 4.313e-02, -7.483e-03), r);
	r = MulAdd(s0_3, M4(4.954e-02, -3.734e-02, 1.704e-01, -9.261e-02, 4.356e-02, 4.334e-02, 1.375e-01, -6.750e-02, 1.645e-01, 3.545e-01, -1.076e-01, -2.754e-01, -8.735e-03, 8.428e-02, -2.600e-02, 5.157e-02), r);
	r = MulAdd(s0_4, M4(-1.529e-01, 6.132e-02, 5.269e-01, 2.303e-01, 3.777e-02, -3.362e-02, -1.288e-01, 3.253e-02, -2.453e-03, -1.311e-01, -1.811e-01, 5.146e-01, 1.360e-01, -1.568e-01, 3.541e-01, -4.269e-01), r);
	r = MulAdd(s0_5, M4(1.203e-01, 2.272e-02, 4.602e-02, -4.652e-02, 4.838e-02, -1.423e-01, -4.015e-02, 2.329e-01, 2.563e-02, 4.549e-03, -6.325e-03, 1.033e-01, -1.185e-01, -1.229e-03, -1.781e-03, 4.882e-02), r);
	r = MulAdd(s0_6, M4(-1.493e-03, -5.072e-04, -7.398e-02, -4.071e-03, 1.147e-02, 7.946e-02, 3.359e-02, -6.394e-02, 3.505e-02, 2.111e-01, 1.077e-01, -9.330e-02, 2.340e-02, 1.186e-02, 1.139e-01, -2.444e-03), r);
	r = MulAdd(s0_7, M4(-5.860e-03, -1.587e-02, -7.634e-02, 6.287e-03, 7.103e-02, 1.223e-01, 1.770e-01, -6.041e-02, -3.422e-02, -8.480e-03, 6.146e-02, 5.680e-02, 6.599e-03, -6.543e-02, -6.087e-02, -1.182e-01), r);
	r = MulAdd(s0_8, M4(-3.065e-03, -2.381e-02, 1.076e-03, 4.174e-02, -1.275e-02, -8.464e-02, -1.656e-02, 1.118e-01, -5.084e-03, -1.276e-02, 1.028e-02, -2.447e-02, 2.944e-02, 3.333e-02, 1.571e-02, -4.768e-02), r);
	r = MulAdd(s1_0, M4(1.033e-02, -1.755e-02, -6.591e-02, -2.916e-03, 5.268e-02, -1.639e-02, 3.173e-02, -3.870e-02, -1.196e-02, -5.798e-02, -6.512e-02, 6.685e-02, 1.077e-01, -1.033e-01, -6.763e-02, 6.647e-03), r);
	r = MulAdd(s1_1, M4(4.385e-01, -5.927e-02, -3.308e-01, 1.535e-01, -5.186e-02, 9.066e-02, 5.980e-02, -5.399e-02, -1.484e-03, 1.159e-01, 1.228e-01, -4.994e-02, 4.690e-02, -5.008e-02, -4.004e-02, -1.684e-02), r);
	r = MulAdd(s1_2, M4(-4.728e-02, 1.658e-02, -5.943e-02, 2.234e-03, -3.209e-02, 4.928e-03, 3.253e-03, 4.860e-04, 1.285e-02, -1.914e-02, 2.240e-02, 1.305e-02, -5.554e-02, -5.859e-04, -3.260e-03, 8.161e-03), r);
	r = MulAdd(s1_3, M4(1.111e-02, -1.017e-02, 3.942e-01, -2.339e-01, -5.259e-02, -1.509e-01, 9.273e-02, 4.821e-03, 4.431e-02, -2.321e-02, 8.765e-03, 1.174e-01, -1.620e-01, -1.094e-01, -1.112e-01, 1.092e-01), r);
	r = MulAdd(s1_4, M4(-1.112e-01, -3.016e-01, 5.767e-01, 2.991e-01, -2.363e-01, 1.773e-01, 4.842e-02, 1.479e-02, 4.656e-02, -6.919e-02, -1.145e-01, 3.517e-01, 1.694e-01, -1.172e-01, 1.981e-01, -3.146e-01), r);
	r = MulAdd(s1_5, M4(7.860e-02, 1.250e-02, 8.584e-02, 2.115e-02, 4.508e-02, -1.057e-01, 3.477e-02, 1.894e-01, 1.702e-04, -3.281e-02, -4.114e-02, 1.520e-01, -3.739e-02, -2.410e-02, 4.224e-02, 4.905e-02), r);
	r = MulAdd(s1_6, M4(-1.856e-02, -3.141e-02, -1.581e-01, -4.136e-02, -5.412e-02, 2.173e-01, -8.472e-02, 2.157e-02, -1.841e-02, 4.442e-03, -6.516e-02, -2.259e-03, -8.614e-03, -2.194e-02, 4.293e-02, 6.910e-02), r);
	r = MulAdd(s1_7, M4(-6.917e-02, -1.204e-01, -1.636e-01, 1.444e-02, -1.302e-01, 1.454e-01, -1.236e-01, -1.381e-01, -2.625e-02, -1.014e-02, 3.965e-02, 5.456e-02, 1.004e-02, -7.594e-02, -2.646e-02, -8.390e-03), r);
	r = MulAdd(s1_8, M4(-1.214e-02, -1.182e-02, -1.654e-02, 5.613e-02, -4.494e-02, -6.883e-02, -6.759e-02, 1.401e-01, 5.809e-03, -7.901e-03, 2.477e-03, 2.240e-02, 2.892e-02, 2.365e-04, 1.916e-02, -4.855e-02), r);
	r = MulAdd(s2_0, M4(1.165e-02, -3.547e-02, -3.269e-02, 3.278e-02, 1.517e-01, 3.076e-01, 1.321e-01, -7.305e-02, -9.144e-02, -1.188e-01, -8.574e-02, 3.771e-02, 5.090e-02, -3.828e-03, -2.782e-03, 9.980e-03), r);
	r = MulAdd(s2_1, M4(4.990e-02, -1.158e-02, -8.473e-03, -7.378e-02, 2.320e-01, 4.317e-03, -1.275e-01, -7.346e-02, 1.375e-01, -5.503e-02, 2.691e-02, 7.374e-02, -9.075e-02, -9.443e-03, -3.406e-02, -8.131e-03), r);
	r = MulAdd(s2_2, M4(-2.091e-02, 2.630e-02, -1.171e-02, -8.149e-03, -6.488e-02, 3.674e-02, -1.582e-02, 2.703e-02, 1.933e-02, 9.368e-04, -2.847e-03, -6.541e-02, -8.207e-03, -2.102e-03, 5.476e-03, 2.813e-02), r);
	r = MulAdd(s2_3, M4(-7.157e-02, 3.019e-01, 4.938e-02, 1.148e-02, -1.928e-02, 5.004e-02, 1.490e-01, -4.090e-02, -6.051e-01, 1.305e-01, 5.432e-02, 3.124e-01, -4.909e-03, 4.734e-03, -4.112e-02, 2.852e-02), r);
	r = MulAdd(s2_4, M4(-6.570e-02, -1.792e-01, -3.370e-01, -1.151e-01, -1.800e-01, -4.234e-01, 2.290e-01, -1.410e-01, -1.107e-01, -3.994e-01, -6.890e-02, 1.616e-01, 2.725e-01, -1.534e-01, 1.134e-02, -1.122e-01), r);
	r = MulAdd(s2_5, M4(2.107e-02, 7.061e-02, -3.419e-02, -7.876e-02, 1.059e-01, 2.269e-02, 3.643e-02, -9.355e-02, 2.354e-02, -2.920e-02, -1.486e-02, 6.596e-02, 1.459e-01, -7.315e-02, 1.001e-02, -1.196e-01), r);
	r = MulAdd(s2_6, M4(7.558e-03, -5.529e-02, 2.896e-02, -5.776e-02, 4.176e-03, 2.669e-02, 8.191e-03, -1.173e-02, -8.356e-04, 2.705e-01, 2.322e-02, 1.236e-01, -1.824e-03, -9.138e-03, 5.993e-03, 2.423e-02), r);
	r = MulAdd(s2_7, M4(2.899e-03, 4.622e-02, 1.248e-01, 5.803e-02, 2.360e-03, 1.574e-02, 9.107e-03, 2.627e-02, 2.870e-03, 1.155e-01, 2.568e-01, 1.185e-01, -1.852e-02, 7.471e-02, 1.442e-01, 4.149e-03), r);
	r = MulAdd(s2_8, M4(2.587e-02, 2.002e-02, 1.244e-02, -7.156e-02, -2.962e-03, -4.371e-02, 9.750e-05, 2.554e-02, 1.524e-02, -3.555e-02, 3.165e-02, -1.252e-01, 7.889e-03, -2.808e-02, -2.502e-02, -9.080e-02), r);
	r = MulAdd(s3_0, M4(-5.464e-02, -9.380e-02, -9.031e-02, 6.067e-02, 1.637e-02, -4.678e-02, -6.354e-02, 2.757e-02, -3.534e-02, -7.544e-02, -4.711e-02, -1.170e-02, -2.121e-02, 6.766e-02, 1.143e-02, -1.352e-02), r);
	r = MulAdd(s3_1, M4(6.666e-02, -3.601e-02, -1.621e-02, 1.027e-02, -7.539e-02, 6.818e-02, 9.687e-02, 8.166e-03, 1.209e-01, -7.593e-02, -6.114e-02, -1.871e-02, -4.486e-03, -4.191e-02, -3.624e-02, -6.917e-02), r);
	r = MulAdd(s3_2, M4(1.685e-03, 1.879e-02, -1.085e-02, -1.463e-02, -2.649e-02, -2.843e-02, -5.443e-02, 1.182e-01, -4.538e-02, 1.604e-02, -1.214e-02, -3.780e-02, 7.448e-02, 4.743e-02, 1.960e-02, -2.091e-02), r);
	r = MulAdd(s3_3, M4(1.581e-03, 4.307e-01, 2.725e-02, -6.223e-03, -1.649e-02, -9.806e-02, -4.996e-02, 5.188e-02, -1.004e-01, 3.665e-01, 6.566e-02, -1.778e-02, 6.244e-02, -8.677e-02, 6.811e-02, -7.358e-02), r);
	r = MulAdd(s3_4, M4(-1.159e-01, -2.202e-01, -4.450e-01, -1.843e-01, -2.163e-01, -5.406e-01, -1.782e-02, 3.599e-02, 4.676e-02, -2.842e-01, 2.868e-02, -3.187e-02, 5.708e-01, -4.671e-01, 2.904e-01, 7.765e-02), r);
	r = MulAdd(s3_5, M4(1.722e-02, 6.820e-02, -2.501e-02, 2.062e-02, 7.785e-02, 3.089e-02, -1.011e-01, 7.250e-02, 1.777e-02, 2.478e-02, 2.426e-02, -1.451e-03, -3.446e-02, -2.670e-02, 2.924e-02, -3.201e-02), r);
	r = MulAdd(s3_6, M4(1.407e-02, -6.091e-02, 9.407e-03, -4.578e-02, -1.060e-02, 4.716e-03, 1.340e-02, 9.612e-03, -4.227e-02, -1.122e-01, -5.321e-02, 5.625e-02, 2.228e-02, 6.253e-03, -6.240e-02, -3.802e-03), r);
	r = MulAdd(s3_7, M4(-1.704e-02, -4.713e-03, 7.542e-02, -7.843e-03, -3.427e-02, 6.325e-03, 1.225e-02, 1.093e-02, 1.470e-02, 8.228e-02, 7.090e-02, 4.060e-02, -1.906e-02, 5.804e-02, 1.348e-01, -7.307e-02), r);
	r = MulAdd(s3_8, M4(1.539e-02, 2.190e-03, -2.100e-02, -2.839e-02, 4.166e-03, -1.752e-02, -2.224e-02, 4.517e-02, -2.712e-02, -1.329e-02, -2.822e-02, -1.040e-02, 2.914e-02, -1.207e-02, -4.796e-02, -6.910e-02), r);
	return r;
}

void Pass9(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = Rmp8x8(tid.x) + blockStart;
	uint2 size = GetInputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = (gxy + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	t0[gxy] = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
	t1[gxy] = f1(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);
}

//!PASS 10
//!DESC out-shuffle
//!BLOCK_SIZE 16
//!NUM_THREADS 64
//!IN INPUT, t0, t1
//!OUT OUTPUT

#define l0(x, y) V4(O(t0, float2(x, y)))
#define l1(x, y) V4(O(t1, float2(x, y)))

V4 f0(V4 s0_0, V4 s0_1, V4 s0_2, V4 s0_3, V4 s0_4, V4 s0_5, V4 s0_6, V4 s0_7, V4 s0_8, V4 s1_0, V4 s1_1, V4 s1_2, V4 s1_3, V4 s1_4, V4 s1_5, V4 s1_6, V4 s1_7, V4 s1_8, V4 s2_0, V4 s2_1, V4 s2_2, V4 s2_3, V4 s2_4, V4 s2_5, V4 s2_6, V4 s2_7, V4 s2_8, V4 s3_0, V4 s3_1, V4 s3_2, V4 s3_3, V4 s3_4, V4 s3_5, V4 s3_6, V4 s3_7, V4 s3_8) {
	V4 r = { -1.409e-03, -1.878e-03, -5.303e-04, -8.141e-04 };
	r = MulAdd(s0_0, M4(2.098e-02, -9.305e-03, -8.033e-03, 3.455e-02, 1.747e-02, -3.697e-02, -1.424e-02, 1.170e-02, -2.027e-02, -5.643e-02, -2.869e-02, -3.308e-02, -1.154e-01, -2.864e-02, -3.009e-02, -1.849e-02), r);
	r = MulAdd(s0_1, M4(-2.191e-02, 7.817e-02, -1.705e-02, -2.475e-03, -2.317e-01, -3.827e-02, -4.318e-04, -7.348e-02, -3.294e-02, -1.082e-01, 2.578e-02, -3.462e-02, -7.983e-02, -2.407e-01, -8.092e-03, -3.626e-02), r);
	r = MulAdd(s0_2, M4(-1.301e-02, -3.897e-02, -6.300e-03, -1.383e-02, 2.743e-02, -4.224e-02, 5.535e-03, -1.838e-02, 9.344e-03, 1.156e-02, -5.436e-03, 1.041e-02, -7.606e-02, -2.449e-02, -2.023e-02, 2.329e-02), r);
	r = MulAdd(s0_3, M4(2.784e-01, 9.384e-02, 1.126e-01, -1.144e-01, 1.104e-01, -3.075e-03, 2.114e-01, -4.576e-02, 2.271e-01, 5.360e-02, -2.026e-02, 2.571e-01, 1.023e-01, -2.406e-02, 3.613e-02, 2.313e-02), r);
	r = MulAdd(s0_4, M4(1.481e-01, 1.487e-01, 3.646e-02, 1.608e-01, -5.368e-01, 7.939e-01, -8.009e-01, 7.326e-01, -8.184e-02, 7.780e-02, 2.823e-02, 1.723e-02, 3.261e-02, 7.264e-02, 4.906e-01, -7.881e-02), r);
	r = MulAdd(s0_5, M4(1.893e-02, 2.051e-02, -1.583e-02, -1.434e-02, -3.022e-02, -5.953e-02, 4.948e-02, -6.243e-02, 1.064e-02, 9.555e-03, 9.215e-03, 2.395e-03, -1.879e-02, -5.293e-02, -6.218e-02, 1.880e-01), r);
	r = MulAdd(s0_6, M4(-1.623e-02, -9.043e-03, 8.706e-02, -2.571e-02, 4.310e-03, 1.182e-02, 2.041e-02, 5.692e-02, -2.960e-02, -2.983e-03, 4.222e-02, -6.760e-02, -7.396e-03, 5.672e-03, -7.944e-03, 4.287e-02), r);
	r = MulAdd(s0_7, M4(-2.240e-02, -1.813e-02, 5.106e-02, 3.940e-02, -2.053e-03, 4.609e-03, -7.422e-02, 1.510e-01, -1.863e-02, -1.240e-02, -4.103e-02, 4.553e-02, -1.829e-02, -7.566e-03, 1.359e-03, -3.670e-02), r);
	r = MulAdd(s0_8, M4(-5.476e-03, -1.114e-02, -4.037e-03, -2.126e-03, 2.712e-02, 1.440e-02, 2.411e-02, 2.362e-02, -5.747e-03, -5.246e-03, 1.138e-02, -1.869e-02, 1.133e-03, -4.128e-03, -5.698e-03, 7.431e-04), r);
	r = MulAdd(s1_0, M4(-2.053e-02, -5.708e-02, 1.294e-01, -1.091e-02, -5.203e-03, -1.339e-02, -2.457e-02, 9.190e-03, -1.666e-01, -1.923e-02, 2.214e-02, -2.020e-02, -8.115e-02, -3.013e-02, -4.038e-02, -3.056e-02), r);
	r = MulAdd(s1_1, M4(-2.557e-01, 5.294e-01, -1.299e-01, -1.493e-01, -1.234e-01, -1.255e-01, 2.948e-03, -4.235e-02, 3.493e-02, -1.870e-01, -2.104e-03, -4.000e-02, -3.905e-02, -2.193e-01, -2.203e-02, -9.760e-03), r);
	r = MulAdd(s1_2, M4(1.733e-02, -7.787e-02, -6.604e-03, 6.678e-03, 7.696e-03, -2.369e-02, -6.539e-04, -1.102e-02, -1.193e-03, 1.231e-02, -1.389e-03, -9.574e-03, -5.801e-02, -2.889e-02, -2.686e-03, 1.507e-02), r);
	r = MulAdd(s1_3, M4(2.792e-01, 9.448e-02, 3.361e-02, -5.689e-02, 1.630e-01, 1.120e-02, 1.771e-01, -2.116e-02, 4.607e-01, -2.987e-02, -1.319e-01, 1.699e-01, 1.127e-01, -3.390e-03, 5.671e-02, 8.547e-03), r);
	r = MulAdd(s1_4, M4(1.412e-01, 6.567e-02, 2.311e-01, 1.009e-01, -7.339e-02, 3.683e-01, -2.510e-01, 2.821e-01, -1.446e-01, -1.170e-01, -6.035e-02, 5.471e-01, 1.075e-01, 9.204e-02, 3.083e-01, -4.666e-02), r);
	r = MulAdd(s1_5, M4(4.185e-02, 9.992e-03, -9.781e-03, -1.284e-01, -6.054e-02, -1.004e-01, 3.920e-03, -7.670e-02, 6.425e-03, 1.315e-02, 1.833e-02, -2.078e-02, -4.423e-03, 1.608e-02, -4.473e-02, 1.431e-01), r);
	r = MulAdd(s1_6, M4(-2.035e-02, -1.490e-02, 7.858e-02, -1.677e-02, -1.529e-02, 1.617e-02, 1.892e-02, 6.421e-02, -5.163e-02, -3.004e-04, 4.796e-02, -6.612e-02, -7.339e-03, 3.612e-03, -3.793e-03, 3.967e-02), r);
	r = MulAdd(s1_7, M4(-1.587e-02, 2.826e-03, 4.107e-02, 3.865e-02, 1.741e-03, -8.144e-03, 3.549e-02, 4.874e-02, -1.309e-02, 9.007e-03, -4.065e-02, 1.889e-02, -1.401e-02, -6.740e-03, -8.651e-03, -3.680e-02), r);
	r = MulAdd(s1_8, M4(-3.425e-02, -1.581e-02, 2.079e-03, 9.678e-03, 1.536e-02, 1.254e-02, -6.491e-03, 1.337e-02, -6.457e-03, -4.502e-03, 7.601e-03, -2.523e-02, -8.848e-04, -4.491e-03, -1.150e-02, -1.041e-02), r);
	r = MulAdd(s2_0, M4(-1.231e-02, 1.957e-02, -4.860e-03, -3.485e-02, 2.150e-02, 2.795e-02, -8.654e-03, -1.193e-02, -3.417e-03, 1.825e-02, 1.567e-02, -3.503e-02, 1.815e-01, 3.099e-02, -2.550e-02, -7.071e-02), r);
	r = MulAdd(s2_1, M4(4.765e-03, 1.726e-02, -1.563e-02, -3.967e-02, 1.431e-01, 1.655e-01, 8.577e-03, -2.072e-02, -1.189e-01, -1.901e-01, 1.268e-02, -1.182e-02, 1.360e-01, -9.727e-02, 3.545e-02, -3.795e-02), r);
	r = MulAdd(s2_2, M4(-1.629e-02, -2.886e-02, 6.265e-04, -4.466e-03, -9.620e-03, -6.831e-03, -1.007e-03, -1.137e-02, 1.575e-02, -1.520e-02, 3.770e-03, -1.629e-03, 9.599e-03, 1.072e-02, -8.331e-03, -2.625e-03), r);
	r = MulAdd(s2_3, M4(-4.895e-02, -1.444e-02, -1.074e-02, 4.024e-02, -7.837e-02, 7.142e-03, -3.005e-02, 5.887e-02, 4.426e-02, -4.724e-02, 1.118e-01, 1.978e-01, 3.873e-01, -6.170e-02, 5.417e-01, 2.115e-01), r);
	r = MulAdd(s2_4, M4(-4.664e-02, 5.652e-02, 1.062e-01, 7.868e-02, -4.444e-01, -2.378e-01, 2.168e-01, 2.783e-01, 2.544e-01, 2.526e-01, -2.176e-01, -3.524e-01, -1.380e-01, -4.658e-01, 7.754e-02, -5.062e-01), r);
	r = MulAdd(s2_5, M4(3.824e-02, -7.471e-03, -3.021e-02, 2.526e-02, -9.479e-03, -8.237e-02, -1.161e-02, 7.648e-02, -1.067e-01, -1.000e-01, 2.901e-03, -3.454e-02, -2.220e-03, -3.343e-02, 4.048e-03, -1.751e-03), r);
	r = MulAdd(s2_6, M4(1.680e-02, 1.039e-03, 5.104e-02, -1.713e-01, 2.749e-03, 4.469e-03, -4.546e-02, 1.381e-02, -6.014e-03, 1.247e-04, -6.902e-03, 6.958e-02, -5.066e-02, -6.274e-03, 2.876e-02, -1.837e-01), r);
	r = MulAdd(s2_7, M4(1.057e-02, -2.665e-02, 8.209e-02, 2.316e-01, 3.331e-02, 3.507e-03, -1.734e-01, -1.194e-01, -9.633e-03, 4.334e-03, 4.570e-02, -3.032e-02, 1.151e-02, -4.714e-03, -8.234e-03, -2.184e-02), r);
	r = MulAdd(s2_8, M4(2.067e-02, -3.817e-03, -2.124e-02, -3.790e-02, -1.628e-03, 1.466e-02, -1.040e-02, -4.732e-02, 8.216e-03, -3.982e-03, -2.452e-02, 3.031e-03, -3.218e-03, 5.065e-03, -2.036e-02, -4.540e-03), r);
	r = MulAdd(s3_0, M4(-1.121e-02, 6.935e-03, 8.246e-03, -1.607e-02, 4.960e-03, 1.605e-02, 3.055e-03, -1.948e-02, -1.705e-02, 3.543e-02, 3.453e-02, -2.897e-03, 8.019e-02, 1.047e-01, 3.947e-03, -5.653e-02), r);
	r = MulAdd(s3_1, M4(-1.800e-02, -1.445e-02, -1.291e-02, 4.545e-03, 1.890e-01, 1.792e-01, -1.108e-02, -3.760e-02, -5.770e-01, -4.943e-01, 5.098e-01, 2.238e-01, 7.838e-02, 3.965e-02, 2.951e-02, 7.738e-03), r);
	r = MulAdd(s3_2, M4(-3.283e-03, -4.729e-02, -8.269e-03, 1.385e-03, -2.860e-02, -7.765e-02, 4.138e-02, 9.117e-04, -1.147e-02, -2.068e-01, -6.331e-03, 2.325e-01, 1.822e-02, 2.032e-02, -2.723e-03, -8.994e-04), r);
	r = MulAdd(s3_3, M4(-6.536e-03, -3.618e-02, -7.814e-02, 6.080e-02, -6.788e-02, -5.059e-04, -2.543e-02, 5.836e-02, 7.723e-02, -2.090e-02, 1.357e-01, 1.821e-01, 2.609e-01, 1.207e-02, 2.234e-01, 2.822e-01), r);
	r = MulAdd(s3_4, M4(-2.409e-01, 6.348e-01, 3.062e-01, -1.282e-01, -3.467e-01, -1.607e-01, -4.471e-03, 2.832e-01, 2.496e-01, 2.512e-01, -1.490e-01, -2.456e-01, -2.036e-01, -2.331e-01, -5.261e-02, -1.896e-01), r);
	r = MulAdd(s3_5, M4(4.482e-02, -5.530e-02, -2.249e-02, 8.728e-03, 2.920e-01, -4.287e-01, -1.998e-01, 3.981e-01, -8.622e-02, -9.097e-02, -2.153e-02, -2.622e-02, 2.039e-03, -3.998e-02, 1.589e-02, -4.862e-03), r);
	r = MulAdd(s3_6, M4(1.152e-02, -4.285e-02, 1.577e-01, -1.897e-01, -7.030e-03, 3.144e-03, -4.456e-02, 1.236e-02, -6.315e-03, 9.912e-04, -1.745e-02, 6.373e-02, -3.957e-02, -1.127e-02, 2.343e-02, -1.559e-01), r);
	r = MulAdd(s3_7, M4(2.342e-02, -1.236e-02, -6.990e-02, 1.352e-01, 1.165e-02, 3.656e-03, -1.004e-01, -1.514e-01, -1.951e-02, -2.067e-04, 3.870e-02, -4.895e-02, 1.210e-02, -2.797e-03, -5.429e-02, 3.699e-02), r);
	r = MulAdd(s3_8, M4(2.117e-02, 1.253e-02, -2.078e-02, -3.665e-03, -3.600e-02, 1.398e-02, -2.210e-02, -9.164e-02, 8.846e-04, 2.017e-04, -1.795e-02, 1.074e-02, -1.653e-03, 6.362e-03, -7.357e-03, -2.392e-02), r);
	return tanh(r);
}

void Pass10(uint2 blockStart, uint3 tid) {
	float2 pt = float2(GetInputPt());
	uint2 gxy = (Rmp8x8(tid.x) << 1) + blockStart;
	uint2 size = GetOutputSize();
	if (gxy.x >= size.x || gxy.y >= size.y) {
		return;
	}
	float2 pos = ((gxy >> 1) + 0.5) * pt;

	V4 s0_0 = l0(-1.0, -1.0);
	V4 s0_1 = l0(0.0, -1.0);
	V4 s0_2 = l0(1.0, -1.0);
	V4 s0_3 = l0(-1.0, 0.0);
	V4 s0_4 = l0(0.0, 0.0);
	V4 s0_5 = l0(1.0, 0.0);
	V4 s0_6 = l0(-1.0, 1.0);
	V4 s0_7 = l0(0.0, 1.0);
	V4 s0_8 = l0(1.0, 1.0);
	V4 s1_0 = -max(-s0_0, 0.0);
	V4 s1_1 = -max(-s0_1, 0.0);
	V4 s1_2 = -max(-s0_2, 0.0);
	V4 s1_3 = -max(-s0_3, 0.0);
	V4 s1_4 = -max(-s0_4, 0.0);
	V4 s1_5 = -max(-s0_5, 0.0);
	V4 s1_6 = -max(-s0_6, 0.0);
	V4 s1_7 = -max(-s0_7, 0.0);
	V4 s1_8 = -max(-s0_8, 0.0);
	s0_0 = max(s0_0, 0.0);
	s0_1 = max(s0_1, 0.0);
	s0_2 = max(s0_2, 0.0);
	s0_3 = max(s0_3, 0.0);
	s0_4 = max(s0_4, 0.0);
	s0_5 = max(s0_5, 0.0);
	s0_6 = max(s0_6, 0.0);
	s0_7 = max(s0_7, 0.0);
	s0_8 = max(s0_8, 0.0);

	V4 s2_0 = l1(-1.0, -1.0);
	V4 s2_1 = l1(0.0, -1.0);
	V4 s2_2 = l1(1.0, -1.0);
	V4 s2_3 = l1(-1.0, 0.0);
	V4 s2_4 = l1(0.0, 0.0);
	V4 s2_5 = l1(1.0, 0.0);
	V4 s2_6 = l1(-1.0, 1.0);
	V4 s2_7 = l1(0.0, 1.0);
	V4 s2_8 = l1(1.0, 1.0);
	V4 s3_0 = -max(-s2_0, 0.0);
	V4 s3_1 = -max(-s2_1, 0.0);
	V4 s3_2 = -max(-s2_2, 0.0);
	V4 s3_3 = -max(-s2_3, 0.0);
	V4 s3_4 = -max(-s2_4, 0.0);
	V4 s3_5 = -max(-s2_5, 0.0);
	V4 s3_6 = -max(-s2_6, 0.0);
	V4 s3_7 = -max(-s2_7, 0.0);
	V4 s3_8 = -max(-s2_8, 0.0);
	s2_0 = max(s2_0, 0.0);
	s2_1 = max(s2_1, 0.0);
	s2_2 = max(s2_2, 0.0);
	s2_3 = max(s2_3, 0.0);
	s2_4 = max(s2_4, 0.0);
	s2_5 = max(s2_5, 0.0);
	s2_6 = max(s2_6, 0.0);
	s2_7 = max(s2_7, 0.0);
	s2_8 = max(s2_8, 0.0);

	V4 r = f0(s0_0, s0_1, s0_2, s0_3, s0_4, s0_5, s0_6, s0_7, s0_8, s1_0, s1_1, s1_2, s1_3, s1_4, s1_5, s1_6, s1_7, s1_8, s2_0, s2_1, s2_2, s2_3, s2_4, s2_5, s2_6, s2_7, s2_8, s3_0, s3_1, s3_2, s3_3, s3_4, s3_5, s3_6, s3_7, s3_8);

	static const MF3x3 rgb2yuv = { 0.299, 0.587, 0.114, -0.169, -0.331, 0.5, 0.5, -0.419, -0.081 };
	static const MF3x3 yuv2rgb = { 1, -0.00093, 1.401687, 1, -0.3437, -0.71417, 1, 1.77216, 0.00099 };
	float2 opt = float2(GetOutputPt());

	pos -= 0.5f * opt;
	MF3 yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = MF4(mul(yuv2rgb, MF3(saturate(yuv.r + r.x), yuv.yz)), 1);

	++gxy.x;
	pos.x += opt.x;
	yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = MF4(mul(yuv2rgb, MF3(saturate(yuv.r + r.y), yuv.yz)), 1);

	++gxy.y;
	pos.y += opt.y;
	yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = MF4(mul(yuv2rgb, MF3(saturate(yuv.r + r.w), yuv.yz)), 1);

	--gxy.x;
	pos.x -= opt.x;
	yuv = mul(rgb2yuv, INPUT.SampleLevel(SL, pos, 0).rgb);
	OUTPUT[gxy] = MF4(mul(yuv2rgb, MF3(saturate(yuv.r + r.z), yuv.yz)), 1);
}
