package org.cloudbus.cloudsim.geoweb.web;

/**
 * This interface represents the abstraction of a queue-factory that generates a
 * (potenentially infinite) number of instances on demand in a specific order.
 * The order of generation may rely on the time - e.g. new entities are
 * generated and cached every 5 seconds. In this case the generator relies on an
 * external caller to periodically notify it of the time - see the
 * {@link IGenerator.notifyOfTime} method.
 * 
 * 
 * @author nikolay.grozev
 * 
 * @param <T>
 *            - the type of elements created by this generator.
 */
public interface IGenerator<T> {

    /**
     * Peeks the top of the queue.
     * 
     * @return the top of the queue or null if currently no elements can be
     *         generated.
     */
    T peek();

    /**
     * Polls the top of the queue.
     * 
     * @return the top of the queue or null if currently no elements can be
     *         generated.
     */
    T poll();

    /**
     * Returns if entries can be generated by this generator.
     * 
     * @return if entries can be generated by this generator.
     */
    boolean isEmpty();

    /**
     * Gets notified of the current time.
     * 
     * @param time
     *            - the current CloudSim time.
     */
    void notifyOfTime(final double time);

}
