﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using FFmpeg.AutoGen.Abstractions;

namespace FFmpeg.AutoGen.Example;

public sealed unsafe class VideoConverter : IDisposable
{
    private readonly SwsContext* _pConvertContext;

    public VideoConverter(Size sourceSize, AVPixelFormat sourcePixelFormat,
        Size destinationSize, AVPixelFormat destinationPixelFormat)
    {
        _pConvertContext = ffmpeg.sws_getContext(sourceSize.Width,
            sourceSize.Height,
            sourcePixelFormat,
            destinationSize.Width,
            destinationSize.Height,
            destinationPixelFormat,
            (int)SwsFlags.SWS_FAST_BILINEAR,
            null,
            null,
            null);
        if (_pConvertContext == null)
            throw new ApplicationException("Could not initialize the conversion context.");

        var convertedFrameBufferSize = ffmpeg.av_image_get_buffer_size(destinationPixelFormat,
            destinationSize.Width,
            destinationSize.Height,
            1);
        var convertedFrameBufferPtr = Marshal.AllocHGlobal(convertedFrameBufferSize);
        var dstData = new byte_ptr4();
        var dstLinesize = new int4();

        ffmpeg.av_image_fill_arrays(ref dstData,
            ref dstLinesize,
            (byte*)convertedFrameBufferPtr,
            destinationPixelFormat,
            destinationSize.Width,
            destinationSize.Height,
            1);
    }

    public void Dispose()
    {
    }

    public AVFrame Convert(AVFrame sourceFrame)
    {
        var dstData = new byte_ptr4();
        var dstLinesize = new int4();

        ffmpeg.sws_scale(_pConvertContext,
            sourceFrame.data,
            sourceFrame.linesize,
            0,
            sourceFrame.height,
            dstData,
            dstLinesize);

        return new AVFrame();
    }
}
