define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "应用程序标头"
      }
    },
    "buttons": {
      "logout": {
        "label": "注销"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "显示/隐藏导航树"
        }
      },
      "theme": {
        "tooltip": "切换主题"
      },
      "whatsNew": {
        "tooltip": "新增功能！"
      },
      "howDoI": {
        "tooltip": "打开“如何操作...？”任务"
      },
      "tips": {
        "tooltip": "显示/隐藏用户提示"
      },
      "help": {
        "tooltip": "打开 WebLogic Remote Console 内部文档"
      },
      "profile": {
        "tooltip": "概要文件"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "打开消息中心"
      },
      "theme": {
        "light": {
          "value": "浅色"
        },
        "dark": {
          "value": "深色"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "单击以重置 WebLogic Remote Console"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "版权所有 (c) 2020，2025，Oracle 和/或其关联公司。<br/>Oracle (r)、Java、MySQL 和 NetSuite 是 Oracle 和/或其关联公司的注册商标。其他名称可能是各自所有者的商标。<br/>",
      "builtWith": "使用 Oracle JET 构建"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "不安全"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "管理服务器连接不安全"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "显示概要文件列表"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "管理概要文件"
          },
          "editor": {
            "tooltip": "概要文件编辑器",
            "toolbar": {
              "save": {
                "tooltip": "保存概要文件"
              },
              "activate": {
                "tooltip": "活动概要文件"
              },
              "add": {
                "tooltip": "添加概要文件"
              },
              "remove": {
                "tooltip": "删除概要文件"
              }
            }
          }
        },
        "image": {
          "tooltip": "概要文件",
          "capture": {
            "tooltip": "添加或更改图像"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "一般信息"
        },
        "settings": {
          "value": "设置"
        },
        "preferences": {
          "value": "首选项"
        },
        "properties": {
          "value": "属性"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "更改图像"
      },
      "clearImage": {
        "value": "清除图像"
      },
      "profile": {
        "default": {
          "value": "默认概要文件"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "显示概要文件编辑器"
            },
            "hide": {
              "value": "隐藏概要文件编辑器"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "打开概要文件管理器"
          },
          "signout": {
            "value": "注销"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "概要文件 ID"
          },
          "organization": {
            "value": "组织"
          },
          "name": {
            "value": "名称"
          },
          "email": {
            "value": "电子邮件"
          },
          "role": {
            "default": {
              "value": "用作默认概要文件"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "是否为您的项目存储加密身份证明？"
            },
            "disableHNV": {
              "value": "是否禁用主机名验证？"
            },
            "proxyAddress": {
              "value": "代理地址"
            },
            "trustStoreType": {
              "value": "信任库类型"
            },
            "trustStorePath": {
              "value": "信任库路径"
            },
            "trustStoreKey": {
              "value": "信任库密钥"
            },
            "connectionTimeout": {
              "value": "管理服务器连接超时"
            },
            "readTimeout": {
              "value": "管理服务器读取超时"
            }
          },
          "preferences": {
            "theme": {
              "value": "主题"
            },
            "startupTaskChooserType": {
              "value": "启动任务选择器类型"
            },
            "useTreeMenusAsRootNodes": {
              "value": "使用树菜单作为树导航器的根级别？"
            },
            "onQuit": {
              "value": "允许未保存的更改以防止退出应用程序？"
            },
            "onDelete": {
              "value": "确认所有删除项？"
            },
            "onActionNotAllowed": {
              "value": "使用“不允许操作”弹出菜单以防止数据丢失？"
            },
            "onUnsavedChangesDetected": {
              "value": "使用“检测到未保存的更改”弹出菜单以防止数据丢失？"
            },
            "onChangesNotDownloaded": {
              "value": "使用“未下载更改”弹出菜单以防止数据丢失？"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Java 系统属性"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "浅色"
            },
            "dark": {
              "value": "深色"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "使用对话框"
            },
            "useCards": {
              "value": "使用卡"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "Windows ROOT"
            },
            "keyChainStore": {
              "value": "密钥链存储"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "已成功保存概要文件 \"{0}\"！"
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "提供程序操作"
        }
      },
      "info": {
        "tooltip": "获取有关此提供程序的信息"
      },
      "edit": {
        "tooltip": "管理此提供程序的设置"
      },
      "deactivate": {
        "tooltip": "停用此提供程序"
      },
      "delete": {
        "tooltip": "删除此提供程序"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "未命名项目"
        },
        "name": {
          "value": "连接提供程序名称"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "代理覆盖"
        },
        "username": {
          "value": "用户名"
        },
        "password": {
          "value": "密码"
        }
      },
      "models": {
        "name": {
          "value": "WDT 模型提供程序名称"
        },
        "file": {
          "value": "WDT 模型文件名"
        },
        "props": {
          "value": "WDT 变量"
        }
      },
      "composite": {
        "name": {
          "value": "WDT 组合模型提供程序名称"
        },
        "providers": {
          "value": "WDT 模型"
        }
      },
      "proplist": {
        "name": {
          "value": "属性列表提供程序名称"
        },
        "file": {
          "value": "属性列表文件名"
        }
      },
      "project": {
        "name": {
          "value": "项目名称"
        },
        "file": {
          "value": "项目文件名"
        }
      },
      "provider": {
        "adminserver": {
          "value": "管理服务器连接"
        },
        "model": {
          "value": "添加 WDT 模型"
        }
      },
      "dropdown": {
        "none": {
          "value": "无"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "项目名称："
          }
        },
        "provider": {
          "id": {
            "label": "提供程序 ID："
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "控制台扩展版本："
          },
          "name": {
            "label": "域名:"
          },
          "url": {
            "label": "域 URL："
          },
          "proxyOverride": {
            "label": "代理覆盖："
          },
          "version": {
            "label": "域版本："
          },
          "username": {
            "label": "用户名："
          },
          "sso": {
            "label": "Web 验证："
          },
          "roles": {
            "label": "角色："
          },
          "connectTimeout": {
            "label": "连接超时："
          },
          "readTimeout": {
            "label": "读取超时:"
          },
          "insecure": {
            "label": "不安全："
          },
          "anyAttempt": {
            "label": "尝试的任何连接："
          },
          "lastAttempt": {
            "label": "上次成功尝试："
          }
        },
        "model": {
          "file": {
            "label": "文件："
          },
          "props": {
            "label": "变量："
          }
        },
        "composite": {
          "models": {
            "label": "模型："
          }
        },
        "proplist": {
          "file": {
            "label": "文件名："
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "添加管理服务器连接提供程序"
        }
      },
      "models": {
        "add": {
          "value": "添加 WDT 模型文件提供程序"
        },
        "new": {
          "value": "为新 WDT 模型文件创建提供程序"
        }
      },
      "composite": {
        "add": {
          "value": "添加 WDT 组合模型文件提供程序"
        }
      },
      "proplist": {
        "add": {
          "value": "添加属性列表提供程序"
        },
        "new": {
          "value": "为新属性列表创建提供程序"
        }
      },
      "providers": {
        "sort": {
          "value": "按提供程序类型排序"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "域 URL："
              },
              "version": {
                "label": "域版本："
              },
              "username": {
                "label": "用户名："
              }
            }
          },
          "model": {
            "file": {
              "label": "文件："
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "将提供程序作为项目导出..."
        },
        "import": {
          "value": "导入项目"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "输入连接提供程序的新名称和连接设置。"
        },
        "edit": {
          "value": "修改连接提供程序的连接设置。"
        },
        "deactivate": {
          "value": "停用连接提供程序并停止域状态轮询。"
        }
      },
      "models": {
        "add": {
          "value": "输入现有模型文件提供程序的设置。单击上载图标以浏览模型文件。"
        },
        "new": {
          "value": "输入新 WDT 模型文件的提供程序名称和文件名，然后单击用于选取文件保存目录的图标。"
        },
        "edit": {
          "value": "修改模型文件提供程序的设置。单击用于浏览模型文件的图标。"
        }
      },
      "composite": {
        "add": {
          "value": "输入新名称，并为组合模型提供程序选择经过排序的模型列表。"
        },
        "edit": {
          "value": "修改组合模型提供程序的设置。使用经过排序的模型列表。"
        }
      },
      "proplist": {
        "add": {
          "value": "输入现有模型列表提供程序的设置。单击上载图标以浏览属性文件。"
        },
        "new": {
          "value": "输入新属性列表的提供程序名称和文件名，然后单击用于选取文件保存目录的图标。"
        },
        "edit": {
          "value": "修改属性列表提供程序的设置。单击用于浏览属性文件的图标。"
        }
      },
      "project": {
        "export": {
          "value": "输入新项目的设置。"
        },
        "import": {
          "value": "单击下载图标以浏览项目。"
        }
      },
      "task": {
        "startup": {
          "value": "您希望执行哪个启动任务？"
        }
      },
      "project-busy": {
        "value": "在对项目的任何部分进行更改之前，请保存或放弃未保存的更改"
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "为管理服务器连接创建提供程序"
        },
        "models": {
          "value": "为现有 WDT 模型文件创建提供程序"
        },
        "composite": {
          "value": "为新 WDT 组合模型创建提供程序"
        },
        "proplist": {
          "value": "为现有属性列表创建提供程序"
        }
      },
      "new": {
        "models": {
          "value": "为新 WDT 模型文件创建提供程序"
        },
        "proplist": {
          "value": "为新属性列表创建提供程序"
        }
      },
      "edit": {
        "connections": {
          "value": "编辑管理服务器连接提供程序"
        },
        "models": {
          "value": "编辑 WDT 模型文件提供程序"
        },
        "composite": {
          "value": "编辑 WDT 组合模型提供程序"
        },
        "proplist": {
          "value": "编辑属性列表提供程序"
        }
      },
      "export": {
        "project": {
          "value": "将提供程序作为项目导出"
        }
      },
      "import": {
        "project": {
          "value": "导入项目"
        }
      },
      "startup": {
        "task": {
          "value": "启动任务"
        }
      },
      "project-busy": {
        "value": "项目繁忙"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "导出未成功",
          "detail": "无法将提供程序作为 '{0}' 项目导出。"
        }
      },
      "import": {
        "failed": {
          "summary": "保存未成功",
          "detail": "无法导入 '{0}' 项目文件。"
        }
      },
      "stage": {
        "failed": {
          "summary": "创建未成功",
          "detail": "无法创建 '{0}' 提供程序项。"
        }
      },
      "use": {
        "failed": {
          "summary": "连接未成功",
          "detail": "无法使用 '{0}' 提供程序项。"
        }
      },
      "upload": {
        "failed": {
          "detail": "无法加载 WDT 模型文件 {0}"
        },
        "props": {
          "failed": {
            "detail": "无法加载 WDT 变量：{0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "此项目中已存在名为 '{0}' 的提供程序！"
        },
        "modelsNotFound": {
          "detail": "找不到所配置的 WDT 模型 '{0}'"
        },
        "propListNotFound": {
          "detail": "找不到 WDT 变量 '{0}'"
        },
        "selectModels": {
          "detail": "要选择 WDT 组合，请首先选择 WDT 组合使用的所有 WDT 模型。"
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "该 URL 必须指定 HTTPS 协议或者使用 localhost"
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>在文件名字段中编辑路径，然后单击“确定”按钮。或者，单击上载图标并选择其他文件。</p>"
        },
        "fixModelFile": {
          "detail": "<p>修复下面引用的问题，然后单击“确定”按钮。或者，选择其他文件。</p>"
        },
        "yamlException": {
          "detail": "{0} 位于第 {1} 行，第 {2} 列"
        },
        "wktModelContent": {
          "summary": "模型内容问题",
          "detail": "使用<i>代码视图</i>选项卡上的模型编辑器来解决问题。"
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "未设置"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "使用稀疏模板"
      },
      "usesso": {
        "label": "使用 Web 验证"
      },
      "insecure": {
        "label": "建立不安全的连接"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "编辑树"
      },
      "view": {
        "tooltip": "配置视图树"
      },
      "monitoring": {
        "tooltip": "监视树"
      },
      "security": {
        "tooltip": "安全数据树"
      },
      "modeling": {
        "tooltip": "WDT 模型"
      },
      "composite": {
        "tooltip": "WDT 组合模型"
      },
      "properties": {
        "tooltip": "属性列表编辑器"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "提供程序树菜单"
      },
      "navtree": {
        "value": "提供程序树导航器"
      },
      "panelResizer": {
        "value": "提供程序树导航器调整大小工具。使用向左箭头键和向右箭头键调整导航器大小"
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "主页。返回到包含提供程序树的卡的页面"
        }
      },
      "region": {
        "title": {
          "value": "内容区域标题"
        }
      },
      "popup": {
        "provider": {
          "value": "提供程序操作"
        }
      }
    },
    "title": {
      "home": "主页",
      "configuration": "编辑树",
      "view": "配置视图树",
      "monitoring": "监视树",
      "security": "安全数据树",
      "modeling": "WDT 模型",
      "composite": "WDT 组合模型",
      "properties": "属性列表"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "主页"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "单击以查看购物车操作"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "查看更改..."
        },
        "discard": {
          "label": "放弃更改"
        },
        "commit": {
          "label": "提交更改"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "购物车"
        },
        "ataglance": {
          "label": "概览"
        },
        "projectmanagement": {
          "label": "提供程序"
        },
        "tips": {
          "label": "用户提示"
        },
        "dashboards": {
          "label": "仪表盘"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "筛选器提示",
        "checkboxes": {
          "hideall": "隐藏所有提示",
          "productivity": "显示工作效率提示",
          "personalization": "显示个性化提示",
          "whereis": "显示“...在哪里”提示",
          "accessibility": "显示可访问性提示",
          "connectivity": "显示连接提示",
          "security": "显示安全提示",
          "other": "显示其他提示"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "全部隐藏"
        },
        "productivity": {
          "value": "工作效率"
        },
        "personalization": {
          "value": "个性化"
        },
        "whereis": {
          "value": "...在哪里"
        },
        "accessibility": {
          "value": "可访问性"
        },
        "connectivity": {
          "value": "连接"
        },
        "security": {
          "value": "安全"
        },
        "other": {
          "value": "其他"
        }
      },
      "cards": {
        "tip0": {
          "title": "搜索域中的所有 MBean！",
          "descriptionHTML": "<p>在控制台顶部的搜索字段中输入搜索词，以梳理当前透视图中的匹配项。您还可以在<b>最近搜索</b>节点中重新访问以前的查询。</p>"
        },
        "tip1": {
          "title": "快速筛选并找到对您重要的数据！",
          "descriptionHTML": "<p>通过仪表盘，可以定义定制标准，将其与您的域进行匹配，并根据域生成全面且准确的报告。</p><p>要开始使用，请打开<b>监视树</b>中的任何节点，然后单击<b>新建仪表盘</b>。或者，打开<b>仪表盘</b>顶级节点查看内置仪表盘。</p>"
        },
        "tip2": {
          "title": "细化表内容",
          "descriptionHTML": "<p>通过隐藏不相关的列来简化表，以便可以专注于对您重要的数据。</p><p>在任何表上方，单击<b>定制表</b>，然后根据需要选择或取消选择列。</p>"
        },
        "tip3": {
          "title": "使用键盘处理表和操作",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "“定制此表”链接在哪里？",
          "descriptionHTML": "<p>“定制此表”链接现在变为<i>定制表</i>按钮。</p>"
        },
        "tip5": {
          "title": "复查暂挂更改",
          "descriptionHTML": "<p>打开购物车，查看已保存到域但尚未提交的更改列表。</p><p>如果您在购物车中看不到<b>查看更改</b>，请尝试<a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>安装 WebLogic Remote Console 扩展</a>。"
        },
        "tip6": {
          "title": "需要帮助?",
          "descriptionHTML": "<ul><li>将光标悬停在工具提示字段旁边的 <b>?</b> 上。</li><li>单击页级别的 <b>?</b> 获取每个可见属性的详细帮助信息。</li><li>在<b>帮助</b>菜单上，单击<b>访问 WebLogic Remote Console GitHub 项目</b>。</li><li>加入我们的 Slack 渠道：<a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>。</li><li>访问我们的文档，网址为 <a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>。</li></ul>"
        },
        "tip7": {
          "title": "其他提示 1",
          "descriptionHTML": "<p>“其他提示 1”的简要说明。换行符不是 HTML 元素，因此不需要在此说明中使用换行符。</p>"
        },
        "tip8": {
          "title": "连接到服务器时出现问题？",
          "descriptionHTML": "<p>在<b>监视树</b> > <b>环境</b> > <b>服务器</b>下，选择无响应的服务器并打开其<b>故障排除</b>选项卡，尝试诊断问题。</p><p>如果您根本无法连接到域，请参阅 WebLogic Remote Console 文档中的<a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>无法连接到管理服务器</a>以获取故障排除帮助。</p>"
        },
        "tip9": {
          "title": "连接提示 2",
          "descriptionHTML": "<p>“连接提示 2”的简要说明。换行符不是 HTML 元素，因此不需要在此说明中使用换行符。</p>"
        },
        "tip10": {
          "title": "安全提示 1",
          "descriptionHTML": "<p>“安全提示 1”的简要说明。换行符不是 HTML 元素，因此不需要在此说明中使用换行符。</p>"
        },
        "tip11": {
          "title": "加快您的工作流！",
          "descriptionHTML": "<p>使用键盘快捷方式直接跳转到特定的 UI 组件。</p><p>前 5 个：</p><li><code><b>Alt+P</b></code> - 打开<b>提供程序</b>抽屉。</li><li><code><b>Alt+C</b></code> - 将焦点移动到<b>购物车</b>。</li><li><code><b>Alt+T</b></code> - 将焦点移动到表中的第一列标题。</li><li><code><b>Alt+|</b></code> - 将焦点移动到导航树宽度调整大小工具。使用方向键更改树的宽度。</li><li><code><b>Alt+;</b></code> - 将焦点移动到第一个可单击的面包屑标签。</li></ul><p>有关键盘快捷方式的完整列表，请参阅文档。</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "面包屑"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "历史记录"
      },
      "separator": {
        "tooltip": "分隔符"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "清除历史记录条目",
          "label": "清除历史记录条目"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "在 {0} 运行"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "连接丢失",
        "detail": "连接丢失。请刷新。"
      },
      "cannotConnect": {
        "summary": "尝试连接失败",
        "detail": "无法连接到 WebLogic 域 {0}，请检查 WebLogic 是否在运行。"
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "树"
        },
        "startup-tasks": {
          "label": "启动任务"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "登录页"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "登录页链接"
        }
      },
      "screenreader": {
        "value1": "您正在处理 {0} 项目。按 Enter 键进行选择。",
        "value2": "您正在处理 {0} 项目。按 Enter 键将展开或折叠该项目。展开后，使用向下箭头键访问相关链接。",
        "value3": "{0}。按 Tab/Shift+Tab 键在相关链接之间移动，按 Esc 键返回上次访问的顶层项目。"
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "提供程序树"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "编辑树",
        "description": "<p>维护您当前使用的 WebLogic 域的配置。</p>"
      },
      "view": {
        "label": "配置视图树",
        "description": "<p>检查您当前使用的 WebLogic 域的只读配置。</p>"
      },
      "monitoring": {
        "label": "监视树",
        "description": "<p>查看您当前使用的 WebLogic 域中选定资源的运行时 MBean 信息。</p>"
      },
      "security": {
        "label": "安全数据树",
        "description": "<p>管理您当前使用的 WebLogic 域中的安全相关信息（例如用户、组、角色、策略、身份证明等）。</p>"
      },
      "modeling": {
        "label": "WDT 模型树",
        "description": "<p>维护与 WebLogic Deploy Tooling 工具关联的模型文件。</p>"
      },
      "composite": {
        "label": "WDT 组合模型树",
        "description": "<p>查看当前正在使用的 WebLogic Deploy Tooling 模型文件的组合集。</p>"
      },
      "properties": {
        "label": "属性列表编辑器",
        "description": "<p>查看或修改属性列表文件中的一组属性。</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "启动任务"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "添加管理服务器连接提供程序",
        "description": "此任务会创建项目资源，该资源可用于连接到管理服务器"
      },
      "addWdtModel": {
        "label": "添加 WDT 模型文件提供程序",
        "description": "此任务会创建项目资源，该资源可用于管理本地文件系统上现有的 WDT 模型文件"
      },
      "addWdtComposite": {
        "label": "添加 WDT 组合模型文件提供程序",
        "description": "此任务会创建项目资源，该资源可用于管理本地文件系统上现有的 WDT 模型文件片段"
      },
      "addPropertyList": {
        "label": "添加属性列表提供程序",
        "description": "此任务会创建项目资源，该资源可用于管理存储在本地文件系统上的 .properties 文件"
      },
      "createWdtModel": {
        "label": "为新 WDT 模型文件创建提供程序",
        "description": "此任务会创建项目资源，该资源是存储在本地文件系统中的新 WDT 模型文件"
      },
      "createPropertyList": {
        "label": "为新属性列表创建提供程序",
        "description": "此任务会创建项目资源，该资源是存储在本地文件系统中的新 .properties 模型文件"
      },
      "importProject": {
        "label": "导入项目",
        "description": "此任务会加载以前导出的项目，该项目包含可立即使用或修改的提供程序"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "放弃更改"
      },
      "commit": {
        "tooltip": "提交更改"
      }
    },
    "sections": {
      "changeManager": {
        "label": "更改管理器"
      },
      "additions": {
        "label": "添加"
      },
      "modifications": {
        "label": "修改"
      },
      "removals": {
        "label": "删除"
      },
      "restart": {
        "label": "重新启动"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "新建"
      },
      "clone": {
        "label": "克隆"
      },
      "delete": {
        "label": "删除"
      },
      "customize": {
        "label": "定制表"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "登录页"
      },
      "history": {
        "tooltip": "显示/隐藏历史记录"
      },
      "instructions": {
        "tooltip": "显示/隐藏说明"
      },
      "help": {
        "tooltip": "显示/隐藏帮助页"
      },
      "sync": {
        "tooltip": "重新加载",
        "tooltipOn": "停止自动重新加载"
      },
      "syncInterval": {
        "tooltip": "设置自动重新加载间隔"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "选择要执行 '{0}' 操作的项目。"
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "消息",
          "detail": "无法在运行自动重新加载时执行 '{0}' 操作！请首先单击 '{1}' 图标停止重新加载。"
        }
      }
    },
    "prompts": {
      "download": {
        "value": "下载的日志文件位置："
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "显示隐藏的列"
      }
    },
    "labels": {
      "totalRows": {
        "value": "总行数: {0}"
      },
      "reloadHidden": {
        "value": "重新加载表以查看当前的 {0} 个值"
      },
      "noData": {
        "value": "未找到数据。"
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "可用列"
        },
        "list": {
          "value": "“可用列”列表"
        },
        "listItem": {
          "value": "“可用列”列表项"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "选定列"
        },
        "list": {
          "value": "“选定列”列表"
        },
        "listItem": {
          "value": "“选定列”列表项"
        }
      },
      "button": {
        "addToRight": {
          "value": "将“可用列”列表中的选中项移至“选定列”列表"
        },
        "addAllRight": {
          "value": "将“可用列”列表中的所有项移至“选定列”列表"
        },
        "removeRight": {
          "value": "将“选定列”列表中的选中项移至“可用列”列表"
        },
        "removeAll": {
          "value": "将“选定列”列表中的所有项移至“可用列”列表"
        },
        "reset": {
          "value": "将“选定列”列表中的列还原为打开表定制器时显示的那些列。"
        },
        "apply": {
          "value": "将列定制设置应用于表"
        },
        "cancel": {
          "value": "取消所有列定制设置"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "保存"
      },
      "new": {
        "label": "创建"
      },
      "delete": {
        "label": "删除"
      },
      "back": {
        "label": "上一步"
      },
      "next": {
        "label": "下一步"
      },
      "finish": {
        "label": "创建"
      },
      "customize": {
        "label": "定制表"
      },
      "dashboard": {
        "label": "新建仪表盘"
      }
    },
    "icons": {
      "save": {
        "tooltip": "保存"
      },
      "create": {
        "tooltip": "创建"
      },
      "landing": {
        "tooltip": "登录页"
      },
      "history": {
        "tooltip": "显示/隐藏历史记录"
      },
      "instructions": {
        "tooltip": "显示/隐藏说明"
      },
      "help": {
        "tooltip": "显示/隐藏帮助页"
      },
      "sync": {
        "tooltip": "重新加载",
        "tooltipOn": "停止自动重新加载"
      },
      "syncInterval": {
        "tooltip": "设置自动重新加载间隔"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "显示高级字段"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "单击 {0} 图标以在概要和详细帮助信息之间切换。"
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "更改已添加到购物车！",
        "generic": "已保存更改！",
        "notSaved": "由于未检测到任何更改，未保存任何内容。"
      },
      "action": {
        "notAllowed": {
          "summary": "不允许操作",
          "detail": "在创建操作期间，无法执行请求的操作。单击“取消”按钮可取消创建操作。"
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "需要重新启动服务器或应用程序"
      },
      "wdtIcon": {
        "tooltip": "WDT 设置"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "帮助表",
        "columns": {
          "header": {
            "name": "名称",
            "description": "说明"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>相关主题：</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "属性"
      },
      "actions": {
        "label": "操作"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "必填字段不完整",
        "detail": "{0} 字段是必填字段，但是尚未提供任何值（或提供的值无效）。"
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "添加条件"
        },
        "combine": {
          "label": "组合"
        },
        "uncombine": {
          "label": "取消组合"
        },
        "moveup": {
          "label": "上移"
        },
        "movedown": {
          "label": "下移"
        },
        "remove": {
          "label": "删除"
        },
        "negate": {
          "label": "求反"
        },
        "reset": {
          "label": "重置"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "添加新的第一个条件..."
          },
          "above": {
            "label": "在单击的行上面添加条件..."
          },
          "below": {
            "label": "在单击的行下面添加条件..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "在选中条件上面添加..."
          },
          "below": {
            "label": "在选中条件下面添加..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "一个或多个必填字段不包含数据！"
      },
      "argumentValueHasWrongFormat": {
        "summary": "'{0}' 字段包含格式不正确的数据！"
      },
      "conditionHasNoArgValues": {
        "summary": "所选条件没有可编辑的参数值！"
      },
      "conditionAlreadyExists": {
        "summary": "此安全策略已具有使用所选谓词构建的条件，或者具有与参数值匹配的条件！"
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>要指定新条件的位置，请在相对条件旁边打勾，然后单击 <b>+添加条件</b>按钮。</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "范围: -31 到 31"
      },
      "dateTime": {
        "value": "格式：yyyy-MM-dd [HH:mm:ss [AM|PM]]（例如 2022-02-14 09:00:00 AM）"
      },
      "time": {
        "value": "格式：HH:mm:ss（例如 14:22:47）"
      },
      "gmtOffset": {
        "value": "格式：GMT+|-h:mm（例如 GMT-5:00）"
      },
      "weekDay": {
        "value": "例如星期日、星期一、星期二、..."
      },
      "or": {
        "value": "或"
      },
      "not": {
        "value": "NOT"
      },
      "combination": {
        "value": "组合"
      },
      "nodata": {
        "Policy": {
          "value": "使用 <b>+ 添加条件</b>按钮添加策略条件。"
        },
        "DefaultPolicy": {
          "value": "未定义默认安全策略条件。"
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "组合",
            "operator": "运算符",
            "expression": "条件短语"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "或",
            "and": "与"
          }
        }
      }
    },
    "wizard": {
      "title": "策略管理",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "选择谓词",
            "instructions": "从下拉列表中为您的新条件选择谓词。"
          },
          "body": {
            "labels": {
              "predicateList": "谓词列表"
            },
            "help": {
              "predicateList": "谓词列表是可用于组成安全策略条件的可用谓词的列表。"
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "组谓词",
            "instructions": "首先，在<i></i>字段中键入值以添加参数值或搜索现有参数值。按 Enter 键以将键入的值添加到列表中。要编辑现有参数值，请单击它并使用弹出式输入字段进行修改。"
          },
          "body": {
            "labels": {
              "conditionPhrase": "条件短语",
              "negate": "条件求反"
            },
            "help": {
              "negate": "将条件转换为具有相反含义（例如，“等于”变为“不等于”，“位于”变为“不位于”）。"
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "树"
      },
      "page": {
        "value": "页"
      },
      "tab": {
        "value": "选项卡"
      },
      "ariaLabel": {
        "value": "页历史记录"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "页不再存在",
        "detail1": "您已重定向到 {0} 页，因为",
        "detail2": "{0} 已被其他用户删除，或不再存在。"
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "页书签"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "为当前页添加书签"
        },
        "show": {
          "label": "显示页书签..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "此页已有书签！"
      },
      "pagesBookmarkAdded": {
        "summary": "当前页已成功添加书签！"
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "返回到提供程序树的登录页。"
        },
        "reset": {
          "value": "刷新页面值"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "操作"
      },
      "apply": {
        "label": "应用"
      },
      "reset": {
        "label": "重置"
      },
      "ok": {
        "label": "确定"
      },
      "cancel": {
        "label": "取消"
      },
      "restart": {
        "label": "重新启动"
      },
      "yes": {
        "label": "是"
      },
      "no": {
        "label": "否"
      },
      "choose": {
        "label": "选择"
      },
      "connect": {
        "label": "连接"
      },
      "add": {
        "label": "添加/发送"
      },
      "edit": {
        "label": "编辑/发送"
      },
      "import": {
        "label": "导入"
      },
      "export": {
        "label": "导出"
      },
      "write": {
        "label": "下载文件"
      },
      "savenow": {
        "label": "立即保存"
      },
      "next": {
        "label": "下一步"
      },
      "previous": {
        "label": "上一个"
      },
      "finish": {
        "label": "完成"
      },
      "done": {
        "label": "完成"
      },
      "close": {
        "label": "关闭"
      },
      "clear": {
        "label": "清除"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "折叠"
      },
      "expand": {
        "value": "展开"
      },
      "choose": {
        "value": "选择文件"
      },
      "clear": {
        "value": "清除所选文件"
      },
      "more": {
        "value": "更多操作"
      },
      "download": {
        "value": "浏览"
      },
      "reset": {
        "value": "重置"
      },
      "filter": {
        "value": "筛选器"
      },
      "submit": {
        "value": "提交更改"
      },
      "write": {
        "value": "下载文件"
      },
      "pick": {
        "value": "选取目录"
      },
      "reload": {
        "value": "重新加载文件"
      },
      "delete": {
        "value": "删除"
      },
      "remove": {
        "value": "删除"
      },
      "noData": {
        "value": "无数据"
      },
      "preloader": {
        "value": "预加载器"
      },
      "checkAll": {
        "value": "全部选中"
      },
      "checkNone": {
        "value": "全部取消选中"
      },
      "checkSome": {
        "value": "清除选中"
      },
      "close": {
        "value": "关闭"
      },
      "recentPages": {
        "value": "显示/隐藏历史记录"
      },
      "pagesHistory": {
        "back": {
          "value": "上一页"
        },
        "next": {
          "value": "下一页"
        },
        "launch": {
          "value": "显示页历史记录"
        },
        "star": {
          "value": "页书签"
        }
      },
      "pageInfo": {
        "value": "单击以固定和取消固定"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "选择文件..."
      },
      "chooseDir": {
        "value": "选择目录..."
      }
    },
    "labels": {
      "info": {
        "value": "信息"
      },
      "warn": {
        "value": "警告"
      },
      "error": {
        "value": "错误"
      },
      "alerts": {
        "value": "预警"
      },
      "pagesHistory": {
        "value": "以下是自选择当前提供程序以来访问的页面。单击行中的任何列以导航到关联页。"
      },
      "pagesBookmark": {
        "value": "以下是为 {0} 提供程序类型添加书签的页面。单击行中的任何列以导航到关联页。"
      }
    },
    "placeholders": {
      "search": {
        "value": "搜索"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "检测到不正确内容"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "'{0}' 包含 JSON，但不是 {1} 的 JSON 表示形式！"
      },
      "dataCopiedToClipboard": {
        "detail": "数据已复制到剪贴板！"
      },
      "tableCopiedToClipboard": {
        "summary": "表已成功复制到剪贴板！"
      },
      "emptyCellData": {
        "detail": "数据未复制到剪贴板，因为所选单元格为空！"
      },
      "emptyRowData": {
        "detail": "数据未复制到剪贴板，因为所选行为空！"
      },
      "browserPermissionDenied": {
        "summary": "浏览器权限被拒绝",
        "detail": "为了执行此操作，您需要启用从 JavaScript 向剪贴板写入。此外，只有通过 HTTPS 提供的页才支持剪贴板 API。"
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "将单元格复制到剪贴板"
        },
        "row": {
          "label": "将行复制到剪贴板"
        },
        "tableAsText": {
          "label": "将表复制到剪贴板（文本）"
        },
        "tableAsJSON": {
          "label": "将表复制到剪贴板 (JSON)"
        },
        "tableAsYAML": {
          "label": "将表复制到剪贴板 (YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "全部折叠"
      },
      "useTreeMenusAsRootNodes": {
        "value": "使用树菜单作为根节点"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "更改已成功保存到 '{0}' 文件！"
      },
      "changesNotSaved": {
        "summary": "无法将更改保存到 '{0}' 文件！"
      },
      "changesDownloaded": {
        "summary": "更改已成功下载到 '{0}' 文件！"
      },
      "changesNotDownloaded": {
        "summary": "无法将更改下载到 '{0}' 文件！"
      },
      "verifyPathEntered": {
        "detail": ". 将 {0} 字段设置为 false 将接受输入的值，而不验证该值是否作为本地文件或目录存在。"
      }
    },
    "wdtOptionsDialog": {
      "title": "编辑：{0}",
      "default": "取消设置值",
      "instructions": "输入要添加到可选项目列表的令牌。",
      "enterValue": "输入值",
      "selectValue": "选择值",
      "selectSwitch": "切换值",
      "enterUnresolvedReference": "输入未解析的引用",
      "enterModelToken": "输入模型令牌",
      "selectPropsVariable": "选择模型令牌变量",
      "createPropsVariable": "创建模型令牌变量",
      "propName": "变量名（必需）",
      "propValue": "变量值",
      "enterVariable": "输入变量",
      "variableName": "变量名（必需）",
      "variableValue": "变量值",
      "multiSelectUnset": "从可用项目列表中选择值"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "检测到未保存的更改"
      },
      "changesNeedDownloading": {
        "value": "未下载更改"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "所有未保存的更改都将丢失。是否继续？"
        },
        "areYouSure": {
          "value": "是否确实要 {0} 而不保存所做的更改？"
        },
        "saveBeforeExiting": {
          "value": "退出前是否要保存更改？"
        },
        "needDownloading": {
          "value": "您对 '{0}' 所做更改尚未下载到文件。<br/><br/>先进行下载再继续？"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "您的新 '{0}' 实例尚未添加到 WDT 模型中。<br/><br/>先进行添加再继续？"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "设置自动重新加载间隔",
      "instructions": "您希望自动重新加载间隔是多少秒？",
      "fields": {
        "interval": {
          "label": "自动重新加载间隔："
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "消息",
          "detail": "当尝试执行 '{1}' 操作时，控制台后端调用生成了 '{0}' 响应"
        },
        "actionNotPerformed": {
          "detail": "无法对一个或多个选中的项目执行 '{0}' 操作"
        },
        "actionNotPerformedNoRow": {
          "detail": "无法执行 '{0}' 操作"
        },
        "actionSucceeded": {
          "summary": "已成功执行 '{0}' 操作！"
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "无法确定确切原因。请查看 JavaScript 控制台中的提示。"
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "操作确认",
        "prompt": "无法撤消 '{0}' 操作！<br/><br/>是否继续？"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "可用",
        "chosen": "所选"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "属性名称",
        "value": "属性值"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "属性名称",
        "valueHeader": "属性值",
        "addButtonTooltip": "添加",
        "deleteButtonTooltip": "删除"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "查看 {0}..."
          },
          "create": {
            "label": "创建新{0}..."
          },
          "edit": {
            "label": "编辑 {0}..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "还原为默认值"
    },
    "placeholder": {
      "value": "默认值"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "'{0}' 不可用。"
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "RUNNING"
      },
      "shutdown": {
        "value": "SHUTDOWN"
      },
      "serverStates": {
        "value": "服务器状态"
      },
      "systemStatus": {
        "value": "系统状态"
      },
      "healthState": {
        "failed": {
          "value": "失败"
        },
        "critical": {
          "value": "严重"
        },
        "overloaded": {
          "value": "超载"
        },
        "warning": {
          "value": "警告"
        },
        "ok": {
          "value": "正常"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "截至以下时间正在运行的服务器的健康状况:"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "名称"
        },
        "state": {
          "value": "状态"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "当前无法访问后端。"
      },
      "connectionMessage": {
        "summary": "连接消息"
      },
      "connectFailed": {
        "detail": "尝试失败："
      },
      "badRequest": {
        "detail": "无法处理提交的文件或请求"
      },
      "invalidCredentials": {
        "detail": "WebLogic 域身份证明无效"
      },
      "invalidUrl": {
        "detail": "无法访问 WebLogic 域 URL"
      },
      "notInRole": {
        "detail": "尝试失败：用户不是管理员、部署人员、操作员或监视人员"
      },
      "notSupported": {
        "detail": "不支持 WebLogic 域"
      },
      "unexpectedStatus": {
        "detail": "意外的结果（状态：{0}）"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "请求未成功",
          "detail": "从控制台后端调用返回了不成功的响应。"
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "请查看远程控制台终端或 Javascript 控制台以了解具体原因。"
      },
      "responseMessages": {
        "summary": "响应消息"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "确认"
      },
      "prompt": {
        "value": "关闭 <b>{0}</b> 将重置当前提供程序。是否继续？"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "无法访问更改管理器！"
      },
      "changesCommitted": {
        "summary": "已成功提交更改！"
      },
      "changesNotCommitted": {
        "summary": "无法提交更改！"
      },
      "changesDiscarded": {
        "summary": "已成功放弃更改！"
      },
      "changesNotDiscarded": {
        "summary": "无法放弃更改！"
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "意外的错误响应"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "连接问题",
        "details": "从提供程序发送和接收数据时出现问题！请确保提供程序可访问，然后再继续操作。"
      },
      "pathNotFound": {
        "summary": "找不到路径",
        "details": "'{0}' 是在本地文件系统上不可访问的文件或目录。"
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "消息行"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "清除消息"
        },
        "suppress": {
          "info": {
            "label": "隐藏信息消息"
          },
          "warning": {
            "label": "隐藏警告消息"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " 无法连接到 WebLogic 域的管理服务器。"
      },
      "shutdownSequenceError": {
        "details": "关闭托管服务器，然后关闭管理服务器。"
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "存在 {0} 个高优先级错误预警"
        },
        "warning": {
          "value": "存在 {0} 个高优先级警告预警"
        },
        "info": {
          "value": "存在 {0} 个高优先级信息预警"
        },
        "view": {
          "value": "查看预警"
        }
      }
    }
  }
});