define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "Cabeçalho do Aplicativo"
      }
    },
    "buttons": {
      "logout": {
        "label": "Fazer Log-out"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "Alternar visibilidade da Árvore de Navegação"
        }
      },
      "theme": {
        "tooltip": "Alternar tema"
      },
      "whatsNew": {
        "tooltip": "O Que Há de Novo!"
      },
      "howDoI": {
        "tooltip": "Abrir Tarefas \"Como Faço para...?\""
      },
      "tips": {
        "tooltip": "Alternar visibilidade de Dicas para o Usuário"
      },
      "help": {
        "tooltip": "Abrir Documentação Interna do WebLogic Remote Console"
      },
      "profile": {
        "tooltip": "Perfil"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "Abrir Message Center"
      },
      "theme": {
        "light": {
          "value": "Claro"
        },
        "dark": {
          "value": "Escuro"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "Clique para redefinir o WebLogic Remote Console"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "Copyright (c) 2020, 2025, Oracle e/ou suas empresas afiliadas.<br/>Oracle (r), Java, MySQL e NetSuite são marcas comerciais registradas da Oracle Corporation e/ou de suas empresas afiliadas. Outros nomes podem ser marcas comerciais de seus respectivos proprietários.<br/>",
      "builtWith": "Criado com o Oracle JET"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "Não seguro"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "Conexão do Servidor de Administração Não Segura"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "Mostrar Lista de Perfis"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "Gerenciar Perfis"
          },
          "editor": {
            "tooltip": "Editor de Perfil",
            "toolbar": {
              "save": {
                "tooltip": "Salvar Perfil"
              },
              "activate": {
                "tooltip": "Perfil Ativo"
              },
              "add": {
                "tooltip": "Adicionar Perfil"
              },
              "remove": {
                "tooltip": "Excluir Perfil"
              }
            }
          }
        },
        "image": {
          "tooltip": "Perfil",
          "capture": {
            "tooltip": "Adicionar ou alterar imagem"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "Geral"
        },
        "settings": {
          "value": "Definições"
        },
        "preferences": {
          "value": "Preferências"
        },
        "properties": {
          "value": "Propriedades"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "Alterar Imagem"
      },
      "clearImage": {
        "value": "Remover Imagem"
      },
      "profile": {
        "default": {
          "value": "Perfil Padrão"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "Mostrar Editor de Perfil"
            },
            "hide": {
              "value": "Ocultar Editor de Perfil"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "Abrir Profile Manager"
          },
          "signout": {
            "value": "Sair do Sistema"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "ID do Perfil"
          },
          "organization": {
            "value": "Organização "
          },
          "name": {
            "value": "Nome"
          },
          "email": {
            "value": "E-mail"
          },
          "role": {
            "default": {
              "value": "Usar como Perfil Padrão"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "Armazenar credenciais criptografadas para seus projetos?"
            },
            "disableHNV": {
              "value": "Desativar verificação de nome do host?"
            },
            "proxyAddress": {
              "value": "Endereço do Proxy"
            },
            "trustStoreType": {
              "value": "Tipo de Armazenamento Confiável"
            },
            "trustStorePath": {
              "value": "Caminho do Armazenamento Confiável"
            },
            "trustStoreKey": {
              "value": "Chave de Armazenamento Confiável"
            },
            "connectionTimeout": {
              "value": "Timeout da Conexão do Servidor de Administração"
            },
            "readTimeout": {
              "value": "Timeout de Leitura do Servidor de Administração"
            }
          },
          "preferences": {
            "theme": {
              "value": "Tema"
            },
            "startupTaskChooserType": {
              "value": "Inicializar Tipo de Seletor de Tarefa"
            },
            "useTreeMenusAsRootNodes": {
              "value": "Usar Menus de Árvore como o nível raiz dos Navegadores de Árvore?"
            },
            "onQuit": {
              "value": "Permitir que alterações não salvas impeçam a saída do aplicativo?"
            },
            "onDelete": {
              "value": "Confirmar todas as exclusões?"
            },
            "onActionNotAllowed": {
              "value": "Usar o popup \"Ação Não Permitida\" para impedir a perda de dados?"
            },
            "onUnsavedChangesDetected": {
              "value": "Usar o popup \"Alterações Não Salvas Detectadas\" para impedir a perda de dados?"
            },
            "onChangesNotDownloaded": {
              "value": "Usar o popup \"Alterações Não Baixadas\" para impedir a perda de dados?"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Propriedades do Sistema Java"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "Claro"
            },
            "dark": {
              "value": "Escuro"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "Usar Caixa de Diálogo"
            },
            "useCards": {
              "value": "Usar Cartões"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "ROOT do Windows"
            },
            "keyChainStore": {
              "value": "Armazenamento de Key Chain"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "O perfil \"{0}\" foi salvo com sucesso!"
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "Ações do Provedor "
        }
      },
      "info": {
        "tooltip": "Obter informações sobre este provedor"
      },
      "edit": {
        "tooltip": "Gerenciar definições deste provedor"
      },
      "deactivate": {
        "tooltip": "Desativar este provedor"
      },
      "delete": {
        "tooltip": "Remover este provedor"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "Projeto não Nomeado"
        },
        "name": {
          "value": "Nome do Provedor de Conexão"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "Substituição de Proxy"
        },
        "username": {
          "value": "Nome do Usuário"
        },
        "password": {
          "value": "Senha"
        }
      },
      "models": {
        "name": {
          "value": "Nome do Provedor de Modelo de WDT"
        },
        "file": {
          "value": "Nome do Arquivo de Modelo de WDT"
        },
        "props": {
          "value": "Variáveis de WDT"
        }
      },
      "composite": {
        "name": {
          "value": "Nome do Provedor de Modelo Composto de WDT"
        },
        "providers": {
          "value": "Modelos de WDT"
        }
      },
      "proplist": {
        "name": {
          "value": "Nome do Provedor da Lista de Propriedades"
        },
        "file": {
          "value": "Nome do Arquivo da Lista de Propriedades"
        }
      },
      "project": {
        "name": {
          "value": "Nome do Projeto"
        },
        "file": {
          "value": "Nome do Arquivo do Projeto"
        }
      },
      "provider": {
        "adminserver": {
          "value": "Conexão do Servidor de Administração"
        },
        "model": {
          "value": "Adicionar Modelo de WDT"
        }
      },
      "dropdown": {
        "none": {
          "value": "Nenhum"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "Nome do Projeto:"
          }
        },
        "provider": {
          "id": {
            "label": "Id do Provedor:"
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "Versão da Extensão da Console:"
          },
          "name": {
            "label": "Nome do Domínio:"
          },
          "url": {
            "label": "URL de Domínio:"
          },
          "proxyOverride": {
            "label": "Substituição de Proxy:"
          },
          "version": {
            "label": "Versão do Domínio:"
          },
          "username": {
            "label": "Nome do usuário:"
          },
          "sso": {
            "label": "Autenticação Web"
          },
          "roles": {
            "label": "Atribuições:"
          },
          "connectTimeout": {
            "label": "Timeout da Conexão:"
          },
          "readTimeout": {
            "label": "Time-out p/Leitura:"
          },
          "insecure": {
            "label": "Inseguro:"
          },
          "anyAttempt": {
            "label": "Quaisquer Conexões Tentadas:"
          },
          "lastAttempt": {
            "label": "Última Tentativa Bem-sucedida:"
          }
        },
        "model": {
          "file": {
            "label": "Arquivo:"
          },
          "props": {
            "label": "Variáveis:"
          }
        },
        "composite": {
          "models": {
            "label": "Modelos:"
          }
        },
        "proplist": {
          "file": {
            "label": "Nome do arquivo:"
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "Adicionar Provedor de Conexão do Servidor de Administração"
        }
      },
      "models": {
        "add": {
          "value": "Adicionar Provedor de Arquivo de Modelo de WDT"
        },
        "new": {
          "value": "Criar Provedor para Novo Arquivo de Modelo de WDT"
        }
      },
      "composite": {
        "add": {
          "value": "Adicionar Provedor de Arquivo de Modelo Composto de WDT"
        }
      },
      "proplist": {
        "add": {
          "value": "Adicionar Provedor de Lista de Propriedades"
        },
        "new": {
          "value": "Criar Provedor para Nova Lista de Propriedades"
        }
      },
      "providers": {
        "sort": {
          "value": "Classificar por Tipo de Provedor"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "URL de Domínio:"
              },
              "version": {
                "label": "Versão do Domínio:"
              },
              "username": {
                "label": "Nome de usuário:"
              }
            }
          },
          "model": {
            "file": {
              "label": "Arquivo:"
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "Exportar Provedores como Projeto..."
        },
        "import": {
          "value": "Importar Projeto"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "Digite as novas definições de nome e conectividade do provedor de conexão."
        },
        "edit": {
          "value": "Modifique as definições de conexão do provedor de conexão."
        },
        "deactivate": {
          "value": "Desative o provedor de conexão e interrompa a sondagem de status do domínio."
        }
      },
      "models": {
        "add": {
          "value": "Digite as definições do provedor de arquivo de modelo existente. Clique no ícone de upload para procurar o arquivo de modelo."
        },
        "new": {
          "value": "Digite o nome do provedor e o nome do usuário para o novo arquivo de modelo de WDT; em seguida, clique no ícone para selecionar o diretório no qual salvar o arquivo."
        },
        "edit": {
          "value": "Modifique as definições do provedor de arquivo de modelo. Clique no ícone para procurar o arquivo de modelo."
        }
      },
      "composite": {
        "add": {
          "value": "Digite um novo nome e selecione uma lista de modelos ordenada para o provedor de modelo composto."
        },
        "edit": {
          "value": "Modifique as definições para o provedor de modelo composto. Use uma lista ordenada de modelos."
        }
      },
      "proplist": {
        "add": {
          "value": "Digite as definições do provedor de lista de propriedades existente. Clique no ícone de upload para procurar um arquivo de propriedades."
        },
        "new": {
          "value": "Digite o nome do provedor e o nome do arquivo para uma nova lista de propriedades; em seguida, clique no ícone para selecionar o diretório no qual salvar o arquivo."
        },
        "edit": {
          "value": "Modifique as definições do provedor de lista de propriedades. Clique no ícone para procurar um arquivo de propriedades."
        }
      },
      "project": {
        "export": {
          "value": "Digite as definições do novo projeto."
        },
        "import": {
          "value": "Clique no ícone de download para procurar o projeto."
        }
      },
      "task": {
        "startup": {
          "value": "Você está interessado na execução de qual tarefa de inicialização?"
        }
      },
      "project-busy": {
        "value": "Salve ou abandone as alterações não salvas antes de fazer alterações em qualquer parte do projeto"
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "Criar Provedor para Conexão do Servidor de Administração"
        },
        "models": {
          "value": "Criar Provedor para Arquivo de Modelo de WDT Existente"
        },
        "composite": {
          "value": "Criar Provedor para Novo Modelo Composto de WDT"
        },
        "proplist": {
          "value": "Criar Provedor para Lista de Propriedades Existente"
        }
      },
      "new": {
        "models": {
          "value": "Criar Provedor para Novo Arquivo de Modelo de WDT"
        },
        "proplist": {
          "value": "Criar Provedor para Nova Lista de Propriedades"
        }
      },
      "edit": {
        "connections": {
          "value": "Editar Provedor de Conexão do Servidor de Administração"
        },
        "models": {
          "value": "Editar Provedor de Arquivo de Modelo de WDT"
        },
        "composite": {
          "value": "Editar Provedor de Arquivo de Modelo Composto de WDT"
        },
        "proplist": {
          "value": "Editar Provedor de Lista de Propriedades"
        }
      },
      "export": {
        "project": {
          "value": "Exportar Provedores como Projeto"
        }
      },
      "import": {
        "project": {
          "value": "Importar Projeto"
        }
      },
      "startup": {
        "task": {
          "value": "Tarefa de Inicialização"
        }
      },
      "project-busy": {
        "value": "Projeto Ocupado"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "Exportação Malsucedida",
          "detail": "Não é possível exportar provedores como projeto '{0}'."
        }
      },
      "import": {
        "failed": {
          "summary": "Salvamento Malsucedido",
          "detail": "Não é possível importar o arquivo do projeto '{0}'."
        }
      },
      "stage": {
        "failed": {
          "summary": "Criação Malsucedida",
          "detail": "Não é possível criar o item do provedor '{0}'."
        }
      },
      "use": {
        "failed": {
          "summary": "Conexão Malsucedida",
          "detail": "Não é possível usar o item do provedor '{0}'."
        }
      },
      "upload": {
        "failed": {
          "detail": "Não é possível carregar o arquivo de modelo de WDT: {0}"
        },
        "props": {
          "failed": {
            "detail": "Não é possível carregar as variáveis de WDT: {0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "Já existe o provedor '{0}' neste projeto!"
        },
        "modelsNotFound": {
          "detail": "Não é possível localizar os modelos de WDT configurados '{0}'"
        },
        "propListNotFound": {
          "detail": "Não é possível localizar as variáveis de WDT: '{0}'"
        },
        "selectModels": {
          "detail": "Para selecionar o Composto WDT, primeiro selecione todos os Modelos de WDT usados pelo Composto WDT."
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "O URL deve especificar o protocolo HTTPS ou usar localhost"
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>Edite o caminho no campo de nome de arquivo. Em seguida, clique no botão OK. Como alternativa, clique no ícone de upload e escolha outro arquivo.</p>"
        },
        "fixModelFile": {
          "detail": "<p>Corrija o(s) problema(s) mencionado(s) abaixo e, em seguida, clique no botão OK. Como alternativa, escolha outro arquivo.</p>"
        },
        "yamlException": {
          "detail": "{0} na linha {1}, coluna {2}"
        },
        "wktModelContent": {
          "summary": "Problemas de Conteúdo do Modelo",
          "detail": "Use o editor de modelos na guia <i>View de Código</i> para resolver problemas."
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "Não definido"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "Usar Modelo Esparso"
      },
      "usesso": {
        "label": "Usar Autenticação Web"
      },
      "insecure": {
        "label": "Tornar Conexão Não Segura"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "Editar Árvore"
      },
      "view": {
        "tooltip": "Árvore da View de Configuração"
      },
      "monitoring": {
        "tooltip": "Árvore de Monitoramento"
      },
      "security": {
        "tooltip": "Árvore de Dados de Segurança"
      },
      "modeling": {
        "tooltip": "Modelo de WDT"
      },
      "composite": {
        "tooltip": "Modelo Composto de WDT"
      },
      "properties": {
        "tooltip": "Editor de Lista de Propriedades"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "Menu de Árvores de Provedores"
      },
      "navtree": {
        "value": "Navegador em Árvore de Provedores"
      },
      "panelResizer": {
        "value": "Redimensionador do Navegador em Árvore de Provedores. Use as teclas de seta para a esquerda e para a direita para redimensionar o navegador"
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "Home. Retorne à página que contém os cartões das árvores do provedor"
        }
      },
      "region": {
        "title": {
          "value": "Cabeçalho da Área de Conteúdo"
        }
      },
      "popup": {
        "provider": {
          "value": "Ações do Provedor"
        }
      }
    },
    "title": {
      "home": "Início",
      "configuration": "Editar Árvore",
      "view": "Árvore da View de Configuração",
      "monitoring": "Árvore de Monitoramento",
      "security": "Árvore de Dados de Segurança",
      "modeling": "Modelo de WDT",
      "composite": "Modelo Composto de WDT",
      "properties": "Lista de Propriedades"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "Início"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "Clique para exibir as ações do carrinho de compras"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "Exibir Alterações..."
        },
        "discard": {
          "label": "Descartar Alterações"
        },
        "commit": {
          "label": "Fazer Commit de Alterações"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "Carrinho de Compras"
        },
        "ataglance": {
          "label": "Visão Rápida"
        },
        "projectmanagement": {
          "label": "Provedores"
        },
        "tips": {
          "label": "Dicas para o Usuário"
        },
        "dashboards": {
          "label": "Painéis de Controle"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "Dicas de Filtro",
        "checkboxes": {
          "hideall": "Ocultar Todas as Dicas",
          "productivity": "Mostrar Dicas de Produtividade",
          "personalization": "Mostrar Dicas de Personalização",
          "whereis": "Mostrar Dicas \"Onde Está...\"",
          "accessibility": "Mostrar Dicas de Acessibilidade",
          "connectivity": "Mostrar Dicas de Conectividade",
          "security": "Mostrar Dicas de Segurança",
          "other": "Mostrar Outras Dicas"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "Ocultar Tudo"
        },
        "productivity": {
          "value": "Produtividade"
        },
        "personalization": {
          "value": "Personalização"
        },
        "whereis": {
          "value": "Onde Está..."
        },
        "accessibility": {
          "value": "Acessibilidade"
        },
        "connectivity": {
          "value": "Conectividade"
        },
        "security": {
          "value": "Segurança"
        },
        "other": {
          "value": "Outro"
        }
      },
      "cards": {
        "tip0": {
          "title": "Pesquise em todos os MBeans do seu domínio!",
          "descriptionHTML": "<p>Digite um termo de pesquisa no campo de pesquisa na parte superior da console para vasculhar a perspectiva atual em busca de correspondências. Vocêtambém pode verificar novamente as consultas anteriores no nó <b>Pesquisas Recentes</b>.</p>"
        },
        "tip1": {
          "title": "Filtre e encontre rapidamente dados que são importantes para você!",
          "descriptionHTML": "<p>Os painéis de controle permitem que você defina critérios personalizados, compare-os com seu domínio e gere relatórios abrangentes e precisos com base no seu domínio.</p><p>Para começar, abra qualquer nó na <b>Árvore de Monitoramento</b> e clique em <b>Novo Painel de Controle</b>. Como alternativa, abra o nó de nível superior <b>Painéis de Controle</b> para ver os painéis de controle incorporados.</p>"
        },
        "tip2": {
          "title": "Refinar o conteúdo da tabela",
          "descriptionHTML": "<p>Simplifique as tabelas ocultando colunas irrelevantes para poder focar nos dados do seu interesse.</p><p>Acima de qualquer tabela, clique em <b>Personalizar Tabela</b> e marque ou desmarque as colunas conforme desejar.</p>"
        },
        "tip3": {
          "title": "Usando o Teclado com Tabelas e Ações",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "Onde está o Link \"Personalizar esta tabela\"?",
          "descriptionHTML": "<p>O link \"Personalizar esta tabela\" agora é o botão <i>Personalizar Tabela</i>.</p>"
        },
        "tip5": {
          "title": "Verificar alterações pendentes",
          "descriptionHTML": "<p>Abra o Carrinho de Compras para ver uma lista das alterações salvas no domínio, mas ainda não confirmadas.</p><p>Caso você não veja a opção <b>Exibir Alterações</b> no Carrinho de Compras, tente <a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>instalar a extensão do WebLogic Remote Console</a>."
        },
        "tip6": {
          "title": "Precisa de ajuda?",
          "descriptionHTML": "<ul><li>Passe o mouse sobre o ponto de interrogação <b>?</b> ao lado de um campo para ver dicas de ferramentas.</li><li>Clique no <b>?</b> no nível da página para obter ajuda detalhada sobre cada atributo visível.</li><li>No menu <b>Ajuda</b>, clique em <b>Visitar Projeto GitHub do WebLogic Remote Console</b>.</li><li>Entre para o nosso canal do Slack: <a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>.</li><li>Visite nossa documentação em <a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>.</li></ul>"
        },
        "tip7": {
          "title": "Outra Dica N.º 1",
          "descriptionHTML": "<p>Uma descrição curta para \"Outra Dica N.º 1\". Um caractere de nova linha não é um elemento HTML; portanto, você não precisa usá-lo nesta descrição.</p>"
        },
        "tip8": {
          "title": "Algum problema na conexão com um servidor?",
          "descriptionHTML": "<p>Em <b>Árvore de Monitoramento</b> > <b>Ambiente</b> > <b>Servidores</b>, selecione o servidor que não está respondendo e abra a guia <b>Diagnóstico e Solução de Problemas</b> para avaliar e diagnosticar o problema.</p><p>Se não for possível estabelecer conexão com o domínio de forma alguma, consulte <a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>Não é possível estabelecer conexão com o Servidor de Administração</a> na documentação do WebLogic Remote Console para obter ajuda no diagnóstico e solução de problemas.</p>"
        },
        "tip9": {
          "title": "Dica de Conectividade N.º 2",
          "descriptionHTML": "<p>Uma descrição curta para \"Dica de Conectividade N.º 2\". Um caractere de nova linha não é um elemento HTML; portanto, você não precisa usá-lo nesta descrição.</p>"
        },
        "tip10": {
          "title": "Dicas de Segurança N.º 1",
          "descriptionHTML": "<p>Uma descrição curta para \"Dica de Segurança N.º 1\". Um caractere de nova linha não é um elemento HTML; portanto, você não precisa usá-lo nesta descrição.</p>"
        },
        "tip11": {
          "title": "Acelere seu workflow!",
          "descriptionHTML": "<p>Use atalhos de teclado para ir diretamente para componentes específicos da interface do usuário.</p><p>5 Principais:</p><li><code><b>Alt+P</b></code> - Abre a gaveta <b>Provedores</b>.</li><li><code><b>Alt+C</b></code> - Move o foco para o <b>Carrinho de Compras</b>.</li><li><code><b>Alt+T</b></code> - Move o foco para o primeiro cabeçalho de coluna em uma tabela.</li><li><code><b>Alt+|</b></code> - Move o foco para o controlador de largura da Árvore de Navegação. Use as teclas de seta para alterar a largura da árvore.</li><li><code><b>Alt+;</b></code> - Move o foco para o primeiro label de trilha de navegação clicável.</li></ul><p>Para obter uma lista completa de atalhos de teclado, consulte a documentação.</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "Navegações estruturais"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "Histórico"
      },
      "separator": {
        "tooltip": "Separador"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "Limpar Entradas do Histórico",
          "label": "Limpar Entradas do Histórico"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "executando às {0}"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "Conexão Perdida",
        "detail": "Conexão perdida. Atualize."
      },
      "cannotConnect": {
        "summary": "Falha na Tentativa de Conexão",
        "detail": "Não é possível estabelecer conexão com o Domínio do WebLogic {0}; verifique se o WebLogic está em execução."
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "Árvores"
        },
        "startup-tasks": {
          "label": "Tarefas de Inicialização"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Página de Destino"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "Links da Página de Destino"
        }
      },
      "screenreader": {
        "value1": "Você está no item {0}. Pressione Enter para selecionar.",
        "value2": "Você está no item {0}. Pressionar Enter o expandirá ou contrairá. Após a expansão, use a seta para baixo para acessar links relacionados.",
        "value3": "{0}. Pressione Tab/Shift+Tab para mover entre links relacionados e Escape para retornar ao item de nível superior visitado por último."
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Árvores de Provedores"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "Editar Árvore",
        "description": "<p>Mantenha a configuração do domínio do WebLogic com o qual você está trabalhando no momento.</p>"
      },
      "view": {
        "label": "Árvore da View de Configuração",
        "description": "<p>Examine a configuração somente para leitura do domínio do WebLogic com o qual você está trabalhando no momento.</p>"
      },
      "monitoring": {
        "label": "Árvore de Monitoramento",
        "description": "<p>Exiba informações de MBean de runtime para recursos selecionados no domínio do WebLogic com o qual você está trabalhando no momento.</p>"
      },
      "security": {
        "label": "Árvore de Dados de Segurança",
        "description": "<p>Gerencie informações relacionadas a segurança (por exemplo, usuários, grupos, atribuições, políticas, credenciais etc.) no domínio do WebLogic com o qual você está trabalhando no momento.</p>"
      },
      "modeling": {
        "label": "Árvore de Modelo de WDT",
        "description": "<p>Mantenha os arquivos de modelo associados à ferramenta WebLogic Deploy Tooling.</p>"
      },
      "composite": {
        "label": "Árvore de Modelos Compostos de WDT",
        "description": "<p>Veja um conjunto combinado de arquivos de modelo de WebLogic Deploy Tooling com o qual você está trabalhando no momento.</p>"
      },
      "properties": {
        "label": "Editor de Lista de Propriedades",
        "description": "<p>Exiba ou modifique um conjunto de propriedades com base em um arquivo de lista de propriedades.</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Tarefas de Inicialização"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "Adicionar Provedor de Conexão do Servidor de Administração",
        "description": "Esta tarefa cria um recurso de projeto que permite estabelecer conexão com um Servidor de Administração"
      },
      "addWdtModel": {
        "label": "Adicionar Provedor de Arquivo de Modelo de WDT",
        "description": "Esta tarefa cria um recurso de projeto que permite gerenciar um arquivo de Modelo do WDT existente no seu sistema de arquivos local"
      },
      "addWdtComposite": {
        "label": "Adicionar Provedor de Arquivo de Modelo Composto de WDT",
        "description": "Esta tarefa cria um recurso de projeto que permite gerenciar fragmentos de um arquivo de Modelo do WDT existente no seu sistema de arquivos local"
      },
      "addPropertyList": {
        "label": "Adicionar Provedor de Lista de Propriedades",
        "description": "Esta tarefa cria um recurso de projeto que permite gerenciar um arquivo .properties armazenado no seu sistema de arquivos local"
      },
      "createWdtModel": {
        "label": "Criar Provedor para Novo Arquivo de Modelo de WDT",
        "description": "Esta tarefa cria um recurso de projeto que é um novo arquivo de Modelo do WDT armazenado no seu sistema de arquivos local"
      },
      "createPropertyList": {
        "label": "Criar Provedor para Nova Lista de Propriedades",
        "description": "Esta tarefa cria um recurso de projeto que é um novo arquivo .properties armazenado no seu sistema de arquivos local"
      },
      "importProject": {
        "label": "Importar Projeto",
        "description": "Esta tarefa carrega um projeto exportado anteriormente, contendo provedores imediatamente prontos para você usar ou modificar"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "Descartar Alterações"
      },
      "commit": {
        "tooltip": "Fazer Commit de Alterações"
      }
    },
    "sections": {
      "changeManager": {
        "label": "Gerenciador de Alterações"
      },
      "additions": {
        "label": "Inclusões"
      },
      "modifications": {
        "label": "Modificações"
      },
      "removals": {
        "label": "Remoções"
      },
      "restart": {
        "label": "Reiniciar"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "Novo"
      },
      "clone": {
        "label": "Clonar"
      },
      "delete": {
        "label": "Excluir"
      },
      "customize": {
        "label": "Personalizar Tabela"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "Página de Destino"
      },
      "history": {
        "tooltip": "Alternar visibilidade do histórico"
      },
      "instructions": {
        "tooltip": "Alternar visibilidade das instruções"
      },
      "help": {
        "tooltip": "Alternar visibilidade da página de Ajuda"
      },
      "sync": {
        "tooltip": "Recarregar",
        "tooltipOn": "Interromper Recarga Automática"
      },
      "syncInterval": {
        "tooltip": "Definir Intervalo de Recarga Automática"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "Selecione os itens nos quais você deseja executar a operação '{0}'."
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "Mensagem",
          "detail": "Não é possível executar a ação '{0}' enquanto a recarga automática está em execução! Clique no ícone '{1}' para interrompê-la primeiro."
        }
      }
    },
    "prompts": {
      "download": {
        "value": "Locais de arquivos de log baixados:"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "Mostrar Colunas Ocultas"
      }
    },
    "labels": {
      "totalRows": {
        "value": "Total de Linhas: {0}"
      },
      "reloadHidden": {
        "value": "Recarregar a tabela para ver os valores {0} atuais"
      },
      "noData": {
        "value": "Não foram encontrados dados."
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "Colunas Disponíveis"
        },
        "list": {
          "value": "Lista de Colunas Disponíveis"
        },
        "listItem": {
          "value": "Item da Lista de Colunas Disponíveis"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "Colunas Selecionadas"
        },
        "list": {
          "value": "Lista de Colunas Selecionadas"
        },
        "listItem": {
          "value": "Item da Lista de Colunas Selecionadas"
        }
      },
      "button": {
        "addToRight": {
          "value": "Mova os itens marcados na lista Colunas Disponíveis para a lista Colunas Selecionadas"
        },
        "addAllRight": {
          "value": "Mova todos os itens na lista Colunas Disponíveis para a lista Colunas Selecionadas"
        },
        "removeRight": {
          "value": "Mova os itens marcados na lista Colunas Selecionadas para a lista Colunas Disponíveis"
        },
        "removeAll": {
          "value": "Mova todos os itens na lista Colunas Selecionadas para a lista Colunas Disponíveis"
        },
        "reset": {
          "value": "Restaure as colunas na lista Colunas Selecionadas para aquelas presentes quando o personalizador de tabela foi aberto."
        },
        "apply": {
          "value": "Aplicar personalizações de coluna à tabela"
        },
        "cancel": {
          "value": "Cancelar todas as personalizações de coluna"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "Salvar"
      },
      "new": {
        "label": "Criar"
      },
      "delete": {
        "label": "Remover"
      },
      "back": {
        "label": "Voltar"
      },
      "next": {
        "label": "Próximo"
      },
      "finish": {
        "label": "Criar"
      },
      "customize": {
        "label": "Personalizar Tabela"
      },
      "dashboard": {
        "label": "Novo Painel de Controle"
      }
    },
    "icons": {
      "save": {
        "tooltip": "Salvar"
      },
      "create": {
        "tooltip": "Criar"
      },
      "landing": {
        "tooltip": "Página de Destino"
      },
      "history": {
        "tooltip": "Alternar visibilidade do histórico"
      },
      "instructions": {
        "tooltip": "Alternar visibilidade das instruções"
      },
      "help": {
        "tooltip": "Alternar visibilidade da página de Ajuda"
      },
      "sync": {
        "tooltip": "Recarregar",
        "tooltipOn": "Interromper Recarga Automática"
      },
      "syncInterval": {
        "tooltip": "Definir Intervalo de Recarga Automática"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "Mostrar Campos Avançados"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "Clique no ícone {0} para alternar entre a ajuda resumida e a detalhada."
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "As alterações foram adicionadas ao carrinho!",
        "generic": "As alterações foram salvas!",
        "notSaved": "Nada salvo porque não foram detectadas alterações."
      },
      "action": {
        "notAllowed": {
          "summary": "Ação Não Permitida",
          "detail": "Não é possível executar a ação solicitada durante uma operação de criação. Clique no botão Cancelar para cancelar a operação de criação."
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "Reinicialização do Servidor ou do Aplicativo Obrigatória"
      },
      "wdtIcon": {
        "tooltip": "Definições de WDT"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "Tabela de Ajuda",
        "columns": {
          "header": {
            "name": "Nome",
            "description": "Descrição"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>Tópicos Relacionados:</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "Atributos"
      },
      "actions": {
        "label": "Ações"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "Campos Obrigatórios Incompletos",
        "detail": "O campo {0} é obrigatório, mas nenhum valor (ou um valor inválido) foi fornecido."
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "Adicionar Condição"
        },
        "combine": {
          "label": "Combinar"
        },
        "uncombine": {
          "label": "Não Combinar"
        },
        "moveup": {
          "label": "Mover para cima"
        },
        "movedown": {
          "label": "Mover para baixo"
        },
        "remove": {
          "label": "Remover"
        },
        "negate": {
          "label": "Negar"
        },
        "reset": {
          "label": "Redefinir"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "Adicionar Nova Primeira Condição..."
          },
          "above": {
            "label": "Adicionar Condição acima da Linha Clicada..."
          },
          "below": {
            "label": "Adicionar Condição abaixo da Linha Clicada..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "Adicionar Condição Marcada acima..."
          },
          "below": {
            "label": "Adicionar Condição Marcada abaixo..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "Um ou mais dos campos obrigatórios não contêm dados!"
      },
      "argumentValueHasWrongFormat": {
        "summary": "O campo '{0}' contém dados formatados incorretamente!"
      },
      "conditionHasNoArgValues": {
        "summary": "A condição selecionada não tem valores de argumento para editar!"
      },
      "conditionAlreadyExists": {
        "summary": "Esta política de segurança já tem uma condição criada usando o predicado selecionado ou um predicado com valores de argumento correspondentes!"
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>Para especificar a localização da nova condição, coloque uma marca de seleção próximo à condição relativa e, em seguida, clique no botão <b>+Adicionar Condição</b>.</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "Faixa: -31 a 31"
      },
      "dateTime": {
        "value": "Formato: aaaa-MM-dd [HH:mm:ss [AM|PM]] (por exemplo, 2022-02-14 09:00:00 AM)"
      },
      "time": {
        "value": "Formato: HH:mm:ss (ex.: 14:22:47)"
      },
      "gmtOffset": {
        "value": "Formato: GMT+|-h:mm (ex.: GMT-5:00)"
      },
      "weekDay": {
        "value": "ex.: domingo, segunda-feira, terça-feira,..."
      },
      "or": {
        "value": "ou"
      },
      "not": {
        "value": "NOT"
      },
      "combination": {
        "value": "Combinação"
      },
      "nodata": {
        "Policy": {
          "value": "Use o botão <b>+ Adicionar Condição</b> para adicionar uma condição de política."
        },
        "DefaultPolicy": {
          "value": "Não há condições de política de segurança padrão definidas."
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "Combinação",
            "operator": "Operador",
            "expression": "Expressão de Condição"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "Or",
            "and": "And"
          }
        }
      }
    },
    "wizard": {
      "title": "Gerenciamento de Políticas",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "Escolha um Predicado",
            "instructions": "Escolha na lista dropdown o predicado para sua nova condição."
          },
          "body": {
            "labels": {
              "predicateList": "Lista de Predicados"
            },
            "help": {
              "predicateList": "A lista de predicados é uma lista de predicados disponíveis que podem ser usados para criar uma condição da política de segurança."
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "Predicado do Grupo",
            "instructions": "Comece digitando no campo <i></i> para adicionar valores de argumento ou procurar os existentes. Pressione Enter para adicionar o valor digitado à lista. Para editar o valor do argumento existente, clique nele e modifique usando o campo de entrada de dados popup."
          },
          "body": {
            "labels": {
              "conditionPhrase": "Expressão de Condição",
              "negate": "Negar Condição"
            },
            "help": {
              "negate": "Converte a condição para ter o significado oposto (por exemplo, \"é igual\" torna-se \"não é igual\", \"em\" torna-se \"não está em\")."
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "Árvore"
      },
      "page": {
        "value": "Página"
      },
      "tab": {
        "value": "Guia"
      },
      "ariaLabel": {
        "value": "Histórico de Páginas"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "A Página Não Existe Mais",
        "detail1": "Você foi redirecionado para a página {0} porque ",
        "detail2": "{0} foi excluída por outro usuário ou não existe mais."
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "Marcadores de Página"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "Adicionar Marcador para a Página Atual"
        },
        "show": {
          "label": "Mostrar Marcadores de Página..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "Já existe um marcador para esta página! "
      },
      "pagesBookmarkAdded": {
        "summary": "A página atual foi marcada com sucesso! "
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "Retorne à Página de Destino da árvore do provedor."
        },
        "reset": {
          "value": "Atualizar valores de página"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "Ação"
      },
      "apply": {
        "label": "Aplicar"
      },
      "reset": {
        "label": "Redefinir"
      },
      "ok": {
        "label": "OK"
      },
      "cancel": {
        "label": "Cancelar"
      },
      "restart": {
        "label": "Reiniciar"
      },
      "yes": {
        "label": "Sim"
      },
      "no": {
        "label": "Não"
      },
      "choose": {
        "label": "Escolher"
      },
      "connect": {
        "label": "Conectar"
      },
      "add": {
        "label": "Adicionar/Enviar"
      },
      "edit": {
        "label": "Editar/Enviar"
      },
      "import": {
        "label": "Importar"
      },
      "export": {
        "label": "Exportar"
      },
      "write": {
        "label": "Arquivo p/Download"
      },
      "savenow": {
        "label": "Salvar Agora"
      },
      "next": {
        "label": "Próximo"
      },
      "previous": {
        "label": "Anterior"
      },
      "finish": {
        "label": "Finalizar"
      },
      "done": {
        "label": "Concluído"
      },
      "close": {
        "label": "Fechar"
      },
      "clear": {
        "label": "Remover"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "Contrair"
      },
      "expand": {
        "value": "Expandir"
      },
      "choose": {
        "value": "Escolher Arquivo"
      },
      "clear": {
        "value": "Remover Arquivo Escolhido"
      },
      "more": {
        "value": "Mais Ações"
      },
      "download": {
        "value": "Procurar"
      },
      "reset": {
        "value": "Redefinir"
      },
      "filter": {
        "value": "Filtro"
      },
      "submit": {
        "value": "Submeter Alterações"
      },
      "write": {
        "value": "Arquivo p/Download"
      },
      "pick": {
        "value": "Selecionar Diretório"
      },
      "reload": {
        "value": "Recarregar Arquivo"
      },
      "delete": {
        "value": "Excluir"
      },
      "remove": {
        "value": "Remover"
      },
      "noData": {
        "value": "Sem Dados"
      },
      "preloader": {
        "value": "Preloader"
      },
      "checkAll": {
        "value": "Marcar Tudo"
      },
      "checkNone": {
        "value": "Desmarcar Tudo"
      },
      "checkSome": {
        "value": "Remover Itens Marcados"
      },
      "close": {
        "value": "Fechar"
      },
      "recentPages": {
        "value": "Alternar visibilidade do histórico"
      },
      "pagesHistory": {
        "back": {
          "value": "Página Anterior"
        },
        "next": {
          "value": "Próxima Página"
        },
        "launch": {
          "value": "Mostrar Histórico de Páginas"
        },
        "star": {
          "value": "Marcadores de Página"
        }
      },
      "pageInfo": {
        "value": "Clique para fixar e desafixar"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "Escolher Arquivo..."
      },
      "chooseDir": {
        "value": "Escolher Diretório..."
      }
    },
    "labels": {
      "info": {
        "value": "Informações"
      },
      "warn": {
        "value": "Advertência"
      },
      "error": {
        "value": "Erro"
      },
      "alerts": {
        "value": "Alertas"
      },
      "pagesHistory": {
        "value": "Aqui estão as páginas visitadas desde a seleção do provedor atual. Clique em qualquer coluna na linha para navegar até a página associada."
      },
      "pagesBookmark": {
        "value": "Aqui estão as páginas marcadas para o tipo de provedor {0}. Clique em qualquer coluna na linha para navegar até a página associada."
      }
    },
    "placeholders": {
      "search": {
        "value": "Pesquisar"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "Conteúdo Incorreto Detectado"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "'{0}' contém JSON, mas não é uma representação JSON de um(a) {1}!"
      },
      "dataCopiedToClipboard": {
        "detail": "Os dados foram copiados para a área de transferência!"
      },
      "tableCopiedToClipboard": {
        "summary": "A tabela foi copiada com sucesso para a área de transferência!"
      },
      "emptyCellData": {
        "detail": "Dados não copiados para a área de transferência porque a célula selecionada estava vazia!"
      },
      "emptyRowData": {
        "detail": "Dados não copiados para a área de transferência porque a linha selecionada estava vazia!"
      },
      "browserPermissionDenied": {
        "summary": "Permissão de Browser Negada",
        "detail": "Para poder executar esta operação, é necessário ativar a gravação na área de transferência pelo JavaScript. Além disso, só há suporte para a API da Área de Transferência em páginas servidas por HTTPS."
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "Copiar Célula para a Área de Transferência"
        },
        "row": {
          "label": "Copiar Linha para a Área de Transferência"
        },
        "tableAsText": {
          "label": "Copiar Tabela para a Área de Transferência (Texto)"
        },
        "tableAsJSON": {
          "label": "Copiar Tabela para a Área de Transferência (JSON)"
        },
        "tableAsYAML": {
          "label": "Copiar Tabela para a Área de Transferência (YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "Contrair Tudo"
      },
      "useTreeMenusAsRootNodes": {
        "value": "Usar Menus em Árvore como Nós Raiz"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "As alterações foram salvas com sucesso no arquivo '{0}'!"
      },
      "changesNotSaved": {
        "summary": "Não é possível salvar as alterações no arquivo '{0}'!"
      },
      "changesDownloaded": {
        "summary": "As alterações foram baixadas com sucesso para o arquivo '{0}'!"
      },
      "changesNotDownloaded": {
        "summary": "Não é possível fazer download das alterações no arquivo '{0}'!"
      },
      "verifyPathEntered": {
        "detail": ". A definição do campo {0} como falso aceitará o valor inserido, sem validar sua existência como um arquivo ou diretório local."
      }
    },
    "wdtOptionsDialog": {
      "title": "Editar: {0}",
      "default": "Cancelar a Definição do Valor",
      "instructions": "Digite o token a ser adicionado à lista de itens selecionáveis.",
      "enterValue": "Informar Valor",
      "selectValue": "Selecionar Valor",
      "selectSwitch": "Alternar Valor",
      "enterUnresolvedReference": "Digitar Referência Não Resolvida",
      "enterModelToken": "Digitar Token de Modelo",
      "selectPropsVariable": "Selecionar Variável de Token de Modelo",
      "createPropsVariable": "Criar Variável de Token de Modelo",
      "propName": "Nome da Variável (Obrigatório)",
      "propValue": "Valor da Variável",
      "enterVariable": "Inserir Variável",
      "variableName": "Nome da Variável (Obrigatório)",
      "variableValue": "Valor da Variável",
      "multiSelectUnset": "Selecione um Valor na Lista de Itens Disponíveis"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "Alterações Não Salvas Detectadas"
      },
      "changesNeedDownloading": {
        "value": "Alterações Não Baixadas"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "Todas as alterações não salvas serão perdidas. Continuar?"
        },
        "areYouSure": {
          "value": "Tem certeza de que deseja {0} sem salvar suas alterações?"
        },
        "saveBeforeExiting": {
          "value": "Deseja salvar as alterações antes de sair?"
        },
        "needDownloading": {
          "value": "Suas alterações em '{0}' não foram baixadas para o arquivo.<br/><br/>Fazer o download delas antes de continuar?"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "Sua nova instância do '{0}' não foi adicionada ao modelo do WDT.<br/><br/>Adicioná-la antes de continuar?"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "Definir Intervalo de Recarga Automática",
      "instructions": "Quantos segundos você deseja configurar para o intervalo de recarga automática?",
      "fields": {
        "interval": {
          "label": "Intervalo de Recarga Automática:"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "Mensagem",
          "detail": "A chamada de backend da console gerou uma resposta '{0}' ao tentar executar a ação '{1}'"
        },
        "actionNotPerformed": {
          "detail": "Não é possível executar a ação '{0}' em um ou mais dos itens assinalados"
        },
        "actionNotPerformedNoRow": {
          "detail": "Não é possível executar a ação '{0}'"
        },
        "actionSucceeded": {
          "summary": "A ação '{0}' foi realizada com sucesso!"
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "Não é possível determinar a causa exata. Verifique as dicas na Console do JavaScript."
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "Confirmação da Ação",
        "prompt": "A ação '{0}' não pode ser desfeita!<br/><br/>Continuar?"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "Disponíveis",
        "chosen": "Escolhidos"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "Nome da Propriedade",
        "value": "Valor da Propriedade"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "Nome de Propriedades",
        "valueHeader": "Valor de Propriedades",
        "addButtonTooltip": "Adicionar",
        "deleteButtonTooltip": "Excluir"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "Exibir {0}..."
          },
          "create": {
            "label": "Criar Novo(a) {0}..."
          },
          "edit": {
            "label": "Editar {0}..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "Restaurar para o padrão"
    },
    "placeholder": {
      "value": "padrão"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "'{0}' não está disponível."
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "RUNNING"
      },
      "shutdown": {
        "value": "SHUTDOWN"
      },
      "serverStates": {
        "value": "Estados do Servidor"
      },
      "systemStatus": {
        "value": "Status do Sistema"
      },
      "healthState": {
        "failed": {
          "value": "Com falha"
        },
        "critical": {
          "value": "Crítico"
        },
        "overloaded": {
          "value": "Sobrecarregado"
        },
        "warning": {
          "value": "Advertência"
        },
        "ok": {
          "value": "OK"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "Condição dos Servidores em Execução a partir de"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "Nome"
        },
        "state": {
          "value": "Estado"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "O backend não está acessível no momento."
      },
      "connectionMessage": {
        "summary": "Mensagem de Conexão"
      },
      "connectFailed": {
        "detail": "Falha na Tentativa: "
      },
      "badRequest": {
        "detail": "Não é possível processar o arquivo ou a solicitação submetida"
      },
      "invalidCredentials": {
        "detail": "As credenciais do Domínio do WebLogic não são válidas"
      },
      "invalidUrl": {
        "detail": "O URL do Domínio do WebLogic não está acessível"
      },
      "notInRole": {
        "detail": "Falha na Tentativa: O usuário não é um Administrador, Implantador, Operador ou Monitor"
      },
      "notSupported": {
        "detail": "Não há suporte para o Domínio do WebLogic"
      },
      "unexpectedStatus": {
        "detail": "Resultado inesperado: (status: {0})"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "Solicitação Malsucedida",
          "detail": "Uma resposta indicadora de falha foi retornada de uma chamada de backend da console."
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "Consulte o terminal da console remota ou a console do Javascript para ver o(s) motivo(s) específico(s)."
      },
      "responseMessages": {
        "summary": "Mensagens de Resposta"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "Confirmação"
      },
      "prompt": {
        "value": "O shutdown de <b>{0}</b> redefinirá o provedor atual. Deseja continuar?"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "Não é possível acessar o gerenciador de alterações!"
      },
      "changesCommitted": {
        "summary": "O commit das alterações foi feito com sucesso!"
      },
      "changesNotCommitted": {
        "summary": "Não é possível fazer commit das alterações!"
      },
      "changesDiscarded": {
        "summary": "As alterações foram descartadas com sucesso!"
      },
      "changesNotDiscarded": {
        "summary": "Não é possível descartar as alterações!"
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "Resposta ao Erro Inesperada"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "Problema de Conexão",
        "details": "Problemas ao enviar e receber dados do provedor! Certifique-se de que eles estejam acessíveis antes de continuar."
      },
      "pathNotFound": {
        "summary": "Caminho Não Encontrado",
        "details": "'{0}' não é um arquivo ou diretório acessível no sistema de arquivos local."
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "Linha de Mensagem"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "Mensagem de Remoção"
        },
        "suppress": {
          "info": {
            "label": "Suprimir Mensagens de Informações"
          },
          "warning": {
            "label": "Suprimir Mensagens de Advertência"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " Não é possível estabelecer conexão com o servidor de administração do domínio do WebLogic."
      },
      "shutdownSequenceError": {
        "details": "Faça shut down dos servidores gerenciados e, em seguida, faça shut down do servidor de administração."
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "Você tem {0} alerta(s) de erro de alta prioridade"
        },
        "warning": {
          "value": "Você tem {0} alerta(s) de advertência de alta prioridade"
        },
        "info": {
          "value": "Você tem {0} alerta(s) de informações de alta prioridade"
        },
        "view": {
          "value": "Exibir Alertas"
        }
      }
    }
  }
});