define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "애플리케이션 헤더"
      }
    },
    "buttons": {
      "logout": {
        "label": "로그아웃"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "탐색 트리 표시 토글"
        }
      },
      "theme": {
        "tooltip": "테마 전환"
      },
      "whatsNew": {
        "tooltip": "새로운 기능!"
      },
      "howDoI": {
        "tooltip": "\"방법...?\" 태스크 열기"
      },
      "tips": {
        "tooltip": "사용자 팁 가시성 토글"
      },
      "help": {
        "tooltip": "WebLogic Remote Console 내부 문서 열기"
      },
      "profile": {
        "tooltip": "프로파일"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "메시지 센터 열기"
      },
      "theme": {
        "light": {
          "value": "밝게"
        },
        "dark": {
          "value": "어둡게"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "눌러서 WebLogic Remote Console 재설정"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "Copyright (c) 2020, 2025, Oracle and/or its affiliates.<br/>Oracle (r)과 Java, MySQL 및 NetSuite는 Oracle Corporation 및/또는 그 자회사의 등록상표입니다. 기타 명칭들은 각 소속 회사의 상표일 수 있습니다.<br/>",
      "builtWith": "Oracle JET로 구축됨"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "안전하지 않음"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "관리 서버 접속이 안전하지 않음"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "프로파일 목록 표시"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "프로파일 관리"
          },
          "editor": {
            "tooltip": "프로파일 편집기",
            "toolbar": {
              "save": {
                "tooltip": "프로파일 저장"
              },
              "activate": {
                "tooltip": "활성 프로파일"
              },
              "add": {
                "tooltip": "프로파일 추가"
              },
              "remove": {
                "tooltip": "프로파일 삭제"
              }
            }
          }
        },
        "image": {
          "tooltip": "프로파일",
          "capture": {
            "tooltip": "이미지 추가 또는 변경"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "일반"
        },
        "settings": {
          "value": "설정"
        },
        "preferences": {
          "value": "환경설정"
        },
        "properties": {
          "value": "속성"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "이미지 변경"
      },
      "clearImage": {
        "value": "이미지 지우기"
      },
      "profile": {
        "default": {
          "value": "기본 프로파일"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "프로파일 편집기 표시"
            },
            "hide": {
              "value": "프로파일 편집기 숨기기"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "프로파일 관리자 열기"
          },
          "signout": {
            "value": "사인아웃"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "프로파일 ID"
          },
          "organization": {
            "value": "조직"
          },
          "name": {
            "value": "이름"
          },
          "email": {
            "value": "전자메일"
          },
          "role": {
            "default": {
              "value": "기본 프로파일로 사용"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "프로젝트를 위해 암호화된 인증서 저장?"
            },
            "disableHNV": {
              "value": "호스트 이름 확인 사용 안함?"
            },
            "proxyAddress": {
              "value": "프록시 주소"
            },
            "trustStoreType": {
              "value": "보안 저장소 유형"
            },
            "trustStorePath": {
              "value": "보안 저장소 경로"
            },
            "trustStoreKey": {
              "value": "보안 저장소 키"
            },
            "connectionTimeout": {
              "value": "관리 서버 접속 시간 초과"
            },
            "readTimeout": {
              "value": "관리 서버 읽기 시간 초과"
            }
          },
          "preferences": {
            "theme": {
              "value": "테마"
            },
            "startupTaskChooserType": {
              "value": "시작 태스크 선택기 유형"
            },
            "useTreeMenusAsRootNodes": {
              "value": "트리 메뉴를 트리 탐색기의 루트 레벨로 사용?"
            },
            "onQuit": {
              "value": "애플리케이션 종료를 막기 위해 저장되지 않은 변경사항 허용?"
            },
            "onDelete": {
              "value": "모든 삭제 확인?"
            },
            "onActionNotAllowed": {
              "value": "데이터 손실을 막기 위해 \"허용되지 않는 작업\" 팝업 사용?"
            },
            "onUnsavedChangesDetected": {
              "value": "데이터 손실을 막기 위해 \"저장되지 않은 변경사항이 감지됨\" 팝업 사용?"
            },
            "onChangesNotDownloaded": {
              "value": "데이터 손실을 막기 위해 \"변경사항이 다운로드되지 않음\" 팝업 사용?"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Java 시스템 속성"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "밝게"
            },
            "dark": {
              "value": "어둡게"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "대화상자 사용"
            },
            "useCards": {
              "value": "카드 사용"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "Windows ROOT"
            },
            "keyChainStore": {
              "value": "키 체인 저장소"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "\"{0}\" 프로파일이 성공적으로 저장되었습니다!"
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "제공자 작업 "
        }
      },
      "info": {
        "tooltip": "이 제공자에 대한 정보 가져오기"
      },
      "edit": {
        "tooltip": "이 제공자에 대한 설정 관리"
      },
      "deactivate": {
        "tooltip": "이 제공자 비활성화"
      },
      "delete": {
        "tooltip": "이 제공자 제거"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "이름 없는 프로젝트"
        },
        "name": {
          "value": "접속 제공자 이름"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "프록시 무효화"
        },
        "username": {
          "value": "사용자 이름"
        },
        "password": {
          "value": "비밀번호"
        }
      },
      "models": {
        "name": {
          "value": "WDT 모델 제공자 이름"
        },
        "file": {
          "value": "WDT 모델 파일 이름"
        },
        "props": {
          "value": "WDT 변수"
        }
      },
      "composite": {
        "name": {
          "value": "WDT 조합 모델 제공자 이름"
        },
        "providers": {
          "value": "WDT 모델"
        }
      },
      "proplist": {
        "name": {
          "value": "속성 목록 제공자 이름"
        },
        "file": {
          "value": "속성 목록 파일 이름"
        }
      },
      "project": {
        "name": {
          "value": "프로젝트 이름"
        },
        "file": {
          "value": "프로젝트 파일 이름"
        }
      },
      "provider": {
        "adminserver": {
          "value": "관리 서버 접속"
        },
        "model": {
          "value": "WDT 모델 추가"
        }
      },
      "dropdown": {
        "none": {
          "value": "없음"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "프로젝트 이름:"
          }
        },
        "provider": {
          "id": {
            "label": "제공자 ID:"
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "콘솔 확장 버전:"
          },
          "name": {
            "label": "도메인 이름:"
          },
          "url": {
            "label": "도메인 URL:"
          },
          "proxyOverride": {
            "label": "프록시 무효화:"
          },
          "version": {
            "label": "도메인 버전:"
          },
          "username": {
            "label": "사용자 이름:"
          },
          "sso": {
            "label": "웹 인증:"
          },
          "roles": {
            "label": "롤:"
          },
          "connectTimeout": {
            "label": "접속 시간 초과:"
          },
          "readTimeout": {
            "label": "읽기 시간 초과:"
          },
          "insecure": {
            "label": "비보안:"
          },
          "anyAttempt": {
            "label": "시도된 접속:"
          },
          "lastAttempt": {
            "label": "마지막 시도 성공:"
          }
        },
        "model": {
          "file": {
            "label": "파일:"
          },
          "props": {
            "label": "변수:"
          }
        },
        "composite": {
          "models": {
            "label": "모델:"
          }
        },
        "proplist": {
          "file": {
            "label": "파일 이름:"
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "관리 서버 접속 제공자 추가"
        }
      },
      "models": {
        "add": {
          "value": "WDT 모델 파일 제공자 추가"
        },
        "new": {
          "value": "새 WDT 모델 파일용 제공자 생성"
        }
      },
      "composite": {
        "add": {
          "value": "WDT 조합 모델 파일 제공자 추가"
        }
      },
      "proplist": {
        "add": {
          "value": "속성 목록 제공자 추가"
        },
        "new": {
          "value": "새 속성 목록에 대한 제공자 생성"
        }
      },
      "providers": {
        "sort": {
          "value": "제공자 유형별 정렬"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "도메인 URL:"
              },
              "version": {
                "label": "도메인 버전:"
              },
              "username": {
                "label": "사용자 이름:"
              }
            }
          },
          "model": {
            "file": {
              "label": "파일:"
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "제공자를 프로젝트로 익스포트..."
        },
        "import": {
          "value": "프로젝트 임포트"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "접속 제공자에 대한 새 이름과 접속 설정을 입력합니다."
        },
        "edit": {
          "value": "접속 제공자에 대한 접속 설정을 수정합니다."
        },
        "deactivate": {
          "value": "접속 제공자를 비활성화한 후 도메인 상태 폴링을 중단합니다."
        }
      },
      "models": {
        "add": {
          "value": "기존 모델 파일 제공자에 대한 설정을 입력합니다. 업로드 아이콘을 눌러 모델 파일을 찾아봅니다."
        },
        "new": {
          "value": "새 WDT 모델 파일에 대한 제공자 이름과 파일 이름을 입력하고, 아이콘을 눌러 파일을 저장할 디렉토리를 선택합니다."
        },
        "edit": {
          "value": "모델 파일 제공자에 대한 설정을 수정합니다. 아이콘을 눌러 모델 파일을 찾아봅니다."
        }
      },
      "composite": {
        "add": {
          "value": "새 이름을 입력하고 조합 모델 제공자에 대해 정렬된 모델 목록을 선택합니다."
        },
        "edit": {
          "value": "조합 모델 제공자에 대한 설정을 수정합니다. 정렬된 모델 목록을 사용합니다."
        }
      },
      "proplist": {
        "add": {
          "value": "기존 속성 목록 제공자에 대한 설정을 입력합니다. 업로드 아이콘을 눌러 속성 파일을 찾아봅니다."
        },
        "new": {
          "value": "새 속성 목록에 대한 제공자 이름과 파일 이름을 입력하고, 아이콘을 눌러 파일을 저장할 디렉토리를 선택합니다."
        },
        "edit": {
          "value": "속성 목록 제공자에 대한 설정을 수정합니다. 아이콘을 눌러 속성 파일을 찾아봅니다."
        }
      },
      "project": {
        "export": {
          "value": "새 프로젝트에 대한 설정을 입력합니다."
        },
        "import": {
          "value": "다운로드 아이콘을 눌러 프로젝트를 찾아봅니다."
        }
      },
      "task": {
        "startup": {
          "value": "어떤 시작 태스크를 수행하고 싶습니까?"
        }
      },
      "project-busy": {
        "value": "프로젝트의 일부를 변경하기 전에 저장되지 않은 변경사항을 저장하거나 중단하십시오."
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "관리 서버 접속용 제공자 생성"
        },
        "models": {
          "value": "기존 WDT 모델 파일용 제공자 생성"
        },
        "composite": {
          "value": "새 WDT 조합 모델에 대한 제공자 생성"
        },
        "proplist": {
          "value": "기존 속성 목록에 대한 제공자 생성"
        }
      },
      "new": {
        "models": {
          "value": "새 WDT 모델 파일용 제공자 생성"
        },
        "proplist": {
          "value": "새 속성 목록에 대한 제공자 생성"
        }
      },
      "edit": {
        "connections": {
          "value": "관리 서버 접속 제공자 편집"
        },
        "models": {
          "value": "WDT 모델 파일 제공자 편집"
        },
        "composite": {
          "value": "WDT 조합 모델 제공자 편집"
        },
        "proplist": {
          "value": "속성 목록 제공자 편집"
        }
      },
      "export": {
        "project": {
          "value": "제공자를 프로젝트로 익스포트"
        }
      },
      "import": {
        "project": {
          "value": "프로젝트 임포트"
        }
      },
      "startup": {
        "task": {
          "value": "시작 태스크"
        }
      },
      "project-busy": {
        "value": "프로젝트 사용 중"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "익스포트 실패",
          "detail": "제공자를 '{0}' 프로젝트로 익스포트할 수 없습니다."
        }
      },
      "import": {
        "failed": {
          "summary": "저장 실패",
          "detail": "'{0}' 프로젝트 파일을 임포트할 수 없습니다."
        }
      },
      "stage": {
        "failed": {
          "summary": "생성 실패",
          "detail": "'{0}' 제공자 항목을 생성할 수 없습니다."
        }
      },
      "use": {
        "failed": {
          "summary": "접속 실패",
          "detail": "'{0}' 제공자 항목을 사용할 수 없습니다."
        }
      },
      "upload": {
        "failed": {
          "detail": "WDT 모델 파일을 로드할 수 없음: {0}"
        },
        "props": {
          "failed": {
            "detail": "WDT 변수를 로드할 수 없음: {0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "'{0}' 이름의 제공자가 이 프로젝트에 이미 있습니다!"
        },
        "modelsNotFound": {
          "detail": "구성된 WDT 모델 '{0}'을(를) 찾을 수 없습니다."
        },
        "propListNotFound": {
          "detail": "WDT 변수 '{0}'을(를) 찾을 수 없습니다."
        },
        "selectModels": {
          "detail": "WDT 조합을 선택하려면 먼저 WDT 조합에 사용된 모든 WDT 모델을 선택하십시오."
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "URL은 HTTPS 프로토콜을 지정하거나 localhost를 사용해야 합니다."
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>파일 이름 필드에서 경로를 편집하고 [확인] 단추를 누릅니다. 또는 업로드 아이콘을 누르고 다른 파일을 선택하십시오.</p>"
        },
        "fixModelFile": {
          "detail": "<p>아래 언급된 문제를 수정하고 [확인] 단추를 누릅니다. 또는 다른 파일을 선택하십시오.</p>"
        },
        "yamlException": {
          "detail": "{1}행, {2}열의 {0}"
        },
        "wktModelContent": {
          "summary": "모델 콘텐츠 문제",
          "detail": "<i>코드 뷰</i> 탭의 모델 편집기를 사용하여 문제를 해결하십시오."
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "설정되지 않음"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "희소 템플리트 사용"
      },
      "usesso": {
        "label": "웹 인증 사용"
      },
      "insecure": {
        "label": "비보안 접속하기"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "트리 편집"
      },
      "view": {
        "tooltip": "구성 뷰 트리"
      },
      "monitoring": {
        "tooltip": "모니터링 트리"
      },
      "security": {
        "tooltip": "보안 데이터 트리"
      },
      "modeling": {
        "tooltip": "WDT 모델"
      },
      "composite": {
        "tooltip": "WDT 조합 모델"
      },
      "properties": {
        "tooltip": "속성 목록 편집기"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "제공자 트리 메뉴"
      },
      "navtree": {
        "value": "제공자 트리 네비게이터"
      },
      "panelResizer": {
        "value": "제공자 트리 네비게이터 크기 조정기입니다. 왼쪽 및 오른쪽 화살표 키를 사용하여 네비게이터 크기를 조정합니다."
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "홈. 제공자의 트리에 대한 카드를 포함하는 페이지로 돌아갑니다."
        }
      },
      "region": {
        "title": {
          "value": "콘텐츠 영역 머리글"
        }
      },
      "popup": {
        "provider": {
          "value": "제공자 작업"
        }
      }
    },
    "title": {
      "home": "홈",
      "configuration": "트리 편집",
      "view": "구성 뷰 트리",
      "monitoring": "모니터링 트리",
      "security": "보안 데이터 트리",
      "modeling": "WDT 모델",
      "composite": "WDT 조합 모델",
      "properties": "속성 목록"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "홈"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "눌러서 쇼핑 카트 작업 보기"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "변경사항 보기..."
        },
        "discard": {
          "label": "변경사항 무시"
        },
        "commit": {
          "label": "변경사항 커밋"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "쇼핑 카트"
        },
        "ataglance": {
          "label": "간략히 보기"
        },
        "projectmanagement": {
          "label": "제공자"
        },
        "tips": {
          "label": "사용자 팁"
        },
        "dashboards": {
          "label": "대시보드"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "팁 필터링",
        "checkboxes": {
          "hideall": "모든 팁 숨기기",
          "productivity": "생산성 팁 표시",
          "personalization": "개인설정 팁 표시",
          "whereis": "위치... 팁 표시",
          "accessibility": "접근성 팁 표시",
          "connectivity": "접속성 팁 표시",
          "security": "보안 팁 표시",
          "other": "기타 팁 표시"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "모두 숨기기"
        },
        "productivity": {
          "value": "생산성"
        },
        "personalization": {
          "value": "개인설정"
        },
        "whereis": {
          "value": "위치..."
        },
        "accessibility": {
          "value": "접근성"
        },
        "connectivity": {
          "value": "접속성"
        },
        "security": {
          "value": "보안"
        },
        "other": {
          "value": "기타"
        }
      },
      "cards": {
        "tip0": {
          "title": "도메인의 모든 MBean을 검색하세요!",
          "descriptionHTML": "<p>콘솔 상단의 검색 필드에 검색어를 입력하여 현재 관점에서 일치 항목을 찾습니다. <b>최근 검색</b> 노드에서 이전 질의를 재방문할 수도 있습니다.</p>"
        },
        "tip1": {
          "title": "중요한 데이터를 빠르게 필터링하고 찾으세요!",
          "descriptionHTML": "<p>대시보드에서 사용자정의 기준을 정의하고, 도메인과 일치시키고, 도메인에 기반한 포괄적이고 정밀한 보고서를 생성할 수 있습니다.</p><p>시작하려면 <b>모니터링 트리</b>에서 노드를 열고 <b>새 대시보드</b>를 누릅니다. 또는 <b>대시보드</b> 최상위 레벨 노드를 열어 내장 대시보드를 확인합니다.</p>"
        },
        "tip2": {
          "title": "테이블 콘텐츠 정제",
          "descriptionHTML": "<p>관련 없는 열을 숨겨 테이블을 간소화하면 중요한 데이터에 집중할 수 있습니다.</p><p>테이블 위의 <b>테이블 사용자정의</b>를 누르고 원하는 대로 열을 선택하거나 선택 해제합니다.</p>"
        },
        "tip3": {
          "title": "테이블 및 작업과 함께 키보드 사용",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "\"이 테이블 사용자정의\" 링크는 어디에 있나요?",
          "descriptionHTML": "<p>\"이 테이블 사용자정의\" 링크는 이제 <i>테이블 사용자정의</i> 단추입니다.</p>"
        },
        "tip5": {
          "title": "보류 중인 변경사항 검토",
          "descriptionHTML": "<p>쇼핑 카트를 열어 도메인에 저장되었지만 아직 커밋되지 않은 변경사항 목록을 확인합니다.</p><p>쇼핑 카트에 <b>변경사항 보기</b>가 표시되지 않으면 <a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>WebLogic Remote Console 확장을 설치</a>해 보십시오."
        },
        "tip6": {
          "title": "도움이 필요합니까?",
          "descriptionHTML": "<ul><li>도구설명을 보려면 필드 옆에 있는 <b>?</b> 위로 커서를 가져갑니다.</li><li>모든 보이는 속성에 대한 자세한 도움말을 보려면 페이지 레벨 <b>?</b>를 누릅니다.</li><li><b>도움말</b> 메뉴에서 <b>WebLogic Remote Console GitHub 프로젝트 방문</b>을 누릅니다.</li><li>Slack 채널에 참여합니다. <a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>.</li><li><a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>에서 설명서를 방문합니다.</li></ul>"
        },
        "tip7": {
          "title": "기타 팁 #1",
          "descriptionHTML": "<p>\"기타 팁 #1\"에 대한 간략한 설명입니다. 줄바꿈 문자는 HTML 요소가 아니므로 이 설명에 사용하지 마십시오.</p>"
        },
        "tip8": {
          "title": "서버 접속에 문제가 있나요?",
          "descriptionHTML": "<p><b>모니터링 트리</b> > <b>환경</b> > <b>서버</b>에서 응답하지 않는 서버를 선택하고 <b>문제 해결</b> 탭을 열어 문제를 진단해 봅니다.</p><p>도메인에 전혀 접속할 수 없는 경우 문제 해결 도움말을 보려면 WebLogic Remote Console 설명서에서 <a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>관리 서버에 접속할 수 없음</a>을 참조하십시오.</p>"
        },
        "tip9": {
          "title": "접속성 팁 #2",
          "descriptionHTML": "<p>\"접속성 팁 #2\"에 대한 간략한 설명입니다. 줄바꿈 문자는 HTML 요소가 아니므로 이 설명에 사용하지 마십시오.</p>"
        },
        "tip10": {
          "title": "보안 팁 #1",
          "descriptionHTML": "<p>\"보안 팁 #1\"에 대한 간략한 설명입니다. 줄바꿈 문자는 HTML 요소가 아니므로 이 설명에 사용하지 마십시오.</p>"
        },
        "tip11": {
          "title": "워크플로우를 가속화하세요!",
          "descriptionHTML": "<p>키보드 단축키를 사용하여 특정 UI 구성요소로 바로 점프합니다.</p><p>상위 5개:</p><li><code><b>Alt+P</b></code> - <b>제공자</b> 서랍을 엽니다.</li><li><code><b>Alt+C</b></code> - <b>쇼핑 카트</b>로 포커스를 이동합니다.</li><li><code><b>Alt+T</b></code> - 테이블의 첫번째 열 머리글로 포커스를 이동합니다.</li><li><code><b>Alt+|</b></code> - 탐색 트리 너비-크기 조정기로 포커스를 이동합니다. 화살표 키를 사용하여 트리 너비를 변경합니다.</li><li><code><b>Alt+;</b></code> - 첫번째 누르기 가능한 이동 경로 레이블로 포커스를 이동합니다.</li></ul><p>전체 키보드 단축키 목록은 설명서를 참조하십시오.</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "이동 경로"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "내역"
      },
      "separator": {
        "tooltip": "구분 기호"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "내역 항목 지우기",
          "label": "내역 항목 지우기"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "{0}에서 실행 중"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "접속 끊김",
        "detail": "접속이 끊겼습니다. 새로고침하십시오."
      },
      "cannotConnect": {
        "summary": "접속 시도 실패",
        "detail": "WebLogic 도메인 {0}에 접속할 수 없습니다. WebLogic이 실행 중인지 확인하십시오."
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "트리"
        },
        "startup-tasks": {
          "label": "시작 태스크"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "시작 페이지"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "시작 페이지 링크"
        }
      },
      "screenreader": {
        "value1": "{0} 항목 위에 있습니다. Enter를 눌러 선택합니다.",
        "value2": "{0} 항목 위에 있습니다. Enter를 누르면 확장되거나 축소됩니다. 확장한 후 아래쪽 화살표를 사용하여 관련 링크에 액세스합니다.",
        "value3": "{0}. Tab/Shift+Tab을 눌러 관련 링크 사이를 이동하고 Esc를 눌러 마지막 방문한 최상위 항목으로 돌아갑니다."
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "제공자 트리"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "트리 편집",
        "description": "<p>현재 사용 중인 WebLogic 도메인의 구성을 유지합니다.</p>"
      },
      "view": {
        "label": "구성 뷰 트리",
        "description": "<p>현재 사용 중인 WebLogic 도메인의 읽기 전용 구성을 검사합니다.</p>"
      },
      "monitoring": {
        "label": "모니터링 트리",
        "description": "<p>현재 사용 중인 WebLogic 도메인의 선택된 리소스에 대한 런타임 MBean 정보를 확인합니다.</p>"
      },
      "security": {
        "label": "보안 데이터 트리",
        "description": "<p>현재 사용 중인 WebLogic 도메인의 보안 관련 정보(예: 사용자, 그룹, 롤, 정책, 인증서 등)를 관리합니다.</p>"
      },
      "modeling": {
        "label": "WDT 모델 트리",
        "description": "<p>WebLogic Deploy Tooling 툴과 연관된 모델 파일을 유지 관리합니다.</p>"
      },
      "composite": {
        "label": "WDT 조합 모델 트리",
        "description": "<p>현재 사용 중인 일련의 결합된 WebLogic Deploy Tooling 모델 파일을 확인합니다.</p>"
      },
      "properties": {
        "label": "속성 목록 편집기",
        "description": "<p>속성 목록 파일에서 속성 집합을 보거나 수정합니다.</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "시작 태스크"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "관리 서버 접속 제공자 추가",
        "description": "이 태스크는 관리 서버에 접속할 수 있는 프로젝트 리소스를 생성합니다."
      },
      "addWdtModel": {
        "label": "WDT 모델 파일 제공자 추가",
        "description": "이 태스크는 로컬 파일 시스템에 존재하는 WDT 모델 파일을 관리할 수 있는 프로젝트 리소스를 생성합니다."
      },
      "addWdtComposite": {
        "label": "WDT 조합 모델 파일 제공자 추가",
        "description": "이 태스크는 로컬 파일 시스템에 존재하는 WDT 모델 파일 조각을 관리할 수 있는 프로젝트 리소스를 생성합니다."
      },
      "addPropertyList": {
        "label": "속성 목록 제공자 추가",
        "description": "이 태스크는 로컬 파일 시스템에 저장된 .properties 파일을 관리할 수 있는 프로젝트 리소스를 생성합니다."
      },
      "createWdtModel": {
        "label": "새 WDT 모델 파일용 제공자 생성",
        "description": "이 태스크는 로컬 파일 시스템에 저장된 새로운 WDT 모델 파일인 프로젝트 리소스를 생성합니다."
      },
      "createPropertyList": {
        "label": "새 속성 목록에 대한 제공자 생성",
        "description": "이 태스크는 로컬 파일 시스템에 저장된 새로운 .properties 파일인 프로젝트 리소스를 생성합니다."
      },
      "importProject": {
        "label": "프로젝트 임포트",
        "description": "이 태스크는 즉시 사용하거나 수정할 준비된 제공자를 포함하는 이전에 익스포트된 프로젝트를 로드합니다."
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "변경사항 무시"
      },
      "commit": {
        "tooltip": "변경사항 커밋"
      }
    },
    "sections": {
      "changeManager": {
        "label": "변경 관리자"
      },
      "additions": {
        "label": "추가"
      },
      "modifications": {
        "label": "수정"
      },
      "removals": {
        "label": "제거"
      },
      "restart": {
        "label": "재시작"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "새로 만들기"
      },
      "clone": {
        "label": "복제"
      },
      "delete": {
        "label": "삭제"
      },
      "customize": {
        "label": "테이블 사용자정의"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "시작 페이지"
      },
      "history": {
        "tooltip": "내역 표시 토글"
      },
      "instructions": {
        "tooltip": "지침 표시 토글"
      },
      "help": {
        "tooltip": "도움말 페이지 표시 토글"
      },
      "sync": {
        "tooltip": "다시 로드",
        "tooltipOn": "자동 다시 로드 정지"
      },
      "syncInterval": {
        "tooltip": "자동 다시 로드 간격 설정"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "'{0}' 작업을 수행할 항목을 선택하십시오."
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "메시지",
          "detail": "자동 다시 로드가 실행 중인 동안에는 '{0}' 작업을 수행할 수 없습니다! 먼저 '{1}' 아이콘을 눌러 정지하십시오."
        }
      }
    },
    "prompts": {
      "download": {
        "value": "다운로드한 로그 파일 위치:"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "숨겨진 열 표시"
      }
    },
    "labels": {
      "totalRows": {
        "value": "총 행: {0}"
      },
      "reloadHidden": {
        "value": "현재 {0} 값을 보려면 테이블을 다시 로드합니다."
      },
      "noData": {
        "value": "데이터를 찾을 수 없음."
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "사용 가능한 열"
        },
        "list": {
          "value": "사용 가능한 열 목록"
        },
        "listItem": {
          "value": "사용 가능한 열 목록 항목"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "선택한 열"
        },
        "list": {
          "value": "선택된 열 목록"
        },
        "listItem": {
          "value": "선택된 열 목록 항목"
        }
      },
      "button": {
        "addToRight": {
          "value": "사용 가능한 열 목록의 표시된 항목을 선택된 열 목록으로 이동"
        },
        "addAllRight": {
          "value": "사용 가능한 열 목록의 모든 항목을 선택된 열 목록으로 이동"
        },
        "removeRight": {
          "value": "선택된 열 목록의 표시된 항목을 사용 가능한 열 목록으로 이동"
        },
        "removeAll": {
          "value": "선택된 열 목록의 모든 항목을 사용 가능한 열 목록으로 이동"
        },
        "reset": {
          "value": "토글을 통해 테이블 사용자정의기가 열렸을 때 표시된 열로 선택된 열 목록의 열을 복원합니다."
        },
        "apply": {
          "value": "테이블에 열 사용자정의 적용"
        },
        "cancel": {
          "value": "모든 열 사용자정의 취소"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "저장"
      },
      "new": {
        "label": "생성"
      },
      "delete": {
        "label": "제거"
      },
      "back": {
        "label": "뒤로"
      },
      "next": {
        "label": "다음"
      },
      "finish": {
        "label": "생성"
      },
      "customize": {
        "label": "테이블 사용자정의"
      },
      "dashboard": {
        "label": "새 대시보드"
      }
    },
    "icons": {
      "save": {
        "tooltip": "저장"
      },
      "create": {
        "tooltip": "생성"
      },
      "landing": {
        "tooltip": "시작 페이지"
      },
      "history": {
        "tooltip": "내역 표시 토글"
      },
      "instructions": {
        "tooltip": "지침 표시 토글"
      },
      "help": {
        "tooltip": "도움말 페이지 표시 토글"
      },
      "sync": {
        "tooltip": "다시 로드",
        "tooltipOn": "자동 다시 로드 정지"
      },
      "syncInterval": {
        "tooltip": "자동 다시 로드 간격 설정"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "고급 필드 표시"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "요약과 자세한 도움말 간에 토글하려면 {0} 아이콘을 누릅니다."
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "변경사항이 카트에 추가되었습니다!",
        "generic": "변경사항이 저장되었습니다!",
        "notSaved": "변경사항이 감지되지 않아서 저장된 것이 없습니다."
      },
      "action": {
        "notAllowed": {
          "summary": "허용되지 않는 작업",
          "detail": "생성 작업 중에 요청된 동작을 수행할 수 없습니다. 생성 작업을 취소하려면 [취소] 단추를 누르십시오."
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "서버 또는 앱 재시작 필요"
      },
      "wdtIcon": {
        "tooltip": "WDT 설정"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "도움말 테이블",
        "columns": {
          "header": {
            "name": "이름",
            "description": "설명"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>관련 항목:</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "속성"
      },
      "actions": {
        "label": "작업"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "불완전한 필수 필드",
        "detail": "{0}은(는) 필수 필드이지만, 값이 제공되지 않았거나 부적합한 값이 제공되었습니다."
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "조건 추가"
        },
        "combine": {
          "label": "결합"
        },
        "uncombine": {
          "label": "결합 취소"
        },
        "moveup": {
          "label": "위로 이동"
        },
        "movedown": {
          "label": "아래로 이동"
        },
        "remove": {
          "label": "제거"
        },
        "negate": {
          "label": "부정"
        },
        "reset": {
          "label": "재설정"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "새 첫번째 조건 추가..."
          },
          "above": {
            "label": "누른 행 위에 조건 추가..."
          },
          "below": {
            "label": "누른 행 아래에 조건 추가..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "위의 선택한 조건 추가..."
          },
          "below": {
            "label": "아래의 선택한 조건 추가..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "하나 이상의 필수 필드에 데이터가 없습니다!"
      },
      "argumentValueHasWrongFormat": {
        "summary": "'{0}' 필드에 형식이 잘못 지정된 데이터가 포함되어 있습니다!"
      },
      "conditionHasNoArgValues": {
        "summary": "선택한 조건에 편집할 인수값이 없습니다!"
      },
      "conditionAlreadyExists": {
        "summary": "이 보안 정책에는 선택된 술어를 사용하여 작성된 조건 또는 일치하는 인수 값이 있는 조건이 이미 있습니다!"
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>새 조건의 위치를 지정하려면 상대 조건 옆에 선택 표시를 한 후 <b>+조건 추가</b> 단추를 누릅니다.</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "범위: -31 ~ 31"
      },
      "dateTime": {
        "value": "형식: yyyy-MM-dd [HH:mm:ss [AM|PM]](예: 2022-02-14 09:00:00 AM)"
      },
      "time": {
        "value": "형식: HH:mm:ss (예: 14:22:47)"
      },
      "gmtOffset": {
        "value": "형식: GMT+|-h:mm (예: GMT-5:00)"
      },
      "weekDay": {
        "value": "예: 일요일, 월요일, 화요일..."
      },
      "or": {
        "value": "or"
      },
      "not": {
        "value": "NOT"
      },
      "combination": {
        "value": "조합"
      },
      "nodata": {
        "Policy": {
          "value": "<b>+ 조건 추가</b> 단추를 사용하여 정책 조건을 추가합니다."
        },
        "DefaultPolicy": {
          "value": "정의된 기본 보안 정책 조건이 없습니다."
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "조합",
            "operator": "연산자",
            "expression": "조건 문구"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "Or",
            "and": "And"
          }
        }
      }
    },
    "wizard": {
      "title": "정책 관리",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "술어 선택",
            "instructions": "드롭다운 목록에서 새 조건의 술어를 선택합니다."
          },
          "body": {
            "labels": {
              "predicateList": "술어 목록"
            },
            "help": {
              "predicateList": "보안 정책 조건을 구성하는 데 사용할 수 있는 술어 목록."
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "그룹 술어",
            "instructions": "<i></i> 필드에 입력을 시작하여 인수값을 추가하거나 기존 항목을 검색합니다. 입력한 값을 목록에 추가하려면 Enter를 누릅니다. 기존 인수값을 편집하려면 누른 후 팝업 입력 필드를 사용하여 수정합니다."
          },
          "body": {
            "labels": {
              "conditionPhrase": "조건 문구",
              "negate": "부정 조건"
            },
            "help": {
              "negate": "반대 의미를 갖도록 조건을 변환합니다(예: \"같음\"은 \"같지 않음\"이 되고 \"속함\"은 \"속하지 않음\"이 됨)."
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "트리"
      },
      "page": {
        "value": "페이지"
      },
      "tab": {
        "value": "탭"
      },
      "ariaLabel": {
        "value": "페이지 내역"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "페이지가 더 이상 존재하지 않음",
        "detail1": "{0} 페이지로 재지정되었습니다. ",
        "detail2": "{0}이(가) 다른 사용자에 의해 삭제되었거나 더 이상 존재하지 않습니다. "
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "페이지 책갈피"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "현재 페이지에 책갈피 추가"
        },
        "show": {
          "label": "페이지 책갈피 표시..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "이 페이지에 이미 책갈피가 있습니다! "
      },
      "pagesBookmarkAdded": {
        "summary": "현재 페이지가 성공적으로 책갈피되었습니다! "
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "제공자 트리의 시작 페이지로 돌아갑니다."
        },
        "reset": {
          "value": "페이지 값 새로고침"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "작업"
      },
      "apply": {
        "label": "적용"
      },
      "reset": {
        "label": "재설정"
      },
      "ok": {
        "label": "확인"
      },
      "cancel": {
        "label": "취소"
      },
      "restart": {
        "label": "재시작"
      },
      "yes": {
        "label": "예"
      },
      "no": {
        "label": "아니오"
      },
      "choose": {
        "label": "선택"
      },
      "connect": {
        "label": "접속"
      },
      "add": {
        "label": "추가/보내기"
      },
      "edit": {
        "label": "편집/보내기"
      },
      "import": {
        "label": "임포트"
      },
      "export": {
        "label": "익스포트"
      },
      "write": {
        "label": "파일 다운로드"
      },
      "savenow": {
        "label": "지금 저장"
      },
      "next": {
        "label": "다음"
      },
      "previous": {
        "label": "이전"
      },
      "finish": {
        "label": "완료"
      },
      "done": {
        "label": "완료"
      },
      "close": {
        "label": "닫기"
      },
      "clear": {
        "label": "지우기"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "축소"
      },
      "expand": {
        "value": "확장"
      },
      "choose": {
        "value": "파일 선택"
      },
      "clear": {
        "value": "선택한 파일 지우기"
      },
      "more": {
        "value": "추가 작업"
      },
      "download": {
        "value": "찾아보기"
      },
      "reset": {
        "value": "재설정"
      },
      "filter": {
        "value": "필터"
      },
      "submit": {
        "value": "변경사항 제출"
      },
      "write": {
        "value": "파일 다운로드"
      },
      "pick": {
        "value": "디렉토리 선택"
      },
      "reload": {
        "value": "파일 다시 로드"
      },
      "delete": {
        "value": "삭제"
      },
      "remove": {
        "value": "제거"
      },
      "noData": {
        "value": "데이터 없음"
      },
      "preloader": {
        "value": "사전 로더"
      },
      "checkAll": {
        "value": "모두 선택"
      },
      "checkNone": {
        "value": "모두 선택 해제"
      },
      "checkSome": {
        "value": "선택항목 지우기"
      },
      "close": {
        "value": "닫기"
      },
      "recentPages": {
        "value": "내역 표시 토글"
      },
      "pagesHistory": {
        "back": {
          "value": "이전 페이지"
        },
        "next": {
          "value": "다음 페이지"
        },
        "launch": {
          "value": "페이지 내역 표시"
        },
        "star": {
          "value": "페이지 책갈피"
        }
      },
      "pageInfo": {
        "value": "눌러서 고정 및 고정 해제"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "파일 선택..."
      },
      "chooseDir": {
        "value": "디렉토리 선택..."
      }
    },
    "labels": {
      "info": {
        "value": "정보"
      },
      "warn": {
        "value": "경고"
      },
      "error": {
        "value": "오류"
      },
      "alerts": {
        "value": "경보"
      },
      "pagesHistory": {
        "value": "다음은 현재 제공자를 선택한 이후 방문한 페이지입니다. 연관된 페이지로 이동하려면 행의 열을 누르십시오."
      },
      "pagesBookmark": {
        "value": "다음은 {0} 제공자 유형에 책갈피된 페이지입니다. 연관된 페이지로 이동하려면 행의 열을 누르십시오."
      }
    },
    "placeholders": {
      "search": {
        "value": "검색"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "부정확한 콘텐츠가 감지됨"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "'{0}'에 JSON이 포함되어 있지만 {1}의 JSON 표현이 아닙니다!"
      },
      "dataCopiedToClipboard": {
        "detail": "데이터가 클립보드로 복사되었습니다!"
      },
      "tableCopiedToClipboard": {
        "summary": "테이블이 성공적으로 클립보드에 복사되었습니다!"
      },
      "emptyCellData": {
        "detail": "선택한 셀이 비어 있어서 데이터가 클립보드로 복사되지 않았습니다!"
      },
      "emptyRowData": {
        "detail": "선택한 행이 비어 있어서 데이터가 클립보드로 복사되지 않았습니다!"
      },
      "browserPermissionDenied": {
        "summary": "브라우저 권한이 거부됨",
        "detail": "이 작업을 수행하려면 JavaScript에서 클립보드로 쓰기를 사용으로 설정해야 합니다. 또한 클립보드 API는 HTTPS를 통해 제공된 페이지에만 지원됩니다."
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "클립보드로 셀 복사"
        },
        "row": {
          "label": "클립보드로 행 복사"
        },
        "tableAsText": {
          "label": "클립보드로 테이블 복사(텍스트)"
        },
        "tableAsJSON": {
          "label": "클립보드로 테이블 복사(JSON)"
        },
        "tableAsYAML": {
          "label": "클립보드로 테이블 복사(YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "모두 축소"
      },
      "useTreeMenusAsRootNodes": {
        "value": "트리 메뉴를 루트 노드로 사용"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "변경사항이 성공적으로 '{0}' 파일에 저장되었습니다!"
      },
      "changesNotSaved": {
        "summary": "'{0}' 파일에 변경사항을 저장할 수 없습니다!"
      },
      "changesDownloaded": {
        "summary": "변경사항이 성공적으로 '{0}' 파일에 다운로드되었습니다!"
      },
      "changesNotDownloaded": {
        "summary": "'{0}' 파일에 변경사항을 다운로드할 수 없습니다!"
      },
      "verifyPathEntered": {
        "detail": ". {0} 필드를 false로 설정하면 로컬 파일 또는 디렉토리인지 검증하지 않고 입력된 값을 수락합니다."
      }
    },
    "wdtOptionsDialog": {
      "title": "편집: {0}",
      "default": "값 설정 해제",
      "instructions": "선택 가능한 항목 목록에 추가할 토큰을 입력합니다.",
      "enterValue": "값 입력",
      "selectValue": "값 선택",
      "selectSwitch": "값 토글",
      "enterUnresolvedReference": "확인되지 않은 참조 입력",
      "enterModelToken": "모델 토큰 입력",
      "selectPropsVariable": "모델 토큰 변수 선택",
      "createPropsVariable": "모델 토큰 변수 생성",
      "propName": "변수 이름(필수)",
      "propValue": "변수 값",
      "enterVariable": "변수 입력",
      "variableName": "변수 이름(필수)",
      "variableValue": "변수 값",
      "multiSelectUnset": "사용 가능한 항목 목록에서 값 선택"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "저장되지 않은 변경사항이 감지됨"
      },
      "changesNeedDownloading": {
        "value": "변경사항이 다운로드되지 않음"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "저장되지 않은 변경사항이 모두 손실됩니다. 계속하겠습니까?"
        },
        "areYouSure": {
          "value": "변경사항을 저장하지 않고 {0}하겠습니까?"
        },
        "saveBeforeExiting": {
          "value": "종료하기 전에 변경사항을 저장하겠습니까?"
        },
        "needDownloading": {
          "value": "'{0}'에 대한 변경사항이 파일에 다운로드되지 않았습니다.<br/><br/>계속하기 전에 다운로드하겠습니까?"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "새 '{0}' 인스턴스가 WDT 모델에 추가되지 않았습니다.<br/><br/>계속하기 전에 추가하겠습니까?"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "자동 다시 로드 간격 설정",
      "instructions": "자동 다시 로드 간격에 대한 시간(초)을 지정하십시오.",
      "fields": {
        "interval": {
          "label": "자동 다시 로드 간격:"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "메시지",
          "detail": "'{1}' 작업을 수행하려고 시도할 때 콘솔 백엔드 호출이 '{0}' 응답을 생성했습니다."
        },
        "actionNotPerformed": {
          "detail": "선택된 항목 중 하나 이상에 대해 '{0}' 작업을 수행할 수 없습니다"
        },
        "actionNotPerformedNoRow": {
          "detail": "'{0}' 작업을 수행할 수 없습니다."
        },
        "actionSucceeded": {
          "summary": "'{0}' 작업이 성공적으로 수행되었습니다!"
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "정확한 원인을 확인할 수 없습니다. 힌트를 얻으려면 JavaScript 콘솔을 확인하십시오."
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "작업 확인",
        "prompt": "'{0}' 작업은 실행취소할 수 없습니다!<br/><br/>계속하겠습니까?"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "사용 가능",
        "chosen": "선택됨"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "속성 이름",
        "value": "속성 값"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "속성 이름",
        "valueHeader": "속성값",
        "addButtonTooltip": "추가",
        "deleteButtonTooltip": "삭제"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "{0} 보기..."
          },
          "create": {
            "label": "새 {0} 생성..."
          },
          "edit": {
            "label": "{0} 편집..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "기본값으로 복원"
    },
    "placeholder": {
      "value": "기본값"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "'{0}'을(를) 사용할 수 없습니다."
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "RUNNING"
      },
      "shutdown": {
        "value": "SHUTDOWN"
      },
      "serverStates": {
        "value": "서버 상태"
      },
      "systemStatus": {
        "value": "시스템 상태"
      },
      "healthState": {
        "failed": {
          "value": "실패"
        },
        "critical": {
          "value": "심각"
        },
        "overloaded": {
          "value": "오버로드됨"
        },
        "warning": {
          "value": "경고"
        },
        "ok": {
          "value": "확인"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "실행 중인 서버 건전성"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "이름"
        },
        "state": {
          "value": "상태"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "현재 백엔드에 연결할 수 없습니다."
      },
      "connectionMessage": {
        "summary": "접속 메시지"
      },
      "connectFailed": {
        "detail": "시도 실패: "
      },
      "badRequest": {
        "detail": "제출된 파일 또는 요청을 처리할 수 없습니다."
      },
      "invalidCredentials": {
        "detail": "WebLogic 도메인 인증서가 부적합합니다."
      },
      "invalidUrl": {
        "detail": "WebLogic 도메인 URL에 연결할 수 없습니다."
      },
      "notInRole": {
        "detail": "시도 실패: 사용자가 관리자, 배치자, 운영자 또는 감독자가 아닙니다."
      },
      "notSupported": {
        "detail": "WebLogic 도메인은 지원되지 않습니다."
      },
      "unexpectedStatus": {
        "detail": "예상치 않은 결과(상태: {0})"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "요청 실패",
          "detail": "콘솔 백엔드 호출에서 실패한 응답이 반환되었습니다."
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "구체적인 원인은 원격 콘솔 터미널 또는 JavaScript 콘솔을 참조하십시오."
      },
      "responseMessages": {
        "summary": "응답 메시지"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "확인"
      },
      "prompt": {
        "value": "<b>{0}</b>을(를) 종료하면 현재 제공자가 재설정됩니다. 계속하겠습니까?"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "변경 관리자에 액세스할 수 없습니다!"
      },
      "changesCommitted": {
        "summary": "변경사항이 성공적으로 커밋되었습니다!"
      },
      "changesNotCommitted": {
        "summary": "변경사항을 커밋할 수 없습니다!"
      },
      "changesDiscarded": {
        "summary": "변경사항이 성공적으로 무시되었습니다!"
      },
      "changesNotDiscarded": {
        "summary": "변경사항을 무시할 수 없습니다!"
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "예상치 않은 오류 응답"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "접속 문제",
        "details": "제공자로부터 데이터를 전송 및 수신하는 데 문제가 있습니다! 계속하기 전에 액세스 가능한지 확인하십시오."
      },
      "pathNotFound": {
        "summary": "경로를 찾을 수 없음",
        "details": "'{0}'은(는) 로컬 파일 시스템에서 액세스 가능한 파일 또는 디렉토리가 아닙니다."
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "메시지 행"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "메시지 지우기"
        },
        "suppress": {
          "info": {
            "label": "정보 메시지 표시 안함"
          },
          "warning": {
            "label": "경고 메시지 표시 안함"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " WebLogic 도메인의 관리 서버에 접속할 수 없습니다."
      },
      "shutdownSequenceError": {
        "details": "관리되는 서버를 종료한 다음 관리 서버를 종료합니다."
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "{0}개의 높은 우선순위 오류 경보가 있습니다."
        },
        "warning": {
          "value": "{0}개의 높은 우선순위 경고 경보가 있습니다."
        },
        "info": {
          "value": "{0}개의 높은 우선순위 정보 경보가 있습니다."
        },
        "view": {
          "value": "경보 보기"
        }
      }
    }
  }
});