define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "Intestazione applicazione"
      }
    },
    "buttons": {
      "logout": {
        "label": "Logout"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "Attiva/disattiva la visibilità della struttura di navigazione"
        }
      },
      "theme": {
        "tooltip": "Cambia tema"
      },
      "whatsNew": {
        "tooltip": "Novità"
      },
      "howDoI": {
        "tooltip": "Apre i task \"Come...\""
      },
      "tips": {
        "tooltip": "Attiva/disattiva la visibilità degli suggerimenti per gli utenti"
      },
      "help": {
        "tooltip": "Apre la documentazione interna di WebLogic Remote Console"
      },
      "profile": {
        "tooltip": "Profilo"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "Apre Message Center"
      },
      "theme": {
        "light": {
          "value": "Chiaro"
        },
        "dark": {
          "value": "Scuro"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "Fare clic per reimpostare WebLogic Remote Console"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "Copyright © 2020-2025, Oracle e/o relative consociate. <br/>Oracle®, Java e MySQL e NetSuite sono marchi registrati di Oracle e/o delle relative consociate. Altri nomi possono essere marchi dei rispettivi proprietari.<br/>",
      "builtWith": "Creato con Oracle JET"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "Non sicura"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "Connessione al server di amministrazione non sicura"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "Mostra la lista di profili"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "Gestisce i profili"
          },
          "editor": {
            "tooltip": "Editor profilo",
            "toolbar": {
              "save": {
                "tooltip": "Salva profilo"
              },
              "activate": {
                "tooltip": "Profilo attivo"
              },
              "add": {
                "tooltip": "Aggiunge il profilo"
              },
              "remove": {
                "tooltip": "Elimina il profilo"
              }
            }
          }
        },
        "image": {
          "tooltip": "Profilo",
          "capture": {
            "tooltip": "Aggiunge o modifica l'immagine"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "Generale"
        },
        "settings": {
          "value": "Impostazioni"
        },
        "preferences": {
          "value": "Preferenze"
        },
        "properties": {
          "value": "Proprietà"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "Modifica immagine"
      },
      "clearImage": {
        "value": "Cancella immagine"
      },
      "profile": {
        "default": {
          "value": "Profilo predefinito"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "Mostra editor profilo"
            },
            "hide": {
              "value": "Nascondi editor profilo"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "Apri Profile Manager"
          },
          "signout": {
            "value": "Disconnetti"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "ID profilo"
          },
          "organization": {
            "value": "Organizzazione"
          },
          "name": {
            "value": "Nome"
          },
          "email": {
            "value": "Posta elettronica"
          },
          "role": {
            "default": {
              "value": "Usa come profilo predefinito"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "Memorizzare le credenziali cifrate per i progetti?"
            },
            "disableHNV": {
              "value": "Disabilitare la verifica del nome host?"
            },
            "proxyAddress": {
              "value": "Indirizzo proxy"
            },
            "trustStoreType": {
              "value": "Tipo truststore"
            },
            "trustStorePath": {
              "value": "Percorso truststore"
            },
            "trustStoreKey": {
              "value": "Chiave truststore"
            },
            "connectionTimeout": {
              "value": "Timeout di connessione del server di amministrazione"
            },
            "readTimeout": {
              "value": "Timeout di lettura del server di amministrazione"
            }
          },
          "preferences": {
            "theme": {
              "value": "Tema"
            },
            "startupTaskChooserType": {
              "value": "Tipo di selettore task di avvio"
            },
            "useTreeMenusAsRootNodes": {
              "value": "Usare i menu Struttura come livello radice dei Navigator struttura?"
            },
            "onQuit": {
              "value": "Consentire le modifiche non salvate per impedire la chiusura dell'applicazione?"
            },
            "onDelete": {
              "value": "Confermare tutte le eliminazioni?"
            },
            "onActionNotAllowed": {
              "value": "Usare il popup \"Azione non consentita\" per evitare la perdita di dati?"
            },
            "onUnsavedChangesDetected": {
              "value": "Usare il popup \"Rilevate modifiche non salvate\" per evitare la perdita di dati?"
            },
            "onChangesNotDownloaded": {
              "value": "Usare il popup \"Modifiche non scaricate\" per evitare la perdita di dati?"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Proprietà di sistema Java"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "Chiaro"
            },
            "dark": {
              "value": "Scuro"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "Usa finestra di dialogo"
            },
            "useCards": {
              "value": "Usa schede"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "Windows ROOT"
            },
            "keyChainStore": {
              "value": "Area di memorizzazione portachiavi"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "Salvataggio del profilo \"{0}\" riuscito."
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "Azioni del provider "
        }
      },
      "info": {
        "tooltip": "Recupera informazioni su questo provider"
      },
      "edit": {
        "tooltip": "Gestisce le impostazioni per questo provider"
      },
      "deactivate": {
        "tooltip": "Disattiva questo provider"
      },
      "delete": {
        "tooltip": "Rimuove questo provider"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "Progetto senza nome"
        },
        "name": {
          "value": "Nome provider di connessione"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "Sostituzione proxy"
        },
        "username": {
          "value": "Nome utente"
        },
        "password": {
          "value": "Password"
        }
      },
      "models": {
        "name": {
          "value": "Nome provider modello WDT"
        },
        "file": {
          "value": "Nome file modello WDT"
        },
        "props": {
          "value": "Variabili WDT"
        }
      },
      "composite": {
        "name": {
          "value": "Nome provider modello composto WDT"
        },
        "providers": {
          "value": "Modelli WDT"
        }
      },
      "proplist": {
        "name": {
          "value": "Nome provider lista proprietà"
        },
        "file": {
          "value": "Nome file lista proprietà"
        }
      },
      "project": {
        "name": {
          "value": "Nome progetto"
        },
        "file": {
          "value": "Nome file progetto"
        }
      },
      "provider": {
        "adminserver": {
          "value": "Connessione al server di amministrazione"
        },
        "model": {
          "value": "Aggiungi modello WDT"
        }
      },
      "dropdown": {
        "none": {
          "value": "Nessuna"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "Nome progetto:"
          }
        },
        "provider": {
          "id": {
            "label": "ID provider:"
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "Versione estensione console:"
          },
          "name": {
            "label": "Nome dominio:"
          },
          "url": {
            "label": "URL dominio:"
          },
          "proxyOverride": {
            "label": "Sostituzione proxy:"
          },
          "version": {
            "label": "Versione dominio:"
          },
          "username": {
            "label": "Nome utente:"
          },
          "sso": {
            "label": "Autenticazione Web:"
          },
          "roles": {
            "label": "Ruoli:"
          },
          "connectTimeout": {
            "label": "Timeout di connessione:"
          },
          "readTimeout": {
            "label": "Timeout di lettura:"
          },
          "insecure": {
            "label": "Non sicuro:"
          },
          "anyAttempt": {
            "label": "Tutti i tentativi di connessione:"
          },
          "lastAttempt": {
            "label": "Ultimo tentativo riuscito:"
          }
        },
        "model": {
          "file": {
            "label": "File:"
          },
          "props": {
            "label": "Variabili:"
          }
        },
        "composite": {
          "models": {
            "label": "Modelli:"
          }
        },
        "proplist": {
          "file": {
            "label": "Nome file:"
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "Aggiungi provider di connessione al server di amministrazione"
        }
      },
      "models": {
        "add": {
          "value": "Aggiungi provider di file modello WDT"
        },
        "new": {
          "value": "Crea provider per nuovo file modello WDT"
        }
      },
      "composite": {
        "add": {
          "value": "Aggiungi provider di file modello composto WDT"
        }
      },
      "proplist": {
        "add": {
          "value": "Aggiungi provider di lista proprietà"
        },
        "new": {
          "value": "Crea provider per nuova lista proprietà"
        }
      },
      "providers": {
        "sort": {
          "value": "Ordina per tipo di provider"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "URL dominio:"
              },
              "version": {
                "label": "Versione dominio:"
              },
              "username": {
                "label": "Nome utente:"
              }
            }
          },
          "model": {
            "file": {
              "label": "File:"
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "Esporta provider come progetto..."
        },
        "import": {
          "value": "Importa progetto"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "Immettere il nuovo nome e le impostazioni di connettività per il provider di connessione."
        },
        "edit": {
          "value": "Modificare le impostazioni di connettività per il provider di connessione."
        },
        "deactivate": {
          "value": "Disattivare il provider di connessione e terminare il polling dello stato del dominio."
        }
      },
      "models": {
        "add": {
          "value": "Immettere le impostazioni per il provider di file modello esistente. Fare clic sull'icona di caricamento per cercare il file modello."
        },
        "new": {
          "value": "Immettere il nome del provider e il nome file per il nuovo file modello WDT, quindi fare clic sull'icona per selezionare la directory in cui salvare il file."
        },
        "edit": {
          "value": "Modificare le impostazioni per il provider di file modello. Fare clic sull'icona per cercare il file modello."
        }
      },
      "composite": {
        "add": {
          "value": "Immettere il nuovo nome e selezionare una lista ordinata di modelli per il provider di modello composito."
        },
        "edit": {
          "value": "Modificare le impostazioni per il provider di modello composito. Utilizzare una lista ordinata di modelli."
        }
      },
      "proplist": {
        "add": {
          "value": "Immettere le impostazioni per il provider di lista proprietà esistente. Fare clic sull'icona di caricamento per cercare un file di proprietà."
        },
        "new": {
          "value": "Immettere il nome del provider e il nome file per una nuova lista di proprietà, quindi fare clic sull'icona per selezionare la directory in cui salvare il file."
        },
        "edit": {
          "value": "Modificare le impostazioni per il provider di lista proprietà. Fare clic sull'icona per cercare un file di proprietà."
        }
      },
      "project": {
        "export": {
          "value": "Immettere le impostazioni per il nuovo progetto."
        },
        "import": {
          "value": "Fare clic sull'icona di download per cercare il progetto."
        }
      },
      "task": {
        "startup": {
          "value": "Quale task di avvio si desidera eseguire?"
        }
      },
      "project-busy": {
        "value": "Salvare o annullare le modifiche non salvate prima di apportare modifiche a qualsiasi parte del progetto"
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "Crea provider per la connessione al server di amministrazione"
        },
        "models": {
          "value": "Crea provider per file modello WDT esistente"
        },
        "composite": {
          "value": "Crea provider per nuovo modello composto WDT"
        },
        "proplist": {
          "value": "Crea provider per lista proprietà esistente"
        }
      },
      "new": {
        "models": {
          "value": "Crea provider per nuovo file modello WDT"
        },
        "proplist": {
          "value": "Crea provider per nuova lista proprietà"
        }
      },
      "edit": {
        "connections": {
          "value": "Modifica provider di connessione al server di amministrazione"
        },
        "models": {
          "value": "Modifica provider di file modello WDT"
        },
        "composite": {
          "value": "Modifica provider di modello composto WDT"
        },
        "proplist": {
          "value": "Modifica provider di lista proprietà"
        }
      },
      "export": {
        "project": {
          "value": "Esporta provider come progetto"
        }
      },
      "import": {
        "project": {
          "value": "Importa progetto"
        }
      },
      "startup": {
        "task": {
          "value": "Task di avvio"
        }
      },
      "project-busy": {
        "value": "Progetto occupato"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "Esportazione non riuscita",
          "detail": "Impossibile esportare i provider come progetto '{0}'."
        }
      },
      "import": {
        "failed": {
          "summary": "Salvataggio non riuscito",
          "detail": "Impossibile importare il file di progetto '{0}'."
        }
      },
      "stage": {
        "failed": {
          "summary": "Creazione non riuscita",
          "detail": "Impossibile creare l'elemento provider '{0}'."
        }
      },
      "use": {
        "failed": {
          "summary": "Connessione non riuscita",
          "detail": "Impossibile usare l'elemento provider '{0}'."
        }
      },
      "upload": {
        "failed": {
          "detail": "Impossibile caricare il file modello WDT: {0}"
        },
        "props": {
          "failed": {
            "detail": "Impossibile caricare le variabili WDT: {0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "Il provider denominato '{0}' è già in questo progetto."
        },
        "modelsNotFound": {
          "detail": "Impossibile trovare i modelli WDT configurati '{0}'"
        },
        "propListNotFound": {
          "detail": "Impossibile trovare le variabili WDT: {0}"
        },
        "selectModels": {
          "detail": "Per selezionare il modello composto WDT, selezionare prima tutti i modelli WDT utilizzati dal modello composto WDT."
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "L'URL deve specificare il protocollo HTTPS o utilizzare localhost"
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>Modificare il percorso nel campo nomefile e fare clic sul pulsante OK. In alternativa, fare clic sull'icona di caricamento e scegliere un altro file.</p>"
        },
        "fixModelFile": {
          "detail": "<p>Risolvere i problemi indicati di seguito e fare clic su OK. In alternativa, scegliere un altro file.</p>"
        },
        "yamlException": {
          "detail": "{0} nella riga {1}, colonna {2}"
        },
        "wktModelContent": {
          "summary": "Problemi relativi al contenuto del modello",
          "detail": "Utilizzare l'editor di modelli nella scheda <i>Vista codice</i> per risolvere i problemi."
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "Non impostato"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "Usa modello di sparsità"
      },
      "usesso": {
        "label": "Usa autenticazione Web"
      },
      "insecure": {
        "label": "Crea connessione non sicura"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "Modifica struttura"
      },
      "view": {
        "tooltip": "Struttura vista configurazione"
      },
      "monitoring": {
        "tooltip": "Struttura di monitoraggio"
      },
      "security": {
        "tooltip": "Struttura dati di sicurezza"
      },
      "modeling": {
        "tooltip": "Modello WDT"
      },
      "composite": {
        "tooltip": "Modello composto WDT"
      },
      "properties": {
        "tooltip": "Editor di liste proprietà"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "Menu con strutture ad albero del provider"
      },
      "navtree": {
        "value": "Navigator struttura ad albero del provider"
      },
      "panelResizer": {
        "value": "Ridimensionatore Navigator struttura ad albero del provider. Usare i tasti freccia sinistra e destra per ridimensionare il Navigator"
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "Home. Tornare alla pagina contenente le schede per le strutture ad albero del provider"
        }
      },
      "region": {
        "title": {
          "value": "Intestazione area del contenuto"
        }
      },
      "popup": {
        "provider": {
          "value": "Azioni del provider"
        }
      }
    },
    "title": {
      "home": "Home",
      "configuration": "Modifica struttura",
      "view": "Struttura vista configurazione",
      "monitoring": "Struttura di monitoraggio",
      "security": "Struttura dati di sicurezza",
      "modeling": "Modello WDT",
      "composite": "Modello composto WDT",
      "properties": "Lista proprietà"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "Home"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "Fare clic per visualizzare le azioni del carrello"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "Visualizza modifiche..."
        },
        "discard": {
          "label": "Annulla modifiche"
        },
        "commit": {
          "label": "Commit delle modifiche"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "Carrello"
        },
        "ataglance": {
          "label": "Panoramica"
        },
        "projectmanagement": {
          "label": "Provider"
        },
        "tips": {
          "label": "Suggerimenti per gli utenti"
        },
        "dashboards": {
          "label": "Dashboard"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "Filtra suggerimenti",
        "checkboxes": {
          "hideall": "Nascondi tutti i suggerimenti",
          "productivity": "Mostra suggerimenti sulla produttività",
          "personalization": "Mostra suggerimenti sulla personalizzazione",
          "whereis": "Mostra suggerimenti su Dove si trova...",
          "accessibility": "Mostra suggerimenti sull'accesso facilitato",
          "connectivity": "Mostra suggerimenti sulla connettività",
          "security": "Mostra suggerimenti sulla sicurezza",
          "other": "Mostra altri suggerimenti"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "Nascondi tutto"
        },
        "productivity": {
          "value": "Produttività"
        },
        "personalization": {
          "value": "Personalizzazione"
        },
        "whereis": {
          "value": "Dove si trova..."
        },
        "accessibility": {
          "value": "Accesso facilitato"
        },
        "connectivity": {
          "value": "Connettività"
        },
        "security": {
          "value": "Sicurezza"
        },
        "other": {
          "value": "Altro"
        }
      },
      "cards": {
        "tip0": {
          "title": "Eseguire una ricerca in tutti gli MBean del dominio",
          "descriptionHTML": "<p>Immettere un termine di ricerca nell'apposito campo nella parte superiore della console per esaminare in dettaglio le corrispondenze trovate. È possibile inoltre esaminare di nuovo le query precedenti nel nodo <b>Ricerche recenti</b>.</p>"
        },
        "tip1": {
          "title": "Filtrare e trovare rapidamente i dati importanti",
          "descriptionHTML": "<p>I dashboard consentono di definire criteri personalizzati, associarli al dominio in uso e generare report completi e accurati in base al dominio.</p><p>Per iniziare, aprire un nodo qualsiasi nella <b>Struttura di monitoraggio</b> e fare clic su <b>Nuovo dashboard</b>. In alternativa, aprire il nodo di livello superiore <b>Dashboard</b> per visualizzare i dashboard built-in.</p>"
        },
        "tip2": {
          "title": "Ridefinire i contenuti delle tabelle",
          "descriptionHTML": "<p>È possibile semplificare le tabelle nascondendo le colonne irrilevanti in modo da poter focalizzare l'attenzione sui dati ai quali si è interessati.</p><p>Sopra una tabella qualsiasi, fare clic su <b>Personalizza tabella</b> e selezionare o deselezionare le colonne in base alle esigenze.</p>"
        },
        "tip3": {
          "title": "Uso della tastiera con le tabelle e le azioni",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "Dove si trova il collegamento \"Personalizza questa tabella\"?",
          "descriptionHTML": "<p>Il collegamento \"Personalizza questa tabella\" è ora il pulsante <i>Personalizza tabella</i>.</p>"
        },
        "tip5": {
          "title": "Esaminare le modifiche in sospeso",
          "descriptionHTML": "<p>Aprire il carrello per visualizzare una lista delle modifiche salvate nel dominio, ma non ancora sottoposte a commit.</p><p>Se l'opzione <b>Visualizza modifiche</b> non è visibile nel carrello, provare a <a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>installare l'estensione di WebLogic Remote Console</a>."
        },
        "tip6": {
          "title": "Assistenza",
          "descriptionHTML": "<ul><li>Passare il puntatore del mouse su <b>?</b> accanto a un campo per visualizzare le descrizioni comandi.</li><li>Fare clic su <b>?</b> a livello di pagina per visualizzare la Guida dettagliata su tutti gli attributi visibili.</li><li>Nel menu <b>Guida</b> fare clic su <b>Visita progetto GitHub di WebLogic Remote Console</b>.</li><li>Per entrare a far parte del canale Slack di Oracle, visitare la pagina: <a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>.</li><li>Consultare la documentazione alla pagina <a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>.</li></ul>"
        },
        "tip7": {
          "title": "Altro suggerimento n. 1",
          "descriptionHTML": "<p>Una descrizione concisa per \"Altro suggerimento n. 1\". Un carattere di nuova riga non è un elemento HTML, pertanto non è consigliabile utilizzarlo in questa descrizione.</p>"
        },
        "tip8": {
          "title": "In caso di problemi di connessione a un server",
          "descriptionHTML": "<p>In <b>Struttura di monitoraggio</b> > <b>Ambiente</b> > <b>Server</b>, selezionare un server che non risponde e aprire la scheda <b>Risoluzione dei problemi</b> per provare a diagnosticare il problema.</p><p>Se non è possibile connettersi al dominio, vedere <a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>Impossibile connettersi al server di amministrazione</a> nella documentazione di WebLogic Remote Console per informazioni sulla risoluzione dei problemi.</p>"
        },
        "tip9": {
          "title": "Suggerimento sulla connettività n. 2",
          "descriptionHTML": "<p>Una descrizione concisa per \"Suggerimento sulla connettività n. 2\". Un carattere di nuova riga non è un elemento HTML, pertanto non è consigliabile utilizzarlo in questa descrizione.</p>"
        },
        "tip10": {
          "title": "Suggerimento sulla sicurezza n. 1",
          "descriptionHTML": "<p>Una descrizione concisa per \"Suggerimento sulla sicurezza n. 1\". Un carattere di nuova riga non è un elemento HTML, pertanto non è consigliabile utilizzarlo in questa descrizione.</p>"
        },
        "tip11": {
          "title": "Accelerare il workflow",
          "descriptionHTML": "<p>Utilizzare i collegamenti da tastiera per spostarsi direttamente sui componenti specifici dell'interfaccia utente.</p><p>Primi 5:</p><li><code><b>Alt+P</b></code>: apre il cassetto di navigazione <b>Provider</b>.</li><li><code><b>Alt+C</b></code>: sposta l'elemento attivo sul <b>Carrello</b>.</li><li><code><b>Alt+T</b></code>: sposta l'elemento attivo sulla prima intestazione di colonna di una tabella.</li><li><code><b>Alt+|</b></code>: sposta l'elemento attivo sull'elemento di ridimensionamento della larghezza dell'albero di navigazione. Utilizzare i tasti freccia per modificare la larghezza della struttura.</li><li><code><b>Alt+;</b></code>: sposta l'elemento attivo sulla prima etichetta dell'indicatore di percorso selezionabile tramite clic.</li></ul><p>Per visualizzare una lista completa dei collegamenti da tastiera, consultare la documentazione.</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "Indicatori di percorso"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "Cronologia"
      },
      "separator": {
        "tooltip": "Separatore"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "Cancella voci cronologia",
          "label": "Cancella voci cronologia"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "in esecuzione alle ore {0}"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "Connessione interrotta",
        "detail": "Connessione persa. Eseguire l'aggiornamento."
      },
      "cannotConnect": {
        "summary": "Tentativo di connessione non riuscito",
        "detail": "Impossibile connettersi al dominio WebLogic {0}, verificare che WebLogic sia in esecuzione."
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "Strutture"
        },
        "startup-tasks": {
          "label": "Task di avvio"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Pagina di arrivo"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "Collegamenti alla pagina di arrivo"
        }
      },
      "screenreader": {
        "value1": "L'elemento {0} è attivo. Premere Invio per selezionare.",
        "value2": "L'elemento {0} è attivo. Premere Invio per espanderlo o comprimerlo. Una volta eseguita l'espansione, utilizzare la freccia rivolta verso il basso per accedere ai collegamenti correlati.",
        "value3": "{0}. Premere Tab/Maiusc+Tab per spostarsi tra i collegamenti correlati e il tasto Esc per tornare all'ultimo elemento di livello superiore visitato."
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Strutture ad albero del provider"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "Modifica struttura",
        "description": "<p>Consente di gestire la configurazione del dominio WebLogic attualmente in uso.</p>"
      },
      "view": {
        "label": "Struttura vista configurazione",
        "description": "<p>Consente di esaminare la configurazione di sola lettura del dominio WebLogic attualmente in uso.</p>"
      },
      "monitoring": {
        "label": "Struttura di monitoraggio",
        "description": "<p>Consente di visualizzare le informazioni MBean di runtime relative a risorse specifiche nel dominio WebLogic attualmente in uso.</p>"
      },
      "security": {
        "label": "Struttura dati di sicurezza",
        "description": "<p>Consente di gestire le informazioni relative alla sicurezza (ad esempio, utenti, gruppi, ruoli, criteri, credenziali e così via) nel dominio WebLogic attualmente in uso.</p>"
      },
      "modeling": {
        "label": "Struttura modello WDT",
        "description": "<p>Gestisce i file modello associati allo strumento WebLogic Deploy Tooling.</p>"
      },
      "composite": {
        "label": "Struttura modello composto WDT",
        "description": "<p>Visualizza un set combinato di file modello WebLogic Deploy Tooling attualmente in uso.</p>"
      },
      "properties": {
        "label": "Editor di liste proprietà",
        "description": "<p>Consente di visualizzare o modificare un set di proprietà da un file di lista delle proprietà.</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Task di avvio"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "Aggiungi provider di connessione al server di amministrazione",
        "description": "Questo task crea una risorsa di progetto che consente di connettersi a un server di amministrazione"
      },
      "addWdtModel": {
        "label": "Aggiungi provider di file modello WDT",
        "description": "Questo task crea una risorsa di progetto che consente di gestire un file modello WDT esistente nel file system locale"
      },
      "addWdtComposite": {
        "label": "Aggiungi provider di file modello composto WDT",
        "description": "Questo task crea una risorsa di progetto che consente di gestire i frammenti di un file modello WDT esistente nel file system locale"
      },
      "addPropertyList": {
        "label": "Aggiungi provider di lista proprietà",
        "description": "Questo task crea una risorsa di progetto che consente di gestire un file .properties memorizzato nel file system locale"
      },
      "createWdtModel": {
        "label": "Crea provider per nuovo file modello WDT",
        "description": "Questo task crea una risorsa di progetto che è un nuovo file modello WDT memorizzato nel file system locale"
      },
      "createPropertyList": {
        "label": "Crea provider per nuova lista proprietà",
        "description": "Questo task crea una risorsa di progetto che è un nuovo file .properties memorizzato nel file system locale"
      },
      "importProject": {
        "label": "Importa progetto",
        "description": "Questo task carica un progetto precedentemente esportato contenente i provider che possono essere immediatamente utilizzati o modificati"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "Annulla modifiche"
      },
      "commit": {
        "tooltip": "Commit delle modifiche"
      }
    },
    "sections": {
      "changeManager": {
        "label": "Change Manager"
      },
      "additions": {
        "label": "Aggiunte"
      },
      "modifications": {
        "label": "Modifiche"
      },
      "removals": {
        "label": "Rimozioni"
      },
      "restart": {
        "label": "Riavvia"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "Nuovo"
      },
      "clone": {
        "label": "Duplica"
      },
      "delete": {
        "label": "Elimina"
      },
      "customize": {
        "label": "Personalizza tabella"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "Pagina di arrivo"
      },
      "history": {
        "tooltip": "Attiva/disattiva visibilità della cronologia"
      },
      "instructions": {
        "tooltip": "Attiva/disattiva visibilità delle istruzioni"
      },
      "help": {
        "tooltip": "Attiva/disattiva visibilità della pagina della Guida"
      },
      "sync": {
        "tooltip": "Ricarica",
        "tooltipOn": "Interrompi ricaricamento automatico"
      },
      "syncInterval": {
        "tooltip": "Imposta intervallo di ricaricamento automatico"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "Selezionare gli elementi su cui si desidera eseguire l'operazione '{0}'."
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "Messaggio",
          "detail": "Impossibile eseguire l'azione '{0}' mentre è in esecuzione il ricaricamento automatico. Prima fare clic sull'icona '{1}' per interromperla."
        }
      }
    },
    "prompts": {
      "download": {
        "value": "Posizioni file di log scaricati:"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "Mostra colonne nascoste"
      }
    },
    "labels": {
      "totalRows": {
        "value": "Totale righe: {0}"
      },
      "reloadHidden": {
        "value": "Ricaricare la tabella per visualizzare i {0} valori correnti"
      },
      "noData": {
        "value": "Nessun dato trovato."
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "Colonne disponibili"
        },
        "list": {
          "value": "Lista di colonne disponibili"
        },
        "listItem": {
          "value": "Elemento lista di colonne disponibili"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "Colonne selezionate"
        },
        "list": {
          "value": "Lista di colonne selezionate"
        },
        "listItem": {
          "value": "Elemento lista di colonne selezionate"
        }
      },
      "button": {
        "addToRight": {
          "value": "Sposta gli elementi selezionati nella lista Colonne disponibili alla lista Colonne selezionate"
        },
        "addAllRight": {
          "value": "Sposta tutti gli elementi selezionati nella lista Colonne disponibili alla lista Colonne selezionate"
        },
        "removeRight": {
          "value": "Sposta gli elementi selezionati nella lista Colonne selezionate alla lista Colonne disponibili"
        },
        "removeAll": {
          "value": "Sposta tutti gli elementi nella lista Colonne selezionate alla lista Colonne disponibili"
        },
        "reset": {
          "value": "Ripristina le colonne nella lista Colonne selezionate in base a quelle presenti quando la funzione di personalizzazione della tabella è stata aperta."
        },
        "apply": {
          "value": "Applica personalizzazioni delle colonne alla tabella"
        },
        "cancel": {
          "value": "Annulla tutte le personalizzazioni delle colonne"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "Salva"
      },
      "new": {
        "label": "Crea"
      },
      "delete": {
        "label": "Rimuovi"
      },
      "back": {
        "label": "Indietro"
      },
      "next": {
        "label": "Avanti"
      },
      "finish": {
        "label": "Crea"
      },
      "customize": {
        "label": "Personalizza tabella"
      },
      "dashboard": {
        "label": "Nuovo dashboard"
      }
    },
    "icons": {
      "save": {
        "tooltip": "Salva"
      },
      "create": {
        "tooltip": "Crea"
      },
      "landing": {
        "tooltip": "Pagina di arrivo"
      },
      "history": {
        "tooltip": "Attiva/disattiva visibilità della cronologia"
      },
      "instructions": {
        "tooltip": "Attiva/disattiva visibilità delle istruzioni"
      },
      "help": {
        "tooltip": "Attiva/disattiva visibilità della pagina della Guida"
      },
      "sync": {
        "tooltip": "Ricarica",
        "tooltipOn": "Interrompi ricaricamento automatico"
      },
      "syncInterval": {
        "tooltip": "Imposta intervallo di ricaricamento automatico"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "Mostra campi avanzati"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "Fare clic sull'icona {0} per passare dal riepilogo alla Guida dettagliata e viceversa."
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "Le modifiche sono state aggiunte al carrello.",
        "generic": "Le modifiche sono state salvate.",
        "notSaved": "Nessun dato salvato perché non sono state rilevate modifiche."
      },
      "action": {
        "notAllowed": {
          "summary": "Azione non consentita",
          "detail": "Impossibile eseguire l'azione richiesta durante un'operazione di creazione. Fare clic sul pulsante Annulla per annullare l'operazione di creazione."
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "Riavvio del server o dell'applicazione obbligatorio"
      },
      "wdtIcon": {
        "tooltip": "Impostazioni WDT"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "Tabella della Guida",
        "columns": {
          "header": {
            "name": "Nome",
            "description": "Descrizione"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>Argomenti correlati:</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "Attributi"
      },
      "actions": {
        "label": "Azioni"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "Campi obbligatori incompleti",
        "detail": "Il campo {0} è obbligatorio, ma non è stato fornito alcun valore o ne è stato fornito uno non valido."
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "Aggiungi condizione"
        },
        "combine": {
          "label": "Combina"
        },
        "uncombine": {
          "label": "Annulla combinazione"
        },
        "moveup": {
          "label": "Sposta in alto"
        },
        "movedown": {
          "label": "Sposta in basso"
        },
        "remove": {
          "label": "Rimuovi"
        },
        "negate": {
          "label": "Nega"
        },
        "reset": {
          "label": "Reimposta"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "Aggiungi nuova prima condizione..."
          },
          "above": {
            "label": "Aggiungi condizione sopra la riga su cui è stato fatto clic..."
          },
          "below": {
            "label": "Aggiungi condizione sotto la riga su cui è stato fatto clic..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "Aggiungi sopra la condizione selezionata..."
          },
          "below": {
            "label": "Aggiungi sotto la condizione selezionata..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "Uno o più campi obbligatori non contengono dati."
      },
      "argumentValueHasWrongFormat": {
        "summary": "Il campo '{0}' contiene dati formattati in modo non corretto."
      },
      "conditionHasNoArgValues": {
        "summary": "La condizione selezionata non contiene valori di argomento da modificare."
      },
      "conditionAlreadyExists": {
        "summary": "Questo criterio di sicurezza ha già una condizione creata utilizzando il predicato selezionato o uno con valori di argomento corrispondenti."
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>Per specificare la posizione della nuova condizione, inserire un segno di spunta accanto alla condizione relativa, quindi fare clic sul pulsante <b>+Aggiungi condizione</b>.</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "Intervallo: da -31 a 31"
      },
      "dateTime": {
        "value": "Formato: yyyy-MM-dd [HH:mm:ss [AM|PM]] (ad esempio 2022-02-14 09:00:00)"
      },
      "time": {
        "value": "Formato: HH:mm:ss (ad esempio 14:22:47)"
      },
      "gmtOffset": {
        "value": "Formato: GMT+|-h:mm (ad esempio GMT-5:00)"
      },
      "weekDay": {
        "value": "Ad esempio domenica, lunedì, martedì, ..."
      },
      "or": {
        "value": "OR"
      },
      "not": {
        "value": "NOT"
      },
      "combination": {
        "value": "Combinazione"
      },
      "nodata": {
        "Policy": {
          "value": "Usare il pulsante <b>+ Aggiungi condizione</b> per aggiungere una condizione di criterio."
        },
        "DefaultPolicy": {
          "value": "Nessuna condizione di criterio di sicurezza predefinita definita."
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "Combinazione",
            "operator": "Operatore",
            "expression": "Frase condizione"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "OR",
            "and": "AND"
          }
        }
      }
    },
    "wizard": {
      "title": "Gestione criteri",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "Scegli predicato",
            "instructions": "Scegliere il predicato per la nuova condizione dall'elenco a discesa."
          },
          "body": {
            "labels": {
              "predicateList": "Lista di predicati"
            },
            "help": {
              "predicateList": "La lista di predicati contiene tutti i predicati disponibili che possono essere utilizzati per creare una condizione di criterio di sicurezza."
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "Predicato di gruppo",
            "instructions": "Iniziare digitando nel campo <i></i> per aggiungere i valori degli argomenti o per cercare i valori esistenti. Premere Invio per aggiungere il valore digitato alla lista. Per modificare un valore di argomento esistente, fare clic sul valore e modificarlo usando il campo di input della finestra popup."
          },
          "body": {
            "labels": {
              "conditionPhrase": "Frase condizione",
              "negate": "Nega condizione"
            },
            "help": {
              "negate": "Converte la condizione in modo da ottenere il significato contrario (ad esempio, \"uguale\" diventa \"diverso\", \"è in\" diventa \"non è in\")."
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "Albero"
      },
      "page": {
        "value": "Pagina"
      },
      "tab": {
        "value": "Scheda"
      },
      "ariaLabel": {
        "value": "Cronologia pagine"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "La pagina non esiste più",
        "detail1": "Si è stati reindirizzati alla pagina {0} perché ",
        "detail2": "{0} è stato eliminato da un altro utente o non esiste più. "
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "Segnalibri pagina"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "Aggiungi segnalibro per la pagina corrente"
        },
        "show": {
          "label": "Mostra segnalibri pagina..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "Esiste già un segnalibro per questa pagina. "
      },
      "pagesBookmarkAdded": {
        "summary": "Creazione del segnalibro per la pagina corrente riuscita. "
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "Torna alla pagina di arrivo della struttura ad albero del provider."
        },
        "reset": {
          "value": "Aggiorna valori pagina"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "Azione"
      },
      "apply": {
        "label": "Applica"
      },
      "reset": {
        "label": "Reimposta"
      },
      "ok": {
        "label": "OK"
      },
      "cancel": {
        "label": "Annulla"
      },
      "restart": {
        "label": "Riavvia"
      },
      "yes": {
        "label": "Sì"
      },
      "no": {
        "label": "No"
      },
      "choose": {
        "label": "Scegli"
      },
      "connect": {
        "label": "Connetti"
      },
      "add": {
        "label": "Aggiungi/Invia"
      },
      "edit": {
        "label": "Modifica/Invia"
      },
      "import": {
        "label": "Importa"
      },
      "export": {
        "label": "Esporta"
      },
      "write": {
        "label": "Download del file"
      },
      "savenow": {
        "label": "Salva adesso"
      },
      "next": {
        "label": "Avanti"
      },
      "previous": {
        "label": "Precedente"
      },
      "finish": {
        "label": "Fine"
      },
      "done": {
        "label": "Eseguito"
      },
      "close": {
        "label": "Chiudi"
      },
      "clear": {
        "label": "Cancella"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "Comprimi"
      },
      "expand": {
        "value": "Espandi"
      },
      "choose": {
        "value": "Scegli file"
      },
      "clear": {
        "value": "Cancella file scelto"
      },
      "more": {
        "value": "Altre azioni"
      },
      "download": {
        "value": "Sfoglia"
      },
      "reset": {
        "value": "Reimposta"
      },
      "filter": {
        "value": "Filtro"
      },
      "submit": {
        "value": "Sottometti modifiche"
      },
      "write": {
        "value": "Download del file"
      },
      "pick": {
        "value": "Scegli directory"
      },
      "reload": {
        "value": "Ricarica file"
      },
      "delete": {
        "value": "Elimina"
      },
      "remove": {
        "value": "Rimuovi"
      },
      "noData": {
        "value": "Nessun dato"
      },
      "preloader": {
        "value": "Preloader"
      },
      "checkAll": {
        "value": "Seleziona tutto"
      },
      "checkNone": {
        "value": "Deseleziona tutto"
      },
      "checkSome": {
        "value": "Cancella selezioni"
      },
      "close": {
        "value": "Chiudi"
      },
      "recentPages": {
        "value": "Attiva/disattiva visibilità della cronologia"
      },
      "pagesHistory": {
        "back": {
          "value": "Pagina precedente"
        },
        "next": {
          "value": "Pagina successiva"
        },
        "launch": {
          "value": "Mostra cronologia pagine"
        },
        "star": {
          "value": "Segnalibri pagina"
        }
      },
      "pageInfo": {
        "value": "Fare clic per bloccare e sbloccare"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "Scegli file..."
      },
      "chooseDir": {
        "value": "Scegli directory..."
      }
    },
    "labels": {
      "info": {
        "value": "Informazioni"
      },
      "warn": {
        "value": "Avvertenza"
      },
      "error": {
        "value": "Errore"
      },
      "alerts": {
        "value": "Avvisi"
      },
      "pagesHistory": {
        "value": "Di seguito sono riportate le pagine visitate dopo la selezione del provider corrente. Fare clic su una colonna della riga per accedere alla pagina associata."
      },
      "pagesBookmark": {
        "value": "Di seguito sono riportate le pagine con segnalibro per il tipo di provider {0}. Fare clic su una colonna della riga per accedere alla pagina associata."
      }
    },
    "placeholders": {
      "search": {
        "value": "Cerca"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "Rilevato contenuto errato"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "'{0}' contiene un file JSON, ma non è una rappresentazione del file JSON di un {1}."
      },
      "dataCopiedToClipboard": {
        "detail": "I dati sono stati copiati negli appunti."
      },
      "tableCopiedToClipboard": {
        "summary": "Copia della tabella negli appunti riuscita."
      },
      "emptyCellData": {
        "detail": "I dati non sono stati copiati negli appunti perché la cella selezionata è vuota."
      },
      "emptyRowData": {
        "detail": "I dati non sono stati copiati negli appunti perché la riga selezionata è vuota."
      },
      "browserPermissionDenied": {
        "summary": "Autorizzazione del browser negata",
        "detail": "Per eseguire questa operazione, è necessario abilitare la scrittura negli appunti da JavaScript. Inoltre, l'API degli appunti è supportata solo per le pagine fornite su HTTPS."
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "Copia cella negli appunti"
        },
        "row": {
          "label": "Copia riga negli appunti"
        },
        "tableAsText": {
          "label": "Copia tabella negli appunti (testo)"
        },
        "tableAsJSON": {
          "label": "Copia tabella negli appunti (JSON)"
        },
        "tableAsYAML": {
          "label": "Copia tabella negli appunti (YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "Comprimi tutto"
      },
      "useTreeMenusAsRootNodes": {
        "value": "Usa i menu Struttura come nodi principali"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "Salvataggio delle modifiche al file '{0}' riuscito."
      },
      "changesNotSaved": {
        "summary": "Impossibile salvare le modifiche al file '{0}'."
      },
      "changesDownloaded": {
        "summary": "Download delle modifiche nel file '{0}' riuscito."
      },
      "changesNotDownloaded": {
        "summary": "Impossibile scaricare le modifiche nel file '{0}'."
      },
      "verifyPathEntered": {
        "detail": ". L'impostazione del campo {0} su false accetterà il valore immesso senza convalidarne l'esistenza come file o directory locale."
      }
    },
    "wdtOptionsDialog": {
      "title": "Modifica: {0}",
      "default": "Annulla impostazione valore",
      "instructions": "Immettere il token da aggiungere alla lista di elementi selezionabili.",
      "enterValue": "Immettere un valore",
      "selectValue": "Selezionare un valore",
      "selectSwitch": "Attiva/Disattiva valore",
      "enterUnresolvedReference": "Immettere il riferimento non risolto",
      "enterModelToken": "Immettere il token modello",
      "selectPropsVariable": "Seleziona variabile token modello",
      "createPropsVariable": "Crea variabile token modello",
      "propName": "Nome variabile (obbligatorio)",
      "propValue": "Valore variabile",
      "enterVariable": "Immettere la variabile",
      "variableName": "Nome variabile (obbligatorio)",
      "variableValue": "Valore variabile",
      "multiSelectUnset": "Seleziona valore dalla lista di elementi disponibili"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "Rilevate modifiche non salvate"
      },
      "changesNeedDownloading": {
        "value": "Modifiche non scaricate"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "Tutte le modifiche non salvate andranno perdute. Continuare?"
        },
        "areYouSure": {
          "value": "Si è certi di voler {0} senza salvare le modifiche?"
        },
        "saveBeforeExiting": {
          "value": "Si desidera salvare le modifiche prima di uscire?"
        },
        "needDownloading": {
          "value": "Le modifiche apportate a '{0}' non sono state scaricate nel file.<br/><br/>Scaricarle prima di continuare?"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "La nuova istanza '{0}' non è stata aggiunta al modello WDT.<br/><br/>Aggiungerla prima di continuare?"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "Imposta intervallo di ricaricamento automatico",
      "instructions": "Indicare i secondi per l'intervallo di ricaricamento automatico.",
      "fields": {
        "interval": {
          "label": "Intervallo ricaricamento automatico:"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "Messaggio",
          "detail": "La chiamata backend della console ha generato una risposta '{0}' durante il tentativo di eseguire l'azione '{1}'."
        },
        "actionNotPerformed": {
          "detail": "Impossibile eseguire l'azione '{0}' su uno o più elementi selezionati"
        },
        "actionNotPerformedNoRow": {
          "detail": "Impossibile eseguire l'azione '{0}'"
        },
        "actionSucceeded": {
          "summary": "L'esecuzione dell'azione '{0}' è riuscita."
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "Impossibile determinare la causa esatta. Controllare la presenza di suggerimenti nella console JavaScript."
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "Conferma azione",
        "prompt": "L'azione '{0}' non può essere annullata.<br/><br/>Continuare?"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "Disponibili",
        "chosen": "Scelti"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "Nome proprietà",
        "value": "Valore proprietà"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "Nome proprietà",
        "valueHeader": "Valore proprietà",
        "addButtonTooltip": "Aggiungi",
        "deleteButtonTooltip": "Elimina"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "Visualizza {0}..."
          },
          "create": {
            "label": "Crea nuovo/a {0}..."
          },
          "edit": {
            "label": "Modifica {0}..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "Ripristina impostazioni predefinite"
    },
    "placeholder": {
      "value": "predefinito"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "'{0}' non è disponibile."
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "RUNNING"
      },
      "shutdown": {
        "value": "SHUTDOWN"
      },
      "serverStates": {
        "value": "Stati server"
      },
      "systemStatus": {
        "value": "Stato sistema"
      },
      "healthState": {
        "failed": {
          "value": "Non riuscito"
        },
        "critical": {
          "value": "Critico"
        },
        "overloaded": {
          "value": "Sovraccaricato"
        },
        "warning": {
          "value": "Avvertenza"
        },
        "ok": {
          "value": "OK"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "Integrità dei server in esecuzione a partire da"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "Nome"
        },
        "state": {
          "value": "Stato"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "Backend non al momento raggiungibile."
      },
      "connectionMessage": {
        "summary": "Messaggio di connessione"
      },
      "connectFailed": {
        "detail": "Tentativo non riuscito:"
      },
      "badRequest": {
        "detail": "Impossibile elaborare la richiesta o il file sottomesso"
      },
      "invalidCredentials": {
        "detail": "Le credenziali del dominio WebLogic non sono valide"
      },
      "invalidUrl": {
        "detail": "URL dominio WebLogic non raggiungibile"
      },
      "notInRole": {
        "detail": "Tentativo non riuscito: l'utente non dispone del ruolo Admin, Deployer, Operator o Monitor"
      },
      "notSupported": {
        "detail": "Dominio WebLogic non supportato"
      },
      "unexpectedStatus": {
        "detail": "Risultato imprevisto (stato: {0})"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "Richiesta non riuscita",
          "detail": "Una risposta non riuscita è stata restituita da una chiamata backend della console."
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "Consultare il terminale della console remota o la console Javascript per conoscere i motivi specifici."
      },
      "responseMessages": {
        "summary": "Messaggi di risposta"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "Conferma"
      },
      "prompt": {
        "value": "L'arresto di <b>{0}</b> reimposterà il provider corrente. Continuare?"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "Impossibile accedere a Change Manager."
      },
      "changesCommitted": {
        "summary": "Commit delle modifiche riuscito."
      },
      "changesNotCommitted": {
        "summary": "Impossibile eseguire il commit delle modifiche."
      },
      "changesDiscarded": {
        "summary": "Annullamento delle modifiche riuscito."
      },
      "changesNotDiscarded": {
        "summary": "Impossibile ignorare le modifiche."
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "Risposta di errore imprevista"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "Problema di connessione",
        "details": "In caso di problemi di invio e ricezione dei dati dal fornitore, assicurarsi che sia accessibile prima di continuare."
      },
      "pathNotFound": {
        "summary": "Percorso non trovato",
        "details": "'{0}' non è un file o una directory accessibile nel file system locale."
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "Barra dei messaggi"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "Cancella messaggio"
        },
        "suppress": {
          "info": {
            "label": "Elimina messaggi informativi"
          },
          "warning": {
            "label": "Elimina messaggi di avvertenza"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " Impossibile connettersi al server di amministrazione del dominio WebLogic."
      },
      "shutdownSequenceError": {
        "details": "Arrestare i server gestiti, quindi il server di amministrazione."
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "{0} avviso/i di errore con priorità elevata"
        },
        "warning": {
          "value": "{0} avviso/i di avvertenza con priorità elevata"
        },
        "info": {
          "value": "{0} avviso/i informativo/i con priorità elevata"
        },
        "view": {
          "value": "Visualizza avviso"
        }
      }
    }
  }
});