define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "En-tête d'application"
      }
    },
    "buttons": {
      "logout": {
        "label": "Déconnexion"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "Activer/Désactiver la visibilité de l'arborescence de navigation"
        }
      },
      "theme": {
        "tooltip": "Changer de thème"
      },
      "whatsNew": {
        "tooltip": "Nouveautés"
      },
      "howDoI": {
        "tooltip": "Ouvrir les tâches de procédure"
      },
      "tips": {
        "tooltip": "Activer/désactiver la visibilité des conseils d'utilisation"
      },
      "help": {
        "tooltip": "Ouvrir la documentation interne WebLogic Remote Console"
      },
      "profile": {
        "tooltip": "Profil"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "Ouvrir le centre de messages"
      },
      "theme": {
        "light": {
          "value": "Clair"
        },
        "dark": {
          "value": "Sombre"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "Cliquer ici pour réinitialiser WebLogic Remote Console"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "Copyright (c) 2020, 2025, Oracle et/ou ses affiliés.<br/>Oracle (r), Java, MySQL et NetSuite sont des marques déposées d'Oracle Corporation et/ou de ses affiliés. Tout autre nom mentionné peut être une marque appartenant à un autre propriétaire qu'Oracle.<br/>",
      "builtWith": "Conçu avec Oracle JET"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "Non sécurisé"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "Connexion au serveur d'administration non sécurisée"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "Afficher la liste des profils"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "Gérer les profils"
          },
          "editor": {
            "tooltip": "Editeur de profil",
            "toolbar": {
              "save": {
                "tooltip": "Enregistrer le profil"
              },
              "activate": {
                "tooltip": "Profil actif"
              },
              "add": {
                "tooltip": "Ajouter un profil"
              },
              "remove": {
                "tooltip": "Supprimer le profil"
              }
            }
          }
        },
        "image": {
          "tooltip": "Profil",
          "capture": {
            "tooltip": "Ajouter ou modifier l'image"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "Généralités"
        },
        "settings": {
          "value": "Paramètres"
        },
        "preferences": {
          "value": "Préférences"
        },
        "properties": {
          "value": "Propriétés"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "Modifier l'image"
      },
      "clearImage": {
        "value": "Effacer l'image"
      },
      "profile": {
        "default": {
          "value": "Profil par défaut"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "Afficher l'éditeur de profil"
            },
            "hide": {
              "value": "Masquer l'éditeur de profil"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "Ouvrir le gestionnaire de profil"
          },
          "signout": {
            "value": "Déconnexion"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "ID de profil"
          },
          "organization": {
            "value": "Organisation"
          },
          "name": {
            "value": "Nom"
          },
          "email": {
            "value": "Adresse électronique"
          },
          "role": {
            "default": {
              "value": "Utiliser en tant que profil par défaut"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "Stocker les informations d'identification cryptées pour vos projets ?"
            },
            "disableHNV": {
              "value": "Désactiver la vérification du nom d'hôte ?"
            },
            "proxyAddress": {
              "value": "Adresse du proxy"
            },
            "trustStoreType": {
              "value": "Type de truststore"
            },
            "trustStorePath": {
              "value": "Chemin de truststore"
            },
            "trustStoreKey": {
              "value": "Clé de truststore"
            },
            "connectionTimeout": {
              "value": "Délai d'expiration de la connexion au serveur d'administration"
            },
            "readTimeout": {
              "value": "Délai d'expiration de lecture du serveur d'administration"
            }
          },
          "preferences": {
            "theme": {
              "value": "Thème"
            },
            "startupTaskChooserType": {
              "value": "Type de sélecteur de tâche de démarrage"
            },
            "useTreeMenusAsRootNodes": {
              "value": "Utiliser les menus arborescents en tant que niveau racine des navigateurs d'arborescence ?"
            },
            "onQuit": {
              "value": "Ne pas quitter l'application en présence de modifications non enregistrées ?"
            },
            "onDelete": {
              "value": "Confirmer toutes les suppressions ?"
            },
            "onActionNotAllowed": {
              "value": "Utiliser la fenêtre instantanée Action non autorisée pour éviter la perte de données ?"
            },
            "onUnsavedChangesDetected": {
              "value": "Utiliser la fenêtre instantanée Modifications non enregistrées détectées pour éviter la perte de données ?"
            },
            "onChangesNotDownloaded": {
              "value": "Utiliser la fenêtre instantanée Modifications non téléchargées pour éviter la perte de données ?"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Propriétés système Java"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "Clair"
            },
            "dark": {
              "value": "Sombre"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "Utiliser une boîte de dialogue"
            },
            "useCards": {
              "value": "Utiliser des cartes"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "Windows ROOT"
            },
            "keyChainStore": {
              "value": "Banque de porte-clés"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "Le profil \"{0}\" a été enregistré."
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "Actions de fournisseur "
        }
      },
      "info": {
        "tooltip": "Obtenir des informations sur ce fournisseur"
      },
      "edit": {
        "tooltip": "Gérer les paramètres pour ce fournisseur"
      },
      "deactivate": {
        "tooltip": "Désactiver ce fournisseur"
      },
      "delete": {
        "tooltip": "Enlever ce fournisseur"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "Projet sans nom"
        },
        "name": {
          "value": "Nom du fournisseur de connexion"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "Proxy de remplacement"
        },
        "username": {
          "value": "Nom utilisateur"
        },
        "password": {
          "value": "Mot de passe"
        }
      },
      "models": {
        "name": {
          "value": "Nom du fournisseur de modèle WDT"
        },
        "file": {
          "value": "Nom de fichier du modèle WDT"
        },
        "props": {
          "value": "Variables WDT"
        }
      },
      "composite": {
        "name": {
          "value": "Nom du fournisseur de modèle de composite WDT"
        },
        "providers": {
          "value": "Modèles WDT"
        }
      },
      "proplist": {
        "name": {
          "value": "Nom du fournisseur de liste des propriétés"
        },
        "file": {
          "value": "Nom de fichier de la liste des propriétés"
        }
      },
      "project": {
        "name": {
          "value": "Nom du projet"
        },
        "file": {
          "value": "Nom de fichier du projet"
        }
      },
      "provider": {
        "adminserver": {
          "value": "Connexion au serveur d'administration"
        },
        "model": {
          "value": "Ajouter un modèle WDT"
        }
      },
      "dropdown": {
        "none": {
          "value": "Aucun"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "Nom du projet:"
          }
        },
        "provider": {
          "id": {
            "label": "ID du fournisseur :"
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "Version d'extension de console :"
          },
          "name": {
            "label": "Nom du domaine :"
          },
          "url": {
            "label": "URL de domaine :"
          },
          "proxyOverride": {
            "label": "Proxy de remplacement:"
          },
          "version": {
            "label": "Version de domaine :"
          },
          "username": {
            "label": "Nom utilisateur :"
          },
          "sso": {
            "label": "Authentification Web :"
          },
          "roles": {
            "label": "Rôles :"
          },
          "connectTimeout": {
            "label": "Délai d'expiration de la connexion:"
          },
          "readTimeout": {
            "label": "Expiration de la lecture :"
          },
          "insecure": {
            "label": "Non sécurisé :"
          },
          "anyAttempt": {
            "label": "Toutes les tentatives de connexion :"
          },
          "lastAttempt": {
            "label": "Dernière tentative réussie :"
          }
        },
        "model": {
          "file": {
            "label": "Fichier :"
          },
          "props": {
            "label": "Variables :"
          }
        },
        "composite": {
          "models": {
            "label": "Modèles :"
          }
        },
        "proplist": {
          "file": {
            "label": "Nom de fichier :"
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "Ajouter un fournisseur de connexion au serveur d'administration"
        }
      },
      "models": {
        "add": {
          "value": "Ajouter un fournisseur de fichier de modèle WDT"
        },
        "new": {
          "value": "Créer un fournisseur pour le nouveau fichier de modèle WDT"
        }
      },
      "composite": {
        "add": {
          "value": "Ajouter un fournisseur de fichier de modèle de composite WDT"
        }
      },
      "proplist": {
        "add": {
          "value": "Ajouter un fournisseur de liste des propriétés"
        },
        "new": {
          "value": "Créer un fournisseur pour la nouvelle liste des propriétés"
        }
      },
      "providers": {
        "sort": {
          "value": "Trier par type de fournisseur"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "URL de domaine :"
              },
              "version": {
                "label": "Version de domaine :"
              },
              "username": {
                "label": "Nom utilisateur :"
              }
            }
          },
          "model": {
            "file": {
              "label": "Fichier :"
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "Exporter les fournisseurs en tant que projet..."
        },
        "import": {
          "value": "Importer un projet"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "Indiquez un nouveau nom et des paramètres de connectivité pour le fournisseur de connexion."
        },
        "edit": {
          "value": "Modifiez les paramètres de connectivité du fournisseur de connexion."
        },
        "deactivate": {
          "value": "Désactivez le fournisseur de connexion et arrêtez l'interrogation du statut de domaine."
        }
      },
      "models": {
        "add": {
          "value": "Indiquez des paramètres pour le fournisseur de fichier de modèle existant. Cliquez sur l'icône de téléchargement vers le serveur pour rechercher le fichier de modèle."
        },
        "new": {
          "value": "Saisissez le nom du fournisseur ainsi que le nom du nouveau fichier de modèle WDT, puis cliquez sur l'icône pour sélectionner le répertoire dans lequel enregistrer le fichier."
        },
        "edit": {
          "value": "Modifiez les paramètres du fournisseur de fichier de modèle. Cliquez sur l'icône pour rechercher le fichier de modèle."
        }
      },
      "composite": {
        "add": {
          "value": "Indiquez un nouveau nom et sélectionnez une liste triée de modèles pour le fournisseur de modèle de composite."
        },
        "edit": {
          "value": "Modifiez les paramètres du fournisseur de modèle de composite. Utilisez une liste triée de modèles."
        }
      },
      "proplist": {
        "add": {
          "value": "Indiquez des paramètres pour le fournisseur de liste des propriétés existant. Cliquez sur l'icône de téléchargement vers le serveur pour rechercher le fichier de propriétés."
        },
        "new": {
          "value": "Saisissez le nom du fournisseur ainsi que le nom de fichier de la nouvelle liste des propriétés, puis cliquez sur l'icône pour sélectionner le répertoire dans lequel enregistrer le fichier."
        },
        "edit": {
          "value": "Modifez les paramètres pour le fournisseur de liste des propriétés. Cliquez sur l'icône pour rechercher le fichier de propriétés."
        }
      },
      "project": {
        "export": {
          "value": "Indiquez les paramètres du nouveau projet."
        },
        "import": {
          "value": "Cliquez sur l'icône de téléchargement en local pour rechercher le projet."
        }
      },
      "task": {
        "startup": {
          "value": "Quelle tâche de démarrage souhaitez-vous effectuer ?"
        }
      },
      "project-busy": {
        "value": "Enregistrez ou abandonnez les modifications non enregistrées avant d'en apporter d'autres à n'importe quelle partie du projet"
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "Créer un fournisseur pour la connexion au serveur d'administration"
        },
        "models": {
          "value": "Créer un fournisseur pour le fichier de modèle WDT existant"
        },
        "composite": {
          "value": "Créer un fournisseur pour le nouveau modèle de composite WDT"
        },
        "proplist": {
          "value": "Créer un fournisseur pour la liste des propriétés existante"
        }
      },
      "new": {
        "models": {
          "value": "Créer un fournisseur pour le nouveau fichier de modèle WDT"
        },
        "proplist": {
          "value": "Créer un fournisseur pour la nouvelle liste des propriétés"
        }
      },
      "edit": {
        "connections": {
          "value": "Modifier le fournisseur de la connexion au serveur d'administration"
        },
        "models": {
          "value": "Modifier le fournisseur de fichier de modèle WDT"
        },
        "composite": {
          "value": "Modifier le fournisseur de modèle de composite WDT"
        },
        "proplist": {
          "value": "Modifier le fournisseur de liste des propriétés"
        }
      },
      "export": {
        "project": {
          "value": "Exporter les fournisseurs en tant que projet"
        }
      },
      "import": {
        "project": {
          "value": "Importer un projet"
        }
      },
      "startup": {
        "task": {
          "value": "Tâche de démarrage"
        }
      },
      "project-busy": {
        "value": "Projet occupé"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "Echec de l'export",
          "detail": "Impossible d'exporter les fournisseurs en tant que projet '{0}'."
        }
      },
      "import": {
        "failed": {
          "summary": "Echec de l'enregistrement",
          "detail": "Impossible d'importer le fichier de projet '{0}'."
        }
      },
      "stage": {
        "failed": {
          "summary": "Echec de la création",
          "detail": "Impossible de créer l'élément de fournisseur '{0}'."
        }
      },
      "use": {
        "failed": {
          "summary": "Echec de la connexion",
          "detail": "Impossible d'utiliser l'élément de fournisseur '{0}'."
        }
      },
      "upload": {
        "failed": {
          "detail": "Impossible de charger le fichier de modèle WDT : {0}"
        },
        "props": {
          "failed": {
            "detail": "Impossible de charger les variables WDT : {0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "Un fournisseur nommé '{0}' existe déjà dans ce projet."
        },
        "modelsNotFound": {
          "detail": "Impossible de trouver les modèles WDT configurés '{0}'"
        },
        "propListNotFound": {
          "detail": "Impossible de trouver les variables WDT '{0}'"
        },
        "selectModels": {
          "detail": "Pour sélectionner le composite WDT, sélectionnez d'abord tous les modèles WDT utilisés par le composite WDT."
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "L'URL doit comprendre le protocole HTTPS ou utiliser localhost"
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>Modifiez le chemin dans le champ de nom de fichier, puis cliquez sur le bouton OK. Sinon, cliquez sur l'icône de téléchargement et choisissez un autre fichier.</p>"
        },
        "fixModelFile": {
          "detail": "<p>Corrigez les problèmes cités ci-dessous, puis cliquez sur le bouton OK. Sinon, choisissez un autre fichier.</p>"
        },
        "yamlException": {
          "detail": "{0} à la ligne {1}, colonne {2}"
        },
        "wktModelContent": {
          "summary": "Problèmes de contenu de modèle",
          "detail": "Utilisez l'éditeur de modèle de l'onglet <i>Vue du code</i> pour résoudre les problèmes."
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "Non défini"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "Utiliser un modèle dispersé"
      },
      "usesso": {
        "label": "Utiliser l'authentification Web"
      },
      "insecure": {
        "label": "Etablir une connexion non sécurisée"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "Modifier l'arborescence"
      },
      "view": {
        "tooltip": "Arborescence de la vue de configuration"
      },
      "monitoring": {
        "tooltip": "Arborescence de la surveillance"
      },
      "security": {
        "tooltip": "Arborescence des données de sécurité"
      },
      "modeling": {
        "tooltip": "Modèle WDT"
      },
      "composite": {
        "tooltip": "Modèle de composite WDT"
      },
      "properties": {
        "tooltip": "Editeur de liste des propriétés"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "Menu des arborescences de fournisseur"
      },
      "navtree": {
        "value": "Navigateur d'arborescence de fournisseur"
      },
      "panelResizer": {
        "value": "Poignée de redimensionnement de navigateur d'arborescence de fournisseur. Utilisez les touches fléchées vers la gauche et vers la droite pour redimensionner le navigateur"
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "Accueil. Revenir à la page contenant les cartes des arborescences du fournisseur"
        }
      },
      "region": {
        "title": {
          "value": "En-tête de zone de contenu"
        }
      },
      "popup": {
        "provider": {
          "value": "Actions de fournisseur"
        }
      }
    },
    "title": {
      "home": "Accueil",
      "configuration": "Modifier l'arborescence",
      "view": "Arborescence de la vue de configuration",
      "monitoring": "Arborescence de la surveillance",
      "security": "Arborescence des données de sécurité",
      "modeling": "Modèle WDT",
      "composite": "Modèle de composite WDT",
      "properties": "Liste des propriétés"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "Accueil"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "Cliquer ici pour visualiser les actions de panier"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "Visualiser les modifications..."
        },
        "discard": {
          "label": "Annuler les modifications"
        },
        "commit": {
          "label": "Valider les modifications"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "Panier"
        },
        "ataglance": {
          "label": "Vue d'ensemble"
        },
        "projectmanagement": {
          "label": "Fournisseurs"
        },
        "tips": {
          "label": "Conseils d'utilisation"
        },
        "dashboards": {
          "label": "Tableaux de bord"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "Conseils de filtrage",
        "checkboxes": {
          "hideall": "Masquer tous les conseils",
          "productivity": "Afficher les conseils de productivité",
          "personalization": "Afficher les conseils de personnalisation",
          "whereis": "Afficher les conseils de localisation",
          "accessibility": "Afficher les conseils d'accessibilité",
          "connectivity": "Afficher les conseils de connectivité",
          "security": "Afficher les conseils de sécurité",
          "other": "Afficher les autres conseils"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "Tout masquer"
        },
        "productivity": {
          "value": "Productivité"
        },
        "personalization": {
          "value": "Personnalisation"
        },
        "whereis": {
          "value": "Localisation"
        },
        "accessibility": {
          "value": "Accessibilité"
        },
        "connectivity": {
          "value": "Connectivité"
        },
        "security": {
          "value": "Sécurité"
        },
        "other": {
          "value": "Autre"
        }
      },
      "cards": {
        "tip0": {
          "title": "Effectuez une recherche dans tous les MBeans de votre domaine !",
          "descriptionHTML": "<p>Saisissez un terme dans le champ de recherche en haut de la console pour rechercher des correspondances dans la perspective en cours. Vous pouvez également consulter les requêtes précédentes dans le noeud <b>Recherches récentes</b>.</p>"
        },
        "tip1": {
          "title": "Filtrez et trouvez rapidement les données qui vous importent !",
          "descriptionHTML": "<p>Les tableaux de bord vous permettent de définir des critères personnalisés, de les appliquer à votre domaine et de générer des rapports complets et précis fondés sur votre domaine.</p><p>Pour commencer, ouvrez un noeud dans l'<b>arborescence de la surveillance</b>, puis cliquez sur <b>Nouveau tableau de bord</b>. Sinon, ouvrez le noeud de niveau supérieur <b>Tableaux de bord</b> pour voir les tableaux de bord intégrés.</p>"
        },
        "tip2": {
          "title": "Affinage du contenu de la table",
          "descriptionHTML": "<p>Simplifiez les tables en masquant les colonnes non pertinentes afin de vous concentrer sur les données qui vous importent.</p><p>Au-dessus d'une table, cliquez sur <b>Personnaliser la table</b>, puis sélectionnez ou désélectionnez les colonnes comme souhaité.</p>"
        },
        "tip3": {
          "title": "Utilisation du clavier avec les tables et les actions",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "Où se trouve le lien Personnaliser cette table ?",
          "descriptionHTML": "<p>Le lien Personnaliser cette table est devenu le bouton <i>Personnaliser la table</i>.</p>"
        },
        "tip5": {
          "title": "Vérification des modifications en attente",
          "descriptionHTML": "<p>Ouvrez le panier pour voir la liste des modifications enregistrées dans le domaine mais pas encore validées.</p><p>Si vous ne pouvez pas voir l'option <b>Visualiser les modifications</b> dans le panier, essayez d'<a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>installer l'extension WebLogic Remote Console</a>."
        },
        "tip6": {
          "title": "Besoin d'aide ?",
          "descriptionHTML": "<ul><li>Placez le curseur de la souris sur <b>?</b> en regard d'un champ pour afficher une info-bulle.</li><li>Cliquez sur <b>?</b> au niveau d'une page pour afficher l'aide détaillée sur chaque attribut visible.</li><li>Dans le menu <b>Aide</b>, cliquez sur <b>Accéder au projet GitHub WebLogic Remote Console</b>.</li><li>Rejoignez notre canal Slack : <a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>.</li><li>Consultez notre documentation à l'adresse <a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>.</li></ul>"
        },
        "tip7": {
          "title": "Autre conseil 1",
          "descriptionHTML": "<p>Brève description pour Autre conseil 1. Un caractère de retour à la ligne n'étant pas un élément HTML, n'en utilisez pas dans cette description.</p>"
        },
        "tip8": {
          "title": "Des problèmes de connexion à un serveur ?",
          "descriptionHTML": "<p>Sous <b>Arborescence de la surveillance</b> > <b>Environnement</b> > <b>Serveurs</b>, sélectionnez le serveur qui ne répond pas et ouvrez son onglet <b>Dépannage</b> pour reproduire et diagnostiquer le problème.</p><p>Si vous ne parvenez pas à vous connecter au domaine, reportez-vous à <a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>Connexion impossible au serveur d'administration</a> dans la documentation WebLogic Remote Console pour obtenir de l'aide sur le dépannage.</p>"
        },
        "tip9": {
          "title": "Conseil de connectivité 2",
          "descriptionHTML": "<p>Brève description pour Conseil de connectivité 2. Un caractère de retour à la ligne n'étant pas un élément HTML, n'en utilisez pas dans cette description.</p>"
        },
        "tip10": {
          "title": "Conseil de sécurité 1",
          "descriptionHTML": "<p>Brève description pour Conseil de sécurité 1. Un caractère de retour à la ligne n'étant pas un élément HTML, n'en utilisez pas dans cette description.</p>"
        },
        "tip11": {
          "title": "Accélérez votre workflow !",
          "descriptionHTML": "<p>Utilisez les raccourcis clavier afin d'accéder directement à des composants d'interface utilisateur spécifiques.</p><p>5 principaux raccourcis :</p><li><code><b>Alt+P</b></code> - Permet d'ouvrir le tiroir <b>Fournisseurs</b>.</li><li><code><b>Alt+C</b></code> - Permet de déplacer le focus sur le <b>panier</b>.</li><li><code><b>Alt+T</b></code> - Permet de déplacer le focus sur le premier en-tête de colonne d'une table.</li><li><code><b>Alt+|</b></code> - Permet de déplacer le focus sur la poignée de redimensionnement de la largeur de l'arborescence de navigation. Utilisez les touches fléchées pour modifier la largeur de l'arborescence.</li><li><code><b>Alt+;</b></code> - Permet de déplacer le focus sur le premier libellé de chemin de navigation sur lequel il est possible de cliquer.</li></ul><p>Pour obtenir la liste complète des raccourcis clavier, reportez-vous à la documentation.</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "Chemins de navigation"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "Historique"
      },
      "separator": {
        "tooltip": "Séparateur"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "Effacer les entrées de l'historique",
          "label": "Effacer les entrées de l'historique"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "exécution à {0}"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "Connexion perdue",
        "detail": "Connexion perdue. Procédez à l'actualisation."
      },
      "cannotConnect": {
        "summary": "Echec de la tentative de connexion",
        "detail": "Impossible de se connecter au domaine WebLogic {0}, vérifiez que WebLogic est en cours d'exécution."
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "Arborescences"
        },
        "startup-tasks": {
          "label": "Tâches de démarrage"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Page de destination"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "Liens de page de destination"
        }
      },
      "screenreader": {
        "value1": "Vous êtes sur l'élément {0}. Appuyez sur Entrée pour le sélectionner.",
        "value2": "Vous êtes sur l'élément {0}. Appuyez sur Entrée pour le développer ou le réduire. Après l'avoir développé, utilisez la flèche vers le bas pour accéder aux liens associés.",
        "value3": "{0}. Appuyez sur Tab/Maj + Tab pour vous déplacer entre les liens associés et sur Echap pour revenir au dernier élément de niveau supérieur utilisé."
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Arborescences de fournisseur"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "Modifier l'arborescence",
        "description": "<p>Gérez la configuration du domaine WebLogic que vous utilisez.</p>"
      },
      "view": {
        "label": "Arborescence de la vue de configuration",
        "description": "<p>Examinez la configuration en lecture seule du domaine WebLogic que vous utilisez.</p>"
      },
      "monitoring": {
        "label": "Arborescence de la surveillance",
        "description": "<p>Visualisez les informations du MBean d'exécution pour les ressources sélectionnées dans le domaine WebLogic que vous utilisez.</p>"
      },
      "security": {
        "label": "Arborescence des données de sécurité",
        "description": "<p>Gérez les informations relatives à la sécurité (par exemple, utilisateurs, groupes, rôles, stratégies, informations d'identification, etc.) dans le domaine WebLogic que vous utilisez actuellement.</p>"
      },
      "modeling": {
        "label": "Arborescence du modèle WDT",
        "description": "<p>Gérez les fichiers de modèle associés à l'outil WebLogic Deploy Tooling.</p>"
      },
      "composite": {
        "label": "Arborescence du modèle de composite WDT",
        "description": "<p>Visualisez un ensemble combinés des fichiers de modèle WebLogic Deploy Tooling que vous utilisez actuellement.</p>"
      },
      "properties": {
        "label": "Editeur de liste des propriétés",
        "description": "<p>Visualisez ou modifiez un ensemble de propriétés provenant d'un fichier de liste des propriétés.</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Tâches de démarrage"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "Ajouter un fournisseur de connexion au serveur d'administration",
        "description": "Cette tâche crée une ressource de projet permettant de se connecter à un serveur d'administration"
      },
      "addWdtModel": {
        "label": "Ajouter un fournisseur de fichier de modèle WDT",
        "description": "Cette tâche crée une ressource de projet permettant de gérer un fichier de modèle WDT existant sur le système de fichiers local"
      },
      "addWdtComposite": {
        "label": "Ajouter un fournisseur de fichier de modèle de composite WDT",
        "description": "Cette tâche crée une ressource de projet permettant de gérer des fragments de fichier de modèle WDT existants sur le système de fichiers local"
      },
      "addPropertyList": {
        "label": "Ajouter un fournisseur de liste des propriétés",
        "description": "Cette tâche crée une ressource de projet permettant de gérer un fichier .properties stocké sur le système de fichiers local"
      },
      "createWdtModel": {
        "label": "Créer un fournisseur pour le nouveau fichier de modèle WDT",
        "description": "Cette tâche crée une ressource de projet qui est un nouveau fichier de modèle WDT, stocké sur le système de fichiers local"
      },
      "createPropertyList": {
        "label": "Créer un fournisseur pour la nouvelle liste des propriétés",
        "description": "Cette tâche crée une ressource de projet qui est un nouveau fichier .properties, stocké sur le système de fichiers local"
      },
      "importProject": {
        "label": "Importer un projet",
        "description": "Cette tâche charge un projet exporté précédemment qui contient des fournisseurs prêts à être utilisés ou modifiés immédiatement"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "Annuler les modifications"
      },
      "commit": {
        "tooltip": "Valider les modifications"
      }
    },
    "sections": {
      "changeManager": {
        "label": "Gestionnaire de modifications"
      },
      "additions": {
        "label": "Ajouts"
      },
      "modifications": {
        "label": "Modifications"
      },
      "removals": {
        "label": "Suppressions"
      },
      "restart": {
        "label": "Redémarrage"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "Nouveau"
      },
      "clone": {
        "label": "Cloner"
      },
      "delete": {
        "label": "Supprimer"
      },
      "customize": {
        "label": "Personnaliser la table"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "Page de destination"
      },
      "history": {
        "tooltip": "Activer/Désactiver la visibilité de l'historique"
      },
      "instructions": {
        "tooltip": "Activer/Désactiver la visibilité des instructions"
      },
      "help": {
        "tooltip": "Activer/Désactiver la visibilité de la page d'aide"
      },
      "sync": {
        "tooltip": "Recharger",
        "tooltipOn": "Arrêter le rechargement automatique"
      },
      "syncInterval": {
        "tooltip": "Définir l'intervalle de rechargement automatique"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "Sélectionnez les éléments sur lesquels effectuer l'opération '{0}'."
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "Message",
          "detail": "Impossible d'effectuer l'action '{0}' lorsque le rechargement automatique est en cours. Cliquez d'abord sur l'icône '{1}' pour l'arrêter."
        }
      }
    },
    "prompts": {
      "download": {
        "value": "Emplacements de fichier journal téléchargé :"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "Afficher les colonnes masquées"
      }
    },
    "labels": {
      "totalRows": {
        "value": "Nombre total de lignes : {0}"
      },
      "reloadHidden": {
        "value": "Recharger la table pour voir les valeurs {0} en cours"
      },
      "noData": {
        "value": "Données introuvables."
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "Colonnes disponibles"
        },
        "list": {
          "value": "Liste des colonnes disponibles"
        },
        "listItem": {
          "value": "Elément de liste des colonnes disponibles"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "Colonnes sélectionnées"
        },
        "list": {
          "value": "Liste des colonnes sélectionnées"
        },
        "listItem": {
          "value": "Elément de liste des colonnes sélectionnées"
        }
      },
      "button": {
        "addToRight": {
          "value": "Déplacer les éléments sélectionnés de la liste des colonnes disponibles vers la liste des colonnes sélectionnées"
        },
        "addAllRight": {
          "value": "Déplacer tous les éléments de la liste des colonnes disponibles vers la liste des colonnes sélectionnées"
        },
        "removeRight": {
          "value": "Déplacer les éléments sélectionnés de la liste des colonnes sélectionnées vers la liste des colonnes disponibles"
        },
        "removeAll": {
          "value": "Déplacer tous les éléments de la liste des colonnes sélectionnées vers la liste des colonnes disponibles"
        },
        "reset": {
          "value": "Restaurez les colonnes de la liste des colonnes sélectionnées vers celles présentes lors de l'ouverture de l'outil de personnalisation de table."
        },
        "apply": {
          "value": "Appliquer les personnalisations de colonne à la table"
        },
        "cancel": {
          "value": "Annuler toutes les personnalisations de colonne"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "Enregistrer"
      },
      "new": {
        "label": "Créer"
      },
      "delete": {
        "label": "Enlever"
      },
      "back": {
        "label": "Retour"
      },
      "next": {
        "label": "Suivant"
      },
      "finish": {
        "label": "Créer"
      },
      "customize": {
        "label": "Personnaliser la table"
      },
      "dashboard": {
        "label": "Nouveau tableau de bord"
      }
    },
    "icons": {
      "save": {
        "tooltip": "Enregistrer"
      },
      "create": {
        "tooltip": "Créer"
      },
      "landing": {
        "tooltip": "Page de destination"
      },
      "history": {
        "tooltip": "Activer/Désactiver la visibilité de l'historique"
      },
      "instructions": {
        "tooltip": "Activer/Désactiver la visibilité des instructions"
      },
      "help": {
        "tooltip": "Activer/Désactiver la visibilité de la page d'aide"
      },
      "sync": {
        "tooltip": "Recharger",
        "tooltipOn": "Arrêter le rechargement automatique"
      },
      "syncInterval": {
        "tooltip": "Définir l'intervalle de rechargement automatique"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "Afficher les champs avancés"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "Cliquez sur l'icône {0} pour basculer entre l'aide récapitulative et l'aide détaillée."
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "Les modifications ont été ajoutées au panier.",
        "generic": "Les modifications ont été enregistrées.",
        "notSaved": "Aucune modification enregistrée car aucune n'a été détectée."
      },
      "action": {
        "notAllowed": {
          "summary": "Action non autorisée",
          "detail": "Impossible d'effectuer l'action demandée pendant une opération de création. Cliquez sur le bouton Annuler pour annuler l'opération de création."
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "Redémarrage du serveur ou de l'application requis"
      },
      "wdtIcon": {
        "tooltip": "Paramètres de WDT"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "Table d'aide",
        "columns": {
          "header": {
            "name": "Nom",
            "description": "Description"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>Rubriques connexes :</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "Attributs"
      },
      "actions": {
        "label": "Actions"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "Champs requis incomplets",
        "detail": "Le champ {0} est requis mais aucune valeur n'a été fournie (ou une valeur non valide est fournie)."
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "Ajouter une condition"
        },
        "combine": {
          "label": "Combiner"
        },
        "uncombine": {
          "label": "Annuler la combinaison"
        },
        "moveup": {
          "label": "Déplacer vers le haut"
        },
        "movedown": {
          "label": "Déplacer vers le bas"
        },
        "remove": {
          "label": "Enlever"
        },
        "negate": {
          "label": "Inverser"
        },
        "reset": {
          "label": "Réinitialiser"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "Ajouter une nouvelle première condition..."
          },
          "above": {
            "label": "Ajouter une condition au-dessus de la ligne sélectionnée..."
          },
          "below": {
            "label": "Ajouter une condition en dessous de la ligne sélectionnée..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "Ajouter au-dessus de la condition sélectionnée..."
          },
          "below": {
            "label": "Ajouter en dessous de la condition sélectionnée..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "Certains champs requis ne contiennent aucune donnée."
      },
      "argumentValueHasWrongFormat": {
        "summary": "Le champ '{0}' contient des données au format incorrect."
      },
      "conditionHasNoArgValues": {
        "summary": "La condition sélectionnée ne comporte aucune valeur d'argument à modifier."
      },
      "conditionAlreadyExists": {
        "summary": "Cette stratégie de sécurité comporte déjà une condition créée à l'aide du prédicat sélectionné ou une condition avec des valeurs d'argument correspondantes."
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>Pour indiquer l'emplacement de la nouvelle condition, placez une coche en regard de la condition relative, puis cliquez sur le bouton <b>+ Ajouter une condition</b>.</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "Plage : -31 à 31"
      },
      "dateTime": {
        "value": "Format : yyyy-MM-dd [HH:mm:ss [AM|PM]] (par exemple : 2022-02-14 09:00:00 AM)"
      },
      "time": {
        "value": "Format : HH:mm:ss (par exemple, 14:22:47)"
      },
      "gmtOffset": {
        "value": "Format : GMT+|-h:mm (par exemple, GMT-5:00)"
      },
      "weekDay": {
        "value": "par exemple, dimanche, lundi, mardi..."
      },
      "or": {
        "value": "ou"
      },
      "not": {
        "value": "NOT"
      },
      "combination": {
        "value": "Combinaison"
      },
      "nodata": {
        "Policy": {
          "value": "Utilisez le bouton <b>+ Ajouter une condition</b> pour ajouter une condition de stratégie."
        },
        "DefaultPolicy": {
          "value": "Aucune condition de stratégie de sécurité par défaut n'est définie."
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "Combinaison",
            "operator": "Opérateur",
            "expression": "Phrase de condition"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "Ou",
            "and": "Et"
          }
        }
      }
    },
    "wizard": {
      "title": "Gestion des stratégies",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "Choisir un prédicat",
            "instructions": "Choisissez le prédicat pour la nouvelle condition dans la liste déroulante."
          },
          "body": {
            "labels": {
              "predicateList": "Liste de prédicats"
            },
            "help": {
              "predicateList": "La liste de prédicats est une liste de prédicats disponibles permettant d'élaborer une condition de stratégie de sécurité."
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "Prédicat de groupe",
            "instructions": "Commencez à saisir du texte dans le champ <i></i> pour ajouter des valeurs d'argument ou pour rechercher des valeurs d'argument existantes. Appuyez sur Entrée pour ajouter la valeur saisie à la liste. Pour modifier une valeur d'argument existante, cliquez dessus et modifiez-la à l'aide du champ d'entrée de la fenêtre instantanée."
          },
          "body": {
            "labels": {
              "conditionPhrase": "Phrase de condition",
              "negate": "Inverser la condition"
            },
            "help": {
              "negate": "Convertit la condition pour lui attribuer le sens opposé. Par exemple, \"est égal à\" devient \"n'est pas égal à\", \"dans\" devient \"pas dans\"."
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "Arborescence"
      },
      "page": {
        "value": "Page"
      },
      "tab": {
        "value": "Onglet"
      },
      "ariaLabel": {
        "value": "Historique des pages"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "La page n'existe plus",
        "detail1": "Vous avez été redirigé vers la page {0} car ",
        "detail2": "{0} a été supprimée par un autre utilisateur ou n'existe plus. "
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "Signets de page"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "Ajouter un signet pour la page en cours"
        },
        "show": {
          "label": "Afficher les signets de page..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "Un signet existe déjà pour cette page. "
      },
      "pagesBookmarkAdded": {
        "summary": "Un signet a été ajouté à la page en cours. "
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "Revenez à la page de destination de l'arborescence de fournisseur."
        },
        "reset": {
          "value": "Actualiser les valeurs de page"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "Action"
      },
      "apply": {
        "label": "Appliquer"
      },
      "reset": {
        "label": "Réinitialiser"
      },
      "ok": {
        "label": "OK"
      },
      "cancel": {
        "label": "Annuler"
      },
      "restart": {
        "label": "Redémarrage"
      },
      "yes": {
        "label": "Oui"
      },
      "no": {
        "label": "Non"
      },
      "choose": {
        "label": "Choisir"
      },
      "connect": {
        "label": "Connexion"
      },
      "add": {
        "label": "Ajouter/Envoyer"
      },
      "edit": {
        "label": "Modifier/Envoyer"
      },
      "import": {
        "label": "Importer"
      },
      "export": {
        "label": "Exporter"
      },
      "write": {
        "label": "Télécharger le fichier en local"
      },
      "savenow": {
        "label": "Enregistrer maintenant"
      },
      "next": {
        "label": "Suivant"
      },
      "previous": {
        "label": "Précédent"
      },
      "finish": {
        "label": "Terminer"
      },
      "done": {
        "label": "Terminé"
      },
      "close": {
        "label": "Fermer"
      },
      "clear": {
        "label": "Effacer"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "Réduire"
      },
      "expand": {
        "value": "Développer"
      },
      "choose": {
        "value": "Sélectionner un fichier"
      },
      "clear": {
        "value": "Effacer le fichier sélectionné"
      },
      "more": {
        "value": "Actions supplémentaires"
      },
      "download": {
        "value": "Parcourir"
      },
      "reset": {
        "value": "Réinitialiser"
      },
      "filter": {
        "value": "Filtre"
      },
      "submit": {
        "value": "Soumettre les modifications"
      },
      "write": {
        "value": "Télécharger le fichier en local"
      },
      "pick": {
        "value": "Sélectionner un répertoire"
      },
      "reload": {
        "value": "Recharger le fichier"
      },
      "delete": {
        "value": "Supprimer"
      },
      "remove": {
        "value": "Enlever"
      },
      "noData": {
        "value": "Aucune donnée"
      },
      "preloader": {
        "value": "Préchargeur"
      },
      "checkAll": {
        "value": "Sélectionner tout"
      },
      "checkNone": {
        "value": "Désélectionner tout"
      },
      "checkSome": {
        "value": "Effacer les sélections"
      },
      "close": {
        "value": "Fermer"
      },
      "recentPages": {
        "value": "Activer/Désactiver la visibilité de l'historique"
      },
      "pagesHistory": {
        "back": {
          "value": "Page précédente"
        },
        "next": {
          "value": "Page suivante"
        },
        "launch": {
          "value": "Afficher l'historique des pages"
        },
        "star": {
          "value": "Signets de page"
        }
      },
      "pageInfo": {
        "value": "Cliquer ici pour attacher et détacher un élément"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "Sélectionner un fichier..."
      },
      "chooseDir": {
        "value": "Choisir un répertoire..."
      }
    },
    "labels": {
      "info": {
        "value": "Informations"
      },
      "warn": {
        "value": "Avertissement"
      },
      "error": {
        "value": "Erreur"
      },
      "alerts": {
        "value": "Alertes"
      },
      "pagesHistory": {
        "value": "Voici les pages consultées depuis que le fournisseur en cours a été sélectionné. Cliquez sur n'importe quelle colonne de la ligne pour accéder à la page associée."
      },
      "pagesBookmark": {
        "value": "Voici les pages avec signet pour le type de fournisseur {0}. Cliquez sur n'importe quelle colonne de la ligne pour accéder à la page associée."
      }
    },
    "placeholders": {
      "search": {
        "value": "Rechercher"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "Contenu incorrect détecté"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "'{0}' contient des données JSON mais n'est pas une représentation JSON de {1}."
      },
      "dataCopiedToClipboard": {
        "detail": "Les données ont été copiées dans le presse-papiers."
      },
      "tableCopiedToClipboard": {
        "summary": "La table a été copiée dans le presse-papiers."
      },
      "emptyCellData": {
        "detail": "Aucune donnée n'a été copiée dans le presse-papiers car la cellule sélectionnée était vide."
      },
      "emptyRowData": {
        "detail": "Aucune donnée n'a été copiée dans le presse-papiers car la ligne sélectionnée était vide."
      },
      "browserPermissionDenied": {
        "summary": "Droit d'accès au navigateur refusé",
        "detail": "Vous devez activer l'écriture dans le presse-papiers à partir de JavaScript pour effectuer cette opération. Par ailleurs, l'API Clipboard est prise en charge uniquement pour les pages diffusées sur HTTPS."
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "Copier la cellule dans le presse-papiers"
        },
        "row": {
          "label": "Copier la ligne dans le presse-papiers"
        },
        "tableAsText": {
          "label": "Copier la table dans le presse-papiers (texte)"
        },
        "tableAsJSON": {
          "label": "Copier la table dans le presse-papiers (JSON)"
        },
        "tableAsYAML": {
          "label": "Copier la table dans le presse-papiers (YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "Tout réduire"
      },
      "useTreeMenusAsRootNodes": {
        "value": "Utiliser les menus arborescents en tant que noeuds racine"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "Les modifications ont été enregistrées dans le fichier '{0}'."
      },
      "changesNotSaved": {
        "summary": "Impossible d'enregistrer les modifications dans le fichier '{0}'."
      },
      "changesDownloaded": {
        "summary": "Les modifications ont été téléchargées vers le fichier '{0}'."
      },
      "changesNotDownloaded": {
        "summary": "Impossible de télécharger les modifications vers le fichier '{0}'."
      },
      "verifyPathEntered": {
        "detail": ". La définition du champ {0} sur False entraîne l'acceptation de la valeur saisie, sans valider son existence en tant que répertoire ou fichier local."
      }
    },
    "wdtOptionsDialog": {
      "title": "Modifier : {0}",
      "default": "Annuler la définition de la valeur",
      "instructions": "Indiquez un jeton à ajouter à la liste des éléments sélectionnables.",
      "enterValue": "Saisir une valeur",
      "selectValue": "Sélectionner une valeur",
      "selectSwitch": "Activer/désactiver la valeur",
      "enterUnresolvedReference": "Saisir une référence non résolue",
      "enterModelToken": "Saisir un jeton de modèle",
      "selectPropsVariable": "Sélectionner une variable de jeton de modèle",
      "createPropsVariable": "Créer une variable de jeton de modèle",
      "propName": "Nom de la variable (requis)",
      "propValue": "Valeur de la variable",
      "enterVariable": "Entrer une variable",
      "variableName": "Nom de la variable (requis)",
      "variableValue": "Valeur de la variable",
      "multiSelectUnset": "Sélectionner la valeur dans la liste des éléments disponibles"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "Modifications non enregistrées détectées"
      },
      "changesNeedDownloading": {
        "value": "Modifications non téléchargées"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "Toutes les modifications non enregistrées seront perdues. Continuer ?"
        },
        "areYouSure": {
          "value": "Voulez-vous {0} sans enregistrer les modifications ?"
        },
        "saveBeforeExiting": {
          "value": "Voulez-vous enregistrer les modifications avant de quitter le système ?"
        },
        "needDownloading": {
          "value": "Les modifications apportées à '{0}' n'ont pas été téléchargées vers le fichier.<br/><br/>Voulez-vous les télécharger avant de continuer ?"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "La nouvelle instance '{0}' n'a pas été ajoutée au modèle WDT.<br/><br/>Voulez-vous l'ajouter avant de continuer ?"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "Définir l'intervalle de rechargement automatique",
      "instructions": "Combien de secondes voulez-vous définir pour l'intervalle de rechargement automatique ?",
      "fields": {
        "interval": {
          "label": "Intervalle de rechargement automatique :"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "Message",
          "detail": "L'appel de back-end de console a généré une réponse '{0}' lors de la tentative d'exécution de l'action '{1}'"
        },
        "actionNotPerformed": {
          "detail": "Impossible d'effectuer l'action '{0}' sur au moins un des éléments sélectionnés"
        },
        "actionNotPerformedNoRow": {
          "detail": "Impossible d'exécuter l'action '{0}'"
        },
        "actionSucceeded": {
          "summary": "L'action '{0}' a été effectuée."
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "Impossible de déterminer la cause exacte. Consultez la console JavaScript pour obtenir des conseils."
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "Confirmation de l'action",
        "prompt": "L'action '{0}' ne peut pas être annulée.<br/><br/>Continuer ?"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "Disponible",
        "chosen": "Choisi"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "Nom de propriété",
        "value": "Valeur de propriété"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "Nom des propriétés",
        "valueHeader": "Valeur des propriétés",
        "addButtonTooltip": "Ajouter",
        "deleteButtonTooltip": "Supprimer"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "Afficher : {0}..."
          },
          "create": {
            "label": "Créer : {0}..."
          },
          "edit": {
            "label": "Modifier : {0}..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "Rétablir la valeur par défaut"
    },
    "placeholder": {
      "value": "valeur par défaut"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "'{0}' n'est pas disponible."
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "En cours d'exécution"
      },
      "shutdown": {
        "value": "Arrêt"
      },
      "serverStates": {
        "value": "Etats de serveur"
      },
      "systemStatus": {
        "value": "Statut du système"
      },
      "healthState": {
        "failed": {
          "value": "Echec"
        },
        "critical": {
          "value": "Critique"
        },
        "overloaded": {
          "value": "Surchargé"
        },
        "warning": {
          "value": "Avertissement"
        },
        "ok": {
          "value": "OK"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "Etat général des serveurs en cours d'exécution en date du"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "Nom"
        },
        "state": {
          "value": "Etat"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "Back-end actuellement inaccessible."
      },
      "connectionMessage": {
        "summary": "Message de connexion"
      },
      "connectFailed": {
        "detail": "Echec de la tentative : "
      },
      "badRequest": {
        "detail": "Impossible de traiter la demande ou le fichier soumis"
      },
      "invalidCredentials": {
        "detail": "Les informations d'identification du domaine WebLogic ne sont pas valides"
      },
      "invalidUrl": {
        "detail": "L'URL du domaine WebLogic n'est pas accessible"
      },
      "notInRole": {
        "detail": "Echec de la tentative : l'utilisateur n'est pas un administrateur, un responsable de déploiement, un opérateur ou un moniteur"
      },
      "notSupported": {
        "detail": "Le domaine WebLogic n'est pas pris en charge"
      },
      "unexpectedStatus": {
        "detail": "Résultat inattendu (statut : {0})"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "Echec de la demande",
          "detail": "Un appel de back-end de console a renvoyé une réponse d'échec."
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "Reportez-vous au terminal de la console distante ou à la console JavaScript pour connaître les motifs spécifiques."
      },
      "responseMessages": {
        "summary": "Messages de réponse"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "Confirmation"
      },
      "prompt": {
        "value": "L'arrêt de <b>{0}</b> entraînera la réinitialisation du fournisseur en cours. Voulez-vous continuer ?"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "Impossible d'accéder au gestionnaire de modifications."
      },
      "changesCommitted": {
        "summary": "Les modifications ont été validées."
      },
      "changesNotCommitted": {
        "summary": "Impossible de valider les modifications."
      },
      "changesDiscarded": {
        "summary": "Les modifications ont été annulées."
      },
      "changesNotDiscarded": {
        "summary": "Impossible d'annuler les modifications."
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "Réponse d'erreur inattendue"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "Problème de connexion",
        "details": "Problème d'envoi et de réception des données du fournisseur. Assurez-vous que ce dernier est accessible avant de continuer."
      },
      "pathNotFound": {
        "summary": "Chemin introuvable",
        "details": "'{0}' n'est pas un fichier ni un répertoire accessible sur le système de fichiers local."
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "Ligne de message"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "Effacer le message"
        },
        "suppress": {
          "info": {
            "label": "Supprimer les messages d'information"
          },
          "warning": {
            "label": "Supprimer les messages d'avertissement"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " Connexion impossible au serveur d'administration du domaine WebLogic."
      },
      "shutdownSequenceError": {
        "details": "Arrêtez les serveurs gérés, puis arrêtez le serveur d'administration."
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "Vous avez {0} alerte(s) d'erreur à priorité élevée"
        },
        "warning": {
          "value": "Vous avez {0} alerte(s) d'avertissement à priorité élevée"
        },
        "info": {
          "value": "Vous avez {0} alerte(s) d'information à priorité élevée"
        },
        "view": {
          "value": "Afficher les alertes"
        }
      }
    }
  }
});