define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "Cabecera de aplicación"
      }
    },
    "buttons": {
      "logout": {
        "label": "Desconectarse"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "Conmutar visibilidad del árbol de navegación"
        }
      },
      "theme": {
        "tooltip": "Cambiar tema"
      },
      "whatsNew": {
        "tooltip": "Novedades"
      },
      "howDoI": {
        "tooltip": "Abrir tareas \"¿Cómo...\""
      },
      "tips": {
        "tooltip": "Conmutar visibilidad de consejos de usuario"
      },
      "help": {
        "tooltip": "Abrir documentación interna de WebLogic Remote Console"
      },
      "profile": {
        "tooltip": "Perfil"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "Abrir centro de mensajes"
      },
      "theme": {
        "light": {
          "value": "Claro"
        },
        "dark": {
          "value": "Oscuro"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "Hacer clic para restablecer WebLogic Remote Console"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "Copyright (c) 2020, 2025, Oracle y/o sus filiales.<br/> Oracle (r), Java, MySQL y NetSuite son marcas comerciales registradas de Oracle y/o sus filiales. Todos los demás nombres pueden ser marcas comerciales de sus respectivos propietarios.<br/>",
      "builtWith": "Creado con Oracle JET"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "No seguro"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "Conexión de servidor de administración no segura"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "Mostrar lista de perfiles"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "Gestionar Perfiles"
          },
          "editor": {
            "tooltip": "Editor de perfiles",
            "toolbar": {
              "save": {
                "tooltip": "Guardar perfil"
              },
              "activate": {
                "tooltip": "Perfil activo"
              },
              "add": {
                "tooltip": "Agregar Perfil"
              },
              "remove": {
                "tooltip": "Suprimir Perfil"
              }
            }
          }
        },
        "image": {
          "tooltip": "Perfil",
          "capture": {
            "tooltip": "Agregar o cambiar imagen"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "General"
        },
        "settings": {
          "value": "Configuración"
        },
        "preferences": {
          "value": "Preferencias"
        },
        "properties": {
          "value": "Propiedades"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "Cambiar imagen"
      },
      "clearImage": {
        "value": "Borrar imagen"
      },
      "profile": {
        "default": {
          "value": "Perfil por Defecto"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "Mostrar editor de perfiles"
            },
            "hide": {
              "value": "Ocultar editor de perfiles"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "Abrir gestor de perfiles"
          },
          "signout": {
            "value": "Cerrar sesión"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "Identificador de Perfil"
          },
          "organization": {
            "value": "Organización"
          },
          "name": {
            "value": "Nombre"
          },
          "email": {
            "value": "Correo electrónico"
          },
          "role": {
            "default": {
              "value": "Usar como perfil por defecto"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "¿Desea almacenar las credenciales cifradas para los proyectos?"
            },
            "disableHNV": {
              "value": "¿Desactivar la verificación del nombre de host?"
            },
            "proxyAddress": {
              "value": "Dirección de Proxy"
            },
            "trustStoreType": {
              "value": "Tipo de Almacenamiento de Confianza"
            },
            "trustStorePath": {
              "value": "Ruta de Acceso del Almacén de Confianza"
            },
            "trustStoreKey": {
              "value": "Clave de almacén de confianza"
            },
            "connectionTimeout": {
              "value": "Timeout de conexión con el servidor de administración"
            },
            "readTimeout": {
              "value": "Timeout de lectura del servidor de administración"
            }
          },
          "preferences": {
            "theme": {
              "value": "Tema"
            },
            "startupTaskChooserType": {
              "value": "Tipo de selector de tarea de inicio"
            },
            "useTreeMenusAsRootNodes": {
              "value": "¿Desea utilizar menús de árbol como nivel raíz de los navegadores de árbol?"
            },
            "onQuit": {
              "value": "¿Desea que los cambios sin guardar impidan que se salga de la aplicación?"
            },
            "onDelete": {
              "value": "¿Desea confirmar todas las supresiones?"
            },
            "onActionNotAllowed": {
              "value": "¿Desea usar el elemento emergente \"Acción no permitida\" para evitar la pérdida de datos?"
            },
            "onUnsavedChangesDetected": {
              "value": "¿Desea usar el elemento emergente \"Se han detectado cambios sin guardar\" para evitar la pérdida de datos?"
            },
            "onChangesNotDownloaded": {
              "value": "¿Desea usar el elemento emergente \"Los cambios no se han descargado\" para evitar la pérdida de datos?"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Propiedades del sistema Java"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "Claro"
            },
            "dark": {
              "value": "Oscuro"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "Usar cuadro de diálogo"
            },
            "useCards": {
              "value": "Usar tarjetas"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "ROOT de Windows"
            },
            "keyChainStore": {
              "value": "Almacén de cadena de claves"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "El perfil \"{0}\" se ha guardado correctamente."
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "Acciones de proveedor "
        }
      },
      "info": {
        "tooltip": "Obtener información sobre este proveedor"
      },
      "edit": {
        "tooltip": "Gestionar configuración de este proveedor"
      },
      "deactivate": {
        "tooltip": "Desactivar este proveedor"
      },
      "delete": {
        "tooltip": "Eliminar este proveedor"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "Proyecto sin nombre"
        },
        "name": {
          "value": "Nombre de proveedor de conexión"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "Anulación de Proxy"
        },
        "username": {
          "value": "Nombre de usuario"
        },
        "password": {
          "value": "Contraseña"
        }
      },
      "models": {
        "name": {
          "value": "Nombre de proveedor de modelo WDT"
        },
        "file": {
          "value": "Nombre de archivo de modelo WDT"
        },
        "props": {
          "value": "Variables de WDT"
        }
      },
      "composite": {
        "name": {
          "value": "Nombre de proveedor de modelo de compuesto WDT"
        },
        "providers": {
          "value": "Modelos WDT"
        }
      },
      "proplist": {
        "name": {
          "value": "Nombre de proveedor de lista de propiedades"
        },
        "file": {
          "value": "Nombre de archivo de lista de propiedades"
        }
      },
      "project": {
        "name": {
          "value": "Nombre de proyecto"
        },
        "file": {
          "value": "Nombre de archivo de proyecto"
        }
      },
      "provider": {
        "adminserver": {
          "value": "Conexión de servidor de administración"
        },
        "model": {
          "value": "Agregar modelo WDT"
        }
      },
      "dropdown": {
        "none": {
          "value": "Ninguno"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "Nombre de proyecto:"
          }
        },
        "provider": {
          "id": {
            "label": "Identificador de Proveedor:"
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "Versión de extensión de consola:"
          },
          "name": {
            "label": "Nombre de Dominio:"
          },
          "url": {
            "label": "URL de dominio:"
          },
          "proxyOverride": {
            "label": "Anulación de Proxy:"
          },
          "version": {
            "label": "Versión de dominio:"
          },
          "username": {
            "label": "Nombre de usuario:"
          },
          "sso": {
            "label": "Autenticación web:"
          },
          "roles": {
            "label": "Roles:"
          },
          "connectTimeout": {
            "label": "Timeout de Conexión:"
          },
          "readTimeout": {
            "label": "Timeout de Lectura:"
          },
          "insecure": {
            "label": "No seguro:"
          },
          "anyAttempt": {
            "label": "Intentos de conexión:"
          },
          "lastAttempt": {
            "label": "Último intento correcto:"
          }
        },
        "model": {
          "file": {
            "label": "Archivo:"
          },
          "props": {
            "label": "Variables:"
          }
        },
        "composite": {
          "models": {
            "label": "Modelos:"
          }
        },
        "proplist": {
          "file": {
            "label": "Nombre de archivo:"
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "Agregar proveedor de conexión de servidor de administración"
        }
      },
      "models": {
        "add": {
          "value": "Agregar proveedor de archivo de modelo WDT"
        },
        "new": {
          "value": "Crear proveedor para el nuevo archivo de modelo WDT"
        }
      },
      "composite": {
        "add": {
          "value": "Agregar proveedor de archivo de modelo de compuesto WDT"
        }
      },
      "proplist": {
        "add": {
          "value": "Agregar proveedor de lista de propiedades"
        },
        "new": {
          "value": "Crear proveedor para nueva lista de propiedades"
        }
      },
      "providers": {
        "sort": {
          "value": "Ordenar por tipo de proveedor"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "URL de dominio:"
              },
              "version": {
                "label": "Versión de dominio:"
              },
              "username": {
                "label": "Nombre de usuario:"
              }
            }
          },
          "model": {
            "file": {
              "label": "Archivo:"
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "Exportar proveedores como proyecto..."
        },
        "import": {
          "value": "Importar Proyecto"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "Introduzca un nuevo nombre y la configuración de conectividad para el proveedor de conexión."
        },
        "edit": {
          "value": "Modifique la configuración de conectividad para el proveedor de conexión."
        },
        "deactivate": {
          "value": "Desactivar el proveedor de conexión y detener el sondeo del estado del dominio"
        }
      },
      "models": {
        "add": {
          "value": "Introduzca la configuración para el proveedor de archivo de modelo existente. Haga clic en el icono de carga para examinar el archivo de modelo."
        },
        "new": {
          "value": "Introduzca el nombre del proveedor y el nombre de archivo para el nuevo archivo de modelo WDT. A continuación, haga clic en el icono para elegir en qué directorio guardar el archivo."
        },
        "edit": {
          "value": "Modifique la configuración para el proveedor de archivo de modelo. Haga clic en el icono para examinar el archivo de modelo."
        }
      },
      "composite": {
        "add": {
          "value": "Introduzca un nuevo nombre y seleccione una lista de modelos ordenada para el proveedor de modelo de compuesto."
        },
        "edit": {
          "value": "Modifique la configuración para el proveedor de modelo de compuesto. Utilice una lista de modelos ordenada."
        }
      },
      "proplist": {
        "add": {
          "value": "Introduzca la configuración para el proveedor de lista de propiedades existente. Haga clic en el icono de carga para examinar un archivo de propiedades."
        },
        "new": {
          "value": "Introduzca el nombre del proveedor y el nombre de archivo para una nueva lista de propiedades. A continuación, haga clic en el icono para elegir en qué directorio guardar el archivo."
        },
        "edit": {
          "value": "Modifique la configuración para el proveedor de listas de propiedades. Haga clic en el icono para examinar un archivo de propiedades."
        }
      },
      "project": {
        "export": {
          "value": "Introduzca la configuración para un nuevo proyecto."
        },
        "import": {
          "value": "Haga clic en el icono de descarga para examinar un proyecto."
        }
      },
      "task": {
        "startup": {
          "value": "¿Qué tarea de inicio desea realizar?"
        }
      },
      "project-busy": {
        "value": "Guarde o abandone los cambios no guardados antes de realizar cambios en cualquier parte del proyecto"
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "Crear proveedor para la conexión de servidor de administración"
        },
        "models": {
          "value": "Crear proveedor para el archivo de modelo WDT existente"
        },
        "composite": {
          "value": "Crear proveedor para nuevo modelo de compuesto WDT"
        },
        "proplist": {
          "value": "Crear proveedor para la lista de propiedades existente"
        }
      },
      "new": {
        "models": {
          "value": "Crear proveedor para el nuevo archivo de modelo WDT"
        },
        "proplist": {
          "value": "Crear proveedor para nueva lista de propiedades"
        }
      },
      "edit": {
        "connections": {
          "value": "Editar proveedor de conexión de servidor de administración"
        },
        "models": {
          "value": "Editar proveedor de archivo de modelo WDT"
        },
        "composite": {
          "value": "Editar proveedor de archivo de modelo de compuesto WDT"
        },
        "proplist": {
          "value": "Editar proveedor de lista de propiedades"
        }
      },
      "export": {
        "project": {
          "value": "Exportar proveedores como proyecto"
        }
      },
      "import": {
        "project": {
          "value": "Importar Proyecto"
        }
      },
      "startup": {
        "task": {
          "value": "Tarea de inicio"
        }
      },
      "project-busy": {
        "value": "Proyecto ocupado"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "Exportación incorrecta",
          "detail": "No se han podido exportar los proveedores como proyecto '{0}'."
        }
      },
      "import": {
        "failed": {
          "summary": "No se ha guardado correctamente",
          "detail": "No se ha podido importar el archivo de proyecto '{0}'"
        }
      },
      "stage": {
        "failed": {
          "summary": "No se ha creado correctamente",
          "detail": "No se ha podido crear el elemento de proveedor '{0}'."
        }
      },
      "use": {
        "failed": {
          "summary": "Conexión incorrecta",
          "detail": "No se ha podido utilizar el elemento de proveedor '{0}'."
        }
      },
      "upload": {
        "failed": {
          "detail": "No se puede cargar el archivo de modelo WDT: {0}"
        },
        "props": {
          "failed": {
            "detail": "No se pueden cargar las variables de WDT: {0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "El proveedor con nombre '{0}' ya está en este proyecto."
        },
        "modelsNotFound": {
          "detail": "No se han encontrado los modelos WDT configurados '{0}'"
        },
        "propListNotFound": {
          "detail": "No se encuentran las variables de '{0}'"
        },
        "selectModels": {
          "detail": "Para seleccionar el compuesto WDT, seleccione primero todos los modelos WDT que utiliza el compuesto WDT."
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "La URL debe especificar el protocolo HTTPS o usar localhost"
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>Edite la ruta en el campo de nombre de archivo y haga clic en el botón Aceptar. Como alternativa, haga clic en el icono de carga y seleccione otro archivo.</p>"
        },
        "fixModelFile": {
          "detail": "<p>Corrija los problemas mencionados a continuación y haga clic en el botón Aceptar. Como alternativa, seleccione otro archivo.</p>"
        },
        "yamlException": {
          "detail": "{0} en la línea {1}, columna {2}"
        },
        "wktModelContent": {
          "summary": "Problemas de contenido de modelos",
          "detail": "Utilice el editor de modelos en el separador <i>Vista de código</i> para solucionar problemas."
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "No definido"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "Usar plantilla ligera"
      },
      "usesso": {
        "label": "Usar autenticación web"
      },
      "insecure": {
        "label": "Continuar con la conexión no segura"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "Editar Árbol"
      },
      "view": {
        "tooltip": "Configurar árbol de vista"
      },
      "monitoring": {
        "tooltip": "Supervisar árbol"
      },
      "security": {
        "tooltip": "Árbol de datos de seguridad"
      },
      "modeling": {
        "tooltip": "Modelo WDT"
      },
      "composite": {
        "tooltip": "Modelo de compuesto WDT"
      },
      "properties": {
        "tooltip": "Editor de lista de propiedad"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "Menú de árboles de proveedores"
      },
      "navtree": {
        "value": "Navegador de árbol de proveedor"
      },
      "panelResizer": {
        "value": "Cambiador de tamaño del navegador de árbol de proveedor. Utilice las teclas de flecha izquierda y derecha para cambiar el tamaño del navegador"
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "Inicio. Volver a la página que contiene tarjetas para los árboles del proveedor"
        }
      },
      "region": {
        "title": {
          "value": "Cabecera de área de contenido"
        }
      },
      "popup": {
        "provider": {
          "value": "Acciones de proveedor"
        }
      }
    },
    "title": {
      "home": "Inicio",
      "configuration": "Editar Árbol",
      "view": "Configurar árbol de vista",
      "monitoring": "Supervisar árbol",
      "security": "Árbol de datos de seguridad",
      "modeling": "Modelo WDT",
      "composite": "Modelo de compuesto WDT",
      "properties": "Lista de propiedades"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "Inicio"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "Hacer clic para ver acciones del carro de compra"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "Ver Cambios..."
        },
        "discard": {
          "label": "Desechar cambios"
        },
        "commit": {
          "label": "Confirmar Cambios"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "Carro de compra"
        },
        "ataglance": {
          "label": "Visión rápida"
        },
        "projectmanagement": {
          "label": "Proveedores"
        },
        "tips": {
          "label": "Consejos de usuario"
        },
        "dashboards": {
          "label": "Paneles de control"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "Consejos de filtro",
        "checkboxes": {
          "hideall": "Ocultar todos los consejos",
          "productivity": "Mostrar consejos de productividad",
          "personalization": "Mostrar consejos de personalización",
          "whereis": "Mostrar consejos de ubicación",
          "accessibility": "Mostrar consejos de accesibilidad",
          "connectivity": "Mostrar consejos de conectividad",
          "security": "Mostrar consejos de seguridad",
          "other": "Mostrar otros consejos"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "Ocultar Todo"
        },
        "productivity": {
          "value": "Productividad"
        },
        "personalization": {
          "value": "Personalización"
        },
        "whereis": {
          "value": "Ubicación"
        },
        "accessibility": {
          "value": "Accesibilidad"
        },
        "connectivity": {
          "value": "Conectividad"
        },
        "security": {
          "value": "Seguridad"
        },
        "other": {
          "value": "Otros"
        }
      },
      "cards": {
        "tip0": {
          "title": "Busque entre todos los beans gestionados de su dominio.",
          "descriptionHTML": "<p>Introduzca un término de búsqueda en el campo de búsqueda de la parte superior de la consola para cribar las coincidencias de la perspectiva actual. También puede volver a visitar las consultas anteriores en el nodo <b>Búsquedas recientes</b>.</p>"
        },
        "tip1": {
          "title": "Filtre rápidamente y encuentre datos importantes para usted.",
          "descriptionHTML": "<p>Los paneles de control permiten definir criterios personalizados, compararlos con su dominio y generar informes completos y precisos basados en el dominio.</p><p>Para empezar, abra cualquier nodo en el <b>árbol de supervisión</b> y haga clic en <b>Nuevo panel del control</b>. O abra el nodo de nivel superior <b>Paneles de control</b> para consultar los paneles de control incorporados.</p>"
        },
        "tip2": {
          "title": "Acotar contenidos de tabla",
          "descriptionHTML": "<p>Simplifique las tablas ocultando las columnas irrelevantes para que pueda centrarse en los datos que son realmente importantes para usted.</p><p>Haga clic en <b>Personalizar tabla</b> sobre cualquier tabla y seleccione o anule la selección de columnas como desee.</p>"
        },
        "tip3": {
          "title": "Uso del teclado con tablas y acciones",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "Ubicación del enlace \"Personalizar esta tabla\"",
          "descriptionHTML": "<p>El enlace \"Personalizar esta tabla\" ahora se ha convertido en el botón <i>Personalizar tabla</i>.</p>"
        },
        "tip5": {
          "title": "Revisar cambios pendientes",
          "descriptionHTML": "<p>Abra el carrito de la compra para ver la lista de cambios que se han guardado en el dominio, pero que no se han aprobado aún.</p><p>Si no puede ver <b>Ver cambios</b> en el carrito de la compra, pruebe a <a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>instalar la extensión de WebLogic Remote Console</a>."
        },
        "tip6": {
          "title": "¿Necesita Ayuda?",
          "descriptionHTML": "<ul><li>Mueva el cursor sobre <b>?</b>, junto a un campo para ver las pistas.</li><li>haga clic en <b>?</b> de la página para obtener ayuda acerca de todos los atributos visibles.</li><li>En el menú <b>Ayuda</b>, haga clic en<b>Visitar el proyecto de GitHub de WebLogic Remote Console</b>.</li><li>Únase a nuestro canal de Slack: <a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>.</li><li>Consulte nuestra documentación en <a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>.</li></ul>"
        },
        "tip7": {
          "title": "Otro consejo n.º 1",
          "descriptionHTML": "<p>Breve descripción de \"Otro consejo n.º 1\". Un carácter de nueva línea no es un elemento HTML, por lo que no debería utilizarlos en esta descripción.</p>"
        },
        "tip8": {
          "title": "¿Problemas para conectar con el servidor?",
          "descriptionHTML": "<p>En <b>Árbol de supervisión</b> > <b>Entorno</b> > <b>Servidores</b>, seleccione el servidor que no responde y abra la pestaña de <b>Solución de problemas</b> para probar y diagnosticar el problema.</p><p>Si no puede conectar con el dominio de ninguna forma, consulte la documentación de ayuda sobre <a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>la imposibilidad de conectar con el servidor de administración</a> de WebLogic Remote Console para solucionar problemas.</p>"
        },
        "tip9": {
          "title": "Consejo de conectividad n.º 2",
          "descriptionHTML": "<p>Breve descripción de \"Consejo de conectividad n.º 2\". Un carácter de nueva línea no es un elemento HTML, por lo que no debería utilizarlos en esta descripción.</p>"
        },
        "tip10": {
          "title": "Consejo de seguridad n.º 1",
          "descriptionHTML": "<p>Breve descripción de \"Consejo de seguridad n.º 1\". Un carácter de nueva línea no es un elemento HTML, por lo que no debería utilizarlos en esta descripción.</p>"
        },
        "tip11": {
          "title": "Acelere su flujo de trabajo",
          "descriptionHTML": "<p>Utilice métodos abreviados de teclado para acceder directamente a componentes de UI específicos.</p><p>5 principales:</p><li><code><b>Alt+P</b></code>: abre el componente de <b>Proveedores</b>.</li><li><code><b>Alt+C</b></code>: traslada el enfoque al <b>carrito de la compra</b>.</li><li><code><b>Alt+T</b></code>: traslada el enfoque a la primera cabecera de columna de la tabla.</li><li><code><b>Alt+|</b></code>: traslada el enfoque al cambiador de ancho del árbol de navegación. Utilice las teclas de flechas para cambiar el ancho del árbol.</li><li><code><b>Alt+;</b></code>: traslada el enfoque a la primera etiqueta de ruta en la que se pueda hacer clic.</li></ul><p>Para consultar la lista de métodos abreviados de teclado, consulte la documentación.</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "Rutas de navegación"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "Historial"
      },
      "separator": {
        "tooltip": "Separador"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "Borrar entradas del historial",
          "label": "Borrar entradas del historial"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "ejecutándose a las {0}"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "Conexión perdida",
        "detail": "Se ha perdido la conexión. Refresque la página."
      },
      "cannotConnect": {
        "summary": "Fallo al intentar la conexión",
        "detail": "No se puede conectar al dominio de WebLogic {0}, compruebe que WebLogic se está ejecutando."
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "Árboles"
        },
        "startup-tasks": {
          "label": "Tareas de inicio"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Página de llegada"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "Enlaces a páginas de llegada"
        }
      },
      "screenreader": {
        "value1": "Está en el elemento {0}. Pulse Intro para seleccionar",
        "value2": "Está en el elemento {0}. Al pulsar Intro se ampliará y reducirá. Después de la ampliación, utilice la flecha hacia abajo para acceder a los enlaces relacionados.",
        "value3": "{0}. Pulse la tecla de tabulador o Mayús+tabulador para desplazarse entre enlaces relacionados y la tecla Esc para volver al último elemento de nivel superior que haya visitado."
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Árboles de proveedores"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "Editar Árbol",
        "description": "<p>Mantener la configuración del dominio de WebLogic con el que está trabajando actualmente.</p>"
      },
      "view": {
        "label": "Configurar árbol de vista",
        "description": "<p>Examinar la configuración de solo lectura del dominio de WebLogic con el que está trabajando actualmente.</p>"
      },
      "monitoring": {
        "label": "Supervisar árbol",
        "description": "<p>Ver la información del MBean de tiempo de ejecución para los recursos seleccionados del dominio de WebLogic con el que está trabajando actualmente.</p>"
      },
      "security": {
        "label": "Árbol de datos de seguridad",
        "description": "<p>Gestionar información relacionada con la seguridad (por ejemplo, usuarios, grupos, roles, políticas, credenciales, etc.) en el dominio de WebLogic en el que está trabajando actualmente.</p>"
      },
      "modeling": {
        "label": "Árbol de modelo WDT",
        "description": "<p>Mantener archivos de modelo asociados a la herramienta WebLogic Deploy Tooling.</p>"
      },
      "composite": {
        "label": "Árbol de modelo de compuesto WDT",
        "description": "<p>Ver un juego combinado de los archivos de modelo WebLogic Deploy Tooling con los que está trabajando actualmente.</p>"
      },
      "properties": {
        "label": "Editor de lista de propiedad",
        "description": "<p>Ver o modificar un conjunto de propiedades de un archivo de lista de propiedad.</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Tareas de inicio"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "Agregar proveedor de conexión de servidor de administración",
        "description": "Con esta tarea se crea un recurso de proyecto que le permite conectarse a un servidor de administración"
      },
      "addWdtModel": {
        "label": "Agregar proveedor de archivo de modelo WDT",
        "description": "Con esta tarea se crea un recurso de proyecto que le permite gestionar un archivo de modelo WDT presente en su sistema de archivos local"
      },
      "addWdtComposite": {
        "label": "Agregar proveedor de archivo de modelo de compuesto WDT",
        "description": "Con esta tarea se crea un recurso de proyecto que le permite gestionar fragmentos de un archivo de modelo WDT presente en su sistema de archivos local"
      },
      "addPropertyList": {
        "label": "Agregar proveedor de lista de propiedades",
        "description": "Con esta tarea se crea un recurso de proyecto que le permite gestionar un archivo .properties almacenado en su sistema de archivos local"
      },
      "createWdtModel": {
        "label": "Crear proveedor para el nuevo archivo de modelo WDT",
        "description": "Con esta tarea se crea un recurso de proyecto que es un archivo de modelo WDT nuevo almacenado en su sistema de archivos local"
      },
      "createPropertyList": {
        "label": "Crear proveedor para nueva lista de propiedades",
        "description": "Con esta tarea se crea un recurso de proyecto que es un archivo .properties nuevo almacenado en su sistema de archivos local"
      },
      "importProject": {
        "label": "Importar Proyecto",
        "description": "Con esta tarea se crea un proyecto previamente exportado que contiene proveedores que podrá usar o modificar de forma inmediata"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "Desechar cambios"
      },
      "commit": {
        "tooltip": "Confirmar Cambios"
      }
    },
    "sections": {
      "changeManager": {
        "label": "Gestor de cambios"
      },
      "additions": {
        "label": "Adiciones"
      },
      "modifications": {
        "label": "Modificaciones"
      },
      "removals": {
        "label": "Eliminaciones"
      },
      "restart": {
        "label": "Reiniciar"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "Nuevo"
      },
      "clone": {
        "label": "Clonar"
      },
      "delete": {
        "label": "Suprimir"
      },
      "customize": {
        "label": "Personalizar Tabla"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "Página de llegada"
      },
      "history": {
        "tooltip": "Conmutar visibilidad del historial"
      },
      "instructions": {
        "tooltip": "Conmutar visibilidad de las instrucciones"
      },
      "help": {
        "tooltip": "Conmutar visibilidad de la página de ayuda"
      },
      "sync": {
        "tooltip": "Recargar",
        "tooltipOn": "Parar recarga automática"
      },
      "syncInterval": {
        "tooltip": "Definir intervalo de recarga automática"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "Seleccione los elementos en los que desea realizar la operación '{0}'."
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "Mensaje",
          "detail": "No se puede realizar la acción '{0}' mientras se está ejecutando la recarga automática. Primero, haga clic en el icono '{1}' para pararla."
        }
      }
    },
    "prompts": {
      "download": {
        "value": "Ubicaciones de archivos log descargados:"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "Mostrar columnas ocultas"
      }
    },
    "labels": {
      "totalRows": {
        "value": "Total de Filas: {0}"
      },
      "reloadHidden": {
        "value": "Recargue la tabla para ver los valores {0} actuales"
      },
      "noData": {
        "value": "No se ha encontrado ningún dato."
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "Columnas disponibles"
        },
        "list": {
          "value": "Lista de columnas disponibles"
        },
        "listItem": {
          "value": "Elemento de lista de columnas disponibles"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "Columnas seleccionadas"
        },
        "list": {
          "value": "Lista de columnas seleccionadas"
        },
        "listItem": {
          "value": "Elemento de lista de columnas seleccionadas"
        }
      },
      "button": {
        "addToRight": {
          "value": "Mover los elementos marcados en la lista de columnas disponibles a la lista de columnas seleccionadas"
        },
        "addAllRight": {
          "value": "Mover todos los elementos en la lista de columnas disponibles a la lista de columnas seleccionadas"
        },
        "removeRight": {
          "value": "Mover los elementos marcados en la lista de columnas seleccionadas a la lista de columnas disponibles"
        },
        "removeAll": {
          "value": "Mover todos los elementos en la lista de columnas seleccionadas a la lista de columnas disponibles"
        },
        "reset": {
          "value": "Restaurar las columnas en la lista de columnas seleccionadas a las que estaban presentes cuando se abrió la herramienta de personalización de tablas"
        },
        "apply": {
          "value": "Aplicar personalizaciones de columnas a la tabla"
        },
        "cancel": {
          "value": "Cancelar todas las personalizaciones de columnas"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "Guardar"
      },
      "new": {
        "label": "Crear"
      },
      "delete": {
        "label": "Eliminar"
      },
      "back": {
        "label": "Atrás"
      },
      "next": {
        "label": "Siguiente"
      },
      "finish": {
        "label": "Crear"
      },
      "customize": {
        "label": "Personalizar Tabla"
      },
      "dashboard": {
        "label": "Nuevo Panel de Control"
      }
    },
    "icons": {
      "save": {
        "tooltip": "Guardar"
      },
      "create": {
        "tooltip": "Crear"
      },
      "landing": {
        "tooltip": "Página de llegada"
      },
      "history": {
        "tooltip": "Conmutar visibilidad del historial"
      },
      "instructions": {
        "tooltip": "Conmutar visibilidad de las instrucciones"
      },
      "help": {
        "tooltip": "Conmutar visibilidad de la página de ayuda"
      },
      "sync": {
        "tooltip": "Recargar",
        "tooltipOn": "Parar recarga automática"
      },
      "syncInterval": {
        "tooltip": "Definir intervalo de recarga automática"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "Mostar Campos Avanzados"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "Haga clic en el icono {0} para conmutar entre la ayuda resumida y la ayuda detallada."
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "Cambios agregados al carro",
        "generic": "Cambios guardados",
        "notSaved": "No se ha guardado nada porque no se ha detectado ningún cambio."
      },
      "action": {
        "notAllowed": {
          "summary": "Acción no permitida",
          "detail": "No se puede realizar la acción solicitada durante una operación de creación. Haga clic en el botón Cancelar para cancelar la operación de creación."
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "Es necesario reiniciar el servidor o la aplicación"
      },
      "wdtIcon": {
        "tooltip": "Configuración de WDT"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "Tabla de ayuda",
        "columns": {
          "header": {
            "name": "Nombre",
            "description": "Descripción"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>Temas relacionados:</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "Atributos"
      },
      "actions": {
        "label": "Acciones"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "Campos necesarios incompletos",
        "detail": "El campo {0} es necesario, pero no se ha proporcionado ningún valor o se ha proporcionado un valor no válido."
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "Agregar condición"
        },
        "combine": {
          "label": "Combinar"
        },
        "uncombine": {
          "label": "Anular combinación"
        },
        "moveup": {
          "label": "Mover hacia arriba"
        },
        "movedown": {
          "label": "Mover hacia abajo"
        },
        "remove": {
          "label": "Eliminar"
        },
        "negate": {
          "label": "Negar"
        },
        "reset": {
          "label": "Restablecer"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "Agregar nueva primera condición..."
          },
          "above": {
            "label": "Agregar condición por encima de la fila seleccionada..."
          },
          "below": {
            "label": "Agregar condición por debajo de la fila seleccionada..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "Agregar condición por encima de la marcada..."
          },
          "below": {
            "label": "Agregar condición por debajo de la marcada..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "Uno o varios campos necesarios no contienen datos."
      },
      "argumentValueHasWrongFormat": {
        "summary": "El campo '{0}' contiene datos con formato incorrecto."
      },
      "conditionHasNoArgValues": {
        "summary": "La condición seleccionada no tiene ningún valor de argumento para editar."
      },
      "conditionAlreadyExists": {
        "summary": "Esta política de seguridad ya tiene una condición creada con el predicado seleccionado o con un predicado con los mismos valores de argumento."
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>Para especificar la ubicación de la nueva condición, ponga una marca junto a la condición relativa y haga clic en el botón <b>+Agregar condición</b>.</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "Rango: De -31 a 31"
      },
      "dateTime": {
        "value": "Formato: aaaa-MM-dd [HH:mm:ss [AM|PM]] (por ejemplo: 2022-02-14 09:00:00 AM)"
      },
      "time": {
        "value": "Formato: HH:mm:ss (por ejemplo: 14:22:47)"
      },
      "gmtOffset": {
        "value": "Formato: GMT+|-h:mm (por ejemplo: GMT-5:00)"
      },
      "weekDay": {
        "value": "Por ejemplo: lunes, martes, miércoles..."
      },
      "or": {
        "value": "o"
      },
      "not": {
        "value": "no"
      },
      "combination": {
        "value": "Combinación"
      },
      "nodata": {
        "Policy": {
          "value": "Utilice el botón <b>+ Agregar condición</b> para agregar una condición de política."
        },
        "DefaultPolicy": {
          "value": "No se ha definido ninguna condición de política de seguridad."
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "Combinación",
            "operator": "Operador",
            "expression": "Expresión de condición"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "OR",
            "and": "AND"
          }
        }
      }
    },
    "wizard": {
      "title": "Gestión de Políticas",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "Seleccionar Predicado",
            "instructions": "Seleccione el predicado de la nueva condición de la lista desplegable"
          },
          "body": {
            "labels": {
              "predicateList": "Lista de Predicados"
            },
            "help": {
              "predicateList": "La lista de predicados es una lista de predicados disponibles que se pueden utilizar para formar una condición de política de seguridad."
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "Predicado de Grupo",
            "instructions": "Empiece a escribir en el campo <i></i> para agregar valores de argumento o buscar valores existentes. Pulse Intro para agregar el valor introducido a la lista. Para editar el valor de argumento existente, haga clic en él y modifíquelo utilizando el campo de entrada emergente."
          },
          "body": {
            "labels": {
              "conditionPhrase": "Expresión de condición",
              "negate": "Negar condición"
            },
            "help": {
              "negate": "Convierte la condición para que tenga el significado opuesto (por ejemplo, \"igual a\" se convierte en \"distinto de\", \"en\" se convierte en \"no en\")."
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "Árbol"
      },
      "page": {
        "value": "Página"
      },
      "tab": {
        "value": "Separador"
      },
      "ariaLabel": {
        "value": "Historial de páginas"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "La página ya no existe",
        "detail1": "Se le ha redirigido a la página {0} porque ",
        "detail2": "otro usuario ha suprimido {0} o ya no existe. "
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "Marcador de página"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "Agregar marcador a la página actual"
        },
        "show": {
          "label": "Mostrar marcadores de página..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "Ya hay un marcador para esta página. "
      },
      "pagesBookmarkAdded": {
        "summary": "La página actual se ha marcado correctamente. "
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "Volver a la página de llegada del árbol de proveedor"
        },
        "reset": {
          "value": "Refrescar valores de página"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "Acción"
      },
      "apply": {
        "label": "Aplicar"
      },
      "reset": {
        "label": "Restablecer"
      },
      "ok": {
        "label": "Aceptar"
      },
      "cancel": {
        "label": "Cancelar"
      },
      "restart": {
        "label": "Reiniciar"
      },
      "yes": {
        "label": "Sí"
      },
      "no": {
        "label": "No"
      },
      "choose": {
        "label": "Seleccionar"
      },
      "connect": {
        "label": "Conectar"
      },
      "add": {
        "label": "Agregar/enviar"
      },
      "edit": {
        "label": "Editar/enviar"
      },
      "import": {
        "label": "Importar"
      },
      "export": {
        "label": "Exportar"
      },
      "write": {
        "label": "Descargar archivo"
      },
      "savenow": {
        "label": "Guardar Ahora"
      },
      "next": {
        "label": "Siguiente"
      },
      "previous": {
        "label": "Anterior"
      },
      "finish": {
        "label": "Finalizar"
      },
      "done": {
        "label": "Listo"
      },
      "close": {
        "label": "Cerrar"
      },
      "clear": {
        "label": "Borrar"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "Reducir"
      },
      "expand": {
        "value": "Ampliar"
      },
      "choose": {
        "value": "Seleccionar Archivo"
      },
      "clear": {
        "value": "Borrar archivo seleccionado"
      },
      "more": {
        "value": "Más acciones"
      },
      "download": {
        "value": "Examinar"
      },
      "reset": {
        "value": "Restablecer"
      },
      "filter": {
        "value": "Filtro"
      },
      "submit": {
        "value": "Enviar Cambios"
      },
      "write": {
        "value": "Descargar archivo"
      },
      "pick": {
        "value": "Seleccionar directorio"
      },
      "reload": {
        "value": "Volver a cargar archivo"
      },
      "delete": {
        "value": "Suprimir"
      },
      "remove": {
        "value": "Eliminar"
      },
      "noData": {
        "value": "Sin datos"
      },
      "preloader": {
        "value": "Precargador"
      },
      "checkAll": {
        "value": "Marcar todo"
      },
      "checkNone": {
        "value": "Desactivar Todo"
      },
      "checkSome": {
        "value": "Borrar marcados"
      },
      "close": {
        "value": "Cerrar"
      },
      "recentPages": {
        "value": "Conmutar visibilidad del historial"
      },
      "pagesHistory": {
        "back": {
          "value": "Página anterior"
        },
        "next": {
          "value": "Página siguiente"
        },
        "launch": {
          "value": "Mostrar historial de páginas"
        },
        "star": {
          "value": "Marcador de página"
        }
      },
      "pageInfo": {
        "value": "Hacer clic para anclar y desanclar"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "Seleccionar Archivo..."
      },
      "chooseDir": {
        "value": "Seleccionar Directorio..."
      }
    },
    "labels": {
      "info": {
        "value": "Información"
      },
      "warn": {
        "value": "Advertencia"
      },
      "error": {
        "value": "Error"
      },
      "alerts": {
        "value": "Alertas"
      },
      "pagesHistory": {
        "value": "Estas son las páginas visitadas desde que se seleccionó el proveedor actual. Haga clic en cualquier columna en la fila para navegar a la página asociada."
      },
      "pagesBookmark": {
        "value": "Estas son las páginas marcadas para el tipo de proveedor {0}. Haga clic en cualquier columna en la fila para navegar a la página asociada."
      }
    },
    "placeholders": {
      "search": {
        "value": "Buscar"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "Contenido incorrecto detectado"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "'{0}' contiene JSON, pero no es una representación de JSON de {1}."
      },
      "dataCopiedToClipboard": {
        "detail": "Los datos se han copiado en el portapapeles."
      },
      "tableCopiedToClipboard": {
        "summary": "La tabla se ha copiado correctamente en el portapapeles."
      },
      "emptyCellData": {
        "detail": "No se han copiado los datos en el portapapeles porque la celda seleccionada está vacía."
      },
      "emptyRowData": {
        "detail": "No se han copiado los datos en el portapapeles porque la fila seleccionada está vacía."
      },
      "browserPermissionDenied": {
        "summary": "Permiso del explorador denegado",
        "detail": "Debe activar la escritura en el portapapeles desde JavaScript para poder realizar esta operación. Asimismo, la API del portapapeles solo está soportada para páginas servidas en HTTPS."
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "Copiar celda en el portapapeles"
        },
        "row": {
          "label": "Copiar Fila en Portapapeles"
        },
        "tableAsText": {
          "label": "Copiar tabla en portapapeles (Texto)"
        },
        "tableAsJSON": {
          "label": "Copiar tabla en portapapeles (JSON)"
        },
        "tableAsYAML": {
          "label": "Copiar tabla en portapapeles (YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "Reducir todo"
      },
      "useTreeMenusAsRootNodes": {
        "value": "Usar menús de árbol como nodos raíz"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "Los cambios se han guardado correctamente en el archivo '{0}'."
      },
      "changesNotSaved": {
        "summary": "No se han podido guardar los cambios en el archivo '{0}'."
      },
      "changesDownloaded": {
        "summary": "Los cambios se han descargado correctamente en el archivo '{0}'."
      },
      "changesNotDownloaded": {
        "summary": "No se han podido descargar los cambios en el archivo '{0}'."
      },
      "verifyPathEntered": {
        "detail": ". Si establece el campo {0} en falso se aceptará el valor competo, sin validar su existencia como un directorio o archivo local."
      }
    },
    "wdtOptionsDialog": {
      "title": "Editar: {0}",
      "default": "Anular definición de valor",
      "instructions": "Introducir token para agregar a lista de elementos seleccionables.",
      "enterValue": "Introducir Valor",
      "selectValue": "Seleccionar valor",
      "selectSwitch": "Conmutar Valor",
      "enterUnresolvedReference": "Introducir referencia sin resolver",
      "enterModelToken": "Introducir token de modelo",
      "selectPropsVariable": "Seleccionar variable de token de modelo",
      "createPropsVariable": "Crear variable de token de modelo",
      "propName": "Nombre de variable (necesario)",
      "propValue": "Valor de Variable",
      "enterVariable": "Introducir variable",
      "variableName": "Nombre de variable (necesario)",
      "variableValue": "Valor de Variable",
      "multiSelectUnset": "Seleccionar valor de la lista de elementos disponibles"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "Se han detectado cambios sin guardar"
      },
      "changesNeedDownloading": {
        "value": "Los cambios no se han descargado"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "Todos los cambios sin guardar se perderán. ¿Desea continuar?"
        },
        "areYouSure": {
          "value": "¿Seguro que desea {0} sin guardar los cambios?"
        },
        "saveBeforeExiting": {
          "value": "¿Desea guardar los cambios antes de salir?"
        },
        "needDownloading": {
          "value": "Sus cambios de '{0}' no se han descargado en el archivo.<br/><br/>¿Desea descargarlos antes de continuar?"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "La nueva instancia '{0}' no se ha agregado al modelo WDT.<br/><br/>¿Desea agregarla antes de continuar?"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "Definir intervalo de recarga automática",
      "instructions": "¿Cuántos segundos desea definir para el intervalo de recarga automática?",
      "fields": {
        "interval": {
          "label": "Intervalo de recarga automática:"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "Mensaje",
          "detail": "La llamada de backend de la consola ha generado una respuesta '{0}' al intentar realizar la acción '{1}'"
        },
        "actionNotPerformed": {
          "detail": "No se ha podido realizar la acción '{0}' en uno o varios de los elementos marcados"
        },
        "actionNotPerformedNoRow": {
          "detail": "No se puede realizar la acción de '{0}'"
        },
        "actionSucceeded": {
          "summary": "La acción '{0}' se ha realizado correctamente."
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "No se puede determinar la causa exacta. Compruebe la consola de JavaScript para obtener indicaciones."
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "Confirmación de acción",
        "prompt": "La acción '{0}' no se puede deshacer.<br/><br/>¿Desea continuar?"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "Disponibles",
        "chosen": "Seleccionados"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "Nombre de propiedad",
        "value": "Valor de propiedad"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "Nombre de Propiedades",
        "valueHeader": "Valor de Propiedades",
        "addButtonTooltip": "Agregar",
        "deleteButtonTooltip": "Suprimir"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "Ver {0}..."
          },
          "create": {
            "label": "Crear Nuevo {0}..."
          },
          "edit": {
            "label": "Editar {0}..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "Restaurar Valor por Defecto"
    },
    "placeholder": {
      "value": "por defecto"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "'{0}' no está disponible."
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "RUNNING"
      },
      "shutdown": {
        "value": "SHUTDOWN"
      },
      "serverStates": {
        "value": "Estados del Servidor"
      },
      "systemStatus": {
        "value": "Estado del Sistema"
      },
      "healthState": {
        "failed": {
          "value": "Con fallos"
        },
        "critical": {
          "value": "Crítico"
        },
        "overloaded": {
          "value": "Sobrecargado"
        },
        "warning": {
          "value": "Advertencia"
        },
        "ok": {
          "value": "Correcto"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "Estado de Servidores en Ejecución a"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "Nombre"
        },
        "state": {
          "value": "Estado"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "No se puede acceder al backend actualmente."
      },
      "connectionMessage": {
        "summary": "Mensaje de conexión"
      },
      "connectFailed": {
        "detail": "Intento con fallos: "
      },
      "badRequest": {
        "detail": "No se ha podido procesar el archivo o la solicitud enviados"
      },
      "invalidCredentials": {
        "detail": "Las credenciales del dominio de WebLogic no son válidas"
      },
      "invalidUrl": {
        "detail": "No se puede acceder a la URL del dominio de WebLogic"
      },
      "notInRole": {
        "detail": "Intento con fallos: el usuario no es administrador, desplegador, operador o supervisor"
      },
      "notSupported": {
        "detail": "El dominio de WebLogic no está soportado"
      },
      "unexpectedStatus": {
        "detail": "Resultado inesperado (estado: {0})"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "Solicitud incorrecta",
          "detail": "Se ha devuelto una respuesta de error de una llamada de backend de consola."
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "Consulte el terminal de la consola remota o la consola de Javascript para obtener información sobre los motivos específicos."
      },
      "responseMessages": {
        "summary": "Mensajes de respuesta"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "Confirmación"
      },
      "prompt": {
        "value": "Al cerrar el elemento <b>{0}</b> se restablecerá el proveedor actual. ¿Desea continuar?"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "No se puede acceder al gestor de cambios."
      },
      "changesCommitted": {
        "summary": "Los cambios se han confirmado correctamente."
      },
      "changesNotCommitted": {
        "summary": "No se pueden confirmar los cambios."
      },
      "changesDiscarded": {
        "summary": "Los cambios se han desechado correctamente."
      },
      "changesNotDiscarded": {
        "summary": "No se pueden desechar los cambios."
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "Respuesta de error inesperado"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "Incidencia de conexión",
        "details": "Hay un problema al enviar y recibir datos del proveedor. Asegúrese de que son accesibles antes de continuar."
      },
      "pathNotFound": {
        "summary": "No se ha encontrado la ruta",
        "details": "'{0}' no es un archivo o directorio accesible en el sistema de archivos local."
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "Línea de mensaje"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "Borrar Mensaje"
        },
        "suppress": {
          "info": {
            "label": "Suprimir mensajes informativos"
          },
          "warning": {
            "label": "Suprimir advertencias"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " No se puede conectar con los dominios de servidor de administración de Weblogic."
      },
      "shutdownSequenceError": {
        "details": "Cierre los servidores gestionados y, a continuación, los servidores de administración."
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "Tiene {0} alertas de error de prioridad alta"
        },
        "warning": {
          "value": "Tiene {0} alertas de advertencia de prioridad alta"
        },
        "info": {
          "value": "Tiene {0} alertas de información de prioridad alta"
        },
        "view": {
          "value": "Ver Alertas"
        }
      }
    }
  }
});