define({
  "wrc-header": {
    "text": {
      "appName": "WebLogic Remote Console"
    },
    "region": {
      "ariaLabel": {
        "value": "Anwendungsheader"
      }
    },
    "buttons": {
      "logout": {
        "label": "Abmelden"
      }
    },
    "icons": {
      "navtree": {
        "toggler": {
          "tooltip": "Sichtbarkeit der Navigationsbaumstruktur umschalten"
        }
      },
      "theme": {
        "tooltip": "Theme wechseln"
      },
      "whatsNew": {
        "tooltip": "Neue Features"
      },
      "howDoI": {
        "tooltip": "Anleitungsaufgaben öffnen (Wie kann man...?)"
      },
      "tips": {
        "tooltip": "Sichtbarkeit von Benutzertipps umschalten"
      },
      "help": {
        "tooltip": "Interne Dokumentation zu WebLogic Remote Console öffnen"
      },
      "profile": {
        "tooltip": "Profil"
      }
    },
    "menus": {
      "messageCenter": {
        "value": "Nachrichtencenter öffnen"
      },
      "theme": {
        "light": {
          "value": "Hell"
        },
        "dark": {
          "value": "Dunkel"
        }
      }
    },
    "tooltips": {
      "appName": {
        "value": "Hier klicken, um WebLogic Remote Console zurückzusetzen"
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "Copyright (c) 2020, 2025, Oracle und/oder verbundene Unternehmen.<br/>Oracle (r), Java, MySQL und NetSuite sind eingetragene Marken der Oracle Corporation und/oder ihrer verbundenen Unternehmen. Andere Namen und Bezeichnungen können Marken ihrer jeweiligen Inhaber sein.<br/>",
      "builtWith": "Mit Oracle JET erstellt"
    }
  },
  "wrc-connectivity": {
    "labels": {
      "insecure": {
        "value": "Nicht sicher"
      }
    },
    "icons": {
      "insecure": {
        "tooltip": "Admin-Serververbindung nicht sicher"
      }
    }
  },
  "wrc-app-profile": {
    "icons": {
      "profile": {
        "popup": {
          "launcher": {
            "tooltip": "Profilliste anzeigen"
          }
        },
        "dialog": {
          "launcher": {
            "tooltip": "Profile verwalten"
          },
          "editor": {
            "tooltip": "Profileditor",
            "toolbar": {
              "save": {
                "tooltip": "Profil speichern"
              },
              "activate": {
                "tooltip": "Aktives Profil"
              },
              "add": {
                "tooltip": "Profil hinzufügen"
              },
              "remove": {
                "tooltip": "Profil löschen"
              }
            }
          }
        },
        "image": {
          "tooltip": "Profil",
          "capture": {
            "tooltip": "Bild hinzufügen oder ändern"
          }
        }
      }
    },
    "tabstrip": {
      "tabs": {
        "general": {
          "value": "Allgemein"
        },
        "settings": {
          "value": "Einstellungen"
        },
        "preferences": {
          "value": "Voreinstellungen"
        },
        "properties": {
          "value": "Eigenschaften"
        }
      }
    },
    "dialog": {
      "changeImage": {
        "value": "Bild ändern"
      },
      "clearImage": {
        "value": "Bild löschen"
      },
      "profile": {
        "default": {
          "value": "Standardprofil"
        },
        "toggler": {
          "editor": {
            "show": {
              "value": "Profileditor anzeigen"
            },
            "hide": {
              "value": "Profileditor ausblenden"
            }
          }
        }
      }
    },
    "popup": {
      "profile": {
        "manager": {
          "open": {
            "value": "Profilmanager öffnen"
          },
          "signout": {
            "value": "Abmelden"
          }
        }
      }
    },
    "labels": {
      "profile": {
        "fields": {
          "id": {
            "value": "Profil-ID"
          },
          "organization": {
            "value": "Organisation"
          },
          "name": {
            "value": "Name"
          },
          "email": {
            "value": "E-Mail-Adresse"
          },
          "role": {
            "default": {
              "value": "Als Standardprofil verwenden"
            }
          },
          "settings": {
            "useCredentialStorage": {
              "value": "Verschlüsselte Zugangsdaten für Ihre Projekte speichern?"
            },
            "disableHNV": {
              "value": "Hostnamenverifizierung deaktivieren?"
            },
            "proxyAddress": {
              "value": "Proxyadresse"
            },
            "trustStoreType": {
              "value": "Truststore-Typ:"
            },
            "trustStorePath": {
              "value": "Truststore-Pfad"
            },
            "trustStoreKey": {
              "value": "Truststore-Schlüssel"
            },
            "connectionTimeout": {
              "value": "Administrationsserver-Verbindungstimeout"
            },
            "readTimeout": {
              "value": "Administrationsserver-Lesetimeout"
            }
          },
          "preferences": {
            "theme": {
              "value": "Theme"
            },
            "startupTaskChooserType": {
              "value": "Typ der Startaufgabenauswahl"
            },
            "useTreeMenusAsRootNodes": {
              "value": "Baummenüs als Root-Ebene von Baumnavigatoren verwenden?"
            },
            "onQuit": {
              "value": "Zulassen, dass nicht gespeicherte Änderungen das Beenden der Anwendung verhindern?"
            },
            "onDelete": {
              "value": "Alle Löschvorgänge bestätigen?"
            },
            "onActionNotAllowed": {
              "value": "Popup-Fenster \"Aktion nicht zulässig\" verwenden, um Datenverlust zu verhindern?"
            },
            "onUnsavedChangesDetected": {
              "value": "Popup-Fenster \"Nicht gespeicherte Änderungen gefunden\" verwenden, um Datenverlust zu verhindern?"
            },
            "onChangesNotDownloaded": {
              "value": "Popup-Fenster \"Änderungen nicht heruntergeladen\" verwenden, um Datenverlust zu verhindern?"
            }
          },
          "properties": {
            "javaSystemProperties": {
              "value": "Java-Systemeigenschaften"
            }
          }
        },
        "legalValues": {
          "themeOptions": {
            "light": {
              "value": "Hell"
            },
            "dark": {
              "value": "Dunkel"
            }
          },
          "taskChooserTypeOptions": {
            "useDialog": {
              "value": "Dialogfeld verwenden"
            },
            "useCards": {
              "value": "Karten verwenden"
            }
          },
          "trustStoreTypeOptions": {
            "jks": {
              "value": "JKS"
            },
            "pkcs12": {
              "value": "PKCS12"
            },
            "windowsRoot": {
              "value": "Windows ROOT"
            },
            "keyChainStore": {
              "value": "Schlüsselbundspeicher"
            }
          }
        },
        "messages": {
          "save": {
            "succeeded": {
              "summary": "Profil \"{0}\" wurde erfolgreich gespeichert."
            }
          }
        }
      }
    }
  },
  "wrc-data-providers": {
    "icons": {
      "hoverMenu": {
        "ariaLabel": {
          "value": "Provideraktionen "
        }
      },
      "info": {
        "tooltip": "Informationen zu diesem Provider abrufen"
      },
      "edit": {
        "tooltip": "Einstellungen zu diesem Provider verwalten"
      },
      "deactivate": {
        "tooltip": "Diesen Provider deaktivieren"
      },
      "delete": {
        "tooltip": "Diesen Provider entfernen"
      }
    },
    "labels": {
      "connections": {
        "header": {
          "value": "Projekt ohne Namen"
        },
        "name": {
          "value": "Verbindungsprovidername"
        },
        "url": {
          "value": "URL"
        },
        "proxyOverride": {
          "value": "Proxy-Override"
        },
        "username": {
          "value": "Benutzername"
        },
        "password": {
          "value": "Kennwort"
        }
      },
      "models": {
        "name": {
          "value": "WDT-Modellprovidername"
        },
        "file": {
          "value": "WDT-Modelldateiname"
        },
        "props": {
          "value": "WDT-Variablen"
        }
      },
      "composite": {
        "name": {
          "value": "WDT-Compositemodell-Providername"
        },
        "providers": {
          "value": "WDT-Modelle"
        }
      },
      "proplist": {
        "name": {
          "value": "Providername von Eigenschaftsliste"
        },
        "file": {
          "value": "Dateiname von Eigenschaftsliste"
        }
      },
      "project": {
        "name": {
          "value": "Projektname"
        },
        "file": {
          "value": "Projektdateiname"
        }
      },
      "provider": {
        "adminserver": {
          "value": "Admin-Serververbindung"
        },
        "model": {
          "value": "WDT-Modell hinzufügen"
        }
      },
      "dropdown": {
        "none": {
          "value": "Kein Wert"
        }
      }
    },
    "popups": {
      "info": {
        "project": {
          "name": {
            "label": "Projektname:"
          }
        },
        "provider": {
          "id": {
            "label": "Provider-ID:"
          }
        },
        "domain": {
          "consoleExtensionVersion": {
            "label": "Konsolenerweiterungsversion:"
          },
          "name": {
            "label": "Domainname:"
          },
          "url": {
            "label": "Domain-URL:"
          },
          "proxyOverride": {
            "label": "Proxy-Override:"
          },
          "version": {
            "label": "Domainversion:"
          },
          "username": {
            "label": "Benutzername:"
          },
          "sso": {
            "label": "Webauthentifizierung:"
          },
          "roles": {
            "label": "Rollen:"
          },
          "connectTimeout": {
            "label": "Verbindungstimeout:"
          },
          "readTimeout": {
            "label": "Lesetimeout:"
          },
          "insecure": {
            "label": "Nicht sicher:"
          },
          "anyAttempt": {
            "label": "Alle Verbindungsversuche:"
          },
          "lastAttempt": {
            "label": "Letzter erfolgreicher Versuch:"
          }
        },
        "model": {
          "file": {
            "label": "Datei:"
          },
          "props": {
            "label": "Variablen:"
          }
        },
        "composite": {
          "models": {
            "label": "Modelle:"
          }
        },
        "proplist": {
          "file": {
            "label": "Dateiname:"
          }
        }
      }
    },
    "menus": {
      "connections": {
        "add": {
          "value": "Admin-Serververbindungsprovider hinzufügen"
        }
      },
      "models": {
        "add": {
          "value": "WDT-Modelldateiprovider hinzufügen"
        },
        "new": {
          "value": "Provider für neue WDT-Modelldatei erstellen"
        }
      },
      "composite": {
        "add": {
          "value": "WDT-Compositemodell-Dateiprovider hinzufügen"
        }
      },
      "proplist": {
        "add": {
          "value": "Eigenschaftslistenprovider hinzufügen"
        },
        "new": {
          "value": "Provider für neue Eigenschaftsliste erstellen"
        }
      },
      "providers": {
        "sort": {
          "value": "Nach Providertyp sortieren"
        }
      },
      "context": {
        "info": {
          "connection": {
            "domain": {
              "url": {
                "label": "Domain-URL:"
              },
              "version": {
                "label": "Domainversion:"
              },
              "username": {
                "label": "Benutzername:"
              }
            }
          },
          "model": {
            "file": {
              "label": "Datei:"
            }
          }
        }
      },
      "project": {
        "export": {
          "value": "Provider als Projekt exportieren..."
        },
        "import": {
          "value": "Projekt importieren"
        }
      }
    },
    "instructions": {
      "connections": {
        "add": {
          "value": "Geben Sie einen neuen Namen und Konnektivitätseinstellungen für den Verbindungsprovider ein."
        },
        "edit": {
          "value": "Ändern Sie Konnektivitätseinstellungen für den Verbindungsprovider."
        },
        "deactivate": {
          "value": "Deaktivieren Sie den Verbindungsprovider, und beenden Sie das Domainstatus-Polling."
        }
      },
      "models": {
        "add": {
          "value": "Geben Sie Einstellungen für den vorhandenen Modelldateiprovider ein. Klicken Sie auf das Uploadsymbol, um nach der Modelldatei zu suchen."
        },
        "new": {
          "value": "Geben Sie den Providernamen und Dateinamen für die neue WDT-Modelldatei ein. Klicken Sie dann auf das Symbol, um das Verzeichnis zum Speichern der Datei auszuwählen."
        },
        "edit": {
          "value": "Ändern Sie die Einstellungen für den Modelldateiprovider. Klicken Sie auf das Symbol, um nach der Modelldatei zu suchen."
        }
      },
      "composite": {
        "add": {
          "value": "Geben Sie einen neuen Namen ein, und wählen Sie eine angeordnete Modellliste für den Compositemodellprovider aus."
        },
        "edit": {
          "value": "Ändern Sie die Einstellungen für den Compositemodellprovider. Verwenden Sie eine angeordnete Modellliste."
        }
      },
      "proplist": {
        "add": {
          "value": "Geben Sie Einstellungen für den vorhandenen Eigenschaftslistenprovider ein. Klicken Sie auf das Uploadsymbol, um nach einer Eigenschaftendatei zu suchen."
        },
        "new": {
          "value": "Geben Sie den Providernamen und Dateinamen für eine neue Eigenschaftsliste ein. Klicken Sie dann auf das Symbol, um das Verzeichnis zum Speichern der Datei auszuwählen."
        },
        "edit": {
          "value": "Ändern Sie Einstellungen für den Eigenschaftslistenprovider. Klicken Sie auf das Symbol, um nach einer Eigenschaftendatei zu suchen."
        }
      },
      "project": {
        "export": {
          "value": "Geben Sie Einstellungen für das neue Projekt ein."
        },
        "import": {
          "value": "Klicken Sie auf das Downloadsymbol, um nach dem Projekt zu suchen."
        }
      },
      "task": {
        "startup": {
          "value": "Welche Startaufgabe möchten Sie ausführen?"
        }
      },
      "project-busy": {
        "value": "Speichern oder verwerfen Sie nicht gespeicherte Änderungen, bevor Sie Änderungen an einem Teil des Projekts vornehmen"
      }
    },
    "titles": {
      "add": {
        "connections": {
          "value": "Provider für Admin-Serververbindung erstellen"
        },
        "models": {
          "value": "Provider für vorhandene WDT-Modelldatei erstellen"
        },
        "composite": {
          "value": "Provider für neues WDT-Compositemodell erstellen"
        },
        "proplist": {
          "value": "Provider für vorhandene Eigenschaftsliste erstellen"
        }
      },
      "new": {
        "models": {
          "value": "Provider für neue WDT-Modelldatei erstellen"
        },
        "proplist": {
          "value": "Provider für neue Eigenschaftsliste erstellen"
        }
      },
      "edit": {
        "connections": {
          "value": "Admin-Serververbindungsprovider bearbeiten"
        },
        "models": {
          "value": "WDT-Modelldateiprovider bearbeiten"
        },
        "composite": {
          "value": "WDT-Compositemodellprovider bearbeiten"
        },
        "proplist": {
          "value": "Eigenschaftslistenprovider bearbeiten"
        }
      },
      "export": {
        "project": {
          "value": "Provider als Projekt exportieren"
        }
      },
      "import": {
        "project": {
          "value": "Projekt importieren"
        }
      },
      "startup": {
        "task": {
          "value": "Startaufgabe"
        }
      },
      "project-busy": {
        "value": "Projekt ausgelastet"
      }
    },
    "messages": {
      "export": {
        "failed": {
          "summary": "Exportieren nicht erfolgreich",
          "detail": "Provider können nicht als Projekt \"{0}\" exportiert werden."
        }
      },
      "import": {
        "failed": {
          "summary": "Speichern nicht erfolgreich",
          "detail": "Projektdatei \"{0}\" kann nicht importiert werden."
        }
      },
      "stage": {
        "failed": {
          "summary": "Erstellen nicht erfolgreich",
          "detail": "Providerelement \"{0}\" kann nicht erstellt werden."
        }
      },
      "use": {
        "failed": {
          "summary": "Verbindung nicht erfolgreich",
          "detail": "Providerelement \"{0}\" kann nicht verwendet werden."
        }
      },
      "upload": {
        "failed": {
          "detail": "Die WDT-Modelldatei kann nicht geladen werden: {0}"
        },
        "props": {
          "failed": {
            "detail": "Die WDT-Variablen können nicht geladen werden: {0}"
          }
        }
      },
      "response": {
        "nameAlreadyExist": {
          "detail": "Es ist bereits ein Provider namens \"{0}\" in diesem Projekt vorhanden."
        },
        "modelsNotFound": {
          "detail": "Die konfigurierten WDT-Modelle \"{0}\" können nicht gefunden werden"
        },
        "propListNotFound": {
          "detail": "Die WDT-Variablen \"{0}\" können nicht gefunden werden"
        },
        "selectModels": {
          "detail": "Um das WDT-Composite auszuwählen, wählen Sie zunächst alle vom WDT-Composite verwendeten WDT-Modelle aus."
        }
      },
      "sso": {
        "secureContextRequired": {
          "detail": "Die URL muss das HTTPS-Protokoll angeben oder localhost verwenden"
        }
      },
      "correctiveAction": {
        "filePathNotFound": {
          "detail": "<p>Bearbeiten Sie den Pfad im Feld \"Dateiname\", und klicken Sie auf die Schaltfläche \"OK\". Alternativ dazu können Sie auf das Uploadsymbol klicken und eine andere Datei auswählen.</p>"
        },
        "fixModelFile": {
          "detail": "<p>Beheben Sie die unten genannten Probleme, und klicken Sie auf die Schaltfläche \"OK\". Alternativ dazu können Sie eine andere Datei auswählen.</p>"
        },
        "yamlException": {
          "detail": "{0} in Zeile {1}, Spalte {2}"
        },
        "wktModelContent": {
          "summary": "Probleme mit Modellinhalt",
          "detail": "Beheben Sie Probleme mit dem Modelleditor auf der Registerkarte <i>Codeansicht</i>."
        }
      }
    },
    "prompts": {
      "info": {
        "fileNotSet": {
          "value": "Nicht festgelegt"
        }
      }
    },
    "checkboxes": {
      "useSparseTemplate": {
        "label": "Sparse-Vorlage verwenden"
      },
      "usesso": {
        "label": "Webauthentifizierung verwenden"
      },
      "insecure": {
        "label": "Unsichere Verbindung herstellen"
      }
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "Baum bearbeiten"
      },
      "view": {
        "tooltip": "Konfigurationsbaumansicht"
      },
      "monitoring": {
        "tooltip": "Monitoringbaum"
      },
      "security": {
        "tooltip": "Sicherheitsdatenbaum"
      },
      "modeling": {
        "tooltip": "WDT-Modell"
      },
      "composite": {
        "tooltip": "WDT-Compositemodell"
      },
      "properties": {
        "tooltip": "Eigenschaftslisteneditor"
      }
    }
  },
  "wrc-navigation": {
    "ariaLabel": {
      "navstrip": {
        "value": "Providerbaummenü"
      },
      "navtree": {
        "value": "Providerbaumnavigator"
      },
      "panelResizer": {
        "value": "Skalierfunktion für den Providerbaumnavigator. Verwenden Sie die Pfeiltasten nach links und rechts, um den Navigator zu skalieren"
      }
    }
  },
  "wrc-content-area-header": {
    "ariaLabel": {
      "button": {
        "home": {
          "value": "Home. Kehren Sie zur Seite mit den Karten für die Providerbäume zurück"
        }
      },
      "region": {
        "title": {
          "value": "Inhaltsbereichsheader"
        }
      },
      "popup": {
        "provider": {
          "value": "Provideraktionen"
        }
      }
    },
    "title": {
      "home": "Home",
      "configuration": "Baum bearbeiten",
      "view": "Konfigurationsbaumansicht",
      "monitoring": "Monitoringbaum",
      "security": "Sicherheitsdatenbaum",
      "modeling": "WDT-Modell",
      "composite": "WDT-Compositemodell",
      "properties": "Eigenschaftsliste"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "Home"
        }
      }
    },
    "icons": {
      "shoppingcart": {
        "tooltip": "Hier klicken, um Aktionen für den Warenkorb anzuzeigen"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "Änderungen anzeigen..."
        },
        "discard": {
          "label": "Änderungen verwerfen"
        },
        "commit": {
          "label": "Änderungen festschreiben"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "Warenkorb"
        },
        "ataglance": {
          "label": "Überblick"
        },
        "projectmanagement": {
          "label": "Provider"
        },
        "tips": {
          "label": "Benutzertipps"
        },
        "dashboards": {
          "label": "Dashboards"
        }
      }
    },
    "popups": {
      "tips": {
        "title": "Tipps filtern",
        "checkboxes": {
          "hideall": "Alle Tipps ausblenden",
          "productivity": "Produktivitätstipps anzeigen",
          "personalization": "Personalisierungstipps anzeigen",
          "whereis": "Tipps zum Thema \"Wo ist...\" anzeigen",
          "accessibility": "Tipps zur Barrierefreiheit anzeigen",
          "connectivity": "Konnektivitätstipps anzeigen",
          "security": "Sicherheitstipps anzeigen",
          "other": "Sonstige Tipps anzeigen"
        }
      }
    },
    "tips": {
      "labels": {
        "hideall": {
          "value": "Alle ausblenden"
        },
        "productivity": {
          "value": "Produktivität"
        },
        "personalization": {
          "value": "Personalisierung"
        },
        "whereis": {
          "value": "Wo ist..."
        },
        "accessibility": {
          "value": "Barrierefreiheit"
        },
        "connectivity": {
          "value": "Konnektivität"
        },
        "security": {
          "value": "Sicherheit"
        },
        "other": {
          "value": "Sonstiges"
        }
      },
      "cards": {
        "tip0": {
          "title": "Suchen Sie über alle MBeans in Ihrer Domain hinweg.",
          "descriptionHTML": "<p>Geben Sie in das Suchfeld oben in der Konsole einen Suchbegriff ein, um die aktuelle Perspektive nach Übereinstimmungen zu durchsuchen. Im Knoten <b>Letzte Suchvorgänge</b> können Sie auch zu vorangegangenen Abfragen zurückkehren.</p>"
        },
        "tip1": {
          "title": "Filtern und finden Sie schnell die Daten, die Ihnen wichtig sind.",
          "descriptionHTML": "<p>Mit Dashboards können Sie benutzerdefinierte Kriterien definieren, mit Ihrer Domain abgleichen und umfassende und genaue Berichte generieren, die auf Ihrer Domain basieren.</p><p>Öffnen Sie dazu zunächst einen Knoten im <b>Monitoringbaum</b>, und klicken Sie auf <b>Neues Dashboard</b>. Oder öffnen Sie auf der höchsten Ebene den Knoten <b>Dashboards</b> , um die integrierten Dashboards zu sehen.</p>"
        },
        "tip2": {
          "title": "Tabelleninhalte verfeinern",
          "descriptionHTML": "<p>Vereinfachen Sie Tabellen, indem sie nicht relevante Spalten ausblenden. So können Sie sich auf die Ihnen wichtigen Daten konzentrieren.</p><p>Klicken Sie über einer beliebigen Tabelle auf <b>Tabelle anpassen</b>, und wählen Sie nach Bedarf Spalten aus oder heben deren Auswahl auf.</p>"
        },
        "tip3": {
          "title": "Tastatur mit Tabellen und Aktionen verwenden",
          "descriptionHTML": "<p></p>"
        },
        "tip4": {
          "title": "Wo ist der Link \"Diese Tabelle anpassen\"?",
          "descriptionHTML": "<p>Der Link \"Diese Tabelle anpassen\" wurde zur Schaltfläche <i>Tabelle anpassen</i> umgestaltet.</p>"
        },
        "tip5": {
          "title": "Ausstehende Änderungen prüfen",
          "descriptionHTML": "<p>Öffnen Sie den Warenkorb, um eine Liste der Änderungen zu sehen, die in der Domain gespeichert, aber noch nicht festgeschrieben wurden.</p><p>Wenn Sie <b>Änderungen anzeigen</b> im Warenkorb nicht finden, versuchen Sie eine <a href='#' tabindex='0' on-click data-url='@@docsURL@@/set-console/#GUID-40440E0F-0310-4830-9B4B-00FC9ABBB591'>Installation der WebLogic Remote Console-Erweiterung</a>."
        },
        "tip6": {
          "title": "Benötigen Sie Hilfe?",
          "descriptionHTML": "<ul><li>Bewegen Sie den Cursor über das <b>?</b> neben einem Feld, um QuickInfos aufzurufen.</li><li>Klicken Sie auf Seitenebene auf das <b>?</b>, um detaillierte Hilfe für jedes sichtbare Attribut aufzurufen.</li><li>Klicken Sie im Menü <b>Hilfe</b> auf <b>WebLogic Remote Console GitHub-Projekt besuchen</b>.</li><li>Treten Sie unserem Slack-Kanal bei: <a href='#' tabindex='0' on-click data-url='https://join.slack.com/t/oracle-weblogic/shared_invite/zt-1ni1gtjv6-PGC6CQ4uIte3KBdm_67~aQ'>#remote-console</a>.</li><li>Zeigen Sie unsere Dokumentation an auf <a href='#' tabindex='0' on-click data-url='@@docsURL@@/'></a>.</li></ul>"
        },
        "tip7": {
          "title": "Sonstiger Tipp 1",
          "descriptionHTML": "<p>Eine kurze Beschreibung für \"Sonstiger Tipp 1\". Ein Zeilenvorschubzeichen ist kein HTML-Element und sollte daher in dieser Beschreibung nicht verwendet werden.</p>"
        },
        "tip8": {
          "title": "Probleme bei Verbindung zu einem Server?",
          "descriptionHTML": "<p>Wählen Sie unter <b>Monitoringbaum</b> > <b>Umgebung</b> > <b>Server</b> den Server aus, der nicht reagiert, und öffnen Sie seine Registerkarte <b>Fehlerbehebung</b>, um eine Diagnose des Problems zu versuchen.</p><p>Wenn Sie gar keine Verbindung zu der Domain herstellen können, finden Sie Hilfe zur Fehlerbehebung unter <a href='#' tabindex='0' on-click data-url='@@docsURL@@/troubleshoot-weblogic-remote-console/#GUID-B3D14A11-0144-4B31-BFE3-E6AC59AEFCBE'>Verbindung zum Administrationsserver nicht möglich</a> in der Dokumentation zu WebLogic Remote Console.</p>"
        },
        "tip9": {
          "title": "Konnektivitätstipp 2",
          "descriptionHTML": "<p>Eine kurze Beschreibung für \"Konnektivitätstipp 2\". Ein Zeilenvorschubzeichen ist kein HTML-Element und sollte daher in dieser Beschreibung nicht verwendet werden.</p>"
        },
        "tip10": {
          "title": "Sicherheitstipp 1",
          "descriptionHTML": "<p>Eine kurze Beschreibung für \"Sicherheitstipp 1\". Ein Zeilenvorschubzeichen ist kein HTML-Element und sollte daher in dieser Beschreibung nicht verwendet werden.</p>"
        },
        "tip11": {
          "title": "Beschleunigen Sie Ihren Workflow.",
          "descriptionHTML": "<p>Verwenden Sie Tastenkombinationen, um direkt zu bestimmten UI-Komponenten zu gelangen.</p><p>Wichtigste 5:</p><li><code><b>Alt+P</b></code>: Öffnet das Menü <b>Provider</b>.</li><li><code><b>Alt+C</b></code>: Verschiebt den Fokus auf den <b>Warenkorb</b>.</li><li><code><b>Alt+T</b></code>: Verschiebt den Fokus auf den ersten Spaltenheader in einer Tabelle.</li><li><code><b>Alt+|</b></code>: Verschiebt den Fokus auf das Bedienelement zum Verändern der Baumbreite. Mit den Pfeiltasten können Sie die Breite des Baums ändern.</li><li><code><b>Alt+;</b></code>: Verschiebt den Fokus auf das erste klickbare Navigationspfadlabel.</li></ul><p>Eine umfassende Liste der Tastenkombinationen finden Sie in der Dokumentation.</p>"
        }
      }
    }
  },
  "wrc-perspective": {
    "ariaLabel": {
      "region": {
        "breadcrumbs": {
          "value": "Navigationspfade"
        }
      }
    },
    "icons": {
      "history": {
        "tooltip": "Historie"
      },
      "separator": {
        "tooltip": "Trennzeichen"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "Historieneinträge löschen",
          "label": "Historieneinträge löschen"
        }
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "Wird ausgeführt bei {0}"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "Verbindung unterbrochen",
        "detail": "Verbindung unterbrochen. Bitte aktualisieren."
      },
      "cannotConnect": {
        "summary": "Verbindungsversuch nicht erfolgreich",
        "detail": "Verbindung zur WebLogic-Domain {0} kann nicht hergestellt werden. Prüfen Sie, ob WebLogic ausgeführt wird."
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "Bäume"
        },
        "startup-tasks": {
          "label": "Startaufgaben"
        }
      }
    }
  },
  "wrc-landing": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Landingpage"
        }
      },
      "cardLinks": {
        "panel": {
          "value": "Landingpage-Links"
        }
      },
      "screenreader": {
        "value1": "Sie zeigen auf das {0}-Element. Drücken Sie zum Auswählen die Eingabetaste.",
        "value2": "Sie zeigen auf das {0}-Element. Mit der Eingabetaste wird es ein- oder ausgeblendet. Nach dem Einblenden können Sie mit dem Pfeil nach unten auf die zugehörigen Links zugreifen.",
        "value3": "{0}. Drücken Sie Tab/Umschalt+Tab, um die zugehörigen Links anzusteuern, und Escape, um zum zuletzt besuchten Element der höchsten Ebene zurückzukehren."
      }
    }
  },
  "wrc-gallery": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Providerbäume"
        }
      }
    },
    "cards": {
      "configuration": {
        "label": "Baum bearbeiten",
        "description": "<p>Behalten Sie die Konfiguration der WebLogic-Domain bei, mit der Sie gerade arbeiten.</p>"
      },
      "view": {
        "label": "Konfigurationsbaumansicht",
        "description": "<p>Prüfen Sie die schreibgeschützte Konfiguration der WebLogic-Domain, mit der Sie gerade arbeiten.</p>"
      },
      "monitoring": {
        "label": "Monitoringbaum",
        "description": "<p>Zeigen Sie Laufzeit-MBean-Informationen für ausgewählte Ressourcen in der WebLogic-Domain an, mit der Sie gerade arbeiten.</p>"
      },
      "security": {
        "label": "Sicherheitsdatenbaum",
        "description": "<p>Verwalten Sie sicherheitsbezogene Informationen (z.B. Benutzer, Gruppen, Rollen, Policys, Zugangsdaten usw.) in der WebLogic-Domain, mit der Sie gerade arbeiten.</p>"
      },
      "modeling": {
        "label": "WDT-Modellbaum",
        "description": "<p>Verwalten Sie Modelldateien für WebLogic Deploy Tooling.</p>"
      },
      "composite": {
        "label": "WDT-Compositemodellbaum",
        "description": "<p>Zeigen Sie ein kombiniertes Set aus WebLogic Deploy Tooling-Modelldateien an, mit denen Sie derzeit arbeiten.</p>"
      },
      "properties": {
        "label": "Eigenschaftslisteneditor",
        "description": "<p>Hier können Sie ein Set aus Eigenschaften aus einer Eigenschaftslistendatei anzeigen oder ändern.</p>"
      }
    }
  },
  "wrc-startup-tasks": {
    "ariaLabel": {
      "cards": {
        "panel": {
          "value": "Startaufgaben"
        }
      }
    },
    "cards": {
      "addAdminServer": {
        "label": "Admin-Serververbindungsprovider hinzufügen",
        "description": "Mit dieser Aufgabe erstellen Sie eine Projektressource, die eine Verbindung zum Admin-Server ermöglicht"
      },
      "addWdtModel": {
        "label": "WDT-Modelldateiprovider hinzufügen",
        "description": "Mit dieser Aufgabe erstellen Sie eine Projektressource, die das Verwalten einer auf Ihrem lokalen Dateisystem vorhandenen WDT-Modelldatei ermöglicht"
      },
      "addWdtComposite": {
        "label": "WDT-Compositemodell-Dateiprovider hinzufügen",
        "description": "Mit dieser Aufgabe erstellen Sie eine Projektressource, die das Verwalten von auf Ihrem lokalen Dateisystem vorhandenen WDT-Modelldateifragmenten ermöglicht"
      },
      "addPropertyList": {
        "label": "Eigenschaftslistenprovider hinzufügen",
        "description": "Mit dieser Aufgabe erstellen Sie eine Projektressource, die das Verwalten einer auf Ihrem lokalen Dateisystem gespeicherten .properties-Datei ermöglicht"
      },
      "createWdtModel": {
        "label": "Provider für neue WDT-Modelldatei erstellen",
        "description": "Mit dieser Aufgabe erstellen Sie eine Projektressource, die eine auf Ihrem lokalen Dateisystem gespeicherte neue WDT-Modelldatei ist"
      },
      "createPropertyList": {
        "label": "Provider für neue Eigenschaftsliste erstellen",
        "description": "Mit dieser Aufgabe erstellen Sie eine Projektressource, die eine auf Ihrem lokalen Dateisystem gespeicherte neue .properties-Datei ist"
      },
      "importProject": {
        "label": "Projekt importieren",
        "description": "Mit dieser Aufgabe laden Sie ein zuvor exportiertes Projekt mit Providern, die Sie sofort verwenden oder ändern können"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "Änderungen verwerfen"
      },
      "commit": {
        "tooltip": "Änderungen festschreiben"
      }
    },
    "sections": {
      "changeManager": {
        "label": "Change Manager"
      },
      "additions": {
        "label": "Hinzugefügte Elemente"
      },
      "modifications": {
        "label": "Geänderte Elemente"
      },
      "removals": {
        "label": "Entfernte Elemente"
      },
      "restart": {
        "label": "Neu starten"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "Neu"
      },
      "clone": {
        "label": "Klonen"
      },
      "delete": {
        "label": "Löschen"
      },
      "customize": {
        "label": "Tabelle anpassen"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "Landingpage"
      },
      "history": {
        "tooltip": "Sichtbarkeit der Historie umschalten"
      },
      "instructions": {
        "tooltip": "Sichtbarkeit von Anweisungen umschalten"
      },
      "help": {
        "tooltip": "Sichtbarkeit der Hilfeseite umschalten"
      },
      "sync": {
        "tooltip": "Neu laden",
        "tooltipOn": "Automatisches Neuladen stoppen"
      },
      "syncInterval": {
        "tooltip": "Intervall für automatisches Neuladen festlegen"
      }
    },
    "instructions": {
      "selectItems": {
        "value": "Wählen Sie Elemente aus, mit denen Sie den Vorgang \"{0}\" ausführen möchten."
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "Meldung",
          "detail": "Aktion \"{0}\" kann nicht ausgeführt werden, während Daten automatisch neu geladen werden. Klicken Sie zunächst auf das Symbol \"{1}\", um das automatische Neuladen zu stoppen."
        }
      }
    },
    "prompts": {
      "download": {
        "value": "Speicherorte für heruntergeladene Logdateien:"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "Ausgeblendete Spalten anzeigen"
      }
    },
    "labels": {
      "totalRows": {
        "value": "Gesamte Zeilen: {0}"
      },
      "reloadHidden": {
        "value": "Tabelle neu laden, um die aktuellen {0} Werte anzuzeigen"
      },
      "noData": {
        "value": "Keine Daten gefunden."
      }
    }
  },
  "wrc-table-customizer": {
    "ariaLabel": {
      "availableColumns": {
        "title": {
          "value": "Verfügbare Spalten"
        },
        "list": {
          "value": "Liste der verfügbaren Spalten"
        },
        "listItem": {
          "value": "Element in Liste der verfügbaren Spalten"
        }
      },
      "selectedColumns": {
        "title": {
          "value": "Ausgewählte Spalten"
        },
        "list": {
          "value": "Liste der ausgewählten Spalten"
        },
        "listItem": {
          "value": "Element in Liste der ausgewählten Spalten"
        }
      },
      "button": {
        "addToRight": {
          "value": "In Liste \"Verfügbare Spalten\" ausgewählte Elemente in Liste \"Ausgewählte Spalten\" verschieben"
        },
        "addAllRight": {
          "value": "Alle Elemente in Liste \"Verfügbare Spalten\" in Liste \"Ausgewählte Spalten\" verschieben"
        },
        "removeRight": {
          "value": "In Liste \"Ausgewählte Spalten\" ausgewählte Elemente in Liste \"Verfügbare Spalten\" verschieben"
        },
        "removeAll": {
          "value": "Alle Elemente in Liste \"Ausgewählte Spalten\" in Liste \"Verfügbare Spalten\" verschieben"
        },
        "reset": {
          "value": "Spalten in Liste \"Ausgewählte Spalten\" auf diejenigen zurücksetzen, die beim Öffnen der Tabellenanpassung vorhanden waren."
        },
        "apply": {
          "value": "Spaltenanpassungen auf Tabelle anwenden"
        },
        "cancel": {
          "value": "Alle Spaltenanpassungen abbrechen"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "Speichern"
      },
      "new": {
        "label": "Erstellen"
      },
      "delete": {
        "label": "Entfernen"
      },
      "back": {
        "label": "Zurück"
      },
      "next": {
        "label": "Weiter"
      },
      "finish": {
        "label": "Erstellen"
      },
      "customize": {
        "label": "Tabelle anpassen"
      },
      "dashboard": {
        "label": "Neues Dashboard"
      }
    },
    "icons": {
      "save": {
        "tooltip": "Speichern"
      },
      "create": {
        "tooltip": "Erstellen"
      },
      "landing": {
        "tooltip": "Landingpage"
      },
      "history": {
        "tooltip": "Sichtbarkeit der Historie umschalten"
      },
      "instructions": {
        "tooltip": "Sichtbarkeit von Anweisungen umschalten"
      },
      "help": {
        "tooltip": "Sichtbarkeit der Hilfeseite umschalten"
      },
      "sync": {
        "tooltip": "Neu laden",
        "tooltipOn": "Automatisches Neuladen stoppen"
      },
      "syncInterval": {
        "tooltip": "Intervall für automatisches Neuladen festlegen"
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "Erweiterte Felder anzeigen"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "Klicken Sie auf das {0}-Symbol, um zwischen der Übersichtshilfe und der detaillierten Hilfe umzuschalten."
      }
    },
    "messages": {
      "savedTo": {
        "shoppingcart": "Änderungen wurden dem Warenkorb hinzugefügt.",
        "generic": "Änderungen wurden gespeichert.",
        "notSaved": "Keine Speicherung, da keine Änderungen erkannt wurden."
      },
      "action": {
        "notAllowed": {
          "summary": "Aktion nicht zulässig",
          "detail": "Die angeforderte Aktion kann während eines Erstellvorgangs nicht ausgeführt werden. Klicken Sie auf die Schaltfläche \"Abbrechen\", um den Erstellvorgang abzubrechen."
        }
      }
    },
    "icons": {
      "restart": {
        "tooltip": "Neustart von Server oder App erforderlich"
      },
      "wdtIcon": {
        "tooltip": "WDT-Einstellungen"
      }
    }
  },
  "wrc-help-form": {
    "tables": {
      "help": {
        "label": "Hilfetabelle",
        "columns": {
          "header": {
            "name": "Name",
            "description": "Beschreibung"
          }
        }
      }
    },
    "labels": {
      "relatedTopics": {
        "value": "<b>Verwandte Themen:</b>"
      }
    },
    "tabs": {
      "attributes": {
        "label": "Attribute"
      },
      "actions": {
        "label": "Aktionen"
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "Nicht ausgefüllte Pflichtfelder",
        "detail": "{0} ist ein Pflichtfeld, aber es wurde kein Wert (oder ein ungültiger Wert) angegeben."
      }
    }
  },
  "wrc-policy-management": {
    "menus": {
      "action": {
        "addCondition": {
          "label": "Bedingung hinzufügen"
        },
        "combine": {
          "label": "Kombinieren"
        },
        "uncombine": {
          "label": "Kombination aufheben"
        },
        "moveup": {
          "label": "Nach oben"
        },
        "movedown": {
          "label": "Nach unten"
        },
        "remove": {
          "label": "Entfernen"
        },
        "negate": {
          "label": "Negieren"
        },
        "reset": {
          "label": "Zurücksetzen"
        }
      }
    },
    "contextMenus": {
      "action": {
        "addCondition": {
          "at": {
            "label": "Neue erste Bedingung hinzufügen..."
          },
          "above": {
            "label": "Bedingung oberhalb der angeklickten Zeile hinzufügen..."
          },
          "below": {
            "label": "Bedingung unterhalb der angeklickten Zeile hinzufügen..."
          }
        }
      }
    },
    "buttonMenus": {
      "action": {
        "addCondition": {
          "above": {
            "label": "Über ausgewählter Bedingung hinzufügen..."
          },
          "below": {
            "label": "Unter ausgewählter Bedingung hinzufügen..."
          }
        }
      }
    },
    "messages": {
      "requiredFieldsMissing": {
        "detail": "Mindestens ein Pflichtfeld enthält keine Daten."
      },
      "argumentValueHasWrongFormat": {
        "summary": "Feld \"{0}\" enthält falsch formatierte Daten."
      },
      "conditionHasNoArgValues": {
        "summary": "Die ausgewählte Bedingung enthält keine Argumentwerte zum Bearbeiten."
      },
      "conditionAlreadyExists": {
        "summary": "Für diese Sicherheits-Policy wurde bereits eine Bedingung mit dem ausgewählten Prädikat oder mit übereinstimmenden Argumentwerten erstellt."
      }
    },
    "instructions": {
      "policyEditor": {
        "value": "<p>Um den Speicherort der neuen Bedingung anzugeben, setzen Sie ein Häkchen neben die jeweilige Bedingung, und klicken Sie dann auf die Schaltfläche <b>+Bedingung hinzufügen</b>.</p>"
      }
    }
  },
  "wrc-policy-editor": {
    "labels": {
      "monthDay": {
        "value": "Bereich: -31 bis 31"
      },
      "dateTime": {
        "value": "Format: yyyy-MM-dd [HH:mm:ss [AM|PM]] (Beispiel: 2022-02-14 09:00:00 AM)"
      },
      "time": {
        "value": "Format: HH:mm:ss (Beispiel: 14:22:47)"
      },
      "gmtOffset": {
        "value": "Format: GMT+|-h:mm (Beispiel: GMT-5:00)"
      },
      "weekDay": {
        "value": "Beispiel: Sonntag, Montag, Dienstag, ..."
      },
      "or": {
        "value": "oder"
      },
      "not": {
        "value": "NOT"
      },
      "combination": {
        "value": "Kombination"
      },
      "nodata": {
        "Policy": {
          "value": "Verwenden Sie die Schaltfläche <b>+ Bedingung hinzufügen</b>, um eine Policy-Bedingung hinzuzufügen."
        },
        "DefaultPolicy": {
          "value": "Es sind keine standardmäßigen Sicherheits-Policy-Bedingungen definiert."
        }
      }
    },
    "tables": {
      "policyConditions": {
        "columns": {
          "header": {
            "combination": "Kombination",
            "operator": "Operator",
            "expression": "Bedingungsausdruck"
          }
        },
        "dropdowns": {
          "operator": {
            "or": "Oder",
            "and": "Und"
          }
        }
      }
    },
    "wizard": {
      "title": "Policy-Verwaltung",
      "pages": {
        "choosePredicate": {
          "header": {
            "title": "Prädikat auswählen",
            "instructions": "Wählen Sie in der Dropdown-Liste das Prädikat für die neue Bedingung aus."
          },
          "body": {
            "labels": {
              "predicateList": "Prädikatliste"
            },
            "help": {
              "predicateList": "Die Prädikatliste ist eine Liste verfügbarer Prädikate, die zum Erstellen einer Sicherheits-Policy-Bedingung verwendet werden können."
            }
          }
        },
        "manageArgumentValues": {
          "header": {
            "title": "Gruppenprädikat",
            "instructions": "Im Feld <i></i> können Sie neue Argumentwerte hinzufügen oder vorhandene Argumentwerte suchen. Drücken Sie die Eingabetaste, um den eingegebenen Wert der Liste hinzuzufügen. Um einen vorhandenen Argumentwert zu bearbeiten, klicken Sie darauf, und ändern Sie ihn im Popup-Eingabefeld."
          },
          "body": {
            "labels": {
              "conditionPhrase": "Bedingungsausdruck",
              "negate": "Bedingung negieren"
            },
            "help": {
              "negate": "Wandelt die Bedingung in die gegenteilige Bedeutung um (Beispiel: \"gleich\" wird zu \"ungleich\", \"ist in\" wird zu \"ist nicht in\")."
            }
          }
        }
      }
    }
  },
  "wrc-recently-visited": {
    "labels": {
      "tree": {
        "value": "Baum"
      },
      "page": {
        "value": "Seite"
      },
      "tab": {
        "value": "Registerkarte"
      },
      "ariaLabel": {
        "value": "Seitenhistorie"
      }
    },
    "messages": {
      "pageNoLongerExists": {
        "summary": "Seite nicht mehr vorhanden",
        "detail1": "Sie wurden zur Seite {0} umgeleitet, weil ",
        "detail2": "{0} von einem anderen Benutzer gelöscht wurde oder nicht mehr vorhanden ist. "
      }
    }
  },
  "wrc-pages-bookmark": {
    "labels": {
      "ariaLabel": {
        "value": "Seitenlesezeichen"
      }
    },
    "menus": {
      "bookmark": {
        "add": {
          "label": "Lesezeichen für aktuelle Seite hinzufügen"
        },
        "show": {
          "label": "Seitenlesezeichen anzeigen..."
        }
      }
    },
    "messages": {
      "pageAlreadyBookmarked": {
        "summary": "Für diese Seite ist bereits ein Lesezeichen vorhanden. "
      },
      "pagesBookmarkAdded": {
        "summary": "Lesezeichen für aktuelle Seite wurde erfolgreich hinzugefügt. "
      }
    }
  },
  "wrc-common": {
    "ariaLabel": {
      "icons": {
        "landing": {
          "value": "Kehren Sie zur Landingpage des Providerbaums zurück."
        },
        "reset": {
          "value": "Seitenwerte aktualisieren"
        }
      }
    },
    "buttons": {
      "action": {
        "label": "Aktion"
      },
      "apply": {
        "label": "Anwenden"
      },
      "reset": {
        "label": "Zurücksetzen"
      },
      "ok": {
        "label": "OK"
      },
      "cancel": {
        "label": "Abbrechen"
      },
      "restart": {
        "label": "Neu starten"
      },
      "yes": {
        "label": "Ja"
      },
      "no": {
        "label": "Nein"
      },
      "choose": {
        "label": "Auswählen"
      },
      "connect": {
        "label": "Verbinden"
      },
      "add": {
        "label": "Hinzufügen/Senden"
      },
      "edit": {
        "label": "Bearbeiten/Senden"
      },
      "import": {
        "label": "Importieren"
      },
      "export": {
        "label": "Exportieren"
      },
      "write": {
        "label": "Datei herunterladen"
      },
      "savenow": {
        "label": "Jetzt speichern"
      },
      "next": {
        "label": "Weiter"
      },
      "previous": {
        "label": "Vorherige"
      },
      "finish": {
        "label": "Fertigstellen"
      },
      "done": {
        "label": "Fertig"
      },
      "close": {
        "label": "Schließen"
      },
      "clear": {
        "label": "Löschen"
      }
    },
    "tooltips": {
      "collapse": {
        "value": "Ausblenden"
      },
      "expand": {
        "value": "Einblenden"
      },
      "choose": {
        "value": "Datei auswählen"
      },
      "clear": {
        "value": "Ausgewählte Datei löschen"
      },
      "more": {
        "value": "Weitere Aktionen"
      },
      "download": {
        "value": "Durchsuchen"
      },
      "reset": {
        "value": "Zurücksetzen"
      },
      "filter": {
        "value": "Filter"
      },
      "submit": {
        "value": "Änderungen weiterleiten"
      },
      "write": {
        "value": "Datei herunterladen"
      },
      "pick": {
        "value": "Verzeichnis auswählen"
      },
      "reload": {
        "value": "Datei erneut laden"
      },
      "delete": {
        "value": "Löschen"
      },
      "remove": {
        "value": "Entfernen"
      },
      "noData": {
        "value": "Keine Daten"
      },
      "preloader": {
        "value": "Preloader"
      },
      "checkAll": {
        "value": "Alle aktivieren"
      },
      "checkNone": {
        "value": "Alle deaktivieren"
      },
      "checkSome": {
        "value": "Auswahl aufheben"
      },
      "close": {
        "value": "Schließen"
      },
      "recentPages": {
        "value": "Sichtbarkeit der Historie umschalten"
      },
      "pagesHistory": {
        "back": {
          "value": "Vorherige Seite"
        },
        "next": {
          "value": "Nächste Seite"
        },
        "launch": {
          "value": "Seitenhistorie anzeigen"
        },
        "star": {
          "value": "Seitenlesezeichen"
        }
      },
      "pageInfo": {
        "value": "Hier klicken, um zu pinnen und Pinnen aufzuheben"
      }
    },
    "menu": {
      "chooseFile": {
        "value": "Datei auswählen..."
      },
      "chooseDir": {
        "value": "Verzeichnis wählen..."
      }
    },
    "labels": {
      "info": {
        "value": "Informationen"
      },
      "warn": {
        "value": "Warnung"
      },
      "error": {
        "value": "Fehler"
      },
      "alerts": {
        "value": "Alerts"
      },
      "pagesHistory": {
        "value": "Die folgenden Seiten wurden seit Auswahl des aktuellen Providers aufgerufen. Klicken Sie auf eine beliebige Spalte in der Zeile, um zur entsprechenden Seite zu navigieren."
      },
      "pagesBookmark": {
        "value": "Für die folgenden Seiten für den Providertyp {0} wurden Lesezeichen hinzugefügt. Klicken Sie auf eine beliebige Spalte in der Zeile, um zur entsprechenden Seite zu navigieren."
      }
    },
    "placeholders": {
      "search": {
        "value": "Suchen"
      }
    },
    "title": {
      "incorrectFileContent": {
        "value": "Falscher Inhalt erkannt"
      }
    },
    "messages": {
      "incorrectFileContent": {
        "detail": "\"{0}\" enthält JSON, ist aber keine JSON-Darstellung von {1}."
      },
      "dataCopiedToClipboard": {
        "detail": "Daten wurden in die Zwischenablage kopiert."
      },
      "tableCopiedToClipboard": {
        "summary": "Tabelle wurde erfolgreich in die Zwischenablage kopiert."
      },
      "emptyCellData": {
        "detail": "Keine Daten in die Zwischenablage kopiert, da die ausgewählte Zelle leer war."
      },
      "emptyRowData": {
        "detail": "Keine Daten in die Zwischenablage kopiert, da die ausgewählte Zeile leer war."
      },
      "browserPermissionDenied": {
        "summary": "Browserberechtigung verweigert",
        "detail": "Sie müssen das Schreiben in die Zwischenablage aus JavaScript aktivieren, um diesen Vorgang auszuführen. Außerdem wird die Zwischenablage-API nur für HTTPS-Seiten unterstützt."
      }
    },
    "contextMenus": {
      "copyData": {
        "cell": {
          "label": "Zelle in Zwischenablage kopieren"
        },
        "row": {
          "label": "Zeile in Zwischenablage kopieren"
        },
        "tableAsText": {
          "label": "Tabelle in Zwischenablage kopieren (Text)"
        },
        "tableAsJSON": {
          "label": "Tabelle in Zwischenablage kopieren (JSON)"
        },
        "tableAsYAML": {
          "label": "Tabelle in Zwischenablage kopieren (YAML)"
        }
      }
    }
  },
  "wrc-navtree-toolbar": {
    "menu": {
      "collapseAll": {
        "value": "Alle ausblenden"
      },
      "useTreeMenusAsRootNodes": {
        "value": "Baummenüs als Root-Knoten verwenden"
      }
    }
  },
  "wrc-wdt-form": {
    "messages": {
      "changesSaved": {
        "summary": "Änderungen wurden erfolgreich in der Datei \"{0}\" gespeichert."
      },
      "changesNotSaved": {
        "summary": "Änderungen konnten nicht in Datei \"{0}\" gespeichert werden."
      },
      "changesDownloaded": {
        "summary": "Änderungen wurden erfolgreich in Datei \"{0}\" heruntergeladen."
      },
      "changesNotDownloaded": {
        "summary": "Änderungen konnten nicht in Datei \"{0}\" heruntergeladen werden."
      },
      "verifyPathEntered": {
        "detail": ". Wenn Sie das Feld {0} auf \"false\" setzen, wird der eingegebene Wert akzeptiert, ohne zu prüfen, ob er als lokale Datei oder Verzeichnis vorhanden ist."
      }
    },
    "wdtOptionsDialog": {
      "title": "Bearbeiten: {0}",
      "default": "Festlegung für Wert aufheben",
      "instructions": "Geben Sie das Token ein, das der Liste der auswählbaren Elemente hinzugefügt werden soll.",
      "enterValue": "Wert eingeben",
      "selectValue": "Wert auswählen",
      "selectSwitch": "Wert umschalten",
      "enterUnresolvedReference": "Nicht aufgelöste Referenz eingeben",
      "enterModelToken": "Modelltoken eingeben",
      "selectPropsVariable": "Modelltokenvariable auswählen",
      "createPropsVariable": "Modelltokenvariable erstellen",
      "propName": "Variablenname (erforderlich)",
      "propValue": "Variablenwert",
      "enterVariable": "Variable eingeben",
      "variableName": "Variablenname (erforderlich)",
      "variableValue": "Variablenwert",
      "multiSelectUnset": "Wert aus Liste \"Verfügbare Elemente\" auswählen"
    }
  },
  "wrc-unsaved-changes": {
    "titles": {
      "unsavedChanges": {
        "value": "Nicht gespeicherte Änderungen gefunden"
      },
      "changesNeedDownloading": {
        "value": "Änderungen nicht heruntergeladen"
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "Alle nicht gespeicherten Änderungen gehen verloren. Fortfahren?"
        },
        "areYouSure": {
          "value": "Möchten Sie wirklich {0}, ohne Ihre Änderungen zu speichern?"
        },
        "saveBeforeExiting": {
          "value": "Möchten Sie Änderungen vor dem Beenden speichern?"
        },
        "needDownloading": {
          "value": "Ihre Änderungen an \"{0}\" wurden nicht in die Datei heruntergeladen.<br/><br/>Möchten Sie sie herunterladen, bevor Sie fortfahren?"
        }
      },
      "uncommitedCreate": {
        "abandonForm": {
          "value": "Ihre neue Instanz vom Typ \"{0}\" wurde dem WDT-Modell nicht hinzugefügt.<br/><br/>Soll sie vor dem Fortfahren hinzugefügt werden?"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "Intervall für automatisches Neuladen festlegen",
      "instructions": "Wie viele Sekunden möchten Sie für das Intervall zum automatischen Neuladen festlegen?",
      "fields": {
        "interval": {
          "label": "Intervall für automatisches Neuladen:"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "Meldung",
          "detail": "Konsolen-Backend-Aufruf hat die Antwort \"{0}\" beim Versuch generiert, die Aktion \"{1}\" auszuführen"
        },
        "actionNotPerformed": {
          "detail": "Aktion \"{0}\" kann für mindestens eins der aktivierten Elemente nicht ausgeführt werden"
        },
        "actionNotPerformedNoRow": {
          "detail": "Aktion \"{0}\" kann nicht ausgeführt werden"
        },
        "actionSucceeded": {
          "summary": "Die Aktion \"{0}\" wurde erfolgreich ausgeführt."
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "Die genaue Ursache kann nicht bestimmt werden. Hinweise finden Sie in der JavaScript-Konsole."
      }
    }
  },
  "wrc-actions-strip": {
    "dialogs": {
      "cannotBeUndone": {
        "title": "Aktionsbestätigung",
        "prompt": "Aktion \"{0}\" kann nicht rückgängig gemacht werden.<br/><br/>Fortfahren?"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "Verfügbar",
        "chosen": "Ausgewählt"
      }
    },
    "cfe-properties-editor": {
      "labels": {
        "name": "Eigenschaftsname",
        "value": "Eigenschaftswert"
      }
    },
    "cfe-property-list-editor": {
      "labels": {
        "nameHeader": "Eigenschaftsname",
        "valueHeader": "Eigenschaftswert",
        "addButtonTooltip": "Hinzufügen",
        "deleteButtonTooltip": "Löschen"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "{0} anzeigen..."
          },
          "create": {
            "label": "{0} neu erstellen..."
          },
          "edit": {
            "label": "{0} bearbeiten..."
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "Standardwert wiederherstellen"
    },
    "placeholder": {
      "value": "Standard"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "detail": "\"{0}\" ist nicht verfügbar."
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "RUNNING"
      },
      "shutdown": {
        "value": "SHUTDOWN"
      },
      "serverStates": {
        "value": "Serverstatus"
      },
      "systemStatus": {
        "value": "Systemstatus"
      },
      "healthState": {
        "failed": {
          "value": "Nicht erfolgreich"
        },
        "critical": {
          "value": "Kritisch"
        },
        "overloaded": {
          "value": "Überlastet"
        },
        "warning": {
          "value": "Warnung"
        },
        "ok": {
          "value": "OK"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "Zustand der gestarteten Server ab"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "Name"
        },
        "state": {
          "value": "Status"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "Backend ist derzeit nicht erreichbar."
      },
      "connectionMessage": {
        "summary": "Verbindungsmeldung"
      },
      "connectFailed": {
        "detail": "Versuch nicht erfolgreich: "
      },
      "badRequest": {
        "detail": "Die weitergeleitete Datei oder Anforderung konnte nicht verarbeitet werden"
      },
      "invalidCredentials": {
        "detail": "Zugangsdaten für WebLogic-Domain sind nicht gültig"
      },
      "invalidUrl": {
        "detail": "URL der WebLogic-Domain ist nicht erreichbar"
      },
      "notInRole": {
        "detail": "Versuch nicht erfolgreich: Der Benutzer ist kein Admin, Deployer, Operator oder Monitor"
      },
      "notSupported": {
        "detail": "WebLogic-Domain wird nicht unterstützt"
      },
      "unexpectedStatus": {
        "detail": "Unerwartetes Ergebnis (Status: {0})"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "Anforderung nicht erfolgreich",
          "detail": "Eine Fehlerantwort wurde von einem Konsolen-Backend-Aufruf zurückgegeben."
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "Spezifische Gründe finden Sie im Remotekonsolenterminal oder in der JavaScript-Konsole."
      },
      "responseMessages": {
        "summary": "Antwortmeldungen"
      }
    }
  },
  "wrc-confirm-dialogs": {
    "adminServerShutdown": {
      "title": {
        "value": "Bestätigung"
      },
      "prompt": {
        "value": "Durch Herunterfahren von <b>{0}</b> wird der aktuelle Provider zurückgesetzt. Fortfahren?"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "Auf Change Manager kann nicht zugegriffen werden."
      },
      "changesCommitted": {
        "summary": "Änderungen wurden erfolgreich festgeschrieben."
      },
      "changesNotCommitted": {
        "summary": "Änderungen konnten nicht festgeschrieben werden."
      },
      "changesDiscarded": {
        "summary": "Änderungen wurden erfolgreich verworfen."
      },
      "changesNotDiscarded": {
        "summary": "Änderungen konnten nicht verworfen werden."
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "Unerwartete Fehlerantwort"
      }
    },
    "messages": {
      "connectionRefused": {
        "summary": "Verbindungsproblem",
        "details": "Beim Senden und Empfangen von Daten vom Provider treten Probleme auf. Stellen Sie sicher, dass der Provider zugänglich ist, bevor Sie fortfahren."
      },
      "pathNotFound": {
        "summary": "Pfad nicht gefunden",
        "details": "\"{0}\" ist keine Datei oder kein Verzeichnis, auf die/das Sie im lokalen Dateisystem zugreifen können."
      }
    }
  },
  "wrc-message-line": {
    "ariaLabel": {
      "region": {
        "value": "Meldungszeile"
      }
    },
    "menus": {
      "more": {
        "clear": {
          "label": "Meldung löschen"
        },
        "suppress": {
          "info": {
            "label": "Informationsmeldungen unterdrücken"
          },
          "warning": {
            "label": "Warnmeldungen unterdrücken"
          }
        }
      }
    },
    "messages": {
      "adminServerShutdown": {
        "details": " Zum Administrationsserver der WebLogic-Domain kann keine Verbindung hergestellt werden."
      },
      "shutdownSequenceError": {
        "details": "Fahren Sie zuerst die Managed Server und dann den Administrationsserver herunter."
      }
    }
  },
  "wrc-alerts": {
    "menus": {
      "alerts": {
        "error": {
          "value": "Sie haben {0} Alert(s) vom Typ \"Fehler\" mit hoher Priorität"
        },
        "warning": {
          "value": "Sie haben {0} Alert(s) vom Typ \"Warnung\" mit hoher Priorität"
        },
        "info": {
          "value": "Sie haben {0} Alert(s) vom Typ \"Informationen\" mit hoher Priorität"
        },
        "view": {
          "value": "Alerts anzeigen"
        }
      }
    }
  }
});