define({
  "wrc-header": {
    "text": {
      "appName": "[‏‮WebLogic Remote Console‬‏]"
    },
    "keyPairs": {
      "welcome": {
        "label": "[‏‮Welcome, {0}‬‏]"
      },
      "connected": {
        "label": "[‏‮Connect to:‬‏]"
      },
      "disconnected": {
        "label": "[‏‮Not Connected‬‏]"
      }
    },
    "icons": {
      "connectivity": {
        "online": {
          "tooltip": "[‏‮Online‬‏]"
        },
        "offline": {
          "tooltip": "[‏‮Offline‬‏]"
        },
        "detached": {
          "tooltip": "[‏‮Detached‬‏]"
        }
      },
      "connectionType": {
        "nonsecure": {
          "tooltip": "[‏‮Nonsecure‬‏]"
        },
        "secure": {
          "tooltip": "[‏‮Secure‬‏]"
        }
      }
    },
    "buttons": {
      "connect": {
        "label": "[‏‮Connect‬‏]"
      },
      "disconnect": {
        "label": "[‏‮Disconnect‬‏]"
      }
    },
    "menus": {
      "domain": {
        "url": {
          "label": "Domain URL:"
        },
        "version": {
          "label": "Domain Version:"
        }
      }
    }
  },
  "wrc-footer": {
    "text": {
      "copyrightLegal": "[‏‮Copyright Â© 2020, 2024, Oracle and/or its affiliates.<br/>Oracle is a registered trademark of Oracle Corporation and/or its affiliates. Other names may be trademarks of their respective owners.<br/>‬‏]",
      "builtWith": "[‏‮Built with Oracle JET‬‏]"
    }
  },
  "wrc-navstrip": {
    "icons": {
      "configuration": {
        "tooltip": "[‏‮Configuration‬‏]"
      },
      "view": {
        "tooltip": "[‏‮View‬‏]"
      },
      "monitoring": {
        "tooltip": "[‏‮Monitoring‬‏]"
      }
    }
  },
  "wrc-content-area-header": {
    "buttons": {
      "readwrite": {
        "label": "[‏‮Read/Write‬‏]"
      },
      "readonly": {
        "label": "[‏‮Read-Only‬‏]"
      }
    },
    "title": {
      "home": "[‏‮Home‬‏]",
      "configuration": "[‏‮Configuration‬‏]",
      "view": "[‏‮View‬‏]",
      "monitoring": "[‏‮Monitoring‬‏]"
    },
    "toolbar": {
      "buttons": {
        "home": {
          "label": "[‏‮Home‬‏]"
        },
        "preferences": {
          "label": "[‏‮Preferences‬‏]"
        },
        "search": {
          "label": "[‏‮Search‬‏]"
        }
      }
    }
  },
  "wrc-ancillary-content": {
    "tabstrip": {
      "tabs": {
        "shoppingcart": {
          "label": "[‏‮Shopping Cart‬‏]"
        },
        "ataglance": {
          "label": "[‏‮At-A-Glance‬‏]"
        }
      }
    },
    "icons": {
      "kiosk": {
        "tooltip": "[‏‮Kiosk‬‏]"
      },
      "expand": {
        "tooltip": "[‏‮Expand‬‏]"
      },
      "collapse": {
        "tooltip": "[‏‮Collapse‬‏]"
      }
    }
  },
  "wrc-configuration": {
    "icons": {
      "history": {
        "tooltip": "[‏‮History‬‏]"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "[‏‮Clear History‬‏]"
        }
      }
    },
    "messages": {
      "dataNotAvailable": {
        "summary": "[‏‮Data Not Available‬‏]"
      }
    }
  },
  "wrc-monitoring": {
    "icons": {
      "history": {
        "tooltip": "[‏‮History‬‏]"
      }
    },
    "menus": {
      "history": {
        "clear": {
          "value": "[‏‮Clear History‬‏]"
        }
      }
    },
    "messages": {
      "dataNotAvailable": {
        "summary": "[‏‮Data Not Available‬‏]"
      }
    }
  },
  "wrc-domain-connection": {
    "labels": {
      "runningAt": {
        "value": "[‏‮running at {0}‬‏]"
      }
    },
    "messages": {
      "lostConnection": {
        "summary": "[‏‮Lost Connection‬‏]",
        "detail": "[‏‮Unable to connect to the WebLogic Domain {0}, please check that WebLogic is running.‬‏]"
      },
      "cannotConnect": {
        "summary": "[‏‮Connection Attempt Failed‬‏]",
        "detail": "[‏‮Unable to connect to the WebLogic Domain {0}, please check that WebLogic is running.‬‏]"
      }
    },
    "dialog1": {
      "title": "[‏‮Connect to WebLogic Domain‬‏]",
      "instructions": "[‏‮Enter admin user credentials and URL for the WebLogic domain:‬‏]",
      "labels": {
        "url": "[‏‮URL‬‏]"
      },
      "buttons": {
        "connect": {
          "label": "[‏‮Connect‬‏]"
        }
      }
    }
  },
  "wrc-home": {
    "tabstrip": {
      "tabs": {
        "gallery": {
          "label": "[‏‮Gallery‬‏]"
        }
      }
    }
  },
  "wrc-gallery": {
    "cards": {
      "configuration": {
        "label": "[‏‮Configuration‬‏]",
        "description": "[‏‮<p>Maintain configuration of WebLogic domain you are currently working with.</p>‬‏]"
      },
      "view": {
        "label": "[‏‮View‬‏]",
        "description": "[‏‮<p>Examine read-only configuration of WebLogic domain you are currently working with.</p>‬‏]"
      },
      "monitoring": {
        "label": "[‏‮Monitoring‬‏]",
        "description": "[‏‮<p>View runtime MBean information for select resources in WebLogic domain you are currently working with.</p>‬‏]"
      }
    }
  },
  "wrc-shoppingcart": {
    "icons": {
      "discard": {
        "tooltip": "[‏‮Discard Changes‬‏]"
      },
      "commit": {
        "tooltip": "[‏‮Commit Changes‬‏]"
      }
    },
    "sections": {
      "changeManager": {
        "label": "[‏‮Change Manager‬‏]"
      },
      "additions": {
        "label": "[‏‮Additions‬‏]"
      },
      "modifications": {
        "label": "[‏‮Modifications‬‏]"
      },
      "removals": {
        "label": "[‏‮Removals‬‏]"
      },
      "restart": {
        "label": "[‏‮Restart‬‏]"
      }
    }
  },
  "wrc-table-toolbar": {
    "buttons": {
      "new": {
        "label": "[‏‮New‬‏]"
      },
      "clone": {
        "label": "[‏‮Clone‬‏]"
      },
      "delete": {
        "label": "[‏‮Delete‬‏]"
      }
    },
    "icons": {
      "landing": {
        "tooltip": "[‏‮Landing Page‬‏]"
      },
      "history": {
        "tooltip": "[‏‮Toggle visibility of history‬‏]"
      },
      "instructions": {
        "tooltip": "[‏‮Toggle visibility of instructions‬‏]"
      },
      "help": {
        "tooltip": "[‏‮Toggle visibility of Help page‬‏]"
      },
      "sync": {
        "tooltip": "[‏‮Reload‬‏]",
        "tooltipOn": "[‏‮Stop Auto-Reload‬‏]"
      },
      "syncInterval": {
        "tooltip": "[‏‮Set Auto-Reload Interval‬‏]"
      },
      "shoppingcart": {
        "tooltip": "[‏‮Click to view actions for cart‬‏]"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "[‏‮View Changes‬‏]"
        },
        "discard": {
          "label": "[‏‮Discard Changes‬‏]"
        },
        "commit": {
          "label": "[‏‮Commit Changes‬‏]"
        }
      }
    },
    "instructions": {
      "selectItems": {
        "value": "[‏‮Select items you want to perform '{0}' operation on.‬‏]"
      }
    },
    "messages": {
      "action": {
        "cannotPerform": {
          "summary": "[‏‮Message‬‏]",
          "detail": "[‏‮Cannot perform '{0}' action while auto-reload is running! Please click the '{1}' icon to stop it, first.‬‏]"
        }
      }
    },
    "labels": {
      "start": {
        "value": "[‏‮Start‬‏]"
      },
      "resume": {
        "value": "[‏‮Resume‬‏]"
      },
      "suspend": {
        "value": "[‏‮Suspend‬‏]"
      },
      "shutdown": {
        "value": "[‏‮Shutdown‬‏]"
      },
      "restartSSL": {
        "value": "[‏‮Restart SSL‬‏]"
      },
      "stop": {
        "value": "[‏‮Stop‬‏]"
      }
    }
  },
  "wrc-table": {
    "checkboxes": {
      "showHiddenColumns": {
        "label": "[‏‮Show Hidden Columns‬‏]"
      }
    },
    "tables": {
      "label": "[‏‮Help Table‬‏]",
      "columns": {
        "header": {
          "name": "[‏‮Name‬‏]",
          "description": "[‏‮Description‬‏]"
        }
      }
    },
    "actionsDialog": {
      "buttons": {
        "cancel": {
          "label": "[‏‮Cancel‬‏]"
        }
      }
    }
  },
  "wrc-form-toolbar": {
    "buttons": {
      "save": {
        "label": "[‏‮Save‬‏]"
      },
      "new": {
        "label": "[‏‮Create‬‏]"
      },
      "delete": {
        "label": "[‏‮Remove‬‏]"
      },
      "back": {
        "label": "[‏‮Back‬‏]"
      },
      "next": {
        "label": "[‏‮Next‬‏]"
      },
      "finish": {
        "label": "[‏‮Create‬‏]"
      }
    },
    "icons": {
      "save": {
        "tooltip": "[‏‮Save‬‏]"
      },
      "create": {
        "tooltip": "[‏‮Create‬‏]"
      },
      "landing": {
        "tooltip": "[‏‮Landing Page‬‏]"
      },
      "history": {
        "tooltip": "[‏‮Toggle visibility of history‬‏]"
      },
      "instructions": {
        "tooltip": "[‏‮Toggle visibility of instructions‬‏]"
      },
      "help": {
        "tooltip": "[‏‮Toggle visibility of Help page‬‏]"
      },
      "sync": {
        "tooltip": "[‏‮Reload‬‏]",
        "tooltipOn": "[‏‮Stop Auto-Reload‬‏]"
      },
      "syncInterval": {
        "tooltip": "[‏‮Set Auto-Reload Interval‬‏]"
      },
      "shoppingcart": {
        "tooltip": "[‏‮Click to view actions for cart‬‏]"
      }
    },
    "menu": {
      "shoppingcart": {
        "view": {
          "label": "[‏‮View Changes‬‏]"
        },
        "discard": {
          "label": "[‏‮Discard Changes‬‏]"
        },
        "commit": {
          "label": "[‏‮Commit Changes‬‏]"
        }
      }
    }
  },
  "wrc-form": {
    "checkboxes": {
      "showAdvancedFields": {
        "label": "[‏‮Show Advanced Fields‬‏]"
      }
    },
    "introduction": {
      "toggleHelp": {
        "text": "[‏‮Click the {0} icon to toggle between summary and detailed help.‬‏]"
      }
    },
    "messages": {
      "save": "[‏‮Changes added to cart‬‏]"
    },
    "icons": {
      "restart": {
        "tooltip": "[‏‮Server or App Restart Required‬‏]"
      },
      "choose": {
        "tooltip": "[‏‮Choose File‬‏]"
      },
      "clear": {
        "tooltip": "[‏‮Clear Chosen File‬‏]"
      },
      "more": {
        "tooltip": "[‏‮More Actions‬‏]"
      }
    },
    "tables": {
      "label": "[‏‮Help Table‬‏]",
      "columns": {
        "header": {
          "name": "[‏‮Name‬‏]",
          "description": "[‏‮Description‬‏]"
        }
      }
    }
  },
  "wrc-create-form": {
    "pageState": {
      "error": {
        "summary": "[‏‮Incomplete Required Fields‬‏]",
        "detail": "[‏‮{0} field is required, but no value has been provided.‬‏]"
      }
    }
  },
  "wrc-form-layouts": {
    "tooltips": {
      "collapse": {
        "value": "[‏‮Collapse‬‏]"
      },
      "expand": {
        "value": "[‏‮Expand‬‏]"
      }
    }
  },
  "wrc-unsaved-changes": {
    "confirmDialog": {
      "title": "[‏‮Unsaved Changes Detected‬‏]",
      "buttons": {
        "yes": {
          "label": "[‏‮Yes‬‏]"
        },
        "no": {
          "label": "[‏‮No‬‏]"
        }
      }
    },
    "prompts": {
      "unsavedChanges": {
        "willBeLost": {
          "value": "[‏‮All unsaved changes will be lost. Continue?‬‏]"
        },
        "areYouSure": {
          "value": "[‏‮Are you sure you want to exit without saving changes?‬‏]"
        }
      }
    }
  },
  "wrc-sync-interval": {
    "dialogSync": {
      "title": "[‏‮Set Auto-Reload Interval‬‏]",
      "instructions": "[‏‮How many seconds do you want for the auto-reloading interval?‬‏]",
      "fields": {
        "interval": {
          "label": "[‏‮Auto-Reload Interval:‬‏]"
        }
      },
      "buttons": {
        "ok": {
          "label": "[‏‮OK‬‏]"
        },
        "cancel": {
          "label": "[‏‮Cancel‬‏]"
        }
      }
    }
  },
  "wrc-pdj-actions": {
    "messages": {
      "action": {
        "unableToPerform": {
          "summary": "[‏‮Message‬‏]",
          "detail": "[‏‮Cannot perform '{0}' action while auto-reload is running! Please click the '{1}' icon to stop it, first.‬‏]"
        }
      }
    },
    "labels": {
      "cannotDetermineExactCause": {
        "value": "[‏‮Cannot determine exact cause. Check JavaScript Console for hints.‬‏]"
      }
    }
  },
  "wrc-pdj-fields": {
    "cfe-multi-select": {
      "labels": {
        "available": "[‏‮Available‬‏]",
        "chosen": "[‏‮Chosen‬‏]"
      }
    }
  },
  "wrc-pdj-options-sources": {
    "menus": {
      "more": {
        "optionsSources": {
          "view": {
            "label": "[‏‮View {0}...‬‏]"
          },
          "create": {
            "label": "[‏‮Create New {0}...‬‏]"
          },
          "edit": {
            "label": "[‏‮Edit {0}...‬‏]"
          }
        }
      }
    }
  },
  "wrc-pdj-unset": {
    "menu": {
      "label": "[‏‮Restore to default‬‏]"
    },
    "placeholder": {
      "value": "[‏‮default‬‏]"
    }
  },
  "wrc-pdj-crosslinks": {
    "messages": {
      "noNotFoundMessage": {
        "summary": "[‏‮Message‬‏]",
        "detail": "[‏‮RDJ did not contain a 'notFoundMessage' field for the '{0}' item.‬‏]"
      }
    }
  },
  "wrc-ataglance": {
    "labels": {
      "running": {
        "value": "[‏‮RUNNING‬‏]"
      },
      "shutdown": {
        "value": "[‏‮SHUTDOWN‬‏]"
      },
      "serverStates": {
        "value": "[‏‮Server States‬‏]"
      },
      "systemStatus": {
        "value": "[‏‮System Status‬‏]"
      },
      "healthState": {
        "failed": {
          "value": "[‏‮Failed‬‏]"
        },
        "critical": {
          "value": "[‏‮Critical‬‏]"
        },
        "overloaded": {
          "value": "[‏‮Overloaded‬‏]"
        },
        "warning": {
          "value": "[‏‮Warning‬‏]"
        },
        "ok": {
          "value": "[‏‮OK‬‏]"
        }
      }
    },
    "descriptions": {
      "healthState": {
        "value": "[‏‮Health of Running Servers as of‬‏]"
      }
    },
    "headers": {
      "serverStates": {
        "name": {
          "value": "[‏‮Name‬‏]"
        },
        "state": {
          "value": "[‏‮State‬‏]"
        }
      }
    }
  },
  "wrc-data-operations": {
    "messages": {
      "backendNotReachable": {
        "detail": "[‏‮Backend not currently reachable.‬‏]"
      },
      "connectionMessage": {
        "summary": "[‏‮Connection Message‬‏]"
      },
      "connectFailed": {
        "detail": "[‏‮Connect Failed: ‬‏]"
      },
      "badRequest": {
        "detail": "[‏‮Please supply the WebLogic Domain URL and credentials ‬‏]"
      },
      "invalidCredentials": {
        "detail": "[‏‮WebLogic Domain credentials are not valid ‬‏]"
      },
      "invalidUrl": {
        "detail": "[‏‮WebLogic Domain URL is not reachable ‬‏]"
      },
      "notSupported": {
        "detail": "[‏‮WebLogic Domain is not supported ‬‏]"
      },
      "unexpectedStatus": {
        "detail": "[‏‮Unexpected result (status: {0}) ‬‏]"
      },
      "cbeRestApi": {
        "requestUnsuccessful": {
          "summary": "[‏‮Request Unsuccessful‬‏]",
          "detail": "[‏‮A non-successful response was returned from a console backend call.‬‏]"
        }
      }
    }
  },
  "wrc-message-displaying": {
    "messages": {
      "seeJavascriptConsole": {
        "detail": "[‏‮See remote console terminal or Javascript console for specific reason(s).‬‏]"
      },
      "responseMessages": {
        "summary": "[‏‮Response Messages‬‏]"
      }
    }
  },
  "wrc-change-manager": {
    "messages": {
      "cannotGetLockState": {
        "summary": "[‏‮Unable to access change manager!‬‏]"
      },
      "changesCommitted": {
        "summary": "[‏‮Changes were successfully committed!‬‏]"
      },
      "changesNotCommitted": {
        "summary": "[‏‮Unable to commit changes!‬‏]"
      },
      "changesDiscarded": {
        "summary": "[‏‮Changes were successfully discarded!‬‏]"
      },
      "changesNotDiscarded": {
        "summary": "[‏‮Unable to discard changes!‬‏]"
      }
    }
  },
  "wrc-view-model-utils": {
    "labels": {
      "unexpectedErrorResponse": {
        "value": "[‏‮Unexpected Error Response‬‏]"
      }
    }
  }
});