/**
 * @license
 * Copyright (c) 2020, 2025, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 * @ignore
 */
'use strict';

/**
 * Example of Require.js boostrap javascript
 */

(function () {
  // noinspection ES6ModulesDependencies
  requirejs.config(
    {
      baseUrl: 'js',

      paths:
      /* DO NOT MODIFY
      ** All paths are dynamicaly generated from the path_mappings.json file.
      ** Add any new library dependencies in path_mappings json file.
      */
// injector:mainReleasePaths

{
  "knockout":"libs/knockout/knockout-3.5.1.debug",
  "jquery":"libs/jquery/jquery-3.7.1",
  "jqueryui-amd":"libs/jquery/jqueryui-amd-1.14.1",
  "hammerjs":"libs/hammer/hammer-2.0.8",
  "ojdnd":"libs/dnd-polyfill/dnd-polyfill-1.0.2",
  "ojs":"libs/oj/17.1.7/debug",
  "ojL10n":"libs/oj/17.1.7/ojL10n",
  "ojtranslations":"libs/oj/17.1.7/resources",
  "@oracle/oraclejet-preact":"libs/oraclejet-preact/amd",
  "oj-c":"libs/packs/oj-c",
  "persist":"libs/persist/debug",
  "text":"libs/require/text",
  "signals":"libs/js-signals/signals",
  "touchr":"libs/touchr/touchr",
  "preact":"libs/preact/dist/preact.umd",
  "preact/hooks":"libs/preact/hooks/dist/hooks.umd",
  "preact/compat":"libs/preact/compat/dist/compat.umd",
  "preact/jsx-runtime":"libs/preact/jsx-runtime/dist/jsxRuntime.umd",
  "preact/debug":"libs/preact/debug/dist/debug.umd",
  "preact/devtools":"libs/preact/devtools/dist/devtools.umd",
  "proj4":"libs/proj4js/dist/proj4-src",
  "css":"libs/require-css/css",
  "ojcss":"libs/oj/17.1.7/debug/ojcss",
  "ojs/ojcss":"libs/oj/17.1.7/debug/ojcss",
  "chai":"libs/chai/chai",
  "js-yaml":"libs/js-yaml/js-yaml",
  "css-builder":"libs/require-css/css-builder",
  "normalize":"libs/require-css/normalize",
  "ojs/normalize":"libs/require-css/normalize",
  "jet-composites":"jet-composites",
  "cfe-breadcrumbs":"jet-composites/cfe-breadcrumbs/1.0.0",
  "cfe-multi-select":"jet-composites/cfe-multi-select/1.0.0",
  "cfe-navtree":"jet-composites/cfe-navtree/1.0.0",
  "cfe-policy-editor":"jet-composites/cfe-policy-editor/1.0.0",
  "cfe-property-list-editor":"jet-composites/cfe-property-list-editor/1.0.0",
  "wdt-model-designer":"jet-composites/wdt-model-designer/1.0.0",
  "wrc-frontend":"jet-composites/wrc-frontend/1.0.0"
}

// endinjector
      , config: {
        ojL10n: {
          merge: {
            'ojtranslations/nls/ojtranslations': 'resources/nls/frontend'
          }
        }
      }
    }
  );
}());

/**
 * A top-level require call executed by the Application.
 * Although 'ojcore' and 'knockout' would be loaded in any case (they are specified as dependencies
 * by the modules themselves), we are listing them explicitly to get the references to the 'oj' and 'ko'
 * objects in the callback.
 *
 * We include the Runtime module (which is associated with our frontend JET web application, not the JET
 * template) in the require list, because the Runtime module reads the src/config/console-frontend-jet.yaml
 * file to set the default logging level used by ojs/ojlogger. We configure our frontend JET web application
 * to use that instead of the built-in console.log mechanism.
 *
 * The console-project-manager.js module is preloaded to trigger the reading of the "wrc-projects"
 * localStorage object.
 */
require(['ojs/ojcore', 'ojs/ojbootstrap', 'ojs/ojconfig', 'ojs/ojcspexpressionevaluator', 'knockout', 'appController', 'ojs/ojrouter', 'wrc-frontend/core/runtime', 'wrc-frontend/microservices/project-management/console-project-manager',
    'ojs/ojknockout', 'ojs/ojnavigationlist'],
  function (oj, Bootstrap, Config, CspExpressionEvaluator, ko, app, Router, Runtime) {
    // this callback gets executed when all required modules are loaded
    Bootstrap.whenDocumentReady().then(
      function() {

        function init() {
          // Set the HTTP Content-Security-Policy expression evaluator
          Config.setExpressionEvaluator(new CspExpressionEvaluator());

          Router.sync()
          .then(() => {
            app.loadModule();
            // Bind your ViewModel for the content of the whole page body.
            ko.applyBindings(app, document.getElementById('globalBody'));
          });

          oj.Logger.option('level', Runtime.getLoggingLevel());
        }

        // If running in a hybrid (e.g. Cordova) environment, we need to wait for the deviceready
        // event before executing any code that might interact with Cordova APIs or plugins.
        if (document.body.classList.contains('oj-hybrid')) {
          document.addEventListener('deviceready', init);
        }
        else {
          init();
        }
      });
  }
);
