import { ValidationResult } from 'oj-c/editable-value/UNSAFE_useValidators/useValidators';
import { Optional } from 'oj-c/select-common/utils/utils';
import { ItemContext } from 'ojs/ojcommontypes';
import { DataProvider } from 'ojs/ojdataprovider';
import { Dispatch, StateUpdater } from 'preact/hooks';
type Value<K> = Optional<K>;
type ValueItem<K, D> = Optional<ItemContext<K, D>>;
export type UseSyncValueAndValueItemProps<K, D> = {
    addBusyState: (desc?: string) => () => void;
    dataProvider?: Optional<DataProvider<K, D>>;
    setDisplayValue: Dispatch<StateUpdater<Value<K>>>;
    setIsLoading: Dispatch<StateUpdater<boolean>>;
    setValue: Dispatch<StateUpdater<Value<K>>>;
    setValueItem: (value: ValueItem<K, D>) => void;
    value?: Value<K>;
    valueItem?: ValueItem<K, D>;
    validateValueOnExternalChange: (value: Value<K>) => ValidationResult;
};
export declare function useSyncValueAndValueItem<K extends string | number, D extends Record<string, any>>({ addBusyState, dataProvider, setDisplayValue, setIsLoading, setValue, setValueItem, value, valueItem, validateValueOnExternalChange }: UseSyncValueAndValueItemProps<K, D>): void;
export {};
