import { JetElement, JetSettableProperties, JetElementCustomEventStrict, JetSetPropertyType } from 'ojs/index';
import 'ojs/oj-jsx-interfaces';
import { NumberInputText as PreactNumberInputText } from '@oracle/oraclejet-preact/UNSAFE_NumberInputText';
import { DisplayOptions, Help, HelpHints } from 'oj-c/editable-value/UNSAFE_useAssistiveText/useAssistiveText';
import Converter = require('ojs/ojconverter');
import Validator = require('ojs/ojvalidator');
import AsyncValidator = require('ojs/ojvalidator-async');
import { ExtendGlobalProps, GlobalProps, ObservedGlobalProps, PropertyChanged, ReadOnlyPropertyChanged } from 'ojs/ojvcomponent';
import { ComponentProps, ComponentType, Ref } from 'preact';
import { Size } from '@oracle/oraclejet-preact/utils/UNSAFE_size';
import { LayoutColumnSpan } from '@oracle/oraclejet-preact/utils/UNSAFE_styles/Layout';
import 'css!oj-c/input-number/input-number-styles.css';
type PreactNumberInputTextProps = ComponentProps<typeof PreactNumberInputText>;
type ValidState = 'valid' | 'pending' | 'invalidHidden' | 'invalidShown';
type Props = ObservedGlobalProps<'aria-describedby' | 'id'> & {
    autocomplete?: 'on' | 'off' | string;
    autofocus?: GlobalProps['autofocus'];
    columnSpan?: LayoutColumnSpan;
    containerReadonly?: boolean;
    converter?: Converter<number> | null;
    disabled?: boolean;
    displayOptions?: DisplayOptions;
    help?: Help;
    helpHints?: HelpHints;
    inputPrefix?: PreactNumberInputTextProps['prefix'];
    inputSuffix?: PreactNumberInputTextProps['suffix'];
    labelEdge?: PreactNumberInputTextProps['labelEdge'];
    labelHint: string;
    labelStartWidth?: Size;
    labelWrapping?: 'truncate' | 'wrap';
    max?: number | null;
    min?: number | null;
    messagesCustom?: PreactNumberInputTextProps['messages'];
    numberRangeExactMessageDetail?: string;
    numberRangeOverflowMessageDetail?: string;
    numberRangeUnderflowMessageDetail?: string;
    placeholder?: string;
    readonly?: boolean;
    required?: boolean;
    requiredMessageDetail?: string;
    step?: number;
    stepperVariant?: PreactNumberInputTextProps['stepperVariant'];
    textAlign?: PreactNumberInputTextProps['textAlign'];
    userAssistanceDensity?: PreactNumberInputTextProps['userAssistanceDensity'];
    validators?: (AsyncValidator<number> | Validator<number>)[] | null;
    value?: number | null;
    virtualKeyboard?: PreactNumberInputTextProps['virtualKeyboard'];
    onMessagesCustomChanged?: PropertyChanged<PreactNumberInputTextProps['messages']>;
    onRawValueChanged?: ReadOnlyPropertyChanged<string>;
    onTransientValueChanged?: ReadOnlyPropertyChanged<number>;
    onValidChanged?: ReadOnlyPropertyChanged<ValidState>;
    onValueChanged?: PropertyChanged<number>;
};
type InputNumberHandle = {
    blur: () => void;
    focus: () => void;
    showMessages: () => void;
    reset: () => void;
    validate: () => Promise<'valid' | 'invalid'>;
};
declare const InputNumberImpl: ({ autocomplete, columnSpan, converter, containerReadonly: propContainerReadonly, disabled, displayOptions, help, helpHints, id, labelWrapping: propLabelWrapping, messagesCustom, readonly: propReadonly, required, stepperVariant, userAssistanceDensity: propUserAssistanceDensity, validators, virtualKeyboard, value, ...otherProps }: Props, ref: Ref<InputNumberHandle>) => import("preact").JSX.Element;
export declare const InputNumber: ComponentType<ExtendGlobalProps<ComponentProps<typeof InputNumberImpl>>>;
export type InputNumberProps = Props;
export {};
export interface CInputNumberElement extends JetElement<CInputNumberElementSettableProperties>, CInputNumberElementSettableProperties {
    readonly rawValue?: Parameters<Required<Props>['onRawValueChanged']>[0];
    readonly transientValue?: Parameters<Required<Props>['onTransientValueChanged']>[0];
    readonly valid?: Parameters<Required<Props>['onValidChanged']>[0];
    addEventListener<T extends keyof CInputNumberElementEventMap>(type: T, listener: (this: HTMLElement, ev: CInputNumberElementEventMap[T]) => any, options?: (boolean | AddEventListenerOptions)): void;
    addEventListener(type: string, listener: EventListenerOrEventListenerObject, options?: (boolean | AddEventListenerOptions)): void;
    getProperty<T extends keyof CInputNumberElementSettableProperties>(property: T): CInputNumberElement[T];
    getProperty(property: string): any;
    setProperty<T extends keyof CInputNumberElementSettableProperties>(property: T, value: CInputNumberElementSettableProperties[T]): void;
    setProperty<T extends string>(property: T, value: JetSetPropertyType<T, CInputNumberElementSettableProperties>): void;
    setProperties(properties: CInputNumberElementSettablePropertiesLenient): void;
    blur: () => void;
    focus: () => void;
    reset: () => void;
    showMessages: () => void;
    validate: () => Promise<'invalid' | 'valid'>;
}
export namespace CInputNumberElement {
    type autocompleteChanged = JetElementCustomEventStrict<CInputNumberElement['autocomplete']>;
    type columnSpanChanged = JetElementCustomEventStrict<CInputNumberElement['columnSpan']>;
    type containerReadonlyChanged = JetElementCustomEventStrict<CInputNumberElement['containerReadonly']>;
    type converterChanged = JetElementCustomEventStrict<CInputNumberElement['converter']>;
    type disabledChanged = JetElementCustomEventStrict<CInputNumberElement['disabled']>;
    type displayOptionsChanged = JetElementCustomEventStrict<CInputNumberElement['displayOptions']>;
    type helpChanged = JetElementCustomEventStrict<CInputNumberElement['help']>;
    type helpHintsChanged = JetElementCustomEventStrict<CInputNumberElement['helpHints']>;
    type inputPrefixChanged = JetElementCustomEventStrict<CInputNumberElement['inputPrefix']>;
    type inputSuffixChanged = JetElementCustomEventStrict<CInputNumberElement['inputSuffix']>;
    type labelEdgeChanged = JetElementCustomEventStrict<CInputNumberElement['labelEdge']>;
    type labelHintChanged = JetElementCustomEventStrict<CInputNumberElement['labelHint']>;
    type labelStartWidthChanged = JetElementCustomEventStrict<CInputNumberElement['labelStartWidth']>;
    type labelWrappingChanged = JetElementCustomEventStrict<CInputNumberElement['labelWrapping']>;
    type maxChanged = JetElementCustomEventStrict<CInputNumberElement['max']>;
    type messagesCustomChanged = JetElementCustomEventStrict<CInputNumberElement['messagesCustom']>;
    type minChanged = JetElementCustomEventStrict<CInputNumberElement['min']>;
    type numberRangeExactMessageDetailChanged = JetElementCustomEventStrict<CInputNumberElement['numberRangeExactMessageDetail']>;
    type numberRangeOverflowMessageDetailChanged = JetElementCustomEventStrict<CInputNumberElement['numberRangeOverflowMessageDetail']>;
    type numberRangeUnderflowMessageDetailChanged = JetElementCustomEventStrict<CInputNumberElement['numberRangeUnderflowMessageDetail']>;
    type placeholderChanged = JetElementCustomEventStrict<CInputNumberElement['placeholder']>;
    type rawValueChanged = JetElementCustomEventStrict<CInputNumberElement['rawValue']>;
    type readonlyChanged = JetElementCustomEventStrict<CInputNumberElement['readonly']>;
    type requiredChanged = JetElementCustomEventStrict<CInputNumberElement['required']>;
    type requiredMessageDetailChanged = JetElementCustomEventStrict<CInputNumberElement['requiredMessageDetail']>;
    type stepChanged = JetElementCustomEventStrict<CInputNumberElement['step']>;
    type stepperVariantChanged = JetElementCustomEventStrict<CInputNumberElement['stepperVariant']>;
    type textAlignChanged = JetElementCustomEventStrict<CInputNumberElement['textAlign']>;
    type transientValueChanged = JetElementCustomEventStrict<CInputNumberElement['transientValue']>;
    type userAssistanceDensityChanged = JetElementCustomEventStrict<CInputNumberElement['userAssistanceDensity']>;
    type validChanged = JetElementCustomEventStrict<CInputNumberElement['valid']>;
    type validatorsChanged = JetElementCustomEventStrict<CInputNumberElement['validators']>;
    type valueChanged = JetElementCustomEventStrict<CInputNumberElement['value']>;
    type virtualKeyboardChanged = JetElementCustomEventStrict<CInputNumberElement['virtualKeyboard']>;
}
export interface CInputNumberElementEventMap extends HTMLElementEventMap {
    'autocompleteChanged': JetElementCustomEventStrict<CInputNumberElement['autocomplete']>;
    'columnSpanChanged': JetElementCustomEventStrict<CInputNumberElement['columnSpan']>;
    'containerReadonlyChanged': JetElementCustomEventStrict<CInputNumberElement['containerReadonly']>;
    'converterChanged': JetElementCustomEventStrict<CInputNumberElement['converter']>;
    'disabledChanged': JetElementCustomEventStrict<CInputNumberElement['disabled']>;
    'displayOptionsChanged': JetElementCustomEventStrict<CInputNumberElement['displayOptions']>;
    'helpChanged': JetElementCustomEventStrict<CInputNumberElement['help']>;
    'helpHintsChanged': JetElementCustomEventStrict<CInputNumberElement['helpHints']>;
    'inputPrefixChanged': JetElementCustomEventStrict<CInputNumberElement['inputPrefix']>;
    'inputSuffixChanged': JetElementCustomEventStrict<CInputNumberElement['inputSuffix']>;
    'labelEdgeChanged': JetElementCustomEventStrict<CInputNumberElement['labelEdge']>;
    'labelHintChanged': JetElementCustomEventStrict<CInputNumberElement['labelHint']>;
    'labelStartWidthChanged': JetElementCustomEventStrict<CInputNumberElement['labelStartWidth']>;
    'labelWrappingChanged': JetElementCustomEventStrict<CInputNumberElement['labelWrapping']>;
    'maxChanged': JetElementCustomEventStrict<CInputNumberElement['max']>;
    'messagesCustomChanged': JetElementCustomEventStrict<CInputNumberElement['messagesCustom']>;
    'minChanged': JetElementCustomEventStrict<CInputNumberElement['min']>;
    'numberRangeExactMessageDetailChanged': JetElementCustomEventStrict<CInputNumberElement['numberRangeExactMessageDetail']>;
    'numberRangeOverflowMessageDetailChanged': JetElementCustomEventStrict<CInputNumberElement['numberRangeOverflowMessageDetail']>;
    'numberRangeUnderflowMessageDetailChanged': JetElementCustomEventStrict<CInputNumberElement['numberRangeUnderflowMessageDetail']>;
    'placeholderChanged': JetElementCustomEventStrict<CInputNumberElement['placeholder']>;
    'rawValueChanged': JetElementCustomEventStrict<CInputNumberElement['rawValue']>;
    'readonlyChanged': JetElementCustomEventStrict<CInputNumberElement['readonly']>;
    'requiredChanged': JetElementCustomEventStrict<CInputNumberElement['required']>;
    'requiredMessageDetailChanged': JetElementCustomEventStrict<CInputNumberElement['requiredMessageDetail']>;
    'stepChanged': JetElementCustomEventStrict<CInputNumberElement['step']>;
    'stepperVariantChanged': JetElementCustomEventStrict<CInputNumberElement['stepperVariant']>;
    'textAlignChanged': JetElementCustomEventStrict<CInputNumberElement['textAlign']>;
    'transientValueChanged': JetElementCustomEventStrict<CInputNumberElement['transientValue']>;
    'userAssistanceDensityChanged': JetElementCustomEventStrict<CInputNumberElement['userAssistanceDensity']>;
    'validChanged': JetElementCustomEventStrict<CInputNumberElement['valid']>;
    'validatorsChanged': JetElementCustomEventStrict<CInputNumberElement['validators']>;
    'valueChanged': JetElementCustomEventStrict<CInputNumberElement['value']>;
    'virtualKeyboardChanged': JetElementCustomEventStrict<CInputNumberElement['virtualKeyboard']>;
}
export interface CInputNumberElementSettableProperties extends JetSettableProperties {
    autocomplete?: Props['autocomplete'];
    columnSpan?: Props['columnSpan'];
    containerReadonly?: Props['containerReadonly'];
    converter?: Props['converter'];
    disabled?: Props['disabled'];
    displayOptions?: Props['displayOptions'];
    help?: Props['help'];
    helpHints?: Props['helpHints'];
    inputPrefix?: Props['inputPrefix'];
    inputSuffix?: Props['inputSuffix'];
    labelEdge?: Props['labelEdge'];
    labelHint: Props['labelHint'];
    labelStartWidth?: Props['labelStartWidth'];
    labelWrapping?: Props['labelWrapping'];
    max?: Props['max'];
    messagesCustom?: Props['messagesCustom'];
    min?: Props['min'];
    numberRangeExactMessageDetail?: Props['numberRangeExactMessageDetail'];
    numberRangeOverflowMessageDetail?: Props['numberRangeOverflowMessageDetail'];
    numberRangeUnderflowMessageDetail?: Props['numberRangeUnderflowMessageDetail'];
    placeholder?: Props['placeholder'];
    readonly?: Props['readonly'];
    required?: Props['required'];
    requiredMessageDetail?: Props['requiredMessageDetail'];
    step?: Props['step'];
    stepperVariant?: Props['stepperVariant'];
    textAlign?: Props['textAlign'];
    userAssistanceDensity?: Props['userAssistanceDensity'];
    validators?: Props['validators'];
    value?: Props['value'];
    virtualKeyboard?: Props['virtualKeyboard'];
}
export interface CInputNumberElementSettablePropertiesLenient extends Partial<CInputNumberElementSettableProperties> {
    [key: string]: any;
}
export interface InputNumberIntrinsicProps extends Partial<Readonly<CInputNumberElementSettableProperties>>, GlobalProps, Pick<preact.JSX.HTMLAttributes, 'ref' | 'key'> {
    rawValue?: never;
    transientValue?: never;
    valid?: never;
    onautocompleteChanged?: (value: CInputNumberElementEventMap['autocompleteChanged']) => void;
    oncolumnSpanChanged?: (value: CInputNumberElementEventMap['columnSpanChanged']) => void;
    oncontainerReadonlyChanged?: (value: CInputNumberElementEventMap['containerReadonlyChanged']) => void;
    onconverterChanged?: (value: CInputNumberElementEventMap['converterChanged']) => void;
    ondisabledChanged?: (value: CInputNumberElementEventMap['disabledChanged']) => void;
    ondisplayOptionsChanged?: (value: CInputNumberElementEventMap['displayOptionsChanged']) => void;
    onhelpChanged?: (value: CInputNumberElementEventMap['helpChanged']) => void;
    onhelpHintsChanged?: (value: CInputNumberElementEventMap['helpHintsChanged']) => void;
    oninputPrefixChanged?: (value: CInputNumberElementEventMap['inputPrefixChanged']) => void;
    oninputSuffixChanged?: (value: CInputNumberElementEventMap['inputSuffixChanged']) => void;
    onlabelEdgeChanged?: (value: CInputNumberElementEventMap['labelEdgeChanged']) => void;
    onlabelHintChanged?: (value: CInputNumberElementEventMap['labelHintChanged']) => void;
    onlabelStartWidthChanged?: (value: CInputNumberElementEventMap['labelStartWidthChanged']) => void;
    onlabelWrappingChanged?: (value: CInputNumberElementEventMap['labelWrappingChanged']) => void;
    onmaxChanged?: (value: CInputNumberElementEventMap['maxChanged']) => void;
    onmessagesCustomChanged?: (value: CInputNumberElementEventMap['messagesCustomChanged']) => void;
    onminChanged?: (value: CInputNumberElementEventMap['minChanged']) => void;
    onnumberRangeExactMessageDetailChanged?: (value: CInputNumberElementEventMap['numberRangeExactMessageDetailChanged']) => void;
    onnumberRangeOverflowMessageDetailChanged?: (value: CInputNumberElementEventMap['numberRangeOverflowMessageDetailChanged']) => void;
    onnumberRangeUnderflowMessageDetailChanged?: (value: CInputNumberElementEventMap['numberRangeUnderflowMessageDetailChanged']) => void;
    onplaceholderChanged?: (value: CInputNumberElementEventMap['placeholderChanged']) => void;
    onrawValueChanged?: (value: CInputNumberElementEventMap['rawValueChanged']) => void;
    onreadonlyChanged?: (value: CInputNumberElementEventMap['readonlyChanged']) => void;
    onrequiredChanged?: (value: CInputNumberElementEventMap['requiredChanged']) => void;
    onrequiredMessageDetailChanged?: (value: CInputNumberElementEventMap['requiredMessageDetailChanged']) => void;
    onstepChanged?: (value: CInputNumberElementEventMap['stepChanged']) => void;
    onstepperVariantChanged?: (value: CInputNumberElementEventMap['stepperVariantChanged']) => void;
    ontextAlignChanged?: (value: CInputNumberElementEventMap['textAlignChanged']) => void;
    ontransientValueChanged?: (value: CInputNumberElementEventMap['transientValueChanged']) => void;
    onuserAssistanceDensityChanged?: (value: CInputNumberElementEventMap['userAssistanceDensityChanged']) => void;
    onvalidChanged?: (value: CInputNumberElementEventMap['validChanged']) => void;
    onvalidatorsChanged?: (value: CInputNumberElementEventMap['validatorsChanged']) => void;
    onvalueChanged?: (value: CInputNumberElementEventMap['valueChanged']) => void;
    onvirtualKeyboardChanged?: (value: CInputNumberElementEventMap['virtualKeyboardChanged']) => void;
}
declare global {
    namespace preact.JSX {
        interface IntrinsicElements {
            'oj-c-input-number': InputNumberIntrinsicProps;
        }
    }
}
