define(["require", "exports", "ojs/ojlogger"], function (require, exports, Logger) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.sumBadge = void 0;
    function sumBadge(items) {
        return items.reduce((total, item) => {
            if (!item.badge) {
                return total;
            }
            const num = Number(item.badge);
            if (!Number.isInteger(num)) {
                Logger.warn(`Tab item with itemKey '${item.itemKey}' provided a badge of '${item.badge}', expected integer`);
                return total;
            }
            if (num < 0) {
                Logger.warn(`Tab item with itemKey '${item.itemKey}' provided a negative numerical badge value of '${item.badge}', expected positive integer. This will be discarded from total.`);
                return total;
            }
            return total + item.badge;
        }, 0);
    }
    exports.sumBadge = sumBadge;
});
