import { By } from 'selenium-webdriver';
import { DriverLike } from '@oracle/oraclejet-webdriver';
import { LineChartWebElement } from './LineChartWebElement';
export { LineChartWebElement };
/**
 * Retrieve an instance of [LineChartWebElement](../classes/LineChartWebElement.html).
 * @example
 * ```javascript
 * import { findLineChart } from '@oracle/oraclejet-core-pack/webdriver';
 * const el = await findLineChart(driver, By.id('my-oj-c-line-chart'));
 * ```
 * @param driver A WebDriver/WebElement instance from where the element will be
 * searched. If WebDriver is passed, the element will be searched globally in the
 * document. If WebElement is passed, the search will be relative to this element.
 * @param by The locator with which to find the element
 */
export declare function findLineChart(driver: DriverLike, by: By): Promise<LineChartWebElement>;
