import { By } from 'selenium-webdriver';
import { DriverLike } from '@oracle/oraclejet-webdriver';
import { AvatarWebElement } from './AvatarWebElement';
export { AvatarWebElement };
/**
 * Retrieve an instance of [AvatarWebElement](../classes/AvatarWebElement.html).
 * @example
 * ```javascript
 * import { findAvatar } from '@oracle/oraclejet-core-pack/webdriver';
 * const el = await findAvatar(driver, By.id('my-oj-c-avatar'));
 * ```
 * @param driver A WebDriver/WebElement instance from where the element will be
 * searched. If WebDriver is passed, the element will be searched globally in the
 * document. If WebElement is passed, the search will be relative to this element.
 * @param by The locator with which to find the element
 */
export declare function findAvatar(driver: DriverLike, by: By): Promise<AvatarWebElement>;
