/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.server;

import io.helidon.microprofile.server.RoutingName;
import io.helidon.microprofile.server.RoutingPath;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;

public final class JaxRsApplication {
    private final String contextRoot;
    private final ResourceConfig config;
    private final ExecutorService executorService;
    private final String appName;
    private final String appClassName;
    private final String routingName;
    private final boolean routingNameRequired;
    private final Class<? extends Application> appClass;
    private final boolean synthetic;

    public static JaxRsApplication create(Class<? extends Application> application) {
        return JaxRsApplication.builder().application(application).build();
    }

    public static JaxRsApplication create(Application application) {
        return JaxRsApplication.builder().application(application).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private JaxRsApplication(Builder builder) {
        this.contextRoot = builder.contextRoot;
        this.config = builder.config;
        this.executorService = builder.executorService;
        this.appClassName = builder.appClassName;
        this.routingName = builder.routingName;
        this.routingNameRequired = builder.routingNameRequired;
        this.appName = builder.appName;
        this.appClass = builder.appClass;
        this.synthetic = builder.synthetic;
    }

    public String toString() {
        return "JAX-RS Application: " + this.appName;
    }

    Optional<String> contextRoot() {
        return Optional.ofNullable(this.contextRoot);
    }

    public ResourceConfig resourceConfig() {
        return this.config;
    }

    public boolean synthetic() {
        return this.synthetic;
    }

    Optional<ExecutorService> executorService() {
        return Optional.ofNullable(this.executorService);
    }

    String appClassName() {
        return this.appClassName;
    }

    Optional<String> routingName() {
        return Optional.ofNullable(this.routingName);
    }

    boolean routingNameRequired() {
        return this.routingNameRequired;
    }

    String appName() {
        return this.appName;
    }

    public Optional<Class<? extends Application>> applicationClass() {
        return Optional.ofNullable(this.appClass);
    }

    public static class Builder {
        private Class<? extends Application> appClass;
        private String contextRoot;
        private ResourceConfig config;
        private ExecutorService executorService;
        private String appName;
        private String appClassName;
        private String routingName;
        private boolean routingNameRequired;
        private boolean synthetic = false;

        public Builder contextRoot(String contextRoot) {
            this.contextRoot = Builder.normalize(contextRoot);
            return this;
        }

        public Builder config(ResourceConfig config) {
            this.config = config;
            return this;
        }

        public Builder application(Application app) {
            this.config = Builder.toConfig(app);
            Class<?> clazz = app.getClass();
            this.contextRoot(clazz);
            this.routingName(clazz);
            this.appClass = clazz;
            this.appClassName = clazz.getName();
            this.appNameUpdate(clazz.getSimpleName());
            return this;
        }

        public Builder application(Class<? extends Application> appClass) {
            this.config = ResourceConfig.forApplicationClass(appClass);
            this.contextRoot(appClass);
            this.routingName(appClass);
            this.appClass = appClass;
            this.appClassName = appClass.getName();
            this.appNameUpdate(appClass.getSimpleName());
            return this;
        }

        public Builder appName(String name) {
            this.appName = name;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder routingName(String routingName) {
            this.routingName = routingName.equals("@default") ? null : routingName;
            return this;
        }

        public Builder routingNameRequired(boolean routingNameRequired) {
            this.routingNameRequired = routingNameRequired;
            return this;
        }

        Builder synthetic(boolean synthetic) {
            this.synthetic = synthetic;
            return this;
        }

        public JaxRsApplication build() {
            if (null == this.appName && null != this.appClassName) {
                int lastDot = this.appClassName.lastIndexOf(46);
                this.appName = lastDot > 0 ? this.appClassName.substring(lastDot + 1) : this.appClassName;
            }
            return new JaxRsApplication(this);
        }

        private void appNameUpdate(String newName) {
            if (null == this.appName) {
                this.appName = newName;
            }
        }

        private static ResourceConfig toConfig(Application application) {
            if (application instanceof ResourceConfig) {
                return (ResourceConfig)application;
            }
            return ResourceConfig.forApplication((Application)application);
        }

        private void contextRoot(Class<?> clazz) {
            if (null != this.contextRoot) {
                return;
            }
            ApplicationPath path = clazz.getAnnotation(ApplicationPath.class);
            if (null != path) {
                this.contextRoot = Builder.normalize(path.value());
                return;
            }
            RoutingPath routingPath = clazz.getAnnotation(RoutingPath.class);
            if (null != routingPath) {
                this.contextRoot = routingPath.value();
            }
        }

        private static String normalize(String contextRoot) {
            int length = contextRoot.length();
            return length > 1 && contextRoot.endsWith("/") ? contextRoot.substring(0, length - 1) : contextRoot;
        }

        private void routingName(Class<?> clazz) {
            if (null != this.routingName) {
                return;
            }
            RoutingName rn = clazz.getAnnotation(RoutingName.class);
            if (null != rn) {
                this.routingName = rn.value();
                this.routingNameRequired = rn.required();
            }
        }

        public Builder applicationClass(Class<? extends Application> applicationClass) {
            this.appClass = applicationClass;
            this.appClassName = applicationClass.getName();
            if (applicationClass != Application.class) {
                this.contextRoot(applicationClass);
                this.routingName(applicationClass);
            }
            return this;
        }
    }
}

