/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.FeatureCatalog;
import io.helidon.common.FeatureDescriptor;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.NativeImageHelper;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class HelidonFeatures {
    private static final Logger LOGGER = Logger.getLogger(HelidonFeatures.class.getName());
    private static final Logger EXPERIMENTAL = Logger.getLogger(HelidonFeatures.class.getName() + ".experimental");
    private static final AtomicBoolean PRINTED = new AtomicBoolean();
    private static final AtomicBoolean SCANNED = new AtomicBoolean();
    private static final AtomicReference<HelidonFlavor> CURRENT_FLAVOR = new AtomicReference();
    private static final Map<HelidonFlavor, Set<FeatureDescriptor>> FEATURES = new EnumMap<HelidonFlavor, Set<FeatureDescriptor>>(HelidonFlavor.class);
    private static final Map<HelidonFlavor, Map<String, Node>> ROOT_FEATURE_NODES = new EnumMap<HelidonFlavor, Map<String, Node>>(HelidonFlavor.class);
    private static final List<FeatureDescriptor> ALL_FEATURES = new LinkedList<FeatureDescriptor>();

    private HelidonFeatures() {
    }

    private static void register(FeatureDescriptor featureDescriptor) {
        for (HelidonFlavor flavor : featureDescriptor.flavors()) {
            String[] path = featureDescriptor.path();
            if (path.length == 1) {
                FEATURES.computeIfAbsent(flavor, key -> new TreeSet<FeatureDescriptor>(Comparator.comparing(FeatureDescriptor::name))).add(featureDescriptor);
            }
            Map rootFeatures = ROOT_FEATURE_NODES.computeIfAbsent(flavor, it -> new TreeMap(String.CASE_INSENSITIVE_ORDER));
            Node node = HelidonFeatures.ensureNode(rootFeatures, path);
            node.descriptor(featureDescriptor);
        }
        ALL_FEATURES.add(featureDescriptor);
    }

    static Node ensureNode(Map<String, Node> rootFeatureNodes, String ... path) {
        if (path.length == 1) {
            return rootFeatureNodes.computeIfAbsent(path[0], Node::new);
        }
        Node lastNode = HelidonFeatures.ensureNode(rootFeatureNodes, path[0]);
        for (int i = 1; i < path.length; ++i) {
            String pathElement = path[i];
            lastNode = HelidonFeatures.ensureNode(pathElement, lastNode);
        }
        return lastNode;
    }

    static Node ensureNode(String name, Node parent) {
        return parent.children.computeIfAbsent(name, it -> new Node(name));
    }

    static Map<String, Node> rootFeatureNodes(HelidonFlavor flavor) {
        return ROOT_FEATURE_NODES.computeIfAbsent(flavor, it -> new HashMap());
    }

    public static void print(HelidonFlavor flavor, String version, boolean details) {
        new Thread(() -> HelidonFeatures.features(flavor, version, details), "features-thread").start();
    }

    private static void features(HelidonFlavor flavor, String version, boolean details) {
        CURRENT_FLAVOR.compareAndSet(null, HelidonFlavor.SE);
        HelidonFlavor currentFlavor = CURRENT_FLAVOR.get();
        if (currentFlavor != flavor) {
            return;
        }
        if (!PRINTED.compareAndSet(false, true)) {
            return;
        }
        HelidonFeatures.scan(Thread.currentThread().getContextClassLoader());
        Set<FeatureDescriptor> features = FEATURES.get((Object)currentFlavor);
        if (null == features) {
            LOGGER.info("Helidon " + String.valueOf((Object)currentFlavor) + " " + version + " has no registered features");
        } else {
            String featureString = "[" + features.stream().map(FeatureDescriptor::name).collect(Collectors.joining(", ")) + "]";
            LOGGER.info("Helidon " + String.valueOf((Object)currentFlavor) + " " + version + " features: " + featureString);
        }
        if (details) {
            LOGGER.info("Detailed feature tree:");
            FEATURES.get((Object)currentFlavor).forEach(feature -> HelidonFeatures.printDetails(feature.name(), ROOT_FEATURE_NODES.get((Object)currentFlavor).get(feature.path()[0]), 0));
        } else {
            LinkedList allExperimental = new LinkedList();
            FEATURES.get((Object)currentFlavor).forEach(feature -> HelidonFeatures.gatherExperimental(allExperimental, ROOT_FEATURE_NODES.get((Object)currentFlavor).get(feature.path()[0])));
            if (!allExperimental.isEmpty()) {
                EXPERIMENTAL.info("You are using experimental features. These APIs may change, please follow changelog!");
                allExperimental.forEach(it -> EXPERIMENTAL.info("\tExperimental feature: " + it.name() + " (" + it.stringPath() + ")"));
            }
        }
    }

    private static void gatherExperimental(List<FeatureDescriptor> allExperimental, Node node) {
        if (node.descriptor != null && node.descriptor.experimental()) {
            allExperimental.add(node.descriptor);
        }
        node.children().values().forEach(it -> HelidonFeatures.gatherExperimental(allExperimental, it));
    }

    public static void nativeBuildTime(ClassLoader classLoader) {
        HelidonFeatures.scan(classLoader);
        for (FeatureDescriptor feat : ALL_FEATURES) {
            if (!feat.nativeSupported()) {
                LOGGER.severe("Feature '" + feat.name() + "' for path '" + feat.stringPath() + "' IS NOT SUPPORTED in native image. Image may still build and run.");
                continue;
            }
            if (feat.nativeDescription().isBlank()) continue;
            LOGGER.warning("Feature '" + feat.name() + "' for path '" + feat.stringPath() + "' has limited support in native image: " + feat.nativeDescription());
        }
    }

    private static void scan(ClassLoader classLoader) {
        if (!SCANNED.compareAndSet(false, true)) {
            return;
        }
        HashSet<String> packages = new HashSet<String>();
        ClassLoader current = classLoader;
        while (true) {
            Package[] clPackages;
            for (Package clPackage : clPackages = current.getDefinedPackages()) {
                packages.add(clPackage.getName());
            }
            ClassLoader parent = current.getParent();
            if (parent == null || parent == current) break;
            current = parent;
        }
        for (String packageName : packages) {
            Set<FeatureDescriptor> featureDescriptors = FeatureCatalog.get(packageName);
            if (featureDescriptors == null) {
                if (!packageName.startsWith("io.helidon.")) continue;
                LOGGER.fine("No catalog entry for package " + packageName);
                continue;
            }
            featureDescriptors.forEach(HelidonFeatures::register);
        }
        if (NativeImageHelper.isRuntime()) {
            ALL_FEATURES.sort(Comparator.comparing(FeatureDescriptor::name));
            for (FeatureDescriptor feature : ALL_FEATURES) {
                if (feature.nativeSupported()) {
                    String desc = feature.nativeDescription();
                    if (desc == null || desc.isBlank()) continue;
                    LOGGER.warning("Native image for feature " + feature.name() + "(" + feature.stringPath() + "): " + desc);
                    continue;
                }
                LOGGER.severe("You are using a feature not supported in native image: " + feature.name() + "(" + feature.stringPath() + ")");
            }
        }
    }

    private static void printDetails(String name, Node node, int level) {
        FeatureDescriptor feat = node.descriptor;
        if (feat == null) {
            System.out.println("  ".repeat(level) + name);
        } else {
            String prefix = " ".repeat(level * 2);
            int len = prefix.length() + name.length();
            String suffix = len <= 18 ? " ".repeat(20 - len) : "\t";
            String experimental = feat.experimental() ? "Experimental - " : "";
            Object nativeDesc = "";
            if (!feat.nativeSupported()) {
                nativeDesc = " (NOT SUPPORTED in native image)";
            } else if (!feat.nativeDescription().isBlank()) {
                nativeDesc = " (Native image: " + feat.nativeDescription() + ")";
            }
            System.out.println(prefix + name + suffix + experimental + feat.description() + (String)nativeDesc);
        }
        node.children.forEach((childName, childNode) -> {
            FeatureDescriptor descriptor = childNode.descriptor;
            String actualName = descriptor == null ? childName : descriptor.name();
            HelidonFeatures.printDetails(actualName, childNode, level + 1);
        });
    }

    public static void flavor(HelidonFlavor flavor) {
        CURRENT_FLAVOR.compareAndSet(null, flavor);
    }

    static final class Node {
        private final Map<String, Node> children = new TreeMap<String, Node>(String.CASE_INSENSITIVE_ORDER);
        private final String name;
        private FeatureDescriptor descriptor;

        Node(String name) {
            this.name = name;
        }

        String name() {
            return this.name;
        }

        Map<String, Node> children() {
            return this.children;
        }

        void descriptor(FeatureDescriptor featureDescriptor) {
            this.descriptor = featureDescriptor;
        }
    }
}

