/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.BuiltInsDetector;
import io.helidon.common.media.type.CustomDetector;
import io.helidon.common.media.type.spi.MediaTypeDetector;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public final class MediaTypes {
    private static final Logger LOGGER = Logger.getLogger(MediaTypes.class.getName());
    private static final List<MediaTypeDetector> DETECTORS;
    private static final ConcurrentHashMap<String, Optional<String>> CACHE;

    private MediaTypes() {
    }

    public static Optional<String> detectType(URL url) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(url)).flatMap(Optional::stream).findFirst();
    }

    public static Optional<String> detectType(URI uri) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(uri)).flatMap(Optional::stream).findFirst();
    }

    public static Optional<String> detectType(Path file) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(file)).flatMap(Optional::stream).findFirst();
    }

    public static Optional<String> detectType(String fileName) {
        return DETECTORS.stream().map(mtd -> mtd.detectType(fileName)).flatMap(Optional::stream).findFirst();
    }

    public static Optional<String> detectExtensionType(String fileSuffix) {
        return CACHE.computeIfAbsent(fileSuffix, it -> DETECTORS.stream().map(mtd -> mtd.detectExtensionType(fileSuffix)).flatMap(Optional::stream).findFirst());
    }

    static {
        CACHE = new ConcurrentHashMap();
        DETECTORS = HelidonServiceLoader.builder(ServiceLoader.load(MediaTypeDetector.class)).addService((Object)new BuiltInsDetector(), 100100).addService((Object)new CustomDetector(), 100000).build().asList();
    }
}

