/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.media.type.spi.MediaTypeDetector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class BuiltInsDetector
implements MediaTypeDetector {
    private static final Logger LOGGER = Logger.getLogger(BuiltInsDetector.class.getName());
    private static final Map<String, String> MAPPINGS = new HashMap<String, String>();

    BuiltInsDetector() {
    }

    @Override
    public Optional<String> detectExtensionType(String fileSuffix) {
        return Optional.ofNullable(MAPPINGS.get(fileSuffix));
    }

    static {
        try (InputStream builtIns = MediaTypes.class.getResourceAsStream("default-media-types.properties");){
            if (null != builtIns) {
                Properties properties = new Properties();
                properties.load(builtIns);
                for (String name : properties.stringPropertyNames()) {
                    MAPPINGS.put(name, properties.getProperty(name));
                }
            } else {
                LOGGER.log(Level.SEVERE, "Failed to find default media type mapping resource");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load default media types mapping", e);
        }
    }
}

