/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class UriInfo {
    private final String scheme;
    private final String host;
    private final int port;
    private final String path;
    private final Optional<String> query;

    public UriInfo(String scheme, String host, int port, String path, Optional<String> query) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
    }

    public URI toUri() {
        try {
            return new URI(this.scheme, this.authority(), this.path, this.query.orElse(null), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("UriInfo cannot be used to create a URI: " + String.valueOf(this), e);
        }
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String path() {
        return this.path;
    }

    public Optional<String> query() {
        return this.query;
    }

    public String authority() {
        return this.host + ":" + this.port;
    }

    public String toString() {
        return new StringJoiner(", ", UriInfo.class.getSimpleName() + "[", "]").add("scheme='" + this.scheme + "'").add("host='" + this.host + "'").add("port=" + this.port).add("path='" + this.path + "'").add("query=" + String.valueOf(this.query)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriInfo uriInfo = (UriInfo)o;
        return this.port == uriInfo.port && this.scheme.equals(uriInfo.scheme) && this.host.equals(uriInfo.host) && this.path.equals(uriInfo.path) && this.query.equals(uriInfo.query);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.path, this.query);
    }
}

