/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.http;

import io.helidon.common.http.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;

public class HashParameters
implements Parameters {
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private final ConcurrentMap<String, List<String>> content;

    protected HashParameters() {
        this((Parameters)null);
    }

    protected HashParameters(Map<String, List<String>> initialContent) {
        if (initialContent == null) {
            this.content = new ConcurrentSkipListMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        } else {
            this.content = new ConcurrentSkipListMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, List<String>> entry : initialContent.entrySet()) {
                this.content.compute(entry.getKey(), (key, values) -> {
                    if (values == null) {
                        return Collections.unmodifiableList(new ArrayList((Collection)entry.getValue()));
                    }
                    values.addAll((Collection)entry.getValue());
                    return values;
                });
            }
        }
    }

    protected HashParameters(Parameters initialContent) {
        this(initialContent == null ? null : initialContent.toMap());
    }

    public static HashParameters create() {
        return new HashParameters();
    }

    public static HashParameters create(Map<String, List<String>> initialContent) {
        return new HashParameters(initialContent);
    }

    public static HashParameters create(Parameters initialContent) {
        return new HashParameters(initialContent);
    }

    public static HashParameters concat(Parameters ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return new HashParameters();
        }
        ArrayList<Map<String, List<String>>> prms = new ArrayList<Map<String, List<String>>>(parameters.length);
        for (Parameters p : parameters) {
            if (p == null) continue;
            prms.add(p.toMap());
        }
        return HashParameters.concat(prms);
    }

    public static HashParameters concat(Iterable<Parameters> parameters) {
        ArrayList<Map<String, List<String>>> prms = new ArrayList<Map<String, List<String>>>();
        for (Parameters p : parameters) {
            if (p == null) continue;
            prms.add(p.toMap());
        }
        return HashParameters.concat(prms);
    }

    private static HashParameters concat(List<Map<String, List<String>>> prms) {
        if (prms.isEmpty()) {
            return new HashParameters();
        }
        if (prms.size() == 1) {
            return new HashParameters(prms.get(0));
        }
        HashMap<String, List<String>> composer = new HashMap<String, List<String>>();
        for (Map<String, List<String>> prm : prms) {
            for (Map.Entry<String, List<String>> entry : prm.entrySet()) {
                List strings = composer.computeIfAbsent(entry.getKey(), (? super K k) -> new ArrayList(((List)entry.getValue()).size()));
                strings.addAll((Collection)entry.getValue());
            }
        }
        return new HashParameters(composer);
    }

    private List<String> internalListCopy(String ... values) {
        return Optional.ofNullable(values).map(Arrays::asList).filter(l -> !l.isEmpty()).map(Collections::unmodifiableList).orElse(null);
    }

    private List<String> internalListCopy(Iterable<String> values) {
        ArrayList<String> result;
        if (values == null) {
            return null;
        }
        if (values instanceof Collection) {
            result = new ArrayList((Collection)values);
        } else {
            result = new ArrayList<String>();
            for (String value : values) {
                result.add(value);
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Optional<String> first(String name) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        return this.content.getOrDefault(name, EMPTY_STRING_LIST).stream().findFirst();
    }

    @Override
    public List<String> all(String name) {
        Objects.requireNonNull(name, "Parameter 'name' is null!");
        return this.content.getOrDefault(name, EMPTY_STRING_LIST);
    }

    @Override
    public List<String> put(String key, String ... values) {
        List<String> vs = this.internalListCopy(values);
        List<String> result = vs == null ? (List<String>)this.content.remove(key) : this.content.put(key, vs);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> put(String key, Iterable<String> values) {
        List<String> vs = this.internalListCopy(values);
        List<String> result = vs == null ? (List<String>)this.content.remove(key) : this.content.put(key, vs);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> putIfAbsent(String key, String ... values) {
        List<String> vls = this.internalListCopy(values);
        List<String> result = vls != null ? this.content.putIfAbsent(key, vls) : (List<String>)this.content.get(key);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> putIfAbsent(String key, Iterable<String> values) {
        List<String> vls = this.internalListCopy(values);
        List<String> result = vls != null ? this.content.putIfAbsent(key, vls) : (List<String>)this.content.get(key);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        List result = this.content.computeIfAbsent(key, (? super K k) -> this.internalListCopy((Iterable)values.apply((String)k)));
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        List result = this.content.computeIfAbsent(key, (? super K k) -> {
            String v = (String)value.apply((String)k);
            if (v == null) {
                return null;
            }
            return Collections.singletonList(v);
        });
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public HashParameters putAll(Parameters parameters) {
        if (parameters == null) {
            return this;
        }
        for (Map.Entry<String, List<String>> entry : parameters.toMap().entrySet()) {
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            this.content.put(entry.getKey(), Collections.unmodifiableList(values));
        }
        return this;
    }

    @Override
    public HashParameters add(String key, String ... values) {
        Objects.requireNonNull(key, "Parameter 'key' is null!");
        if (values == null || values.length == 0) {
            return this;
        }
        this.content.compute(key, (s, list) -> {
            if (list == null) {
                return Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(values)));
            }
            ArrayList<String> newValues = new ArrayList<String>(list.size() + values.length);
            newValues.addAll((Collection<String>)list);
            newValues.addAll(Arrays.asList(values));
            return Collections.unmodifiableList(newValues);
        });
        return this;
    }

    @Override
    public HashParameters add(String key, Iterable<String> values) {
        Objects.requireNonNull(key, "Parameter 'key' is null!");
        List<String> vls = this.internalListCopy(values);
        if (vls == null) {
            return this;
        }
        this.content.compute(key, (s, list) -> {
            if (list == null) {
                return Collections.unmodifiableList(vls);
            }
            ArrayList newValues = new ArrayList(list.size() + vls.size());
            newValues.addAll(list);
            newValues.addAll(vls);
            return Collections.unmodifiableList(newValues);
        });
        return this;
    }

    @Override
    public HashParameters addAll(Parameters parameters) {
        if (parameters == null) {
            return this;
        }
        Map<String, List<String>> map = parameters.toMap();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public List<String> remove(String key) {
        List result = (List)this.content.remove(key);
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public Map<String, List<String>> toMap() {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry entry : this.content.entrySet()) {
            result.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }

    public String toString() {
        return this.content.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashParameters)) {
            return false;
        }
        HashParameters that = (HashParameters)o;
        return this.content.equals(that.content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }
}

